/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BshArray;
import bsh.BshClassManager;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.Invocable;
import bsh.Modifiers;
import bsh.NameSpace;
import bsh.ParserConstants;
import bsh.Reflect;
import bsh.ReflectError;
import bsh.Types;
import bsh.UtilEvalError;
import bsh.UtilTargetError;
import bsh.Variable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

class LHS
implements ParserConstants,
Serializable {
    private static final long serialVersionUID = 1L;
    NameSpace nameSpace;
    boolean localVar;
    static final int VARIABLE = 0;
    static final int FIELD = 1;
    static final int PROPERTY = 2;
    static final int INDEX = 3;
    static final int METHOD_EVAL = 4;
    static final int LOOSETYPE_FIELD = 5;
    static final int MAP_ENTRY = 6;
    int type;
    String varName;
    Object propName;
    Invocable field;
    Object object;
    int index;
    Variable var;

    LHS(NameSpace nameSpace, String varName, boolean localVar) {
        this.type = 0;
        this.localVar = localVar;
        this.varName = varName;
        this.nameSpace = nameSpace;
    }

    LHS(NameSpace nameSpace, String varName) {
        this.type = 5;
        this.varName = varName;
        this.nameSpace = nameSpace;
    }

    LHS(Invocable field) {
        this.type = 1;
        this.object = null;
        this.field = field;
    }

    LHS(Object object, Invocable field) {
        if (object == null) {
            throw new NullPointerException("constructed empty LHS");
        }
        this.type = 1;
        this.object = object;
        this.field = field;
    }

    LHS(Object object, Object propName) {
        if (object == null) {
            throw new NullPointerException("constructed empty LHS");
        }
        this.type = 2;
        this.object = object;
        this.propName = propName;
    }

    LHS(Object key) {
        this.type = 6;
        this.object = key;
    }

    LHS(Object array, int index) {
        this.type = 3;
        this.object = array;
        this.index = index;
    }

    public Object getValue() throws UtilEvalError {
        if (this.type == 0) {
            return this.nameSpace.getVariableOrProperty(this.varName, null);
        }
        if (this.type == 1) {
            try {
                return Objects.requireNonNull(this.field).invoke(this.object, new Object[0]);
            }
            catch (ReflectiveOperationException e2) {
                throw new UtilEvalError("Can't read field: " + this.field, e2);
            }
        }
        if (this.type == 2) {
            try {
                return Reflect.getObjectProperty(this.object, this.propName);
            }
            catch (ReflectError e) {
                Interpreter.debug(e.getMessage());
                throw new UtilEvalError("No such property: " + this.propName, e);
            }
        }
        if (this.type == 3) {
            try {
                return BshArray.getIndex(this.object, this.index);
            }
            catch (Exception e) {
                throw new UtilEvalError("Array access: " + e, e);
            }
        }
        if (this.type == 5) {
            return this.nameSpace.getVariable(this.varName);
        }
        throw new InterpreterError("LHS type");
    }

    public String getName() {
        if (null != this.field) {
            return this.field.getName();
        }
        if (null != this.var) {
            return this.var.getName();
        }
        return this.varName;
    }

    public Class<?> getType() {
        if (null != this.field) {
            return this.field.getReturnType();
        }
        if (null != this.getVariable()) {
            return this.var.getType();
        }
        try {
            return Types.getType(this.getValue());
        }
        catch (UtilEvalError e) {
            return null;
        }
    }

    public boolean isStatic() {
        if (null != this.field) {
            return this.field.isStatic();
        }
        if (null == this.var) {
            return false;
        }
        return this.var.hasModifier("static");
    }

    public boolean isFinal() {
        if (this.getVariable() == null) {
            return false;
        }
        return this.var.hasModifier("final");
    }

    public Variable getVariable() {
        if (null != this.var) {
            return this.var;
        }
        if (null != this.nameSpace) {
            this.var = Reflect.getVariable(this.nameSpace, this.getName());
        } else if (this.isStatic()) {
            this.var = Reflect.isGeneratedClass(this.field.getDeclaringClass()) ? Reflect.getVariable(this.field.getDeclaringClass(), this.getName()) : new Variable(this.field.getName(), this.field.getReturnType(), this);
        } else if (Reflect.isGeneratedClass(this.object.getClass())) {
            this.var = Reflect.getVariable(this.object, this.getName());
        } else if (null != this.field) {
            this.var = new Variable(this.field.getName(), this.field.getReturnType(), this);
        }
        return this.var;
    }

    public Object assign(Object val) throws UtilEvalError {
        return this.assign(val, false);
    }

    public Object assign(Object val, boolean strictJava) throws UtilEvalError {
        if (this.type == 0) {
            if (this.localVar) {
                this.nameSpace.setLocalVariableOrProperty(this.varName, val, strictJava);
            } else {
                this.nameSpace.setVariableOrProperty(this.varName, val, strictJava);
            }
        } else {
            if (this.type == 1) {
                try {
                    Objects.requireNonNull(this.field).invoke(this.object, val);
                    return val;
                }
                catch (NullPointerException e) {
                    throw new UtilEvalError("LHS (" + this.field.getName() + ") not a static field.", e);
                }
                catch (ReflectiveOperationException e2) {
                    throw new UtilEvalError("LHS (" + this.field.getName() + ") can't access field: " + e2, e2);
                }
                catch (IllegalArgumentException e3) {
                    String type = val == null ? "null" : Types.getType(val).getSimpleName();
                    throw new UtilEvalError("Argument type mismatch. " + type + " not assignable to field " + this.field.getName(), e3);
                }
            }
            if (this.type == 2) {
                try {
                    if (this.propName instanceof String) {
                        return Reflect.setObjectProperty(this.object, (String)this.propName, val);
                    }
                    return Reflect.setObjectProperty(this.object, this.propName, val);
                }
                catch (ReflectError e) {
                    Interpreter.debug("Assignment: " + e.getMessage());
                    throw new UtilEvalError("No such property: " + this.propName, e);
                }
            }
            if (this.type == 3) {
                try {
                    if (this.object.getClass().isArray() && val != null) {
                        try {
                            val = Types.castObject(val, Types.arrayElementType(this.object.getClass()), 1);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    BshArray.setIndex(this.object, this.index, val);
                }
                catch (UtilTargetError e1) {
                    if (IndexOutOfBoundsException.class.isAssignableFrom(e1.getCause().getClass())) {
                        throw new UtilEvalError("Error array set index: " + e1.getMessage(), e1);
                    }
                    throw e1;
                }
                catch (Exception e) {
                    throw new UtilEvalError("Assignment: " + e.getMessage(), e);
                }
            }
            if (this.type == 5) {
                Modifiers mods = new Modifiers(2);
                mods.addModifier("public");
                if (this.nameSpace.isInterface) {
                    mods.setConstant();
                }
                this.nameSpace.setTypedVariable(this.varName, Types.getType(val), val, mods);
                return val;
            }
            if (this.type == 6) {
                if (this.object instanceof Map.Entry) {
                    return ((Map.Entry)this.object).setValue(val);
                }
                return new Types.MapEntry(this.object, val);
            }
            throw new InterpreterError("unknown lhs type");
        }
        return val;
    }

    public String toString() {
        return "LHS: " + (this.field != null ? "field = " + this.field.toString() : "") + (this.varName != null ? " varName = " + this.varName : "") + (this.nameSpace != null ? " nameSpace = " + this.nameSpace.toString() : "");
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        if (null != this.field) {
            this.object = this.field.getDeclaringClass();
            this.varName = this.field.getName();
            this.field = null;
        }
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (null == this.object) {
            return;
        }
        Class cls = this.object.getClass();
        if (this.object instanceof Class) {
            cls = (Class)this.object;
        }
        this.field = BshClassManager.memberCache.get(cls).findField(this.varName);
    }
}

