/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Modifiers
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int CLASS = 0;
    public static final int METHOD = 1;
    public static final int FIELD = 2;
    private final int context;
    private final List<String> modifiers = new ArrayList<String>();

    public Modifiers(int context) {
        this.context = context;
    }

    public void addModifier(String name) {
        if (this.modifiers.contains(name)) {
            throw new IllegalStateException("Duplicate modifier: " + name);
        }
        if (name.equals("public") || name.equals("protected") || name.equals("private")) {
            this.modifiers.add(0, name);
        } else {
            this.modifiers.add(name);
        }
        int count = 0;
        if (this.hasModifier("private")) {
            ++count;
        }
        if (this.hasModifier("protected")) {
            ++count;
        }
        if (this.hasModifier("public")) {
            ++count;
        }
        if (count > 1) {
            throw new IllegalStateException("public/private/protected cannot be used in combination.");
        }
        switch (this.context) {
            case 0: {
                this.validateForClass();
                break;
            }
            case 1: {
                this.validateForMethod();
                break;
            }
            case 2: {
                this.validateForField();
            }
        }
    }

    public boolean hasModifier(String name) {
        return this.modifiers.contains(name);
    }

    private void validateForMethod() {
        this.insureNo("volatile", "Method");
        this.insureNo("transient", "Method");
    }

    private void validateForField() {
        this.insureNo("synchronized", "Variable");
        this.insureNo("native", "Variable");
        this.insureNo("abstract", "Variable");
    }

    private void validateForClass() {
        this.validateForMethod();
        this.insureNo("native", "Class");
        this.insureNo("synchronized", "Class");
    }

    private void insureNo(String modifier, String context) {
        if (this.hasModifier(modifier)) {
            throw new IllegalStateException(context + " cannot be declared '" + modifier + "'");
        }
    }

    public void setConstant() {
        this.modifiers.clear();
        this.addModifier("public");
        this.addModifier("static");
        this.addModifier("final");
    }

    public String toString() {
        return "Modifiers: " + String.join((CharSequence)" ", this.modifiers);
    }
}

