/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BshClassManager;
import bsh.BshMethod;
import bsh.CallStack;
import bsh.ClassIdentifier;
import bsh.EvalError;
import bsh.FileReader;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.Invocable;
import bsh.LHS;
import bsh.Modifiers;
import bsh.Name;
import bsh.NameSource;
import bsh.Node;
import bsh.Primitive;
import bsh.Reflect;
import bsh.This;
import bsh.UtilEvalError;
import bsh.Variable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NameSpace
implements Serializable,
BshClassManager.Listener,
NameSource,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final NameSpace JAVACODE = new NameSpace(null, null, "Called from compiled Java code.");
    private String nsName;
    private NameSpace parent;
    private Map<String, Variable> variables = new HashMap<String, Variable>();
    private Map<String, List<BshMethod>> methods = new HashMap<String, List<BshMethod>>();
    protected Map<String, String> importedClasses = new HashMap<String, String>();
    private List<String> importedPackages = new ArrayList<String>();
    private List<String> importedCommands = new ArrayList<String>();
    private List<Object> importedObjects = new ArrayList<Object>();
    private List<Class<?>> importedStatic = new ArrayList();
    private List<NameSource.Listener> nameSourceListeners = new ArrayList<NameSource.Listener>();
    private String packageName;
    private transient BshClassManager classManager;
    private This thisReference;
    private Map<String, Name> names = new HashMap<String, Name>();
    Node callerInfoNode;
    boolean isMethod;
    boolean isClass;
    boolean isInterface;
    boolean isEnum;
    Class<?> classStatic;
    Object classInstance;
    private transient Map<String, Class<?>> classCache = new HashMap();

    void setClassStatic(Class<?> clas) {
        this.classStatic = clas;
        this.importStatic(clas);
    }

    void setClassInstance(Object instance) {
        this.classInstance = instance;
        this.importObject(instance);
    }

    Object getClassInstance() throws UtilEvalError {
        if (this.classInstance != null) {
            return this.classInstance;
        }
        if (this.classStatic != null) {
            throw new UtilEvalError("Can't refer to class instance from static context.");
        }
        throw new InterpreterError("Can't resolve class instance 'this' in: " + this);
    }

    public NameSpace(NameSpace parent, String name) {
        this(parent, null, name);
    }

    public NameSpace(String name) {
        this(null, null, name);
    }

    public NameSpace(String name, BshClassManager classManager) {
        this(null, classManager, name);
    }

    public NameSpace(NameSpace parent, BshClassManager classManager, String name) {
        this.setName(name);
        this.setParent(parent);
        this.setClassManager(classManager);
        this.getClassManager().addListener(this);
    }

    public void setName(String name) {
        this.nsName = name;
    }

    public String getName() {
        return this.nsName;
    }

    void setNode(Node node) {
        this.callerInfoNode = node;
    }

    Node getNode() {
        if (this.callerInfoNode != null) {
            return this.callerInfoNode;
        }
        if (this.parent != null) {
            return this.parent.getNode();
        }
        return null;
    }

    public Object get(String name, Interpreter interpreter) throws UtilEvalError {
        CallStack callstack = new CallStack(this);
        return this.getNameResolver(name).toObject(callstack, interpreter);
    }

    public void setVariable(String name, Object value, boolean strictJava) throws UtilEvalError {
        this.setVariable(name, value, strictJava, true);
    }

    public Variable setLocalVariable(String name, Object value, boolean strictJava) throws UtilEvalError {
        return this.setVariable(name, value, strictJava, false);
    }

    Variable setVariable(String name, Object value, boolean strictJava, boolean recurse) throws UtilEvalError {
        Variable existing;
        if (value == null) {
            value = Primitive.NULL;
        }
        if ((existing = this.getVariableImpl(name, recurse)) != null) {
            existing.setValue(value, 1);
            return existing;
        }
        if (strictJava) {
            throw new UtilEvalError("(Strict Java mode) Assignment to undeclared variable: " + name);
        }
        Variable var = this.createVariable(name, value, null);
        this.variables.put(name, var);
        this.nameSpaceChanged();
        return var;
    }

    public void setVariableOrProperty(String name, Object value, boolean strictJava) throws UtilEvalError {
        this.setVariableOrProperty(name, value, strictJava, true);
    }

    void setLocalVariableOrProperty(String name, Object value, boolean strictJava) throws UtilEvalError {
        this.setVariableOrProperty(name, value, strictJava, false);
    }

    void setVariableOrProperty(String name, Object value, boolean strictJava, boolean recurse) throws UtilEvalError {
        if (value == null) {
            throw new InterpreterError("null variable value");
        }
        Variable existing = this.getVariableImpl(name, recurse);
        if (existing != null) {
            try {
                existing.setValue(value, 1);
            }
            catch (UtilEvalError e) {
                throw new UtilEvalError("Variable assignment: " + name + ": " + e.getMessage(), e);
            }
        } else {
            if (strictJava) {
                throw new UtilEvalError("(Strict Java mode) Assignment to undeclared variable: " + name);
            }
            boolean setProp = this.attemptSetPropertyValue(name, value, null);
            if (setProp) {
                return;
            }
            NameSpace varScope = this;
            varScope.variables.put(name, this.createVariable(name, value, null));
            this.nameSpaceChanged();
        }
    }

    protected Variable createVariable(String name, Object value, Modifiers mods) throws UtilEvalError {
        return this.createVariable(name, null, value, mods);
    }

    protected Variable createVariable(String name, Class<?> type, Object value, Modifiers mods) throws UtilEvalError {
        return new Variable(name, type, value, mods);
    }

    protected Variable createVariable(String name, Class<?> type, LHS lhs) throws UtilEvalError {
        return new Variable(name, type, lhs);
    }

    public void unsetVariable(String name) {
        this.variables.remove(name);
        this.nameSpaceChanged();
    }

    public String[] getVariableNames() {
        return (String[])this.variables.keySet().stream().toArray(String[]::new);
    }

    public String[] getMethodNames() {
        return (String[])this.methods.keySet().stream().toArray(String[]::new);
    }

    public BshMethod[] getMethods() {
        return (BshMethod[])this.methods.values().stream().flatMap(v -> v.stream()).toArray(BshMethod[]::new);
    }

    public NameSpace getParent() {
        return this.parent;
    }

    public boolean isChildOf(NameSpace parent) {
        return null != this.getParent() && (this.getParent().equals(parent) || this.getParent().isChildOf(parent));
    }

    public This getSuper(Interpreter declaringInterpreter) {
        if (this.parent != null) {
            return this.parent.getThis(declaringInterpreter);
        }
        return this.getThis(declaringInterpreter);
    }

    public This getGlobal(Interpreter declaringInterpreter) {
        if (this.parent != null) {
            return this.parent.getGlobal(declaringInterpreter);
        }
        return this.getThis(declaringInterpreter);
    }

    public This getThis(Interpreter declaringInterpreter) {
        if (this.thisReference == null) {
            this.thisReference = This.getThis(this, declaringInterpreter);
        }
        return this.thisReference;
    }

    public BshClassManager getClassManager() {
        if (this.classManager != null) {
            return this.classManager;
        }
        if (this.parent != null && this.parent != JAVACODE) {
            return this.parent.getClassManager();
        }
        this.setClassManager(BshClassManager.createClassManager(null));
        return this.classManager;
    }

    void setClassManager(BshClassManager classManager) {
        this.classManager = classManager;
    }

    public void prune() {
        this.getClassManager();
        this.setParent(null);
    }

    public void setParent(NameSpace parent) {
        this.parent = parent;
        if (parent == null) {
            this.loadDefaultImports();
        }
    }

    public Object getVariableOrProperty(String name, Interpreter interp) throws UtilEvalError {
        Object val = this.getVariable(name, true);
        return val == Primitive.VOID ? this.getPropertyValue(name, interp) : val;
    }

    public Object getVariable(String name) throws UtilEvalError {
        return this.getVariable(name, true);
    }

    public Object getVariable(String name, boolean recurse) throws UtilEvalError {
        Variable var = this.getVariableImpl(name, recurse);
        return this.unwrapVariable(var);
    }

    protected Variable getVariableImpl(String name, boolean recurse) throws UtilEvalError {
        Variable var = null;
        if (this.variables.containsKey(name)) {
            return this.variables.get(name);
        }
        var = this.getImportedVar(name);
        if (recurse && var == null && this.parent != null) {
            var = this.parent.getVariableImpl(name, recurse);
        }
        return var;
    }

    protected void setVariableImpl(Variable var) {
        if (!this.variables.containsKey(var.getName())) {
            this.variables.put(var.getName(), var);
        }
    }

    public Variable[] getDeclaredVariables() {
        return (Variable[])this.variables.values().stream().toArray(Variable[]::new);
    }

    protected Object unwrapVariable(Variable var) throws UtilEvalError {
        return var == null ? Primitive.VOID : var.getValue();
    }

    @Deprecated
    public void setTypedVariable(String name, Class<?> type, Object value, boolean isFinal) throws UtilEvalError {
        Modifiers modifiers = new Modifiers(2);
        if (isFinal) {
            modifiers.addModifier("final");
        }
        this.setTypedVariable(name, type, value, modifiers);
    }

    public void setTypedVariable(String name, Class<?> type, Object value, Modifiers modifiers) throws UtilEvalError {
        Variable existing = this.getVariableImpl(name, false);
        if (existing != null && existing.getType() != null) {
            if (existing.getType() != type) {
                throw new UtilEvalError("Typed variable: " + name + " was previously declared with type: " + existing.getType());
            }
            if (existing.modifiers == null) {
                existing.modifiers = modifiers;
            }
            existing.setValue(value, 0);
            return;
        }
        this.variables.put(name, this.createVariable(name, type, value, modifiers));
    }

    public void setMethod(BshMethod method) {
        String name = method.getName();
        if (!this.methods.containsKey(name)) {
            this.methods.put(name, new ArrayList(1));
        }
        this.methods.get(name).remove(method);
        this.methods.get(name).add(0, method);
    }

    public BshMethod getMethod(String name, Class<?>[] sig) throws UtilEvalError {
        return this.getMethod(name, sig, false);
    }

    public BshMethod getMethod(String name, Class<?>[] sig, boolean declaredOnly) throws UtilEvalError {
        BshMethod method = null;
        if (this.isClass && !this.isEnum && !declaredOnly) {
            method = this.getImportedMethod(name, sig);
        }
        if (method == null && this.methods.containsKey(name)) {
            method = Reflect.findMostSpecificBshMethod(sig, this.methods.get(name));
        }
        if (method == null && !this.isClass && !declaredOnly) {
            method = this.getImportedMethod(name, sig);
        }
        if (method == null && !declaredOnly && this.parent != null) {
            return this.parent.getMethod(name, sig);
        }
        return method;
    }

    public void importClass(String name) {
        this.importedClasses.put(Name.suffix(name, 1), name);
        this.nameSpaceChanged();
    }

    public void importPackage(String name) {
        this.importedPackages.remove(name);
        this.importedPackages.add(0, name);
        this.nameSpaceChanged();
    }

    public void importCommands(String name) {
        if (!(name = name.replace('.', '/')).startsWith("/")) {
            name = "/" + name;
        }
        if (name.length() > 1 && name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        this.importedCommands.remove(name);
        this.importedCommands.add(0, name);
        this.nameSpaceChanged();
    }

    public Object getCommand(String name, Class<?>[] argTypes, Interpreter interpreter) throws UtilEvalError {
        Interpreter.debug("getCommand: ", name);
        BshClassManager bcm = interpreter.getClassManager();
        for (String path : this.importedCommands) {
            String scriptPath = path.equals("/") ? path + name + ".bsh" : path + "/" + name + ".bsh";
            Interpreter.debug("searching for script: " + scriptPath);
            URL url = bcm.getResource(scriptPath);
            if (null != url) {
                try {
                    return this.loadScriptedCommand((InputStream)url.getContent(), name, argTypes, scriptPath, interpreter);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            String className = path.equals("/") ? name : path.substring(1).replace('/', '.') + "." + name;
            Interpreter.debug("searching for class: " + className);
            Class<?> clas = bcm.classForName(className);
            if (clas == null) continue;
            return clas;
        }
        if (this.parent != null) {
            return this.parent.getCommand(name, argTypes, interpreter);
        }
        return null;
    }

    protected BshMethod getImportedMethod(String name, Class<?>[] sig) throws UtilEvalError {
        Invocable method;
        for (Object object : this.importedObjects) {
            method = Reflect.resolveJavaMethod(object.getClass(), name, sig, false);
            if (method == null) continue;
            return new BshMethod(method, object);
        }
        for (Class clazz : this.importedStatic) {
            method = Reflect.resolveJavaMethod(clazz, name, sig, true);
            if (method == null) continue;
            return new BshMethod(method, null);
        }
        return null;
    }

    protected Variable getImportedVar(String name) throws UtilEvalError {
        Invocable field;
        Variable var = null;
        for (Object object : this.importedObjects) {
            field = Reflect.resolveJavaField(object.getClass(), name, false);
            if (field != null) {
                var = this.createVariable(name, field.getReturnType(), new LHS(object, field));
            } else if (this.isClass) {
                This ths;
                Class<?> supr = object.getClass();
                while (Reflect.isGeneratedClass(supr = supr.getSuperclass()) && (null == (ths = Reflect.getClassInstanceThis(object, supr.getSimpleName())) || null == (var = ths.getNameSpace().variables.get(name)))) {
                }
            }
            if (null == var) continue;
            this.variables.put(name, var);
            return var;
        }
        for (Class clazz : this.importedStatic) {
            field = Reflect.resolveJavaField(clazz, name, true);
            if (field == null) continue;
            var = this.createVariable(name, field.getReturnType(), new LHS(field));
            this.variables.put(name, var);
            return var;
        }
        return null;
    }

    private BshMethod loadScriptedCommand(InputStream in, String name, Class<?>[] argTypes, String resourcePath, Interpreter interpreter) throws UtilEvalError {
        try (FileReader reader = new FileReader(in);){
            interpreter.eval(reader, this, resourcePath);
        }
        catch (EvalError | IOException e) {
            Interpreter.debug(e.toString());
            throw new UtilEvalError("Error loading script: " + e.getMessage(), e);
        }
        BshMethod meth = this.getMethod(name, argTypes);
        return meth;
    }

    void cacheClass(String name, Class<?> c) {
        this.classCache.put(name, c);
    }

    public Class<?> getClass(String name) throws UtilEvalError {
        Class<?> c = this.getClassImpl(name);
        if (c != null) {
            return c;
        }
        if (this.parent != null) {
            return this.parent.getClass(name);
        }
        return null;
    }

    private Class<?> getClassImpl(String name) throws UtilEvalError {
        boolean unqualifiedName;
        Class<?> c = null;
        if (this.classCache.containsKey(name)) {
            return this.classCache.get(name);
        }
        boolean bl = unqualifiedName = !Name.isCompound(name);
        if (unqualifiedName) {
            c = this.getImportedClassImpl(name);
            if (c == null) {
                c = this.classForName(name);
            }
            if (c != null) {
                this.cacheClass(name, c);
                return c;
            }
        }
        if ((c = this.classForName(name)) != null) {
            return c;
        }
        Interpreter.debug("getClass(): ", name, " not found in ", this);
        return null;
    }

    private Class<?> getImportedClassImpl(String name) throws UtilEvalError {
        String s2;
        String fullname = this.importedClasses.get(name);
        if (fullname != null) {
            Class clas = this.classForName(fullname);
            if (clas != null) {
                return clas;
            }
            if (Name.isCompound(fullname)) {
                try {
                    clas = this.getNameResolver(fullname).toClass();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            Interpreter.debug("imported unpackaged name not found:", fullname);
            if (clas != null) {
                this.getClassManager().cacheClassInfo(fullname, clas);
                return clas;
            }
            return null;
        }
        for (String s2 : this.importedPackages) {
            Class<?> c = this.classForName(s2 + "." + name);
            if (c == null) continue;
            return c;
        }
        BshClassManager bcm = this.getClassManager();
        if (bcm.hasSuperImport() && (s2 = bcm.getClassNameByUnqName(name)) != null) {
            return this.classForName(s2);
        }
        return null;
    }

    private Class<?> classForName(String name) {
        return this.getClassManager().classForName(name);
    }

    @Override
    public String[] getAllNames() {
        ArrayList<String> vec = new ArrayList<String>();
        this.getAllNamesAux(vec);
        return vec.toArray(new String[vec.size()]);
    }

    protected void getAllNamesAux(List<String> vec) {
        vec.addAll(this.variables.keySet());
        if (this.methods != null) {
            vec.addAll(this.methods.keySet());
        }
        if (this.parent != null) {
            this.parent.getAllNamesAux(vec);
        }
    }

    @Override
    public void addNameSourceListener(NameSource.Listener listener) {
        this.nameSourceListeners.add(listener);
    }

    public void doSuperImport() throws UtilEvalError {
        this.getClassManager().doSuperImport();
    }

    public String toString() {
        return "NameSpace: " + (this.nsName == null ? super.toString() : this.nsName + " (" + super.toString() + ")") + (this.isClass ? " (class) " : "") + (this.isInterface ? " (interface) " : "") + (this.isEnum ? " (enum) " : "") + (this.isMethod ? " (method) " : "") + (this.classStatic != null ? " (class static) " : "") + (this.classInstance != null ? " (class instance) " : "");
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        this.names.clear();
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.classCache = new HashMap();
    }

    public Object invokeMethod(String methodName, Object[] args, Interpreter interpreter) throws EvalError {
        return this.invokeMethod(methodName, args, interpreter, null, null);
    }

    public Object invokeMethod(String methodName, Object[] args, Interpreter interpreter, CallStack callstack, Node callerInfo) throws EvalError {
        return this.getThis(interpreter).invokeMethod(methodName, args, interpreter, callstack, callerInfo, false);
    }

    @Override
    public void classLoaderChanged() {
        this.nameSpaceChanged();
    }

    public void nameSpaceChanged() {
        this.classCache.clear();
        this.names.clear();
    }

    public void loadDefaultImports() {
        this.importClass("bsh.EvalError");
        this.importClass("bsh.Interpreter");
        this.importClass("bsh.Capabilities");
        this.importPackage("java.net");
        this.importClass("java.util.Map.Entry");
        this.importPackage("java.util.function");
        this.importPackage("java.util.stream");
        this.importPackage("java.util.regex");
        this.importPackage("java.util");
        this.importPackage("java.io");
        this.importPackage("java.lang");
        this.importClass("bsh.FileReader");
        this.importClass("java.math.BigInteger");
        this.importClass("java.math.BigDecimal");
        this.importCommands("/bsh/commands");
    }

    Name getNameResolver(String ambigname) {
        if (!this.names.containsKey(ambigname)) {
            this.names.put(ambigname, new Name(this, ambigname));
        }
        return this.names.get(ambigname);
    }

    public int getInvocationLine() {
        Node node = this.getNode();
        if (node != null) {
            return node.getLineNumber();
        }
        return -1;
    }

    public String getInvocationText() {
        Node node = this.getNode();
        if (node != null) {
            return node.getText();
        }
        return "<invoked from Java code>";
    }

    public static Class<?> identifierToClass(ClassIdentifier ci) {
        return ci.getTargetClass();
    }

    public void clear() {
        this.variables.clear();
        this.methods.clear();
        this.importedClasses.clear();
        this.importedPackages.clear();
        this.importedCommands.clear();
        this.importedObjects.clear();
        if (this.parent == null) {
            this.loadDefaultImports();
        }
        this.classCache.clear();
        this.names.clear();
    }

    public void importObject(Object obj) {
        this.importedObjects.remove(obj);
        this.importedObjects.add(0, obj);
        this.nameSpaceChanged();
    }

    public void importStatic(Class<?> clas) {
        this.importedStatic.remove(clas);
        this.importedStatic.add(0, clas);
        this.nameSpaceChanged();
    }

    void setPackage(String packageName) {
        this.packageName = packageName;
    }

    String getPackage() {
        if (this.packageName != null) {
            return this.packageName;
        }
        if (this.parent != null) {
            return this.parent.getPackage();
        }
        return null;
    }

    boolean attemptSetPropertyValue(String propName, Object value, Interpreter interp) throws UtilEvalError {
        String accessorName = Reflect.accessorName("set", propName);
        Object val = Primitive.unwrap(value);
        Class[] classArray = new Class[]{val == null ? null : val.getClass()};
        BshMethod m = this.getMethod(accessorName, classArray);
        if (m != null) {
            try {
                this.invokeMethod(accessorName, new Object[]{value}, interp);
                return true;
            }
            catch (EvalError ee) {
                throw new UtilEvalError("'This' property accessor threw exception: " + ee.getMessage(), ee);
            }
        }
        return false;
    }

    Object getPropertyValue(String propName, Interpreter interp) throws UtilEvalError {
        String accessorName = Reflect.accessorName("get", propName);
        Class<?>[] classArray = Reflect.ZERO_TYPES;
        BshMethod m = this.getMethod(accessorName, classArray);
        try {
            if (m != null) {
                return m.invoke(null, interp);
            }
            accessorName = Reflect.accessorName("is", propName);
            m = this.getMethod(accessorName, classArray);
            if (m != null && m.getReturnType() == Boolean.TYPE) {
                return m.invoke(null, interp);
            }
            return Primitive.VOID;
        }
        catch (EvalError ee) {
            throw new UtilEvalError("'This' property accessor threw exception: " + ee.getMessage(), ee);
        }
    }

    NameSpace copy() {
        try {
            NameSpace clone = (NameSpace)this.clone();
            clone.thisReference = null;
            clone.variables = this.clone(this.variables);
            clone.methods = this.clone(this.methods);
            clone.importedClasses = this.clone(this.importedClasses);
            clone.importedPackages = this.clone(this.importedPackages);
            clone.importedCommands = this.clone(this.importedCommands);
            clone.importedObjects = this.clone(this.importedObjects);
            clone.importedStatic = this.clone(this.importedStatic);
            clone.names = this.clone(this.names);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    private <K, V> Map<K, V> clone(Map<K, V> map) {
        if (map == null) {
            return null;
        }
        return new HashMap<K, V>(map);
    }

    private <T> List<T> clone(List<T> list) {
        if (list == null) {
            return null;
        }
        return new ArrayList<T>(list);
    }

    static {
        NameSpace.JAVACODE.isMethod = true;
    }
}

