/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BshArray;
import bsh.InterpreterError;
import bsh.ParserConstants;
import bsh.Primitive;
import bsh.Types;
import bsh.UtilEvalError;
import bsh.UtilTargetError;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;

class Operators
implements ParserConstants {
    private static final List<Integer> OVERFLOW_OPS = Arrays.asList(104, 105, 106, 116);
    private static final List<Integer> COMPARABLE_OPS = Arrays.asList(88, 89, 86, 87, 92, 93, 94, 95, 96, 97);

    private Operators() {
    }

    public static Object arbitraryObjectsBinaryOperation(Object lhs, Object rhs, int kind) throws UtilEvalError {
        if (kind == 92) {
            return lhs == rhs ? Primitive.TRUE : Primitive.FALSE;
        }
        if (kind == 97) {
            return lhs != rhs ? Primitive.TRUE : Primitive.FALSE;
        }
        if (lhs == Primitive.VOID || rhs == Primitive.VOID) {
            throw new UtilEvalError("illegal use of undefined variable, class, or 'void' literal");
        }
        if (kind == 104) {
            if (lhs instanceof String || rhs instanceof String) {
                return String.valueOf(lhs) + String.valueOf(rhs);
            }
            if (lhs.getClass().isArray() && rhs instanceof List) {
                rhs = ((List)rhs).toArray();
            }
            if (lhs.getClass().isArray() && rhs.getClass().isArray()) {
                return BshArray.concat(lhs, rhs);
            }
            if (lhs instanceof List && rhs.getClass().isArray()) {
                rhs = Types.castObject(rhs, List.class, 0);
            }
            if (lhs instanceof List && rhs instanceof List) {
                return BshArray.concat((List)lhs, (List)rhs);
            }
        }
        if (kind == 106) {
            if (lhs.getClass().isArray()) {
                return BshArray.repeat(lhs, (int)((Integer)Primitive.unwrap(rhs)));
            }
            if (rhs.getClass().isArray()) {
                return BshArray.repeat(rhs, (int)((Integer)Primitive.unwrap(lhs)));
            }
            if (lhs instanceof List) {
                return BshArray.repeat((List)lhs, (int)((Integer)Primitive.unwrap(rhs)));
            }
            if (rhs instanceof List) {
                return BshArray.repeat((List)rhs, (int)((Integer)Primitive.unwrap(lhs)));
            }
        }
        if (lhs instanceof String || rhs instanceof String) {
            throw new UtilEvalError("Use of non + operator with String");
        }
        if (lhs.getClass().isArray() || rhs.getClass().isArray() || lhs instanceof List || rhs instanceof List) {
            throw new UtilEvalError("Use of invalid operator " + tokenImage[kind] + " with array or List type");
        }
        if (lhs == Primitive.NULL || rhs == Primitive.NULL) {
            throw new UtilEvalError("illegal use of null value or 'null' literal");
        }
        throw new UtilEvalError("Operator: " + tokenImage[kind] + " inappropriate for objects");
    }

    public static Object binaryOperation(Object obj1, Object obj2, int kind) throws UtilEvalError {
        Object result;
        Object lhs = Primitive.unwrap(obj1);
        Object rhs = Primitive.unwrap(obj2);
        if (Types.isNumeric(lhs) && Types.isNumeric(rhs)) {
            Object[] operands = Operators.promotePrimitives(lhs, rhs);
            lhs = operands[0];
            rhs = operands[1];
        }
        if (lhs.getClass() != rhs.getClass()) {
            throw new UtilEvalError("Type mismatch in operator.  " + lhs.getClass() + " cannot be used with " + rhs.getClass());
        }
        try {
            result = Operators.binaryOperationImpl(lhs, rhs, kind);
        }
        catch (ArithmeticException e) {
            throw new UtilTargetError("Arithemetic Exception in binary op", e);
        }
        if (result instanceof Boolean) {
            return (Boolean)result != false ? Primitive.TRUE : Primitive.FALSE;
        }
        if (obj1 instanceof Primitive && obj2 instanceof Primitive) {
            if (Types.isFloatingpoint(result) && lhs.getClass() == BigDecimal.class) {
                return Primitive.wrap(result, result.getClass());
            }
            return Primitive.shrinkWrap(result);
        }
        return Primitive.shrinkWrap(result).getValue();
    }

    static <T> Object binaryOperationImpl(T lhs, T rhs, int kind) throws UtilEvalError {
        if (lhs instanceof Boolean) {
            return Operators.booleanBinaryOperation((Boolean)lhs, (Boolean)rhs, kind);
        }
        if (COMPARABLE_OPS.contains(kind)) {
            return Operators.comparableBinaryBooleanOperations((Comparable)lhs, rhs, kind);
        }
        if (lhs instanceof BigInteger) {
            return Operators.bigIntegerBinaryOperation((BigInteger)lhs, (BigInteger)rhs, kind);
        }
        if (lhs instanceof BigDecimal) {
            return Operators.bigDecimalBinaryOperation((BigDecimal)lhs, (BigDecimal)rhs, kind);
        }
        if (Types.isFloatingpoint(lhs)) {
            return Operators.doubleBinaryOperation((Double)lhs, (Double)rhs, kind);
        }
        if (lhs instanceof Number) {
            return Operators.longBinaryOperation((Long)lhs, (Long)rhs, kind);
        }
        throw new UtilEvalError("Invalid types in binary operator");
    }

    static Boolean booleanBinaryOperation(Boolean B1, Boolean B2, int kind) {
        boolean lhs = B1;
        boolean rhs = B2;
        switch (kind) {
            case 92: {
                return lhs == rhs;
            }
            case 97: {
                return lhs != rhs;
            }
            case 98: 
            case 99: {
                return rhs;
            }
            case 100: 
            case 101: {
                return rhs;
            }
            case 108: 
            case 109: {
                return lhs & rhs;
            }
            case 110: 
            case 111: {
                return lhs | rhs;
            }
            case 112: 
            case 113: {
                return lhs ^ rhs;
            }
        }
        throw new InterpreterError("unimplemented binary operator");
    }

    static <T> Boolean comparableBinaryBooleanOperations(Comparable<T> lhs, T rhs, int kind) {
        switch (kind) {
            case 88: 
            case 89: {
                return lhs.compareTo(rhs) < 0;
            }
            case 86: 
            case 87: {
                return lhs.compareTo(rhs) > 0;
            }
            case 93: 
            case 94: {
                return lhs.compareTo(rhs) <= 0;
            }
            case 95: 
            case 96: {
                return lhs.compareTo(rhs) >= 0;
            }
            case 97: {
                return lhs.compareTo(rhs) != 0;
            }
        }
        return lhs.compareTo(rhs) == 0;
    }

    static Object longBinaryOperation(long lhs, long rhs, int kind) {
        switch (kind) {
            case 104: {
                if (lhs > 0L && Long.MAX_VALUE - lhs < rhs) break;
                return lhs + rhs;
            }
            case 105: {
                if (lhs < 0L && Long.MIN_VALUE - lhs > -rhs) break;
                return lhs - rhs;
            }
            case 106: {
                if (lhs != 0L && Long.MAX_VALUE / lhs < rhs) break;
                return lhs * rhs;
            }
            case 107: {
                return lhs / rhs;
            }
            case 114: 
            case 115: {
                return lhs % rhs;
            }
            case 116: 
            case 117: {
                double check = Math.pow(lhs, rhs);
                BigInteger bi = BigDecimal.valueOf(check).toBigInteger();
                if (bi.compareTo(Primitive.LONG_MIN) < 0 || bi.compareTo(Primitive.LONG_MAX) > 0) break;
                return (long)check;
            }
            case 118: 
            case 119: {
                return lhs << (int)rhs;
            }
            case 120: 
            case 121: {
                return lhs >> (int)rhs;
            }
            case 122: 
            case 123: {
                return lhs >>> (int)rhs;
            }
            case 108: 
            case 109: {
                return lhs & rhs;
            }
            case 110: 
            case 111: {
                return lhs | rhs;
            }
            case 112: 
            case 113: {
                return lhs ^ rhs;
            }
        }
        if (OVERFLOW_OPS.contains(kind)) {
            return Operators.bigIntegerBinaryOperation(BigInteger.valueOf(lhs), BigInteger.valueOf(rhs), kind);
        }
        throw new InterpreterError("Unimplemented binary long operator");
    }

    static Object bigIntegerBinaryOperation(BigInteger lhs, BigInteger rhs, int kind) {
        switch (kind) {
            case 104: {
                return lhs.add(rhs);
            }
            case 105: {
                return lhs.subtract(rhs);
            }
            case 106: {
                return lhs.multiply(rhs);
            }
            case 107: {
                return lhs.divide(rhs);
            }
            case 114: 
            case 115: {
                return lhs.mod(rhs);
            }
            case 116: 
            case 117: {
                return lhs.pow(rhs.intValue());
            }
            case 118: 
            case 119: {
                return lhs.shiftLeft(rhs.intValue());
            }
            case 120: 
            case 121: {
                return lhs.shiftRight(rhs.intValue());
            }
            case 122: 
            case 123: {
                if (lhs.signum() >= 0) {
                    return lhs.shiftRight(rhs.intValue());
                }
                BigInteger opener = BigInteger.ONE.shiftLeft(lhs.toString(2).length() + 1);
                BigInteger opened = lhs.subtract(opener);
                BigInteger mask = opener.subtract(BigInteger.ONE).shiftRight(rhs.intValue() + 1);
                return opened.shiftRight(rhs.intValue()).and(mask);
            }
            case 108: 
            case 109: {
                return lhs.and(rhs);
            }
            case 110: 
            case 111: {
                return lhs.or(rhs);
            }
            case 112: 
            case 113: {
                return lhs.xor(rhs);
            }
        }
        throw new InterpreterError("Unimplemented binary integer operator");
    }

    static Object doubleBinaryOperation(double lhs, double rhs, int kind) throws UtilEvalError {
        switch (kind) {
            case 104: {
                if (lhs > 0.0 && Double.MAX_VALUE - lhs < rhs) break;
                return lhs + rhs;
            }
            case 105: {
                if (lhs < 0.0 && -1.7976931348623157E308 - lhs > -rhs) break;
                return lhs - rhs;
            }
            case 106: {
                if (lhs != 0.0 && Double.MAX_VALUE / lhs < rhs) break;
                return lhs * rhs;
            }
            case 107: {
                return lhs / rhs;
            }
            case 114: 
            case 115: {
                return lhs % rhs;
            }
            case 116: 
            case 117: {
                double check = Math.pow(lhs, rhs);
                if (Double.isInfinite(check)) break;
                return check;
            }
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: {
                throw new UtilEvalError("Can't shift floatingpoint values");
            }
        }
        if (OVERFLOW_OPS.contains(kind)) {
            return Operators.bigDecimalBinaryOperation(BigDecimal.valueOf(lhs), BigDecimal.valueOf(rhs), kind);
        }
        throw new InterpreterError("Unimplemented binary double operator");
    }

    static Object bigDecimalBinaryOperation(BigDecimal lhs, BigDecimal rhs, int kind) throws UtilEvalError {
        switch (kind) {
            case 104: {
                return lhs.add(rhs);
            }
            case 105: {
                return lhs.subtract(rhs);
            }
            case 106: {
                return lhs.multiply(rhs);
            }
            case 107: {
                return lhs.divide(rhs);
            }
            case 114: 
            case 115: {
                return lhs.remainder(rhs);
            }
            case 116: 
            case 117: {
                return lhs.pow(rhs.intValue());
            }
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: {
                throw new UtilEvalError("Can't shift floatingpoint values");
            }
        }
        throw new InterpreterError("Unimplemented binary float operator");
    }

    static Number promoteToInteger(Object wrapper) {
        if (wrapper instanceof Character) {
            return (int)((Character)wrapper).charValue();
        }
        if (wrapper instanceof Byte || wrapper instanceof Short) {
            return ((Number)wrapper).intValue();
        }
        return (Number)wrapper;
    }

    static Object[] promotePrimitives(Object lhs, Object rhs) {
        Number lnum = Operators.promoteToInteger(lhs);
        Number rnum = Operators.promoteToInteger(rhs);
        if (lhs instanceof BigDecimal) {
            if (!(rhs instanceof BigDecimal)) {
                rhs = Primitive.castNumber(BigDecimal.class, rnum);
            }
        } else if (rhs instanceof BigDecimal) {
            lhs = Primitive.castNumber(BigDecimal.class, lnum);
        } else if (Types.isFloatingpoint(lhs) || Types.isFloatingpoint(rhs)) {
            if (!(lhs instanceof Double)) {
                lhs = lnum.doubleValue();
            }
            if (!(rhs instanceof Double)) {
                rhs = rnum.doubleValue();
            }
        } else if (lhs instanceof BigInteger) {
            if (!(rhs instanceof BigInteger)) {
                rhs = Primitive.castNumber(BigInteger.class, rnum);
            }
        } else if (rhs instanceof BigInteger) {
            lhs = Primitive.castNumber(BigInteger.class, lnum);
        } else {
            if (!(lhs instanceof Long)) {
                lhs = lnum.longValue();
            }
            if (!(rhs instanceof Long)) {
                rhs = rnum.longValue();
            }
        }
        return new Object[]{lhs, rhs};
    }

    public static Primitive unaryOperation(Primitive val, int kind) throws UtilEvalError {
        if (val == Primitive.NULL) {
            throw new UtilEvalError("illegal use of null object or 'null' literal");
        }
        if (val == Primitive.VOID) {
            throw new UtilEvalError("illegal use of undefined object or 'void' literal");
        }
        Class<?> operandType = val.getType();
        if (operandType == Boolean.TYPE) {
            return Operators.booleanUnaryOperation((Boolean)val.getValue(), kind) ? Primitive.TRUE : Primitive.FALSE;
        }
        Number operand = Operators.promoteToInteger(val.getValue());
        if (operand instanceof Integer) {
            int result = Operators.intUnaryOperation((Integer)operand, kind);
            if (kind == 102 || kind == 103) {
                if (operandType == Byte.TYPE) {
                    return new Primitive((byte)result);
                }
                if (operandType == Short.TYPE) {
                    return new Primitive((short)result);
                }
                if (operandType == Character.TYPE) {
                    return new Primitive((char)result);
                }
            }
            return new Primitive(result);
        }
        if (operand instanceof Long) {
            return new Primitive(Operators.longUnaryOperation(operand.longValue(), kind));
        }
        if (operand instanceof Float) {
            return new Primitive(Operators.floatUnaryOperation(Float.valueOf(operand.floatValue()), kind));
        }
        if (operand instanceof Double) {
            return new Primitive(Operators.doubleUnaryOperation(operand.doubleValue(), kind));
        }
        if (operand instanceof BigInteger) {
            return new Primitive(Operators.bigIntegerUnaryOperation((BigInteger)operand, kind));
        }
        if (operand instanceof BigDecimal) {
            return new Primitive(Operators.bigDecimalUnaryOperation((BigDecimal)operand, kind));
        }
        throw new InterpreterError("An error occurred.  Please call technical support.");
    }

    static boolean booleanUnaryOperation(Boolean B, int kind) throws UtilEvalError {
        boolean operand = B;
        switch (kind) {
            case 90: {
                return !operand;
            }
        }
        throw new UtilEvalError("Operator inappropriate for boolean");
    }

    static int intUnaryOperation(Integer I, int kind) {
        int operand = I;
        switch (kind) {
            case 104: {
                return operand;
            }
            case 105: {
                return -operand;
            }
            case 91: {
                return ~operand;
            }
            case 102: {
                return operand + 1;
            }
            case 103: {
                return operand - 1;
            }
        }
        throw new InterpreterError("bad integer unaryOperation");
    }

    static BigInteger bigIntegerUnaryOperation(BigInteger operand, int kind) {
        switch (kind) {
            case 104: {
                return operand;
            }
            case 105: {
                return operand.negate();
            }
            case 91: {
                return operand.not();
            }
            case 102: {
                return operand.add(BigInteger.ONE);
            }
            case 103: {
                return operand.subtract(BigInteger.ONE);
            }
        }
        throw new InterpreterError("bad big integer unaryOperation");
    }

    static BigDecimal bigDecimalUnaryOperation(BigDecimal operand, int kind) {
        switch (kind) {
            case 104: {
                return operand;
            }
            case 105: {
                return operand.negate();
            }
            case 91: {
                return operand.signum() == 1 ? operand.negate() : operand;
            }
            case 102: {
                return operand.add(BigDecimal.ONE);
            }
            case 103: {
                return operand.subtract(BigDecimal.ONE);
            }
        }
        throw new InterpreterError("bad big decimal unaryOperation");
    }

    static long longUnaryOperation(Long L, int kind) {
        long operand = L;
        switch (kind) {
            case 104: {
                return operand;
            }
            case 105: {
                return -operand;
            }
            case 91: {
                return operand ^ 0xFFFFFFFFFFFFFFFFL;
            }
            case 102: {
                return operand + 1L;
            }
            case 103: {
                return operand - 1L;
            }
        }
        throw new InterpreterError("bad long unaryOperation");
    }

    static float floatUnaryOperation(Float F, int kind) {
        float operand = F.floatValue();
        switch (kind) {
            case 104: {
                return operand;
            }
            case 105: {
                return -operand;
            }
            case 102: {
                return operand + 1.0f;
            }
            case 103: {
                return operand - 1.0f;
            }
        }
        throw new InterpreterError("bad float unaryOperation");
    }

    static double doubleUnaryOperation(Double D, int kind) {
        double operand = D;
        switch (kind) {
            case 104: {
                return operand;
            }
            case 105: {
                return -operand;
            }
            case 102: {
                return operand + 1.0;
            }
            case 103: {
                return operand - 1.0;
            }
        }
        throw new InterpreterError("bad double unaryOperation");
    }
}

