/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BshMethod;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.Node;
import bsh.Primitive;
import bsh.Reflect;
import bsh.This;
import bsh.UtilEvalError;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.Map;

public class PreparsedScript {
    private final BshMethod prepared;
    private final Interpreter interpreter = new Interpreter();

    public PreparsedScript(String source) throws EvalError {
        this(source, PreparsedScript.getDefaultClassLoader());
    }

    public PreparsedScript(String source, ClassLoader classLoader) throws EvalError {
        this.interpreter.setClassLoader(classLoader);
        try {
            This callable = (This)this.interpreter.eval(new StringReader("__execute() {" + this.interpreter.terminatedScript(source) + "} return this;"), this.interpreter.globalNameSpace, this.interpreter.showEvalString("pre-parsed script", source));
            this.prepared = callable.getNameSpace().getMethod("__execute", Reflect.ZERO_TYPES, false);
        }
        catch (UtilEvalError e) {
            throw new IllegalStateException(e);
        }
    }

    private static ClassLoader getDefaultClassLoader() {
        ClassLoader classLoader = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (null == classLoader) {
            classLoader = PreparsedScript.class.getClassLoader();
        }
        if (null == classLoader) {
            return ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public Object invoke(Map<String, ?> context) throws EvalError {
        NameSpace scope = new NameSpace(this.interpreter.globalNameSpace, this.interpreter.getClassManager(), "BeanshellExecutable");
        scope.isMethod = true;
        Interpreter local = new Interpreter(scope, this.interpreter);
        for (Map.Entry<String, ?> entry : context.entrySet()) {
            local.set(entry.getKey(), entry.getValue());
        }
        return Primitive.unwrap(this.prepared.invoke(Reflect.ZERO_ARGS, local, new CallStack(scope), Node.JAVACODE, true));
    }

    public void setOut(PrintStream out) {
        this.interpreter.setOut(out);
    }

    public void setErr(PrintStream err) {
        this.interpreter.setErr(err);
    }
}

