/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BshMethod;
import bsh.Primitive;
import bsh.Reflect;
import bsh.Types;
import bsh.Variable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StringUtil {
    public static String typeString(Object value) {
        return null == value || Primitive.NULL == value ? "null" : (value instanceof Primitive ? ((Primitive)value).getType().getSimpleName() : StringUtil.typeString(value.getClass()));
    }

    public static String typeString(Class<?> clas) {
        if (Map.class.isAssignableFrom(clas)) {
            clas = Map.class;
        } else if (List.class.isAssignableFrom(clas)) {
            clas = Queue.class.isAssignableFrom(clas) ? Queue.class : List.class;
        } else if (Deque.class.isAssignableFrom(clas)) {
            clas = Deque.class;
        } else if (Set.class.isAssignableFrom(clas)) {
            clas = Set.class;
        } else if (Map.Entry.class.isAssignableFrom(clas)) {
            clas = Map.Entry.class;
        }
        return clas.isArray() ? StringUtil.typeString(clas.getComponentType()) + "[]" : (clas.getName().startsWith("java") ? clas.getSimpleName() : clas.getName());
    }

    public static String typeValueString(Object value) {
        StringBuilder sb = new StringBuilder(StringUtil.valueString(value));
        return sb.append(" :").append(StringUtil.typeString(value)).toString();
    }

    public static String valueString(Object value) {
        StringBuilder val = new StringBuilder("" + value);
        if (null != value && value.getClass().isArray()) {
            val = new StringBuilder("{");
            for (int i = 0; i < Array.getLength(value); ++i) {
                val.append(StringUtil.valueString(Array.get(value, i))).append(", ");
            }
            if (val.reverse().charAt(0) == ' ') {
                val.delete(0, 2);
            }
            return val.reverse().append("}").toString();
        }
        if (value instanceof Collection) {
            val = new StringBuilder("[");
            for (Object v : (Collection)value) {
                val.append(StringUtil.valueString(v)).append(", ");
            }
            if (val.reverse().charAt(0) == ' ') {
                val.delete(0, 2);
            }
            return val.reverse().append("]").toString();
        }
        if (value instanceof Map) {
            val = new StringBuilder("{");
            for (Map.Entry e : ((Map)value).entrySet()) {
                val.append(StringUtil.valueString(e.getKey())).append("=").append(StringUtil.valueString(e.getValue())).append(", ");
            }
            if (val.reverse().charAt(0) == ' ') {
                val.delete(0, 2);
            }
            return val.reverse().append("}").toString();
        }
        if (value instanceof Map.Entry) {
            return StringUtil.valueString(((Map.Entry)value).getKey()) + "=" + StringUtil.valueString(((Map.Entry)value).getValue());
        }
        if (value instanceof String) {
            return val.insert(0, "\"").append("\"").toString();
        }
        if (Primitive.unwrap(value) instanceof Character) {
            return val.insert(0, "'").append("'").toString();
        }
        if (Primitive.unwrap(value) instanceof Number) {
            if (Primitive.unwrap(value) instanceof Byte) {
                return val.append("o").toString();
            }
            if (Primitive.unwrap(value) instanceof Short) {
                return val.append("s").toString();
            }
            if (Primitive.unwrap(value) instanceof Integer) {
                return val.append("I").toString();
            }
            if (Primitive.unwrap(value) instanceof Long) {
                return val.append("L").toString();
            }
            if (Primitive.unwrap(value) instanceof BigInteger) {
                return val.append("W").toString();
            }
            if (Primitive.unwrap(value) instanceof Float) {
                return val.append("f").toString();
            }
            if (Primitive.unwrap(value) instanceof Double) {
                return val.append("d").toString();
            }
            if (Primitive.unwrap(value) instanceof BigDecimal) {
                return val.append("w").toString();
            }
        }
        return val.toString();
    }

    public static String maxCommonPrefix(String one, String two) {
        int i = 0;
        while (one.regionMatches(0, two, 0, i)) {
            ++i;
        }
        return one.substring(0, i - 1);
    }

    public static String methodString(String name, Object[] args) {
        return StringUtil.methodString(name, Types.getTypes(args));
    }

    public static String methodString(String name, String[] types) {
        StringBuilder sb = new StringBuilder();
        sb.append(name).append('(');
        for (int i = 0; i < types.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(types[i]);
        }
        sb.append(')');
        return sb.toString();
    }

    public static String methodString(String name, Class<?>[] types) {
        return StringUtil.methodString(name, StringUtil.getTypeNames(types));
    }

    public static String methodString(String name, Class<?>[] types, String[] names) {
        return StringUtil.methodString(name, StringUtil.getTypeNames(types, names));
    }

    private static Stream<String> getTypeNamesStream(Class<?>[] types) {
        return Stream.of(types).map(StringUtil::getTypeName);
    }

    private static List<String> getTypeNamesList(Class<?>[] types) {
        return StringUtil.getTypeNamesStream(types).collect(Collectors.toList());
    }

    private static String[] getTypeNames(Class<?>[] types) {
        return (String[])StringUtil.getTypeNamesStream(types).toArray(String[]::new);
    }

    private static String[] getTypeNames(Class<?>[] types, String[] names) {
        Iterator namesIt = Stream.of(names).iterator();
        return (String[])StringUtil.getTypeNamesStream(types).map(type -> type + " " + (String)namesIt.next()).toArray(String[]::new);
    }

    private static String getTypeName(Class<?> type) {
        return null == type ? "Object" : type.getSimpleName();
    }

    private static String getTypeExtends(Class<?> type) {
        return type.isInterface() ? "" : " extends " + StringUtil.getTypeName(type.getSuperclass());
    }

    private static String getTypeImplements(Class<?> type) {
        StringBuilder sb = new StringBuilder();
        if (type.getInterfaces().length > 0) {
            sb.append(type.isInterface() ? " extends " : " implements ").append(String.join((CharSequence)", ", StringUtil.getTypeNamesList(type.getInterfaces())));
        }
        return sb.toString();
    }

    public static String methodString(Method method) {
        String mods = Modifier.toString(method.getModifiers());
        StringBuilder sb = new StringBuilder();
        return sb.append(mods).append(" ").append(StringUtil.getTypeName(method.getReturnType())).append(" ").append(StringUtil.methodString(method.getName(), method.getParameterTypes())).append(mods.contains("abstract") ? ";" : " {}").toString();
    }

    public static String methodString(BshMethod method) {
        String mods = method.getModifiers().toString().substring(11);
        StringBuilder sb = new StringBuilder();
        return sb.append(mods).append(" ").append(StringUtil.getTypeName(method.getReturnType())).append(" ").append(StringUtil.methodString(method.getName(), method.getParameterTypes(), method.getParameterNames())).append(mods.contains("abstract") ? ";" : " {}").toString();
    }

    private static String generatedClassString(Class<?> type) {
        StringBuilder sb = new StringBuilder();
        sb.append(Reflect.getClassModifiers(type).toString().substring(11)).append(type.isInterface() ? " interface" : " class").append(" ").append(StringUtil.getTypeName(type)).append(StringUtil.getTypeExtends(type)).append(StringUtil.getTypeImplements(type));
        return sb.append(" {").toString().trim();
    }

    public static String classString(Class<?> type) {
        if (Reflect.isGeneratedClass(type)) {
            return StringUtil.generatedClassString(type);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Modifier.toString(type.getModifiers())).append(type.isInterface() ? "" : " class").append(" ").append(StringUtil.getTypeName(type)).append(StringUtil.getTypeExtends(type)).append(StringUtil.getTypeImplements(type));
        return sb.append(" {").toString().trim();
    }

    public static String variableString(Variable var) {
        StringBuilder sb = new StringBuilder();
        sb.append(var.getModifiers().toString().substring(11)).append(" ").append(StringUtil.getTypeName(var.getType())).append(" ").append(var.getName());
        return sb.append(";").toString();
    }

    public static String variableString(Field field) {
        StringBuilder sb = new StringBuilder();
        sb.append(Modifier.toString(field.getModifiers())).append(" ").append(StringUtil.getTypeName(field.getType())).append(" ").append(field.getName());
        return sb.append(";").toString();
    }
}

