/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.CallStack;
import bsh.EvalError;
import bsh.Node;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;

public final class TargetError
extends EvalError {
    private final boolean inNativeCode;

    public TargetError(String msg, Throwable t, Node node, CallStack callstack, boolean inNativeCode) {
        super(msg, node, callstack, t);
        this.inNativeCode = inNativeCode;
    }

    public TargetError(Throwable t, Node node, CallStack callstack) {
        this("TargetError", t, node, callstack, false);
    }

    public synchronized Throwable getTarget() {
        Throwable target = this.getCause();
        if (target instanceof InvocationTargetException) {
            return target.getCause();
        }
        return target;
    }

    @Override
    public synchronized String getMessage() {
        return super.getMessage() + "Caused by: " + this.printTargetError(this.getCause());
    }

    public void printStackTrace(boolean debug, PrintStream out) {
        StackTraceElement[] st;
        if (debug) {
            super.printStackTrace(out);
            out.println("--- Target Stack Trace ---");
        }
        for (StackTraceElement ste : st = this.getCause().getStackTrace()) {
            if (ste.getClassName().contains("reflect")) break;
            out.println("        at " + ste);
        }
    }

    private synchronized String printTargetError(Throwable t) {
        StringBuilder msgs = new StringBuilder(t.toString());
        while (null != (t = t.getCause())) {
            msgs.append("\n").append(t.toString());
        }
        return msgs.toString();
    }

    public boolean inNativeCode() {
        return this.inNativeCode;
    }
}

