/*
 * Decompiled with CFR 0.152.
 */
package bsh.engine;

import bsh.EvalError;
import bsh.ExternalNameSpace;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.ParseException;
import bsh.PreparsedScript;
import bsh.TargetError;
import bsh.This;
import bsh.engine.BshScriptEngineFactory;
import bsh.engine.ScriptContextEngineView;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

public class BshScriptEngine
extends AbstractScriptEngine
implements Compilable,
Invocable {
    static final String engineNameSpaceKey = "org_beanshell_engine_namespace";
    private BshScriptEngineFactory factory;
    private Interpreter interpreter;

    public BshScriptEngine() {
        this((BshScriptEngineFactory)null);
    }

    public BshScriptEngine(BshScriptEngineFactory factory) {
        this.factory = factory;
        this.getInterpreter();
    }

    protected Interpreter getInterpreter() {
        if (this.interpreter == null) {
            this.interpreter = new Interpreter();
            this.interpreter.setNameSpace(null);
        }
        return this.interpreter;
    }

    @Override
    public Object eval(String script, ScriptContext scriptContext) throws ScriptException {
        return this.evalSource(script, scriptContext);
    }

    @Override
    public Object eval(Reader reader, ScriptContext scriptContext) throws ScriptException {
        return this.evalSource(reader, scriptContext);
    }

    private Object evalSource(Object source, ScriptContext scriptContext) throws ScriptException {
        try {
            Interpreter bsh = this.getInterpreter();
            NameSpace contextNameSpace = BshScriptEngine.getEngineNameSpace(scriptContext);
            bsh.setNameSpace(contextNameSpace);
            bsh.setOut(this.toPrintStream(scriptContext.getWriter()));
            bsh.setErr(this.toPrintStream(scriptContext.getErrorWriter()));
            if (source instanceof Reader) {
                return bsh.eval((Reader)source);
            }
            return bsh.eval((String)source);
        }
        catch (ParseException e) {
            throw new ScriptException(e.toString(), e.getErrorSourceFile(), e.getErrorLineNumber());
        }
        catch (TargetError e) {
            ScriptException se = new ScriptException(e.toString(), e.getErrorSourceFile(), e.getErrorLineNumber());
            se.initCause(e.getTarget());
            throw se;
        }
        catch (EvalError e) {
            throw new ScriptException(e.toString(), e.getErrorSourceFile(), e.getErrorLineNumber());
        }
        catch (IOException e) {
            throw new ScriptException(e.toString());
        }
    }

    private PrintStream toPrintStream(Writer writer) throws UnsupportedEncodingException {
        return new PrintStream((OutputStream)new WriterOutputStream(writer), true, "UTF-8");
    }

    private static NameSpace getEngineNameSpace(ScriptContext scriptContext) {
        ScriptContextEngineView engineView = new ScriptContextEngineView(scriptContext);
        NameSpace ns = (NameSpace)engineView.get(engineNameSpaceKey);
        if (!engineView.containsKey(engineNameSpaceKey)) {
            ns = new ExternalNameSpace(null, "javax_script_context", engineView);
            engineView.put(engineNameSpaceKey, ns);
        }
        return ns;
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public ScriptEngineFactory getFactory() {
        if (this.factory == null) {
            this.factory = new BshScriptEngineFactory();
        }
        return this.factory;
    }

    @Override
    public CompiledScript compile(final String script) throws ScriptException {
        try {
            final PreparsedScript preparsed = new PreparsedScript(script);
            return new CompiledScript(){

                @Override
                public Object eval(ScriptContext context) throws ScriptException {
                    try {
                        preparsed.setOut(BshScriptEngine.this.toPrintStream(context.getWriter()));
                        preparsed.setErr(BshScriptEngine.this.toPrintStream(context.getErrorWriter()));
                        return preparsed.invoke(new ScriptContextEngineView(context));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new ScriptException(e.toString(), script, -1);
                    }
                    catch (EvalError e) {
                        throw BshScriptEngine.this.constructScriptException(e);
                    }
                }

                @Override
                public ScriptEngine getEngine() {
                    return BshScriptEngine.this;
                }
            };
        }
        catch (EvalError e) {
            throw this.constructScriptException(e);
        }
    }

    private ScriptException constructScriptException(EvalError e) {
        return new ScriptException(e.getMessage(), e.getErrorSourceFile(), e.getErrorLineNumber());
    }

    private static String convertToString(Reader reader) throws IOException {
        int len;
        StringBuffer buffer = new StringBuffer(64);
        char[] cb = new char[64];
        while ((len = reader.read(cb)) != -1) {
            buffer.append(cb, 0, len);
        }
        reader.close();
        return buffer.toString();
    }

    @Override
    public CompiledScript compile(Reader script) throws ScriptException {
        try {
            return this.compile(BshScriptEngine.convertToString(script));
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public Object invokeMethod(Object thiz, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        if (!(thiz instanceof This)) {
            throw new ScriptException("Illegal object type: " + (null == thiz ? "null" : thiz.getClass()));
        }
        This bshObject = (This)thiz;
        try {
            return bshObject.invokeMethod(name, args);
        }
        catch (TargetError e) {
            ScriptException se = new ScriptException(e.toString(), e.getErrorSourceFile(), e.getErrorLineNumber());
            se.initCause(e.getTarget());
            throw se;
        }
        catch (EvalError e) {
            throw new ScriptException(e.toString(), e.getErrorSourceFile(), e.getErrorLineNumber());
        }
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        return this.invokeMethod(this.getGlobal(), name, args);
    }

    @Override
    public <T> T getInterface(Class<T> clasz) {
        return clasz.cast(this.getGlobal().getInterface(clasz));
    }

    @Override
    public <T> T getInterface(Object thiz, Class<T> clasz) {
        if (!(thiz instanceof This)) {
            throw new IllegalArgumentException("Illegal object type: " + (null == thiz ? "null" : thiz.getClass()));
        }
        This bshThis = (This)thiz;
        return clasz.cast(bshThis.getInterface(clasz));
    }

    private This getGlobal() {
        return BshScriptEngine.getEngineNameSpace(this.getContext()).getThis(this.getInterpreter());
    }

    class WriterOutputStream
    extends OutputStream {
        private final ByteBuffer input;
        private final CharBuffer output;
        private final Writer writer;
        private final CharsetDecoder decoder;

        WriterOutputStream(Writer writer) {
            this.writer = writer;
            this.decoder = StandardCharsets.UTF_8.newDecoder();
            int size = 16384;
            this.input = ByteBuffer.allocate(size);
            this.output = CharBuffer.allocate(size);
        }

        @Override
        public void write(int data) throws IOException {
            this.write(new byte[]{(byte)data}, 0, 1);
        }

        @Override
        public void write(byte[] buffer) throws IOException {
            this.write(buffer, 0, buffer.length);
        }

        @Override
        public void write(byte[] buffer, int offset, int length) throws IOException {
            while (length > 0) {
                CoderResult result;
                int done = Math.min(length, this.input.remaining());
                this.input.put(buffer, offset, done);
                this.input.flip();
                do {
                    if ((result = this.decoder.decode(this.input, this.output, false)).isError()) {
                        result.throwException();
                    }
                    this.writer.write(this.output.array(), 0, this.output.position());
                    this.writer.flush();
                    this.output.rewind();
                } while (!result.isUnderflow());
                this.input.compact();
                offset += done;
                length -= done;
            }
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }
}

