/*
 * Decompiled with CFR 0.152.
 */
package bsh.servlet;

import bsh.EvalError;
import bsh.FileReader;
import bsh.Interpreter;
import bsh.servlet.SimpleTemplate;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BshServlet
extends HttpServlet {
    private static final String bshVersion;
    static String exampleScript;

    static String getBshVersion() {
        return bshVersion;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String script = request.getParameter("bsh.script");
        String client = request.getParameter("bsh.client");
        String output = request.getParameter("bsh.servlet.output");
        String captureOutErr = request.getParameter("bsh.servlet.captureOutErr");
        boolean capture = false;
        if (captureOutErr != null && captureOutErr.equalsIgnoreCase("true")) {
            capture = true;
        }
        Object scriptResult = null;
        Exception scriptError = null;
        StringBuilder scriptOutput = new StringBuilder();
        if (script != null) {
            try {
                scriptResult = this.evalScript(script, scriptOutput, capture, request, response);
            }
            catch (Exception e) {
                scriptError = e;
            }
        }
        response.setHeader("Bsh-Return", String.valueOf(scriptResult));
        if (output != null && output.equalsIgnoreCase("raw") || client != null && client.equals("Remote")) {
            this.sendRaw(request, response, scriptError, scriptResult, scriptOutput);
        } else {
            this.sendHTML(request, response, script, scriptError, scriptResult, scriptOutput, capture);
        }
    }

    void sendHTML(HttpServletRequest request, HttpServletResponse response, String script, Exception scriptError, Object scriptResult, StringBuilder scriptOutput, boolean capture) throws IOException {
        SimpleTemplate st = new SimpleTemplate(BshServlet.class.getResource("page.template"));
        st.replace("version", BshServlet.getBshVersion());
        String requestURI = request.getRequestURI();
        st.replace("servletURL", requestURI);
        if (script != null) {
            st.replace("script", script);
        } else {
            st.replace("script", exampleScript);
        }
        if (capture) {
            st.replace("captureOutErr", "CHECKED");
        } else {
            st.replace("captureOutErr", "");
        }
        if (script != null) {
            st.replace("scriptResult", this.formatScriptResultHTML(script, scriptResult, scriptError, scriptOutput));
        }
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        st.write(out);
        out.flush();
        out.close();
    }

    void sendRaw(HttpServletRequest request, HttpServletResponse response, Exception scriptError, Object scriptResult, StringBuilder scriptOutput) throws IOException {
        response.setContentType("text/plain");
        PrintWriter out = response.getWriter();
        if (scriptError != null) {
            out.println("Script Error:\n" + scriptError);
        } else {
            out.println(scriptOutput.toString());
        }
        out.flush();
        out.close();
    }

    String formatScriptResultHTML(String script, Object result, Exception error, StringBuilder scriptOutput) throws IOException {
        SimpleTemplate tmplt;
        if (error != null) {
            String errString;
            tmplt = new SimpleTemplate(((Object)((Object)this)).getClass().getResource("error.template"));
            if (error instanceof EvalError) {
                EvalError evalError = (EvalError)error;
                int lineNo = evalError.getErrorLineNumber();
                String msg = evalError.getRawMessage();
                int contextLines = 4;
                errString = BshServlet.escape(msg);
                if (lineNo > -1) {
                    errString = errString + "<hr>" + this.showScriptContextHTML(script, lineNo, contextLines);
                }
            } else {
                errString = BshServlet.escape(error.toString());
            }
            tmplt.replace("error", errString);
        } else {
            tmplt = new SimpleTemplate(((Object)((Object)this)).getClass().getResource("result.template"));
            tmplt.replace("value", BshServlet.escape(String.valueOf(result)));
            tmplt.replace("output", BshServlet.escape(scriptOutput.toString()));
        }
        return tmplt.toString();
    }

    String showScriptContextHTML(String s, int lineNo, int context) {
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new StringReader(s));
        int beginLine = Math.max(1, lineNo - context);
        int endLine = lineNo + context;
        for (int i = 1; i <= lineNo + context + 1; ++i) {
            String line;
            if (i < beginLine) {
                try {
                    br.readLine();
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e.toString());
                }
            }
            if (i > endLine) break;
            try {
                line = br.readLine();
            }
            catch (IOException e) {
                throw new RuntimeException(e.toString());
            }
            if (line == null) break;
            if (i == lineNo) {
                sb.append("<font color=\"red\">" + i + ": " + line + "</font><br/>");
                continue;
            }
            sb.append(i + ": " + line + "<br/>");
        }
        return sb.toString();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    /*
     * Exception decompiling
     */
    Object evalScript(String script, StringBuilder scriptOutput, boolean captureOutErr, HttpServletRequest request, HttpServletResponse response) throws EvalError {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String escape(String value) {
        String search = "&<>";
        String[] replace = new String[]{"&amp;", "&lt;", "&gt;"};
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            int pos = search.indexOf(c);
            if (pos < 0) {
                buf.append(c);
                continue;
            }
            buf.append(replace[pos]);
        }
        return buf.toString();
    }

    static {
        exampleScript = "print(\"hello!\");";
        String tmp = "BeanShell: unknown version";
        try (FileReader reader = new FileReader(BshServlet.class.getResource("getVersion.bsh").openStream());){
            Interpreter bsh = new Interpreter();
            bsh.eval(reader);
            tmp = (String)bsh.eval("getVersion()");
        }
        catch (Exception exception) {
            // empty catch block
        }
        bshVersion = tmp;
    }
}

