%import math

; Draw sine and cosine graphs. The sine and cosine functions are table lookups
; where the tables are generated by 64tass list functions.

; NOTE: meant to test to virtual machine output target (use -target virtual)

main {
    const uword width = 320
    const ubyte height = 200

    sub start()  {
        sys.gfx_enable(0)       ; enable lo res screen

        sincos255()
        sys.wait(120)

        sys.gfx_clear(0)

        sincos180()
        sys.wait(120)

        sys.gfx_clear(0)
        circles()

        sys.wait(120)
    }

    sub sincos255() {
        graphics_line(256)

        ubyte pixelyb
        ubyte pixelxb
        byte pixelys

        for pixelxb in 0 to 255 {
            pixelyb = math.cos8u(pixelxb) / 2
            sys.gfx_plot(pixelxb, pixelyb+20, 255)
            pixelyb = math.sin8u(pixelxb) / 2
            sys.gfx_plot(pixelxb, pixelyb+20, 255)
        }

        for pixelxb in 0 to 255 {
            pixelys = math.cos8(pixelxb) / 2
            sys.gfx_plot(pixelxb, pixelys as uword + 90, 255)
            pixelys = math.sin8(pixelxb) / 2
            sys.gfx_plot(pixelxb, pixelys as uword + 90, 255)
        }
    }

    sub sincos180() {
        graphics_line(180)

        ubyte pixelyb
        ubyte pixelxb
        byte pixelys

        for pixelxb in 0 to 179 {
            pixelyb = math.cosr8u(pixelxb) / 2
            sys.gfx_plot(pixelxb, pixelyb+20, 255)
            pixelyb = math.sinr8u(pixelxb) / 2
            sys.gfx_plot(pixelxb, pixelyb+20, 255)
        }

        for pixelxb in 0 to 179 {
            pixelys = math.cosr8(pixelxb) / 2
            sys.gfx_plot(pixelxb, pixelys as uword + 90, 255)
            pixelys = math.sinr8(pixelxb) / 2
            sys.gfx_plot(pixelxb, pixelys as uword + 90, 255)
        }
    }

    sub circles() {
        ubyte pixelyb
        uword pixelxw
        ubyte r

        ; circle with "degrees" from 0 to 255
        for r in 0 to 255 {
            pixelxw = (math.sin8(r)/2 as uword) + 80
            pixelyb = (math.cos8(r)/2 as uword + height/2) as ubyte
            sys.gfx_plot(pixelxw, pixelyb, 255)
        }

        for r in 0 to 255 {
            pixelxw = math.sin8u(r)/2
            pixelyb = math.cos8u(r)/2
            sys.gfx_plot(pixelxw + 16, pixelyb+50, 255)
        }

        ; circle with half-degrees from 0 to 179 (=full degrees 0..358 with steps of 2 degrees)
        for r in 0 to 179 {
            pixelxw = (math.sinr8(r) as word /2 + 220) as uword
            pixelyb = (math.cosr8(r)/2 + height/2) as ubyte
            sys.gfx_plot(pixelxw, pixelyb, 255)
        }

        for r in 0 to 179 {
            pixelxw = math.sinr8u(r)/2
            pixelyb = math.cosr8u(r)/2
            sys.gfx_plot(pixelxw + 156, pixelyb+50, 255)
        }
    }

    sub graphics_line(uword x) {
        uword y
        for y in 0 to height-1 {
            sys.gfx_plot(x, y, 100)
        }
    }

}
