// Copyright 2019 Istio Authors
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

// Code generated by kubetype-gen. DO NOT EDIT.

package version

import (
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"

	v1beta1 "istio.io/api/meta/v1beta1"
	types "istio.io/tools/cmd/kubetype-gen/testdata/test_input/positive/types"
)

//
// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object

// EmptyKubeType is for test
// +kubetype-gen
// +kubetype-gen:groupVersion=group/version
// +kubetype-gen:kubeType
type EmptyKubeType struct {
	v1.TypeMeta `json:",inline"`
	// +optional
	v1.ObjectMeta `json:"metadata,omitempty" protobuf:"bytes,1,opt,name=metadata"`

	// Spec defines the implementation of this definition.
	// +optional
	Spec types.EmptyKubeType `json:"spec,omitempty" protobuf:"bytes,2,opt,name=spec"`

	Status v1beta1.IstioStatus `json:",inline"`
}

// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object

// EmptyKubeTypeList is a collection of EmptyKubeTypes.
type EmptyKubeTypeList struct {
	v1.TypeMeta `json:",inline"`
	// +optional
	v1.ListMeta `json:"metadata,omitempty" protobuf:"bytes,1,opt,name=metadata"`
	Items       []EmptyKubeType `json:"items" protobuf:"bytes,2,rep,name=items"`
}

//
// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object

// MultipleNames is for test
// +kubetype-gen
// +kubetype-gen:groupVersion=group/version
// +kubetype-gen:kubeType=Type3
// +kubetype-gen:kubeType=Type4
// +kubetype-gen:Type4:tag=sometag=somevalue
type Type3 struct {
	v1.TypeMeta `json:",inline"`
	// +optional
	v1.ObjectMeta `json:"metadata,omitempty" protobuf:"bytes,1,opt,name=metadata"`

	// Spec defines the implementation of this definition.
	// +optional
	Spec types.MultipleNames `json:"spec,omitempty" protobuf:"bytes,2,opt,name=spec"`

	Status v1beta1.IstioStatus `json:",inline"`
}

// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object

// Type3List is a collection of Type3s.
type Type3List struct {
	v1.TypeMeta `json:",inline"`
	// +optional
	v1.ListMeta `json:"metadata,omitempty" protobuf:"bytes,1,opt,name=metadata"`
	Items       []Type3 `json:"items" protobuf:"bytes,2,rep,name=items"`
}

//
// +sometag=somevalue
// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object

// MultipleNames is for test
// +kubetype-gen
// +kubetype-gen:groupVersion=group/version
// +kubetype-gen:kubeType=Type3
// +kubetype-gen:kubeType=Type4
// +kubetype-gen:Type4:tag=sometag=somevalue
type Type4 struct {
	v1.TypeMeta `json:",inline"`
	// +optional
	v1.ObjectMeta `json:"metadata,omitempty" protobuf:"bytes,1,opt,name=metadata"`

	// Spec defines the implementation of this definition.
	// +optional
	Spec types.MultipleNames `json:"spec,omitempty" protobuf:"bytes,2,opt,name=spec"`

	Status v1beta1.IstioStatus `json:",inline"`
}

// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object

// Type4List is a collection of Type4s.
type Type4List struct {
	v1.TypeMeta `json:",inline"`
	// +optional
	v1.ListMeta `json:"metadata,omitempty" protobuf:"bytes,1,opt,name=metadata"`
	Items       []Type4 `json:"items" protobuf:"bytes,2,rep,name=items"`
}

//
// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object

// NameOverride is for test
// +kubetype-gen
// +kubetype-gen:groupVersion=group/version
// +kubetype-gen:kubeType=Type2
type Type2 struct {
	v1.TypeMeta `json:",inline"`
	// +optional
	v1.ObjectMeta `json:"metadata,omitempty" protobuf:"bytes,1,opt,name=metadata"`

	// Spec defines the implementation of this definition.
	// +optional
	Spec types.NameOverride `json:"spec,omitempty" protobuf:"bytes,2,opt,name=spec"`

	Status v1beta1.IstioStatus `json:",inline"`
}

// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object

// Type2List is a collection of Type2s.
type Type2List struct {
	v1.TypeMeta `json:",inline"`
	// +optional
	v1.ListMeta `json:"metadata,omitempty" protobuf:"bytes,1,opt,name=metadata"`
	Items       []Type2 `json:"items" protobuf:"bytes,2,rep,name=items"`
}

// +kubetype-gen
// +kubetype-gen:groupVersion=group/version
// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object

// SecondCommentsKubeType is for test
type SecondCommentsKubeType struct {
	v1.TypeMeta `json:",inline"`
	// +optional
	v1.ObjectMeta `json:"metadata,omitempty" protobuf:"bytes,1,opt,name=metadata"`

	// Spec defines the implementation of this definition.
	// +optional
	Spec types.SecondCommentsKubeType `json:"spec,omitempty" protobuf:"bytes,2,opt,name=spec"`

	Status v1beta1.IstioStatus `json:",inline"`
}

// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object

// SecondCommentsKubeTypeList is a collection of SecondCommentsKubeTypes.
type SecondCommentsKubeTypeList struct {
	v1.TypeMeta `json:",inline"`
	// +optional
	v1.ListMeta `json:"metadata,omitempty" protobuf:"bytes,1,opt,name=metadata"`
	Items       []SecondCommentsKubeType `json:"items" protobuf:"bytes,2,rep,name=items"`
}

//
// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object

// Type1 is for test
// +kubetype-gen
// +kubetype-gen:groupVersion=group/version
type Type1 struct {
	v1.TypeMeta `json:",inline"`
	// +optional
	v1.ObjectMeta `json:"metadata,omitempty" protobuf:"bytes,1,opt,name=metadata"`

	// Spec defines the implementation of this definition.
	// +optional
	Spec types.Type1 `json:"spec,omitempty" protobuf:"bytes,2,opt,name=spec"`

	Status v1beta1.IstioStatus `json:",inline"`
}

// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object

// Type1List is a collection of Type1s.
type Type1List struct {
	v1.TypeMeta `json:",inline"`
	// +optional
	v1.ListMeta `json:"metadata,omitempty" protobuf:"bytes,1,opt,name=metadata"`
	Items       []Type1 `json:"items" protobuf:"bytes,2,rep,name=items"`
}
