# protoc-gen-deepcopy

`protoc-gen-deepcopy` is a plugin for protoc which generates
`DeepCopyInto()` and `DeepCopy()` functions for `.pb.go` types.
The implementations simply use `proto.Clone()` to copy the contents of the `in`
instance to the `out` instance.  This allows the use of Kubernetes
`deepcopy-gen` with the Kubernetes types generated by `kubetype-gen`.

## Usage

Add the executable to your system's PATH, for example:

`$ go install istio.io/tools/cmd/protoc-gen-golang-deepcopy`

Add the `golang-deepcopy_out` option to your `protoc` command line, for example:

`$ protoc --golang-deepcopy_out=:output/path ...`

## Examples Of Generated Code

```go
// Code generated by protoc-gen-deepcopy. DO NOT EDIT.
package generated

import (
    proto "github.com/golang/protobuf/proto"
)

// DeepCopyInto supports using TagType within kubernetes types, where deepcopy-gen is used.
func (in *TagType) DeepCopyInto(out *TagType) {
    p := proto.Clone(in).(*TagType)
    *out = *p
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TagType. Required by controller-gen.
func (in *TagType) DeepCopy() *TagType {
    if in == nil {
        return nil
    }
    out := new(TagType)
    in.DeepCopyInto(out)
    return out
}

// DeepCopyInterface is an autogenerated deepcopy function, copying the receiver, creating a new TagType. Required by controller-gen.
func (in *TagType) DeepCopyInterface() interface{} {
    return in.DeepCopy()
}
```
