# protoc-gen-jsonshim

`protoc-gen-jsonshim` is a plugin for protoc which generates `MarshalJSON()` and
`UnmarshalJSON()` functions for `.pb.go` types.  The implementations simply
redirect to `MarshalJSONPB()` and `UnmarshalJSONPB()` respectively.  This allows
the types to be used with native Go JSON serialization.

## Usage

Add the executable to your system's PATH, for example:

`$ go install istio.io/tools/cmd/protoc-gen-golang-jsonshim`

Add the `golang-jsonshim_out` option to your `protoc` command line, for example:

`$ protoc --golang-jsonshim_out=:output/path ...`

## Examples Of Generated Code

```go
// Code generated by protoc-gen-jsonshim. DO NOT EDIT.
package generated

import (
    bytes "bytes"
    jsonpb "github.com/golang/protobuf/jsonpb"
)

// MarshalJSON is a custom marshaler for Simple
func (this *Simple) MarshalJSON() ([]byte, error) {
    str, err := TypesMarshaler.MarshalToString(this)
    return []byte(str), err
}

// UnmarshalJSON is a custom unmarshaler for Simple
func (this *Simple) UnmarshalJSON(b []byte) error {
    return TypesUnmarshaler.Unmarshal(bytes.NewReader(b), this)
}

var (
    TypesMarshaler   = &jsonpb.Marshaler{}
    TypesUnmarshaler = &jsonpb.Unmarshaler{AllowUnknownFields: true}
)

```
