# utoipa-config

[![Utoipa build](https://github.com/juhaku/utoipa/actions/workflows/build.yaml/badge.svg)](https://github.com/juhaku/utoipa/actions/workflows/build.yaml)
[![crates.io](https://img.shields.io/crates/v/utoipa-config.svg?label=crates.io&color=orange&logo=rust)](https://crates.io/crates/utoipa-config)
[![docs.rs](https://img.shields.io/static/v1?label=docs.rs&message=utoipa-config&color=blue&logo=data:image/svg+xml;base64,PHN2ZyByb2xlPSJpbWciIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmlld0JveD0iMCAwIDUxMiA1MTIiPjxwYXRoIGZpbGw9IiNmNWY1ZjUiIGQ9Ik00ODguNiAyNTAuMkwzOTIgMjE0VjEwNS41YzAtMTUtOS4zLTI4LjQtMjMuNC0zMy43bC0xMDAtMzcuNWMtOC4xLTMuMS0xNy4xLTMuMS0yNS4zIDBsLTEwMCAzNy41Yy0xNC4xIDUuMy0yMy40IDE4LjctMjMuNCAzMy43VjIxNGwtOTYuNiAzNi4yQzkuMyAyNTUuNSAwIDI2OC45IDAgMjgzLjlWMzk0YzAgMTMuNiA3LjcgMjYuMSAxOS45IDMyLjJsMTAwIDUwYzEwLjEgNS4xIDIyLjEgNS4xIDMyLjIgMGwxMDMuOS01MiAxMDMuOSA1MmMxMC4xIDUuMSAyMi4xIDUuMSAzMi4yIDBsMTAwLTUwYzEyLjItNi4xIDE5LjktMTguNiAxOS45LTMyLjJWMjgzLjljMC0xNS05LjMtMjguNC0yMy40LTMzLjd6TTM1OCAyMTQuOGwtODUgMzEuOXYtNjguMmw4NS0zN3Y3My4zek0xNTQgMTA0LjFsMTAyLTM4LjIgMTAyIDM4LjJ2LjZsLTEwMiA0MS40LTEwMi00MS40di0uNnptODQgMjkxLjFsLTg1IDQyLjV2LTc5LjFsODUtMzguOHY3NS40em0wLTExMmwtMTAyIDQxLjQtMTAyLTQxLjR2LS42bDEwMi0zOC4yIDEwMiAzOC4ydi42em0yNDAgMTEybC04NSA0Mi41di03OS4xbDg1LTM4Ljh2NzUuNHptMC0xMTJsLTEwMiA0MS40LTEwMi00MS40di0uNmwxMDItMzguMiAxMDIgMzguMnYuNnoiPjwvcGF0aD48L3N2Zz4K)](https://docs.rs/utoipa-config/latest/)
![rustc](https://img.shields.io/static/v1?label=rustc&message=1.75&color=orange&logo=rust)

This crate provides global configuration capabilities for `utoipa`.

## Config options

* Define rust type aliases for `utoipa` with `.alias_for(...)` method.
* Define schema collect mode for `utoipa` with `.schema_collect(...)` method.
  * `SchemaCollect:All` will collect all schemas from usages including inlined with `inline(T)`
  * `SchemaCollect::NonInlined` will only collect non inlined schemas from usages.

> [!WARNING]
> The build config will be stored to projects `OUTPUT` directory. It is then read from there via `OUTPUT` environment
> variable which will return **any instance** rust compiler might find at that time (Whatever the `OUTPUT` environment variable points to).
> **Be aware** that sometimes you might face a situation where the config is not aligned with your Rust aliases. 
> This might need you to change something on your code before changed config might apply.

## Install

Add dependency declaration to `Cargo.toml`.

```toml
[build-dependencies]
utoipa-config = "0.1"
```

## Examples

Create `build.rs` file with following content, then in your code you can just use `MyType` as 
alternative for `i32`.

```rust
use utoipa_config::Config;

fn main() {
    Config::new()
        .alias_for("MyType", "i32")
        .write_to_file();
}
```

See full [example for utoipa-config](../examples/utoipa-config-test/).

## License

Licensed under either of [Apache 2.0](LICENSE-APACHE) or [MIT](LICENSE-MIT) license at your option.

Unless you explicitly state otherwise, any contribution intentionally submitted for inclusion in this crate
by you, shall be dual licensed, without any additional terms or conditions.
