# `jest` Charter

Jest is a modular test runner and framework for JavaScript, designed for running using Node.js on all of its supported platforms. It is a modular runner than can run and test any JavaScript, TypeScript, or other language that compiles to JavaScript. It is designed to be easy to use and to have a low barrier to entry, while still being flexible and powerful.

## Section 0: Guiding Principles

The `jest` project is part of the [OpenJS Foundation][openjs foundation]. The project operates transparently, openly, collaboratively, and ethically. Project proposals, timelines, and status must not merely be open, but also easily visible to outsiders.

## Section 1: Scope

`jest` is primarily a test framework and test runner, focused on making it easy to test any JS code, either written for the server, the client or both. The Jest project consists of many different smaller modules, such as the assertion library, test runner, diffing algorithm, object serializer, task manager, and more. The project is designed to be modular, so that it can be used in a variety of different environments and for different purposes.

## Section 2: Relationship with OpenJS Foundation CPC.

Technical leadership for the projects within the [OpenJS Foundation][openjs foundation] is delegated to the projects through their project charters by the [OpenJS Foundation Cross-Project Council](https://openjsf.org/about/governance/) (CPC). In the case of the `jest` project, it is delegated to the [`jest` Maintainers](GOVERNANCE.md#maintainers) (the “Maintainers”). The OpenJS Foundation's business leadership is the Board of Directors (the “Board”).

This `jest` Charter reflects a carefully constructed balanced role for the Maintainers and the CPC in the governance of the OpenJS Foundation. The charter amendment process is for the Maintainers to propose changes using simple majority of the full Maintainers, the proposed changes being subject to review and approval by the CPC. The CPC may additionally make amendments to the project charter at any time, though the CPC will not interfere with day-to-day discussions, votes, or meetings of the Maintainers.

### 2.1 Other Formal Project Relationships

Section Intentionally Left Blank

## Section 3: `jest`'s Maintainers Governing Body

`jest` is governed by its [maintainers](GOVERNANCE.md#maintainers).

## Section 4: Roles & Responsibilities

The roles and responsibilities of `jest`'s Maintainers are described in [GOVERNANCE.md](./GOVERNANCE.md).

### Section 4.1 Project Operations & Management

Section Intentionally Left Blank

### Section 4.2: Decision-making, Voting, and/or Elections

The project will define a consensus-driven governance model in GOVERNANCE.md as need arises.

### Section 4.3: Other Project Roles

Section Intentionally Left Blank

## Section 5: Definitions

_Maintainers_: responsible for the technical direction of the project and for release management.

_Core contributors_: Maintainers delegate project responsibilities to core contributors, as documented in [GOVERNANCE.md](./GOVERNANCE.md).

[openjs foundation]: https://openjsf.org
