---
title: 'Jest 13.0: Flow & REPL'
authors: cpojer
---

Today we are happy to announce the next major release of Jest. We have made major changes to Jest which are going to benefit you and all of Facebook's JavaScript test infrastructure. Most importantly, we added static types to all of Jest's code during a recent Jest hackathon at Facebook. Fifteen people worked for a day and night to add [Flow](https://flowtype.org/) types to Jest and to add new features to Jest. The Flow types serve two purposes: First, we believe that code is written to be read. Most of the time, code is written only once but read by dozens of people over the course of years. Adding static types to the project helps document the code and helps explain some of the architecture in Jest. Second, adding static types makes maintenance easier and will allow us to more confidently refactor parts of Jest without fear of breakages.

The Flow project has evolved a lot within Facebook and has been successfully adopted across many of our frameworks and almost all of our product code. Adoption can be parallelized incredibly well – it can be done file-by-file until enough of the codebase is well-typed. Then, Flow provides real value and helps guide through large changes. Through this, many small edge cases and bugs were found.

<!--truncate-->

With the help of [lerna](https://github.com/lerna/lerna), we continued to modularize the Jest project. With just a small [update to the configuration](https://github.com/lerna/lerna#lernajson), Flow and lerna now get along well with each other. Splitting up Jest into packages helped us rethink module boundaries and enabled us to ship useful [packages](https://github.com/jestjs/jest/tree/main/packages) standalone: The `jest-runtime` and `jest-repl` cli tools now allow you to run scripts in a sandboxed Jest environment, enabling you to run and debug your app from the command line. This is especially helpful for projects that use Facebook's `@providesModule` module convention. To get started, just install `jest-repl` and run it in the same folder you normally run your tests in! We also published a `jest-changed-files` package that finds changed files in version control for either git or hg, a common thing in developer tools.

## New and improved features

- Added a notification plugin that shows a test run notification when using `--notify`.
- Added a `browser` config option to properly resolve npm packages with a browser field in `package.json` if you are writing tests for client side apps.
- Improved “no tests found message” which will now report which tests were found and how they were filtered.
- Added `jest.isMockFunction(jest.fn())` to test for mock functions.
- Improved test reporter printing and added a test failure summary when running many tests.
- Added support for mocking virtual modules through `jest.mock('Module', implementation, {virtual: true})`.
- Removed the `.haste_cache` folder. Jest now uses the operating system's preferred temporary file location.
- Added the duration of individual tests in verbose mode.
- Added the ability to record snapshots in Jest. We'll be publishing a separate blog post about this feature soon.

Finally, we have received a complete website redesign done by Matthew Johnston and added documentation for using [Jest with webpack](/docs/webpack). Happy Jesting!
