---
title: 2016 in Jest
authors: cpojer
---

2016 was a big year for JavaScript testing with Jest. In the first six months of the year we rewrote Jest and built a solid foundation to significantly improve performance and the developer experience of testing JavaScript code. We flow-typed the entire codebase, built a ton of integration tests for Jest itself and adopted [lerna](https://lernajs.io/) to turn Jest from a framework into a [_Painless JavaScript Testing platform_](https://github.com/jestjs/jest/tree/main/packages).

The newly created [react-test-renderer](https://yarnpkg.com/en/package/react-test-renderer) finally enabled testing of react-native components. Through the jest-react-native preset (now merged directly into react-native) Jest now works out of the box for any React project and comes pre-configured in [create-react-app](https://github.com/facebookincubator/create-react-app) and [react-native](https://github.com/facebook/react-native) projects. We integrated core pieces of Jest into [react-native's packager](https://github.com/facebook/react-native/tree/main/packager/react-packager/src) and the completely new snapshot testing feature has since been used outside of Jest: It was integrated with React Storybook as “[storyshots](https://github.com/storybooks/storyshots)” and is being adopted by other test runners like [ava](https://github.com/avajs/ava/pull/1113).

<!--truncate-->

The [pretty-format](https://github.com/jestjs/jest/tree/main/packages/pretty-format) project was rewritten with performance in mind to drive Jest's snapshot feature, was recently merged into Jest's monorepo and is also helpful in other [test runners](https://github.com/avajs/ava/pull/1154). Nowadays Jest is much more about collecting different ideas and solutions to testing than it is about one specific implementation of a test framework.

I'd like to deeply thank all the people that have [contributed to Jest this year](https://github.com/jestjs/jest/graphs/contributors?from=2016-01-01&to=2016-12-14&type=c), both from the open source community and at Facebook: Dmitrii Abramov, Cristian Carlesso, Dan Abramov, Daniel Lo Nigro, Maxim Derbin, Evan Scott, Forbes Lindesay, Keyan Zhang and 60 more people. We'd also like to welcome [Michał Pierzchała (@thymikee)](https://twitter.com/thymikee) as first official external contributor to Jest. He's been doing a great job managing the issues and PRs on the repo. If you'd like to start contributing to Jest, we have a bunch of [good first tasks](https://github.com/jestjs/jest/issues?q=is%3Aissue+is%3Aopen+label%3A%22good+first+bug%22) and we are always happy to help on our [discord channel](https://discord.gg/j6FKKQQrW9).

## [repl.it](http://repl.it/) with Jest integration

Amjad Massad [built a Jest container](https://repl.it/languages/jest) so you can now try out Jest directly in the browser. You can use it from now on when creating GitHub issues which should help troubleshoot problems more quickly. Amjad and Haya are building [repl.it](http://repl.it/) to democratize programming by building powerful yet simple tools and platforms for educators, learners, and developers. They are also [hiring talented engineers](https://repl.it/site/jobs)!

<div class="jest-repl">
  <iframe src="https://repl.it/languages/jest?lite=true"></iframe>
</div>

## Community Update

We feel incredibly humbled that 100+ companies [have adopted Jest](https://twitter.com/cpojer/status/803965499407290369) in the last six months. Companies like Twitter, Pinterest, Paypal, nytimes, IBM (Watson), Spotify, eBay, SoundCloud, Intuit, FormidableLabs, Automattic, Trivago and Microsoft have either fully or partially switched to Jest for their JavaScript testing needs. Thank you very much for giving this project a chance. We would also like to thank everyone who went to conferences and meetups to speak about Jest and to everyone who is writing blog posts about how Jest is or isn't working for them!

Here is what happened in the community in the last two months:

- Jason Bonta and Dmitrii Abramov [redefined the “testing pyramid”](https://twitter.com/abramov_dmitrii/status/805913874704674816) we were talking a lot about at Facebook.
- [jest-codemods](https://github.com/skovhus/jest-codemods#jest-codemods) now allows you to painlessly migrate from Mocha, Tape and Ava to Jest.
- The React team announced [improvements to the react-test-renderer](https://facebook.github.io/react/blog/2016/11/16/react-v15.4.0.html) in 15.4.0.
- Orta Therox build an amazing [vscode-jest integration](https://github.com/orta/vscode-jest#the-aim) and donated the code for editor support to Jest.
- Pavithra Kodmad is documenting [Flipkarts adoption of Jest](http://pksjce.github.io/2016/12/08/notes-on-jest) and shares some getting started tips.
- Kent C. Dodds wrote about [migrating to Jest at Paypal](https://medium.com/@kentcdodds/migrating-to-jest-881f75366e7e#.ticf0wchu) and Jason Brown [wrote about migrating to Jest as well](http://browniefed.com/blog/migrating-ava-to-jest/).
- Ben McCormick wrote about [saving time with Jest](http://benmccormick.org/2016/12/10/saving-time-with-jest/).
- Eric Clemmons wrote about [snapshots and storybook integration](https://medium.com/@ericclemmons/jest-snapshots-for-storybook-5bf36b5e5a3a).
- Edvin Erikson wrote about [getting Tap output in Jest](https://medium.com/@edvinerikson/getting-jest-output-in-tap-format-6e07dc2c484c#.1l4edixhl).
- [jest-html](https://github.com/guigrpa/jest-html#jest-html--) can bring snapshot diffing to your browser.
- There were a few [great conversations on hackernews](https://news.ycombinator.com/item?id=13128146) about Jest.
- The community started a great discussion about the [future of enzyme](https://github.com/airbnb/enzyme/issues/715).
- Ruben Oostinga wrote about [combining chai and Jest matchers](https://medium.com/@RubenOostinga/combining-chai-and-jest-matchers-d12d1ffd0303#.87si0ra2h).
- Emil Ong wrote about why [“TDD'ing your frontend seems pointless”](https://engineering.haus.com/why-tdding-your-frontend-feels-pointless-5f710fea7325#.pql79knnm).
- Nate Hunzaker wrote about [end-to-end testing with Jest and Nightmare](https://www.viget.com/articles/acceptance-testing-react-apps-with-jest-and-nightmare).
- [Using Jest with Angular just works](https://medium.com/aya-experience/testing-an-angularjs-app-with-jest-3029a613251#.h9badqevy) according to Matthieu Lux.
- A fantastic conversation about the [purpose of snapshot testing](https://github.com/jestjs/jest/issues/2197) is happening right now.
- Dmitrii made a new [music video with his metal band](https://twitter.com/abramov_dmitrii/status/806613542447157248).
- [lazyspec](https://yarnpkg.com/en/package/lazyspec) can help you create smoke tests quickly if you are introducing tests to an existing codebase.
- Patrick Stapfer did a lightning talk about [vim and Jest](https://twitter.com/ryyppy/status/803871975995277312).
- Mark Dalgleish was [commenting on the value of snapshot testing](https://twitter.com/markdalgleish/status/806608159527747584).

## New features, changes and fixes in Jest 17 & 18

Jest was initially created more than five years ago and as such an old framework it has accumulated some technical debt. This is why we tend to make breaking changes more often than may seem necessary: We believe it is important to incrementally reduce technical debt to ensure that Jest as a project stays maintainable long-term. We didn't announce Jest 17 in a blog post and if you haven't upgraded to it in the last month you may find the [changelog](https://github.com/jestjs/jest/blob/main/CHANGELOG.md) useful.

- **Breaking:** Removed `pit` in favor of `it` or `test` and `mockImpl` in favor of `jest.fn()` or `mockImplementation` .
- **Breaking:** Renamed `--jsonOutputFile` to `--outputFile`.
- **Breaking:** Updated `testRegex` to include `test.js` and `spec.js` files.
- **Breaking:** Replaced `scriptPreprocessor` with the new `transform` option.
- **Breaking:** The `testResultsProcessor` function is now required to return the modified results.
- **Potentially Breaking:** Properly resolve `snapshotSerializers`, `setupFiles`, `transform`, `testRunner` and `testResultsProcessor` with a resolution algorithm instead of using `path.resolve`. This mainly means that `<rootDir>` is no longer needed for these options.
- **Added:** `pretty-format` and `jest-editor-support` were merged into Jest.
- **Added:** `expect.any`, `expect.anything`, `expect.objectContaining`, `expect.arrayContaining`, `expect.stringMatching`.
- **Added:** `--testResultsProcessor` is now exposed through the cli.
- **Added:** Implemented file watching in `jest-haste-map`.
- **Added:** Usage of Jest in watch mode can be hidden through `JEST_HIDE_USAGE`.
- **Added:** `expect.assertions(number)` which will ensure that a specified amount of assertions is made in one test.
- **Added:** `.toMatchSnapshot(?string)` feature to give snapshots a name.
- **Added:** `toMatchObject`, `toHaveProperty` , `toHaveLength` matchers.
- **Added:** `expect.extend`.
- **Added:** Added support for custom snapshots serializers.
- **Added:** Big diffs are now collapsed by default in snapshots and assertions. Added `--expand` (or `-e`) to show the full diff.
- **Added:** `jest.resetAllMocks` which replaces `jest.clearAllMocks`.
- **Added:** `--json` now includes information about individual tests inside a file.
- **Fixed:** `test.concurrent` unhandled promise rejections.
- **Fixed:** `babel-plugin-jest-hoist` when using `jest.mock` with three arguments.
- **Fixed:** The `JSON` global in `jest-environment-node` now comes from the vm context instead of the parent context.
- **Fixed:** Jest does not print stack traces from babel any longer.
- **Fixed:** Fake timers are reset when `FakeTimers.useTimers()` is called.
- **Fixed:** Regular expressions are properly escaped in snapshots.
- **Fixed:** Improved pretty printing of large objects.
- **Fixed:** `NaN% Failed` in the OS notification when using `--notify`.
- **Fixed:** The first test run without cached timings will now use separate processes instead of running in band.
- **Fixed:** `Map`/`Set` comparisons.
- **Fixed:** `test.concurrent` now works with `--testNamePattern`.
- **Fixed:** Improved `.toContain` matcher.
- **Fixed:** Properly resolve modules with platform extensions on react-native.
- **Fixed:** global built in objects in `jest-environment-node` now work properly.
- **Fixed:** Create mock objects in the vm context instead of the parent context.
- **Fixed:** `.babelrc` is now part of the transform cache key in `babel-jest`.
- **Fixed:** docblock parsing with haste modules.
- **Fixed:** Exit with the proper code when the coverage threshold is not reached.
- **Fixed:** Jest now clears the entire scrollback in watch mode.
- **Deprecated:** `jest-react-native` was deprecated and now forwards `react-native`.

## Plans for Jest in H1 2017

Six months ago [we shared our plans for Jest](/blog/2016/07/27/jest-14#what-s-next-for-jest) and we are happy that we were able to execute well on almost all of them. For the next six months, here is what we are planning:

- **Instant feedback:** [Nuclide](https://nuclide.io/) integration and an improved and [faster watch mode](https://github.com/jestjs/jest/pull/2324#issuecomment-267149669).
- **Improved developer experience:** new mocking APIs and improved assertions.
- **Better performance and memory usage:** analyze Jest and be more conscious about efficiency.
- **Snapshot Improvements:** snapshot approval mode, syntax highlighting and improved `react-test-renderer` APIs.
- **Website:** We'll overhaul the website and documentation and add a Jest cheat sheet.

We won't be providing timelines or estimates for these features and we may not actually get to all of these things. If you'd like to help make these things a reality, send us issues and pull requests with your ideas and let's work on improving Jest together in 2017.
