---
title: A Great Developer Experience
authors: hramos
---

We strongly believe that great documentation is crucial to providing a great developer experience. The docs should be clear, concise, and useful to new users and veterans alike. With that in mind, we recently took some time to overhaul the Jest website.

## Improved docs

One of the changes you'll notice upon visiting our docs is the updated sidebar. The documentation is now divided into three main areas: an introduction to Jest, detailed guides to Jest's features, and a comprehensive API reference.

The **Introduction** section will guide you from installing Jest and writing your first case, to using Jest's matchers and testing async code. If you're new to Jest or need a quick refresher, these docs should get you up to speed in no time. If you've used Jest before and only need a quick reference on how it's installed, you need to go no further than the [Getting Started](/docs/getting-started) guide.

Once you feel comfortable using Jest, proceed to the advanced **Guides** section. The new [Snapshot Testing guide](/docs/snapshot-testing) covers everything you need to know about creating and maintaining snapshot test cases.

Finally, we've completely overhauled our API reference docs. You can now find detailed information on all of Jest's [Globals](/docs/api), [matchers](/docs/expect), and [every flag](/docs/cli) supported by the `jest` CLI.

<!--truncate-->

## New colors & website

The colors in the Jest logo and on the website have felt outdated to us for a while. We changed the color scheme we are using for Jest and changed the landing page significantly to be more inviting. We hope you like the new colors and showcase of Jest's strengths.

## Who's using Jest?

We have created a [showcase of users](/) to highlight some of the companies that are using Jest. We're thankful to all of these companies for using Jest to test their websites, mobile apps, and APIs. If you're using Jest, check out the guidelines on GitHub and send us a pull request!

<div class="productShowcaseSection">
 <div class="logos">
   <img src="/img/logos/twitter.png" title="Twitter"/>
   <img src="/img/logos/pinterest.png" title="Pinterest"/>
   <img src="/img/logos/paypal.png" title="PayPal"/>
   <img src="/img/logos/ibm.png" title="IBM"/>
   <img src="/img/logos/spotify.png" title="Spotify"/>
 </div>
</div>

## Jest in the browser

As highlighted [last month](/blog/2016/12/15/2016-in-jest), it is now possible to use Jest directly in the browser using [repl.it](https://repl.it/languages/jest). If you want to try out Jest before installing it, you can easily do so below or directly from the Jest homepage. Go ahead and give it a try!

<div class="jest-repl">
  <iframe src="https://repl.it/@amasad/try-jest?lite=true"></iframe>
</div>

## Get involved

This is just the start. Go ahead and take a look at the docs, and don't hesitate to send any feedback our way. If you find a mistake in the docs or you just want to let us know what needs to be documented better, please tweet at us at [@jestjs\_](https://twitter.com/jestjs_), [open an issue on GitHub](https://github.com/jestjs/jest/issues), or send us a PR by clicking "Edit on GitHub" at the top of the doc.

We're really excited for the year ahead and can't wait to hear from you!
