---
title: Supporting Jest Open Source
authors: rickhanlonii
---

Jest is maintained by a community of open source contributors and Facebook employees.

Our open source contributors work on behalf of the community to create new features, fix bugs, and maintain the issue backlog. Facebook employees do the same, focused on the problems specific to Facebook's scale, and run all proposed releases on Facebook's enormous test suite before publishing.

All of us do our part to make testing delightful.

At the Jest Summit we announced the Jest Open Collective. This is our way to help support the efforts of the open source Jest community. **To be absolutely clear: Facebook employees cannot benefit from the Jest Open Collective.** The collective's sole purpose is to support the open source side of the Jest community.

In this post we'll outline what the Jest Open Collective is, the structure, and the goals we have.

<!--truncate-->

## The Jest Open Collective

![Banner image for Jest Open Collective](/img/blog/collective.png)

Open Collective is a platform to manage groups of people transparently. Jest joins projects like [webpack](https://opencollective.com/webpack), [Babel](https://opencollective.com/babel), [Mocha](https://opencollective.com/mochajs), [Preact](https://opencollective.com/preact), [Vue](https://opencollective.com/vuejs), and many more in supporting the open source community through the Open Collective platform.

### What is the Jest Open Collective

The Jest Open Collective is a group of open source contributors who operate in full transparency to:

- Receive funds from backers and sponsors
- Approve expenses submitted by the community
- Give everyone visibility on the budget

### What is the structure of the collective

The Jest Open Collective is currently managed by three non-Facebook core contributors from the open source community:

- [Michal Pierzchala](https://twitter.com/thymikee)
- [Simen Bekkhus](https://github.com/simenb)
- [Rick Hanlon](https://twitter.com/rickhanlonii)

Michal has been an active Jest contributor since September 2016, Simen joined the core team in June 2017, and Rick joined in January. They're responsible for setting the budget, approving expenses, and managing admins of the collective. We have elected to keep [Christoph Nakazawa](https://twitter.com/cpojer) as an adviser.

There are two levels of support for the collective: Backer and Sponsor.

#### Backers

Backers of the collective are individuals contributing at least $2/month. We'll include a list of backers on the Jest homepage, README on github/yarn/npm, and Contributors page.

#### Sponsors

Sponsors of the collective are individuals and organizations contributing at least $100/month. We'll place sponsor logos with a link to their site on the Jest homepage, README on github/yarn/npm, and Contributors page.

### What is the goal of the collective

The goal of the collective is to support the work of open source contributors to Jest in order to make testing delightful.

To achieve that goal, we will use the funds to:

- Cover speaker travel expenses
- Host events and meetups
- Print and distribute swag
- Develop and fund a bug bounty program (TBD)

This is just the beginning and we're committed to getting this right. If you have ideas on how else we can support the community, or feedback on the structure of the collective, please reach out to us on [twitter](https://twitter.com/jestjs_)!

## Thank You

Finally, thank you to everyone who contributes to the Jest community and open source in general. We are incredibly grateful that we get the opportunity to work on improving JavaScript testing together.

The Jest core team would also like to make a special thank you to Facebook Open Source for driving the creation of this collective.
