---
title: 'Jest Website Upgrade'
authors: slorber
---

We are excited to present the **new Jest website**!

The Jest site was upgraded from **[Docusaurus 1](https://v1.docusaurus.io/)** to **[Docusaurus 2](https://v2.docusaurus.io/)**, and is an early adopter of the [newly released Docusaurus 2 i18n support](https://v2.docusaurus.io/blog/2021/03/09/releasing-docusaurus-i18n).

So, what's new exactly?

<!--truncate-->

## What's new?

Here's a good overview of the most visible improvements:

- **Dark Mode**: change the color scheme through the navbar switch.

- **Modern navigation**: we improved the navigation experience with **client-side routing** and **prefetching**.

- **Versions dropdown**: it is now simpler to switch from one Jest version to another.

- **Progressive-Web-App**: you can install the Jest website and browse it offline.

- **Search**: try the new Algolia **DocSearch v3** user-experience. It is now possible to **search in blog posts**.

- **I18n**: Jest is the first website using the **[new i18n feature of Docusaurus 2](https://v2.docusaurus.io/docs/i18n/introduction)**. It is now possible to **translate blog posts**.

- **MDX**: embedding React components in Markdown will allow maintainers to make the **documentation more interactive**.

## For site translators

If you want to help to translate the new Jest website, please use the new Crowdin project [jest-v2](https://crowdin.com/project/jest-v2) instead of the previous one.

:::note

In localized pages, the edit button now links directly to Crowdin.

:::

## Thanks

Thanks to all the contributors that supported or reviewed this migration: [Simen](https://github.com/SimenB), [Orta](https://github.com/orta), [Joel](https://github.com/JoelMarcey), [Kristoffer](https://github.com/merceyz)...

Please report any problem on the [migration issue](https://github.com/jestjs/jest/pull/11021).
