% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateThreshVsPerf.R
\name{plotROCCurves}
\alias{plotROCCurves}
\title{Plots a ROC curve using ggplot2.}
\usage{
plotROCCurves(obj, measures, diagonal = TRUE, pretty.names = TRUE,
  facet.learner = FALSE)
}
\arguments{
\item{obj}{(\link{ThreshVsPerfData})\cr
Result of \link{generateThreshVsPerfData}.}

\item{measures}{([list(2)` of \link{Measure})\cr
Default is the first 2 measures passed to \link{generateThreshVsPerfData}.}

\item{diagonal}{(\code{logical(1)})\cr
Whether to plot a dashed diagonal line.
Default is \code{TRUE}.}

\item{pretty.names}{(\code{logical(1)})\cr
Whether to use the \link{Measure} name instead of the id in the plot.
Default is \code{TRUE}.}

\item{facet.learner}{(\code{logical(1)})\cr
Weather to use facetting or different colors to compare multiple learners.
Default is \code{FALSE}.}
}
\value{
ggplot2 plot object.
}
\description{
Plots a ROC curve from predictions.
}
\examples{
\donttest{
lrn = makeLearner("classif.rpart", predict.type = "prob")
fit = train(lrn, sonar.task)
pred = predict(fit, task = sonar.task)
roc = generateThreshVsPerfData(pred, list(fpr, tpr))
plotROCCurves(roc)

r = bootstrapB632plus(lrn, sonar.task, iters = 3)
roc_r = generateThreshVsPerfData(r, list(fpr, tpr), aggregate = FALSE)
plotROCCurves(roc_r)

r2 = crossval(lrn, sonar.task, iters = 3)
roc_l = generateThreshVsPerfData(list(boot = r, cv = r2), list(fpr, tpr), aggregate = FALSE)
plotROCCurves(roc_l)
}
}
\seealso{
Other plot: \code{\link{createSpatialResamplingPlots}},
  \code{\link{plotBMRBoxplots}},
  \code{\link{plotBMRRanksAsBarChart}},
  \code{\link{plotBMRSummary}},
  \code{\link{plotCalibration}},
  \code{\link{plotCritDifferences}},
  \code{\link{plotLearningCurve}},
  \code{\link{plotPartialDependence}},
  \code{\link{plotResiduals}},
  \code{\link{plotThreshVsPerf}}

Other thresh_vs_perf: \code{\link{generateThreshVsPerfData}},
  \code{\link{plotThreshVsPerf}}
}
\concept{plot}
\concept{thresh_vs_perf}
