# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](http://keepachangelog.com/en/1.0.0/)
and this project adheres to [Semantic Versioning](http://semver.org/spec/v2.0.0.html).

## 2.15.1
### Fixed
- Fix old config removal

## 2.15.0
### Added
- Allow to have a private/internal /prometheus endpoint for some containers (QE-709)

## 2.14.0
### Fixed
- Security updates for docker-gen
- Vhost specific app-server or app_location should be deleted if non-existant in current dca
### Changed
- nohttps should just comment out the https section instead of delete it
- Use FDN DNS to prevent any surprise

## 2.13.0
### Fixed
- nginx versions between docker-gen and nginx container should be the same

## 2.12.0
### Changed
- Detect error on system service reload and restart it instead

## 2.11.0
### Fixed
- fix old docker compose python command. One can use `docker compose` or `docker-compose`.
### Changed
- Allow the reload command and deploy a bit faster (Added)
### Added
- Example app as DCA
- Instructions on how to local test this

## 2.10.1
### Fixed
- Fix hook chaining failed if one hook fails
- Also don’t resolve symbolic links, so hooks can rely on them (backup hook)

## 2.10.0
### Changed
- Per-environment configuration resource (QE-589)
- New compose-systemd version to `1.5.0`, allows to delay app start when node reboot

## 2.9.2
### Fixed
- `docker-gen` update

## 2.9.1
### Fixed
- Openssl PEM keys should be specified directly with header/footer/new lines

## 2.9.0
### Changed
- Allow to directly use openssl public keys for privileged deployement

## 2.8.0
### Fixed
- Fix `max_proc` not being taken into account in the installer
### Changed
- Security updates and docker-gen build and patch from source

## 2.7.0
### Changed
- Check for `vhost` validity before deploying.
- Check nginx config generated by `docker-gen` before sumbit
- Allow to specify `logging` key for a service.

## 2.6.2
### Fixed
- Updated `le-gen` image versions for security reason (version `2.1.3` is issue-free).

## 2.6.1
### Fixed
- Fix `rmdir` that was too soon in the installer
- Updated image versions (`le-gen` still need an still-unreleased upgraded version).

## 2.6.0
### Fixed
- Updated image versions.
- `compose-dirs` updated to version `1.4.0`.
### Changed
- `capp` can be tested in docker.
- More verbose tasks on `deploy`/`undeploy`.

## 2.5.0
### Fixed
- Fix `undeploy` command on non-existant app/env.
- Fix parsing metadata version on `undeploy`.
### Changed
- Do not use cache when using `build` command.

## 2.4.0
### Changed
- `build` command to force build and pull application services.
- better `exec` command, with multiple arguments supported and you can inject environment variables, change the working directory or the current user.

## 2.3.1
### Fixed
- Let’s encrypt companion update

## 2.3.0
### Fixed
- Security updates (docker images)
### Changed
- Support for multiple (ssh) keys per user (`listkey`, `addkey`, `delkey`)
- Support for `exec` action to enter an application service

## 2.2.0
### Changed
- Rights and user management
- Generate `authorized_keys` on login attempt
- Updated docker versions
- Pull images on deploy
- `/etc/capp/le_blacklist.txt` file to list host that should NOT be processed by Let's Encrypt

## 2.1.0
### Fixed
- Fix Hooks invocation (as-root, string-only parameters)
### Changed
- Usage of `verify_dca.py` in `capp`.
- Hash check on deploy is now a bit quicker and use less memory
- Hooks on deploy/undeploy action

## 2.0.0
### Changed
- DCA format version 2
