var couchdb = require('../couchdb'),
    logger = require('../logger'),
    argParse = require('../args').parse,
    url = require('url');


exports.summary = 'Returns UUIDs generated by a CouchDB instance';
exports.usage = '' +
'kanso uuids [OPTIONS] [URL]\n' +
'\n' +
'Parameters:\n' +
'  URL         The CouchDB instance to generate UUIDs from\n' +
'              (defaults to http://localhost:5984)\n' +
'\n' +
'Options:\n' +
'  -n [NUM], --number [NUM]    The number of UUIDs to generate (default: 1)';


exports.run = function (settings, args, commands) {
    var a = argParse(args, {
        'count': {match: ['--number','-n'], value: true}
    });
    var couchdb_url = a.positional[0] || 'http://localhost:5984';

    // /_uuids is at the root couchdb instance level, not the db level
    var parsed = url.parse(couchdb_url);
    delete parsed.pathname;
    delete parsed.query;
    delete parsed.search;
    var db = couchdb(url.format(parsed));

    db.uuids(a.options.count, function (err, uuids) {
        if (err) {
            return logger.error(err);
        }
        uuids.forEach(function (uuid) {
            console.log(uuid);
        });
        logger.clean_exit = true;
    });
};
