// import { defineConfig } from 'vitepress'
import { readFileSync } from 'node:fs'
import path from 'node:path'
import { URL } from 'node:url'
import { groupIconMdPlugin, groupIconVitePlugin } from 'vitepress-plugin-group-icons'
import llmstxt from 'vitepress-plugin-llms'
import { withMermaid } from 'vitepress-plugin-mermaid'
import { advanced, essentials, extraTopics, introduction, meta, plugin } from './contents.ts'

const __dirname = path.dirname(new URL(import.meta.url).pathname)

// https://vitepress.dev/reference/site-config
export default withMermaid({
  ...meta,
  lastUpdated: true,
  cleanUrls: true,

  head: [
    ['meta', { name: 'theme-color', content: '#468c56' }],
    ['link', { rel: 'icon', type: 'image/x-icon', href: '/favicon.png' }],
    ['meta', { property: 'og:type', content: 'website' }],
    ['meta', { property: 'og:locale', content: 'en' }],
    ['meta', { property: 'og:title', content: 'Gunshi | Modern javascript command-line library' }],
    ['meta', { property: 'og:image', content: 'https://gunshi.dev/og-image.png' }],
    ['meta', { property: 'og:site_name', content: 'Gunshi' }],
    ['meta', { property: 'og:url', content: 'https://gunshi.dev/' }],
    ['script', {}, readFileSync(path.resolve(__dirname, './banner.js'), 'utf8')]
  ],

  themeConfig: {
    // https://vitepress.dev/reference/default-theme-config
    logo: '/symbol.png',

    nav: [
      { text: 'Home', link: '/' },
      { text: 'Guide', link: '/guide/introduction/what-is-gunshi' },
      { text: 'API', link: '/api' },
      { text: 'Showcase', link: '/showcase' },
      { text: 'GitHub', link: 'https://github.com/kazupon/gunshi' }
    ],

    sidebar: [introduction, essentials, advanced, plugin, extraTopics],

    search: {
      provider: 'local'
    },

    socialLinks: [{ icon: 'github', link: 'https://github.com/kazupon/gunshi' }],

    footer: {
      message: 'Released under the MIT License.',
      copyright: 'Copyright © 2025 kazuya kawaguchi.'
    }
  },

  markdown: {
    config(md) {
      md.use(groupIconMdPlugin)
    }
  },

  vite: {
    optimizeDeps: {
      include: ['@braintree/sanitize-url', 'dayjs', 'debug', 'cytoscape-cose-bilkent', 'cytoscape']
    },
    resolve: {
      alias:
        process.env.NODE_ENV === 'production'
          ? undefined
          : {
              debug: path.resolve(
                __dirname,
                '../../../../node_modules/.pnpm/debug@4.4.3/node_modules/debug/src/browser.js'
              ),
              '@braintree/sanitize-url': path.resolve(
                __dirname,
                '../../../../node_modules/.pnpm/@braintree+sanitize-url@7.1.1/node_modules/@braintree/sanitize-url/dist/index.js'
              ),
              dayjs: path.resolve(
                __dirname,
                '../../../../node_modules/.pnpm/dayjs@1.11.18/node_modules/dayjs/esm/index.js'
              )
            }
    },

    plugins: [groupIconVitePlugin(), llmstxt()]
  },

  mermaid: { theme: 'forest' },
  mermaidPlugin: { class: 'mermaid my-class' }
})
