# Plugin List

Gunshi provides official plugins that address common CLI development needs. See [Using Plugins](./getting-started.md) for how to use plugins in your application.

## Official Plugins

### [@gunshi/plugin-global](https://github.com/kazupon/gunshi/tree/main/packages/plugin-global)

Adds global `--help` and `--version` options to all commands.

### [@gunshi/plugin-renderer](https://github.com/kazupon/gunshi/tree/main/packages/plugin-renderer)

Provides default rendering for usage, help text, and validation errors.

### [@gunshi/plugin-i18n](https://github.com/kazupon/gunshi/tree/main/packages/plugin-i18n)

Provides internationalization support for CLI applications.

### [@gunshi/plugin-completion](https://github.com/kazupon/gunshi/tree/main/packages/plugin-completion)

Provides shell completion functionality for bash, zsh, and fish.

## Community Plugins

<!-- eslint-disable markdown/no-missing-label-refs -->

> [!NOTE]
> Welcome your plugins! Submit a PR to add your plugin to this list.

<!-- eslint-enable markdown/no-missing-label-refs -->

## Where to Go From Here

- **Use official plugins**: Integrate these plugins into your CLI applications for enhanced functionality
- **Study implementations**: Review the source code of official plugins to learn implementation patterns
- **Create your own**: Apply what you've learned to build custom plugins for your specific needs
- **Share with the community**: Publish your plugins and submit a PR to add them to this list
