# MISP Project roadmap

The MISP Project roadmap is mostly based on the user communities (e.g. private communities, CSIRTs communities, security researchers, ISACs (Information Sharing and Analysis Centers), security providers, governmental or military organisations) relying on MISP to perform their duties of information sharing and analysis. 
The features in the MISP project are built from practical use-cases in information security, intelligence communities, incident response teams and fraud analysis groups. 

These groups provide their input via the different methods such as [GitHub](https://github.com/MISP/misp/issues)/[Gitter](https://github.com/MISP/misp/issues) issues, user groups, and discussions from MISP Summit and [MISP trainings](https://www.misp-project.org/events/). 
Some groups are actively taking part in developing the MISP project whilst many others contribute by providing bug reports, feature requests or proposals to enhance the project. 
As the various communities have common goals, the [MISP core team](https://github.com/orgs/MISP/teams/core/members) maintains the list of features and prioritises the implementation based on the impact and usefulness in the different groups and communities.

We track enhancements and [feature requests](https://github.com/MISP/MISP/issues?q=is%3Aissue+is%3Aopen+label%3A%22T%3A+feature+request%22+sort%3Acomments-desc) on GitHub, and tend to use the number of comments on feature request to prioritize the features that the community needs. If there's a feature you want to see in MISP, feel free to [create a feature request](https://github.com/MISP/MISP/issues/new?assignees=&labels=feature+request%2C+needs+triage&template=feature_request.md) or leave a comment on an existing related issue (if it exists). Better still, you can [implement the feature yourself](/CONTRIBUTING.md).

We do not do long term roadmaps on purpose. The problem of really long-term specific roadmaps is that people might end up expecting in something that turns out to be not really relevant for the community at large and is just posponed forever. Our priorities change frequently depending on:
- What threat of the month we are facing
- What small issue turns into an maintainable disaster
- What we fast track based on larger communities asking for it or paid developer support

That being said, we have a few general goals that we are currently working towards:
- Focusing on analyst tooling
- Reworking the software stack
- Improving usability
- Additional interconnections
