Changelog
=========


v2.4.153 (2022-02-04)
---------------------

New
~~~
- [UI] Show TLS version for server test. [Jakub Onderka]
- [security] Check TLSv1.3 connection. [Jakub Onderka]
- [oidc] Add new option: OidcAuth.authentication_method. [Jakub Onderka]
- [oidc] Add support for jakub-onderka/openid-connect-php OIDC fork.
  [Jakub Onderka]
- [CLI] admin configLint. [Jakub Onderka]
- [security] Allow to specify min_tls_version. [Jakub Onderka]
- [security] securityAuditTls. [Jakub Onderka]
- [CLI] Security audit. [Jakub Onderka]
- [form factory] added a div field type. [iglocska]

  - allows to create parametrised divs for additional placeholders
  - parameters are id, class, style, to be extended when needed
- [test] New audit. [Jakub Onderka]

Changes
~~~~~~~
- [version] bump. [iglocska]
- Fix findoriginaluuid typo. [Jeroen Pinoy]
- [oidc] Store user sid in session. [Jakub Onderka]
- [misp-objects] updated. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [internal] Add debugging for problematic push. [Jakub Onderka]
- [tools] communities.md generator works with new website. [Christophe
  Vandeplas]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [setting] Check if value is from options. [Jakub Onderka]
- [UI] Use number input for numeric setting. [Jakub Onderka]
- [internal] Do not call __evaluateLeaf for branch. [Jakub Onderka]
- [internal] Recommend to install pydeep2. [Jakub Onderka]
- [connection] Allow to define onConnect callback. [Jakub Onderka]
- [js:markdown-it] Update markdown-it library from version 11.0.0 to
  version 12.3.2. [Sami Mokaddem]
- [test] Use new link to install poetry. [Jakub Onderka]
- [test] Remove libfuzzy-dev package. [Jakub Onderka]
- [internal] Bump PyMISP to use pydeep2. [Jakub Onderka]
- [internal] Use pydeep2. [Jakub Onderka]
- [internal] Event report name is required. [Jakub Onderka]
- [security] Warn about unsupported OS. [Jakub Onderka]
- [internal] Fix session closing for dashboard widget. [Jakub Onderka]
- [internal] Remove useless session closing. [Jakub Onderka]
- [security] Avoid timing attacks for post validating. [Jakub Onderka]
- [internal] Remove random_compat. [Jakub Onderka]
- [internal] Do not modify session when not necessary. [Jakub Onderka]
- [cli] Deprecate `cake baseurl` command. [Jakub Onderka]
- [PyMISP] updated to the latest version. [Alexandre Dulaunoy]
- [CI] fixed installation. [Alexandre Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [i18n] Updated Thai (21%) [Steve Clement]
- [doc] Added php-curl to speed up composer. [Steve Clement]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [i18n] default.pot update. [Steve Clement]
- [i18n] Renamed Thai directory. [Steve Clement]
- [i18n] Added Thai, updated active language files. [Steve Clement]
- [i18n] Update pot files. [Steve Clement]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- [installer] Updated to latest, considering rhel8.4/8.5. [Steve
  Clement]
- [doc] Remove centos ref. [Steve Clement]
- [doc] Added rhel8.4 and rhel8.5. [Steve Clement]
- [installer] Latest installer to reflect doc changes. [Steve Clement]
- [installer] Latest installer to reflect doc changes. [Steve Clement]
- [doc] Removed CentOS ref. [Steve Clement]
- [doc] Updated docs and removed obsolete refs. [Steve Clement]
- [doc] Various CentOS9 references. [Steve Clement]

Fix
~~~
- [language] fix (exception text) [iglocska]
- [internal] Array to string conversion. [Jakub Onderka]
- [misp-stix] Same errors handling for STIX1 as it recently has been
  pushed for STIX2. [chrisr3d]
- [API key] shown on automation page when using classic keys. [iglocska]
- [misp-stix] Bumped latest version with enhanced parsing of objects
  which encountered parsing errors. [chrisr3d]

  - Instead of simply storing the error message, we
    also convert those objects as STIX Custom objects
- [misp-stix] Bumped latest version with a better exceptions handling
  for file, pe & pe-section objects converted to STIX2 file objects with
  a pebinary extension. [chrisr3d]
- [stix export] Fixed wrong indentation causing variable name errors.
  [chrisr3d]
- [misp-stix] Bumped latest version with a quick fix on Tags handling as
  STIX2 markings. [chrisr3d]
- [misp-stix] Bumped latest version with some fixes on the tags parsing.
  [chrisr3d]
- [internal] testForCABundle should return true. [Jakub Onderka]
- [stix] STIX test. [Jakub Onderka]
- [internal] Syntax error in PHP 7.2. [Jakub Onderka]
- [test] Do not force libpcre2 installation. [Jakub Onderka]
- [setting] Default value for MISP.require_password_confirmation is
  false. [Jakub Onderka]
- [appController:loginByAuthkey] Skip authentication with basic
  authorization. [Sami Mokaddem]

  Fix #7576.
  Basic Auth might happen for some setup where the authentication is performed by another component such as LDAP.
  For these cases, the Authorization header is present and contains the Basic Auth data used by the authentication plugin. Before this patch, MISP failed to resolve the API key to a user and threw a 403. This was because MISP detected the presence of the Authorization header which triggered an authentication by Authkey that would always fail as the content is not a valid API key.
- [event add] resolved notice error when viewing the event add form.
  [iglocska]

  - converted the html div added as a field to a proper factory field
- [audit] Send IP address to ZMQ in full form. [Jakub Onderka]
- Supervisord_status showing as a worker when its not. [Luciano
  Righetti]
- [CLI] Authkey valid - reconnect in case of failure. [Jakub Onderka]
- Fix: add flag to update deps as suggested by @hlijan. [Luciano
  Righetti]
- Bug defaulting source_format instead of fixed_event on /feeds/add
  endpoint. [Luciano Righetti]
- [UI] Fix authkey field type. [Jakub Onderka]
- [internal] Closing session for statistics. [Jakub Onderka]
- Fix: unix timestamps should have a @ prefix. [Luciano Righetti]
- Make SimpleBackgroundJobs work on RHEL 7 with
  supervisorphp/supervisor:^3.0. [Richard van den Berg]
- Change simple bg jobs settings to critical, fix notice in server
  shell. [Luciano Righetti]
- [stix1 export] Removed unused imports. [chrisr3d]
- [stix2 import] Fixed wrong variable name. [chrisr3d]
- [misp-stix] Bumped latest fixed version of the library. [chrisr3d]

  - Includes fixes on the usage of orgnames during
    a STIX 1 export:
    - The orgname used to define the information
      source and the reporter identity remains
      the same
    - The orgname used to define every STIX object
      id is sanitized to comply with the STIX
      validation process
- [CI] libpcre2 issue. [Alexandre Dulaunoy]
- Error later on when json enconding a binary repr ipv6. [Luciano
  Righetti]
- [i18n] Typo. [Steve Clement]
- [typo] check - not chech. [Steve Clement]
- [galaxyclusters] view by uuid fixed. [iglocska]
- [typo] tagID. [Steve Clement]
- Fix: unix timestamps should have a @ prefix. [Luciano Righetti]

Other
~~~~~
- Merge branch 'develop' into 2.4. [iglocska]
- Merge pull request #8129 from Wachizungu/fix-findoriginaluuid-typo.
  [Alexandre Dulaunoy]

  chg: fix findoriginaluuid typo
- Merge pull request #8118 from JakubOnderka/new-oidc. [Jakub Onderka]

  chg: [oidc] Store user sid in session
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge pull request #8123 from JakubOnderka/event-push-debug. [Jakub
  Onderka]

  fix: [internal] Array to string conversion
- Merge branch '2.4' of https://github.com/MISP/MISP into develop.
  [chrisr3d]
- Merge branch 'develop' of https://github.com/MISP/MISP into develop.
  [chrisr3d]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' of https://github.com/MISP/MISP into develop.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of https://github.com/MISP/MISP into develop.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge pull request #8120 from JakubOnderka/event-push-debug. [Jakub
  Onderka]

  chg: [internal] Add debugging for problematic push
- Merge branch '2.4' of https://github.com/MISP/MISP into develop.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge pull request #8109 from JakubOnderka/tls-debug. [Jakub Onderka]

  TLS connection debug
- Merge pull request #8117 from JakubOnderka/new-oidc. [Jakub Onderka]

  new: [oidc] Add support for jakub-onderka/openid-connect-php OIDC fork
- Merge branch '2.4' of https://github.com/MISP/MISP into develop.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into develop.
  [chrisr3d]
- Merge branch 'develop' of https://github.com/MISP/MISP into develop.
  [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into develop. [chrisr3d]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [chrisr3d]
- Merge pull request #8107 from JakubOnderka/settings-lint. [Jakub
  Onderka]

  Settings lint
- Merge pull request #8106 from JakubOnderka/stix-test. [Jakub Onderka]

  Stix test
- Merge pull request #8105 from JakubOnderka/min_tls_version. [Jakub
  Onderka]

  new: [security] Allow to specify min_tls_version
- Merge pull request #8089 from JakubOnderka/security-audit-cli. [Jakub
  Onderka]

  new: [CLI] Security audit
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge pull request #8100 from JakubOnderka/pydeep2. [Jakub Onderka]

  chg: [internal] Bump PyMISP to use pydeep2
- Merge pull request #8098 from JakubOnderka/zmq-audit-ip-address.
  [Jakub Onderka]

  fix: [audit] Send IP address to ZMQ in full form
- Merge pull request #8099 from JakubOnderka/pydeep2. [Jakub Onderka]

  chg: [internal] Use pydeep2
- Merge branch '2.4' into develop. [Luciano Righetti]
- Merge pull request #8065 from fandigunawan/2.4. [Jakub Onderka]

  fix: Removes debug print in AWS S3 Client
- Removes debug print. [Fandi Gunawan]
- Merge pull request #8067 from righel/issue-8064. [Andras Iklody]

  fix: supervisord_status showing as a worker when its not
- Merge pull request #8086 from JakubOnderka/event-report-name-required.
  [Jakub Onderka]

  chg: [internal] Event report name is required
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge branch '2.4' into develop. [Steve Clement]
- Merge pull request #8072 from JakubOnderka/fix-authkeys-valid. [Jakub
  Onderka]

  fix: [CLI] Authkey valid - reconnect in case of failure
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge pull request #8069 from JakubOnderka/security-audit-old-os.
  [Jakub Onderka]

  chg: [security] Warn about unsupported OS
- Merge pull request #8061 from JakubOnderka/authkey-input. [Jakub
  Onderka]

  fix: [UI] Fix authkey field type
- Merge pull request #7986 from JakubOnderka/better-security. [Jakub
  Onderka]

  chg: [internal] Do not modify session when not necessary
- Merge branch '2.4' into develop. [Steve Clement]
- Merge pull request #8052 from RichieB2B/ncsc-nl/supervisor. [Luciano
  Righetti]

  Make supervisor connector work with supervisorphp/supervisor 3
- Merge pull request #8053 from righel/improve-simple-bg-jobs-settings.
  [Luciano Righetti]

  Improve SimpleBackgroundJobs settings
- Add: add migration guide to docs. [Luciano Righetti]
- Merge pull request #8039 from JakubOnderka/cake-baseurl-deprecated.
  [Jakub Onderka]

  chg: [cli] Deprecate `cake baseurl` command
- Merge branch '2.4' of https://github.com/MISP/MISP into develop.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into develop.
  [chrisr3d]
- Merge pull request #8092 from DCSO/fix/linotp-throw2. [Alexandre
  Dulaunoy]

  LinOTP minor fixes
- [chg] LinOTP default baseURL. [Hendrik Baecker]
- [chg] Make LinOTP configurable via webui and cli. [Hendrik Baecker]
- [chg] Add link to LinOTP selfservice. [Hendrik Baecker]
- [chg] Improved LinOTP error handling. [Hendrik Baecker]

  Matches if ssl verify fails for example
- Merge pull request #8096 from righel/fix-issue-8093. [Luciano
  Righetti]

  fix: error later on when json enconding a binary repr ipv6
- Merge pull request #8091 from SteveClement/i18n. [Steve Clement]
- Merge pull request #8084 from SteveClement/i18n. [Steve Clement]
- Merge pull request #8083 from SteveClement/guides. [Steve Clement]
- Merge remote-tracking branch 'origin' into guides. [Steve Clement]
- Merge branch 'MISP:2.4' into 2.4. [Steve Clement]
- Merge branch 'MISP:2.4' into 2.4. [Steve Clement]
- Merge pull request #5 from SteveClement/guides. [Steve Clement]
- Merge pull request #8082 from SteveClement/i18n. [Steve Clement]
- Merge pull request #8080 from SteveClement/i18n. [Steve Clement]
- Merge pull request #8079 from SteveClement/i18n. [Steve Clement]
- Merge pull request #8075 from SteveClement/i18n. [Steve Clement]
- Merge pull request #8074 from SteveClement/i18n. [Steve Clement]
- Merge pull request #8068 from StefanKelm/2.4. [Luciano Righetti]

  fix wording
- Update Server.php. [StefanKelm]

  fix wording
- Merge pull request #8059 from SteveClement/guides. [Steve Clement]
- Merge pull request #8058 from SteveClement/guides. [Steve Clement]
- Merge pull request #8056 from SteveClement/guides. [Steve Clement]
- Add: add migration guide to docs. [Luciano Righetti]


v2.4.152 (2021-12-22)
---------------------

New
~~~
- [CLI] user authkey_valid command. [Jakub Onderka]
- [tag] Generate predictable tag color. [Jakub Onderka]
- [server:synchronisation] Type filtering during PULL synchronisation.
  [Sami Mokaddem]
- [event-timeline] Support of image attachments. [Sami Mokaddem]
- [CLI] Get authkey info by `cake user authkey` [Jakub Onderka]
- [securityAudit] Check expose_php setting. [Jakub Onderka]
- [test] Exports. [Jakub Onderka]
- [securityAudit] Check if xdebug is enabled. [Jakub Onderka]
- [bg] Support unix socket for supervisord. [Jakub Onderka]
- [internal] Use pubToZmq to check if publish to ZMQ. [Jakub Onderka]

Changes
~~~~~~~
- [misp-stix] Bumped latest version of the library. [chrisr3d]
- [security audit] fixed failures on kernel compilation time. [iglocska]

  - currently the check makes a lot of invalid assumptions, made it more lax to fail gracefully
- [PyMISP] Bump version. [Raphaël Vinot]
- [version] bump. [iglocska]
- [Python] Use pymisp from pypi. [Raphaël Vinot]
- [internal] Make JSONConverterTool method static. [Jakub Onderka]
- [rephrasing] some warnings. [iglocska]
- [server:edit] Display object name for both sync mechanisms. [Sami
  Mokaddem]

  Even though I said I won't do it
- [server:edit] Include the object name in addition to the template UUID
  for PUSH. [Sami Mokaddem]

  The name of the object could be unknown by the instance for PULL so we keep it on the old behavior.
- [server:pull] Do not log empty event entries if it was cause by the
  rules. [Sami Mokaddem]
- [servers:index] Improved UI. [Sami Mokaddem]

  Only show blocked attribute types/objects if setting is turned on
- [server:synchronisation] Usage of template_uuid instead of the object
  name. [Sami Mokaddem]
- [server:synchronisation] Tpye filtering duringg PUSH synchronisation.
  [Sami Mokaddem]

  Split type on attributes and objects
- [pip] unused and broken Pipfile.lock (old conflict merged) [Alexandre
  Dulaunoy]
- [app] Bumped query version. [Sami Mokaddem]
- [event:timeline] Fit timeline after initial load. [Sami Mokaddem]
- [feeds] Support for sharing groups with feeds, fixes #5758.
  [Christophe Vandeplas]
- Allow change disable_correlation in mass edit attributes. [Luciano
  Righetti]
- [internal] Log when attribute was dropped. [Jakub Onderka]
- [auditLog] Fetch field required for model info. [Jakub Onderka]
- [internal] Add job ID to worker. [Jakub Onderka]
- [internal] Lazy load images. [Jakub Onderka]
- [internal] Avoid calling unnecessary method. [Jakub Onderka]
- [internal] Slightly optimise OrgImgHelper. [Jakub Onderka]
- [internal] Element file cache. [Jakub Onderka]
- [internal] Move some checks to beforeRender method. [Jakub Onderka]
- [internal] Faster sending images. [Jakub Onderka]
- [internal] Slightly optimise CakeResponseTmp. [Jakub Onderka]
- [securityAudit] PHP 7.3 is not supported anymore. [Jakub Onderka]
- [internal] testForBinExec cleanup. [Jakub Onderka]
- [internal] Optimise setting. [Jakub Onderka]
- [upload] Allow to upload SVG files. [Jakub Onderka]
- [internal] Simplify index.php. [Jakub Onderka]
- [CLI] Initialize BackgroundJobsTool just when required. [Jakub
  Onderka]
- [internal] New method ProcessTool::whoami. [Jakub Onderka]
- [export] Cleanup code for OpeniocExport and YaraExport. [Jakub
  Onderka]
- [stix] Simplified STIX export code. [Jakub Onderka]
- [internal] Use ProcessTool in Sighting. [Jakub Onderka]
- [internal] Use ProcessTool in Exports. [Jakub Onderka]
- [bg] Move logging to one place. [Jakub Onderka]
- [process] No need to close pipes. [Jakub Onderka]
- [diagnostics] Check also MISP.attachments_dir and MISP.tmpdir folders.
  [Jakub Onderka]
- [securityAudit] Show warning if encryption key is not set. [Jakub
  Onderka]
- [internal] Remove unused variable. [Jakub Onderka]
- [internal] Convert array to const in QueryTool. [Jakub Onderka]
- [internal] Convert array to const in Warninglist. [Jakub Onderka]
- [internal] Convert array to const in RestResponseComponent. [Jakub
  Onderka]
- [internal] Convert array to const in ACLComponent. [Jakub Onderka]
- [internal] Fix typo. [Jakub Onderka]
- [internal] Remove unused methods. [Jakub Onderka]
- [internal] Convert array to const. [Jakub Onderka]
- [internal] Convert strings to const. [Jakub Onderka]
- [internal] Convert array to const. [Jakub Onderka]
- [internal] Convert array in log to const. [Jakub Onderka]
- [internal] Convert array to const. [Jakub Onderka]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy] updated. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [backwards] compatibility. [iglocska]

  - reverted a strict typed function parameter check to appease the legacy gods
- [installer] Update to latest version. [Steve Clement]
- [doc] Minor error on rhel version. [Steve Clement]
- [misp-galaxy] updates. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [warninglists] updated. [Alexandre Dulaunoy]
- [pip] unused and broken Pipfile.lock (old conflict merged) [Alexandre
  Dulaunoy]
- [installer] Update to latest version. [Steve Clement]
- [doc] endpoint.com is now enpointdev.com. [Steve Clement]
- [misp-stix] Bumped latest version. [chrisr3d]
- Add dicussions link. [Luciano Righetti]
- Use issue forms templates with required fields. [Luciano Righetti]
- [taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [stix export] Merging all the differents changes at different places
  to support every type of collection export as STIX 1 & 2. [chrisr3d]
- [stix1 export] Better parsing with a separation between events and
  attributes collections export. [chrisr3d]
- [stix] allow passing the publish flag to the stix upload. [iglocska]
- [stix1 export] Making STIX1 attributes export parser available.
  [chrisr3d]

Fix
~~~
- [stix1 export] Ordering object types to avoid validation issues.
  [chrisr3d]

  - STIX validator seems to dislike `Observables`
    objects coming after `Indicators`, so we put
    the object types in the order they are presented
    in the documentation
- [event:checkDistributionForPush] typos. [Richard van den Berg]
- [event:uploadEventSightingsToServersRouter] use Event model for
  Sighting context. [Richard van den Berg]
- [event:uploadEventSightingsToServersRouter] allow sightings to be
  pushed upstream. [Richard van den Berg]
- [server:add] Pass the correct variables to the view. [Sami Mokaddem]
- [event:push] Unset attribute before processing it and nesting typo.
  [Sami Mokaddem]
- [server:pull] Typo in objectAttribute filtering. [Sami Mokaddem]
- [server:edit] Extra field in group by leading to object duplication.
  [Sami Mokaddem]
- [server:edit] Typo synchronisation. [Sami Mokaddem]
- [server:pull] Typo while unsetting attribute blocked by filtering
  rule. [Sami Mokaddem]
- [events:synchronisation] debug and typos. [Sami Mokaddem]
- [servers:edit] Capture filtering freetext tags for PUSH. [Sami
  Mokaddem]
- [tools:timeline] Usage of correct UUID and disabled polling
  extrapolation. [Sami Mokaddem]

  This half baked feature was making thing confusing for the users. If we ever need it implemented it should be something more robust and configurable.
- Do not try to autocomplete with users authkey. [Luciano Righetti]
- Publishtimestamp defaults. [Luciano Righetti]
- Array to string notice. [Luciano Righetti]
- Typos, bump js version. [Luciano Righetti]
- Datetime format. [Luciano Righetti]
- Revert change. [Luciano Righetti]
- Use from/until input in UI filters. [Luciano Righetti]
- Notice when filter is array. [Luciano Righetti]
- Show error message instead of fatal error when diagnostics tool fails
  to run. [Luciano Righetti]
- [UI] Ajax forms lose persistence. [iglocska]

  - generic Form builder now has the persistence baked in
  - capture all form fields' data before submiting as expected
- [feeds] i18n some strings. [iglocska]
- [feeds] preview attribute distribution. [iglocska]

  - escape sharing group name
- Wrong params. [Luciano Righetti]
- Improve error handling when supervisor is not available or connection
  settings are wrong. [Luciano Righetti]
- [internal] Fixes #7961. [Jakub Onderka]
- [UI] Adding attributes to object. [Jakub Onderka]
- [tools:backgroundjob] Support of legacy systems (3) [Sami Mokaddem]
- [tools:backgroundjob] Support of legacy systems (2) [Sami Mokaddem]
- [backgroundjob] Support of legacy system. [Sami Mokaddem]
- [test] Ignore beforeRender function. [Jakub Onderka]
- [internal] Deleting events. [Jakub Onderka]
- [internal] Old style view class. [Jakub Onderka]
- [security] Disable caching of images. [Jakub Onderka]
- [CLI] Show error when calling methods for managing workers when
  SimpleBackgroundJobs are enabled. [Jakub Onderka]
- [internal] Fix checking if system is Linux. [Jakub Onderka]
- [internal] User ProcessTool for selfTest. [Jakub Onderka]
- [auditlog] Array converted to const. [Jakub Onderka]
- [auditLog] Warning when deleting event. [Jakub Onderka]
- [internal] Remove UrlCache. [Jakub Onderka]
- ServerShell fails if SimpleBackgroundJobs config does not exists.
  [Luciano Righetti]
- Update dep for fixing php74 build. [Luciano Righetti]
- [misp-stix] Bumped latest version with up-to-date dependencies &
  requirements. [chrisr3d]
- [stix export] Added parameters to the temporary files deleting
  function. [chrisr3d]

  - Can delete output files when we get an exception
    from the python scirpt
  - Can delete a specific list of files that are not
    suffixed with a '.out' extension, like it is the
    case for attributes collections export as STIX 1
- [stix export] Removed unused variables. [chrisr3d]
- [stix export] Copy paste issue from merge conflict handling.
  [chrisr3d]
- [stix1 export] Syntax typo from merge conflict handling. [chrisr3d]
- [API] downloadAttachment API user object fetching fixed. [iglocska]

  - user is already in session, just reuse it
- [feeds] pulling freetext feed sets attribute distribution, fixes
  #7992. [iglocska]

  - should just inherit the event's setting
  - when using sharing groups this becomes a serious issue
- [audit] fix user modifications not working with the modern audit log.
  [iglocska]

  - trying to get the old state of non persistent form fields breaks
- [stix1 export] Removed debugging print. [chrisr3d]
- [stix2 export] Added the required traceback parameter to the
  `print_tb` call. [chrisr3d]
- [upload_stix] Going back to the previous  way of handling files before
  we properly merge `develop` and this branch together. [chrisr3d]

  - The publish flag added in `develop` remains here
    but we come back to the previous way of handling
    the input file, like before we cherry-picked the
    commit containing the changes concerning the
    publish flag.
- [misp-stix] Bumped latest version. [chrisr3d]
- [stix export] Removing traceback parsing since it is handled in
  stderr. [chrisr3d]
- [stix export] Keeping traceback messages for the logs. [chrisr3d]
- [stix export] Making sure the error message is displayed when there is
  no input file. [chrisr3d]
- [stix1 export] Indentation issues caused STIX1 result files not to be
  written. [chrisr3d]
- [stix export] Displaying errors with their traceback. [chrisr3d]
- [stix2 export] Removed unnecessary loop split. [chrisr3d]
- [stix2 export] Removed separator that should not be set here.
  [chrisr3d]
- [stix export] Typo on a class variable. [chrisr3d]
- [stix export] Better galaxies & clusters handling when dealing with
  attributes collections. [chrisr3d]

  - We skip some fields from galaxies and clusters,
    as well as adding the event timestamp that is
    going to be used when exporting event galaxies

Other
~~~~~
- Merge branch 'develop' into 2.4. [iglocska]
- Merge branch 'develop' of https://github.com/MISP/MISP into develop.
  [chrisr3d]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch 'misp-stix' of https://github.com/MISP/MISP into develop.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into develop.
  [chrisr3d]
- Merge pull request #8047 from RichieB2B/ncsc-nl/sightings-dist.
  [Alexandre Dulaunoy]

  Fix typos
- Merge pull request #8046 from RichieB2B/ncsc-nl/sightings-dist.
  [Andras Iklody]

  Use Event model for Sighting context
- Merge pull request #8045 from RichieB2B/ncsc-nl/sightings-dist.
  [Andras Iklody]

  Allow sightings to be pushed upstream
- Merge branch 'develop' into 2.4. [iglocska]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge branch '2.4' of https://github.com/MISP/MISP into develop.
  [chrisr3d]
- Merge branch 'develop' into 2.4. [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch 'develop' into 2.4. [iglocska]
- Merge branch '8042' into develop. [iglocska]
- LinOTP: nitpicking and failsafe. [Hendrik Baecker]

  Also one CodeFactor fix
- [chg] Ensure 'false' if LinOTP Request fails. [Hendrik Baecker]
- [chg] Establish 'mixedauth' [Hendrik Baecker]

  mixedauth=false: Only query LinOTP for OTP (or OTP-Pin+OTP Value)
  mixedauth=true: Use MISP Userbase for Passwordchecking AND LinOTP for second factor

  mixedauth=true will throw exceptions if OTP doesn't match to not fall back
  to FormAuthenticate from MISP - which would get the 2FA useless.
- [chg] Extract otp from request. [Hendrik Baecker]
- [chg] Fix typos. [Hendrik Baecker]
- [chg] Adjust handling LinOTP response. [Hendrik Baecker]
- [chg] Add OTP Form Field if LinOTP active. [Hendrik Baecker]
- [chg] added LinOTP to configs. [Hendrik Baecker]
- [chg] no more php-curl but cake socket. [Hendrik Baecker]
- [chg] Safe LinOTP Config. [Hendrik Baecker]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [Alexandre Dulaunoy]
- Merge branch 'develop' of https://github.com/MISP/MISP into develop.
  [chrisr3d]
- Merge branch '2.4' into develop. [iglocska]
- Merge pull request #8027 from JakubOnderka/cli_authkey_valid. [Jakub
  Onderka]

  new: [CLI] user authkey_valid command
- Merge pull request #8025 from JakubOnderka/predicatable-tag-color.
  [Jakub Onderka]

  new: [tag] Generate predictable tag color
- Merge pull request #8028 from JakubOnderka/json-convertor-static.
  [Jakub Onderka]

  chg: [internal] Make JSONConverterTool method static
- Merge branch 'sync_filter' into develop. [iglocska]
- Merge branch 'develop' of github.com:MISP/MISP into feature-sync-type-
  filtering. [Sami Mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into develop. [Alexandre
  Dulaunoy]
- Merge branch '2.4' into develop. [Steve Clement]
- Merge branch '2.4' into develop. [iglocska]
- Merge pull request #8019 from righel/add_events_time_filter. [Luciano
  Righetti]

  new: add events index time ui filters
- Add: timestamp and publish_timestamp filters and optional columns to
  /events/index. [Luciano Righetti]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge pull request #7997 from righel/avoid-fatals-in-settings-
  diagnostics. [Alexandre Dulaunoy]

  fix: show error message instead of fatal error when diagnostics tool …
- Merge branch 'sg_feeds' into develop. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into develop. [Alexandre
  Dulaunoy]
- Merge pull request #7996 from JakubOnderka/cli-authkey. [Jakub
  Onderka]

  new: [CLI] Get authkey info by `cake user authkey`
- Merge pull request #7967 from
  righel/toggle_correlation_mass_edit_attributes. [Luciano Righetti]

  chg: allow change disable_correlation in mass edit attributes
- Merge pull request #7994 from righel/fix-issue-7988. [Luciano
  Righetti]

  fix: improve error handling when supervisor is not available or conne…
- Merge pull request #7993 from JakubOnderka/fix-7961. [Jakub Onderka]

  fix: [internal] Fixes #7961
- Merge pull request #7991 from JakubOnderka/fix-7987. [Jakub Onderka]

  chg: [internal] Log when attribute was dropped
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge pull request #7975 from JakubOnderka/process-tool-selftest.
  [Jakub Onderka]

  Process tool selftest
- Merge pull request #7577 from JakubOnderka/add-event-cleanup. [Jakub
  Onderka]

  chg: [internal] Convert array to const
- Revert "chg: [logbehaviour] skipfields reverted to an array from a
  constant" [Jakub Onderka]

  This reverts commit 9d7da3103fb935c3c98c6c3c136e3a8f1a78614f.
- Merge pull request #7984 from JakubOnderka/fix-audit-log. [Jakub
  Onderka]

  fix: [auditLog] Warning when deleting event
- Merge pull request #7974 from JakubOnderka/url-cache. [Jakub Onderka]

  fix: [internal] Remove UrlCache
- Merge pull request #7981 from righel/fix-php-7.4-build. [Luciano
  Righetti]

  fix: update dep for fixing php74 build
- Merge branch 'develop' into fix-php-7.4-build. [Luciano Righetti]
- Merge branch 'misp-stix' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into misp-stix.
  [chrisr3d]
- Merge pull request #8037 from SteveClement/guides. [Steve Clement]

  chg: [doc] Minor error on rhel version
- Merge pull request #8035 from SteveClement/guides. [Steve Clement]
- Add: [stix1 export] Supporting specific framing for attributes
  collections export. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into misp-stix.
  [chrisr3d]
- Merge pull request #8008 from righel/add-issues-form-templates.
  [Alexandre Dulaunoy]

  chg: use issue forms templates with required fields
- Merge pull request #7995 from coolacid/WordWrap. [Jakub Onderka]

  fix: Autocrypt email header force RFC 5322 - 2.1.1 line length limits
- RFC 5322 - 2.1.1 line length limits. [Jason Kendall]

  Use '\r\n' instead of PHP_EOL

  Use '\r\n' instead of PHP_EOL
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch 'misp-stix' of https://github.com/MISP/MISP into misp-
  stix. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into misp-stix. [chrisr3d]
- Merge branch 'misp-stix' of github.com:MISP/MISP into misp-stix.
  [chrisr3d]
- Merge branch 'misp-stix' of github.com:MISP/MISP into misp-stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into misp-stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into misp-stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into misp-stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into misp-stix.
  [chrisr3d]
- Wip: [stix export] Adding stix various formats in the list of valid
  formats for attributes restSearch. [chrisr3d]
- Wip: [stix export] First implementation of an attributes restSearch
  export as STIX 1 & 2. [chrisr3d]

  - More testing, and changes on other parts of the
    process to come as well


v2.4.151 (2021-11-23)
---------------------

New
~~~
- [internal] Faster caching. [Jakub Onderka]
- [user] Add sub field for user. [Jakub Onderka]
- [CLI] For redisMemoryUsage show also server cache size. [Jakub
  Onderka]
- Support existing worker controls via supervisor api. [Luciano
  Righetti]
- Add default config for new background jobs (disabled). [Luciano
  Righetti]
- [CLI] Redis memory usage diagnostics. [Jakub Onderka]
- [CLI] admin reencrypt command. [Jakub Onderka]
- [security] Store authkeys for servers encrypted. [Jakub Onderka]
- [UI] Define custom right menu link. [Jakub Onderka]
- [CLI] Allow to set setting value to `null` [Jakub Onderka]
- [internal] Save to config file just what was in file. [Jakub Onderka]
- [internal] encryption_key config. [Jakub Onderka]
- [internal] Fix when authkey is invalid. [Jakub Onderka]
- [internal] BetterSecurity tool. [Jakub Onderka]
- [setting] Allow to encrypt setting. [Jakub Onderka]
- [setting] Add new MISP.system_setting_db setting. [Jakub Onderka]
- Store system settings in database. [Jakub Onderka]
- [MISP fetcher] added to create an offline update package. [iglocska]
- [doc] Initial php8.0 and Ubuntu 22.04. [Steve Clement]
- [test] test_add_duplicate_tags. [Jakub Onderka]
- [test] test_log_new_audit. [Jakub Onderka]
- [test] test_restsearch_event_by_tags. [Jakub Onderka]
- [settings] Allow to use ThreatLevel.name for alert filter. [Jakub
  Onderka]
- [API] Return JSON for server index preview. [Jakub Onderka]
- [CLI] New task for removeOrphanedCorrelations and optimiseTables.
  [Jakub Onderka]
- [attribute type] ssh-fingerprint - a fingerprint of SSH key material.
  [Alexandre Dulaunoy]
- [attribute type] ssh-fingerprint - a fingerprint of SSH key material.
  [Alexandre Dulaunoy]
- [test] test_deleted_attributes. [Jakub Onderka]
- [CLI] Assign UserSetting to list output. [Jakub Onderka]
- [oidc] User setting for oidc metadata. [Jakub Onderka]
- [test] test_delete_event_blocklist. [Jakub Onderka]
- [sync] Server sync logging. [Jakub Onderka]
- [test] test_search_index_by_all. [Jakub Onderka]

Changes
~~~~~~~
- [version] bump. [iglocska]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- Bump PyMISP. [Raphaël Vinot]
- [warning-lists] updated. [Alexandre Dulaunoy]
- [taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [submodule update] added --init --recursive. [iglocska]
- [internal] Add BACKGROUND_JOB_ID to new process. [Jakub Onderka]
- [CLI] Start worker help. [Jakub Onderka]
- [internal] Bg worker cleanup. [Jakub Onderka]
- [internal] Check if update is possible. [Jakub Onderka]
- [internal] Simplify Attribute::fetchAttributes. [Jakub Onderka]
- [taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [object] break on duplicate, include uuid in addition to ID in failure
  message, fixes #7929. [iglocska]
- [internal] Use ProcessTool in Server. [Jakub Onderka]
- [internal] Use ProcessTool in PubSubTool. [Jakub Onderka]
- [internal] Use ProcessTool in SecurityAudit. [Jakub Onderka]
- [internal] Use ProcessTool in StixExport. [Jakub Onderka]
- [internal] upload_stix uses ProcessTool. [Jakub Onderka]
- [internal] Use ProcessTool in AttachmentTool. [Jakub Onderka]
- [internal] Simplify checking if folder is writable. [Jakub Onderka]
- [internal] Try to use array for processes. [Jakub Onderka]
- [internal] Better submodule info fetching. [Jakub Onderka]
- [internal] Check if update is possible. [Jakub Onderka]
- [internal] Current branch and commit checking. [Jakub Onderka]
- [internal] More clear method names. [Jakub Onderka]
- [UI] Use TimeHelper for zmq status. [Jakub Onderka]
- [internal] Small optim. [Jakub Onderka]
- [internal] Move version checking to one function. [Jakub Onderka]
- [internal] Use GitTool for remote version fetching. [Jakub Onderka]
- [internal] Faster way how to get current commit. [Jakub Onderka]
- [internal] Authkey resetting. [Jakub Onderka]
- [internal] Simplified remove version checking. [Jakub Onderka]
- [UI] scheduler doesn't exist for SimpleBackgroundJobs. [Jakub Onderka]
- [CLI] Add help for Admin redisReady command. [Jakub Onderka]
- [internal] Avoid shell_exec. [Jakub Onderka]
- [internal] Code style. [Jakub Onderka]
- [internal] pubsub types. [Jakub Onderka]
- [internal] Simplified Feed:getFreetextFeed method. [Jakub Onderka]
- [internal] Simplified feed caching. [Jakub Onderka]
- [internal] searchCaches code cleanup. [Jakub Onderka]
- [internal] Simplify server caching. [Jakub Onderka]
- Setting msg. [Luciano Righetti]
- Remove track_status setting. [Luciano Righetti]
- Remove MISP.use_simple_background_jobs setting in favor of
  SimpleBackgroundJobs.enabled. [Luciano Righetti]
- Remove monitor stuff from docbloc. [Luciano Righetti]
- Remove workers monitor script, rely on Supervisor API for all worker-
  related stuff. [Luciano Righetti]
- Try to get user via posix method first. [Luciano Righetti]
- Remove sleep from worker poll. [Luciano Righetti]
- Merge develop, fix conflicts. [Luciano Righetti]
- Add background jobs settings to the ui editor. [Luciano Righetti]
- Add fxmlrpc package as suggested. [Luciano Righetti]
- Minor refactor. [Luciano Righetti]
- Reload conf. [Luciano Righetti]
- Add redis namespace globally, add auto json de/serializer setting to
  redis client. [Luciano Righetti]
- Move initTool() logic to constructor. [Luciano Righetti]
- Merge develop, fix conflicts. [Luciano Righetti]
- Merge develop, fix conflicts. [Luciano Righetti]
- Rename settings. [Luciano Righetti]
- Rename conf name. [Luciano Righetti]
- Rename conf name. [Luciano Righetti]
- Call supervisor xml-rpc api, add supervisor app required packages.
  [Luciano Righetti]
- Add db update. [Luciano Righetti]
- Remove deprecation msg. [Luciano Righetti]
- Merge develop, fix conflicts. [Luciano Righetti]
- Use new bg jobs tool in user model. [Luciano Righetti]
- Use new bg jobs tool in shadow attribute model. [Luciano Righetti]
- Use new bg job tool in job model (cache cmds) [Luciano Righetti]
- Use new bg job tool in post model, refactor command. [Luciano
  Righetti]
- Use new bg job tool in log model. [Luciano Righetti]
- Use new bg job tool for publishing galaxy clusters. [Luciano Righetti]
- Use new bg jobs tool in correlation exclusion model. [Luciano
  Righetti]
- Use new bg jobs tool in correlation model. [Luciano Righetti]
- Use new bg jobs tool in AttachmentScan. [Luciano Righetti]
- Use new bg jobs tool in AppModel. [Luciano Righetti]
- Use new bg jobs tool in shadow attributes controller. [Luciano
  Righetti]
- Use new bg jobs tool in feeds controller. [Luciano Righetti]
- Use new bg jobs tool in servers controller. [Luciano Righetti]
- Use new bg jobs tool in /attributes/generateCorrelation. [Luciano
  Righetti]
- Move metadata parameter to last, refactor Server calls to background
  jobs to new tool. [Luciano Righetti]
- Add user to worker class, make /servers/getWorkers compatible with new
  bg jobs. [Luciano Righetti]
- Fix issues with servershell pull/push commands. [Luciano Righetti]
- Refactor background jobs tool to receive jobId instead of entity.
  [Luciano Righetti]
- Refactor server shell background jobs to use new tool. [Luciano
  Righetti]
- Refactor all background job calls from event model and controller to
  use new tool. [Luciano Righetti]
- Move contact reporter background job to new tool. [Luciano Righetti]
- Fetch job status from redis in jobs view. [Luciano Righetti]
- Remove hardcode response, map shell/cmd names. [Luciano Righetti]
- Pass sql Job to new job handler. [Luciano Righetti]
- Make enqueue method generic for both engines. [Luciano Righetti]
- [installer] Bump to latest version. [Steve Clement]
- [installer] Bump installer to latest version. [Steve Clement]
- [doc] updated dates in copyright section. [Christophe Vandeplas]
- [internal] Code style. [Jakub Onderka]
- [internal] AppController cleanup. [Jakub Onderka]
- [internal] App model cleanup. [Jakub Onderka]
- [internal] Simplify code for pulling events. [Jakub Onderka]
- [internal] Delete system setting when value is empty. [Jakub Onderka]
- [internal] Make system setting more secure. [Jakub Onderka]
- [internal] Deprecate Org::getUUIDs endpoint. [Jakub Onderka]
- [internal] Do not try to fetch empty clusters. [Jakub Onderka]
- [internal] Optimise loading event info in AuditLog. [Jakub Onderka]
- [internal] Unpublish event timestamp. [Jakub Onderka]
- [internal] Simplified editing field. [Jakub Onderka]
- [internal] Simplified attribute pagination. [Jakub Onderka]
- [internal] Remove SysLogLogable from SystemSetting. [Jakub Onderka]
- [internal] Simplify Server model code. [Jakub Onderka]
- [systemsetting] Better checking if setting is sensitive. [Jakub
  Onderka]
- [optimise] Reduce number of SQL queries for login page. [Jakub
  Onderka]
- [auditlog] Smarter title. [Jakub Onderka]
- [internal] Hide sensitive setting in AuditLog. [Jakub Onderka]
- [internal] Code style. [Jakub Onderka]
- [internal] Faster attaching tags to events. [Jakub Onderka]
- [internal] Assign galaxies in one query. [Jakub Onderka]
- [internal] Optimise loading attributes when doing search. [Jakub
  Onderka]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [doc] Document use of local parameter in API for tags/galaxies. [Loïc
  Fortemps]
- [doc] minor changes for 22.04 and ethX update. [Steve Clement]
- [install] Update to latest installer. [Steve Clement]
- [doc] Varios small fixes. [Steve Clement]
- [misp-objects] updated. [Alexandre Dulaunoy]
- [auditlog] Remove non exists insertId. [Jakub Onderka]
- [schema] Set object_references.uuid as unique column. [Jakub Onderka]
- [internal] Optimise saving attributes. [Jakub Onderka]
- [internal] Optimise attaching tags to objects. [Jakub Onderka]
- [internal] Optimise AuditLogBehavior. [Jakub Onderka]
- [auditlog] Remove unused variable. [Jakub Onderka]
- [auditlog] Simplify and optimise code. [Jakub Onderka]
- [internal] Optimise Attribute::fetchAttribute. [Jakub Onderka]
- [internal] Optimise updating templates. [Jakub Onderka]
- [internal] Optimise genericPicker. [Jakub Onderka]
- [internal] Use FileAccessTool in MispObject. [Jakub Onderka]
- [internal] Faster fetching object templates for selectbox. [Jakub
  Onderka]
- [internal] Optimise bulkSaveRelations. [Jakub Onderka]
- [internal] Optimise AuditLog. [Jakub Onderka]
- [internal] Try to remove possible unused methods. [Jakub Onderka]
- [internal] Optimise Tag::findTagIdsByTagNames. [Jakub Onderka]
- [internal] Optimise fetching events by tags. [Jakub Onderka]
- [internal] Simplify creating tag. [Jakub Onderka]
- [build] Try to run workers under www-data user. [Jakub Onderka]
- [PyMISP] Bump. [Jakub Onderka]
- [internal] Faster importing galaxy relation tags. [Jakub Onderka]
- [internal] Optimise sightings. [Jakub Onderka]
- [internal] Small optimisations. [Jakub Onderka]
- [internal] Code cleanup. [Jakub Onderka]
- [internal] Do not check event tags conflicts. [Jakub Onderka]
- [UI] Check empty event before filtering. [Jakub Onderka]
- [internal] Simplify code for Server::serverGetRequest. [Jakub Onderka]
- [internal] Better error messages when fetching feeds. [Jakub Onderka]
- [internal] Simplified link and boolean validation. [Jakub Onderka]
- [test] testDomainModify. [Jakub Onderka]
- [internal] Optimise converting hash to lowercase. [Jakub Onderka]
- [internal] Faster IPv6 compression. [Jakub Onderka]
- [misp-objects] updated. [Alexandre Dulaunoy]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- [PyMISP] updated. [Alexandre Dulaunoy]
- [internal] Optimise afterFind and simplify ISODatetimeToUTC. [Jakub
  Onderka]
- [internal] Code style. [Jakub Onderka]
- [internal] Move IPv6 compression to one method. [Jakub Onderka]
- [internal] Simplify validation for `domain|ip` [Jakub Onderka]
- [internal] Move ssdeep validation to specific method. [Jakub Onderka]
- [internal] Add ssh-fingerpint validation. [Jakub Onderka]
- [internal] Change params order for validate method. [Jakub Onderka]
- [internal] Move attribute validation to different tool. [Jakub
  Onderka]
- [PyMISP] update version. [Alexandre Dulaunoy]
- [PyMISP] updated to the latest version. [Alexandre Dulaunoy]
- [PyMISP] updated. [Alexandre Dulaunoy]
- [PyMISP] update to the latest version. [Alexandre Dulaunoy]
- [PyMISP] updated to the latest version. [Alexandre Dulaunoy]
- [stix] Bumped laster version of various stix related libraries.
  [chrisr3d]
- [opendata] Bumped latest version. [chrisr3d]
- [misp-stix] Bumped latest version. [chrisr3d]
- [server settings] allow empty baseurl to be saved. [iglocska]
- [stix] allow passing the publish flag to the stix upload. [iglocska]
- [internal] Reduce one SQL query for every request. [Jakub Onderka]
- [internal] Fetch less columns for Tag for event index. [Jakub Onderka]
- [internal] Do not fetch EventTag.id for events index. [Jakub Onderka]
- [internal] Log when object reference could not be captured. [Jakub
  Onderka]
- [internal] Add validation for ObjectReference. [Jakub Onderka]
- [schema] Add index for object_references.event_id column. [Jakub
  Onderka]
- [internal] Faster attaching references. [Jakub Onderka]
- [internal] Move method for fetching tags to one place. [Jakub Onderka]
- [internal] Simplified Event::attachTagsToEvents. [Jakub Onderka]
- [internal] Faster attaching attribute tags. [Jakub Onderka]
- [internal] Simplify Attribute::runValidation. [Jakub Onderka]
- [internal] Disable order for hasAny method. [Jakub Onderka]
- [internal] Simplified notifications loading. [Jakub Onderka]
- [misp-galaxy] updated to the latest version (ATT&CK v10) [Alexandre
  Dulaunoy]
- [internal] Faster tag capturing. [Jakub Onderka]
- [internal] Simplify UserSetting code. [Jakub Onderka]
- [misp-stix] Bumped latest version. [chrisr3d]
- [Server:update] Execute git submodule sync before updating. [Sami
  Mokaddem]

  This is done in order to make sure the submodules' remote URL is inline with the value defined in the .gitmodules
- [install] Regenerated install script to include the latest changes +
  update installer checksums. [chrisr3d]
- [doc] Update to OpenBSD 7.0. [Steve Clement]
- [doc] Added 3 more optionals. [Steve Clement]
- [github actions] Enabling tests on the `misp-stix` branch (at least
  temporarily) [chrisr3d]
- [stix2 export] Using specific filter `stix-version` instead of
  `version` that is too generic and used somewhere else. [chrisr3d]
- [schema] Set sharing group name as unique index. [Jakub Onderka]
- [internal] Simplify code for compareDBIndexes. [Jakub Onderka]
- [internal] Change way how to remove focus from URL. [Jakub Onderka]
- [internal] Convert to const array. [Jakub Onderka]
- [internal] Remove duplicates from acceptedFilteringNamedParams. [Jakub
  Onderka]
- [API] Simplify handling deleted attributes. [Jakub Onderka]
- [UI] Simplify performQuery method. [Jakub Onderka]
- [UI] Simplify HTML code. [Jakub Onderka]
- [ajax] Return correct error code when user is not logged. [Jakub
  Onderka]
- [Server:update] Execute git submodule sync before updating. [Sami
  Mokaddem]

  This is done in order to make sure the submodules' remote URL is inline with the value defined in the .gitmodules
- [internal] Faster tag extraction. [Jakub Onderka]
- [auditlog] Optimise fetching old records. [Jakub Onderka]
- [internal] Update correlations just when necessary. [Jakub Onderka]
- [internal] Event::unpublishEvent method. [Jakub Onderka]
- [internal] Simplify validation for Event org_id and orgc_id fields.
  [Jakub Onderka]
- [internal] Move UUID generation to beforeSave method. [Jakub Onderka]
- [internal] SaveMany for Event::add_original_file. [Jakub Onderka]
- [internal] Simplify Event::__attachReferences. [Jakub Onderka]
- [internal] Optimise fetching correlations. [Jakub Onderka]
- [internal] Simplify Event::beforeValidate. [Jakub Onderka]
- [internal] Simplify Attribute::beforeValidate. [Jakub Onderka]
- [internal] Simplify validation. [Jakub Onderka]
- [internal] Optimise beforeValidate for object. [Jakub Onderka]
- [internal] Optimise datetimeOrNull method. [Jakub Onderka]
- [internal] Optimise JSONConverterTool. [Jakub Onderka]
- [modules] Use JsonTool. [Jakub Onderka]
- [stix-export] Use JsonTool. [Jakub Onderka]
- [pubsub] Optimise. [Jakub Onderka]
- [internal] Optimise validators. [Jakub Onderka]
- [internal] Remove unused validation rule. [Jakub Onderka]
- [internal] Fix validation for UserSetting value. [Jakub Onderka]
- [internal] Remove unused method. [Jakub Onderka]
- [internal] Use reference for event modification. [Jakub Onderka]
- [internal] Optimise code for fetch proposals for events. [Jakub
  Onderka]
- [internal] Simplified attaching sharing groups. [Jakub Onderka]
- [internal] Do not specify fields when fetching object. [Jakub Onderka]
- [internal] Optimise fetching event when pulling. [Jakub Onderka]
- [internal] Fix setting cleanDb admin setting. [Jakub Onderka]
- [internal] Do less work when checking if db is updated. [Jakub
  Onderka]
- [internal] Code cleanup for Server::pull method. [Jakub Onderka]
- [UI] For first/last seen show timezone in tooltip. [Jakub Onderka]
- [UI] Event tooltips. [Jakub Onderka]
- [sync] Better exception handling. [Jakub Onderka]
- [sync] Use server sync tool for compatibility check. [Jakub Onderka]
- [internal] Create log entry for compatibility check. [Jakub Onderka]
- [internal] Code cleanup for EventsController::__indexRestResponse.
  [Jakub Onderka]
- [internal] Small optimisations for index REST response. [Jakub
  Onderka]
- [internal] Remove user id from fetched columns. [Jakub Onderka]
- [API] Fetch sharing groups in different query. [Jakub Onderka]
- [API] Optimise fetching event index. [Jakub Onderka]
- [event-index] Faster fetching empty results. [Jakub Onderka]
- [index] Faster event filtering by multiple tags. [Jakub Onderka]
- [internal] Event tags are deleted by quick delete. [Jakub Onderka]
- [event-index] Simplified condition for minimal search. [Jakub Onderka]
- [test] test_search_index_by_attribute. [Jakub Onderka]
- [test] test_search_index_minimal_published. [Jakub Onderka]
- [event index] For non exists email, do not return any event. [Jakub
  Onderka]
- [test] Tests for event index – search not by info. [Jakub Onderka]
- [test] test_search_index_by_email_admin. [Jakub Onderka]
- [internal] Handle non admin search event by email differently. [Jakub
  Onderka]
- [test] Tests for event index search by email. [Jakub Onderka]
- [test] Add more test for event index. [Jakub Onderka]
- [internal] Another bunch of event filter optim. [Jakub Onderka]
- [rest] Do not copy data. [Jakub Onderka]
- [rest] Close session to allow concurrent requests. [Jakub Onderka]
- [test] temp folder is not writable. [Jakub Onderka]
- [test] Better tests for event index. [Jakub Onderka]
- [index] Simplified code for org matching. [Jakub Onderka]
- [test] More tests for event index. [Jakub Onderka]
- [test] Tests for event index. [Jakub Onderka]
- [stix-export] Code cleanup. [Jakub Onderka]
- [export] Check method existence rather than another variable. [Jakub
  Onderka]
- [stix-export] Throw exception on error. [Jakub Onderka]
- [stix-export] Store temp file in default folder. [Jakub Onderka]
- [stix-export] Try to directly return TmpFileTool. [Jakub Onderka]
- [stix-export] Use more reliable file processing. [Jakub Onderka]
- [stix-export] Use TmpFileTool. [Jakub Onderka]
- [stix-export] Simplified loading python bin. [Jakub Onderka]
- [internal] Use JsonTool for JSON encoding. [Jakub Onderka]
- [internal] Use tmp folder for stix upload. [Jakub Onderka]
- [internal] Use FileAccessTool for STIX upload. [Jakub Onderka]
- [internal] Use FileAccessTool for Event::__getTagNamesFromSynonyms.
  [Jakub Onderka]
- [internal] Use FileAccessTool for Feed::unzipFirstFile. [Jakub
  Onderka]
- [internal] Use FileAccessTool for publishing sightings. [Jakub
  Onderka]

Fix
~~~
- [tools:backgroundjob] Support of legacy systems (3) [Sami Mokaddem]
- [tools:backgroundjob] Support of legacy systems (2) [Sami Mokaddem]
- [backgroundjob] Support of legacy system. [Sami Mokaddem]
- Update dep for fixing php74 build. [Luciano Righetti]
- ServerShell fails if SimpleBackgroundJobs config does not exists.
  [Luciano Righetti]
- [internal] Attaching cluster. [Jakub Onderka]
- [systemSetting] Check if database exists. [Jakub Onderka]
- [internal] Try to create directory if not exist. [Jakub Onderka]
- [user creation] don't show old style API key in the UI if advanced
  authkeys are enabled. [iglocska]

  - confusing and unusable anyway
- [user creation] Don't create an advanced authkey by default when
  creating a new user. [iglocska]

  - nobody will see the initial key, users can always create API keys for themselves
- [internal] Remove redundant condition. [Jakub Onderka]
- [internal] Correctly count matched attributes. [Jakub Onderka]
- [internal] Skip empty line. [Jakub Onderka]
- [internal] Update JSON. [Jakub Onderka]
- [internal] Param order. [Jakub Onderka]
- [internal] Private property access. [Jakub Onderka]
- [CLI] redisMemoryUsage. [Jakub Onderka]
- [UI] Correct attaching cache timestamp to server. [Jakub Onderka]
- [internal] Remove unused MISP.cached_attachments setting. [Jakub
  Onderka]
- Wrong default. [Luciano Righetti]
- Wrong default. [Luciano Righetti]
- Allow start worker by queue type. [Luciano Righetti]
- Issues when worker is stopped, allow null pid and user in worker
  class. [Luciano Righetti]
- Do not fail on process_id=null. [Luciano Righetti]
- Class not found issue. [Luciano Righetti]
- Bad merge. [Luciano Righetti]
- Minor cs issues. [Luciano Righetti]
- Revert bad merge. [Luciano Righetti]
- Fix typo. [Luciano Righetti]
- Replace splat operator, follow cake 2.x private methods naming.
  [Luciano Righetti]
- Change expected db version. [Luciano Righetti]
- Wrong update query. [Luciano Righetti]
- Use class registry to get job class. [Luciano Righetti]
- Add missing jobId param to enqueue() calls. [Luciano Righetti]
- Fix get worker status. [Luciano Righetti]
- Handle job status not found. [Luciano Righetti]
- Fix typo. [Luciano Righetti]
- Return correct X-Result-Count value in /attributes/restSearch.
  [Luciano Righetti]
- [CLI] fixes to the appshell. [iglocska]

  - always load the configload task
- [CLI/background jobs] reverted removal of perform command. [iglocska]
- [email OTP] subject tag fixed. [iglocska]

  - [MISP foo] to [foo MISP] to be aligned with other e-mails
- [doc] Added missing misp-stix to the documentation. [Steve Clement]
- [schema] updated. [iglocska]
- [internal] Remove unused helper. [Jakub Onderka]
- [internal] Remove potentially problematic and non functional
  searchAlternate. [Jakub Onderka]
- [config] Remove not used Attributes_Values_Filter_In_Event. [Jakub
  Onderka]
- [internal] Fetching clusters. [Jakub Onderka]
- [tags] enforce local_only check on backend. [Loïc Fortemps]
- [API] Object reference view. [Jakub Onderka]
- [auditlog] Fetch event_id when necessary. [Jakub Onderka]
- [API] Do not allow same tags for one object (local/global) [Jakub
  Onderka]
- [internal] Attaching tags to attachment attribute. [Jakub Onderka]
- [test] Permission for workers. [Jakub Onderka]
- [API] Exception value. [Jakub Onderka]
- [API] UserSetting::getSetting method. [Jakub Onderka]
- [API] Deleting user setting. [Jakub Onderka]
- [UI] Ignore harvest exception. [Jakub Onderka]
- [UI] Correct link to focus. [Jakub Onderka]
- [API] Remove default filters for viewEventAttributes. [Jakub Onderka]
- [UI] Element name. [Jakub Onderka]
- [UI] Filtering attribute when distribution is zero. [Jakub Onderka]
- [UI] Feed hits. [Jakub Onderka]
- [UI] Add link to full attribute. [Jakub Onderka]
- [validation] Correctly validate filename|tlsh attribute. [Jakub
  Onderka]
- [internal] removeOrphanedCorrelations. [Jakub Onderka]
- [internal] Filename|xxx could not contain new line char. [Jakub
  Onderka]
- [internal] named pipe validation. [Jakub Onderka]
- [internal] Remove unreachable code. [Jakub Onderka]
- [internal] Simplify Attribute code. [Jakub Onderka]
- [API] Simplify some validations. [Jakub Onderka]
- [cti-python-stix2] Correctly bumped latest version... [chrisr3d]
- [cti-python-stix2] Correctly bumped latest version... [chrisr3d]
- [database] upgrade script using mb4 defaulted to 255 key length.
  [iglocska]

  - default should be 191
- [API] Faster assigning objects and attributes to references. [Jakub
  Onderka]
- [internal] Do not duplicate column. [Jakub Onderka]
- [API] Simplify linking proposals to attributes. [Jakub Onderka]
- [API] Simplify fetchEvent code. [Jakub Onderka]
- [internal] Attaching servere/feed correlation to proposals. [Jakub
  Onderka]
- [internal] Proposal validation. [Jakub Onderka]
- [schema] Modify User.change_pw column to boolean. [Jakub Onderka]
- [internal] No exception when db logs are disabled. [Jakub Onderka]
- [UI] Correct values for deleted attribute filtering. [Jakub Onderka]
- [github actions] For the tests purpose, installing the stix1 python
  library from the submodule. [chrisr3d]
- [gitignore] Removed directories related to python libraries.
  [chrisr3d]
- [stix python install] Added STIX python dependencies to the install.
  [chrisr3d]
- [validation] TLSH new format validation added. [iglocska]

  - ffs
- [internal] Do not allow deleting SG when object or event reprot is
  assigned to that SG. [Jakub Onderka]
- [internal] Prevent duplicate org for sharing group. [Jakub Onderka]
- [CLI] Cluster publishing. [Jakub Onderka]
- [UI] Active rules value. [Jakub Onderka]
- [UI] Event filtering. [Jakub Onderka]
- [ui] Do not call checkAndSetPublishedInfo when no need. [Jakub
  Onderka]
- [UI] Correctly handle links to related events. [Jakub Onderka]
- [UI] Broken tag attaching. [Jakub Onderka]
- [internal] Deleting events. [Jakub Onderka]
- [internal] Try to prevent deadlocks when updating event attribute
  count. [Jakub Onderka]
- [internal] Fetch event index in CSV. [Jakub Onderka]
- [test] Fix event index tests. [Jakub Onderka]
- [UI] Undefined index. [Jakub Onderka]
- [stix-export] Delete tmp files. [Jakub Onderka]
- [index] Org condition. [Jakub Onderka]
- [index] Remove all virtual fields. [Jakub Onderka]
- [API] Fix fetching events by org UUID. [Jakub Onderka]
- [event index] search by org fixed when using string names, fixes
  MISP/PyMISP#799. [iglocska]

Other
~~~~~
- Merge branch 'develop' into 2.4. [iglocska]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [Alexandre Dulaunoy]
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge pull request #7971 from JakubOnderka/apcu. [Jakub Onderka]

  new: [internal] Faster caching
- Merge pull request #7970 from JakubOnderka/fix-diagnostics. [Jakub
  Onderka]

  fix: [internal] Try to create directory if not exist
- Merge pull request #7965 from JakubOnderka/bg-worker-simplify. [Jakub
  Onderka]

  chg: [internal] Bg worker cleanup
- Merge pull request #7956 from JakubOnderka/fix-attr-count. [Jakub
  Onderka]

  fix: [internal] Correctly count matched attributes
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge pull request #7959 from JakubOnderka/remote-version-checking.
  [Jakub Onderka]

  chg: [internal] Simplified remote version checking
- Merge pull request #7958 from JakubOnderka/bg-fix. [Jakub Onderka]

  Bg fix
- Merge pull request #7955 from JakubOnderka/code-style-background-jobs.
  [Jakub Onderka]

  chg: [internal] Code style
- Merge pull request #7954 from JakubOnderka/sub. [Jakub Onderka]

  new: [user] Add sub field for user
- Merge pull request #7949 from JakubOnderka/server-caching. [Jakub
  Onderka]

  Server caching
- Merge pull request #7953 from JakubOnderka/cached_attachments_remove.
  [Jakub Onderka]

  fix: [internal] Remove unused MISP.cached_attachments setting
- Merge pull request #7939 from righel/add_simple_background_jobs.
  [Andras Iklody]

  Add simple background jobs
- Merge branch 'develop' into add_simple_background_jobs. [Luciano
  Righetti]
- Merge branch 'develop' into add_simple_background_jobs. [Luciano
  Righetti]
- Add: add initial new simple background jobs. [Luciano Righetti]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge pull request #7946 from JakubOnderka/redis-memory-usage. [Jakub
  Onderka]

  new: [CLI] Redis memory usage diagnostics
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' into develop. [Steve Clement]
- Merge pull request #7944 from SteveClement/guides. [Steve Clement]

  fix: [doc] Added missing misp-stix to the documentation
- Merge pull request #7817 from fandigunawan/supports-minio. [Alexandre
  Dulaunoy]

  new: Supports MinIO as alternative to AWS S3
- Adds default TLS validation to true and supports custom CA path.
  [Fandi Gunawan]
- Supports MinIO as alternative to AWS S3. [Fandi Gunawan]
- Merge pull request #7938 from JakubOnderka/authkeys-encrypted-vol2.
  [Jakub Onderka]

  Authkeys encrypted vol2
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge pull request #7937 from JakubOnderka/app-controller-cleanup-
  vol4. [Jakub Onderka]

  App controller cleanup vol4
- Merge pull request #7936 from JakubOnderka/app-model-cleanup. [Jakub
  Onderka]

  chg: [internal] App model cleanup
- Merge pull request #7932 from JakubOnderka/pulling-simplify. [Jakub
  Onderka]

  chg: [internal] Simplify code for pulling events
- Merge pull request #7935 from JakubOnderka/system-setting-security.
  [Jakub Onderka]

  chg: [internal] Make system setting more secure
- Merge pull request #7742 from JakubOnderka/get-uuids-deprecate. [Jakub
  Onderka]

  chg: [internal] Deprecate Org::getUUIDs endpoint
- Merge pull request #7934 from JakubOnderka/attribute-pagination.
  [Jakub Onderka]

  Attribute pagination
- Merge pull request #7416 from JakubOnderka/menu-custom-right-link.
  [Jakub Onderka]

  new: [UI] Define custom right menu link
- Merge pull request #7927 from JakubOnderka/system-setting. [Jakub
  Onderka]

  System setting in database
- Merge pull request #7933 from JakubOnderka/attributes-index. [Jakub
  Onderka]

  Attributes index
- Merge pull request #7931 from thijskh/shib-doc-fixes. [Alexandre
  Dulaunoy]

  Fix docblock formatting and add newer settings to README documentation
- Fix docblock formatting and add newer settings to README
  documentation. [Thijs Kinkhorst]
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch 'local_only' into develop. [iglocska]
- Bump DB version. [Loïc Fortemps]
- Merge branch 'develop' into local_tags. [Loïc Fortemps]
- Adding a local_only option for Tags and Galaxies. [Loic Fortemps]
- Merge branch '2.4' into develop. [iglocska]
- Merge pull request #7928 from SteveClement/guides. [Steve Clement]
- Merge pull request #7926 from SteveClement/guides. [Steve Clement]
- Merge pull request #7918 from StefanKelm/2.4. [Luciano Righetti]

  Update openapi.yaml
- Update openapi.yaml. [StefanKelm]

  tiny typo...
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge pull request #7904 from StefanKelm/2.4. [Luciano Righetti]

  Update openapi.yaml
- Update openapi.yaml. [StefanKelm]

  small copy-n-paste error
- Merge pull request #7854 from JakubOnderka/save-optim. [Jakub Onderka]

  chg: [internal] Optimise saving attributes
- Merge pull request #7915 from JakubOnderka/fix-saving-attribute.
  [Jakub Onderka]

  fix: [internal] Attaching tags to attachment attribute
- Merge pull request #7914 from JakubOnderka/audit-log-behaviour-optim.
  [Jakub Onderka]

  Audit log behaviour optim
- Merge pull request #7913 from JakubOnderka/fetchAttribute. [Jakub
  Onderka]

  chg: [internal] Optimise Attribute::fetchAttribute
- Merge pull request #7910 from JakubOnderka/object-templates. [Jakub
  Onderka]

  Object templates
- Merge pull request #7911 from JakubOnderka/bulkSaveRelations. [Jakub
  Onderka]

  chg: [internal] Optimise bulkSaveRelations
- Merge pull request #7912 from JakubOnderka/audit-log-optim. [Jakub
  Onderka]

  chg: [internal] Optimise AuditLog
- Merge pull request #7908 from
  JakubOnderka/test_restsearch_event_by_tags. [Jakub Onderka]

  new: [test] test_restsearch_event_by_tags
- Merge pull request #7909 from JakubOnderka/galaxy-cluster-relation-
  tag. [Jakub Onderka]

  chg: [internal] Simplify creating tag
- Merge pull request #7890 from JakubOnderka/thret-level-notification.
  [Jakub Onderka]

  new: [settings] Allow to use ThreatLevel.name for alert filter
- Merge pull request #7891 from JakubOnderka/faster-galaxy-import.
  [Jakub Onderka]

  chg: [internal] Faster importing galaxy relation tags
- Merge pull request #7852 from JakubOnderka/optimise-sighting. [Jakub
  Onderka]

  chg: [internal] Optimise sightings
- Merge pull request #7907 from JakubOnderka/view-event-attriubtes-
  ignore. [Jakub Onderka]

  View event attriubtes ignore
- Merge pull request #7905 from JakubOnderka/fix-view-event-attributes.
  [Jakub Onderka]

  Fix view event attributes
- Merge pull request #7903 from JakubOnderka/fix-filter-distribution-
  zero. [Jakub Onderka]

  fix: [UI] Filtering attribute when distribution is zero
- Merge pull request #7887 from thijskh/patch-1. [Alexandre Dulaunoy]

  Clarify some aspects of the Shibboleth config
- Clarify some aspects of the Shibboleth config. [Thijs Kinkhorst]
- Merge pull request #7902 from JakubOnderka/attribute-list-link. [Jakub
  Onderka]

  fix: [UI] Add link to full attribute
- Merge pull request #7901 from JakubOnderka/tlsh-validation-fix. [Jakub
  Onderka]

  fix: [validation] Correctly validate filename|tlsh attribute
- Merge pull request #7897 from JakubOnderka/preview-index-api. [Jakub
  Onderka]

  Preview index api
- Merge pull request #7899 from JakubOnderka/admin-shell. [Jakub
  Onderka]

  new: [CLI] New task for removeOrphanedCorrelations and optimiseTables
- Merge pull request #7900 from JakubOnderka/fetch-feed. [Jakub Onderka]

  chg: [internal] Better error messages when fetching feeds
- Merge pull request #7896 from JakubOnderka/fix-remove-orphaned-
  correlation. [Jakub Onderka]

  add: [test] test_remove_orphaned_correlations
- Add: [test] test_remove_orphaned_correlations. [Jakub Onderka]
- Merge pull request #7895 from JakubOnderka/attribute-validation-tool-
  fix. [Jakub Onderka]

  Attribute validation tool fix
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge pull request #7894 from JakubOnderka/attribute-code-style.
  [Jakub Onderka]

  fix: [internal] Simplify Attribute code
- Merge pull request #7893 from JakubOnderka/attribute-validation-tool.
  [Jakub Onderka]

  Attribute validation tool
- Fixup! chg: [internal] Move attribute validation to different tool.
  [Jakub Onderka]
- Add: [test] Basic test for AttributeValidationTool. [Jakub Onderka]
- Merge branch '2.4' of github.com:MISP/MISP into develop. [Alexandre
  Dulaunoy]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [chrisr3d]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [Alexandre Dulaunoy]
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge pull request #7878 from imidoriya/patch-2. [Alexandre Dulaunoy]

  Exclude the /venv/* as it causes confusion
- Exclude the /venv/* as it causes confusion. [Deku]
- Merge pull request #7889 from JakubOnderka/reduce-sql. [Jakub Onderka]

  chg: [internal] Reduce one SQL query for every request
- Merge pull request #7881 from JakubOnderka/attribute-tags. [Jakub
  Onderka]

  chg: [internal] Faster attaching attribute tags
- Merge pull request #7886 from JakubOnderka/proposals-correaltions.
  [Jakub Onderka]

  fix: [internal] Attaching servere/feed correlation to proposals
- Merge pull request #7885 from JakubOnderka/fix-proposal-validation.
  [Jakub Onderka]

  fix: [internal] Proposal validation
- Merge pull request #7884 from JakubOnderka/faster-notifications.
  [Jakub Onderka]

  chg: [internal] Simplified notifications loading
- Merge pull request #7882 from JakubOnderka/change-pw-fix. [Jakub
  Onderka]

  fix: [schema] Modify User.change_pw column to boolean
- Merge pull request #7883 from JakubOnderka/skip-db-logs-fix. [Jakub
  Onderka]

  fix: [internal] No exception when db logs are disabled
- Merge pull request #7880 from JakubOnderka/deleted-fixes. [Jakub
  Onderka]

  fix: [UI] Correct values for deleted attribute filtering
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge pull request #7872 from JakubOnderka/faster-tag-capturing.
  [Jakub Onderka]

  chg: [internal] Faster tag capturing
- Merge pull request #7873 from JakubOnderka/user-setting-cleanup.
  [Jakub Onderka]

  chg: [internal] Simplify UserSetting code
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of https://github.com/MISP/MISP into misp-stix.
  [chrisr3d]
- Merge pull request #7841 from SteveClement/guides. [Steve Clement]
- Merge branch 'MISP:2.4' into guides. [Steve Clement]
- Merge pull request #7840 from amuehlem/2.4. [Alexandre Dulaunoy]

  added 'git submodule sync' before 'git submodule update'
- Added 'git submodule sync' before 'git submodule update' [Andreas
  Muehlemann]
- Merge remote-tracking branch 'upstream/2.4' into guides. [Steve
  Clement]
- Merge branch '2.4' of https://github.com/MISP/MISP into misp-stix.
  [chrisr3d]
- Merge pull request #7871 from JakubOnderka/duplicate-sg-org. [Jakub
  Onderka]

  fix: [internal] Prevent duplicate org for sharing group
- Merge pull request #7870 from JakubOnderka/code-cleanup-vol10. [Jakub
  Onderka]

  chg: [internal] Simplify code for compareDBIndexes
- Merge pull request #7866 from JakubOnderka/publish-cluster-fix. [Jakub
  Onderka]

  fix: [CLI] Cluster publishing
- Add: [test] Publishing galaxy cluster. [Jakub Onderka]
- Merge pull request #7864 from JakubOnderka/handle-deleted. [Jakub
  Onderka]

  chg: [API] Simplify handling deleted attributes
- Merge pull request #7863 from JakubOnderka/advanced-filtering. [Jakub
  Onderka]

  Advanced filtering cleanup
- Merge pull request #7862 from JakubOnderka/test_deleted_attributes.
  [Jakub Onderka]

  new: [test] test_deleted_attributes
- Merge pull request #7730 from JakubOnderka/user-setting-oidc. [Jakub
  Onderka]

  new: [oidc] User setting for oidc metadata
- Merge pull request #7861 from JakubOnderka/ajax-401. [Jakub Onderka]

  chg: [ajax] Return correct error code when user is not logged
- Merge pull request #7859 from JakubOnderka/fix-completeley-broken-ui.
  [Jakub Onderka]

  fix: [UI] Broken tag attaching
- Merge pull request #7857 from JakubOnderka/faster-tag-extraction.
  [Jakub Onderka]

  chg: [internal] Faster tag extraction
- Merge pull request #7855 from JakubOnderka/delete-event-fix. [Jakub
  Onderka]

  fix: [internal] Deleting events
- Merge pull request #7851 from JakubOnderka/better-validation. [Jakub
  Onderka]

  Better validation
- Merge pull request #7850 from JakubOnderka/optimise-event-fetch.
  [Jakub Onderka]

  chg: [internal] Optimise fetching event when pulling
- Merge pull request #7849 from JakubOnderka/fix-clean-db. [Jakub
  Onderka]

  chg: [internal] Fix setting cleanDb admin setting
- Merge pull request #7848 from JakubOnderka/update-less-work. [Jakub
  Onderka]

  chg: [internal] Do less work when checking if db is updated
- Merge pull request #7797 from JakubOnderka/server-pull-cleanup. [Jakub
  Onderka]

  chg: [internal] Code cleanup for Server::pull method
- Merge pull request #6562 from JakubOnderka/prevent-deadlocks. [Jakub
  Onderka]

  fix: [internal] Try to prevent deadlocks when updating event attribute count
- Merge pull request #7036 from JakubOnderka/event-tooltips. [Jakub
  Onderka]

  Event tooltips
- Merge pull request #7658 from JakubOnderka/compatiblity-check-log.
  [Jakub Onderka]

  chg: [internal] Create log entry for compatibility check
- Merge pull request #7646 from JakubOnderka/server-sync-log. [Jakub
  Onderka]

  new: [sync] Server sync logging
- Merge pull request #7584 from JakubOnderka/index-fetch-optim. [Jakub
  Onderka]

  Index fetch optim
- Merge pull request #7748 from JakubOnderka/event-index-optim-vol2.
  [Jakub Onderka]

  chg: [internal] Another bunch of event filter optim
- Fi: [test] test_search_index_by_email_admin. [Jakub Onderka]
- Merge pull request #7847 from JakubOnderka/rest-search-optim-vol2.
  [Jakub Onderka]

  Rest search optim vol2
- Merge pull request #7844 from JakubOnderka/build-test-vol2. [Jakub
  Onderka]

  chg: [test] temp folder is not writable
- Merge pull request #7845 from JakubOnderka/fix-ui-undefined-index.
  [Jakub Onderka]

  fix: [UI] Undefined index
- Merge pull request #7846 from JakubOnderka/stix-delete-files. [Jakub
  Onderka]

  fix: [stix-export] Delete tmp files
- Merge pull request #7843 from JakubOnderka/index-test-vol2. [Jakub
  Onderka]

  Index test vol2
- Merge pull request #7842 from JakubOnderka/index-test. [Jakub Onderka]

  chg: [test] Tests for event index
- Merge branch '2.4' into develop. [iglocska]
- Merge pull request #7835 from JakubOnderka/stix-export. [Jakub
  Onderka]

  chg: [internal] Simplified loading python bin
- Merge pull request #7832 from JakubOnderka/pulish-sightings-file.
  [Jakub Onderka]

  chg: [internal] Use FileAccessTool for publishing sightings


v2.4.150 (2021-10-12)
---------------------

New
~~~
- [test] Build test. [Jakub Onderka]

Changes
~~~~~~~
- [version] bump. [iglocska]
- Add missing action buttons. [Luciano Righetti]
- Add tags and galaxies col. [Luciano Righetti]
- Add sightings cols and actions. [Luciano Righetti]
- Add attributes index custom fields. [Luciano Righetti]
- Initial migration of attributes/index view to factory. [Luciano
  Righetti]
- Migrate news views to factory. [Luciano Righetti]
- [queryversion] bump. [iglocska]
- [log] Log when saving tags fails for attribute or event. [Jakub
  Onderka]
- [internal] Add new submodules to diagnostics page. [Jakub Onderka]
- [UI] Show proper error when uploading event that already exists.
  [Jakub Onderka]
- [feed] Move feed cache to proper folder. [Jakub Onderka]
- [feed] Use FileAccessTool. [Jakub Onderka]
- [feed] Simplified code for updating events from MISP feed. [Jakub
  Onderka]
- [feed] Support unicode for feed preview search. [Jakub Onderka]
- [feed] Faster saving freetext attributes. [Jakub Onderka]
- [feed] Clean cache after feed modification. [Jakub Onderka]
- [feed] Check ETag when fetching freetext feed. [Jakub Onderka]
- [internal] Use hasAny for Org::canSee method. [Jakub Onderka]
- [internal] Use findColumn for Org::getOrgIdsFromMeta method. [Jakub
  Onderka]
- [internal] Use FileAccessTool to read country galaxy cluster. [Jakub
  Onderka]
- [internal] Better logging when saving SharingGroup. [Jakub Onderka]
- [internal] Simplify fetching Kafka topic. [Jakub Onderka]
- [internal] Simplify SharingGroup::checkIfAuthorisedToSave. [Jakub
  Onderka]
- [internal] Simplify Event::__captureObjects code. [Jakub Onderka]
- [internal] Remove dead code. [Jakub Onderka]
- [internal] No need to initialize Sighting model. [Jakub Onderka]
- [internal] Remove unused attribute from MispObject::captureObject
  method. [Jakub Onderka]
- [internal] Remove unused code when saving attributes for event. [Jakub
  Onderka]
- [internal] Simplified code for MispObject::captureObject. [Jakub
  Onderka]
- [internal] Faster saving attributes. [Jakub Onderka]
- [internal] Save multiple tags in one call. [Jakub Onderka]
- [internal] Simplified SharingGroup::appendOrgsAndServers. [Jakub
  Onderka]
- [internal] Remove unused method Tag::findEventTags. [Jakub Onderka]
- [internal] Cache capturing tag results. [Jakub Onderka]
- [internal] Faster validating SG. [Jakub Onderka]
- [internal] Remove unused method. [Jakub Onderka]
- [internal] Simplified SharingGroup::checkIfAuthorised method. [Jakub
  Onderka]
- [internal] Use hasAny for SG existence check. [Jakub Onderka]
- [internal] Use ?: operator. [Jakub Onderka]
- [internal] Use hasAny method for checkIfAuthorised methods. [Jakub
  Onderka]
- [internal] Simplified Attribute::editAttribute method. [Jakub Onderka]
- [internal] Move Attribute::resizeImage method to AttachmentTool.
  [Jakub Onderka]
- [internal] Default distribution method. [Jakub Onderka]
- [internal] Attribute::onDemandEncrypt faster. [Jakub Onderka]
- [internal] Delete unused method Attribute::saveAndEncryptAttribute.
  [Jakub Onderka]
- [internal] Faster saving origin file. [Jakub Onderka]
- [internal] Optimise Attribute::valueIsUnique check. [Jakub Onderka]
- [internal] Do not encode/decode base64 for simpleAddMalwareSample.
  [Jakub Onderka]
- [internal] Use FileAccessTool in AttachmentTool. [Jakub Onderka]
- [internal] Allow to save raw data. [Jakub Onderka]
- [internal] Background processing refactoring. [Jakub Onderka]
- [PyMISP] Update. [Jakub Onderka]
- [misp-stix] Update. [Jakub Onderka]
- [MISP/cakephp] updated - to get latest CA bundle. [Alexandre Dulaunoy]

Fix
~~~
- [attribute index] fixed attribute tag widget. [iglocska]

  - notice errors due to missing variables in the closure
- [attribute index] fix galaxy widget for the attribute index.
  [iglocska]

  - notice errors when logged in as a user
- [attribute index] action ACL fixed. [iglocska]
- Incorrect sort keys. [Luciano Righetti]
- [internal] withCredentials property was added into $.ajaxSetup() to
  get rid of 403 and 302 responses. [MrBoba]
- [internal] Fix saving tags. [Jakub Onderka]
- [log] Undefined index local. [Jakub Onderka]
- [internal] Remove unused SharingGroup::getSGSyncRules method. [Jakub
  Onderka]
- [internal] Remove unused Event::checkIfAuthorised method. [Jakub
  Onderka]
- [internal] Deleting event propagation to ZMQ and Kafka. [Jakub
  Onderka]
- [shell] EventShell::contactemail command. [Jakub Onderka]
- [community-metadata] Fix typos and improve wording. [Jeroen Pinoy]
- [API] Return correct error message if event is blocklisted. [Jakub
  Onderka]
- [attribute] Use `filename-pattern` [Jakub Onderka]
- [internal] Server save setting file. [Jakub Onderka]
- [stix1 export] Removed unnecessary write. [chrisr3d]

Other
~~~~~
- Merge branch 'develop' into 2.4. [iglocska]
- Merge branch 'attribute_index' into develop. [iglocska]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge pull request #7633 from righel/migrate-news-views. [Andras
  Iklody]

  chg: migrate news views to factory.
- Merge branch '2.4' into develop. [iglocska]
- Revert "fix: [internal] withCredentials property was added into
  $.ajaxSetup() to get rid of 403 and 302 responses" [iglocska]

  This reverts commit b496161f5bf2a7f15ce52cf0dec62a52fc9d713e.
- Merge branch '2.4' into develop. [iglocska]
- Merge pull request #7818 from MrBoba/fix-unauthorized-ajax. [Andras
  Iklody]

  fix: [internal] withCredentials property was added into $.ajaxSetup()…
- Merge pull request #7833 from JakubOnderka/fix-local-tags. [Jakub
  Onderka]

  fix: [internal] Fix saving tags
- Merge pull request #7831 from marjatech/marjatech-local-tag-import.
  [Andras Iklody]

  fix: keep tag local state when importing from json or sync from internal
- Keep tag local state when importing from json or sync from internal.
  [misp-test]

  Fixes MISP#7810
  When importing an Event via JSON, local tags inside the json should stay local after import too, and not be attached as global ones.
  Same applies for Sync-Operations from internal instances (for any other instance local tags get stripped anyway)
- Merge pull request #7830 from JakubOnderka/audit-log-undefined-index.
  [Jakub Onderka]

  fix: [log] Undefined index local
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [Alexandre Dulaunoy]
- Merge pull request #7826 from JakubOnderka/new-submodules. [Jakub
  Onderka]

  chg: [internal] Add new submodules to diagnostics page
- Merge pull request #7827 from JakubOnderka/upload-stix-existing-uuid.
  [Jakub Onderka]

  chg: [UI] Show proper error when uploading event that already exists
- Merge pull request #7798 from JakubOnderka/feed-etag. [Jakub Onderka]

  chg: [feed] Check ETag when fetching freetext feed
- Chf: [feed] Cache MISP feed manifest file. [Jakub Onderka]
- Merge pull request #7824 from JakubOnderka/code-cleanup-vol9. [Jakub
  Onderka]

  Code cleanup vol9
- Merge pull request #7823 from JakubOnderka/faster-attachment. [Jakub
  Onderka]

  chg: [internal] Allow to save raw data
- Merge pull request #7821 from JakubOnderka/background-processing-chg.
  [Jakub Onderka]

  chg: [internal] Background processing refactoring
- Merge pull request #7820 from JakubOnderka/build-test. [Jakub Onderka]

  new: [test] Build test
- Merge pull request #7819 from Wachizungu/fix-communities-list-
  language. [Alexandre Dulaunoy]

  fix: [community-metadata] Fix typos and improve wording
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [Alexandre Dulaunoy]
- Merge pull request #7816 from JakubOnderka/update-misp-stix. [Jakub
  Onderka]

  chg: [misp-stix] Update
- Merge pull request #7638 from JakubOnderka/add-event-error. [Jakub
  Onderka]

  fix: [API] Return correct error message if event is blocklisted
- Merge pull request #7710 from JakubOnderka/filename-pattern. [Jakub
  Onderka]

  fix: [attribute] Use `filename-pattern`
- Merge pull request #7814 from JakubOnderka/server-save-setting. [Jakub
  Onderka]

  fix: [internal] Server save setting file
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]


v2.4.149 (2021-10-09)
---------------------

New
~~~
- [internal] Store MISP live status also in Redis. [Jakub Onderka]
- [internal] OrgBlocklist::removeBlockedEvents. [Jakub Onderka]
- [internal] Method Job::createJob. [Jakub Onderka]
- Support for BECH32 (P2WPKH) BTC address. [Jakub Onderka]
- [CLI] UserShell::ip_user command. [Jakub Onderka]
- [CLI] New tasks that will check if Redis is available. [Jakub Onderka]
- Add more /taxonomies/* endpoints api docs. [Luciano Righetti]
- Add openapi docs for /users_settings/* endpoints. [Luciano Righetti]
- [shell] Tag merging. [Jakub Onderka]
- [event:notification] Added email notification ban system based on
  users triggering the notification. [mokaddem]
- [cerebrate:pull_sg] Pull sharing groups from a cerebrate instance.
  [mokaddem]
- [UI] Allow to filter attributes by specific warninglist. [Jakub
  Onderka]
- [CLI] User shell. [Jakub Onderka]
- [oidc] Allow to automatically unblock user after successful login.
  [Jakub Onderka]
- [security] Disable browser autocomplete for authkeys field. [Jakub
  Onderka]
- [export:host] RestSearch export for blackholing via host file.
  [mokaddem]
- [warninglist] Assign warninglist comment. [Jakub Onderka]
- [sighting:add] Ability to provide filtering parameters when adding
  sightings for specific values Fix #7669. [mokaddem]
- [API] Allow to delete multiple events by UUID. [Jakub Onderka]
- [test] Test more endpoints in sync test. [Jakub Onderka]
- [API] Allow more granular specification what data to return when
  viewing event. [Jakub Onderka]
- [test] Push to remote server. [Jakub Onderka]
- [test] Sync. [Jakub Onderka]

Changes
~~~~~~~
- [stix2 export] Using a specific filter to specify the STIX version.
  [chrisr3d]

  - `version` being too generic and used from another
    end point, we use `stix-version` in order to
    avoid confusion between the 2 filters
- [install] Update installer checksums. [Steve Clement]
- [PyMISP] bump to the latest version. [Alexandre Dulaunoy]
- [GitHub action] install the python-cti-stix2 from the local submodule.
  [Alexandre Dulaunoy]
- [GitHub action] raging on venv library path. [Alexandre Dulaunoy]
- [GitHubAction] add2virtualenv the STIX stuff. [Alexandre Dulaunoy]
- [modules] typo fixed. [Alexandre Dulaunoy]
- [gitmodules] fix the branch to main. [Alexandre Dulaunoy]
- [gitmodules] TLS is always fine. [Alexandre Dulaunoy]
- [version] bump. [iglocska]
- [misp-object] updated. [Alexandre Dulaunoy]
- [misp-stix] Bumped latest version including recent PR merged.
  [chrisr3d]
- [stix] Bumped latest version of `misp-stix` $ `cti-python-stix2`
  python libraries. [chrisr3d]
- [INSTALL] Removing the install commands for the STIX libraries.
  [chrisr3d]
- [stix2 export] Moved the stix2 python library with its stix1 friends
  in the `scripts` dir. [chrisr3d]
- [users:routeafterlogin] Allow forcing the pre-login URL to be HTTPS.
  [Sami Mokaddem]

  This can be achieved by turning the setting MISP.forceHTTPSforPreLoginRequestedURL to true.
- [misp-stix] Bumped the latest version including some fixes and
  updates. [chrisr3d]
- [misp-stix] Bumped latest misp-stix version. [chrisr3d]
- [stix export] Removed mapping files not used anymore. [chrisr3d]

  - The STIX1 & STIX2 mapping is now managed with
    the misp-stix python library
- [cti-python-stix2] Bumped latest version. [chrisr3d]
- [misp-stix] Bumped latest version. [chrisr3d]
- [stix1 export] Using the misp-stix library to export MISP format into
  STIX 1.1.1 or 1.2. [chrisr3d]
- [stix export] Updated Stix export libraries. [chrisr3d]

  - Including parameters to define versions in the
    restSearch filters
  - New parameters to call the python scripts
- [misp-stix] Bumped latest version. [chrisr3d]
- [misp-stix] Updated to the latest version. [chrisr3d]
- [internal] Generate correlations just once. [Jakub Onderka]
- [internal] Faster adding tags to attributes. [Jakub Onderka]
- [users:routeafterlogin] Allow forcing the pre-login URL to be HTTPS.
  [Sami Mokaddem]

  This can be achieved by turning the setting MISP.forceHTTPSforPreLoginRequestedURL to true.
- [internal] Use hasAny. [Jakub Onderka]
- [internal] Faster event tag attaching. [Jakub Onderka]
- [misp-warninglists] updated. [Alexandre Dulaunoy]
- [misp-galaxy] updated. [Alexandre Dulaunoy]
- [misp-objects] updated. [Alexandre Dulaunoy]
- [warning-list] updated. [Alexandre Dulaunoy]
- [gitmodules] as Branch 2.x was removed from the original repository,
  we now use our own repo. [Alexandre Dulaunoy]
- [misp-objects] updated. [Alexandre Dulaunoy]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- Detail attribute categories in openapi doc. [Luciano Righetti]
- Detail attribute types in openapi doc. [Luciano Righetti]
- Detail attribute types in openapi doc. [Luciano Righetti]
- [taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [internal] Refactor FileAccessTool. [Jakub Onderka]
- [internal] Simplified EventsController::view code. [Jakub Onderka]
- [sync] Use server sync tool for fetching remote events index. [Jakub
  Onderka]
- [warning-lists] updated. [Alexandre Dulaunoy]
- [internal] Use AdminSetting::getSetting method. [Jakub Onderka]
- [internal] Fetch just value for AdminSetting::getSetting method.
  [Jakub Onderka]
- [internal] Switch admin setting  name column to unique index. [Jakub
  Onderka]
- [internal] Faster Attribute search. [Jakub Onderka]
- [gitmodules] as Branch 2.x was removed from the original repository,
  we now use our own repo. [Alexandre Dulaunoy]
- [internal] Server::command_line_functions is generated on demand.
  [Jakub Onderka]
- [internal] Do not try to save config when config file is not
  writeable. [Jakub Onderka]
- [internal] Cleanup AdminShell::{updateJSON,runUpdates} [Jakub Onderka]
- [internal] Optimise saving logs. [Jakub Onderka]
- [internal] Cleanup unnecessary permissions. [Jakub Onderka]
- [internal] Simplify ACLComponent. [Jakub Onderka]
- [internal] AppController code cleanup. [Jakub Onderka]
- [internal] Move methods to specific controllers. [Jakub Onderka]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- Migrate /event_blocklist/add,edit to view factory. [Luciano Righetti]
- Move org blocklists add and edit to new views factories. [Luciano
  Righetti]
- Migrate org_blocklists/index view to factory. [Luciano Righetti]
- Detail attribute categories in openapi doc. [Luciano Righetti]
- Detail attribute types in openapi doc. [Luciano Righetti]
- Detail attribute types in openapi doc. [Luciano Righetti]
- [internal] Code cleanup. [Jakub Onderka]
- [UI] Better error messages when uploading MISP file. [Jakub Onderka]
- [taxonomies] updated. [Alexandre Dulaunoy]
- [internal] Try to fix validation when value1 and value2 provided.
  [Jakub Onderka]
- [UI] PGP error message. [Jakub Onderka]
- [internal] Do not fetch authkey from db. [Jakub Onderka]
- [internal] Do not fetch password from db. [Jakub Onderka]
- [internal] Do not fetch keys from db for authkey login. [Jakub
  Onderka]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [internal] Remove deprecated variables. [Jakub Onderka]
- [internal] Optimise fetching event index by org or by email. [Jakub
  Onderka]
- [internal] Check if file exists. [Jakub Onderka]
- [internal] Simplify ServerShell code. [Jakub Onderka]
- [internal] Faster capturing organisation. [Jakub Onderka]
- [internal] Remove AdminSetting from AuditLog. [Jakub Onderka]
- [internal] Use faster algo for checking duplicate objects. [Jakub
  Onderka]
- [internal] Faster editing attributes when change is required. [Jakub
  Onderka]
- [internal] Faster capturing object attributes. [Jakub Onderka]
- [internal] Faster processing freetext import. [Jakub Onderka]
- [UI] Add link to exact attribute for related attribute. [Jakub
  Onderka]
- [internal] Do not fetch tags for related attributes. [Jakub Onderka]
- [misp-wipe] wipe auth_keys tables. [Richard van den Berg]
- Add openapi docs for [POST]/admin/logs. [Luciano Righetti]
- [PyMISP] Bump. [Raphaël Vinot]
- [PyMISP] Bump. [Raphaël Vinot]
- Skip dev dependencies when installing via INSTALL.sh script. [Luciano
  Righetti]
- [alert] Deprecate `publish_alerts_summary_only`, this option just
  duplicate `event_alert_metadata_only` [Jakub Onderka]
- [user:checkNotificationBanStatus] Typo in comment. [mokaddem]
- [PyMISP] updated. [Alexandre Dulaunoy]
- [internal] Simplify code for editing object. [Jakub Onderka]
- [internal] Simplify code for editing attribute. [Jakub Onderka]
- [internal] Faster calls. [Jakub Onderka]
- [internal] Use correlation object from attribute. [Jakub Onderka]
- [internal] Faster deleting correlation when deleting attribute. [Jakub
  Onderka]
- [internal] Optimise ssdeep correlation. [Jakub Onderka]
- [internal] Use object variable and not Configure again and again.
  [Jakub Onderka]
- [internal] Do not fetch 'Event.disable_correlation' field. [Jakub
  Onderka]
- [internal] Fetch just necessary attributes when editing attribute.
  [Jakub Onderka]
- [internal] Fetch less CIDR for correlation. [Jakub Onderka]
- Add openapi docs for [POST]/admin/logs. [Luciano Righetti]
- [sync] Examine less events for sightings pulling. [Jakub Onderka]
- [UI] Sort orgs by name in statistics. [Jakub Onderka]
- [optim] Little optimise sighting statistics. [Jakub Onderka]
- [internal] Throw exception if JSON could not be encoded. [Jakub
  Onderka]
- [internal] Simplify capturing object code. [Jakub Onderka]
- [internal] Simplify capturing attribute code. [Jakub Onderka]
- [correlation] Allow to drop Correlation.{date,info} columns. [Jakub
  Onderka]
- [PyMISP] updated. [Alexandre Dulaunoy]
- [diagnostic] Bumped updated STIX python libraries versions. [chrisr3d]

  - Should fix diagnostic issues with version mentioned in #7054
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [internal] Server controller cleanup. [Jakub Onderka]
- [security] Use const hasher also for login. [Jakub Onderka]
- [sync] Use server sync to get available sync filtering rules. [Jakub
  Onderka]
- [sync] Simplify server post test code. [Jakub Onderka]
- [sync] Use server sync tool for connection test. [Jakub Onderka]
- [security] Mitigate timing attacks when comparing advanced auth keys
  hashes. [Jakub Onderka]
- [restResponseComponent] Added doc for new sighting/add filters
  parameter. [Sami Mokaddem]
- [sync] Filter out events that do not exist locally when pulling
  sightings. [Jakub Onderka]
- [sync] Pull just necessary data when pulling sightings. [Jakub
  Onderka]
- [sync] Use sync tool for pulling proposals. [Jakub Onderka]
- [validation] UUID unique validation. [Jakub Onderka]
- [schema] Mark more indexes as unique. [Jakub Onderka]
- [attributes] fixed typo in genCategoriesDefinitions function name.
  [Christophe Vandeplas]
- Update openapi spec with new parameters in add sightings endpoint.
  [Luciano Righetti]
- [i18n] Updated default.pot. [Steve Clement]
- [UI] Show matched value for warninglist search. [Jakub Onderka]
- [taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- Migrate sharing_views/view/[id] to factory. [Luciano Righetti]
- [sync] Remove `commit` and MISP-version from HTTP header. [Jakub
  Onderka]
- Remove previous /tags/edit view. [Luciano Righetti]
- Migrate /tags/add view to factory. [Luciano Righetti]
- [schema] Organisation name should be unique. [Jakub Onderka]
- [internal] Fetch just necessary fields when capturing tag. [Jakub
  Onderka]
- [internal] Do not fetch attribute tags when editing attribute. [Jakub
  Onderka]
- [schema] Tag name should be unique. [Jakub Onderka]
- [internal] Do not load exclusion list from Redis again and again.
  [Jakub Onderka]
- [sync] Pull events with less info. [Jakub Onderka]
- [schema] Sightings UUID column should be unique. [Jakub Onderka]
- [internal] Convert PubSubTool to static. [Jakub Onderka]
- [internal] Simplified code for adding events. [Jakub Onderka]
- [internal] Do not keep original variable to save memory. [Jakub
  Onderka]
- [internal] Simplified Event::getRelatedAttributes. [Jakub Onderka]
- [internal] Use hash for removing duplicate attributes. [Jakub Onderka]
- [internal] Use one EventLock instance. [Jakub Onderka]
- [internal] Cleanup code responsible for adding events. [Jakub Onderka]
- [rest] Change User-Agent to `MISP REST Client` [Jakub Onderka]
- [UI] Cleanup REST client template. [Jakub Onderka]
- [internal] Do not convert values to lower, since collation is already
  case-insensitive. [Jakub Onderka]
- [internal] Code style for event pulling. [Jakub Onderka]
- [sync] Refactor server overlap events fetching. [Jakub Onderka]
- [sync] Better error handling for pulling. [Jakub Onderka]
- [internal] Better exception handling for server sync. [Jakub Onderka]
- [logbehaviour] skipfields reverted to an array from a constant.
  [iglocska]

  - keeps ancient PHP versions happy (as happy as anyone can be knowing they run ancient PHP versions)
- [internal] Log exception for remote server POST test. [Jakub Onderka]
- [internal] Optimise updating galaxies. [Jakub Onderka]
- [internal] Remove unused methods. [Jakub Onderka]
- [internal] Galaxy cluster relation UUID must be RFC 4122 valid. [Jakub
  Onderka]
- [internal] Faster removing blocked events. [Jakub Onderka]
- [schema] Mark event_blocklist uuid column as unique. [Jakub Onderka]
- [taxonomies] Migrated views to use the UI factories. [mokaddem]
- [ui] Various improvements in factories. [mokaddem]

Fix
~~~
- [misp-stix] updated to the latest version (incorrect submodule)
  [Alexandre Dulaunoy]

  Fix #7812
- Sharing groups dropdown not showing when adding a feed with
  distribution set to sharing group. [Luciano Righetti]
- [misp-stix] Bumped latest version. [chrisr3d]
- [github actions] removed the cti stix installation as it's no longer
  there. [iglocska]
- [github actions] removed the cti stix installation as it's no longer
  there. [iglocska]
- [stix2 import] Using path to import the stix2 python library.
  [chrisr3d]
- [stix1 export] Added the required stix python library path for their
  import. [chrisr3d]

  - Support of the coming changes to use paths instead
    of maintaining the pip updates
- [stix1 import] Quick fix due to some recent changes library changes
  and the support of STIX 1.2. [chrisr3d]
- [stix export] Aligning path of the STIX2 python library to following
  its recent location change. [chrisr3d]
- [stix export] Added all the needed paths to load the required python
  libraries. [chrisr3d]
- [misp-stix] Bumped latest version with a quick fix on email objects
  export as STIX 2.0 & 2.1. [chrisr3d]
- [diagnostic] Updated stix2 python library requirements. [chrisr3d]
- [stix1 export] Removed debugging prints. [chrisr3d]
- [stix export] Quick single line php `if else` command clean-up.
  [chrisr3d]
- [gitmodules] Added current misp-stix branch. [chrisr3d]
- [misp-stix] Dumped latest MISP-STIX Converter version. [chrisr3d]
- [log] Do not call callbacks when deleting. [Jakub Onderka]
- [users] adding/modifying users fails silently for org admins if domain
  restriction checks fail. [iglocska]
- [organisations] correctly handle a list of org domain restrictions.
  [iglocska]
- [internal] Bad merge. [Jakub Onderka]
- Incorrect check for alertemail and publishSightings event commands.
  [Luciano Righetti]
- Incorrect check for publish event command. [Luciano Righetti]
- [shells] Sync improved cmd line help to 9d7da310. [Matjaz Rihtar]
- [shells] Additional command line help. [Matjaz Rihtar]
- [refanging] Fix test for commit b7733615. [Matjaz Rihtar]
- [shells] Fixed/improved command line help. [Matjaz Rihtar]
- [eventReport:contextExtraction] Make sure the cluster's value has
  enough characters before trying to perform the replacement. [mokaddem]
- [stix1 import] Fixed STIX header call that made the classification of
  the STIX file always being external. [chrisr3d]

  - `from_misp` variable was always False since the
    try / catch to get the title always raised an
    exception with `event.header` being an invalid
    attribute. The valid one is `event.stix_header`
- [internal] Better error handling when uploading STIX file. [Jakub
  Onderka]
- [internal] Undefined offset in AppController. [Jakub Onderka]
- Wrong input name. [Luciano Righetti]
- Add missing translation function. [Luciano Righetti]
- Remove CRUDComponent usage. [Luciano Righetti]
- Add missing new line. [Luciano Righetti]
- Remove CRUDComponent usage to mantain same api response. [Luciano
  Righetti]
- [eventReport:contextExtraction] Make sure the cluster's value has
  enough characters before trying to perform the replacement. [mokaddem]
- [internal] Modifying domain|ip attribute. [Jakub Onderka]
- [misp-retention] use update_tag. [Richard van den Berg]
- Bug correlation exclusion comment overriding value. [Luciano Righetti]
- [internal] Sending external e-mail. [Jakub Onderka]
- [UI] Fix link to user profile. [Jakub Onderka]
- [taxonomies] disabling tags via API call failed. [iglocska]
- [taxonomies] enabling breaks on POST request if named parameters
  aren't used. [iglocska]
- [Taxonomy] search for taxonomy by namespace when accessing
  /taxonomies/view. [iglocska]
- [internal] Argument parsing for testEventNotificationEmail command.
  [Jakub Onderka]
- [object] validation and modification fixes. [iglocska]

  - require certain metafields to be set (such as template uuid, template version, etc)
  - allow editing for unknown templates / no templates via the API (was previously incorrectly blocked / generated notices due to some UI related functionalities being triggered)
- [acl] Added routes in ACL. [mokaddem]
- [internal] Remove ssdeep data when deleting attribute. [Jakub Onderka]
- [internal] Filtering warninglist in objects. [Jakub Onderka]
- [UI] Warninglist order. [Jakub Onderka]
- [internal] Typo. [Jakub Onderka]
- Add missing requestBodies to servers endpoint. [Luciano Righetti]
- [internal] Fetching filter rules. [Jakub Onderka]
- [sync] Fix pulling sightings. [Jakub Onderka]
- [sync] Pushing sightings. [Jakub Onderka]
- [ACL] queryAvailableSyncFilteringRules is required just for site
  admins. [Jakub Onderka]
- [security] Check permission when viewing shadow attribute picture.
  [Jakub Onderka]
- [internal] Code cleanup. [Jakub Onderka]
- [API] Deprecation header. [Jakub Onderka]
- Fix query to make it work on all supported db engines. [Luciano
  Righetti]
- [tools] fixed gen_misp_types_categories script. [Christophe Vandeplas]
- Fix broken queries on postgres. [Luciano Righetti]
- [eventReport:reprotFromEvent] Make sure filtering condition are not
  empty. [mokaddem]
- [UI] Warninglist form. [Jakub Onderka]
- [event:filter_value] Allow searching for multiple values. [mokaddem]
- [db_schema] Fixed column default value for audit_log table - Fix
  #7662. [mokaddem]
- [event:view] Attribute filtering widget `deleted` parameter
  inconsistency. [mokaddem]

  - Potentially fix #7594
- [log] Array to string conversion. [Jakub Onderka]
- [API] Boolean options in index filter conditions. [Jakub Onderka]
- [internal] Shadow attributes don't have tags. [Jakub Onderka]
- [acl] Bumped ACL. [mokaddem]

Other
~~~~~
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [Alexandre Dulaunoy]
- Merge branch 'develop' of https://github.com/MISP/MISP into misp-stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into misp-stix.
  [chrisr3d]
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge branch 'develop' into 2.4. [iglocska]
- Merge branch 'develop' into 2.4. [iglocska]
- Merge branch 'misp-stix' into develop. [iglocska]
- Merge branch '2.4' of https://github.com/MISP/MISP into misp-stix.
  [chrisr3d]
- Add: [stix export] Submoduled all the required python libraries.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into misp-stix.
  [chrisr3d]
- Wip: [misp-stix] Bumped latest version. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into misp-stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into misp-stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into misp-stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into misp-stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into misp-stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into misp-stix.
  [chrisr3d]
- Wip: [stix2 export] Args parsing to better handle parameters & Support
  for STIX 2.1. [chrisr3d]
- Wip: [stix export, framing] Reworked misp_framing. [chrisr3d]

  - Made it cleaner
  - Made it support the STIX framing provided by
    misp-stix converter library
- Merge branch '2.4' of https://github.com/MISP/MISP into misp-stix.
  [chrisr3d]
- Wip: [stix2 export] Testing MISP-STIX python library with the included
  changes on the Export Lib and on the misp2stix2.py script. [chrisr3d]
- Add: [submodules, stix] Added MISP-STIX converter library as
  submodule. [chrisr3d]
- Merge pull request #7808 from JakubOnderka/tag-add. [Jakub Onderka]

  chg: [internal] Faster adding tags to attributes
- Merge pull request #7809 from JakubOnderka/audit-log-fix. [Jakub
  Onderka]

  fix: [log] Do not call callbacks when deleting
- Merge branch 'feature-force-https-for-pre-login-request' into develop.
  [Sami Mokaddem]
- Merge pull request #7805 from JakubOnderka/event-tag-attach. [Jakub
  Onderka]

  chg: [internal] Faster event tag attaching
- Merge pull request #7806 from JakubOnderka/bad-merge-fix. [Jakub
  Onderka]

  fix: [internal] Bad merge
- Merge remote-tracking branch 'origin/2.4' into develop. [Sami
  Mokaddem]
- Merge pull request #7224 from mrihtar/cmdLineHelp. [Andras Iklody]

  fix: [shells] Fixed/improved command line help
- Merge branch '2.4' into cmdLineHelp. [Matjaz Rihtar]

  # Conflicts:
  #	app/Console/Command/AdminShell.php
  #	app/Console/Command/EventShell.php
  #	app/Model/Server.php
- Merge branch 'MISP:2.4' into 2.4. [Matjaz Rihtar]
- Merge branch 'MISP:2.4' into 2.4. [Matjaz Rihtar]
- Merge pull request #1 from MISP/2.4. [Matjaz Rihtar]

  Sync fork with original MISP/MISP
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge pull request #7792 from JakubOnderka/misp-live-redis-v2. [Jakub
  Onderka]

  new: [internal] Store MISP live status also in Redis
- Merge pull request #7800 from JakubOnderka/file-accesss-tool. [Jakub
  Onderka]

  chg: [internal] Refactor FileAccessTool
- Merge pull request #7796 from JakubOnderka/org-blocklist. [Jakub
  Onderka]

  new: [internal] OrgBlocklist::removeBlockedEvents
- Merge pull request #7795 from JakubOnderka/event-view-controller.
  [Jakub Onderka]

  chg: [internal] Simplified EventsController::view code
- Merge pull request #7688 from JakubOnderka/server-sync-get-ids. [Jakub
  Onderka]

  chg: [sync] Use server sync tool for fetching remote events index
- Merge pull request #7779 from JakubOnderka/create-job. [Jakub Onderka]

  new: [internal] Method Job::createJob
- Merge pull request #7791 from JakubOnderka/admin-settings. [Jakub
  Onderka]

  Admin settings
- Merge pull request #7789 from JakubOnderka/stix-upload-error. [Jakub
  Onderka]

  Stix upload error
- Merge pull request #7788 from JakubOnderka/search-attr-faster. [Jakub
  Onderka]

  chg: [internal] Faster Attribute search
- Merge pull request #7778 from JakubOnderka/server-command-line. [Jakub
  Onderka]

  chg: [internal] Server::command_line_functions is generated on demand
- Merge pull request #7780 from JakubOnderka/btc-bech32. [Jakub Onderka]

  new: Support for BECH32 (P2WPKH) BTC address
- Merge pull request #7776 from JakubOnderka/user_shell_ip_user. [Jakub
  Onderka]

  new: [CLI] UserShell::ip_user command
- Merge pull request #7775 from JakubOnderka/set-setting-not-writeable.
  [Jakub Onderka]

  chg: [internal] Do not try to save config when config file is not writeable
- Merge pull request #7772 from JakubOnderka/update-cleanup. [Jakub
  Onderka]

  chg: [internal] Cleanup AdminShell::{updateJSON,runUpdates}
- Merge pull request #7774 from JakubOnderka/log-save-optim. [Jakub
  Onderka]

  chg: [internal] Optimise saving logs
- Merge pull request #7771 from JakubOnderka/cli-redis-available. [Jakub
  Onderka]

  new: [CLI] New tasks that will check if Redis is available
- Merge pull request #7769 from JakubOnderka/app-controller-cleanup-
  vol3. [Jakub Onderka]

  chg: [internal] AppController code cleanup
- Merge pull request #7768 from JakubOnderka/app-controller-cleanup-
  vol2. [Jakub Onderka]

  chg: [internal] Move methods to specific controllers
- Merge pull request #7767 from JakubOnderka/undefined-offset-fix.
  [Jakub Onderka]

  fix: [internal] Undefined offset in AppController
- Merge pull request #7571 from righel/migrate-org_blocklists-index-
  view. [Andras Iklody]

  Migrate org blocklists index view
- Revert "chg: migrate /event_blocklist/add,edit to view factory."
  [Luciano Righetti]

  This reverts commit 51f226fd8c79d5b7e514d459968e89c211535025.
- Merge pull request #7761 from JakubOnderka/code-cleanup-vol8. [Jakub
  Onderka]

  chg: [internal] Code cleanup
- Merge pull request #7762 from JakubOnderka/upload-mistp-file. [Jakub
  Onderka]

  chg: [UI] Better error messages when uploading MISP file
- Merge pull request #7722 from JakubOnderka/attribute-validation-fix.
  [Jakub Onderka]

  chg: [internal] Try to fix validation when value1 and value2 provided
- Merge pull request #7759 from JakubOnderka/pgp-view-pgp. [Jakub
  Onderka]

  chg: [UI] PGP error message
- Add: add initial api docs fo /taxonomies endpoints. [Luciano Righetti]
- Merge pull request #7754 from JakubOnderka/do-not-fetch-keys. [Jakub
  Onderka]

  chg: [internal] Do not fetch keys from db for authkey login
- Merge pull request #7758 from JakubOnderka/modify-domain|ip. [Jakub
  Onderka]

  fix: [internal] Modifying domain|ip attribute
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge pull request #7744 from RichieB2B/ncsc-nl/retention. [Sami
  Mokaddem]

  fix: [misp-retention] use update_tag
- Merge pull request #7752 from JakubOnderka/fix-sending-external.
  [Jakub Onderka]

  fix: [internal] Sending external e-mail
- Merge pull request #7753 from JakubOnderka/deprecated-variables.
  [Jakub Onderka]

  cchg: [internal] Remove deprecated variables
- Merge pull request #7590 from JakubOnderka/event-index-optim. [Jakub
  Onderka]

  chg: [internal] Optimise fetching event index by org or by email
- Doc: add /auth_keys/* endpoints to openapi spec. [Luciano Righetti]
- Merge pull request #7746 from JakubOnderka/security-audit-file. [Jakub
  Onderka]

  chg: [internal] Check if file exists
- Merge pull request #7725 from JakubOnderka/server-shell. [Jakub
  Onderka]

  chg: [internal] Simplify ServerShell code
- Merge pull request #7740 from JakubOnderka/capture-org-faster. [Jakub
  Onderka]

  chg: [internal] Faster capturing organisation
- Merge pull request #7739 from JakubOnderka/audit-log-admin-setting.
  [Jakub Onderka]

  chg: [internal] Remove AdminSetting from AuditLog
- Merge pull request #7733 from JakubOnderka/capture-object-attributes.
  [Jakub Onderka]

  chg: [internal] Faster capturing object attributes
- Merge pull request #7738 from JakubOnderka/related-faster. [Jakub
  Onderka]

  chg: [internal] Faster processing freetext import
- Merge pull request #7737 from JakubOnderka/related-faster. [Jakub
  Onderka]

  chg: [internal] Do not fetch tags for related attributes
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge pull request #7720 from RichieB2B/ncsc-nl/wipe-auth. [Alexandre
  Dulaunoy]

  chg: [misp-wipe] wipe auth_keys tables
- Merge pull request #7734 from righel/add-composer-no-dev-flag. [Steve
  Clement]

  chg: skip dev dependencies when installing via INSTALL.sh script.
- Merge pull request #7579 from
  JakubOnderka/publish_alerts_summary_only_deprecate. [Jakub Onderka]

  chg: [alert] Deprecate `MISP.publish_alerts_summary_only`
- Merge pull request #7732 from JakubOnderka/tag-merging. [Jakub
  Onderka]

  new: [shell] Tag merging
- Merge branch 'migration-taxonomy' into develop. [mokaddem]
- Merge branch 'develop' of github.com:MISP/MISP into migration-
  taxonomy. [mokaddem]
- Merge branch 'feature-cerebrate-sg-pull' into develop. [mokaddem]
- Merge branch 'develop' of github.com:MISP/MISP into feature-cerebrate-
  sg-pull. [mokaddem]
- Merge branch 'feature-email-notification-bans' into develop.
  [mokaddem]
- Merge branch 'develop' of github.com:MISP/MISP into feature-email-
  notification-bans. [mokaddem]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into feature-email-
  notification-bans. [mokaddem]
- Merge pull request #7728 from JakubOnderka/edit-attr-simplify. [Jakub
  Onderka]

  chg: [internal] Simplify code for editing attribute
- Merge pull request #7727 from JakubOnderka/correlation-optim. [Jakub
  Onderka]

  Correlation optim
- Merge pull request #7724 from JakubOnderka/attr-edit-speedup. [Jakub
  Onderka]

  chg: [internal] Fetch just necessary attributes when editing attribute
- Merge pull request #7723 from JakubOnderka/less-cidr. [Jakub Onderka]

  chg: [internal] Fetch less CIDR for correlation
- Merge pull request #7721 from JakubOnderka/fix-typo. [Jakub Onderka]

  fix: [internal] Typo
- Merge pull request #7719 from JakubOnderka/warninglist-filtering.
  [Jakub Onderka]

  new: [UI] Allow to filter attributes by specific warninglist
- Merge pull request #7713 from JakubOnderka/sync-pull-sightings. [Jakub
  Onderka]

  chg: [sync] Examine less events for sightings pulling
- Merge pull request #7712 from JakubOnderka/sight-stats-optim. [Jakub
  Onderka]

  chg: [optim] Little optimise sighting statistics
- Merge pull request #7708 from JakubOnderka/json-throw-exception.
  [Jakub Onderka]

  chg: [internal] Throw exception if JSON could not be encoded
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [mokaddem]
- Merge pull request #7704 from JakubOnderka/capture-attr-refactor.
  [Jakub Onderka]

  chg: [internal] Simplify capturing attribute code
- Merge pull request #7706 from JakubOnderka/fix-filter-rules. [Jakub
  Onderka]

  fix: [internal] Fetching filter rules
- Merge pull request #6021 from JakubOnderka/correlations-dummy-values.
  [Jakub Onderka]

  chg: [correlation] Allow to drop Correlation.{date,info} columns
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge pull request #7691 from JakubOnderka/user-shell. [Jakub Onderka]

  new: [CLI] User shell
- Merge branch '2.4' of github.com:MISP/MISP into develop. [Alexandre
  Dulaunoy]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [Alexandre Dulaunoy]
- Merge pull request #7696 from JakubOnderka/server-controller-cleanup.
  [Jakub Onderka]

  chg: [internal] Server controller cleanup
- Merge pull request #7692 from JakubOnderka/const-hasher-password.
  [Jakub Onderka]

  chg: [security] Use const hasher also for login
- Merge pull request #7693 from JakubOnderka/oidc_auth_unblock. [Jakub
  Onderka]

  new: [oidc] Allow to automatically unblock user after successful login
- Merge pull request #7683 from JakubOnderka/pull-sightings-optimise.
  [Jakub Onderka]

  fix: [sync] Fix pulling sightings
- Merge pull request #7634 from JakubOnderka/fix-sighting-push-vol2.
  [Jakub Onderka]

  fix: [sync] Pushing sightings
- Merge pull request #7672 from JakubOnderka/acl-fix. [Jakub Onderka]

  fix: [ACL] queryAvailableSyncFilteringRules is required just for site admins
- Merge pull request #7673 from JakubOnderka/sync-filter-ref. [Jakub
  Onderka]

  chg: [sync] Use server sync to get available sync filtering rules
- Merge pull request #7686 from JakubOnderka/code-fixes. [Jakub Onderka]

  Code fixes
- Merge pull request #7685 from JakubOnderka/fix-deprecation-warning.
  [Jakub Onderka]

  fix: [API] Deprecation header
- Merge pull request #7678 from JakubOnderka/post-test-simplify. [Jakub
  Onderka]

  chg: [sync] Simplify server post test code
- Merge pull request #7676 from JakubOnderka/connection-test-server-
  sync. [Jakub Onderka]

  chg: [sync] Use server sync tool for connection test
- Merge pull request #7677 from JakubOnderka/mitigate-timing-attacks.
  [Jakub Onderka]

  chg: [security] Mitigate timing attacks
- Merge pull request #7675 from JakubOnderka/authkeys-autocompelte-off.
  [Jakub Onderka]

  new: [security] Disable browser autocomplete for authkeys field
- Merge branch 'develop' of github.com:MISP/MISP into develop. [Luciano
  Righetti]
- Merge pull request #7649 from JakubOnderka/pull-sightings. [Jakub
  Onderka]

  chg: [sync] Pull just necessary data when pulling sightings
- Merge pull request #7650 from JakubOnderka/pull-proposals-vol2. [Jakub
  Onderka]

  chg: [sync] Use sync tool for pulling proposals
- Merge pull request #7659 from JakubOnderka/unique-indexes. [Jakub
  Onderka]

  chg: [schema] Mark more indexes as unique
- Security: fix unescaped parameter leading to sqli. [Luciano Righetti]
- Merge branch '2.4' of github.com:MISP/MISP into develop. [Alexandre
  Dulaunoy]
- Merge pull request #7694 from SteveClement/i18n. [Steve Clement]

  chg: [i18n] Updated default.pot
- Security: fix unescaped parameter leading to sqli. [Luciano Righetti]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [mokaddem]
- Merge pull request #7666 from JakubOnderka/assign-comment. [Jakub
  Onderka]

  new: [warninglist] Assign warninglist comment
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge pull request #7665 from JakubOnderka/fix-7663. [Jakub Onderka]

  fix: [log] Array to string conversion
- Merge pull request #7641 from righel/migrate-sharing-groups-views.
  [Andras Iklody]

  chg: migrate sharing_views/view/[id] to factory
- Merge pull request #7648 from JakubOnderka/remove-http-commit. [Andras
  Iklody]

  chg: [sync] Remove commit and MISP-version from HTTP header
- Merge pull request #7656 from righel/migrate-tags-views. [Andras
  Iklody]

  Migrate tags views
- Merge pull request #7657 from JakubOnderka/org-name-unique. [Jakub
  Onderka]

  Org name unique
- Merge pull request #7653 from JakubOnderka/edit-event-optim. [Jakub
  Onderka]

  chg: [internal] Do not fetch attribute tags when editing attribute
- Merge pull request #7654 from JakubOnderka/tag-name-unique. [Jakub
  Onderka]

  chg: [schema] Tag name should be unique
- Merge pull request #7655 from JakubOnderka/do-not-load-exclusion-
  again. [Jakub Onderka]

  chg: [internal] Do not load exclusion list from Redis again and again
- Merge pull request #7651 from JakubOnderka/event-index-filter. [Jakub
  Onderka]

  fix: [API] Boolean options in index filter conditions
- Merge pull request #7644 from JakubOnderka/pull-less-info. [Jakub
  Onderka]

  chg: [sync] Pull events with less info
- Merge pull request #7645 from JakubOnderka/sightins-uuid-unique.
  [Jakub Onderka]

  chg: [schema] Sightings UUID column should be unique
- Merge pull request #7643 from JakubOnderka/pubsub-static. [Jakub
  Onderka]

  chg: [internal] Convert PubSubTool to static
- Merge pull request #7541 from JakubOnderka/delete-event-refactor.
  [Jakub Onderka]

  new: [API] Allow to delete multiple events by UUID
- Merge pull request #7640 from JakubOnderka/add-event-cleanup-part.
  [Jakub Onderka]

  Add event cleanup
- Merge pull request #7587 from JakubOnderka/rest-client-user-agent.
  [Jakub Onderka]

  Change User-Agent to MISP REST Client
- Merge pull request #7617 from JakubOnderka/attribute-search. [Jakub
  Onderka]

  chg: [internal] Do not convert values to lower, since collation is al…
- Merge pull request #7639 from JakubOnderka/pull-codestyle. [Jakub
  Onderka]

  chg: [internal] Code style for event pulling
- Merge pull request #7637 from JakubOnderka/test-syncc. [Jakub Onderka]

  new: [test] Test more endpoints in sync test
- Merge pull request #7636 from JakubOnderka/event-view-spec. [Jakub
  Onderka]

  new: [API] Allow more granular specification what data to return when viewing event
- Merge pull request #7635 from JakubOnderka/server-overlap-method.
  [Jakub Onderka]

  chg: [sync] Refactor server overlap events fetching
- Merge pull request #7625 from JakubOnderka/pull-error-handling. [Jakub
  Onderka]

  chg: [sync] Better error handling for pulling
- Merge pull request #7632 from JakubOnderka/server-sync-exception.
  [Jakub Onderka]

  chg: [internal] Better exception handling for server sync
- Merge branch '2.4' into develop. [iglocska]
- Merge pull request #7627 from JakubOnderka/post-test-error-log. [Jakub
  Onderka]

  chg: [internal] Log exception for remote server POST test
- Merge pull request #7610 from JakubOnderka/galaxy-update-vol2. [Jakub
  Onderka]

  Galaxy update vol2
- Merge pull request #7615 from JakubOnderka/event_blocklist_unique.
  [Jakub Onderka]

  Event blocklist unique
- Merge pull request #7628 from JakubOnderka/fix-invalid-foreach. [Jakub
  Onderka]

  fix: [internal] Shadow attributes don't have tags
- Merge branch 'develop' of github.com:MISP/MISP into migration-
  taxonomy. [mokaddem]


v2.4.148 (2021-08-05)
---------------------

New
~~~
- [test] Check schema diagnostics in CI. [Jakub Onderka]
- [citation-cff] added. [Alexandre Dulaunoy]
- [citation-cff] added. [Alexandre Dulaunoy]
- [test] Security test for publishing events. [Jakub Onderka]

Changes
~~~~~~~
- [VERSION] bump. [iglocska]
- [PyMISP] Bump recommended version. [Raphaël Vinot]
- [PyMISP] Bump. [Raphaël Vinot]
- [internal] Use ServerSyncTool for fetching remote user info. [Jakub
  Onderka]
- [internal] org_blocklists.org_uuid should be unique index. [Jakub
  Onderka]
- [internal] Organisation and object UUID should be unique. [Jakub
  Onderka]
- [zmq] Convert array to JSON at one place. [Jakub Onderka]
- [internal] Optimise loading attribute histogram. [Jakub Onderka]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- [opendata] updated and changed parameter handling. [iglocska]
- [shibbauth] added option to block organisation changes at login - New
  ApacheShibbAuth.BlockOrgModifications setting added, defaults to
  false, boolean. If set to true, will block updates to the organisation
  of existing users on authentication. This preserves any modifications
  made by a site admin in MISP and is similar to
  ApacheShibbauth.BlockRoleModifications (same logic applied to role
  modifications). [Liviu Valsan]
- [API] Refactor event publishing. [Jakub Onderka]
- [internal] Convert array to const. [Jakub Onderka]
- [internal] Convert array to const. [Jakub Onderka]
- [internal] Simplified Attribute::deleteAttribute method. [Jakub
  Onderka]
- [internal] Removed unused variables. [Jakub Onderka]
- [internal] Remove unused variable. [Jakub Onderka]
- [internal] Convert array to const. [Jakub Onderka]
- [shibbauth] added option to block organisation changes at login - New
  ApacheShibbAuth.BlockOrgModifications setting added, defaults to
  false, boolean. If set to true, will block updates to the organisation
  of existing users on authentication. This preserves any modifications
  made by a site admin in MISP and is similar to
  ApacheShibbauth.BlockRoleModifications (same logic applied to role
  modifications). [Liviu Valsan]
- [compatibility] scoped constant changed to unscoped to allow for 7.0
  compatibility. [iglocska]

  - update your PHP version though

Fix
~~~
- [js] Show correct error message for get remote version. [Jakub
  Onderka]
- [UI] Show correct error message for get remote user. [Jakub Onderka]
- [sync] Fetching remote server version. [Jakub Onderka]
- [schema] audit_logs.authkey_id columns should be nullable. [Jakub
  Onderka]
- [zmq] Add missing `misp_json_warninglist` topic to Python script.
  [Jakub Onderka]
- [API] Undefined index when just last_seen is set. [Jakub Onderka]
- [afterHook] for setting changes wasn't returning true, fixes 7477.
  [iglocska]

  - this caused the CLI setting change to error out
- [stix2misp] Use describeTypes from PyMISP. [Jakub Onderka]
- [security] Stored XSS when viewing galaxy cluster relationships - As
  reported by Dawid Czarnecki. [mokaddem]
- [security] Stored XSS when viewing galaxy cluster elements in JSON
  format. [mokaddem]
- [compatibility] several scoped constants reverted. [iglocska]
- [proposal alert email] function call fixed. [iglocska]

Other
~~~~~
- Merge branch 'develop' into 2.4. [iglocska]
- Merge pull request #7624 from JakubOnderka/get-remote-user-fixes.
  [Jakub Onderka]

  fix: [UI] Show correct error message for get remote user
- Merge pull request #7622 from JakubOnderka/fix-fetching-version.
  [Jakub Onderka]

  fix: [sync] Fetching remote server version
- Merge pull request #7619 from JakubOnderka/get-remote-update. [Jakub
  Onderka]

  chg: [internal] Use ServerSyncTool for fetching remote user info
- Merge pull request #7620 from JakubOnderka/database-indexes. [Jakub
  Onderka]

  Database indexes
- Merge pull request #7568 from JakubOnderka/zmq. [Jakub Onderka]

  Add missing misp_json_warninglist topic to Python script
- Merge pull request #7606 from JakubOnderka/undefined-index-fix. [Jakub
  Onderka]

  fix: [API] Undefined index when just last_seen is set
- Merge pull request #7614 from JakubOnderka/optimise-statistics. [Jakub
  Onderka]

  chg: [internal] Optimise loading attribute histogram
- Merge branch '2.4' into develop. [iglocska]
- Merge pull request #7613 from lk-dll/patch-1. [Alexandre Dulaunoy]

  quick fix sticky buffers
- Quick fix sticky buffers. [lk-dll]

  According to documention (https://suricata.readthedocs.io/en/suricata-6.0.3/rules/http-keywords.html#http-keywords) sticky buffers should be before content, http.header and http.uri isn't marked as sticky buffers, but rules are wrongly generated and reported to logs. Tested on stable Suricata v6.0.1+
- Quick fix sticky buffers. [lk-dll]

  According to documention (https://suricata.readthedocs.io/en/suricata-6.0.3/rules/http-keywords.html#http-keywords) sticky buffers should be before content, http.header and http.uri isn't marked as sticky buffers, but rules are wrongly generated and reported to logs. Tested on stable Suricata v6.0.1+
- Merge pull request #7500 from JakubOnderka/stix-to-misp-types-path.
  [Jakub Onderka]

  Stix to misp types path
- Merge branch '2.4' of github.com:MISP/MISP into develop. [Alexandre
  Dulaunoy]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge remote-tracking branch 'origin/2.4' into develop. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #7602 from liviuvalsan/shib_user_org. [Alexandre
  Dulaunoy]

  chg: [shibbauth] added option to block organisation changes at login
- Merge branch 'develop' into 2.4. [iglocska]
- Merge branch 'develop' into 2.4. [iglocska]
- Merge pull request #7539 from JakubOnderka/publishing-refactoring.
  [Jakub Onderka]

  Refactor publishing event
- Merge pull request #7609 from JakubOnderka/code-cleanup-vol6. [Jakub
  Onderka]

  Code cleanup vol6
- Merge pull request #7607 from JakubOnderka/non-correlationg-types-
  const. [Jakub Onderka]

  chg: [internal] Convert array to const
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]


v2.4.147 (2021-07-27)
---------------------

New
~~~
- [sync] When saving sightings, push just new sightings. [Jakub Onderka]
- [sync] When pushing event, upload sightings by another call. [Jakub
  Onderka]
- [sync] Filter out existing sightings if remote sever supports that
  method. [Jakub Onderka]
- [sync] Method for filtering out existing sightings. [Jakub Onderka]
- [API] Taxonomy export. [Jakub Onderka]
- [misp2stix2] Return traceback for error. [Jakub Onderka]

Changes
~~~~~~~
- [version] bump. [iglocska]
- [PyMISP] bump. [iglocska]
- [security audit] Check config.php.bk file permission. [Jakub Onderka]
- [internal] Create config backup just when it is necessary. [Jakub
  Onderka]
- [internal] Reset PHP cache after config file is successfully changed.
  [Jakub Onderka]
- [test] Move PHP tests to different task. [Jakub Onderka]
- [PyMISP] bump. [iglocska]
- [PyMISP] bump. [iglocska]
- [UI] Use time element for event published timestamp. [Jakub Onderka]
- [UI] Raise font size of local org description. [Jakub Onderka]
- [UI] After creating new org, redirect to org details. [Jakub Onderka]
- [UI] Add link to add new organisation. [Jakub Onderka]
- [republish ban] enabled by default on new installs. [iglocska]
- [config] Added missing options Fix #7549. [mokaddem]
- [CLI] better error messages when a setting change fails. [iglocska]

  - explain why it failed
  - explain how a user can override it
- [misp-objects] fix #7599. [Alexandre Dulaunoy]
- [misp-warninglists] updated to the latest version. [Alexandre
  Dulaunoy]
- Migrate threads/index to factory view. [Luciano Righetti]
- Migrate /event_blocklist/add,edit to view factory. [Luciano Righetti]
- Migrate /event_blocklists/index to view factory. [Luciano Righetti]
- Migrate /templates/view/:id to view factory. [Luciano Righetti]
- Reuse add view for /templates/edit. [Luciano Righetti]
- Migrate /templates/add view to factory. [Luciano Righetti]
- Migrate /templates/index view, use CRUD compoenent in
  TemplatesController::delete() [Luciano Righetti]
- [internal] Use const arrays. [Jakub Onderka]
- [internal] Use strict comparison. [Jakub Onderka]
- [internal] Use constants that should be faster. [Jakub Onderka]
- [UI] Simplified generating categories that can be malware sample.
  [Jakub Onderka]
- [internal] Remove unused method. [Jakub Onderka]
- [internal] Remove unnecessary method calls. [Jakub Onderka]
- [internal] Move variable from AppModel to Server model. [Jakub
  Onderka]
- [internal] Convert variable to const. [Jakub Onderka]
- [internal] Remove JS helper from controllers. [Jakub Onderka]
- [user:updateToAdvancedAuthKeys] Functionality accessible via the CLI.
  [mokaddem]
- [logs] Add link to SG and Taxonomy in AuditLog. [Jakub Onderka]
- Initial port genericForm changes from cerebrate. [Luciano Righetti]
- Migrate FeedsController to use CRUD component. [Luciano Righetti]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- [galaxies:view_relations] Both inbound and outbound relations can be
  viewed. [mokaddem]
- [galaxyClusters:view] Both inbound and outbound relations can be
  viewed. [mokaddem]
- [genericElement:topbar] Support of raw html. [mokaddem]
- [sync] Faster capturing sighting when pushing whole event. [Jakub
  Onderka]
- [sync] Optimise event filtering. [Jakub Onderka]
- [sync] Check if event exists before pushing. [Jakub Onderka]
- [sync] Remove old method for uploading sightings. [Jakub Onderka]
- [sync] Check event existence before pushing sightings. [Jakub Onderka]
- [sync] New separate method for uploading sightings to remote server.
  [Jakub Onderka]
- [internal] Disable unicode escaping for JSON. [Jakub Onderka]
- [diagnostic] STIX diagnostics. [Jakub Onderka]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [internal] Use standardized response output. [Jakub Onderka]
- [internal] Remove redundant checks. [Jakub Onderka]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [internal] Regenerate warninglist cache just when save was successful.
  [Jakub Onderka]
- [internal] Use less memory when inserting warninglist to db. [Jakub
  Onderka]
- [API] Deprecate getPyMISPVersion and returns required info in
  getVersion. [Jakub Onderka]
- [mispObject:breakOnDuplicate] Provide more feedback. [mokaddem]
- [installer] Update to latest version. [Steve Clement]
- [installer] Update to latest version. [Steve Clement]
- [doc] Guides now compatible with Fedora WS/Server 34. [Steve Clement]
- [warning-list] updated. [Alexandre Dulaunoy]

Fix
~~~
- [test] Set expected config for security tests. [Jakub Onderka]
- [test] Check if user is logged. [Jakub Onderka]
- [config defaults] unset the default python bin path. [iglocska]
- [config defaults] changed default attachment storage. [iglocska]
- [Userinit] create advanced auth key when needed. [iglocska]
- [config] Fixed indentation. [mokaddem]
- [test] Redis password can be empty. [Jakub Onderka]
- [test] After CLI setSetting change. [Jakub Onderka]
- [security] Stored XSS when forking a galaxy cluster As reported by
  Giuseppe Diego Gianni. [mokaddem]
- [posts] add org field to email job. [iglocska]
- Add missing newline. [Luciano Righetti]
- Rename container div. [Luciano Righetti]
- Add mass selector for deleting event blocklists. [Luciano Righetti]
- Remove old copy. [Luciano Righetti]
- Add view action to index templates. [Luciano Righetti]
- [internal] Remove unused variable. [Jakub Onderka]
- [API] Remove duplicate objects from warninglist. [Jakub Onderka]
- [internal] Remove unused variable. [Jakub Onderka]
- Add missing search parameters for [POST]/events/index. [Luciano
  Righetti]
- [UI] Do not use inline JS. [Jakub Onderka]
- [API] Always return bool for perm fields in getVersion response.
  [Jakub Onderka]
- Nest noticelist entries inside Noticelist property. [Luciano Righetti]
- Add noticelist entries in view response. [Luciano Righetti]
- Undefined index notice when enable/disable noticelist. [Luciano
  Righetti]
- Remove unsused field. [Luciano Righetti]
- Merge develop branch. [Luciano Righetti]
- Fix ui issues on multiple views. [Luciano Righetti]
- Add missing input descriptions. [Luciano Righetti]
- Fix pr comments: add warning notice for local feeds disabled on
  feeds/add, fix various ui elements. [Luciano Righetti]
- Add missing refresh to feed pull rules. [Luciano Righetti]
- Fix issue when adding attribute, add optionalField class to inputs.
  [Luciano Righetti]
- Fix pr comments: replace whitelist->allowlist, checkbox label inline,
  add missing feed fields for csv and freetext. add missing button for
  adding basic auth headers. [Luciano Righetti]
- Remove required attr from hidden inputs in add attribute form.
  [Luciano Righetti]
- Remove required attr from hidden inputs in add event form. [Luciano
  Righetti]
- Escape js variable. [Luciano Righetti]
- Fix error when decoding array feed settings, maintain same response
  schema as before. [Luciano Righetti]
- Add type dropdown in all generic forms. [Luciano Righetti]
- Fix pull rules legend not showing on feeds/edit load. [Luciano
  Righetti]
- Handle feed rules. [Luciano Righetti]
- Fix genericForm builder issues. [Luciano Righetti]
- Only override values that were set in the input. [Luciano Righetti]
- Allow 0 or '0' to be a possible field value, for example 'selected'
  property. [Luciano Righetti]
- [sync] Better error handling when fetching IDs for push/pull. [Jakub
  Onderka]
- [tags:attachTagToObject] No longer return a failure message is
  relation already exists Fix #6569. [mokaddem]
- [organisations:view] Restored org logo Fix #7491. [mokaddem]
- [event:contact] User object passed in contact reporter Fix #7471.
  [mokaddem]
- [sync] Do not append 'metadata:1' when pushing event. [Jakub Onderka]
- [attribute:edit] Make sure event_id cannot be changed. [mokaddem]
- [tags:detachFromObject] Make travis test passes. [mokaddem]
- [internal] Update object relationships when updating JSONs. [Jakub
  Onderka]
- [API] Check if user can view object that contains reference. [Jakub
  Onderka]
- [UI] Trim object UUID when adding reference. [Jakub Onderka]
- [internal] Change exception type. [Jakub Onderka]
- [internal] Relationship import. [Jakub Onderka]
- [tag] Update object's timestamp and unpublish only if in global
  context Fix #5806. [mokaddem]
- [internal] Faster deleting warninglist. [Jakub Onderka]
- [galaxies:add] Missing entry in sidebar Fix #7499. [mokaddem]
- [install:MySQL] Removed org_blacklists table creation Fix #7476.
  [mokaddem]
- Wrong attribute value hash computed inside checkForDuplicateObjects
  function. [Sebastiano Mariani]
- [doc] Fix conditonal error. [Steve Clement]
- [tools] Catch openssl not being installed. [Steve Clement]
- [galaxies:add] Missing entry in sidebar Fix #7499. [mokaddem]

Other
~~~~~
- Merge branch 'develop' into 2.4. [iglocska]
- Merge branch 'develop' into 2.4. [iglocska]
- Merge pull request #7603 from JakubOnderka/fix-tests-vol2. [Jakub
  Onderka]

  Fix tests vol2
- Merge pull request #7596 from JakubOnderka/publishd-time. [Jakub
  Onderka]

  chg: [UI] Use time element for event published timestamp
- Merge pull request #7589 from JakubOnderka/org-ui. [Jakub Onderka]

  Org UI
- Merge branch 'config_defaults' into develop. [iglocska]
- Merge pull request #7600 from JakubOnderka/fix-tests. [Jakub Onderka]

  fix: [test] After CLI setSetting change
- Merge remote-tracking branch 'origin/2.4' into develop. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into develop. [Alexandre
  Dulaunoy]
- Merge pull request #7578 from Cooper-Dale/patch-1. [Alexandre
  Dulaunoy]

  updated suricata legacy modifiers
- Updated suricata legacy modifiers. [Cooper Dale]

  based on https://suricata.readthedocs.io/en/suricata-6.0.3/rules/tls-keywords.html?highlight=tls_sni#tls-sni
  https://suricata.readthedocs.io/en/suricata-6.0.3/rules/http-keywords.html#http-keywords
  https://suricata.readthedocs.io/en/suricata-6.0.3/rules/dns-keywords.html
- Merge branch 'threads_refactor' into develop. [iglocska]
- Merge branch 'blocklist_refactor' into develop. [iglocska]
- Merge branch 'template_refactor' into develop. [iglocska]
- Merge pull request #7595 from JakubOnderka/code-cleanup-vol4. [Jakub
  Onderka]

  Code cleanup vol4
- Merge pull request #7581 from JakubOnderka/simplified-template. [Jakub
  Onderka]

  chg: [UI] Simplified generating categories that can be malware sample
- Merge pull request #7562 from JakubOnderka/warninglist-output. [Jakub
  Onderka]

  fix: [API] Remove duplicate objects from warninglist
- Merge pull request #7583 from JakubOnderka/code-cleanup-vol2. [Jakub
  Onderka]

  Code cleanup
- Merge pull request #7538 from JakubOnderka/js-helper. [Jakub Onderka]

  chg: [internal] Remove JS helper from controllers
- Merge branch 'develop' of github.com:MISP/MISP into develop. [Luciano
  Righetti]
- Updated suricata legacy modifiers. [Cooper Dale]

  based on https://suricata.readthedocs.io/en/suricata-6.0.3/rules/tls-keywords.html?highlight=tls_sni#tls-sni
  https://suricata.readthedocs.io/en/suricata-6.0.3/rules/http-keywords.html#http-keywords
  https://suricata.readthedocs.io/en/suricata-6.0.3/rules/dns-keywords.html
- Merge remote-tracking branch 'origin/2.4' into develop. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch 'shibb' into develop. [iglocska]
- Block org modiufication option for shibb auth. [mzp]
- Merge pull request #7560 from JakubOnderka/audit-sg. [Jakub Onderka]

  Add link to SG and Taxonomy in AuditLog
- Merge pull request #7566 from JakubOnderka/getversion-bool. [Jakub
  Onderka]

  fix: [API] Always return bool for perm fields in getVersion response
- Merge pull request #7357 from righel/refactor-noticelists-controller-
  to-use-crud-component. [Luciano Righetti]

  chg: refactor noticelists controller to use crud component
- Merge develop. [Luciano Righetti]
- Merge pull request #7520 from righel/migrate-feeds-controller-to-crud-
  component. [Luciano Righetti]

  chg: migrate feeds controller to crud component
- Merge branch 'develop' into migrate-feeds-controller-to-crud-
  component. [Luciano Righetti]
- Merge branch 'pr-7551' into develop. [mokaddem]
- Merge remote-tracking branch 'origin/develop' into pr-7551. [mokaddem]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [mokaddem]
- Merge pull request #7433 from JakubOnderka/sync-clusters-error-
  handling. [Jakub Onderka]

  fix: [sync] Better error handling when fetching IDs for push/pull
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [mokaddem]
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge pull request #6817 from JakubOnderka/upload-sightings. [Jakub
  Onderka]

  chg: [sync] New separate method for uploading sightings to remote server
- Merge pull request #7157 from JakubOnderka/sighting-push-filtering.
  [Jakub Onderka]

  new: [sync] Method for filtering out existing sightings
- Merge pull request #7558 from JakubOnderka/taxonomy_export. [Jakub
  Onderka]

  new: [API] Taxonomy export
- Merge pull request #7553 from JakubOnderka/stix-diagnostics. [Jakub
  Onderka]

  chg: [diagnostic] STIX diagnostics
- Merge branch '2.4' of github.com:MISP/MISP into develop. [Alexandre
  Dulaunoy]
- Merge remote-tracking branch 'origin/2.4' into develop. [mokaddem]
- Merge branch 'fix-5806' into develop. [mokaddem]
- Merge remote-tracking branch 'origin/develop' into fix-5806.
  [mokaddem]
- Merge pull request #7530 from JakubOnderka/fix-relationship-import.
  [Jakub Onderka]

  fix: [internal] Relationship import
- Merge pull request #7555 from JakubOnderka/misp2stix_traceback. [Jakub
  Onderka]

  new: [misp2stix2] Return traceback for error
- Merge remote-tracking branch 'origin' into develop. [Alexandre
  Dulaunoy]
- Merge pull request #7540 from MISP/2.4. [Jakub Onderka]

  Merge 2.4 to develop to fix build
- Merge pull request #7532 from JakubOnderka/warninglist-quick-delete.
  [Jakub Onderka]

  fix: [internal] Faster deleting warninglist
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [mokaddem]
- Merge pull request #7525 from JakubOnderka/deprecate-getpymisp-
  version. [Jakub Onderka]

  chg: [API] Deprecate getPyMISPVersion
- Merge branch '2.4' into develop. [iglocska]
- Merge pull request #7537 from SteveClement/guides. [Steve Clement]

  fix: [doc] Fix conditonal error
- Merge pull request #7536 from SteveClement/tools. [Steve Clement]

  fix: [tools] Catch openssl not being installed
- Merge pull request #7535 from SteveClement/guides. [Steve Clement]

  chg: [doc] Guides now compatible with Fedora WS/Server 34
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Add search bar, fix col widths, show ref field as links. [Luciano
  Righetti]
- Deserialize ref and geographical_area fields in index and view
  endpoints. [Luciano Righetti]
- Resolve pr comments. [Luciano Righetti]
- Support toggle noticelist enable checkbox. [Luciano Righetti]
- Fix noticelist message not showing. [Luciano Righetti]
- Refactor noticelists index and view to use crud component. [Luciano
  Righetti]
- Add crud component noticelists index. [Luciano Righetti]


v2.4.146 (2021-06-30)
---------------------

New
~~~
- [API] Read only authkeys. [Jakub Onderka]

Changes
~~~~~~~
- [VERSION] bump. [iglocska]
- [log] Remove ObjectRelationship from audit log. [Jakub Onderka]
- [internal] Simplify generating some JSON responses. [Jakub Onderka]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]

Fix
~~~
- [UI] Loading non exists library in Audit log index. [Jakub Onderka]
- [event:add] Typo in accessing sharing group roaming information.
  [mokaddem]

Other
~~~~~
- Merge branch 'develop' into 2.4. [iglocska]
- Merge pull request #7533 from JakubOnderka/audit-log-ui-fix. [Jakub
  Onderka]

  fix: [UI] Loading non exists library in Audit log index
- Merge remote-tracking branch 'origin/2.4' into develop. [mokaddem]
- Merge pull request #7482 from JakubOnderka/authkey-read-only. [Jakub
  Onderka]

  new: [API] Read only authkeys
- Merge pull request #7527 from JakubOnderka/response-simplify. [Jakub
  Onderka]

  chg: [internal] Simplify generating some JSON responses
- Merge pull request #7526 from MISP/2.4. [Jakub Onderka]

  Merge 2.4 into develop
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Security: fix stored xss in sharing groups view as reported by Nicolas
  Vidal from TEHTRIS. [Luciano Righetti]


v2.4.145 (2021-06-28)
---------------------

New
~~~
- [API] Import warninglist. [Jakub Onderka]
- [internal] Support Cake installation by composer. [Jakub Onderka]
- [ZMQ] Send warninglist changes to ZMQ. [Jakub Onderka]
- [API] Export warninglists to CSV. [Jakub Onderka]
- [API] Export warninglists. [Jakub Onderka]
- Custom warninglist. [Jakub Onderka]
- [emailing] added event summaries only as a setting. [iglocska]

  - publish the normal alert report to eligible users
  - exclude attributes/objects, so the e-mail will only include a summary

Changes
~~~~~~~
- [version] bump. [iglocska]
- [doc:authentication_diagrams] Included session and cookie handling.
  [mokaddem]
- [servers:add] Fallback to correct json structure if synchronisation
  rules are empty. [mokaddem]
- [server] Relaxed url validation rule. [mokaddem]
- [user] Relaxed email validation rule. [mokaddem]
- [warning-list] updated to the latest version. [Alexandre Dulaunoy]
- [composer] Crypt_GPG updated to 1.6.5. [Alexandre Dulaunoy]
- [internal] Remove unused 'full' arg when fetching taxonomies. [Jakub
  Onderka]
- [API] Add description to predicates and values. [Jakub Onderka]
- Log remote IP for authkey use attempt if remote IP not allowed by key.
  [Jeroen Pinoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [installer] Added Rocky Linux 8.4 tweaks. [Steve Clement]
- [doc] Added Rocky Linux 8.4. [Steve Clement]
- [doc] Updated to OpenBSD 6.9. [Steve Clement]
- [misp-warninglists] updated to the latest version. [Alexandre
  Dulaunoy]
- [taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [warning-lists] updated. [Alexandre Dulaunoy]
- [composer] Crypt_GPG updated to 1.6.5. [Alexandre Dulaunoy]

Fix
~~~
- [rest client] Handle state when body is too big to save into rest
  client history. [Jakub Onderka]
- [server caching] only push data to redis / logs if there's something
  to push. [iglocska]

  - avoids the count() notice if no data was returned by the remote
- Add mising return formats for rest search endpoints. [Luciano
  Righetti]
- Add missing returnFormat to restSearch endpoints, move the parameter
  as requestBody property. [Luciano Righetti]
- [getSettings] include the options. [iglocska]
- [API] Taxonomy namespace is case insensitive. [Jakub Onderka]
- Copy/pasta, rename galaxy clusters tag, move restSearch endpoints to
  resource 1st. [Luciano Righetti]
- [server:edit] Typo in index. [Sami Mokaddem]
- [user edit] lost the set password checkbox. [iglocska]
- [server caching] only push data to redis / logs if there's something
  to push. [iglocska]

  - avoids the count() notice if no data was returned by the remote
- Add mising return formats for rest search endpoints. [Luciano
  Righetti]
- [user add/edit] added missing JS change to restore the external auth
  field. [iglocska]
- [external auth key / password] fields changed, fixes #7488. [iglocska]

  - show what's relevant based on the customauth settings and hide that which is not
- [emailing] added missing if branch for the publish alert summary mode
  to trigger. [iglocska]
- [validation] account for the edge-case where a composite attribute
  does not yet have a second value. [iglocska]
- [attribute validation] - also check for composite values containing
  control characters, fixes #7391. [iglocska]
- [validation] fixed issue introduced in last commit. [iglocska]
- [attribute] validation tightened for empty strings. [iglocska]

  - a value containing only control characters will now be blocked from entry
- [CRUD] accept contain as a parameter for edit, fixes an issue with
  auth key edits. [iglocska]
- Typo. [Bart]

  😅

Other
~~~~~
- Merge branch 'develop' into 2.4. [iglocska]
- Merge remote-tracking branch 'origin/2.4' into develop. [mokaddem]
- Merge remote-tracking branch 'origin/2.4' into develop. [mokaddem]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge pull request #7495 from JakubOnderka/warninglist-import. [Jakub
  Onderka]

  Warninglist import
- Merge pull request #7494 from JakubOnderka/cake-composer-support.
  [Jakub Onderka]

  new: [internal] Support Cake installation by composer
- Merge branch '2.4' into develop. [iglocska]
- Merge pull request #7504 from mokaddem/fix-server-url-validation.
  [Andras Iklody]

  Fix server url validation
- Merge branch 'develop' of github.com:MISP/MISP into fix-server-url-
  validation. [mokaddem]
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge pull request #7502 from mokaddem/fix-user-email-validation.
  [Andras Iklody]

  chg: [user] Relaxed email validation rule
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [Alexandre Dulaunoy]
- Merge branch '2.4' into develop. [iglocska]
- Merge pull request #7464 from JakubOnderka/warninglist. [Jakub
  Onderka]

  Custom warninglists
- Merge pull request #7444 from JakubOnderka/taxonomy-add-description.
  [Jakub Onderka]

  chg: [API] Add description to predicates and values
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge pull request #7479 from Wachizungu/log-IP-if-not-allowed-for-
  authkey. [Andras Iklody]

  chg: log remote IP for authkey use attempt if remote IP not allowed b…
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge pull request #7524 from SteveClement/tools. [Steve Clement]
- Merge pull request #7523 from SteveClement/guides. [Steve Clement]
- Merge branch 'guides' of github.com:SteveClement/MISP into guides.
  [Steve Clement]
- Security: [generic-template:index] Fixed unsanitized input. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #7506 from adliwahid/patch-1. [Alexandre Dulaunoy]

  Added 3 feeds sources from APNIC
- Added 3 feeds sources from APNIC. [Adli Wahid]

  Added 3 daily feeds (ssh bruteforce, telnet bruteforce, URLs seen)  from the APNIC Community Honeynet Project
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Luciano
  Righetti]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Luciano
  Righetti]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Luciano
  Righetti]
- Merge branch 'develop' of github.com:MISP/MISP into 2.4. [Luciano
  Righetti]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Update README.md. [Alexandre Dulaunoy]
- Merge pull request #7483 from bartblaze/2.4. [Alexandre Dulaunoy]

  fix: typo
- Merge pull request #1 from bartblaze/bartblaze-patch-1. [Bart]

  fix: typo


v2.4.144 (2021-06-07)
---------------------

New
~~~
- Add initial version of openapi spec, add ReDoc js files. [Luciano
  Righetti]
- [doc:sync] Added notes and diagrams about synchornisation logics.
  [mokaddem]
- [galaxy] Support of enabled/disabled state at galaxy level. [mokaddem]

  Fix #7019
- [CyCat integration] v1. [iglocska]

  - lookup on relationshis for a given galaxy cluster
- [UI] Add link to event report history. [Jakub Onderka]
- [doc:auth-diagram] Added authentication diagram. [mokaddem]

Changes
~~~~~~~
- [version] bump. [iglocska]
- [PyMISP] Bump. [Raphaël Vinot]
- [logo] reverted to the non-birthday version. [iglocska]
- [PyMISP] Bump deps. [Raphaël Vinot]
- [galaxyCluster:CyCat relations] Added icon and reference of the
  project. [mokaddem]
- [genericElements:accordion] Added possiblity to pass html title.
  [mokaddem]
- [cluster:cycat_relations] Added missing view. [mokaddem]
- [galaxyCluster:view] oved CyCat relationships in their own child
  elements - Significantly speed up view loading time. [mokaddem]
- [sharinggroup] Allow pushing SG if remote internal server is not in
  the list of SG servers. [mokaddem]
- [dashboard:updateSetting] Work with form data in memory rather than in
  HTML body. [mokaddem]
- [db_schema] Updated schema. [mokaddem]
- [acl] Updated ACL to support new endpoints. [mokaddem]
- [doc:synchronisation-digrams] Added original diag. file. [mokaddem]
- [doc:synchronisation-diagrams] Added full version for both sync and
  clarification about conditions. [mokaddem]
- [doc:synchronisation-diagrams] Added precision regarding index
  filtering. [Sami Mokaddem]
- [doc:synchronisation] Renamed files. [mokaddem]
- [UI] Show warning when advanced auth keys are not enabled. [Jakub
  Onderka]
- [UI] Make permision titles translatable. [Jakub Onderka]
- [Pip] lock updated. [Alexandre Dulaunoy]
- [PyMISP] updated. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- [misp-objects] updated to latest version. [Alexandre Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- [misp-objects] updated fix #7445. [Alexandre Dulaunoy]
- [config] default config now uses RFC2606 example.com domain.
  [Alexandre Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]

Fix
~~~
- [PyMISP] Bump pipenv. [Raphaël Vinot]
- /feeds/add endpoint returns empty 'name' error via api call. [Luciano
  Righetti]
- Pr comments, update acl to allow all for /servers/openapi view, remove
  rest client from events menu, remove php7 return hint. [Luciano
  Righetti]
- [appController] Bumped queryversion. [mokaddem]
- [events:view] Correctly support arrays passed as deleted parameter.
  [mokaddem]
- [events:view] Restored previous deleted behavior. [mokaddem]
- [events:view] Replaced correlation scope to behave similarly to the
  filtering tool. [mokaddem]
- [events:view] Fixed deleted toggle enabled by default. [mokaddem]
- [galaxyCluster:view] Use CyCat local icon. [mokaddem]
- [galaxyCluster:view] Make sure the cluster contain cycat relations
  before inserting content. [mokaddem]
- [galaxyCluster:view] Typo in setting name. [mokaddem]
- [event:__prepareForPushToServer] Slight refactoring. [mokaddem]
- [event:prepareForPush] Gracefully handle the case if
  SharingGroupServer is empty. [mokaddem]
- [sharinggroup:capture] Re-use the ID of an existing SG if it exists
  instead of the defaulted value 0. [mokaddem]
- [sharinggroup:captureOrg/captureServer] Use the ID of the existing
  sharing group. [mokaddem]
- [dashboard:update_settings] Added missing view. [mokaddem]
- [dashbpard:updateSetting] Usage of CSRF token. [mokaddem]
- [security] Always capture attribute sharing groups. [iglocska]

  - via object edits it was omitted, leading to a possible misassociation of sharing groups by using the local ID of a referenced SG

  - as reported by Jeroen Pinoy
- [Event:set_filter_value] Support of wildcard searches. [mokaddem]
- Nonaggregated column mysql error when calling
  /sightings/index/[event_id] [Luciano Righetti]
- Decode json ref and geographical_area properties in
  /noticelists/view/[noticelist_id] endpoint. [Luciano Righetti]
- [Event:set_filter_value] Reset array indexing. [mokaddem]
- [Event:set_filter_value] Allows searching for composite attributes.
  [mokaddem]

  Fix #7119
- [typo in attribute add] caused the view to fail when adding
  attributes. [iglocska]
- [doc:auth-diagram] Filename typo. [mokaddem]
- [UI] Security audit message. [Jakub Onderka]
- [UI] Simplify warninglist view template. [Jakub Onderka]
- Return api error when feed is not enabled. [Luciano Righetti]
- [UI] Show error only if it is not empty. [Jakub Onderka]
- [UI] Add missing event report model in audit log. [Jakub Onderka]
- [events:index] Reindex tag array to always return a list. [mokaddem]
- [markdown-editor:event-report] Fixed MISPElements in table. [mokaddem]
- [organisations:add] Wrong label value. [mokaddem]
- [db] rename org_blacklists to org_blocklists everywhere. [Richard van
  den Berg]
- [post:send_mails] Make sure to have full group_by. [mokaddem]
- [attribute add] fixed typo causing the add function to fail.
  [iglocska]
- [organisations index] added quickfilter as an alias for the search.
  [iglocska]
- [Sharing groups] show roaming state in the API view. [iglocska]
- [UI] Restore notice list warnings when adding or editing attribute.
  [Anders Einar Hilden]

  Restore the notice_message div that vanished in commit 0d4df7c98b0fc67618b1c3c298e64efb668fc4fe.
- [security] disable email uniqueness validation for the self
  registration. [iglocska]
- [OTP] identifier tag fixed. [iglocska]

  - was hard coded to [MISP]
- [events:index] Reindex tag array to always return a list. [mokaddem]
- [organisations:add] Wrong label value. [mokaddem]
- [group by] error fixed in diagnostics,  fixes #7411. [iglocska]

Other
~~~~~
- Merge branch 'develop' into 2.4. [iglocska]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge branch 'fix-dahsboard-updateSettings' into develop. [mokaddem]
- Merge branch 'develop' of github.com:MISP/MISP into fix-dahsboard-
  updateSettings. [mokaddem]
- Merge pull request #7427 from righel/fix-add-feed-api-endpoint.
  [Alexandre Dulaunoy]

  fix: /feeds/add endpoint returns empty 'name' error via api call
- Merge pull request #7468 from righel/add-openapi-spec. [Andras Iklody]

  Add openapi spec
- Add /users/initiatePasswordReset/[user_id]/[first_time] openapi spec.
  [Luciano Righetti]
- Fix openapi errors, fix default organisation restricted_to_domain
  value. [Luciano Righetti]
- Merge branch 'fix-event-view-attribute-toolbar' into develop.
  [mokaddem]
- Merge branch 'develop' of github.com:MISP/MISP into fix-event-view-
  attribute-toolbar. [mokaddem]
- Merge branch 'fix-sg-api-edit' into develop. [mokaddem]
- Merge remote-tracking branch 'origin/develop' into fix-sg-api-edit.
  [mokaddem]
- Merge pull request #7470 from mokaddem/improvements-cycat. [Andras
  Iklody]

  Improvements for cycat integration
- Merge remote-tracking branch 'origin/2.4' into develop. [mokaddem]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge branch 'fix-composite-attribute-filtering' into develop.
  [mokaddem]
- Merge remote-tracking branch 'origin/develop' into fix-composite-
  attribute-filtering. [mokaddem]
- Merge branch 'feature-galaxy-disabled' into develop. [mokaddem]
- Merge remote-tracking branch 'origin/develop' into feature-galaxy-
  disabled. [mokaddem]
- Merge pull request #7456 from righel/fix-mysql-error-index-sightings-
  by-event-id. [Andras Iklody]

  Fix mysql error index sightings by event
- Merge pull request #7455 from righel/fix-non-deserialized-properties-
  view-noticelist. [Andras Iklody]

  fix: decode json ref and geographical_area properties in /noticelists…
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [mokaddem]
- Merge branch 'doc-sync' into develop. [mokaddem]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [mokaddem]
- Merge branch '2.4' into develop. [iglocska]
- Merge pull request #7443 from JakubOnderka/fix-securiy-audit. [Jakub
  Onderka]

  Fix securiy audit
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [Alexandre Dulaunoy]
- Merge pull request #7435 from JakubOnderka/event-report-history.
  [Jakub Onderka]

  Event report history
- Merge pull request #7440 from righel/return-api-error-when-fetch-from-
  feed-fails. [Alexandre Dulaunoy]

  fix: return api error when fetch from feed fails
- Merge branch 'return-api-error-when-fetch-from-feed-fails' of
  github.com:righel/MISP into return-api-error-when-fetch-from-feed-
  fails. [Luciano Righetti]
- Return api error when feed is not enabled. [Luciano Righetti]
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge pull request #7432 from JakubOnderka/perm_flags_translatable.
  [Jakub Onderka]

  Perm flags translatable
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch 'airbus-cert-synchronisation_servers_cache_features' into
  develop. [Alexandre Dulaunoy]
- Add cacheServerAll documentation. [Amaury Leroy]
- Add 'Cache server' documentation. [Amaury Leroy]
- Add PushAll documentation. [Amaury Leroy]
- Function pushAll -- push all servers. [Amaury Leroy]
- Function cacheServerAll -- cache all server. [Amaury Leroy]
- Revert "Merge pull request #7476 from RichieB2B/ncsc-nl/org_blocklist"
  [Alexandre Dulaunoy]

  This reverts commit ea73d2613f457bb0459da874f3f84ffd3444c203, reversing
  changes made to 6d8c2eebcf35f4bf68fcd88677331b0d65bbd14a.
- Merge pull request #7476 from RichieB2B/ncsc-nl/org_blocklist.
  [Alexandre Dulaunoy]

  fix: [db] rename org_blacklists to org_blocklists everywhere
- Merge pull request #7459 from Kagee/patch-1. [Andras Iklody]

  fix: [UI] Restore notice list warnings when adding or editing attribute
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]


v2.4.143 (2021-05-14)
---------------------

New
~~~
- [internal] View event as different user. [Jakub Onderka]
- [event index] add report count. [iglocska]
- [users:index] Batch toggleable fields. [mokaddem]
- [elements:genericForm] Added support of field descriptions. [mokaddem]
- [elements:indexCountry] Added country element to display flags and
  nationalities. [mokaddem]
- [log] Add supoort for AuthKeys. [Jakub Onderka]
- [log] Show full change in popup. [Jakub Onderka]
- [log] Audit Log statistics. [Jakub Onderka]
- [log] LogShell. [Jakub Onderka]
- [log] Audit log. [Jakub Onderka]
- [event:alert] Re-publishing ban feature based on configurable
  threshold. [mokaddem]
- [event:alert] Re-publishing ban feature based on configurable
  threshold. [mokaddem]
- [Correlation exclusions] clean function reworked. [iglocska]

  - does everything on DB side
  - no more issues with large lists being passed around
  - should also be a fair bit faster

Changes
~~~~~~~
- [version] bumped. [iglocska]
- [birthday] logo added. [iglocska]

  - to be removed on the next release
- [routes] fix allowedlists routes. Renamed from whitelists. [Jeroen
  Pinoy]
- [PyMISP] Bump version. [Raphaël Vinot]
- [misp-objects] updated. [Alexandre Dulaunoy]
- [misp-taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [setting] Add missing setting fo new audit log. [Jakub Onderka]
- [correlation] Cleanup Correlation model code. [Jakub Onderka]
- [object] Added validation rules for some fields. [mokaddem]
- [organisations:edit] Usage of the add view. [mokaddem]
- [organisations:add] Migrated view to factory. [mokaddem]
- [organisations:index] Migrated view to factory. [mokaddem]
- [elements:indexGenericField] Allow passing implode's glue. [mokaddem]
- [warninglists:index] Moved views to factory - WiP. [mokaddem]
- [UsageData] fix active proposal count, exclude deleted entries.
  [Jeroen Pinoy]
- Bumped queryversion. [mokaddem]
- [event-report] Improved hints autocomplete while typing. [mokaddem]

  - Hints available scopes
  - Allow searching for object's priority value
- [log] Add link to Role. [Jakub Onderka]
- [log] Add link to ObjectTemplate from audit log. [Jakub Onderka]
- [log] Correctly show request type in user interface. [Jakub Onderka]
- [internal] Return ugly print JSON for AJAX requests. [Jakub Onderka]
- [warninglists:checkValue] Exposed feature in the UI. [mokaddem]
- [server:setting] Added missing config `warning_for_all` [mokaddem]
- [allowedlist] Migrated views to factory. [mokaddem]
- [users:index] Migrated view to factory. [mokaddem]
- Bumped queryversion. [mokaddem]
- [event-report] Improved hints autocomplete while typing. [mokaddem]

  - Hints available scopes
  - Allow searching for object's priority value
- [warninglists:checkValue] Exposed feature in the UI. [mokaddem]
- [server:setting] Added missing config `warning_for_all` [mokaddem]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [event:alert] Added option to refresh to ban. [mokaddem]
- [event:getEventRepublishBanStatus] Improved wording. [mokaddem]
- [UI] Link to proposal limited view from proposal event index. [Jakub
  Onderka]
- [event:alert] Added option to refresh to ban. [mokaddem]
- [event:getEventRepublishBanStatus] Improved wording. [mokaddem]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [objects] updated to the latest version. [Alexandre Dulaunoy]
- [elements:serverRuleElements] Removed useless spaces. [mokaddem]
- [server:queryAvailableSyncFilteringRules] Returns error message
  instead of throwing error. [mokaddem]
- [servers:edit] Added indicative text for serverRuleElements.
  [mokaddem]
- [elements:serverRuleServers] Added text for each scopes. [mokaddem]
- [elements:serverRuleElements] Reset widgets state on modal close.
  [mokaddem]
- [elements:rules_widget] Added collapsible for freetext inputs.
  [mokaddem]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [ACL] added correlation exception edit. [iglocska]
- [elements:indexPostlink] Added possibility to add confirm messages.
  [mokaddem]

  Fixed JS error throwing undefined variable in top correlations

Fix
~~~
- [jobs view] Typo with $baseurl variable name. [chrisr3d]
- [module results] References between objects returned with module
  results and the original object attribute are now pointing to the
  original object itself. [chrisr3d]

  - A reference between an object and an object
    attribute is supported in the API, but does not
    appear on the event graph
  - Instead of pointing to the initial object
    attribute then, we look for the uuid of the
    object containing the attribute and use this
    uuid for the reference
  - The references between objects returned as
    module results and the object containing the
    attribute initially used for the enrichment
    with a module are then handled properly
- [taxonomies] updated. [Alexandre Dulaunoy]
- [attribute:first_seen/last_seen] First seen value can be equal to the
  last_seen value. Fix #7404. [mokaddem]
- [module results] Included the object references handling loop in the
  objects handling loop. [chrisr3d]

  - If we did not get any object in a result from
    a misp module, the `$references` variable would
    not have been defined and would have raised an
    issue. The references are related to objects,
    it is then obvious to handle them both together
- [modules results] Fixed the query to find the uuid of the attribute
  used as input of a misp-module. [chrisr3d]

  - With `Attribute.object_id => 0`, the query did
    only return attributes outside of a MISP object
  - This was causing issues with references between
    the MISP objects returned by the modules and the
    attribute used as input to the module. Those
    references were visible in the module results
    preview, but skipped then after the submit
    button is pressed.
  - The references are now correctly handled
- [attributes] Enforce FS to be before LS (also for ShadowAttributes &
  Objects) [mokaddem]
- Servers cannot be edited via API when MISP.host_org_id setting is
  empty. [Luciano Righetti]
- [attribute:first_seen/last_seen] First seen value can be equal to the
  last_seen value. Fix #7404. [mokaddem]
- [correlations] Correctly handle exclusion. [Jakub Onderka]
- [internal] Attribute correlation toggle. [Jakub Onderka]
- [attributes] Enforce FS to be before LS (also for ShadowAttributes &
  Objects) [mokaddem]
- [internal] Missing variable. [Jakub Onderka]
- [UI] Chosen autofocus for attribute mass edit. [Jakub Onderka]
- [feed] Better error handling when downloading MISP feeds. [Jakub
  Onderka]
- [export] YARA export. [Jakub Onderka]
- [warninglists:index] Restored site admin permission requirement for
  deletion. [mokaddem]
- [log] Do not log unnecessary data to AuditLog. [Jakub Onderka]
- [feed preview] fixed exception thrown to invalid threat level listing
  call. [iglocska]
- [UI] Warning message for event modification warning. [Jakub Onderka]
- [server:settings] Typo. [mokaddem]
- [db_schema] Update to version 68. [Jakub Onderka]
- [files:defaut_feeds] Added trailing slash Fix #7022. [mokaddem]
- [worker] restart not working correctly with SELinux. [iglocska]

  - endless process spawn due to not being able to fetch the user's name
- [server:settings] Typo. [mokaddem]
- [db_schema] Update to version 68. [Jakub Onderka]
- [stix2 export] Making sure timestamps are always converted into the
  format STIX likes. [chrisr3d]
- [stix2 export] Making sure attributes have their Galaxy field before
  trying to parse it. [chrisr3d]
- [stix2 export] Copy paste issue. [chrisr3d]
- [stix2 export] Trying to make first_seen & last_seen fields are
  exported in an iso-formatted datetime format. [chrisr3d]
- [stix2 export] Avoiding issues with MISP events 'Event' field.
  [chrisr3d]
- [stix2 import] Added the missing ip address observable parsing
  function. [chrisr3d]

  - Should fix #6855
- [stix2 import] Avoid missing the to_ids flag when set to False.
  [chrisr3d]

  - attribute.get('to_ids') with 'to_ids' set to
    False will simply skip the field, and let then
    MISP set the flag to the default 'to_ids' value
    depending on the attribute type
  - With the test being `attribute.get('to_ids') is not None`
    we make sure even if 'to_ids' is False, we get
    the field as it is
- [stix1 import] Avoiding AttributeError exceptions when the STIX
  packages have no header. [chrisr3d]
- [worker] restart not working correctly with SELinux. [iglocska]

  - endless process spawn due to not being able to fetch the user's name
- [emailing] password resets and OTP didn't handle line breaks
  correctly. [iglocska]
- [elements:serverRuleElementPush] Recover freetext tags not known by
  the instance. [mokaddem]
- [decayings:add] Correct usage of the translation function. [mokaddem]
- [UI] Correctly display last login time. [Loïc Fortemps]

  Until now, we were showing the "one before last" login time, this fixes the issue
- [galaxyCluster:export] Only unset fields if they exists. [mokaddem]

  In some cases, galaxy clusters might not have targeting clusters
- [galaxyCluster:export] Only unset fields if they exists. [mokaddem]

  In some cases, galaxy clusters might not have targeting clusters

Other
~~~~~
- Merge branch 'develop' into 2.4. [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge pull request #7377 from 86x/pi-support. [Andras Iklody]

  fix: Support various Raspberry Pi OS's in SUPPORT_MAP
- Added support for raspberry pi. [User]
- Merge pull request #7334 from Wachizungu/fix-allowedlists-route.
  [Andras Iklody]

  chg: [routes] fix allowedlists routes. Renamed from whitelists.
- Merge pull request #7403 from righel/fix-restricted_to_domain-reset-
  on-org-edit-allow-json-arrays. [Andras Iklody]

  fix restricted_to_domain reset when updating org, allow arrays via api.
- Fix restricted_to_domain reset when updating org, allow arrays via
  api. [Luciano Righetti]
- Merge branch '2.4' of https://github.com/MISP/MISP into develop.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge pull request #7405 from righel/fix-edit-servers-via-api-when-
  host_org_id-is-empty. [Andras Iklody]

  fix: servers cannot be edited via API when MISP.host_org_id setting i…
- Merge pull request #7397 from JakubOnderka/log-new-setting. [Jakub
  Onderka]

  chg: [setting] Add missing setting fo new audit log
- Merge pull request #7400 from JakubOnderka/after-save-correlation-fix.
  [Jakub Onderka]

  After save correlation fix
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge pull request #7189 from JakubOnderka/view-as. [Jakub Onderka]

  new: [internal] View event as different user
- Merge pull request #7390 from JakubOnderka/fix-chosen-autofix. [Jakub
  Onderka]

  fix: [UI] Chosen autofocus for attribute mass edit
- Merge pull request #7395 from JakubOnderka/feed-download-error-
  handlig. [Jakub Onderka]

  fix: [feed] Better error handling when downloading MISP feeds
- Merge pull request #7018 from JakubOnderka/yara-export-fix. [Jakub
  Onderka]

  fix: [export] YARA export
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge branch 'migration-allowlists' into develop. [mokaddem]
- Merge branch 'develop' of github.com:MISP/MISP into migration-
  allowlists. [mokaddem]
- Merge branch 'migration-users-views' into develop. [mokaddem]
- Merge branch 'develop' of github.com:MISP/MISP into migration-users-
  views. [mokaddem]
- Merge branch 'develop' of github.com:MISP/MISP into migration-users-
  views. [mokaddem]
- Merge branch 'develop' of github.com:MISP/MISP into migration-
  allowlists. [mokaddem]
- Merge branch 'migration-organisations-views' into develop. [mokaddem]
- Merge branch 'develop' of github.com:MISP/MISP into migration-
  organisations-views. [mokaddem]
- Merge branch 'migration-warninglists' into develop. [mokaddem]
- Merge branch 'develop' of github.com:MISP/MISP into migration-
  warninglists. [mokaddem]
- Merge branch 'develop' of github.com:MISP/MISP into migration-
  allowlists. [mokaddem]
- Merge pull request #7392 from Wachizungu/fix-usage-data-active-
  proposals-count. [Andras Iklody]

  chg: [statistics:UsageData] fix active proposal count, exclude deleted entries
- Merge pull request #6914 from JakubOnderka/audit-log. [Jakub Onderka]

  New Audit log system
- Merge branch '2.4' into develop. [iglocska]
- Merge pull request #7389 from aaronkaplan/patch-1. [Andras Iklody]

  Update apache.24.misp.ssl
- Update apache.24.misp.ssl. [AaronK]

  StrongCiphers4All! \o/
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge pull request #7388 from JakubOnderka/fix-log-warning. [Jakub
  Onderka]

  Fix log warning
- Merge branch 'feature-event-republishing-ban' into develop. [mokaddem]
- Merge remote-tracking branch 'origin/2.4' into feature-event-
  republishing-ban. [mokaddem]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into develop.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into develop.
  [chrisr3d]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [mokaddem]
- Merge pull request #7384 from JakubOnderka/fix-db-schema. [Jakub
  Onderka]

  fix: [db_schema] Update to version 68
- Merge pull request #7367 from JakubOnderka/proposal-index-ui. [Jakub
  Onderka]

  chg: [UI] Link to proposal limited view from proposal event index
- Merge branch '2.4' of github.com:MISP/MISP into develop. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into develop. [chrisr3d]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [chrisr3d]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Update supportFunctions.md. [Raphaël Vinot]

  pull from oirigin main and not origin master in PyMISP
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch 'improvements-sync-filter-rules2' into develop.
  [mokaddem]
- Merge remote-tracking branch 'origin/2.4' into develop. [mokaddem]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge pull request #7374 from lfortemps/patch-3. [Alexandre Dulaunoy]

  fix: [UI] Correctly display last login time
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' into develop. [iglocska]


v2.4.142 (2021-04-27)
---------------------

New
~~~
- [correlation exclusions] now have an optional comment field.
  [iglocska]

  - explain why you exclude a value for easier maintenance
  - edit existing exclusions to add those comments after the fact
- [top correlations] Redirect to the attribute search when clicking a
  value. [iglocska]
- [Index builder] add simple postlink field. [iglocska]
- [Correlations] Added cached toplist. [iglocska]

  - stored via zset in redis
  - very fast, but needs to be generated
  - generation background processed
- [index top bar] added element to act as a text replacement field
  instead of a button. [iglocska]
- [correlations] added new background task for correlating individual
  values. [iglocska]
- [Correlations] refactor / rework. [iglocska]

  - moved to own controller and model
  - refactored several long incomprehensible functions

  - extracted reused tasks from functions and made them reusable
  - added a way to correlate individual values as opposed to attributes

  - Added top correlations index
- [UI] added stupid pagination links. [iglocska]

  - sometimes we want to paginate data not derrived from the usual backend but still have a first/last/next/previous link included
- [correlations] top correlations index view added. [iglocska]
- [Correlations] added dedicated controller/model/views. [iglocska]
- [servers:edit] Fetches available orgs and tags from remote server.
  [mokaddem]

  - Componentized views and made them responsive
  - Usage of picker for orgs and tags
  - For server pull rule, fetches available choices from remote server
- [galaxyCluster:wipe_default] New endpoint to wipe out all default
  clusters. [mokaddem]
- [Cache] search allows bulk lookups. [iglocska]

  - it is now possible to search for a list of values such as:

  {
      "value": ["1.1.1.1", "8.8.8.8", "8.8.4.4"]
  }

  - this will now return a dictionary with the key being the lookup value and the value being a list of hits and their metadata

  - passing a single value will revert to the old behaviour, returning a simple list with the hits and their metadata
- [doc] Add doc on how MISP uses git. [E. Cleopatra]
- [Dashboard] Adding user count evolution widget. [Jeroen Pinoy]
- [Dashboard] Add org count evolution widget. [Jeroen Pinoy]
- [doc] Add roadmap. [E. Cleopatra]
- [event:timeline] Fit visible window from provided start/end dates +
  help tooltip. [mokaddem]
- [servers:diagnostic] Tool to remove orphaned correlations. [mokaddem]
- [UI] Smarter events lock checking. [Jakub Onderka]
- [API] REST repose for jobs index. [Jakub Onderka]
- [docs] Added API_Doc. [mokaddem]
- [Console] New API shell to create API documentation from
  RestResponseComponent. [mokaddem]
- [Dashboard] Add usage data widget. [Jeroen Pinoy]
- [UI] User column selector. [Jakub Onderka]
- [UI] User can choose columns for event index. [Jakub Onderka]
- [chg] timestamp index field allows a new "x units ago" representation.
  [iglocska]

  - just pass "ago": 1 as a parameter to the field

Changes
~~~~~~~
- [elements:indexPostlink] Added possibility to add confirm messages.
  [mokaddem]

  Fixed JS error throwing undefined variable in top correlations
- [correlations] reverted the division by 2 for the correlation counts.
  [iglocska]

  - there are legitimate cases where we get one way correlations
    - we use the value field to aggregate the count, which leads to it being incorrect when using advanced correlations (the reverse correlation will use the value of the remote side)
- [CRUD] component - added redirect_controller parameter. [iglocska]

  - redirect to other controllers on demand, not just other actions
- [ACL] added top correlation generation to ACL. [iglocska]
- [version] bump. [iglocska]
- Force perms for logfiles before tests. [Raphaël Vinot]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- [PyMISP] Bump. [Raphaël Vinot]
- [CRUD] component, changed two filtering functions to be accessible
  externally. [iglocska]
- [indextable] added stupid pagination options. [iglocska]
- [menues] updated with new correlation functionality. [iglocska]
- [elements:indexTable] Allow passing URL parameters for link actions.
  [mokaddem]
- [css:event-report] Improved layout when using objects in markdown
  headers. [mokaddem]
- [internal] Do not load not necessary event info for attack export.
  [Jakub Onderka]
- [UI] Hide URL from feed and server cache hits. [Jakub Onderka]
- [elements:serverRuleElements] Added notice for older server not
  supporting filtering rule queries. [mokaddem]
- [elements:serverRuleElements] Better function name for
  maintainability. [mokaddem]
- [element:serverRuleElements] Rules are parsed and build on
  rules_widget container. [mokaddem]

  They can later be recovered by external commands without having to rely
  on fixed HTML ID properties
- [elements:serverRuleElements] Parametrized display of freetext input.
  [mokaddem]
- [servers:add] Removed unused view. [mokaddem]
- [server:queryAvailableSyncFilteringRules] Includes the HTTP return
  code in case of errors. [mokaddem]
- [elements:serverRuleElements] Added support of existing rules for
  feeds. [mokaddem]
- [elements:serverRuleElements] Inject existing rules into widget.
  [mokaddem]
- [elements:serverRuleElements] Support of previous rule states - WiP.
  [mokaddem]
- [elements:serverRuleElements] Added preventive sanitizations.
  [mokaddem]
- [warning-lists] updated. [Alexandre Dulaunoy]
- [elements:infoModal] Added sanitization. Just in case. [mokaddem]
- [servers:edit] Slight UI adjustements. [mokaddem]
- [servers:edit] Added support of codemirror and delete buttons.
  [mokaddem]
- [internal] fetchEventIds refactored. [iglocska]

  - the stupid ordered params were driving me nuts
- [warning-list] updated to the latest version. [Alexandre Dulaunoy]
- [PyMISP] Bump. [Raphaël Vinot]
- [doc] FIx links. [E. Cleopatra]
- [doc] Some minor changes. [E. Cleopatra]
- [doc] Fix grammatical errors. [E. Cleopatra]
- [doc] update and rename. [E. Cleopatra]
- [doc] Add content. [E. Cleopatra]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [PyMISP] Bump. [Raphaël Vinot]
- [MispObject] fix copy paste error in checkForDuplicateObjects. [Jeroen
  Pinoy]
- [MispObject] fix copy paste error in editObject. [Jeroen Pinoy]
- [Dashboard:MultiLineChart] make enabling 'total' line on initial
  render configurable. [Jeroen Pinoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [PyMISP] updated. [Alexandre Dulaunoy]
- [metadata] JSON fixed. [Alexandre Dulaunoy]
- [feed] JSON fixed. [Alexandre Dulaunoy]
- [feed] default feed JSON fixed. [Alexandre Dulaunoy]
- [doc] Minor changes. [E. Cleopatra]
- [installer] Update to latest. [Steve Clement]
- [installer] Update template for rhel7/8. [Steve Clement]
- [doc] Updates to RHEL7/8 doc. [Steve Clement]
- [installer] Update to latest. [Steve Clement]
- [installer] Updated template for RHEL install. [Steve Clement]
- [fix] Missing version number. [Steve Clement]
- [installer] Installer Update, RHEL support added. [Steve Clement]
- [installer] Minor clean-up. [Steve Clement]
- [doc] More specific tweak to v7 and v8. [Steve Clement]
- [doc] Makes v7/v8 more clear. [Steve Clement]
- [doc] More cohesive docs. [Steve Clement]
- [installer] Latest installer. [Steve Clement]
- [installer] Template update to support RHEL7/8 CentOS7/8. [Steve
  Clement]
- [installer] udpated template to install php7.4 on ubuntu18.04. [Steve
  Clement]
- [doc] Suggest installing php74 on Ubuntu 18.04. [Steve Clement]
- Bump PyMISP. [Raphaël Vinot]
- [installer] Update to latest installer. [Steve Clement]
- [installer] Added modulesCAKE fn. [Steve Clement]
- [installer] Update to latest. [Steve Clement]
- [sh] Small fix to make misp-refresh non-interactive. [Steve Clement]
- [doc] lief is in requirements.txt. [Steve Clement]
- [feeds:edit] Improved saving of edits Fix #7293. [mokaddem]
- [event:search] Allow filtering by org uuid. Fix #7288. [mokaddem]
- [internal] Move fetching related attributes to one place. [Jakub
  Onderka]
- [internal] Install DebugKit by Composer. [Jakub Onderka]
- [internal] Install random_compat by Composer. [Jakub Onderka]
- [internal] Install CakePHP by Composer. [Jakub Onderka]
- [UI] Correctly handle progress for jobs. [Jakub Onderka]
- [UI] Make possible to filter jobs by prio queue. [Jakub Onderka]
- Bump PyMISP. [Raphaël Vinot]
- Bump PyMISP. [Raphaël Vinot]
- [attributes/restSearch] add clarifying comments. [Jeroen Pinoy]
- [restResponseComponent] Get scoped available endpoints. [mokaddem]
- Bump PyMISP. [Raphaël Vinot]
- [doc] Updated cake config defaults. [Steve Clement]
- [doc] Further RHELL tweaks. [Steve Clement]
- [doc] Seperated RHEL 7/8 install fn. Fedora33 supported. [Steve
  Clement]
- [doc] some cleanups. [Steve Clement]
- [doc] Seperated cake commands into seperate files. [Steve Clement]
- [doc] fix merge. [Steve Clement]
- Bump pipfile lock. [Raphaël Vinot]
- [UI] Use choosen for tag select. [Jakub Onderka]
- [UI] dblclickElement. [Jakub Onderka]
- [internal] Optimise fetching correlation count for events. [Jakub
  Onderka]
- [doc] Automation adaption. [Steve Clement]
- [doc] Updated Changelog.md. [Steve Clement]
- [doc] Added details on MISPvars. [Steve Clement]

Fix
~~~
- [attribute search] Don't use form tampering protection for searches.
  [iglocska]
- [top correlations] Divide the count by 2. [iglocska]

  - Each correlation has 2 entries in the DB (A->B and B->A)
  - this doesn't mean that we should count each of those entries, but rather divide by 2 to get the actual correlation count
- [default feeds] duplicate name resolved, fixes #6978. [iglocska]

  - as reported by @chrisinmtown
- [galaxy] logging - use SYSTEM as the default org name for logging.
  [iglocska]
- [galaxy] new logging to catch meta field errors assumed that the user
  object was available. [iglocska]

  - [narrator] It wasn't.
- [galaxy] update fails gracefully and skips over malformed meta fields
  in a cluster. [iglocska]
- [feeds:edit] Recover event_id if it exists Fix #7293 (second part)
  [mokaddem]
- [correlations] added fix for invalid function call. [iglocska]

  - introduced by the refactor, looking up Attribute object variables such as noncorrelatingTypes
- [correlations] Don't barf when trying to add data with no
  correlations. [iglocska]
- [correlation exclusions] controller comment fixed. [iglocska]
- [Correlations] controller - added missing components. [iglocska]
- [Correlations] fixed advanced correlations for ssdeep and separated
  into own function. [iglocska]
- [stix1 framing] Fixed CIQ Identity namespace. [chrisr3d]
- Add strict commit test function. [Luciano Righetti]
- Allow setting org_id=0 via cake console, add --force option to force
  settings. [Luciano Righetti]
- [UI] Event lock warning. [Jakub Onderka]
- [UI] Wrong org id for galaxy matrix stats. [Jakub Onderka]
- [misp.js] Support display on fretext values and removed useless
  functions. [mokaddem]
- [servers:edit] Support servers/add with the server/edit view.
  [mokaddem]
- [feeds:edit] Display additional filtering rules. [mokaddem]
- [elements:serverRuleElement] Push should not be allowed to set
  freetext orgs. [mokaddem]
- [elements:serverRuleElements] Avoid saving the space character as
  additional rule. [mokaddem]
- [feeds:edit] Log correct action. Fix #7347. [mokaddem]
- [elements:serverRuleElementPull] Typo. [mokaddem]
- [elements:serverRuleElementsPull] Correctly setup codemirror.
  [mokaddem]
- [server:edit] Usage of IDs or raw values on correct context.
  [mokaddem]

  - PUSH should use IDs
  - PULL should use raw values
- [test] Allow access from IPv6 addresses. [Jakub Onderka]
- [GHA] change in hostname, bump pymisp, fix vhost. [Raphaël Vinot]
- [feed:edit] Fixed bug preventing to recover feed data in the UI.
  [mokaddem]
- [doc] moreutils package added (required for sponge) [Alexandre
  Dulaunoy]

  Fix #7353
- [decaying:row_simulation] Removed buggy HTML title. [mokaddem]
- [decaying:row_simulation] Correctly pass event data to galaxy element.
  [mokaddem]
- [audit] Better path to cake version file. [Jakub Onderka]
- [decaying:row_simulation] Correctly pass event data to galaxy element.
  [mokaddem]
- [decaying:row_simulation] Removed buggy HTML title. [mokaddem]
- Fix remove attribute tag showing text/html content-type. [Luciano
  Righetti]
- [CSRF] issues resolved for the dashboards controller. [iglocska]
- [security] Sharing group misassociation on sync. [iglocska]

  - when an object has a sharing group associated on an event edit, the sharing group object is ignored and instead the passed local ID is reused
  - as reported by Jeroen Pinoy
- [doc] Small regression. [Steve Clement]
- Remove call to private method, call __alterAttributeCount() from
  Attribute::restore() method. [Luciano Righetti]
- [installer] Updated template to fix v7/8. [Steve Clement]
- [installer] Fix merge fup of template. [Steve Clement]
- [webroot:index] Make sure MISP works if cakephp is not installed via
  composer. [mokaddem]
- [internal] Organisation object for user is not included all time.
  [Jakub Onderka]
- [UI] Hide job retries since this column is always zero. [Jakub
  Onderka]
- [UI] Failed jobs are not considered as Queued. [Jakub Onderka]
- [xml] Object can be without attributes. [Jakub Onderka]
- [factories] links and timestamps fixed. [iglocska]

  - really annoying timestamp issue
  - as discovered during LS21
- [tools] Fixed misp-backup. [Steve Clement]
- [emailing] subject restored. [iglocska]

  - view template not having the subject var set defaulted the subject to null
- [UI] Event index filter nicer. [Jakub Onderka]
- [UI] Event index filter edit. [Jakub Onderka]
- [internal] Remove unused code. [Jakub Onderka]
- [doc] CentOS 7 needs to use Remi too. [Steve Clement]
- [installer] Use awk to print until EoF from match. [Steve Clement]
- [installer] globalVariables fix to ignore preceeding lines. [Steve
  Clement]
- [tools] now works on MacOS and considers gsed. [Steve Clement]
- [internal] ThreatLevel::list() function renamed. [iglocska]

  - causes issues under certain PHP versions as it's a reserved keyword

Other
~~~~~
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch 'develop' into 2.4. [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch 'develop' into 2.4. [iglocska]
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge pull request #7369 from MISP/fix-link. [Alexandre Dulaunoy]

  Fix link
- Fix link. [E. Cleopatra]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [mokaddem]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge branch '2.4' of https://github.com/MISP/MISP into develop.
  [chrisr3d]
- Merge branch 'developt push' of github.com:MISP/MISP into develop.
  [mokaddem]
- Merge pull request #7366 from righel/allow-cake-cli-set-null-settings.
  [Andras Iklody]

  fix: allow setting org_id=0 via cake console, add --force option
- Merge branch 'feature-galaxy-cluster-wipe-default' into develop.
  [mokaddem]
- Merge branch 'develop' of github.com:MISP/MISP into feature-galaxy-
  cluster-wipe-default. [mokaddem]
- Merge pull request #7364 from JakubOnderka/galaxy-stats-fix. [Jakub
  Onderka]

  Galaxy stats fix
- Merge remote-tracking branch 'origin/2.4' into develop. [mokaddem]
- Security: [feeds] Hide headers for non-site admin users. [mokaddem]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [mokaddem]
- Merge pull request #7365 from JakubOnderka/feed-url-remove. [Jakub
  Onderka]

  chg: [UI] Hide URL from feed and server cache hits
- Merge branch 'develop' of github.com:MISP/MISP into feature-galaxy-
  cluster-wipe-default. [mokaddem]
- Merge branch 'improvements-sync-filter-rules' into develop. [mokaddem]
- Merge branch 'develop' of github.com:MISP/MISP into improvements-sync-
  filter-rules. [mokaddem]
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge remote-tracking branch 'origin/2.4' into develop. [mokaddem]
- Merge branch 'develop' of github.com:MISP/MISP into improvements-sync-
  filter-rules. [mokaddem]
- Merge branch 'develop' of github.com:MISP/MISP into improvements-sync-
  filter-rules. [mokaddem]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge pull request #7358 from JakubOnderka/fix-security-test. [Jakub
  Onderka]

  fix: [test] Allow access from IPv6 addresses
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [mokaddem]
- Merge pull request #7230 from jozuatec/patch-2. [Jakub Onderka]

  Update OidcAuthenticate.php
- Update OidcAuthenticate.php. [jozuatec]

  With our IDP the user roles do not get delivered through claims. With this edit (get roles through "requestUserInfo" when claims fails to do so), our IDP can deliver the roles through an "Extra Attributes" field.
  I am already using this code in our production, it works fine for us.
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge pull request #7235 from imidoriya/patch-1. [Andras Iklody]

  chg: [tag] Use detailed message in tag return
- Restored generic when successes > 1. [Deku]

  Generic can handle when more than 1 tag is added.
- Generic message overwrites detailed message. [Deku]

  A detailed message is created on lines 870 and 877, however, they're never used in the response as it is overwritten by the generic message on line 888.
- Merge pull request #7326 from PROTechThor/contribute. [Alexandre
  Dulaunoy]

  Improve contributing.md, Add coding style, workflow
- Update STYLE.md. [E. Cleopatra]
- Update GITWORKFLOW.md. [E. Cleopatra]
- Update CONTRIBUTING.md. [E. Cleopatra]
- Update CONTRIBUTING.md. [E. Cleopatra]
- Write coding style guidelines. [E. Cleopatra]
- Merge pull request #7342 from Wachizungu/fix-checkForDuplicateObjects-
  typo. [Andras Iklody]

  chg: [MispObject] fix copy paste error in checkForDuplicateObjects
- Merge pull request #7343 from Wachizungu/fix-typo-in-editObject.
  [Andras Iklody]

  chg: [MispObject] fix copy paste error in editObject
- Merge pull request #7345 from Wachizungu/user-count-evolution-widget.
  [Andras Iklody]

  new: [Dashboard] Add user count evolution widget
- Merge pull request #7350 from Wachizungu/org-count-evolution-widget.
  [Andras Iklody]

  new: [Dashboard] Add org count evolution widget
- Merge pull request #7352 from JakubOnderka/revert-composer. [Jakub
  Onderka]

  Revert composer
- Revert "chg: [internal] Install CakePHP by Composer" [Jakub Onderka]

  This reverts commit 74eccfe9
- Revert "chg: [internal] Install random_compat by Composer" [Jakub
  Onderka]

  This reverts commit fe7d0a46
- Merge pull request #7349 from Wachizungu/multilinechart-make-enabling-
  total-configurable. [Alexandre Dulaunoy]

  chg: [Dashboard:MultiLineChart] make enabling 'total' line on initial…
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge pull request #7336 from stevengoossensB/2.4. [Alexandre
  Dulaunoy]

  Change config.default.php to have everything needed for Azure AD auth
- Change config.default.php to have everything needed for Azure AD
  authentication in there (as suggested in PR 6661) [Steven]
- Merge pull request #7339 from righel/fix-remove-tag-attribute-content-
  type-header. [Andras Iklody]

  fix: fix remove attribute tag showing text/html content-type
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge pull request #7304 from StefanKelm/2.4. [Alexandre Dulaunoy]

  add MalwareBazaar and URLhaus
- Add MalwareBazaar and URLhaus. [StefanKelm]

  https://github.com/MISP/MISP/issues/7176
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge pull request #7320 from PROTechThor/roadmap. [Alexandre
  Dulaunoy]

  MISP Roadmap
- Merge branch '2.4' into develop. [iglocska]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [mokaddem]
- Merge branch '2.4' into develop. [iglocska]
- Merge pull request #7309 from SteveClement/guides. [Steve Clement]
- Merge pull request #7308 from SteveClement/tools. [Steve Clement]

  chg: [installer] Update template for rhel7/8
- Merge pull request #7307 from SteveClement/guides. [Steve Clement]

  chg: [doc] Updates to RHEL7/8 doc
- Merge pull request #7306 from SteveClement/tools. [Steve Clement]
- Merge pull request #7303 from righel/fix-error-when-restoring-
  attribute-from-api. [Andras Iklody]

  fix: remove call to private method, call __alterAttributeCount() from…
- Merge pull request #7302 from SteveClement/tools. [Steve Clement]

  chg: [installer] Minor clean-up
- Merge pull request #7301 from SteveClement/tools. [Steve Clement]
- Merge branch 'tools' of github.com:SteveClement/MISP into tools.
  [Steve Clement]
- Merge branch 'tools' of github.com:SteveClement/MISP into tools.
  [Steve Clement]
- Merge branch '2.4' into tools. [Steve Clement]
- Merge remote-tracking branch 'upstream/2.4' into tools. [Steve
  Clement]
- Merge pull request #7300 from SteveClement/guides. [Steve Clement]
- Merge pull request #7298 from SteveClement/tools. [Steve Clement]

  chg: [installer] Template update to support RHEL7/8 CentOS7/8
- Merge pull request #7297 from SteveClement/tools. [Steve Clement]

  chg: [installer] udpated template to install php7.4 on ubuntu18.04
- Merge pull request #7296 from SteveClement/guides. [Steve Clement]

  chg: [doc] Suggest installing php74 on Ubuntu 18.04
- Merge pull request #7291 from stevengoossensB/2.4. [Alexandre
  Dulaunoy]

  Added Threatfox to default feeds
- Fix typo. [Steven]
- Added Threatfox to default feeds. [Steven]
- Merge pull request #7289 from SteveClement/tools. [Steve Clement]

  chg: [installer] Added modulesCAKE fn
- Merge pull request #7287 from SteveClement/tools. [Steve Clement]
- Merge pull request #7187 from JakubOnderka/related-attributes. [Jakub
  Onderka]

  chg: [internal] Move fetching related attributes to one place
- Merge pull request #7227 from JakubOnderka/smarter-event-locks-check.
  [Jakub Onderka]

  new: [UI] Smarter events lock checking
- Merge pull request #7158 from JakubOnderka/sg-user-org-id. [Jakub
  Onderka]

  fix: [internal] Organisation object for user is not included all time
- Merge pull request #7294 from JakubOnderka/cakephp-composer. [Jakub
  Onderka]

  chg: [internal] Install CakePHP by Composer
- Merge pull request #7204 from JakubOnderka/fix-jobs. [Jakub Onderka]

  Fix jobs
- Merge pull request #7267 from JakubOnderka/fix-xml-empty-object.
  [Jakub Onderka]

  fix: [xml] Object can be without attributes
- Added Threatfox to default feeds. [Steven]
- Merge pull request #7266 from stephengroat/patch-1. [Jakub Onderka]

  fix recursive submodule checkout
- Fix recursive submodule checkout. [Stephen]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [mokaddem]
- Add: [module results] Catching MISP Objects first_seen & last_seen
  values. [chrisr3d]

  - Will probably also check at attribute level to
    have it too if needed
- Merge branch 'develop' of https://github.com/MISP/MISP into develop.
  [chrisr3d]
- Merge pull request #7273 from Wachizungu/add-comments-attributes-
  restsearch. [Sami Mokaddem]

  chg: [attributes/restSearch] add clarifying comments
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #7282 from SteveClement/tools. [Steve Clement]
- Merge branch '2.4' into tools. [Steve Clement]
- Merge branch '2.4' of github.com:SteveClement/MISP into 2.4. [Steve
  Clement]
- Merge branch '2.4' into tools. [Steve Clement]
- Merge pull request #7281 from SteveClement/guides. [Steve Clement]

  chg: [doc] Further RHELL tweaks
- Chf: [doc] More amendments to RHEL8. [Steve Clement]
- Add: [module results] Catching MISP Objects first_seen & last_seen
  values. [chrisr3d]

  - Will probably also check at attribute level to
    have it too if needed
- Merge pull request #7278 from SteveClement/guides. [Steve Clement]
- Merge pull request #7276 from SteveClement/guides. [Steve Clement]

  chg: [doc] some cleanups
- Merge pull request #7275 from SteveClement/guides. [Steve Clement]

  chg: [doc] Seperated cake commands into seperate files
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge pull request #7263 from Wachizungu/add-usagedata-dashboard-
  widget. [Andras Iklody]

  new: [Dashboard] Add usage data widget
- Merge pull request #7228 from JakubOnderka/event-index-custom-columns.
  [Jakub Onderka]

  Event index custom columns
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #7269 from SteveClement/guides. [Steve Clement]
- Merge pull request #7268 from SteveClement/guides. [Steve Clement]

  chg: [doc] Added details on MISPvars
- Merge pull request #7233 from EvaYiYang/patch-1. [Andras Iklody]

  fix: [internal] Keep AadAuth setting in config.php when modify setting value from UI
- Merge branch '2.4' into patch-1. [Andras Iklody]
- Add AadAuth module as saved settings. [Eva Yang]
- Merge branch '2.4' into develop. [iglocska]


v2.4.141 (2021-03-29)
---------------------

New
~~~
- [cli] enable all tags for a taxonomy. [Jeroen Pinoy]
- [eventgraph:viewPicture] Allow access to saved picture from the
  eventgraph history. [mokaddem]
- [UI] Reworked galaxy quick view. [Jakub Onderka]
- [UI] Show threat level icons on event index. [Jakub Onderka]
- [freetext] Faster freetext parsing with more tests. [Jakub Onderka]
- [event loader] has a new extensionList parameter. [iglocska]

  - boolean, if set includes a list of extension events, metadata only
- [test] Alert email generating. [Jakub Onderka]
- [email] New setting `MISP.event_alert_metadata_only` [Jakub Onderka]
- [email] Command for testing generated alert email. [Jakub Onderka]
- [email] Allow to set email subject from template. [Jakub Onderka]
- [mail] Add reference for event alert emails. [Jakub Onderka]
- [mail] Move contact alert email to templates. [Jakub Onderka]
- [mail] HTML alert emails. [Jakub Onderka]
- [mail] Backend support for sending HTML emails. [Jakub Onderka]
- [shortcuts] Show help when pressing ? key. [Jakub Onderka]
- [internal] Security setting force_https. [Jakub Onderka]
- [authkeys] Copy key info when resetting key. [Jakub Onderka]
- [authkeys] Allowed IPs. [Jakub Onderka]
- [UI] Render galaxy cluster description as markdown. [Jakub Onderka]

Changes
~~~~~~~
- [warning-lists] updated. [Alexandre Dulaunoy]
- [misp-galaxy] updated. [Alexandre Dulaunoy]
- [doc] when enabling remi 7.4 by default, paths change. [Steve Clement]
- [doc] CentOS8Stream is now supported. [Steve Clement]
- [doc] reshuffle documentation order and archive some older guides.
  [Steve Clement]
- [i18n] Updated base strings. [Steve Clement]
- [i8n] Added localization progress. [Steve Clement]
- [i18n] Fix mrg conflict. [Steve Clement]
- [i18n] Updated base strings. [Steve Clement]
- [i18n] Updated translations. [Steve Clement]
- [galaxy] Update. [Jakub Onderka]
- [UI] fix debugon for debug = 1. fix #7131. [Jeroen Pinoy]
- [PyMISP] updated to the latest version. [Alexandre Dulaunoy]
- [taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [doc] more fine tuning to RHEL8. [Steve Clement]
- [doc] Balanced RHEL 8 and 7 Docs. [Steve Clement]
- [doc] Move away from expect. [Steve Clement]
- [installer] Update to latest. [Steve Clement]
- [doc] Added additional hardening and logging defaults. [Steve Clement]
- [doc] Some minor changes and hardening. [Steve Clement]
- [doc] Minor adjustments to permissions setter. [Steve Clement]
- [doc] typo. [Steve Clement]
- [doc] Added symlink to php. [Steve Clement]
- [doc] Be friendly to automation. [Steve Clement]
- [taxonomies] updated. [Alexandre Dulaunoy]
- [PyMISP] updated to the latest version. [Alexandre Dulaunoy]
- [taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [auth] if no API key is provided for an API action - log it.
  [iglocska]
- [auth key] logging no longer collapsed if the new setting is enabled.
  [iglocska]

  Security.log_each_individual_auth_fail will log all API failures instead of collapsing repeated queries
- [statistics] fix typo in statistics_data view - monthly attributes
  styling check. [Jeroen Pinoy]
- [ShibbAuth] Add login entry on logging in for audit. [Jeroen Pinoy]
- [statistics] fix typo in statistics_data view - monthly attributes
  styling check. [Jeroen Pinoy]
- [ShibbAuth] Add login entry on logging in for audit. [Jeroen Pinoy]
- [feed] Check if value is clean IP without doing expensive operations.
  [Jakub Onderka]
- [test] Add test for #7214. [Jakub Onderka]
- [shibbauth] added two extra settings. [iglocska]

  - ApacheShibbauth.DefaultRole: defaults to false, if set, pick the supplied roleID for any user authenticating. Can be used together with BlockRoleModifications
  - ApacheShibbauth.BlockRoleModifications: defaults to false, boolean. If set to true, will block any updates to the existing users on authentication. This preserves any modifications made by a site admin in MISP.
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [UI] Show number of items in freetext feed. [Jakub Onderka]
- [UI] Make feed event preview nicer. [Jakub Onderka]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [internal] Threat levels list. [Jakub Onderka]
- [restClient:querybuilder] add events and attributes addTag and
  removeTag actions. [Jeroen Pinoy]
- [attributes] fix attribute addtag by name conditions for find not set.
  [Jeroen Pinoy]
- [attributes] fix copypasta error leading to internal server error on
  addtag with tag name. [Jeroen Pinoy]
- [attributes] fix copypasta error leading to internal server error on
  addtag with tag name. [Jeroen Pinoy]
- Bumped queryversion. [mokaddem]
- [optimisation] Faster Model::_findList method. [Jakub Onderka]
- [internal] Faster event locks with Redis. [Jakub Onderka]
- [correlation] Do not update info and date column, since they are not
  used anymore. [Jakub Onderka]
- [restClient:querybuilder] fix remove tag from object template. [Jeroen
  Pinoy]
- [restClient:querybuilder] add events and attributes addTag and
  removeTag actions. [Jeroen Pinoy]
- [attributes] fix attribute addtag by name conditions for find not set.
  [Jeroen Pinoy]
- [attributes] fix copypasta error leading to internal server error on
  addtag with tag name. [Jeroen Pinoy]
- [email] Move event alert email subject generting. [Jakub Onderka]
- [internal] Fetch attribute UUIDs for sightings in different query.
  [Jakub Onderka]
- [UI] It is 2021! Removed -moz and -webkit specific CSS properties.
  [Jakub Onderka]
- [UI] Make some parts of MISP nicer. [Jakub Onderka]
- [eventGraph] Improved object coloring strategy. [mokaddem]
- [security audit] removed sharing group recommendation and fixed
  grammar. [iglocska]

  - the hide sharing group org setting is actively harmful, we should definitely not promote it
- [sync] Code cleanup. [Jakub Onderka]
- [sync] Do not decode body if is empty. [Jakub Onderka]
- [UI] Nicer pivots. [Jakub Onderka]
- [diagnostics] Show Redis memory fragmentation. [Jakub Onderka]
- [internal] When caching feed, save progress to db less often. [Jakub
  Onderka]
- [PyMISP] Bump version. [Raphaël Vinot]
- [PyMISP] Fix tests. [Raphaël Vinot]
- [PyMISP] Bump before release. [Raphaël Vinot]
- [internal] Set cookie name just when no name is set. [Jakub Onderka]
- [schema] Add index for EventReport.event_id. [Jakub Onderka]
- [schema] Convert GalaxyCluster tag name to case insensitive. [Jakub
  Onderka]
- [UI] Do not show published for default galaxy clusters. [Jakub
  Onderka]
- [internal] Cleanup code that is resposible for fetching server
  setting. [Jakub Onderka]
- [UI] Simplify keyboard-shortcuts.js. [Jakub Onderka]
- [UI] Use Page Visibility API. [Jakub Onderka]
- [optimise] Faster loading galaxy cluster index. [Jakub Onderka]

Fix
~~~
- [attribute:restSearch] `includeCorrelations` Do not longer returns
  soft-deleted attributes. [mokaddem]
- [sharinggroup:captureSG] Correctly capture the roaming state.
  [mokaddem]

  Fix #7254
- [attribute] typo in place-port-of-original-embarkation fixed.
  [Alexandre Dulaunoy]
- [doc] Partial fix for misp-modules. [Steve Clement]
- [doc] Fixed a bash variable bug. [Steve Clement]
- [doc] MISP-core now working on RHEL 7.9. [Steve Clement]
- [doc] next stages of the RHEL7 install. [Steve Clement]
- [sync:local-tag] Local tags converted into global after sync for
  internal sync. [mokaddem]

  Fix #7253
- [attribute] typo in place-port-of-original-embarkation fixed.
  [Alexandre Dulaunoy]
- [attributes:restSearch] pop attribute timestamp filtering condition.
  [mokaddem]

  This avoid the condition to propagates to the event level.
  Fix #7096
- [command:admin] UpdateTaxonomies provides correct feedback Fix #7132.
  [mokaddem]
- [tags] More granularity for local and global add cluster buttons.
  [mokaddem]
- [tags] More granularity for local and global add tag buttons.
  [mokaddem]
- [attributes:addTag] Pass the event to check ACL. [mokaddem]
- [taxonomy] avoid MISP becoming unhappy when trying to enable tags for
  a non-existing taxonomy. [iglocska]
- [doc] rhel 7 install doc initial fixes. [Steve Clement]
- [selinux] allow log files rename. [Richard van den Berg]
- [db_schema] Cerebrates's comment default value. [mokaddem]

  Fix #7200, fix #7137
- [API] Fixes crash when a new indicator in existing event has a
  sighting. [Tom King]
- [Sync] Crash when attempting to sync with 'Pull Galaxy Clusters'
  enabled. [Tom King]
- [swp] /var/swap.img is not a safe place. [Steve Clement]
- [merge] Local tags should stay local vol. 2. [Jakub Onderka]
- [internal] Keep OidcAuth setting when modify setting value from UI.
  [Jakub Onderka]
- Remove broken refang. [Raphaël Vinot]
- [config.php] file permission after changes fixes #7229. [iglocska]

  - will revert to the permissions before the save
  - caused by the create -> rename cycle that backs up server settings on each change actually creating a new file instead of modifying it
- [sharing groups] uuid not logged when saving failed due to invalid
  variable lookup. [iglocska]
- [UI] signature allowedlist clarification. [iglocska]
- Fixes bug that stops country flag being displayed alongside the coutry
  in galaxy clusters. [Tom King]
- [refanging] Removed obnoxious regexes, fixes #7214. [iglocska]

  - refanging \\. and .. to . is a stupid idea
- [shibbauth] fixed invalid varname. [iglocska]
- [test] Repo is missing. [Jakub Onderka]
- [feed] Convert invalid key case. [Jakub Onderka]
- [test] Repo is missing. [Jakub Onderka]
- [internal] Remove unnecessary create call. [Jakub Onderka]
- [workers] Worker name when processing freetext. [Jakub Onderka]
- [merge] Local tags should stay local. [Jakub Onderka]
- [unsafe API keys] fixed. [iglocska]

  - if you really have to use them, they should work again

  - please don't use them, you are disclosing your APIkey via the URL
  - apache logs, proxy logs they will all have your APIkey
  - adding headers with your APIkey isn't so difficult
  - if a tool you use has no way of configuring headers, reach out to your vendor, they ought to do something about that
- [UI] indextable link generation on empty result set. [iglocska]

  - empty string instead of notice barfed back
- [email] Correctly check if user has PGP or S/MIME key. [Jakub Onderka]
- [email] Correct Content-Type header for alternative content. [Jakub
  Onderka]
- [email] Correctly set domain for email message ID. [Jakub Onderka]
- [internal] PHP warnings when pivoting. [Jakub Onderka]
- [internal] Warning when object has no attributes. [Jakub Onderka]
- [SG] allow saving sharing groups with empty releasabiltiy tags, fixes
  #7165. [iglocska]
- [sync] Warning when sync object without attributes. [Jakub Onderka]
- [UI] event matrix heatmap view correctly flattens the event.
  [iglocska]

  - object attributes were excluded
- [UI] fix broken checkbox layout in generic Form builder forms.
  [iglocska]
- [Freetext import] handle end of sentence periods and brackets better,
  fixes #7163. [iglocska]
- [UI] Module diagnostics view. [Jakub Onderka]
- [UI] event matrix heatmap view correctly flattens the event.
  [iglocska]

  - object attributes were excluded
- [UI] Add attribute checkboxes. [Jakub Onderka]
- [UI] Diagnostics box. [Jakub Onderka]
- [UI] Remove warning about old PHP a Python. [Jakub Onderka]
- [diagnostics] Typo in security audit message. [Jakub Onderka]
- [UI] fix broken checkbox layout in generic Form builder forms.
  [iglocska]
- [OIDC] Change algo how roles are assigned to users. [Jakub Onderka]
- [internal] Undefined index when importing from module. [Jakub Onderka]

Other
~~~~~
- Chg; [version] bump. [iglocska]
- Merge branch 'develop' into 2.4. [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge pull request #7261 from SteveClement/guides. [Steve Clement]

  chg: [doc] when enabling remi 7.4 by default, paths change
- Merge pull request #7260 from SteveClement/guides. [Steve Clement]

  chg: [doc] CentOS8Stream is now supported
- Merge pull request #7259 from SteveClement/guides. [Steve Clement]
- Merge pull request #7257 from SteveClement/i18n. [Steve Clement]
- Merge remote-tracking branch 'upstream/2.4' into i18n. [Steve Clement]
- Merge pull request #7256 from SteveClement/i18n. [Steve Clement]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [mokaddem]
- Merge pull request #7264 from JakubOnderka/galaxy-update. [Jakub
  Onderka]

  chg: [galaxy] Update
- Merge pull request #7255 from Wachizungu/fix-debugon-gui-logic.
  [Alexandre Dulaunoy]

  chg: [UI] fix debugon for debug = 1. fix #7131
- Merge remote-tracking branch 'origin/2.4' into develop. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into develop. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge pull request #7251 from SteveClement/guides. [Steve Clement]

  fix: [doc] Partial fix for misp-modules
- Merge pull request #7250 from SteveClement/guides. [Steve Clement]

  chg: [doc] more fine tuning to RHEL8
- Merge pull request #7249 from SteveClement/guides. [Steve Clement]
- Merge pull request #7248 from SteveClement/guides. [Steve Clement]

  fix: [doc] Fixed a bash variable bug
- Merge pull request #7247 from SteveClement/guides. [Steve Clement]

  chg: [doc] Added additional hardening and logging defaults
- Merge pull request #7246 from SteveClement/guides. [Steve Clement]
- Merge pull request #7245 from SteveClement/guides. [Steve Clement]
- Merge pull request #7244 from SteveClement/guides. [Steve Clement]

  fix: [doc] MISP-core now working on RHEL 7.9
- Merge pull request #7243 from SteveClement/guides. [Steve Clement]

  fix: [doc] next stages of the RHEL7 install
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge pull request #7242 from Wachizungu/add-enable-taxonomy-tags-
  cake-command. [Andras Iklody]

  new: [cli] enable all tags for a taxonomy
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge remote-tracking branch 'origin/2.4' into develop. [mokaddem]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [mokaddem]
- Merge pull request #7236 from Wachizungu/fix-users-statistics-data-
  typo. [Alexandre Dulaunoy]

  chg: [statistics] fix typo in statistics_data view - monthly attribut…
- Merge pull request #7231 from Wachizungu/add-login-log-shibbauth.
  [Alexandre Dulaunoy]

  chg: [ShibbAuth] Add login entry on logging in for audit
- Merge branch '2.4' into develop. [iglocska]
- Merge pull request #7238 from SteveClement/guides. [Steve Clement]
- Merge pull request #7237 from RichieB2B/ncsc-nl/selinux-rename. [Steve
  Clement]
- Merge pull request #7206 from tomking2/bug/sighting_crash. [Andras
  Iklody]

  fix: [api] Fixes crash when a new indicator in existing event has a sighting
- Merge pull request #7219 from tomking2/bug/galaxy-cluster-
  sharinggroup. [Jakub Onderka]

  fix: [sync] Crash when attempting to sync with 'Pull Galaxy Clusters' enabled
- Merge pull request #7215 from SteveClement/tools. [Steve Clement]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge pull request #7081 from JakubOnderka/galaxy-view-new. [Jakub
  Onderka]

  New galaxy view for events
- Merge pull request #6722 from JakubOnderka/threat-level-index. [Jakub
  Onderka]

  new: [UI] Show threat level icons on event index
- Merge pull request #7183 from JakubOnderka/merge-local-tags-v2. [Jakub
  Onderka]

  fix: [merge] Local tags should stay local vol. 2
- Merge pull request #7181 from JakubOnderka/freetext-speedup. [Jakub
  Onderka]

  new: [freetext] Faster freetext parsing with more tests
- Merge pull request #7213 from JakubOnderka/oidc-keep-setting. [Jakub
  Onderka]

  fix: [internal] Keep OidcAuth setting when modify setting value from UI
- Merge pull request #7222 from JakubOnderka/refang-test. [Jakub
  Onderka]

  chg: [test] Add test for #7214
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #7205 from tomking2/bug/galaxy_country_flag. [Jakub
  Onderka]

  fix: [UI] Fixes bug that stops country flag being displayed alongside country
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge pull request #7188 from dataplane/2.4. [Alexandre Dulaunoy]

  added newest DataPlane.org feeds
- Added newest DataPlane.org feeds. [John Kristoff]
- Merge pull request #7207 from JakubOnderka/freetext-feed-view. [Jakub
  Onderka]

  chg: [UI] Show number of items in freetext feed
- Merge pull request #7184 from JakubOnderka/feed-event-preview-nicer.
  [Jakub Onderka]

  chg: [UI] Make feed event preview nicer
- Merge pull request #7203 from JakubOnderka/fix-build. [Alexandre
  Dulaunoy]

  fix: [test] Repo is missing
- Merge pull request #7191 from JakubOnderka/create-no-need. [Jakub
  Onderka]

  fix: [internal] Remove unnecessary create call
- Merge pull request #7190 from JakubOnderka/worker-name. [Jakub
  Onderka]

  fix: [workers] Worker name when processing freetext
- Merge pull request #7186 from JakubOnderka/threat-level-list. [Jakub
  Onderka]

  chg: [internal] Threat levels list
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge pull request #7182 from JakubOnderka/merge-local-tags. [Jakub
  Onderka]

  fix: [merge] Local tags should stay local
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch 'eventgraph-node-coloring' into develop. [mokaddem]
- Merge branch 'develop' of github.com:MISP/MISP into eventgraph-node-
  coloring. [mokaddem]
- Merge pull request #7170 from JakubOnderka/find-list-optim. [Jakub
  Onderka]

  chg: [optimisation] Faster Model::_findList method
- Merge pull request #7174 from JakubOnderka/event-locks-faster. [Jakub
  Onderka]

  chg: [internal] Faster event locks with Redis
- Merge pull request #7173 from JakubOnderka/disable-correlation-info-
  date. [Jakub Onderka]

  chg: [correlation] Do not update info and date column
- Merge pull request #7159 from Wachizungu/fix-removetag-querybuilder-
  template. [Alexandre Dulaunoy]

  chg: [restClient:querybuilder] fix remove tag from object template
- Merge pull request #7172 from Wachizungu/add-addTag-removeTag-actions-
  event-attribute-query-builder. [Alexandre Dulaunoy]

  chg: [restClient:querybuilder] add events and attributes addTag and r…
- Merge pull request #7171 from Wachizungu/fix-attributes-addtag-by-
  name. [Alexandre Dulaunoy]

  chg: [attributes] fix attribute addtag by name conditions for find no…
- Merge pull request #7168 from Wachizungu/fix-copypasta-error-
  attributes-addTag. [Jakub Onderka]

  chg: [attributes] fix copypasta error leading to internal server erro…
- Merge pull request #6967 from JakubOnderka/html-alert-email. [Jakub
  Onderka]

  HTML alert email
- Merge pull request #7161 from JakubOnderka/sighting-different-query.
  [Jakub Onderka]

  chg: [internal] Fetch attribute UUIDs for sightings in different query
- Merge pull request #7133 from JakubOnderka/pivot-fix. [Jakub Onderka]

  fix: [internal] PHP warnings when pivoting
- Merge pull request #7156 from JakubOnderka/fix-empty-object. [Jakub
  Onderka]

  fix: [internal] Warning when object has no attributes
- Merge pull request #7166 from JakubOnderka/css-nice. [Jakub Onderka]

  CSS nice
- Merge pull request #7167 from JakubOnderka/keyboard-shortucts. [Jakub
  Onderka]

  Keyboard shortcuts
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge pull request #7162 from JakubOnderka/empty-object-sync. [Jakub
  Onderka]

  fix: [sync] Warning when sync object without attributes
- Merge branch '2.4' into develop. [iglocska]
- Merge pull request #7160 from JakubOnderka/fix-diagnotics. [Jakub
  Onderka]

  fix: [UI] Module diagnostics view
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge pull request #7155 from JakubOnderka/push-optim. [Jakub Onderka]

  Push optim
- Merge pull request #7154 from JakubOnderka/diagnostics. [Jakub
  Onderka]

  Diagnostics
- Merge pull request #7150 from JakubOnderka/force-https. [Jakub
  Onderka]

  new: [internal] Security setting force_https
- Merge branch '2.4' into develop. [iglocska]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge pull request #7138 from JakubOnderka/oidc-role-fix. [Jakub
  Onderka]

  fix: [OIDC] Change algo how roles are assigned to users
- Merge pull request #7086 from JakubOnderka/save-progress. [Jakub
  Onderka]

  chg: [internal] When caching feed, save progress to db less often
- Merge pull request #7104 from JakubOnderka/authkeys-allowed-ips.
  [Jakub Onderka]

  new: [authkeys] Allowed IPs
- Merge pull request #7111 from JakubOnderka/cookie-name. [Jakub
  Onderka]

  chg: [internal] Set cookie name just when no name is set
- Merge pull request #7060 from JakubOnderka/galaxy-cluster-tag-name-ci.
  [Jakub Onderka]

  chg: [schema] Convert GalaxyCluster tag name to case insensitive
- Merge pull request #7112 from JakubOnderka/galaxy-cluster-md. [Jakub
  Onderka]

  new: [UI] Render galaxy cluster description as markdown
- Merge pull request #7127 from JakubOnderka/server-setting-cleanup.
  [Jakub Onderka]

  chg: [internal] Cleanup code that is resposible for fetching setting
- Merge pull request #7117 from JakubOnderka/keyboard-shortcuts. [Jakub
  Onderka]

  chg: [UI] Simplify keyboard-shortcuts.js
- Merge pull request #7116 from JakubOnderka/page-visibility-api. [Jakub
  Onderka]

  chg: [UI] Use Page Visibility API
- Merge pull request #7125 from JakubOnderka/fix-undefined-index. [Jakub
  Onderka]

  fix: [internal] Undefined index when importing from module
- Merge pull request #7113 from JakubOnderka/optimise-loading-clusters.
  [Jakub Onderka]

  chg: [optimise] Faster loading galaxy cluster index
- Merge branch '2.4' into develop. [iglocska]


v2.4.140 (2021-03-03)
---------------------

New
~~~
- [test] Password change. [Jakub Onderka]
- [server shell] list servers, fixes #7115. [iglocska]

  - simple human readable listing
  - kept the old weird JSON producing listServers intact
- [oidc] Readme. [Jakub Onderka]
- [security] Content-Security-Policy support. [Jakub Onderka]
- [CLI] check if updates are done yet or not. [iglocska]

  usage:

  - /var/www/MISP/app/Console/cake Admin updatesDone [blocking]
  - returns True or False based on whether it is done
  - When the blocking parameter is set, it will not return until all updates are done
- [api] When creating object, allow to mark tag as local. [Jakub
  Onderka]
- [type] new dkim and dkim-signature attribute type. [Alexandre
  Dulaunoy]
- [objectReference] Allow adding reference across extended events.
  [mokaddem]

  Fix #6255
- [UI] Event locks for background jobs and automatic tools. [Jakub
  Onderka]
- [UI] Show tag info in taxonomy view. [Jakub Onderka]
- [sync] Compressed requests support. [Jakub Onderka]
- [security] Security audit. [Jakub Onderka]
- [oidc] OpenID Connect authentication. [Jakub Onderka]
- [devshell] added a new shell for developer related tasks. [iglocska]

  - 1 task currently, cleanFeedDefault
    - runs some cleanup on the feed definition file to remove local IDs etc
- [object] Allows updating from an unknown object templates. [mokaddem]

Changes
~~~~~~~
- [csp] Add Security.csp_enforce to server setting. [Jakub Onderka]
- [csp] Report only by default. [Jakub Onderka]
- [PyMISP] Bump version. [Raphaël Vinot]
- [PyMISP] Fix tests. [Raphaël Vinot]
- [PyMISP] Bump before release. [Raphaël Vinot]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [version] bump. [iglocska]
- [UI] fix keyboard shortcut manager popup triangle. [Jeroen Pinoy]
- [UI] Add small description of what event block rules do. [Jeroen
  Pinoy]
- [sighting] Simplified sighting deletion. [Jakub Onderka]
- Bump PyMISP. [Raphaël Vinot]
- [genericForm] added description field to the explanation. [iglocska]
- Add small description of what org blocklist does. Fix #4363. [Jeroen
  Pinoy]
- [oidc] Use first match as user role. [Jakub Onderka]
- [UI] correct edit org blocklist entries view. [Jeroen Pinoy]
- [taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [UI] Disable sync XHR. [Jakub Onderka]
- [ineternal] Opimise GalaxyCluster::fetchGalaxyClusters when full is
  True. [Jakub Onderka]
- [UI] Put type under name for object add form. [Jakub Onderka]
- [UI] Nicer Object pre-save review. [Jakub Onderka]
- [UI] Make different forms nicer. [Jakub Onderka]
- [internal] Check missing taxonomies at one place. [Jakub Onderka]
- [internal] New method Taxonomy::splitTagToComponents. [Jakub Onderka]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- Add can access check for correlation exclusions menu entry. [Jeroen
  Pinoy]
- [PyMISP] updated. [Alexandre Dulaunoy]
- [js] Use proper message when remote server returns 401. [Jakub
  Onderka]
- [internal] Faster fetching galaxy clusters when fetching event. [Jakub
  Onderka]
- [UI] Remove authors from galaxy cluster popover. [Jakub Onderka]
- [UI] Do not create links for galaxy cluster source popover. [Jakub
  Onderka]

  Links are not clickable in popovers
- [UI] Do not show refs for galaxy cluster popover, becasue links are
  not clickable. [Jakub Onderka]
- [UI] Do not show description if is empty for galaxy cluster popover.
  [Jakub Onderka]
- [galaxy] Make Galaxy cluster description optional. [Jakub Onderka]
- [server] DBSchemaDiagnostic consider nullable inconsistencies as
  critical. [mokaddem]
- [genericPicker] Allow using picker for galaxy matrixes. [mokaddem]
- [objectReference] Renamed function. [mokaddem]
- [events:eventGraph] Improved hull algorithm and UI. [mokaddem]
- [js] Move code from template to misp.js. [Jakub Onderka]
- [internal] Faster Event::removeOlder method used when pulling from
  remote server. [Jakub Onderka]
- [internal] Simplified ServersController::serverSettings. [Jakub
  Onderka]
- Use a more suitable Sighting creation function as recommended, grab
  the Org ID from the user if present. [Tom King]
- Add in ability to update sightings against each attribute from a
  POSTed MISP Event. [Tom King]
- [feed] Simplified code for loading feeds. [Jakub Onderka]
- [restResponse] Return role_id along with its name. [mokaddem]
- [objectReference] Added objectReference/view endpoint. [mokaddem]
- [dashboard] added to the root level of the top menu. [iglocska]
- [internal] Make Redis connection static. [Jakub Onderka]
- [internal] Faster updating taxonomies. [Jakub Onderka]

Fix
~~~
- [csp] Incorrect variable name. [Jakub Onderka]
- [csp] Custom policies. [Jakub Onderka]
- [Sharing groups] capturing a sharing group correctly ignores the
  incoming data's active flag when editing. [iglocska]

  - based on PR #7101 by @lfortemps
- [sync] prevent local tags from being pulled. [Golbark]
- [email_otp] Trim value for increased UX. [Loïc Fortemps]
- [sharing groups] fixed regression with updating local sharing groups.
  [iglocska]
- [comments] updated for two recent changes in the code. [iglocska]
- [sharing groups] Allow users to see events they own, even if their
  organisation is not explicitly mentioned in the SG. [iglocska]

  - however, show a clear message that this is the case
  - in-line with the rest of the ACL
- [security] sharing group all org flag too lax. [iglocska]

  - the all org flag was used as a trigger to make the sharing group obejct itself viewable to all local organisations
  - even if the all org flag was set for an instance other than the local one

  - as reported by Jeroen Pinoy
- [tag index] remove sorting on count fields. [iglocska]

  - doesn't work anyway
- [galaxyCluster] Revoke relations on sync. [mokaddem]

  - Relationships are now re-build from scratch for the cluster being sync
  - This cancels any modification done locally (which should not have
  happened in the first place)
- [galaxyClusterRelations] Bump cluster's timestamp after performing
  CRUD on relations. [mokaddem]
- [pull] invalid internal vs external server lookup when deciding
  whether to pull local tags. [iglocska]
- [sharing group] saving fixed. [iglocska]

  invalid boolean operator when encoding the local org
- [email_otp] skip OTP for disabled users. [Loïc Fortemps]
- [internal] Empty object when getting event info for event report.
  [Jakub Onderka]
- [internal] Correctly save log. [Jakub Onderka]
- [Sharing group] refactored and fixed. [iglocska]

  - include own org in pulled sharing groups (to avoid implicit inclusion not being visible after a pull)
  - refactor the pulling method to be more maintainable
  - avoid pulling proposals/sightings on each event cherry pick
- [internal] Incorrect tag three components split. [Jakub Onderka]
- [UI] Fetch GalaxyElements for event index. [Jakub Onderka]
- [UI] Pagination for event reports in event view. [Jakub Onderka]
- [internal] Bad 7085. [Jakub Onderka]
- [internal] Bad merge that prevents language change. [Jakub Onderka]
- [sync] Undefined index when pushing sightings. [Jakub Onderka]
- [internal] perm_tag_editor can just create tags. [Jakub Onderka]
- [internal] Include cluster elements for user interface. [Jakub
  Onderka]
- [internal] Really disable password change. [Jakub Onderka]
- [sync] Fixed a critical issue causing sharing groups to lose
  orgs/instance information on sync when using non sync users on a pull.
  [iglocska]
- Ui  _ function does not exist, l10n function is __ [Patrizio Tufarolo]
- Syntax error in constructTaxonomyInfo() [Fredrik Soderblom]
- [server] Add application/x-pie-executable to the list of accepted
  mimetypes in testForBinExec. [Patrizio Tufarolo]
- [schema feed] remove non-required fields in feed format. [Alexandre
  Dulaunoy]
- [API] password reset was broken for admins. [iglocska]
- [tools] misp-wipe updated list of table to truncate. [mokaddem]
- [js] Use error callback for relevant ajax calls. [Jakub Onderka]
- [js] Remove async default value. [Jakub Onderka]
- [galaxy] GalaxyClusterRelation doesn't have Org and Orgc. [Jakub
  Onderka]
- [restsearch] fixed a bug introduced via the new page/limit filters.
  [iglocska]
- [caching] monkey-patching a client side MISP bug causing the caching
  to loop endlessly. [iglocska]

  - MISP caching can run into an endless loop if errors are returned for whatever reason
  - This patch handles the specific case when the remote MISP requests an attribute range for caching that has an offset beyond the highest ID (should never happen)

  - It's a dirty fix but should have nearly no impact on performance whilst resolving the issue
- [server] Caching a server ensures that the returned data is an actual
  UUID. [mokaddem]
- [ACL] opened up postTest to all roles. [Andras Iklody]
- [securityAudit] Display python version. [mokaddem]
- [dashboard] Saving an invalid JSON when importing templates shows an
  error. [mokaddem]
- [galaxy] Missing variable when editing relation. [Jakub Onderka]
- [attributes] full_group_by fix for statistics. Fix #7014. [mokaddem]
- [event] Fix retreiving selected referenced element data. [mokaddem]
- [event] Provide text for missing referenced elements. [mokaddem]

  - The event might not contain the referenced elements if they belong to
  an extended event
- [events:eventGraph] Make sure to include event_id for attribute nodes.
  [mokaddem]
- [post] Do not send emails to disabled user for new posts. [Jakub
  Onderka]
- [UI] Attribute create button nicer. [Jakub Onderka]
- [internal] Remove unused ServerTag. [Jakub Onderka]
- [internal] Remove unused layouts. [Jakub Onderka]
- [internal] Remove unused roboto font. [Jakub Onderka]
- [UI] Remove unnecessary CSS from default template. [Jakub Onderka]
- [restClient] Make sure to split value on strings. [mokaddem]

  Fix #7032
- [objectReference] Make sure to bump timestamp. [mokaddem]
- [objectReference] Make sure to save source_uuid field as well.
  [mokaddem]
- [Event] Correctly save references after sync. [mokaddem]
- [galaxy] Fix undefined variable when capturing clusters. [Jakub
  Onderka]
- [feed defaults] Removed some required properties in the validation
  schema. [mokaddem]

  - Propoerties like IDs are instance dependant and therefore are not
  necessary
- [dashboard] Saving an invalid JSON shows an error. [mokaddem]

  Fix #6975
- [feed defaults] removed a bunch of feeds and clarified the description
  of some, fixes #7006. [iglocska]
- [UI] Galaxy pagination. [Jakub Onderka]
- [feed] edit ignored changes to the header, fixes #6780. [iglocska]
- [UI] Showing date and time in user profile. [Jakub Onderka]
- [UI] Object template pagination. [Jakub Onderka]
- [feeds] feed edit ignored the headers field, ffixes #6780. [iglocska]
- Allow cluster authors to be an actual array. [Tom King]
- Allow 'hard' param in POSTed body for deleting a cluster, send back a
  proper message. [Tom King]

Other
~~~~~
- Merge pull request #7149 from JakubOnderka/csp-setting. [Jakub
  Onderka]

  chg: [csp] Add Security.csp_enforce to server setting
- Merge pull request #7145 from JakubOnderka/fix-change-pw. [Jakub
  Onderka]

  new: [test] Password change by org admin
- Merge pull request #7147 from JakubOnderka/fix-csp-again. [Jakub
  Onderka]

  fix: [csp] Incorrect variable name
- Merge branch 'jakub' into 2.4. [iglocska]
- Merge pull request #7142 from JakubOnderka/fix-csp. [Jakub Onderka]

  fix: [csp] Custom policies
- Merge branch 'develop' into 2.4. [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #6661 from cudeso/2.4. [Andras Iklody]

  Azure Active Directory Authentication
- Avoid "TODO" in the README to avoid CodeFactor. [Koen Van Impe]
- Azure Active Directory Authentication. [Koen Van Impe]
- Merge pull request #7100 from lfortemps/local-tags-fix. [Andras
  Iklody]

  Prevent pulling local tags
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge pull request #7130 from Wachizungu/fix-shortcut-manager-
  triangle-popup. [Andras Iklody]

  chg: [UI] fix keyboard shortcut manager popup triangle
- Merge pull request #7114 from Wachizungu/add-short-event-block-rule-
  explanation. [Andras Iklody]

  chg: [UI] Add small description of what event block rules do
- Merge pull request #6736 from JakubOnderka/sighting-deletion. [Andras
  Iklody]

  chg: [sighting] Simplified sighting deletion
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #7059 from adammchugh/patch-1. [Andras Iklody]

  Inclusion of full-name under person
- Inclusion of full-name under person. [adammchugh]

  Proposing the inclusion of full-name under person to allow for better capture and correlation of full names of identified persons in events. Particularly where there are multiple identities within an event which may create confusion with multiple first-name and last-name entries.
- Merge pull request #7080 from StefanKelm/2.4. [Andras Iklody]

  Update resolved_misp_format.ctp
- Update resolved_misp_format.ctp. [StefanKelm]

  slight rewording
- Merge pull request #7092 from lfortemps/patch-2. [Andras Iklody]

  fix: [email_otp] Trim value for increased UX
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [mokaddem]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [mokaddem]
- Merge remote-tracking branch 'origin/2.4' into develop. [mokaddem]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge pull request #7094 from JakubOnderka/oidc-readme. [Jakub
  Onderka]

  new: [oidc] Readme
- Merge pull request #7106 from Wachizungu/add-short-org-blocklist-
  explanation. [Alexandre Dulaunoy]

  chg: [UI] Add small description of what org blocklist does. Fix #4363
- Merge pull request #7105 from JakubOnderka/oidc-roles. [Jakub Onderka]

  chg: [oidc] Use first match as user role
- Merge pull request #7107 from Wachizungu/change-edit-org-blocklist-
  view-title. [Jakub Onderka]

  chg: [UI] correct edit org blocklist entries view
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge pull request #7091 from Golbark/patch-1. [Alexandre Dulaunoy]

  fix: [email_otp] skip OTP for disabled users
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [Alexandre Dulaunoy]
- Merge pull request #7095 from JakubOnderka/event-report-empty-objects.
  [Jakub Onderka]

  fix: [internal] Empty object when getting event info for event report
- Merge pull request #7097 from JakubOnderka/csp. [Jakub Onderka]

  new: [security] Content-Security-Policy support
- Merge pull request #7102 from JakubOnderka/disable-sync-xhr. [Jakub
  Onderka]

  chg: [UI] Disable sync XHR
- Merge pull request #7090 from JakubOnderka/fix-saving-log. [Jakub
  Onderka]

  fix: [internal] Correctly save log
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [Alexandre Dulaunoy]
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge pull request #7089 from JakubOnderka/fix-tag-split. [Jakub
  Onderka]

  fix: [internal] Incorrect tag three components split
- Merge pull request #7083 from JakubOnderka/event-index-galaxy-
  elements. [Jakub Onderka]

  fix: [UI] Fetch GalaxyElements for event index
- Merge pull request #7088 from JakubOnderka/event-report-pagination.
  [Jakub Onderka]

  fix: [UI] Pagination for event reports in event view
- Merge pull request #7087 from JakubOnderka/fix-7085. [Jakub Onderka]

  fix: [internal] Bad 7085
- Merge pull request #7085 from JakubOnderka/optimise-cluster-fetch.
  [Jakub Onderka]

  Optimise cluster fetch
- Merge pull request #7084 from JakubOnderka/fix-bad-merge-lang. [Jakub
  Onderka]

  fix: [internal] Bad merge that prevents language change
- Merge pull request #7049 from JakubOnderka/ui-form-fixes. [Jakub
  Onderka]

  chg: [UI] Make different forms nicer
- Merge pull request #7079 from JakubOnderka/fix-sightings-pushing.
  [Jakub Onderka]

  fix: [sync] Undefined index when pushing sightings
- Merge pull request #7078 from JakubOnderka/missing-taxonomies. [Jakub
  Onderka]

  Missing taxonomies
- Merge pull request #7069 from JakubOnderka/tag-edit-delete. [Jakub
  Onderka]

  fix: [internal] perm_tag_editor can just create tags
- Merge pull request #7073 from JakubOnderka/include-cluster-meta.
  [Jakub Onderka]

  fix: [internal] Include cluster elements for user interface
- Merge pull request #7065 from JakubOnderka/disable-password-change.
  [Jakub Onderka]

  fix: [internal] Really disable password change
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #7056 from Wachizungu/add-can-access-check-for-
  menu-entry-correlation-exclusions. [Jakub Onderka]

  chg: [UI] Add can access check for correlation exclusions menu entry
- Merge pull request #7070 from fsoderblom/fix-syntaxerror. [Andras
  Iklody]

  fix: syntax error in constructTaxonomyInfo()
- Update misp-wipe.sql. [Raphaël Vinot]

  Rename whitelist -> allowedlist / blacklist -> blocklist
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #7037 from Wachizungu/add-list-auth-keys-button-to-
  global-menu. [Alexandre Dulaunoy]

  Adds 'List Auth Keys' button to Administration in global menu
- Adds 'List Auth Keys' button to Administration in global menu. [Jeroen
  Pinoy]
- Merge pull request #7052 from patriziotufarolo/patch-1. [Alexandre
  Dulaunoy]

  fix: [server] Add application/x-pie-executable to the list of accepted mimetypes in testForBinExec
- Merge pull request #7053 from eCrimeLabs/2.4. [Alexandre Dulaunoy]

  Fix for ZeroMQ - #7040 and #7039
- Fix for #7040 and #7039. [eCrimeLabs]

  The following commit contains the fix for ZeroMQ only listening on 0.0.0.0
- Merge pull request #7033 from MISP/fix-misp-wipe. [Andras Iklody]

  fix: [tools] misp-wipe updated list of table to truncate
- Merge pull request #7048 from JakubOnderka/xhr-401-handling. [Jakub
  Onderka]

  XHR 401 handling
- Merge pull request #7055 from JakubOnderka/fast-event-galaxies. [Jakub
  Onderka]

  chg: [internal] Faster fetching galaxy clusters when fetching event
- Merge pull request #7057 from JakubOnderka/tag-local. [Jakub Onderka]

  new: [api] When creating object, allow to mark tag as local
- Merge pull request #7050 from JakubOnderka/cluster-relation. [Jakub
  Onderka]

  fix: [galaxy] GalaxyClusterRelation doesn't have Org and Orgc
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge pull request #7027 from JakubOnderka/galaxy-view-mini. [Jakub
  Onderka]

  Galaxy view mini
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [mokaddem]
- Merge pull request #7029 from JakubOnderka/galaxy-cluster-description.
  [Jakub Onderka]

  chg: [galaxy] Make Galaxy cluster description optional
- Merge pull request #7043 from JakubOnderka/cluster-relattion-missing-
  var. [Jakub Onderka]

  fix: [galaxy] Missing variable when editing relation
- Merge branch 'feature-reference-for-extended-event' into develop.
  [mokaddem]
- Merge branch 'develop' into feature-reference-for-extended-event.
  [mokaddem]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [mokaddem]
- Merge pull request #6742 from JakubOnderka/post-user-disabled. [Jakub
  Onderka]

  fix: [post] Do not send emails to disabled user for new posts
- Merge pull request #6925 from JakubOnderka/event-locks. [Jakub
  Onderka]

  new: [UI] Event locks for background jobs and automatic tools
- Merge pull request #6943 from JakubOnderka/ui-create-button. [Jakub
  Onderka]

  fix: [UI] Attribute create button nicer
- Merge pull request #7002 from JakubOnderka/code-cleanup. [Jakub
  Onderka]

  fix: [UI] Remove unnecessary CSS from default template
- Merge pull request #7034 from JakubOnderka/taxonomy-tag-info. [Jakub
  Onderka]

  new: [UI] Show tag info in taxonomy view
- Merge pull request #6906 from JakubOnderka/compressed-requests. [Jakub
  Onderka]

  new: [sync] Compressed requests support
- Merge pull request #6871 from JakubOnderka/faster-pull. [Jakub
  Onderka]

  chg: [internal] Faster Event::removeOlder method used when pulling
- Merge pull request #6741 from JakubOnderka/security-diagnostics.
  [Jakub Onderka]

  new: [security] Security diagnostics
- Merge pull request #6938 from tomking2/feature/attribute_sightings.
  [Jakub Onderka]

  [API] Update attribute sightings from REST POST
- Merge remote-tracking branch 'upstream/2.4' into
  feature/attribute_sightings. [Tom King]
- Merge branch '2.4' into feature/attribute_sightings. [Tom King]
- Merge pull request #6984 from JakubOnderka/oidc. [Jakub Onderka]

  new: [oidc] OpenID Connect authentication
- Merge pull request #7020 from JakubOnderka/feed-saving-simplified.
  [Jakub Onderka]

  chg: [feed] Simplified code for saving feed
- Merge remote-tracking branch 'origin/2.4' into develop. [mokaddem]
- Merge branch 'fix-sync-object-relations' into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into fix-sync-object-
  relations. [mokaddem]
- Merge pull request #7035 from JakubOnderka/galaxy-fix-undefined-
  variable. [Jakub Onderka]

  fix: [galaxy] Fix undefined variable when capturing clusters
- Merge branch 'tomking2-bug/galaxy_cluster' into develop. [mokaddem]
- Merge remote-tracking branch 'origin/develop' into
  tomking2-bug/galaxy_cluster. [mokaddem]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge pull request #7017 from JakubOnderka/fix-galaxies-pagination.
  [Jakub Onderka]

  fix: [UI] Galaxy pagination
- Merge pull request #7015 from JakubOnderka/redis-static. [Jakub
  Onderka]

  chg: [internal] Make Redis connection static
- Merge branch '2.4' into develop. [iglocska]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge pull request #7016 from JakubOnderka/fix-user-view-time. [Jakub
  Onderka]

  fix: [UI] Showing date and time in user profile
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [mokaddem]
- Merge pull request #7008 from JakubOnderka/update-taxnomies-faster.
  [Jakub Onderka]

  chg: [internal] Faster updating taxonomies
- Merge branch '2.4' into develop. [iglocska]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge pull request #7007 from JakubOnderka/object-template. [Jakub
  Onderka]

  fix: [UI] Object template
- Merge branch '2.4' into develop. [iglocska]
- Merge remote-tracking branch 'upstream/2.4' into bug/galaxy_cluster.
  [Tom King]


v2.4.139 (2021-02-16)
---------------------

New
~~~
- [widget] Eventstream widget and index widget UI added. [iglocska]

  - EventStream
    - add a lightweight event index to your dashboard
    - configure filters for the events you're interested in (tags, orgs, published)
    - set the number of events to display (limit)
    - set the list of fields it should display (id, orgc, info, tags, threat_level, analysis, date)

  - Index widget UI
    - uses the generic index builder
    - build simple index like UIs
- [event] Added supports of eventReport coming from modules. [mokaddem]
- [modules] Export module can specify event fetch options. [Jakub
  Onderka]

Changes
~~~~~~~
- [version] bump. [iglocska]
- [array lookup index field] updatd to work correctly. [iglocska]
- [event model] fetchEvent() now accepts page/limit/order as parameters.
  [iglocska]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [events] Enables index search for object. Fix #6961. [mokaddem]
- [organisation] "International" typo fixed + Europe added. [Alexandre
  Dulaunoy]

  Notes TODO: Improve the selection using the region galaxy in addition to
  country galaxy
- [installer] Updated installer Checksums. [Steve Clement]
- [installer] The installer is compatible with Ubuntu 21.04 LTS. [Steve
  Clement]
- [LogsController] add missing EventReport in log search. [Alexandre
  Dulaunoy]
- [organisation] "International" typo fixed + Europe added. [Alexandre
  Dulaunoy]

  Notes TODO: Improve the selection using the region galaxy in addition to
  country galaxy
- [UI] Make event preview nicer. [Jakub Onderka]
- [UI] Highlight column for roles table. [Jakub Onderka]
- [internal] Faster updating warninglist. [Jakub Onderka]
- [UI] Allow filter enabled/disabled warninglists. [Jakub Onderka]
- [internal] Small optimisation for filterEventIds. [Jakub Onderka]
- [internal] Use RestResponse for filterEventIdsForPush. [Jakub Onderka]
- [internal] Update moment javascript library. [Jakub Onderka]
- [internal] Update composer to 2.0.9. [Jakub Onderka]
- [UI] Use TimeHelper for datetime formatting. [Jakub Onderka]
- [internal] Refactor TagsController::view. [Jakub Onderka]
- [event fetcher] add limit and page parameters to the event fetcher.
  [iglocska]
- [connection test] clarified that read only users can pull. [iglocska]

  - Reduced error level to "orange"
  - Added a clarification that they can still pull

Fix
~~~
- [dashboard] removed training example left in the code. [iglocska]

  - restricted new module to only 3 user IDs
- [event index] changed the galaxy cluster field width. [iglocska]

  - no longer looks like it was sandwiched between two semis
- [UI] Escaping in row_attribute. [Jakub Onderka]
- [internal] Field name in HttpSocketExtended. [Jakub Onderka]
- [breakOnDuplicate] on event add fixed, fixes #6917. [iglocska]

  - add breakOnDuplicate on the event level as a flag
    - {"Event":{"breakOnDuplicate":1, "info": "foo", ...}}

  - correctly handle 2 equal objects added to the same event in memory
- [auto logout] disabled. [iglocska]

  - this crap just causes issues and is pretty pointless
- [event] `merge from` feature correctly saves object relations. Fix
  #6969. [mokaddem]
- [event] Includes eventReport when using the `merge from` feature.
  [mokaddem]
- [dashboard] Typo breakig the dashboards fixed. [iglocska]
- [eventreport] add fixed to avoid ID collisions. [iglocska]
- [STIX] fix typo in message. [Alexandre Dulaunoy]
- [events] Attach cluster from matrix in multiselect. Fix #6956.
  [mokaddem]
- [eventTimeline] Refrsh attribute index when dragging. Fix #6958.
  [mokaddem]
- [STIX] fix typo in message. [Alexandre Dulaunoy]
- [taxonomy] Hide unselectable tags by default. Fix #6912. [mokaddem]
- [event] Publishing to pub/sub queues includes all tags. [mokaddem]
- [internal] Bad variable. [Jakub Onderka]
- [UI] Undefined variables in authkeys view. [Jakub Onderka]
- [idTranslator] Distinguish between not found and unreachable. [Jakub
  Onderka]
- [UI] Broken checkboxes for role permissions. [Jakub Onderka]
- [internal] GalaxyCluster::getCluster also accepts ID. [Jakub Onderka]
- Correctly show hidden tags in tag-list. [marjatech]
- [UI] Attach correct count of enabled taxonomy tags. [Jakub Onderka]
- [UI] Remove right margin from form seen input. [Jakub Onderka]
- [feed] Feed name is required. [Jakub Onderka]
- [internal] idTranslator could show invalid results. [Jakub Onderka]
- [generic_picker] Improved perfs by adding a debounce for redrawing
  results. [mokaddem]
- [logs] aded eventgraph to log search. [iglocska]
- [UI] Undefined variables in authkeys view. [Jakub Onderka]
- [galaxyClusters:view_relation_tree] Fix inital draw of the tree.
  [mokaddem]

  - Declare variables before assigning value
- Elasticsearch complains when an IP is an empty string. [Tom King]
- [tag collections] typo causing tag collections to break completely
  fixed. [iglocska]
- [bro] export fixed. [iglocska]

  - invalid group by statement removed

Other
~~~~~
- Merge branch 'develop' into 2.4. [iglocska]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge pull request #7012 from JakubOnderka/row-attribute-escaping.
  [Jakub Onderka]

  fix: [UI] Escaping in row_attribute
- Merge pull request #7011 from JakubOnderka/http-socket-fied-name.
  [Jakub Onderka]

  fix: [internal] Field name in HttpSocketExtended
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [mokaddem]
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [mokaddem]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [Alexandre Dulaunoy]
- Merge remote-tracking branch 'origin/2.4' into develop. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge pull request #7009 from SteveClement/guides. [Steve Clement]

  chg: [installer] The installer is compatible with Ubuntu 21.04 LTS
- Merge pull request #7001 from JakubOnderka/nicer-event-preview. [Jakub
  Onderka]

  chg: [UI] Make event preview nicer
- Merge pull request #7004 from JakubOnderka/bad-variable. [Jakub
  Onderka]

  fix: [internal] Bad variable
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge pull request #6999 from JakubOnderka/authkey-undefined-
  variables. [Jakub Onderka]

  fix: [UI] Undefined variables in authkeys view
- Merge pull request #6997 from JakubOnderka/id-translator-fixes. [Jakub
  Onderka]

  fix: [idTranslator] Distinguish between not found and unreachable
- Merge pull request #6995 from JakubOnderka/fix-role-edit-view. [Jakub
  Onderka]

  fix: [UI] Broken checkboxes for role permissions
- Merge pull request #6996 from JakubOnderka/highlight-column-role.
  [Jakub Onderka]

  chg: [UI] Highlight column for roles table
- Merge pull request #6994 from JakubOnderka/get-cluster-id. [Jakub
  Onderka]

  fix: [internal] GalaxyCluster::getCluster also accepts ID
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge pull request #6993 from JakubOnderka/warninglist-index. [Jakub
  Onderka]

  chg: [UI] Allow filter enabled/disabled warninglists
- Merge pull request #6816 from JakubOnderka/filter-event-ids-
  optimisation. [Jakub Onderka]

  chg: [internal] Small optimisation for filterEventIds
- Merge pull request #6872 from JakubOnderka/rest-response-filter-event.
  [Jakub Onderka]

  chg: [internal] Use RestResponse for filterEventIdsForPush
- Merge pull request #6898 from JakubOnderka/export-module-fetch-
  options. [Jakub Onderka]

  new: [modules] Export module can specify event fetch options
- Merge pull request #6937 from marjatech/fix_list_hidden_tags. [Jakub
  Onderka]

  fix: correctly show hidden tags in tag-list
- Merge pull request #6992 from JakubOnderka/taxonomy-attach-real-count.
  [Jakub Onderka]

  fix: [UI] Attach correct count of enabled taxonomy tags
- Merge branch '2.4' into develop. [mokaddem]
- Merge pull request #6989 from JakubOnderka/moment-update. [Jakub
  Onderka]

  chg: [internal] Update moment javascript library
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [mokaddem]
- Merge pull request #6985 from JakubOnderka/form-seen-fix. [Jakub
  Onderka]

  fix: [UI] Remove right margin from form seen input
- Merge pull request #6986 from JakubOnderka/feed-name-required. [Jakub
  Onderka]

  fix: [feed] Feed name is required
- Merge pull request #6983 from JakubOnderka/composer-update-2. [Jakub
  Onderka]

  chg: [internal] Update composer to 2.0.9
- Merge pull request #6982 from JakubOnderka/time-helper. [Jakub
  Onderka]

  chg: [UI] Use TimeHelper for datetime formatting
- Merge pull request #6980 from JakubOnderka/tag-view-refactor. [Jakub
  Onderka]

  chg: [internal] Refactor TagsController::view
- Merge pull request #6977 from JakubOnderka/fix-idTranslator. [Jakub
  Onderka]

  fix: [internal] idTranslator could show invalid results
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #6988 from tomking2/bug/elasticsearch_ip.
  [Alexandre Dulaunoy]

  fix: Elasticsearch complains when an IP is an empty string


v2.4.138 (2021-02-08)
---------------------

New
~~~
- [settings] Allow to use ThreatLevel.name for alert filter. [Jakub
  Onderka]
- [test] Update github actions build to Ubuntu 20.04. [Jakub Onderka]
- [internal] Cidr tool for faster checking CIDR ranges. [Jakub Onderka]
- [objectTemplate] Allow fetching the raw template stored on disk by
  UUID or name. [mokaddem]
- [PHP] version notification. [iglocska]

  - 8.0 is not supported, let users know in a more obvious way

Changes
~~~~~~~
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [version] bump. [iglocska]
- Bump PyMISP & version. [Raphaël Vinot]
- [ACLComponent] Added new galaxy element endpoints. [mokaddem]
- [tools] Removed useless library. [mokaddem]
- [galaxyClusters:view_relation] Reuse already fetched relations.
  [mokaddem]
- [galaxyElement] Added individual deletion and JSON
  flattening/expanding. [mokaddem]
- [misp.js] Allow index filtering without searchbox. [mokaddem]
- [galaxyElements] Migrated galaxy element index to generic factory.
  [mokaddem]
- [galaxyElement] Added draft of element flattening and unflattening.
  [mokaddem]
- [internal] Optimise fetching trending tags widget. [Jakub Onderka]
- [internal] Cache warninglist for eight hours. [Jakub Onderka]
- [UI] Make toggle buttons nicer. [Jakub Onderka]
- [internal] Optimise correlation exclusion. [Jakub Onderka]
- [internal] Optimise CidrTool. [Jakub Onderka]
- [PyMISP] Bump, update deps (reportlab release removed) [Raphaël Vinot]
- Bump PyMISP. [Raphaël Vinot]
- [objecTemplate:getRaw] Refactored and optimized feature. [mokaddem]
- [eventReports:delete] Make delete/restore call consistent with other
  models. [mokaddem]
- [internal] Raise memory limit for TmptFileTool to 5 MB. [Jakub
  Onderka]
- [internal] Generate event to TmpFile. [Jakub Onderka]
- [eventReports:delete] Accept hard flag to be passed in POST body.
  [mokaddem]
- Bumped queryversion. [mokaddem]
- [eventReports] Improved manual extraction layout. [mokaddem]
- [export:csv] Added support of decaying model. Fix #6734. [mokaddem]
- [console:admin] Improved feedback when updating object templates. Fix
  #6715. [mokaddem]
- [objects:delete] Support of hard flag in posted body. Fix #6689.
  [mokaddem]
- [PyMISP] bump to latest version. [Alexandre Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [installer] fixes to misp-modules. [Steve Clement]
- [misp-modules] some reqs are not in sync, fixing manually. [Steve
  Clement]
- [installer] Update to latest installer. [Steve Clement]
- [misp-objects] updated to the latest. [Alexandre Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [cake] Make misp-after-installer less yellow. [Steve Clement]
- [misp-galaxy] updated (RSIT galaxy added) [Alexandre Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- Bumped queryversion. [mokaddem]
- [objects:delete] Support of hard flag in posted body. Fix #6689.
  [mokaddem]
- Bumped queryversion. [mokaddem]

Fix
~~~
- [zmq/kafka] attribute edits should include non exportable attributes.
  [iglocska]
- [UI] notice resolved on the feed index. [iglocska]
- [internal] Do not throw warning when user don't have collections.
  [Jakub Onderka]
- [galaxyCluster] Delete elements if field is empty. [mokaddem]
- [galaxyCluster] Integrated changes of improved index factory.
  [mokaddem]
- [CLI] Check user existence. [Jakub Onderka]
- [UI] passedArgs should be JSON encoded. [Jakub Onderka]
- [widget] Typo in MispSystemResourceWidget. [Jakub Onderka]
- [internal] First check if attribute value is valid composite, then run
  other checks. [Jakub Onderka]
- [internal] Bump CakePHP to 2.10.24. [Jakub Onderka]
- [internal] Bump PyMISP. [Jakub Onderka]
- [UI] Nicer forms. [Jakub Onderka]
- [internal] Fix some warnings. [Jakub Onderka]
- [logs:event] Added missing line breaks. [mokaddem]
- [log] Allow to filter logs by org name. [Jakub Onderka]
- [acl] Added missing ACL entry. [mokaddem]
- [objectTemplate:update] Typo instance variable. [mokaddem]
- [shadowAttributes:viewPicture] Allows shadow attribute's pictures to
  be displayed. [mokaddem]
- [attributes:viewPicture] Allow viewing pictures of deleted attributes.
  [mokaddem]
- [events:eventGraph] Deleted object reference are no longer shown in
  the graph. [mokaddem]

  - Fix #6487
- [UI] Allow to download attachments from attribute index. [Jakub
  Onderka]
- [internal] Remove compact method call that do nothing. [Jakub Onderka]
- [eventReport:getProxyElement] Prevent crash if viewing a report for an
  extended event. [mokaddem]

  - Make sure merging array happens in existing keys
- [server:recoveyQuery] Only add `unsigned` when applicable. Fix #6762.
  [mokaddem]

  - Correctly compare return value of strpos
- [UI] Show proper unit for diagnostics. [Jakub Onderka]
- [servers:rest] Speed up rest client and improved reactivity.
  [mokaddem]

  - Added debounce when typing
  - Only update query builder when its displayed
- [warninglists:index] Fixed URL for ID. [mokaddem]
- [UI] Remote event preview. [Jakub Onderka]
- [stix2 import] Fixed pattern parsing. [chrisr3d]

  - Stripping patterns to avoid issue with space
    characters at the beginning or at the end of the
    patterns
- [UI] hard-delete option missing for soft-deleted objects. [iglocska]
- [internal] timestmaping when adding clusters to attributes wasn't
  working. [iglocska]

  - added it as a quick fix, should be moved in the future to a more generic place
- [extended event] layout broken, fixes #6946. [iglocska]
- [internal] Capturing sightings for attributes. [Jakub Onderka]
- [kali] Fixed Kali installer, now only works on 2020.4 and higher.
  [Steve Clement]
- [breakOnDuplicate] invalid placement return, affects #6917. [iglocska]

  - as reported by @github-germ
- [UI] Allow to sort feeds by name. [Jakub Onderka]
- [eventReport:edit] Editing event via /events/edit should work as
  expected. [mokaddem]

  - Correct call to editReport
  - Force local ID to match provided UUID
- [dashboards] saving the dashboard state failed due to uninitialised
  model. [Andras Iklody]
- [events:eventTimeline] Correctly restore elements after changing
  context or group. [mokaddem]

  - Fix #6885
- [events:eventGraph] Makes additions and editions of nodes working as
  expected. [mokaddem]

  Fix #6877
- Bump PyMISP, make gh actions happy. [Raphaël Vinot]
- [eventReport:getProxyElement] Prevent crash if viewing a report for an
  extended event. [mokaddem]

  - Make sure merging array happens in existing keys
- [server:recoveyQuery] Only add `unsigned` when applicable. Fix #6762.
  [mokaddem]

  - Correctly compare return value of strpos
- [servers:rest] Speed up rest client and improved reactivity.
  [mokaddem]

  - Added debounce when typing
  - Only update query builder when its displayed
- [warninglists:index] Fixed URL for ID. [mokaddem]
- [diagnostics] complain about PHP >= 8.0. [iglocska]

Other
~~~~~
- Merge branch 'develop' into 2.4. [iglocska]
- Merge pull request #6939 from JakubOnderka/warnings-fix. [Jakub
  Onderka]

  fix: [internal] Do not throw warning when user don't have collections
- Merge branch 'feature-galaxy-element-tree-view' into develop.
  [mokaddem]
- Merge remote-tracking branch 'origin/develop' into feature-galaxy-
  element-tree-view. [mokaddem]
- Merge branch 'develop' into feature-galaxy-element-tree-view.
  [mokaddem]
- Merge branch 'develop' of github.com:MISP/MISP into feature-galaxy-
  element-tree-view. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into feature-galaxy-
  element-tree-view. [mokaddem]
- Merge pull request #6973 from JakubOnderka/check-user-existence.
  [Jakub Onderka]

  fix: [CLI] Check user existence
- Merge pull request #6971 from JakubOnderka/threat-level-notification-
  filter. [Jakub Onderka]

  new: [settings] Allow to use ThreatLevel.name for alert filter
- Merge pull request #6948 from JakubOnderka/fix-passed-args. [Jakub
  Onderka]

  fix: [UI] passedArgs should be JSON encoded
- Merge pull request #6962 from JakubOnderka/trending-tags-optimisation.
  [Jakub Onderka]

  chg: [internal] Optimise fetching trending tags widget
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [chrisr3d]
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge pull request #6964 from JakubOnderka/attribute-validation-order.
  [Jakub Onderka]

  fix: [internal] First check if attribute value is valid composite
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge branch '2.4' into develop. [Steve Clement]
- Merge pull request #6950 from JakubOnderka/bump-cakephp. [Jakub
  Onderka]

  fix: [internal] Bump CakePHP to 2.10.24
- Merge pull request #6949 from JakubOnderka/bump-pymisp-v2. [Jakub
  Onderka]

  fix: [internal] Bump PyMISP
- Merge pull request #6944 from JakubOnderka/warninglist-cache-raise.
  [Jakub Onderka]

  chg: [internal] Cache warninglist for eight hours
- Merge pull request #6935 from JakubOnderka/event-toggle-buttons.
  [Jakub Onderka]

  chg: [UI] Make toggle buttons nicer
- Merge pull request #6894 from JakubOnderka/github-actions-os. [Jakub
  Onderka]

  new: [test] Update github actions build to Ubuntu 20.04
- Merge pull request #6888 from JakubOnderka/form-ui-fixes. [Jakub
  Onderka]

  fix: [UI] Nicer forms
- Merge pull request #6927 from JakubOnderka/correlation-exclusion-
  optimise. [Jakub Onderka]

  chg: [internal] Optimise correlation exclusion
- Merge pull request #6926 from JakubOnderka/faster-cidr-tool. [Jakub
  Onderka]

  chg: [internal] Optimise CidrTool
- Merge pull request #6899 from marjatech/smime-signature. [Andras
  Iklody]

  fix: generate S/MIME Signature in DETACHED mode
- Switch S/MIME Signature generation to DETACHED mode. [marjatech]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [mokaddem]
- Merge pull request #6924 from JakubOnderka/cidr-tool. [Jakub Onderka]

  new: [internal] Cidr tool for faster checking CIDR ranges
- Merge pull request #6922 from JakubOnderka/warnings-fixes. [Jakub
  Onderka]

  fix: [internal] Fix some warnings
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [Alexandre Dulaunoy]
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge pull request #6889 from JakubOnderka/log-org-filter. [Jakub
  Onderka]

  fix: [log] Allow to filter logs by org name
- Merge branch 'feature-getRawObjectTemplate' into develop. [mokaddem]
- Merge branch 'develop' of github.com:MISP/MISP into feature-
  getRawObjectTemplate. [mokaddem]
- Merge remote-tracking branch 'origin/2.4' into develop. [mokaddem]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [mokaddem]
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge pull request #6873 from JakubOnderka/event-output. [Jakub
  Onderka]

  Event output
- Merge remote-tracking branch 'origin/2.4' into develop. [mokaddem]
- Merge branch '2.4' into develop. [mokaddem]
- Merge pull request #6900 from JakubOnderka/attribute-index-attachment-
  download. [Jakub Onderka]

  fix: [UI] Allow to download attachments from attribute index
- Merge pull request #6737 from JakubOnderka/remove-compat. [Andras
  Iklody]

  fix: [internal] Remove compact method call that do nothing
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [mokaddem]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [mokaddem]
- Merge pull request #6890 from JakubOnderka/php-diagnostics-unit.
  [Jakub Onderka]

  fix: [UI] Show proper unit for diagnostics
- Merge remote-tracking branch 'origin/2.4' into develop. [mokaddem]
- Merge pull request #6881 from JakubOnderka/remote-event-preview-fix.
  [Jakub Onderka]

  fix: [UI] Remote event preview
- Merge pull request #6976 from StefanKelm/2.4. [Jakub Onderka]

  Update Server.php
- Update Server.php. [StefanKelm]

  wording
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #6951 from JakubOnderka/fix-sighting-capture.
  [Jakub Onderka]

  fix: [internal] Capturing sightings for attributes
- Merge pull request #6953 from SteveClement/guides. [Steve Clement]

  chg: [misp-modules] some reqs are not in sync, fixing manually.
- Merge pull request #6952 from SteveClement/guides. [Steve Clement]
- Merge remote-tracking branch 'upstream/2.4' into guides. [Steve
  Clement]
- Merge pull request #6916 from JakubOnderka/feed-sort. [Jakub Onderka]

  fix: [UI] Allow to sort feeds by name


v2.4.137 (2021-01-21)
---------------------

New
~~~
- [UI] Show event count in server popover for comparison. [Jakub
  Onderka]
- [object add] make add event / edit event breakOnDuplicate aware.
  [iglocska]

  - cull objects that would be duplicates
  - cache the fetching of existing objects to speed up the query

  - thanks to @github-germ for the suggested fixes to the duplicate checking to accomodate this patch
- [API] update command got new branch parameter. [iglocska]

  - instruct the update process to be prepended by a checkout of a given branch
  - passed via a URL parameter (/servers/update/branch:develop)
  OR
  - passed via a JSON object ({"branch": "develop"})
- [server] Compare server events overlap. [Jakub Onderka]
- [internal] New ability to get JSON data from event preview. [Jakub
  Onderka]
- [doc] Added doc about how to change the installer generator. [Steve
  Clement]
- [taxonomy] Importing taxonomy in machinetag format by REST API. [Jakub
  Onderka]
- [UI] Show link to event preview for ID translator. [Jakub Onderka]
- [idTranslator] Allow check event on different servers from event view.
  [Jakub Onderka]
- [UI] Show sharing groups in org view. [Jakub Onderka]
- [sync] Enable compression for server sync. [Jakub Onderka]
- [feed] Support brotli compression. [Jakub Onderka]
- [correlation] added system to exclude certain values from the
  correlation engine. [iglocska]

  - simply add values at /exclude_correlations
  - new values coming in will not correlate if they trip over the values listed there
  - to remove existing correlations run the cleaner tool on the above endpoint

  - values can be 1:1 matches, or substring searches (denoted with a leading, ending, or both '%')
    - https://www.google.com/%  will match anything starting with https://www.google.com/
    - %google.com% will match anything that contains google.com
- [UI] Allow to sort orgs by number of orgs. [Jakub Onderka]
- [sighting] New setting that will allow users to see host org
  sightings. [Jakub Onderka]
- [UI] Show tag description if tag belongs to taxonomy. [Jakub Onderka]
- [internal] New model method find('column') [Jakub Onderka]
- [security] Check org list when accessing distribution graph. [Jakub
  Onderka]
- [security] Test for hide_organisations_in_sharing_groups setting.
  [Jakub Onderka]
- [security] Setting to hide orgs form sharing group view. [Jakub
  Onderka]
- [internal] Allow to output directly TmpFileTool. [Jakub Onderka]
- [UI] Show number of unique IPs for key usage. [Jakub Onderka]
- [UI] Show last key usage in index table. [Jakub Onderka]
- [UI] Show information about key expiration in server list. [Jakub
  Onderka]
- [security] Cancel API session right after auth key is deleted. [Jakub
  Onderka]
- [security] Put information about key expiration into response header.
  [Jakub Onderka]
- [security] Allow to set key validity. [Jakub Onderka]
- [security] New setting Security.username_in_response_header. [Jakub
  Onderka]
- [test] Check when `MISP.authkey_keep_session` is true. [Jakub Onderka]
- [internal] Show auth key usage in key view page. [Jakub Onderka]
- [internal] Allow to log authkey usage in Redis. [Jakub Onderka]
- [rest] Allow to search sightings by event or attribute UUID. [Jakub
  Onderka]
- [UI] Download GPG public key from GPG homedir. [Jakub Onderka]
- [type] favicon-mmh3 is the murmur3 hash of a favicon as used in
  Shodan. [Alexandre Dulaunoy]
- [Statistics shell] Added new statistics shell. [iglocska]

  - (R)etrieval (o)f (m)etrics (m)atrix (e)xtended (f)or (s)tatistics

  - run it via /var/www/MISP/app/Console/cake Statistics rommelfs

Changes
~~~~~~~
- [VERSION] bump. [iglocska]
- Bump PyMISP version. [Raphaël Vinot]
- [pgp] default pgp key server updated to openpgp.circl.lu. [Alexandre
  Dulaunoy]

  openpgp.circl.lu is the replacement keyserver of pgp.circl.lu
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [misp-objects] updated. [Alexandre Dulaunoy]
- Add authenticode support in generate_file_objects. [Raphaël Vinot]
- [PyMISP] Bump package (new lief). [Raphaël Vinot]
- [internal] Faster fetching galaxy clusters by REST API. [Jakub
  Onderka]
- [internal] Simplified code for index and event preview. [Jakub
  Onderka]
- [internal] Remove deprecated Set class calls. [Jakub Onderka]
- [internal] Optimise fetching tags for event index API requests. [Jakub
  Onderka]
- [internal] Optimise filter event index window. [Jakub Onderka]
- [UI] Simplified event ajax index template. [Jakub Onderka]
- [UI] Generate pagination just once. [Jakub Onderka]
- [internal] Fetch user email just when user is site admin. [Jakub
  Onderka]
- [internal] Optimise appending tags to events. [Jakub Onderka]
- [internal] Do not fetch unnecessary fields. [Jakub Onderka]
- [internal] Do not fetch full clusters for rest event index. [Jakub
  Onderka]
- [internal] Optimise fetching tags for rest client. [Jakub Onderka]
- [internal] Optimise fetching event index by API. [Jakub Onderka]
- [UI] Optimise fetching tags for picker. [Jakub Onderka]
- [misp-warninglists] updated. [Alexandre Dulaunoy]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- [installer] Updated installer. [Steve Clement]
- [doc] Considered $DBHOST. [Steve Clement]
- [UI] Optimise loading taxonomy tags for for tagging form. [Jakub
  Onderka]
- [sync] Simplified fetching version from remote server. [Jakub Onderka]
- [taxonomy] Faster fetching event and attribute counts for tag. [Jakub
  Onderka]
- [installer] Update to latest. [Steve Clement]
- [git] Made the checkouts more proxy friendly. [Steve Clement]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [taxonomies] updated. [Alexandre Dulaunoy]
- [idTranslator] Allow to use from GET request. [Jakub Onderka]
- [idTranslator] Check also servers that we push. [Jakub Onderka]
- [UI] Optimise generic picker. [Jakub Onderka]
- [UI] Faster paginator for index table. [Jakub Onderka]
- [UI] Faster event paginator. [Jakub Onderka]
- [internal] Remove unnecessary Attribute::defaultCategories array.
  [Jakub Onderka]
- [internal] Call array_values method just when necessary. [Jakub
  Onderka]
- [internal] Use strict comparison for in_array. [Jakub Onderka]
- [internal] Generate server settings just when need. [Jakub Onderka]
- [internal] Generate type definitions just when required. [Jakub
  Onderka]
- [UI] Deduplicate sightings form. [Jakub Onderka]
- [internal] Optimise sightings saving. [Jakub Onderka]
- [UI] Make server index view nicer. [Jakub Onderka]
- [sync] Optimise version compatibility checking to save sql queries.
  [Jakub Onderka]
- [sync] Return content encoding in postTest. [Jakub Onderka]
- [sync] Convert connection timeout to exception. [Jakub Onderka]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [PyMISP] updated to the latest version. [Alexandre Dulaunoy]
- [PyMISP] updated to the latest version. [Alexandre Dulaunoy]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- [optimisation] Faster Tag::fetchSimpleEventsForTag method. [Jakub
  Onderka]
- [optimisation] Faster fetching attributes with tags. [Jakub Onderka]
- [optimisation] Decode JSON input from request just once. [Jakub
  Onderka]
- [internal] Remove unused methods. [Jakub Onderka]
- [distribution-graph] Optimise loading. [Jakub Onderka]
- [internal] Use find('column') on more places. [Jakub Onderka]
- [internal] Do not load sightings for event log. [Jakub Onderka]
- [taxonomies] updated. [Alexandre Dulaunoy]
- [warning-lists] updated. [Alexandre Dulaunoy]
- [internal] Use find('column') on more places. [Jakub Onderka]
- [internal] Optimise loading event correlation graph. [Jakub Onderka]
- [UI] Use chosen when select contains more than 10 sharing groups.
  [Jakub Onderka]
- [role] Do not allow delete role when is still assigned to user. [Jakub
  Onderka]
- [UI] Show cancel button for event report filter. [Jakub Onderka]
- [UI] Merge roles index and admin_index. [Jakub Onderka]
- [UI] Rotate header for role index table. [Jakub Onderka]
- [UI] Site admin redirects from role index to admin index. [Jakub
  Onderka]
- [UI] Set dbclickAction for user index. [Jakub Onderka]
- [UI] Go directly to edit mode after clicking to "Edit report" button.
  [Jakub Onderka]
- [UI] Make event report page nicer. [Jakub Onderka]
- [sighting] Faster and memory efficient rest search. [Jakub Onderka]
- [log] Do not log request type logs to syslog. [Jakub Onderka]
- [REST] Close session early for `authkey_keep_session` connections.
  [Jakub Onderka]
- [test] Update testlive_security.py to new version. [Jakub Onderka]
- [internal] Code cleanup. [Jakub Onderka]
- [internal] Small optimisations. [Jakub Onderka]
- [interna] AppController code cleanup. [Jakub Onderka]
- [internal] Rename MISP.log_user_ips_auth ->
  MISP.log_user_ips_authkeys. [Jakub Onderka]
- [internal] Move access monitoring to own method. [Jakub Onderka]
- [internal] Force to update session data after database update. [Jakub
  Onderka]
- [internal] Allow to reuse session for API requests. [Jakub Onderka]
- [internal] Do not log full authkeys. [Jakub Onderka]
- [internal] Simplify User::describeAuthFields. [Jakub Onderka]
- [internal] Update role changes immediately. [Jakub Onderka]
- [internal] Do not fetch user settings for User::getAuthUser. [Jakub
  Onderka]
- [UI] Change description for user edit checkboxes. [Jakub Onderka]
- [internal] Load just necessary info when loading homepage info. [Jakub
  Onderka]
- [internal] Load user role info from session data. [Jakub Onderka]
- [internal] Move user checks to one place. [Jakub Onderka]
- [UI] Convert taxonomies to default view. [Jakub Onderka]
- [sync] When pushing event to remote server, request back just
  metadata. [Jakub Onderka]
- [eventReport] Load tags in one call. [Jakub Onderka]
- [shibb] Better log messages for ApacheShibbAuthenticate. [Jakub
  Onderka]
- [sighting] Optimise bulk sighting saving. [Jakub Onderka]
- [debug] cleanup. [iglocska]
- [misp-galaxy] updated. [Alexandre Dulaunoy]
- [misp-objects] updated. [Alexandre Dulaunoy]
- [taxonomies] updated. [Alexandre Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [PyMISP] updated. [Alexandre Dulaunoy]
- [PyMISP] updated. [Alexandre Dulaunoy]
- [PyMISP] updated to the latest version. [Alexandre Dulaunoy]
- [warning-list] updated to the latest version. [Alexandre Dulaunoy]
- [doc] From Travis to GH action. [Alexandre Dulaunoy]
- [veracode] removed. [Alexandre Dulaunoy]
- [installer] Latest update. [Steve Clement]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [installer] update to latest. [Steve Clement]
- [fix] typo. [Steve Clement]
- [doc] OpenBSD 6.8 update. [Steve Clement]
- [php] Added 2 missing modules. [Steve Clement]
- [doc] Added new default flags. [Steve Clement]

Fix
~~~
- [helper:genericPicker] Adding object from pill selector - Prevents
  double encoding of the passed data. [mokaddem]
- [login] Correctly convert old password hash to blowfish. [Jakub
  Onderka]
- [login] Convert old password hash to blowfish. [Jakub Onderka]
- [update] fixed due to issues introduced with the branch flag.
  [iglocska]
- [security] Reflective XSS in the RestClient. [mokaddem]
- [security] XSS in the user homepage favourite button. [iglocska]

  - navigating to a url in MISP with the URL containing a javascript payload would cause the execution of reflected xss
  - automatically sanitised by modern browsers, but still confirmed via raw curl fetches
- [security] XSS via galaxy cluster element values for reference types
  could contain javascript links. [iglocska]

  - ref type elements are automatically converted to links. A user would have to click a javascript: link for it to trigger, it's still too risky to keep as is
  - only urls starting with http:// and https:// are converted from here on

  - As reported by Patrik Kontura from ESET
- [security] Stored XSS in the galaxy cluster view. [iglocska]

  - Galaxy cluster names were vulnerable to XSS injection

  - As reported by Patrik Kontura of ESET
- [security] Require password confirmations by default. [iglocska]

  - the setting is optional, but the default should be that it's required unless disabled

  - As reported by Patrix Kontura from ESET
- [UI] Nicer first and last seen form. [Jakub Onderka]
- [log] Correctly handle limit and page params. [Jakub Onderka]
- [internal] Group for getting sightings for tag. [Jakub Onderka]
- [taxonomy] Support unicode chars in tag names. [Jakub Onderka]
- [S/MIME] don't sign e-mails if no signing key is set. [iglocska]

  - fixes e-mails not going out on instances where no signing key was provided
- [server] Handle case when checking CLI version is not possible. [Jakub
  Onderka]
- [object] the optional blocking of duplicates fixed for objects
  including malware samples. [iglocska]

  - also looping the attributes through the pre-validation massaging ensures that attributes modified by it are correctly compared
- [objects] breakonduplicate fixed. [iglocska]
- [sighting] Order must contain group for some mysql servers. [Jakub
  Onderka]
- [UI] Make event paginator universal. [Jakub Onderka]
- [UI] Remove nonsense paginator options. [Jakub Onderka]
- [UI] Chosen autofocus. [Jakub Onderka]
- [internal] Remove unused method isOwnedByOrg. [Jakub Onderka]
- [internal] Remove duplicate array definition. [Jakub Onderka]
- [rest] Allow to edit roaming mode of sharing group. [Jakub Onderka]
- [dbSchema] Update to v65. [Jakub Onderka]
- MIssing dependency. [Raphaël Vinot]
- Call the security test suite properly. [Raphaël Vinot]
- Remove call to python script out of the virtenv. [Raphaël Vinot]
- [S/MIME] don't sign e-mails if no signing key is set. [iglocska]

  - fixes e-mails not going out on instances where no signing key was provided
- [inernal] Remove duplicates from server correlations. [Jakub Onderka]
- [internal] Attaching warninglist for feed event preview without
  attributes. [Jakub Onderka]
- [UI] Multiple popovers for cluster relations. [Jakub Onderka]
- [UI] Change role name for admin view and add title. [Jakub Onderka]
- [UI] Redirect after add role modal to index page. [Jakub Onderka]
- [UI] Cancelling search didn't work for index table. [Jakub Onderka]
- [UI] Add Object works again for all databases. [Jakub Onderka]
- [UI] Remove unnecessary padding from form. [Jakub Onderka]
- [UI] Correctly show contributors in event view. [Jakub Onderka]
- [UI] Fix attribte search in event view. [Jakub Onderka]
- [UI] Show error message when galaxy info couldn't be loaded. [Jakub
  Onderka]
- [sighting] Grouping sighting fetch for tags. [Jakub Onderka]
- [sighting] Order must contain group for some mysql servers. [Jakub
  Onderka]
- [UI] Move debug mode variable before setting database connection.
  [Jakub Onderka]
- [monitoring] Do not encode payload, it is string. [Jakub Onderka]
- [UI] Enable quick filter for auth keys. [Jakub Onderka]
- [UI] Auth Key index and view changes and fixes. [Jakub Onderka]
- [UI] Days to expire count. [Jakub Onderka]
- [security] Do not return hashed authentication key after creation.
  [Jakub Onderka]
- [internal] Check if setting value is scalar. [Jakub Onderka]
- [security] Auth key must be always random generated at server side.
  [Jakub Onderka]
- [security] Do not allow to use API key authenticated session to do non
  API calls. [Jakub Onderka]
- [internal] Remove unused variables. [Jakub Onderka]
- [internal] Remove unused $user siteadmin variable. [Jakub Onderka]
- [UI] Use generic style for taxonomy view. [Jakub Onderka]
- [UI] Autofocus generic picker. [Jakub Onderka]
- [UI] Replace GnuPG with PGP. [Jakub Onderka]
- [UI] Empty field for galaxy 'Forked From' and 'Forked By' [Jakub
  Onderka]
- [UI] Use correct font for Show all. [Jakub Onderka]
- [UI] Send request just when opening event detail windows. [Jakub
  Onderka]
- [eventReport] Smarter extractWithReplacements. [Jakub Onderka]
- [eventReport] Replace defanged values. [Jakub Onderka]
- [eventReport] Notice when galaxy value is not separated by ` - `
  [Jakub Onderka]
- [stix2 import] Checking if attack-pattern, course-of-action and
  vulnerability names are known galaxies before importing them as MISP
  object. [chrisr3d]
- [tags] truncate tag names that are too long. [Andras Iklody]

  Otherwise we run into issues on the DB level anyway. For the future, perhaps change the field length.
- [installer] Typo. [Steve Clement]
- [search] don't append the same quicksearch value more than once in the
  URL. [iglocska]
- [statistics] Local org flag fixed to show the correct count.
  [iglocska]
- [mistake in a comment fixed] [iglocska]
- [internal] sharing_group graph missing org_ids - throwing notices.
  [iglocska]
- [internal] further promises removed from the galaxy model. [iglocska]

  - easier than getting people to stop using EOL software
- [installer] type in php-bcmath package. [Steve Clement]
- [installer] forgot to add sfv. [Steve Clement]
- [internal] removed function promises in crud component. [iglocska]

  - to appease EOL php versions...
- [delegation] invalid user call. [iglocska]

Other
~~~~~
- Merge pull request #6896 from JakubOnderka/fix-old-password-convert.
  [Jakub Onderka]

  fix: [login] Correctly convert old password hash to blowfish
- Merge branch 'old-hash-transfer' into 2.4. [Christophe Vandeplas]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch 'develop' into 2.4. [iglocska]
- Merge branch 'develop' into 2.4. [iglocska]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [Alexandre Dulaunoy]
- Merge pull request #6880 from JakubOnderka/server-compare-count.
  [Jakub Onderka]

  new: [UI] Show event count in server popover for comparison
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge remote-tracking branch 'origin/2.4' into develop. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge pull request #6879 from JakubOnderka/first-seen-input-format.
  [Jakub Onderka]

  fix: [UI] Nicer first and last seen form
- Merge pull request #6870 from JakubOnderka/galaxy-cluster-rest-search.
  [Jakub Onderka]

  chg: [internal] Faster fetching galaxy clusters by REST API
- Merge pull request #6860 from JakubOnderka/log-fix. [Jakub Onderka]

  fix: [log] Correctly handle limit and page params
- Merge pull request #6874 from JakubOnderka/preview-server. [Jakub
  Onderka]

  Preview server
- Merge pull request #6869 from JakubOnderka/event-index-tags. [Jakub
  Onderka]

  chg: [internal] Optimise fetching tags for event index API requests
- Merge pull request #6868 from JakubOnderka/event-index-rest-optim.
  [Jakub Onderka]

  Event index rest optim
- Merge pull request #6867 from JakubOnderka/event-index-rest-optim.
  [Jakub Onderka]

  chg: [internal] Optimise fetching event index by API
- Merge pull request #6866 from JakubOnderka/fix-bad-merge. [Jakub
  Onderka]

  fix: [internal] Group for getting sightings for tag
- Merge pull request #6863 from JakubOnderka/tag-fetching-optimisation.
  [Jakub Onderka]

  chg: [UI] Optimise fetching tags for picker
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge branch '2.4' into develop. [iglocska]
- Merge pull request #6865 from SteveClement/guides. [Andras Iklody]

  chg: [doc] Considered $DBHOST
- Merge pull request #6858 from SteveClement/guides. [Steve Clement]

  new: [doc] Added doc about how to change the installer generator
- Merge pull request #6862 from JakubOnderka/tag-chose-optimise. [Jakub
  Onderka]

  chg: [UI] Optimise loading taxonomy tags for for tagging form
- Merge pull request #6861 from JakubOnderka/taxonomy-unicode. [Jakub
  Onderka]

  fix: [taxonomy] Support unicode chars in tag names
- Merge branch '2.4' into develop. [Steve Clement]
- Merge pull request #6854 from JakubOnderka/server-pull-version. [Jakub
  Onderka]

  chg: [sync] Simplified fetching version from remote server
- Merge pull request #6851 from JakubOnderka/taxonomy-import. [Jakub
  Onderka]

  new: [taxonomy] Importing taxonomy in machinetag format by REST API
- Merge pull request #6853 from JakubOnderka/server-diagnostic-fix.
  [Jakub Onderka]

  fix: [server] Handle case when checking CLI version is not possible
- Merge branch '2.4' into develop. [iglocska]
- Merge pull request #6835 from MISP/dependabot/pip/lxml-4.6.2.
  [Alexandre Dulaunoy]

  build(deps): bump lxml from 4.3.3 to 4.6.2
- Build(deps): bump lxml from 4.3.3 to 4.6.2. [dependabot[bot]]

  Bumps [lxml](https://github.com/lxml/lxml) from 4.3.3 to 4.6.2.
  - [Release notes](https://github.com/lxml/lxml/releases)
  - [Changelog](https://github.com/lxml/lxml/blob/master/CHANGES.txt)
  - [Commits](https://github.com/lxml/lxml/compare/lxml-4.3.3...lxml-4.6.2)
- Merge pull request #6825 from StefanKelm/2.4. [Alexandre Dulaunoy]

  Update index.ctp
- Update index.ctp. [StefanKelm]

  Tinies of typos...
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #6826 from SteveClement/guides. [Steve Clement]

  chg: [git] Made the checkouts more proxy friendly
- Fix git urls to https (users behind proxy) [Alexandre Dulaunoy]

  Fix git urls to https (users behind proxy)
- Merge pull request #6849 from JakubOnderka/id-translator-preview-link.
  [Jakub Onderka]

  new: [UI] Show link to event preview for ID translator
- Merge pull request #6833 from JakubOnderka/id-translator-push. [Jakub
  Onderka]

  chg: [idTranslator] Check also servers that we push
- Merge pull request #6845 from JakubOnderka/generic-picker-
  optimisation. [Jakub Onderka]

  chg: [UI] Optimise generic picker
- Merge pull request #6841 from JakubOnderka/paginator-fix. [Jakub
  Onderka]

  Paginator fix
- Merge pull request #6843 from JakubOnderka/choosen-autofocus-fix.
  [Jakub Onderka]

  fix: [UI] Chosen autofocus
- Merge pull request #6842 from JakubOnderka/small-optims. [Jakub
  Onderka]

  Small optims
- Merge pull request #6840 from JakubOnderka/translate-optimisation.
  [Jakub Onderka]

  Translate optimisation
- Merge pull request #6839 from JakubOnderka/deduplicate-sighting-form.
  [Jakub Onderka]

  chg: [UI] Deduplicate sightings form
- Merge pull request #6809 from JakubOnderka/optimise-sightings-saving.
  [Jakub Onderka]

  chg: [internal] Optimise sightings saving
- Merge pull request #6827 from JakubOnderka/sharing_groups_org. [Jakub
  Onderka]

  new: [UI] Show sharing groups in org view
- Merge pull request #6830 from JakubOnderka/sg-roaming-edit. [Jakub
  Onderka]

  fix: [rest] Allow to edit roaming mode of sharing group
- Merge pull request #6837 from JakubOnderka/db-schema. [Jakub Onderka]

  fix: [dbSchema] Update to v65
- Merge pull request #6831 from JakubOnderka/server-view-ui. [Jakub
  Onderka]

  chg: [UI] Make server index view nicer
- Merge pull request #6828 from JakubOnderka/check-version-
  compatibility-optim. [Jakub Onderka]

  chg: [sync] Optimise version compatibility checking to save sql queries
- Merge pull request #6822 from JakubOnderka/server-sync-compression.
  [Jakub Onderka]

  new: [sync] Enable compression for server sync
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge pull request #6821 from JakubOnderka/http-socket-brotli. [Jakub
  Onderka]

  new: [feed] Support brotli compression
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge pull request #6820 from MISP/Rafiot-patch-6. [Raphaël Vinot]

  [Test] Run the security suite from the virtualenv
- [Test] Run the security suite from the virtualenv. [Raphaël Vinot]
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [Alexandre Dulaunoy]
- Merge branch '2.4' of github.com:MISP/MISP into develop. [Alexandre
  Dulaunoy]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge branch 'develop' of https://github.com/MISP/MISP into develop.
  [chrisr3d]
- Merge pull request #6813 from JakubOnderka/feed-cache-deduplicate.
  [Jakub Onderka]

  fix: [inernal] Remove duplicates from server correlations
- Merge pull request #6812 from JakubOnderka/feed-warninglist. [Jakub
  Onderka]

  fix: [internal] Attaching warninglist for feed event preview without …
- Merge pull request #6811 from JakubOnderka/attach-tags-to-attributes.
  [Jakub Onderka]

  Attach tags to attributes
- Merge pull request #6810 from JakubOnderka/json-decode-just-once.
  [Jakub Onderka]

  chg: [optimisation] Decode JSON input from request just once
- Merge pull request #6804 from JakubOnderka/optimisations-vol2. [Jakub
  Onderka]

  Optimisations vol2
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [Alexandre Dulaunoy]
- Merge pull request #6797 from JakubOnderka/optimisations. [Jakub
  Onderka]

  Optimisations
- Merge pull request #6745 from JakubOnderka/user-sort. [Jakub Onderka]

  User sort
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [Alexandre Dulaunoy]
- Merge pull request #6772 from JakubOnderka/sighting-policy-host-org.
  [Jakub Onderka]

  new: [sighting] New setting that will allow users to see host org sig…
- Merge pull request #6778 from JakubOnderka/tag-info. [Jakub Onderka]

  Tag info popover
- Merge pull request #6749 from JakubOnderka/hide-orgs-from-sg. [Jakub
  Onderka]

  Hide orgs from sharing group view
- Merge pull request #6788 from JakubOnderka/ui-fixes. [Jakub Onderka]

  UI fixes
- Merge pull request #6789 from JakubOnderka/sighting-tag-group. [Jakub
  Onderka]

  Sighting tag group
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [Alexandre Dulaunoy]
- Merge pull request #6497 from JakubOnderka/experimental-cake-tmp-
  response. [Jakub Onderka]
- Merge pull request #6787 from JakubOnderka/sighting-rest-optim. [Jakub
  Onderka]

  chg: [sighting] Faster and memory efficient rest search
- Merge pull request #6786 from JakubOnderka/sighting-bug-6773. [Jakub
  Onderka]

  fix: [sighting] Order must contain group for some mysql servers
- Merge pull request #6581 from JakubOnderka/newsread-loading. [Jakub
  Onderka]

  chg: [internal] Move user checks to one place
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge branch '2.4' into develop. [Alexandre Dulaunoy]
- Merge branch '2.4' into develop. [Steve Clement]
- Merge pull request #6782 from JakubOnderka/taxonomies-view. [Jakub
  Onderka]

  chg: [UI] Convert taxonomies to default view
- Merge pull request #6760 from JakubOnderka/sighting-rest-uuid. [Jakub
  Onderka]

  new: [rest] Allow to search sightings by event or attribute UUID
- Merge pull request #6781 from JakubOnderka/another-ui-fixes. [Jakub
  Onderka]

  Another UI fixes
- Merge pull request #6776 from JakubOnderka/event-push-metadata. [Jakub
  Onderka]

  chg: [sync] When pushing event to remote server, request back just me…
- Merge pull request #6779 from JakubOnderka/event-report-extract-fix.
  [Jakub Onderka]

  Event report extract fix
- Merge pull request #6755 from JakubOnderka/shibb-log-messages. [Jakub
  Onderka]

  chg: [shibb] Better log messages for ApacheShibbAuthenticate
- Merge pull request #6759 from JakubOnderka/bulk-sighting-saving-optim.
  [Jakub Onderka]

  chg: [sighting] Optimise bulk sighting saving
- Merge pull request #5234 from JakubOnderka/gpg_key_footer. [Jakub
  Onderka]

  new: [UI] Download GPG public key from GPG homedir
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #6747 from legoguy1000/ja3_zeek_intel_rules.
  [Alexandre Dulaunoy]

  Create JA3 Hash Zeek Intel Rules
- JA3 Zeek Intel Rules. [Alex Resnick]
- Merge pull request #6799 from simonflood/patch-1. [Alexandre Dulaunoy]

  INSTALL.rhel8.md - update EoL for CentOS 8
- INSTALL.rhel8.md - update EoL for CentOS 8. [Simon Flood]

  Maintenance for CentOS 8 will now end on 31 December 2021
- Merge pull request #6795 from sdenel/patch-2. [Alexandre Dulaunoy]

  Typo in Server.php: currenty -> currently
- Typo in Server.php. [Simon DENEL]
- Veracode added. [Alexandre Dulaunoy]
- CodeQL added. [Alexandre Dulaunoy]
- HandlerSSL should be true. [Alexandre Dulaunoy]
- Merge pull request #6785 from StefanKelm/2.4. [Alexandre Dulaunoy]

  Typos
- Update indexForEvent.ctp. [StefanKelm]
- Update importReportFromUrl.ctp. [StefanKelm]
- Merge pull request #6783 from FafnerKeyZee/patch-1. [Alexandre
  Dulaunoy]

  Add the possibility to have a '-' in the baseurl
- Add the possibility to have a '-' in the baseurl. [Fafner [_KeyZee_]]

  With the actual regex in testBaseURL, we can not have a '-' inside the BaseURL, I did a quick fix
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #6767 from SteveClement/guides. [Steve Clement]
- Merge pull request #6764 from Natsec/patch-1. [Andras Iklody]

  Typo caused fail of dependency installation
- Typo caused fail of dependency installation. [Kamil]

  Hello,

  During installation, I would get the following error :
  ```shell
  Cloning into '/var/www/MISP/app/files/scripts/python-cybox'...
  remote: Enumerating objects: 343, done.
  remote: Counting objects: 100% (343/343), done.
  remote: Compressing objects: 100% (191/191), done.
  remote: Total 14731 (delta 180), reused 253 (delta 152), pack-reused 14388
  Receiving objects: 100% (14731/14731), 7.39 MiB | 3.10 MiB/s, done.
  Resolving deltas: 100% (10487/10487), done.
  ERROR: Invalid requirement: '/var/www/MISP/app/files/scripts/CybOXProject/python-cybox'
  Hint: It looks like a path. File '/var/www/MISP/app/files/scripts/CybOXProject/python-cybox' does not exist.
  apt is maybe locked, waiting 3 seconds.
  Cloning into '/var/www/MISP/app/files/scripts/python-stix'...
  remote: Enumerating objects: 298, done.
  remote: Counting objects: 100% (298/298), done.
  remote: Compressing objects: 100% (215/215), done.
  remote: Total 13777 (delta 190), reused 155 (delta 83), pack-reused 13479
  Receiving objects: 100% (13777/13777), 5.78 MiB | 2.58 MiB/s, done.
  Resolving deltas: 100% (10076/10076), done.
  ERROR: Invalid requirement: '/var/www/MISP/app/files/scripts/STIXProject/python-stix'
  Hint: It looks like a path. File '/var/www/MISP/app/files/scripts/STIXProject/python-stix' does not exist.
  apt is maybe locked, waiting 3 seconds.
  Cloning into '/var/www/MISP/app/files/scripts/python-maec'...
  remote: Enumerating objects: 59, done.
  remote: Counting objects: 100% (59/59), done.
  remote: Compressing objects: 100% (39/39), done.
  remote: Total 4472 (delta 32), reused 40 (delta 20), pack-reused 4413
  Receiving objects: 100% (4472/4472), 1.29 MiB | 1.90 MiB/s, done.
  Resolving deltas: 100% (2992/2992), done.
  ERROR: Invalid requirement: '/var/www/MISP/app/files/scripts/MAECProject/python-maec'
  Hint: It looks like a path. File '/var/www/MISP/app/files/scripts/MAECProject/python-maec' does not exist.
  apt is maybe locked, waiting 3 seconds.
  Cloning into '/var/www/MISP/app/files/scripts/mixbox'...
  remote: Enumerating objects: 39, done.
  remote: Counting objects: 100% (39/39), done.
  remote: Compressing objects: 100% (26/26), done.
  remote: Total 1055 (delta 20), reused 27 (delta 13), pack-reused 1016
  Receiving objects: 100% (1055/1055), 278.98 KiB | 901.00 KiB/s, done.
  Resolving deltas: 100% (696/696), done.
  ERROR: Invalid requirement: '/var/www/MISP/app/files/scripts/CybOXProject/mixbox'
  Hint: It looks like a path. File '/var/www/MISP/app/files/scripts/CybOXProject/mixbox' does not exist.
  ```

  Making the modification fixed the installation of the dependencies.

  Best regards,
  Kamil


v2.4.136 (2020-12-16)
---------------------

New
~~~
- [CLI] Import events with compressed file support. [Jakub Onderka]

  Useful for importing big files
- [UI] Find org images also by uuid and support SVG images. [Jakub
  Onderka]
- [UI] Make possible to filter users by active/disabled. [Jakub Onderka]
- [UI] Show number of events for sharing group. [Jakub Onderka]
- [test] View org page. [Jakub Onderka]
- [UI] Allow to search in sharing group list. [Jakub Onderka]
- [security] Test if user can see sharing groups. [Jakub Onderka]
- [factories] generic confirmation UI factory added. [iglocska]
- [Cerebrates] added Cerebrate sync functionality. [iglocska]

  - add/modify cerebrate links
  - preview cerebrate instanes for organisations
  - fetch organisations from cerebrate
    - ingests new organisations and updates existing ones

  - More to come in the future
- [Cerebrate] db update added. [iglocska]
- [view factories rework] [iglocska]

  indextable:
    - org lookup field cleaned up and made more resilient
    - remote status: status field for checking of the local vs remote state of objects added
    - pagination system updated to allow for ajax pagination
    - random named container added for the index table's scaffolding

  side menu:
    - added cerebrate options

  side panels:
    - new factory type added for side panel elements (for the usual 2:1 split views)
    - added logo element

  single views:
    - child reworked to use the accordion element
    - added side panel support
- [auth] Allow to enforce auth plugin authentication. [Jakub Onderka]
- [shibb] Test for organisation UUID HTTP header. [Jakub Onderka]
- [shibb] Allow to get organisation UUID from HTTP headers. [Jakub
  Onderka]
- [test] Test for ApacheShibbAuth. [Jakub Onderka]
- [test] Security test suite. [Jakub Onderka]
- [security] New setting to check `Sec-Fetch-Site` header. [Jakub
  Onderka]
- [security] Add new `Security.disable_browser_cache` option to disable
  saving data to browser cache. [Jakub Onderka]

Changes
~~~~~~~
- [version] bump. [iglocska]
- [UI] Nicer galaxy cluster view. [Jakub Onderka]
- [UI] Nicer icon for discussion reply. [Jakub Onderka]
- [UI] Move org UUID after ID to match other page style. [Jakub Onderka]
- [UI] Add cancel for sharing group search. [Jakub Onderka]
- [UI] Nicer title when creating event report. [Jakub Onderka]
- [security] For `hide_organisation_index_from_users` hide orgs that
  make contribution that user cannot see. [Jakub Onderka]
- [composer] Add ext-rdkafka as suggested dependency. [Jakub Onderka]
- [UI] Use PGP instead of GnuGP, GnuPG is implementation. [Jakub
  Onderka]
- [UI] Hide some fields from user profile and use better description.
  [Jakub Onderka]
- [internal] HEAD check if org exists. [Jakub Onderka]
- [internal] Simplified SharingGroup::checkIfOwner method. [Jakub
  Onderka]
- [internal] Load orgs just when it is necessary. [Jakub Onderka]
- [UI] Use standardised view for sharging group. [Jakub Onderka]
- [composer] Raise minimal PHP version to 7.2 and disable support for
  8.0. [Jakub Onderka]
- [shibb] Newly created org should be local. [Jakub Onderka]
- [galaxyClusters:view_relation_tree] Adjust height based on the number
  of nodes. [mokaddem]
- [actions] added develop branch. [iglocska]
- [ACL] cerebrate added to the ACL. [iglocska]
- [querystring] bump. [iglocska]
- [image] added cerebrate logo. [iglocska]
- [js] runIndexQuickFilter changes. [iglocska]

  - added optional url parameter to set a fixed URL to search from
  - added target parameter for ajax refreshes (target css selector)
  - added possibility to pass ordered parameters in addition to key value pairs
  - added ajax lookups
- [Cerebrate] added to the global menu. [iglocska]
- [synctool] added custom model support for the setuphttpsocket()
  function. [iglocska]
- [CRUD component] call model functions in the afterfind. [iglocska]

  - added the option to either use anonymous functions or call model functions in the hook
  - fixed a bug with a missing modelname in the lookup scope for fields (carryover from cerebrate)
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- [installer] Update to latest version. [Steve Clement]
- [installer] Leveled installer out. [Steve Clement]
- [installer] Update to latest. [Steve Clement]
- [installer] More fixes to replayability. [Steve Clement]
- [actions] added to the develop branch. [iglocska]
- [UI] Normalize date format to match rest of MISP. [Jakub Onderka]
- [installer] Update to latest. [Steve Clement]
- [installer] misp-modules install refactor. [Steve Clement]
- [installer] Refactor the core MISP checkout. [Steve Clement]
- [installer] Update to latest. [Steve Clement]
- [fmt] Make it look better. [Steve Clement]
- [sighting] Support for postgres. [Jakub Onderka]
- [tag] Simplified taxonomy handling. [Jakub Onderka]
- [tag] Fetch event count for tags in one query. [Jakub Onderka]
- [sighting] Speedup loading sighting for tags and galaxies. [Jakub
  Onderka]
- [sighting] Speedups list all sightings. [Jakub Onderka]
- [sighting] Reworked listing sightings. [Jakub Onderka]
- [sighting] Sighting statistics. [Jakub Onderka]
- [installer] Deploy latest. [Steve Clement]
- [doc] The installer takes certain env_vars into account. [Steve
  Clement]
- [installer] Deploy latest installer with automation fixes. [Steve
  Clement]
- [installer] Removed expect, this will ease automation. [Steve Clement]
- [internal] Fetch just necessary orgs and server object for sharing
  groups. [Jakub Onderka]
- [misp-galaxy] MITRE ATT&CK updated. [Alexandre Dulaunoy]
- [vhash] removed validation altogether. [Andras Iklody]

  - vhash is like a box of chocolates, you never know what you're going to get.
- [internal] Better exception description for PGP key validation. [Jakub
  Onderka]
- [PyMISP] Bump version, again. [Raphaël Vinot]
- [PyMISP] Bump version. [Raphaël Vinot]
- [internal] Attach event correlations in one call for attribute UI
  search. [Jakub Onderka]
- [internal] Attach feed correlations in one call for attribute UI
  search. [Jakub Onderka]
- [internal] Optimise attribute search in UI. [Jakub Onderka]
- [internal] removed void return promise. [iglocska]

  - to make EOL php versions happy
- [events:view] Possibility to fetch events without attachments via the
  API. [mokaddem]
- [galaxyCluster:relationsTreeTool] Ignore duplicated cluster UUIDs.
  [mokaddem]

  - Some default clusters have the same UUID. They are the same entity but
  stored in a different cluster package. It should be addressed in the
  future

Fix
~~~
- [UI] Contact form text. [Jakub Onderka]
- [distribution graph] Graph doesn't work for non sync users when event
  is shared to sharing group. [Jakub Onderka]
- [UI] Show correct sync org for sharing group view. [Jakub Onderka]
- [UI] Change order for sg view. [Jakub Onderka]
- [UI] Do not show authkey if advanced authkeys are enabled. [Jakub
  Onderka]
- [UI] For accorddion external link do not propagate click. [Jakub
  Onderka]
- [UI] Send email link should be visible just for admin view. [Jakub
  Onderka]
- [UI] User search keeps filter. [Jakub Onderka]
- [UI] Show correct menu for EventsController::importModule action.
  [Jakub Onderka]
- [UI] For import show correct active menu. [Jakub Onderka]
- [UI] For tags show actions just when user can permission to use them.
  [Jakub Onderka]
- [UI] For Taxonomies show actions just when user can permission to use
  them. [Jakub Onderka]
- [UI] Show correct menu for Contact Reporter page. [Jakub Onderka]
- [UI] Remove unused All button from galaxy index. [Jakub Onderka]
- [UI] Show feed cache buttons just to site admins. [Jakub Onderka]
- [UI] For fail when uploading stix, show unit for maximum size. [Jakub
  Onderka]
- [UI] Button border when adding thread port. [Jakub Onderka]
- [UI] Show REST client menu item just when user has perm_auth. [Jakub
  Onderka]
- [internal] Undefined variable $passedArgs. [Jakub Onderka]
- [internal] Undefined variables when GitHub is not reachable. [Jakub
  Onderka]
- [internal] Undefined variable me. [Jakub Onderka]
- [UI] Better error message for permission denied. [Jakub Onderka]
- [security] Do not leak org names when
  hide_organisation_index_from_users enabled. [Jakub Onderka]
- [UI] Nicer error message for CSRF. [Jakub Onderka]
- [internal] User should be able to see his org. [Jakub Onderka]
- [UI] Toggle doesn't work with absolute URLs. [Jakub Onderka]
- [UI] Confusing messages after object template is deleted. [Jakub
  Onderka]
- [UI] Do not mention that STIX 2 export require library. [Jakub
  Onderka]

  This information can be useful just for site administrators, but not for users
- [UI] Do not show REST client menu link when user don't have
  permission. [Jakub Onderka]
- [UI] Do not show taxonomy delete menu link when user don't have
  permission. [Jakub Onderka]
- [UI] Do not show proposals menu link when user don't have permission.
  [Jakub Onderka]
- [UI] Do not show extend this event button when user don't have
  permission to do that. [Jakub Onderka]
- [UI] Allow to access delegations index just when delegations are
  enabled. [Jakub Onderka]
- [UI] Show `Add Cluster` in menu just when user has permission to add
  cluster. [Jakub Onderka]
- [sighting] Make sure that correct columns are processed. [Jakub
  Onderka]
- [rest-client] Do not raise exception for not site admin. [Jakub
  Onderka]
- [UI] Link to role edit. [Jakub Onderka]
- [UI] Show delete and edit button for SG just when user has permission.
  [Jakub Onderka]
- [UI] Sort countries by name. [Jakub Onderka]
- [db_schema] added cerebrate. [iglocska]
- [baseurl] validation relaxed. [iglocska]

  - no more arbitrary junk blocking https://localhost
- [communities] search fixed, context no longer defaults to "pending"
  which is an unknown value. [iglocska]
- [authkey] fixed a bug causing recurring authkey lookups via model
  binding failing. [iglocska]

  - missing parameter caused the linking to be single use
- [community] removed invalid filter field causing notice errors.
  [iglocska]
- [custompagination tool] hardcoded modelname fixed. [iglocska]
- [doc] Location typo fixed. [Alexandre Dulaunoy]
- [pgp] Key info for older GPG versions. [Jakub Onderka]
- [security] XSS in authkey comment field. [Jakub Onderka]
- [sightings] Support mysql in sql_mode=only_full_group_by. [Jakub
  Onderka]
- [security] Remove hashed advanced keys from response. [Jakub Onderka]
- [bindmodel] added reset = false to the linking of users to authkeys.
  [Andras Iklody]

  - added reset = false in parameters (otherwise consecutive calls to the user model will not include the relation)
- [UI] Correctly handle truncated values for import. [Jakub Onderka]
- [UI] Favourite only for tags. [Jakub Onderka]
- [installer] fi was forgotten, #hotfix. [Steve Clement]
- [installer] sfv file was forgotten. [Steve Clement]
- [internal] Remove unused method from AppController. [Jakub Onderka]
- [csvExport] Prevent override when using `includeContext` parameter Fix
  #3774. [mokaddem]
- [internal] Redis unlink method for old Redis versions. [Jakub Onderka]
- [text export] cull duplicates after fetching the data. [iglocska]

  - pros: No more full group by exceptions
          Handles duplicate culling across internally paginated workloads

  - cons: The returned dataset's size will not always match the requested count as duplicates are culled
- [authkey] only link the model if the instance is already updated.
  [iglocska]
- [UI] user add. [iglocska]

  S/MIME label misaligned

Other
~~~~~
- Merge branch 'develop' into 2.4. [iglocska]
- Merge pull request #6754 from JakubOnderka/fix-contact-ui. [Jakub
  Onderka]

  fix: [UI] Contact form text
- Merge pull request #6752 from JakubOnderka/distribution_graph_sg_fix.
  [Jakub Onderka]

  fix: [distribution graph] Graph doesn't work for non sync users
- Merge pull request #6698 from JakubOnderka/small-ui-fixes. [Jakub
  Onderka]

  Small UI fixes
- Merge pull request #6716 from JakubOnderka/cli-import. [Jakub Onderka]

  new: [CLI] Import events with compressed file support
- Merge pull request #6730 from JakubOnderka/org-image-svg-uuid. [Jakub
  Onderka]

  new: [UI] Find org images also by uuid and support SVG images
- Merge pull request #6746 from JakubOnderka/rest-client-menu-
  permission. [Jakub Onderka]

  Rest client menu permission
- Merge pull request #6743 from JakubOnderka/undefined-me. [Jakub
  Onderka]

  fix: [internal] Undefined variables
- Merge pull request #6744 from JakubOnderka/user-filter. [Jakub
  Onderka]

  new: [UI] Make possible to filter users by active/disabled
- Merge pull request #6739 from JakubOnderka/error-message. [Jakub
  Onderka]

  fix: [UI] Better error message for permission denied
- Merge pull request #6738 from JakubOnderka/hide-orgs-dont-leak. [Jakub
  Onderka]

  fix: [security] Do not leak org names
- Merge pull request #6735 from JakubOnderka/error-message. [Jakub
  Onderka]

  fix: [UI] Nicer error message for CSRF
- Merge pull request #6732 from JakubOnderka/hide-orgs-show-his-org.
  [Jakub Onderka]

  fix: [internal] User should be able to see his org
- Merge pull request #6727 from JakubOnderka/fix-toggle-url. [Jakub
  Onderka]

  fix: [UI] Toggle doesn't work with absolute URLs
- Merge pull request #6721 from JakubOnderka/org-can-see. [Jakub
  Onderka]

  chg: [security] For `hide_organisation_index_from_users` hide more orgs
- Merge pull request #6725 from JakubOnderka/object-delete-ui. [Jakub
  Onderka]

  fix: [UI] Confusing messages after object template is deleted
- Merge pull request #6724 from JakubOnderka/kafka-suggested-ext. [Jakub
  Onderka]

  Kafka suggested ext
- Merge pull request #6707 from JakubOnderka/event-export-library-
  mention. [Jakub Onderka]

  fix: [UI] Do not mention that STIX 2 export require library
- Merge pull request #6720 from JakubOnderka/permission-ui. [Jakub
  Onderka]

  Permission UI
- Merge pull request #6719 from JakubOnderka/delegation-access. [Jakub
  Onderka]

  fix: [UI] Allow to access delegations index just when delegations are enabled
- Merge pull request #6717 from JakubOnderka/sharing-group-events.
  [Jakub Onderka]

  new: [UI] Show number of events for sharing group
- Merge pull request #6696 from JakubOnderka/user-profile-ui. [Jakub
  Onderka]

  chg: [UI] Hide some fields from user profile and use better description
- Merge pull request #6695 from JakubOnderka/add-cluster-menu-view.
  [Jakub Onderka]

  fix: [UI] Show `Add Cluster` in menu just when user has permission to…
- Merge branch 'develop' into add-cluster-menu-view. [Jakub Onderka]
- Merge pull request #6676 from JakubOnderka/fix-sighting-columns.
  [Jakub Onderka]

  fix: [sighting] Make sure that correct columns are processed
- Merge pull request #6694 from JakubOnderka/invalid-controller-name-
  fix. [Jakub Onderka]

  fix: [rest-client] Do not raise exception for non site admin
- Merge pull request #6706 from JakubOnderka/role-edit-fix. [Jakub
  Onderka]

  fix: [UI] Link to role edit
- Merge pull request #6699 from folbricht-stripe/s3-fix-writable-check.
  [Jakub Onderka]

  fix: Don't fail writable attachment dir test for S3
- Don't fail writable attachment dir test for S3. [Frank Olbricht]
- Merge pull request #6703 from JakubOnderka/org-view. [Jakub Onderka]

  new: [test] View org page
- Merge pull request #6700 from JakubOnderka/sg-view. [Jakub Onderka]

  Sharing group view
- Merge pull request #6701 from JakubOnderka/security-sg-view. [Jakub
  Onderka]

  new: [security] Test if user can see sharing groups
- Merge pull request #6662 from JakubOnderka/php-test. [Jakub Onderka]

  Disable PHP 8 support
- Merge pull request #6693 from JakubOnderka/countries-order. [Jakub
  Onderka]

  fix: [UI] Sort countries by name
- Merge pull request #6691 from JakubOnderka/shibb-new-org-local. [Jakub
  Onderka]

  chg: [shibb] Newly created org should be local
- Merge branch 'develop' of github.com:MISP/MISP into develop.
  [iglocska]
- Merge branch '2.4' into develop. [iglocska]
- Merge branch '2.4' into cerebrate. [iglocska]
- Merge pull request #6733 from legoguy1000/#6355-Suricata-JA3-Rules.
  [Alexandre Dulaunoy]

  Create JA3 Hash Suricata Rules
- #6355 Create JA3 Hash Suricata Rules. [Alex Resnick]
- Merge pull request #6697 from JakubOnderka/gpg-key-import-fix. [Jakub
  Onderka]

  fix: [pgp] Key info for older GPG versions
- Merge pull request #6690 from JakubOnderka/xss-authkey-fix. [Jakub
  Onderka]

  fix: [security] XSS in authkey comment field
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #6675 from SteveClement/guides. [Steve Clement]

  chg: [installer] Leveled installer out
- Merge pull request #6674 from SteveClement/guides. [Steve Clement]

  chg: [installer] More fixes to replayability.
- Merge pull request #6673 from JakubOnderka/news-date-format-change.
  [Jakub Onderka]

  chg: [UI] Normalize date format to match rest of MISP
- Merge pull request #6672 from JakubOnderka/fix-full-group. [Jakub
  Onderka]

  fix: [sightings] Support mysql in sql_mode=only_full_group_by
- Merge pull request #6656 from JakubOnderka/auth-plugin-enforce. [Jakub
  Onderka]

  new: [auth] Allow to enforce auth plugin authentication
- Merge pull request #6669 from StefanKelm/2.4. [Andras Iklody]

  Update event-timeline.js
- Update event-timeline.js. [StefanKelm]

  Few typos...
- Merge pull request #6668 from SteveClement/guides. [Steve Clement]
- Merge pull request #6665 from JakubOnderka/remove-hashed-keys. [Jakub
  Onderka]

  fix: [security] Remove hashed advanced keys from response
- Merge pull request #6664 from SteveClement/guides. [Steve Clement]

  chg: [fmt] Make it look better
- Merge pull request #6663 from JakubOnderka/fix-import-truncated-
  values. [Jakub Onderka]

  fix: [UI] Correctly handle truncated values for import
- Merge pull request #6578 from JakubOnderka/sighting-statistics. [Jakub
  Onderka]
- Merge pull request #6660 from SteveClement/guides. [Steve Clement]

  chg: [doc] The installer takes certain env_vars into account
- Merge pull request #6658 from SteveClement/guides. [Steve Clement]

  chg: [installer] Removed expect, this will ease automation.
- Merge pull request #6657 from JakubOnderka/app-controller-cleanup.
  [Jakub Onderka]

  fix: [internal] Remove unused method from AppController
- Merge pull request #6633 from JakubOnderka/sg-fetching-optim. [Jakub
  Onderka]

  chg: [internal] Fetch just necessary orgs and server object for sg
- Merge pull request #6624 from JakubOnderka/shibb-org-uuid. [Jakub
  Onderka]

  new: [shibb] Allow to get organisation UUID from HTTP headers
- Merge pull request #6613 from JakubOnderka/security-tests. [Jakub
  Onderka]

  new: [test] Security test suite
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #6081 from
  JakubOnderka/security_disable_browser_cache. [Jakub Onderka]

  new: [security] HTTP headers hardening
- Merge pull request #6646 from JakubOnderka/gpg-key-validation. [Jakub
  Onderka]

  chg: [internal] Better exception description for PGP key validation
- Merge pull request #6644 from JakubOnderka/fix-redis-unlink. [Jakub
  Onderka]

  fix: [internal] Redis unlink method for old Redis versions
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #6634 from JakubOnderka/attribute-search-
  optimisation. [Jakub Onderka]

  chg: [internal] Optimise attribute search in UI


v2.4.135 (2020-11-24)
---------------------

New
~~~
- [datamodels] added jarm-fingerprint type. [Kory Kyzar]
- [galaxyCluster:index] Added badge showing number of custom clusters.
  [mokaddem]
- [UI] Allow to sort attributes or objects by first and last seen.
  [Jakub Onderka]
- [diagnostic] Check extensions version. [Jakub Onderka]
- [internal] JSON stream convert. [Jakub Onderka]
- [eventReport] Report from event. [mokaddem]
- Github action. [Raphaël Vinot]
- [diagnostic] Show installed GnuPG version. [Jakub Onderka]
- [user] Setting `disable_user_add` to disable user creation by org
  admins. [Jakub Onderka]
- [user] Disabling password and login changes apply also for org admins.
  [Jakub Onderka]
- [UI] Add `disable_user_password_change` and
  `disable_user_login_change` setting. [Jakub Onderka]
- [user] Allow to disable user login change. [Jakub Onderka]
- [user] Allow to disable user password change. [Jakub Onderka]
- [authkey] generate authkeys automatically when creating users.
  [iglocska]

  - when using the new authkey system
- [standardised delete] view factory added. [iglocska]
- [advanced authkey] system. [iglocska]
- [CRUD component] backport from Cerebrate. [iglocska]
- [genericForm] system backport from Cerebrate. [iglocska]
- [indextable] scaffolding added along with a list of improvements.
  [iglocska]
- [advanced authkey] API key copy to the new system added to
  diagnostics. [iglocska]
- [CRUD] component port from Cerebrate, initial version. [iglocska]
- [indextable] factories added. [iglocska]
- [js] submit form in place. [iglocska]

  - for popup forms, have the option to display the result directly in the popover
- [generic templates] added with a single view for now (delete)
  [iglocska]
- [Authkey] system added. [iglocska]
- [SingleView factories] added. [iglocska]
- [accordion] element added. [iglocska]
- [advanced authkeys] toggle added. [iglocska]
- [API] Fast check object or attribute existence by HEAD method. [Jakub
  Onderka]
- [events] endpoint `runTaxonomyExclusivityCheck` for event elements.
  [mokaddem]
- [rest] Allow to return just metadata after creating or editing event.
  [Jakub Onderka]
- [API] Allow event existence check by HEAD method. [Jakub Onderka]
- [GalaxyCluster] Added soft and hard deletion. [mokaddem]
- [clusterBlocklist] Added initial blocklist similar to the event one.
  [mokaddem]
- [galaxyCluster:publish] Upon publishing, push the cluster to remote
  servers. [mokaddem]
- [server:pull_relevant_cluster] Added new cluster pull technique.
  [mokaddem]

  It fetches remote clusters based on cluster tags known locally
- [galaxyCluster:restSearch] Possibility to search for clusters
  contained in an Event. [mokaddem]
- [tag] Added 2 new columns to fetch tags from galaxies faster.
  [mokaddem]
- [galaxyCluster] Added `published` flag to clusters. [mokaddem]
- [clusterRelations:view] Added endpoint for rest query only. [mokaddem]
- [server] Added `pull_galaxy_cluster` option in the server config.
  [mokaddem]
- [events:view] Added Cluster relationship network graph. [mokaddem]
- [clusterRelations:edit] Added endpoint. [mokaddem]
- [clusterRelation] Early work on Galaxy Cluster Relations. [mokaddem]
- [galaxyClusters:updateCluster] Added draft version to align a forked
  cluster's elements to his parent. [mokaddem]
- [galaxyClusters:add] Added UI to create/edit GalaxyClusterElements.
  [mokaddem]
- [galaxyCluster] Initial import of Galaxy2.0 codebase - WiP. [mokaddem]

Changes
~~~~~~~
- [version] bump. [iglocska]
- [PyMISP] Bump version. [Raphaël Vinot]
- [PyMISP] updated to the latest version. [Alexandre Dulaunoy]
- [attribute] new process-state type. [Alexandre Dulaunoy]
- Add optional dep (email) [Raphaël Vinot]
- Add optional dep (email) [Raphaël Vinot]
- [PyMISP] updated for jarm-fingerprint type. [Alexandre Dulaunoy]
- [PyMISP] Bump. [Raphaël Vinot]
- [installer] Update to latest version. [Steve Clement]
- Improve actions. [Raphaël Vinot]
- [PyMISP] Bump version. [Raphaël Vinot]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [servers:schema_diagnostic] Added notice concerning benign deltas.
  [mokaddem]
- [installer] Updated installer. [Steve Clement]
- [internal] Faster updating JSON structures. [Jakub Onderka]
- [event:index] Allow passing list when filtering. [mokaddem]
- [galaxy update] improvements. [iglocska]

  - should be a fair bit faster
- [installer] even out changes from 20.04. [Steve Clement]
- [installer] Updated installer. [Steve Clement]
- [sh] If env vars exist, use that value. [Steve Clement]
- [doc] Added ignore file mode. [Steve Clement]
- [UI] Allow to set syslog setting from UI. [Jakub Onderka]
- [internal] Code style. [Jakub Onderka]
- [logging] Allow to define syslog identifier. [Jakub Onderka]
- [logging] Allow to disable syslog logging to stderr. [Jakub Onderka]
- [internal] Throw exception if setting name doesn't exists. [Jakub
  Onderka]
- [galaxyClusterRelations:index] Show edit button for users having the
  permission. [mokaddem]
- [galaxyCluster:view_relations] Moved custom relation option at the
  top. [mokaddem]
- [galaxyClusterRelations:add] Added picker for relation type.
  [mokaddem]
- [galaxyClusterBlocklist:add] Added picker for cluster. [mokaddem]
- [galaxyClusters] Sort by version then by value. [mokaddem]
- [UI] Change colors for auth key expiration field. [Jakub Onderka]
- [UI] Always use auth key with space in UI. [Jakub Onderka]
- [UI] Use quick click select for new generated authkey. [Jakub Onderka]
- [UI] Use monospace font for showing autkeys. [Jakub Onderka]
- [UI] Add information about key expiration to title. [Jakub Onderka]
- [feed] Optimise freetext feed caching. [Jakub Onderka]
- [galaxy] Do not fetch full galaxy info for event view UI. [Jakub
  Onderka]
- Bumped db_schema. [mokaddem]
- [mysql] Backported forgotten update. [mokaddem]
- [UI] For search field, by default put current search term. [Jakub
  Onderka]
- [test] Do not run workers in background. [Jakub Onderka]
- [test] Run under multiple PHP versions. [Jakub Onderka]
- [test] Merge common commands. [Jakub Onderka]
- [diagnostic] Smarter PHP extension diagnostics. [Jakub Onderka]
- [warning-list] updated. [Alexandre Dulaunoy]
- [export:textExport] Filter out deplicated values Fix #6603 for
  attribute scope. [mokaddem]
- [eventReport:reportFromEvent] Added support of attributes and objects.
  [mokaddem]
- Set USER everywhere. [Raphaël Vinot]
- Bump PyMISP. [Raphaël Vinot]
- Try to fix weirdness in PyMISP git history. [Raphaël Vinot]
- Bump PyMISP. [Jakub Onderka]
- Bump PyMISP. [Raphaël Vinot]
- Bump warning-lists. [Raphaël Vinot]
- [mysql] Reverted changes to be aligned with db_version. [mokaddem]
- [internal] Allow to fetch two orgs in one query. [Jakub Onderka]
- [rest] For attribute REST search with includeContext, fetch events
  just once. [Jakub Onderka]
- [UI] Simplified user edit forms and interface. [Jakub Onderka]
- [internal] Simplified ACLComponent::printRoleAccess. [Jakub Onderka]
- [UI] Authkey reset position. [Jakub Onderka]
- [UI] Ajax user list. [Jakub Onderka]
- [ACL] User different way how to use dynamic rules. [Jakub Onderka]
- [UI] Add link to user org from profile. [Jakub Onderka]
- [automation] page updated to accomodate new authkey system. [iglocska]

  - since the API keys can no longer be retrieved, point the user to where they can manage their keys
- [user] views aligned with new authkeys. [iglocska]

  - adding users should display the newly created authkey
  - other views should not show anything
  - API responses fixed
- [cleanup] removed superfluous </div> [iglocska]
- [boolean] field added to the single view fields. [iglocska]
- [user view] removed separate admin view. [iglocska]
- [authkey] add view added. [iglocska]
- [REST client] adapted to the APIkey changes. [iglocska]
- [Roles] CRUD rework. [iglocska]
- [users] admin view updated to optionally use the new authkeys.
  [iglocska]
- [indexfilter] component updated with several improvements. [iglocska]
- [user] admin view now loads advanced authkeys when appropriate.
  [iglocska]
- [authkey] system tied into authentication. [iglocska]
- [user index] don't show the old style authkeys when advanced authkeys
  are enabled. [iglocska]
- [side menu] authkeyindex added. [iglocska]
- [form] generator minor improvements. [iglocska]
- [authkey] model tied to user model. [iglocska]
- [galaxyCluster] Remote feature support check is based on flag rather
  than strict version number. [mokaddem]
- [internal] Simplified getApiInfo method. [Jakub Onderka]
- [galaxyClusters] Returns created json blob instead of interface
  response. [mokaddem]
- [events:automation] Added entry for galaxy cluster restSearch.
  [mokaddem]
- [galaxyCluster:add] Adapt page title if forking. [mokaddem]
- [galaxyCluster:view_relations] Improved UI for relations. [mokaddem]
- [galaxyCluster] Drop all elements before capture. [mokaddem]
- [server:index] Changed icon for pull relevant clusters. [mokaddem]
- [galaxy] Added logging behavior for galaxies, clusters and relations.
  [mokaddem]
- [appModel] Logout users after update. [mokaddem]
- [galaxyCluster:publish] Returns true regardless of the result for
  pushing to other servers. [mokaddem]
- [galaxyClusters:index] Added local ID in the index. [mokaddem]
- Bumped queryversion. [mokaddem]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- [warninglists:index] Migrated index to factory view. [mokaddem]
- [events:view] Renamed object's `name` key into `Object name`
  [mokaddem]

  - This is done to emphasis that elements bordered with a blue line are
  in fact MISP Objects
- [galaxy:export] Improved misp-galaxy format export and added notice.
  [mokaddem]
- [galaxy:export] Started conversion tool to misp-galaxy format - WiP.
  [mokaddem]
- [galaxies:export] Added form entry to specify the export format - WiP.
  [mokaddem]
- Bumped queryversion. [mokaddem]
- [rest] Faster attributes restSearch. [Jakub Onderka]
- [UI] Small fixes for report view. [Jakub Onderka]
- [UI] Put 'Add Event Report' to one line with other buttons. [Jakub
  Onderka]
- [UI] Make related event little bit nicer. [Jakub Onderka]
- Bumped queryversion. [mokaddem]
- [PyMISP] Bump. [Raphaël Vinot]
- [object:editField] Make the behavior of fs/ls similar to object/edit.
  [mokaddem]
- [taxonomy] Include if the predicate is exclusive at entry level.
  [mokaddem]
- [restResponseComponent] Added doc for `tags/search` [mokaddem]
- [internal] Speedup sightings saving. [Jakub Onderka]
- [use full path] added conditional to the toggle, instead of silently
  ignoring the setting when it's disabled server side. [iglocska]
- [servers:rest] Added CodeMirror support in REST Client and improve
  url's path parsing. [mokaddem]
- [internal] Slightly optimise JSONConverterTool. [Jakub Onderka]
- [feed] Check also URL without protocol. [Jakub Onderka]
- [galaxyClusterRelations] GetExistingRelationships also returns
  ObjectReference relation names. [mokaddem]
- [galaxyClusterRelation] Make sure sourceCluster is always contained.
  [mokaddem]
- [galaxyCluster] Do not display publish button for default clusters.
  [mokaddem]
- [galaxyCluster] Display value of the cluster in the header. [mokaddem]
- [galaxyClusterRelations] Displays error while posting. [mokaddem]
- [galaxyClusterRelations] Changed add/edit relationships to singular.
  [mokaddem]
- [galaxyClusterRelations] Allow unpublished clusters in the picker.
  [mokaddem]
- [galaxyClusterRelations] Display org and orgc. [mokaddem]
- [galaxy] Fixed baseurl typo. [mokaddem]
- [galaxyCluster] Allow all clusters to be forked as long as user can
  edit galaxies. [mokaddem]
- [galaxyCluster] Show published status of default clusters as N/A.
  [mokaddem]
- [galaxyClusters] Hide more actions based on users permisions.
  [mokaddem]
- [galaxyClusters] Added warning regarding useability of clusters.
  [mokaddem]
- [sidebar] Move add cluster for more consistency. [mokaddem]
- [sidemenu] `Export Galaxy Clusters` is now visible when viewing
  galaxy_cluster/view. [mokaddem]
- [side_menu] Small glitches due to merge. [mokaddem]
- [galaxyClusterBlocklist] Replaced blacklist by blocklist. [mokaddem]
- [clustersRelations:add] Redirect to the index after adding a relation.
  [mokaddem]
- [clusterRelations:add] Added helps about relationship type field.
  [mokaddem]
- [genericElement] Allow default organisation to be used as a picture.
  [mokaddem]

  - The default MISP organisation uses the MISP logo
- [OrgImgHelper] Do not return link for Orgnisation without a valid ID.
  [mokaddem]
- [clusterBlocklists:add] Improved validation and added form help.
  [mokaddem]
- [clusterRelations:add] Force no galaxy matrix when picking clusters.
  [mokaddem]
- [galaxyClusters:index] Do not propose edit for default clusters.
  [mokaddem]
- [galaxyClusters:view] Renamed extended_by/from with forked_by/from.
  [mokaddem]
- [galaxyClusters:add] Improved form layout and galaxy element ui.
  [mokaddem]
- [galaxyClusters] Added more entries in side menu. [mokaddem]
- [restResponseComponent] Added doc for rest client. [mokaddem]
- [restResponseComponent] Added doc for cluster and cluster relations.
  [mokaddem]
- [galaxyClusters:selectCluster] Only offers non-deleted clusters.
  [mokaddem]
- [galaxyCluster:publish] Slightly simplified save process. [mokaddem]
- [galaxyClusters:publish] Return job id if rest call. [mokaddem]
- [ACLComponent] Added cluster blocklist endpoints. [mokaddem]
- [clusterBlocklist:index] Added base url in table actions. [mokaddem]
- [galaxyCluster] Prevent creation if UUID is in blocklist. Added
  default distribution fallback. [mokaddem]
- [clusterBlocklist:delete] Possibility to delete entry by cluster_uuid.
  [mokaddem]
- [clusterBlocklist] Added forms and endpoints to interract with the
  model. [mokaddem]
- [galaxyCluster:delete] Creates entry in cluster blocklist whenever
  hard-deleting. [mokaddem]
- [galaxyCluster] Unset ids before capturing. [mokaddem]
- Removed empty line. [mokaddem]
- [genericElements:extended] Renamed `extended` related fields into
  `tree` and added doc. [mokaddem]
- [galaxy_cluster_link] Added doc. [mokaddem]
- [genericElements:cluster_link] Renamed `cluster_link` into
  `galaxy_cluster_link` [mokaddem]
- Added more doc. [mokaddem]
- [galaxyClusterRelation] Code refactoring and documentation. [mokaddem]
- [galaxyCluster] Added bunch of doc. [mokaddem]
- [galaxy] Improved doc. [mokaddem]
- Added more docs. [mokaddem]
- [ClusterRelationsGraphTool] Refacto and simplified code. [mokaddem]
- Removed integer type hinting in controllers. [mokaddem]
- [galaxyClusters] Doc and code reuse. [mokaddem]
- [galaxyClusters] Variable renaming and code reuse. [mokaddem]
- [clusterRelations] Added type hinting. [mokaddem]
- [galaxyCluster:fetchIfAuthorized] Renamed function checkAuthorization
  into fetchIfAuthorized. [mokaddem]
- Added comments. [mokaddem]
- Refacto bunch of galaxy clusters files. [mokaddem]
- Refacto some galaxy cluster controller files. [mokaddem]
- [galaxyCluster:saveCluster] Make sure collection_uuid is set before
  saving. [mokaddem]
- [galaxyCluster:add/edit] Automatically prepend GalaxyCluster if
  missing. [mokaddem]
- [galaxyClusters:index] Allow site_admin to publish from the cluster
  index. [mokaddem]
- [galaxyClusters:index] Allow site_admin to perfom more actions.
  [mokaddem]
- [server:pull] Pluralized `pull_relevant_cluster` as we may pull more
  than one. [mokaddem]
- [galaxyCluster:publish_router] Accept cluster data or cluster id.
  [mokaddem]
- [galaxyClusters:view_relations] Rebuild tree right after quick form
  submit. [mokaddem]
- [galaxyCluster:view_relations] Added support of pickers in quick add
  form. [mokaddem]
- [clusterRelations:add] Added picker for cluster source. [mokaddem]
- [galaxyCluster:add] Usage of new genericForm's picker for
  clusterElement UI. [mokaddem]
- [genericForm:picker] Use a default text for the picker label if not
  provided. [mokaddem]
- [formHelper] Added support of picker widget. [mokaddem]
- [clusterRelations:add] Added target cluster and tags picker.
  [mokaddem]
- [event:publish] Publishing also pushes attached custom galaxy
  clusters. [mokaddem]
- [server:push_galaxy_cluster] Working version of cluster push all
  technique. [mokaddem]
- [server:pull_cluster] Added support of `numeric` pull technique.
  [mokaddem]
- [galaxyCluster:pull] Pull clusters before events and added support of
  published state. [mokaddem]
- [galaxyClusters:updateCluster] Improved parsing of new element to be
  added from parent. [mokaddem]
- [galaxyCluster] Usage of model alias when fetching a cluster.
  [mokaddem]
- [galaxyCluster] Centralized permission checks and code refactoring.
  [mokaddem]
- [galaxyCluster] Replaced `galaxyCluster->find` by its ACL-aware
  counterpart where applicable - WiP. [mokaddem]
- [clusterRelation] Unpublish source cluster when altering a relation.
  [mokaddem]
- [servers:getVersion] Return `perm_galaxy_editor` status. [mokaddem]
- [clusterRelation:captureRelation] More lenient capture of orgc.
  Fallback to orgc=org if user is not a sync user. [mokaddem]
- [galaxyCluster:captureCluster] More lenient capture of orgc. Fallback
  to orgc=org if user is not a sync user. [mokaddem]
- [galaxyCluster:push] Only push custom clusters that are contained in
  the event getting pushed. [mokaddem]
- [GalaxyCluster] Fetcher function arrange the data before returing its
  results. [mokaddem]
- [galaxyCluster:add] Force orgc to be the user adding the cluster.
  [mokaddem]
- [GalaxyClusters:edit] Improved error message format. [mokaddem]
- [GalaxyClusters:add] Improved error message format. [mokaddem]
- [galaxyCluster:add] Allow adding cluster with galaxy uuid. [mokaddem]
- [ACLComponent] Added entry galaxy_clusters/restSearch. [mokaddem]
- [server:pull] Improved pull process for galaxyClusters. [mokaddem]
- [galaxyCluster] Usage of alias when building ACL conditions.
  [mokaddem]
- [clusterRelations:add] Savings tags is more flexible and reliable.
  [mokaddem]
- [acl] Updated endpoints and sidebar permissions. [mokaddem]
- [galaxyCluster:view] Arrange data before exporting. [mokaddem]
- [galaxyCluster:add] Improved error reporting and importing now uses
  `add` endpoint. [mokaddem]
- [galaxyCluster:crud] Improved how clusters and their linked models are
  saved. [mokaddem]
- [galaxies:delete] Allow deletion by uuid. [mokaddem]
- [galaxyCluster:restSearch] Added support of additional search params.
  [mokaddem]
- [galaxyCluster:capture] Improved cluster catpure. [mokaddem]

  - Allow to capture relationships pointing to unknown clusters
  - Improved display of relationships
- [galaxyCluster:export] Unset useless fields before export. [mokaddem]
- [galaxyClusers:relations_graph] Display notice if no relation.
  [mokaddem]
- [galaxyCluster:relations_graph] Added filtering capability and fixed
  redraw issue. [mokaddem]
- [clusterRelations:view_relations] Select default distribution.
  [mokaddem]
- [clusterRelations:index] Use correct alias. [mokaddem]
- [clusterElements:updateElements] Possibility to delete or not old
  data. [mokaddem]
- [generic_index:relation_counts] Changed icons. [mokaddem]
- [clusterRelations:relations_graph] Slight UI improvements. [mokaddem]
- [clusterRelations:relations_graph] Display tags on the links.
  [mokaddem]
- [galaxyClusters:relations_graph] Support of tag numerical values.
  [mokaddem]
- [clusterRelations:view_relations] Display all relation tags.
  [mokaddem]
- [clusterRelations:fetcher] Performs massaging on targetting relations.
  [mokaddem]
- [galaxyCluster:restSearch] Improved iterated_fetch process. [mokaddem]
- [galaxyCluster:view_relations] Added #relations and added relation
  tag. [mokaddem]
- [clusterRelations:add] Refactored how relations are saved to better
  support tags and force override. [mokaddem]
- [clusterRelations:index] Support of tags. [mokaddem]
- [clusterRelations:CRUD] Added support of tags. [mokaddem]
- [clusterRelations:index] Improved UI and new `cluster_link` generic
  index field. [mokaddem]
- [appModel:update-55] Added indexes and removed incorrect sql commands.
  [mokaddem]
- [galaxyClusters:pull] Added pull capabilities to fetch remote
  clusters. [mokaddem]
- [galaxyCluster:push] Correctly alter data before pushing and added
  nets to avoid pushing if not applicable. [mokaddem]
- [galaxyCluster:getElligibleClustersToPush] Renamed function for better
  clarity. [mokaddem]
- [server:push] Drafty version of galaxyCluster push. [mokaddem]
- [galaxyCluster] Added drafty version of restSearch. [mokaddem]
- [clusterRelations:edit] Make edit works again and improved error
  reporting. [mokaddem]
- [galaxyCluster] Usage of both ID and UUID for relation with drafty
  working version of import/export. [mokaddem]
- [galaxyClusters] Improved logging and error reporting. [mokaddem]
- [galaxyCluster] First version of capture functions. [mokaddem]
- [galaxy:export] Added configurable galaxy exporter. [mokaddem]
- [event:view] Added support of relation_tree for galaxyQuickView.
  [mokaddem]
- [clusterRelations] Moved relation_tree into its own `tool` and added
  modal support for galaxyQuickView. [mokaddem]
- [cluster:view_relations] Decoupled relation_tree from the form.
  [mokaddem]
- [clusters:index] Reworked how the forks are displayed. [mokaddem]
- [clusters:update_cluster] Changed title for improved clarity.
  [mokaddem]
- [clusterRelations:networkGenerator] Moved function in `Lib/Tools`
  [mokaddem]
- [clusterRelations:relations_graph] Added distribution and Org info.
  [mokaddem]
- [galaxyClusters:relations_graph] Keep link labels always readable.
  [mokaddem]
- [events:relations_graph] Added Referencing Clusters. [mokaddem]
- [clusters:view] Added Cluster relation index table. [mokaddem]
- [clusterRelations:networkGraphs] Improved UI by highlighting root
  nodes. [mokaddem]
- [cluster:relations_graph] Added labels to links. [mokaddem]
- [clusterRelations:index] Support of tag_name search. [mokaddem]
- [galaxy:relations_graph] Added links in tooltip. [mokaddem]
- [galaxy:relations_graph] Support of node and link selection.
  [mokaddem]
- [galaxy:relations_graph] Added tooltip support. [mokaddem]
- [clusterRelations:view_relations] Improved layout support tags in both
  side. [mokaddem]
- [clusterRelations:view_relations] Added arrows and improved UI.
  [mokaddem]
- [clusterRelations:view_relations] Working draft version for 2-sided
  tree. [mokaddem]
- [clusterRelations:view_relations] Attached referencing relations.
  [mokaddem]
- [clusterRelations:view_relations] Started implementation of double
  sided tree. [mokaddem]
- [clusterRelations:view_relations] Quick submit and few fixes.
  [mokaddem]
- [clusterRelations] Very basic CRUD. [mokaddem]
- [clusterRelations] Model linking and basic index. [mokaddem]
- [galaxyClusters:viewRelations] Improved UI. [mokaddem]
- [clusterRelations] Improved UI of relation_graph and relation_viewer.
  [mokaddem]
- [galaxy] Renamed `reference` into `relation` [mokaddem]
- [galaxyClusters:updateCluster] Working version and improved UI and
  text. [mokaddem]
- [galaxyClusters:updateCluster] Slightly improved UI. [mokaddem]
- [galaxy:sidebar] Moved item for more consistency. [mokaddem]
- [galaxyClusters:fork_tree] Replaced rectangle by label for version.
  [mokaddem]
- [galaxyClusters:view] Added warning if new parent version available.
  [mokaddem]
- [galaxuCluster:add] Added `extends_version` [mokaddem]
- [galaxyClusters:view] Added forked version number. [mokaddem]
- [galaxy:fork_tree] Version's rectangle with is now dynamically
  computed. [mokaddem]
- [galaxy:fork_tree] Added version node - WiP. [mokaddem]
- [galaxy:fork_tree] Added more information in the tooltip. [mokaddem]
- [galaxyClusters] Added column `extends_version` [mokaddem]
- [galaxy:fork_tree] Adapth root node size. [mokaddem]
- [galaxy:import] Preliminary work on export/import galaxy clusters.
  [mokaddem]
- [galaxyCluster:index] Added titles to action buttons. [mokaddem]
- [galaxyCluster:view] Added org/orgc in meta. [mokaddem]
- [galaxy:fork_tree] Added orgc picture in nodes. [mokaddem]
- [galaxy:fork_tree] Added galaxyElement in the tooltip. [mokaddem]
- [galaxy:index] Possibility to toggle fork view. [mokaddem]
- [galaxy:fork_tree] Moved generation in the model. [mokaddem]
- [galaxy:fork_tree] Doubleclick redirects to the cliked element.
  [mokaddem]
- [galaxy:fork_tree] Added fork tree visualisation - WiP. [mokaddem]
- [genericForm:extend] Adde `extended_generic` that support both
  `extended_by` and `extended_from` [mokaddem]
- [galaxyCluster:sidebar] Reorganised the sidebar a bit. [mokaddem]
- [galaxyCluster:views] Added `extended_by` and `extended_from`
  information. [mokaddem]
- [galaxyCluster:edit] Created model and controller functions.
  [mokaddem]
- [galaxyClusters:add] Created views, controller and models functions.
  [mokaddem]
- [galaxyCluster] Restored working behavior of `index` and `view` views.
  [mokaddem]
- [genericElement:indexTable] Removed auto casting to boolean as the
  bool element exists. [mokaddem]
- [galaxyCluster:fetchClusters] Added function. [mokaddem]

Fix
~~~
- [security] Make cluster's elements adhere to ACL. [mokaddem]
- Missing dep in actions. [Raphaël Vinot]
- [installer] Added missing checkout. [Steve Clement]
- [galaxy update] tag capture fixed. [iglocska]

  - set random colour and some other default values
- [galaxy update] force flag should be cast to boolean. [iglocska]
- [eventReport:reportFromEvent] Correctly apply filter conditions Fix
  #6631. [mokaddem]
- [tags] Pass user object to massaging function. [mokaddem]
- [event:index] Pass missing parameter. [mokaddem]
- [installer] if not installed as a user other then 'misp' we used to
  fail, now fixed. [Steve Clement]
- [internal] Do not try to fetch empty job. [Jakub Onderka]
- [tags] invalid function call for the tag massaging after adding a tag.
  [iglocska]
- [tags] Pass user object to massaging function. [mokaddem]
- [appController] Prevent notice for `perm_galaxy_editor`  if update is
  still running. [mokaddem]
- [logs] Add missing AuthKey model to log search. [Jakub Onderka]
- [authkey] There is no AuthKey.timestamp column. [Jakub Onderka]
- [UI] There is nothing like AuthKey.disabled. [Jakub Onderka]
- [UI] Auto prevent default for index table actions. [Jakub Onderka]
- [UI] Add label to delete auth key icon. [Jakub Onderka]
- [UI] Remove unused inbox controller and menu link. [Jakub Onderka]
- [server:sqlRecoveryQuery] Added support of unsigned int Fix #6618.
  [mokaddem]
- [galaxy:update] Correctly delete clusters when performing a force
  update. [mokaddem]
- [security] XSS in the template element index view - As reported by
  Rubin Azad. [mokaddem]
- [object] Send all required arguments. [mokaddem]
- [authkey] default value incorrect. [iglocska]
- [galaxy:update] Make sure the fake user has the perm_sync right.
  [mokaddem]
- [UI] Correct path to user profile from authkey view. [Jakub Onderka]
- [security] Proper check who can view new authkeys. [Jakub Onderka]
- [test] Do not pull PyMISP. [Jakub Onderka]
- [internal] MISP update without branch. [Jakub Onderka]
- [test] Run updates. [Jakub Onderka]
- [attribute:fetch_attributes] Respect group_by request. [mokaddem]
- [mispObject:save_object] Returns error in correct format. Fix #6598.
  [mokaddem]
- [acl] Added report_from_event entry in ACL. [mokaddem]
- Fix spelling of sightings_anonymise_as description. [Mat]
- Perms in travis, var in gh action. [Raphaël Vinot]
- Just make config writable by everyone, again. [Raphaël Vinot]
- Just make config writable by everyone. [Raphaël Vinot]
- [internal] Diagnostic data download. [Jakub Onderka]
- [internal] Server::update method. [Jakub Onderka]
- [internal] Initialize ZMQ just when necessary after setting change.
  [Jakub Onderka]
- [event index] search via attribute key allows for empty input now.
  [iglocska]
- [internal] Destroy session just when session is started. [Jakub
  Onderka]
- [index search] allow for list of values to be passed via the attribute
  key. [iglocska]
- [tag:search] Correctly pass user data. [mokaddem]
- [UI] Put back requesting API access  to user page. [Jakub Onderka]
- [security] Properly validate new auth key. [Jakub Onderka]
- [UI] Cerebrate -> MISP. [Jakub Onderka]
- [MYSQL.sql] added first/last seen. [iglocska]
- [MYSQL.sql] removed duplicate entry. [iglocska]
- [test] Update db_schema.json for auth_keys table. [Jakub Onderka]
- [test] Update database before generating new user. [Jakub Onderka]
- [MYSQL.sql] updated. [iglocska]

  - incorporated all changes from 40 -> 61
  - should solve the userinit issues
- [authkey] convert existing keys. [iglocska]

  - added functionality to convert old style API keys to the setting description
- [UI] various smaller fixes. [iglocska]
- [authkey] various improvements. [iglocska]

  - correct lookup of users by API key when no expiration is set
  - added authkey reset functions
- [rest client] implenented changes for advanced authkeys. [iglocska]

  - strip auth headers in the history
  - but not in the actual request
- [various fixes] to the authkeys controller. [iglocska]

  - invalid admin lookup fixed
  - restriction to individual users added when using a user view to access the authkey index
- [copy pasta] menues shown twice on user view fixed. [iglocska]
- [galaxyCluster] Improved compatibility detection. [mokaddem]
- [galaxyCluster] Bump timestamp after soft-deletion and restoration.
  [mokaddem]
- [RestClient] Catch exceptions and show error message to user. [Jakub
  Onderka]
- [galaxyCluster] Apply deleteAll on correct model. [mokaddem]
- [galaxyClusters:view_relations] No galaxy matrix in the picker.
  [mokaddem]
- [galaxyCluster] Allow forks with same name to appear in the picker.
  [mokaddem]
- [galaxyClusterController:edit] Default empty list to empty string.
  [mokaddem]
- [galaxies:export] typo. [mokaddem]
- [galaxyCluster] Fixed publishing cluster permissions. [mokaddem]
- [galaxyCluster:edit] Edit do not require distribution field.
  [mokaddem]
- [galaxies] Correctly highlight galaxy in index scope. [mokaddem]
- [galaxyClusters:index] Apply find on correct model for REST requests.
  [mokaddem]
- [galaxyClusterRelations:index] Added baseurl. [mokaddem]
- [servers:restClient] Keep HTTP body on template selection if it
  changed. [mokaddem]

  Making someone happy:
  oooooooooooooooo+++ssyyyysso++ooooooooooosssyyysoo
  oooooooooooooo+shmMNNNNNNNmmmdys+ooooooooyyyyysyhs
  oooooooooooo+yNMNMNNNNNNNNNNNNdhds/ooooooosooooooo
  oooooooooo+omMMMMMNNNNNNNNNNNNNmhdy/oooooooooooooo
  ooooooooo++NMMMMNMNNNNNNNNNNmmmmdhm/oooooooooooooo
  ooooooooo+yMMMMMMMMMNNNNNNNmmdmdmhN/oooooooooooooo
  ooooooooo+oNMMNNmNMMMMMMNNNmddmdmhN/oooooooooooooo
  oooooooooooodddhmys+.yyyhNNmdmNdNhh/oooooooooooooo
  oooooooooooss/y+syso+s---+smdNhomdy+oooooooooooooo
  ooooooooooooos:+oo+/-.....:hoos+Nmo+oooooooooooooo
  oooooooooooo+sysso/-.......-.ohmNd/ooooooooooooooo
  ooooooooooooo+yooo:-........-hNmh/+ooooooooooooooo
  oooooooooooooo/ho+-.......-:+dhs//oooooooooooooooo
  ooooooooooooooo+ys/::::/o++ooh:.:/+o+/+ooooooooooo
  oooooooooooooooo+ooyhydNyoshy+.`````:++o++oooooooo
  ooooooooooooooo+osssossyyhyo+-`````/:.``:y/+oooooo
  ooooooooooooo+oyooosssssso/-````../:-````+s/oooooo
  oooooooooooo++hosssssso+-```````::/:+hhyyyd:oooooo
  oooooooooooo/hossssso+:````````./oo+ymsdyym:oooooo
  ooooooooooo/ssoyysso/.```````.:+ho+smNmmmmN/+ooooo
  ooooooooooo/moshdyyso/`````:osydsoohodddhym/oooooo
  oooooooooo+yyossdhsooo-``.-ossshosd/:-..-sd/oooooo
  oooooooooo/msshdd++/:--//+++oo+sss++:.```oy+oooooo
  oooooooooo/mosssshhs+oo+/::-..``-/++--```m++oooooo
  oooooooooo/d++ooossdmhs++oooo++/:--:-.``:d/ooooooo
- [internal] Do not fetch unnecessary correlations for distribution
  graph. [Jakub Onderka]
- [object:deltaMerge] Stopped updating object's attributes when updating
  the FS/LS. [mokaddem]

  - Make sure to compare the correct date value of FS/LS and not their representation
- [eventReports] Handle exception for EventReportsController::index.
  [Jakub Onderka]
- [regression] invalid server loaded for connection test. [iglocska]
- [galaxyClusters] Fixing badly merged merge-conflict. [mokaddem]
- [internal] Properly set login times for custom auth. [Jakub Onderka]
- [UI] Join with ", " array meta values for event reports. [Jakub
  Onderka]
- [UI] Prepend URL with baseurl. [Jakub Onderka]
- [UI] Disable debounce slowdown for first event report render. [Jakub
  Onderka]
- [UI] Show 'Add Event Report' just when user can modify event. [Jakub
  Onderka]
- [internal] Do not start session for shell commands. [Jakub Onderka]
- [internal] Do not load all attributes and sightings when editing
  event. [Jakub Onderka]
- [server:restclient] Removed force url for codemirror hints. [mokaddem]
- [object:edit] Changes on fs/ls handling for object's attributes.
  [mokaddem]

  - Allow object's attributes to have fs/ls different from their object.
  - Object's attribute's timestamp is no longer refreshed when editing an object unless the attribute changed
  - Object's attribute's inherit their object fs/ls if unset
- [attribute] `only_full_group_by` fixed for `__getCDIRList`. Fix #6218.
  [mokaddem]
- [appmodel] Make sure parameter is a string before accessing string
  index. Fix #6544. [mokaddem]
- [logs:admin_index] Removed bad usage of PHP's compact function Fix
  #6543. [mokaddem]
- [tags:search] Apply correct conditions on corresponding models. Fix
  #6475. [mokaddem]
- [stix2 import] Fixed parsing of objects mapped into galaxies for
  external STIX. [chrisr3d]

  - Mapping dictionary was not loaded correctly
    while calling the ExternalStixParser class, and
    it is now fixed
  - For objects from external STIX content that
    should be mapped as galaxies (such as malware,
    threat actor, and so on), we do not only test
    the perfect match with one of the galaxy names
    in the mapping dictionary, we also test now if
    the galaxy name is contained in any of the
    known galaxy names of the dictionary
- [new tag index] added, left off in previous commit. [iglocska]
- [servers:rest] Querybuilder performance improved when loading a new
  endpoint. [mokaddem]
- [internal] `Undefined index: value` warning. [Jakub Onderka]
- [galaxyClusters] Removed print statement. [mokaddem]
- [galaxyCluster] Only fetch targeting relations if full requested.
  [mokaddem]
- [galaxyClusterRelation] id condition not ambiguous. [mokaddem]
- [galaxyClusterRelation] Make sure contain is an array. [mokaddem]
- [galaxyClusterRelation] Make sure to include sourceCluster for the ACL
  condition. [mokaddem]
- [galaxyClusterRelation] Make sure owner of source cluser can see
  org_only relations. [mokaddem]
- [galaxyCluster] Hide edit cluster for notallowed users. [mokaddem]
- [galaxyCluster] Recursive conditions on grandparent model. [mokaddem]
- [galaxyClusterRelations] Hide delete button for non-elligible users.
  [mokaddem]
- [galaxyClusterRelation] Hide linked clusters where applicable.
  [mokaddem]

  - For source cluster, hide the relation
  - For target cluster, show the relation but hide target data
- [galaxyCluster] Allow hard-deletion of default clusters. [mokaddem]
- [galaxyClusterBlocklist] Correct usage of the new blocklist component.
  [mokaddem]
- [event] Failed merge conflict. [mokaddem]
- [clusterRelations:edit] Make edition of relation possible Make sure to
  assign the source cluster id to the relation. [mokaddem]
- [clusterRelations:index] Correctly unset target cluster if unkown and
  uses correct index element. [mokaddem]
- [galaxies:export] Return application/json MIME type for all exports.
  [mokaddem]
- [misp.js] Addressed lgtm warnings. [mokaddem]
- [galaxyCluster] Make sure the value is not empty while saving.
  [mokaddem]
- [server:pull] Make sure to update the job progress only if we are
  running in a background job. [mokaddem]
- [server:pull] Makes pull works with jobs. [mokaddem]
- [galaxyCluster:updateRelationsForSync] Use correct model to get
  announceBaseUrl. [mokaddem]
- [galaxyCluster:captureCluster] Block any attempt to modify a not
  locked clusters if server is not internal. [mokaddem]
- [galaxyClusterRelation:editRelation] Removed typo. [mokaddem]

  Cluster returned by fetchIfAuthorized is not inside a list
- [galaxyCluster:saveRelation] Set `default` value if unset and allow
  saving unknown clusters if force flag set. [mokaddem]
- [galaxyCluster:fetchIfAuthorized] Adhere to $throwErrors if the ID is
  invalid. [mokaddem]
- [galaxyCluster:publish] Cluster parameter can be of any type.
  [mokaddem]
- [galaxyCluster:publishRouter] Cluster parameter can be of any type.
  [mokaddem]
- [appModel:db_changes] Added new entry. [mokaddem]
- [galaxyCluster:fetchGalaxyCluster] Make sure to fetch a fresh version
  of the sharinggroup with all its associated data. [mokaddem]
- [GalaxyCluster:fetchGalaxyCluster] Correctly attach all sharinggroup
  information. [mokaddem]
- [galaxyCluster] Make sure we correctly update cluster relations and
  few QoL fixes. [mokaddem]
- [clusterRelations:add] Correctly report validation errors. [mokaddem]
- [install:MySQL] Create `perm_galaxy` in roles table before updating
  rows. [mokaddem]
- [clusterRelations:add/edit] Avoid error variable override. [mokaddem]
- [clusterRelation:delete] Take first result if id matches. [mokaddem]
- [clusterRelation] Use correct linked model alias. [mokaddem]
- [galaxyCluster] Typo when accessing variables. [mokaddem]
- [ACLComponent] Put `pushClusters` into the correct section. Also
  removed useless condition. [mokaddem]
- [servers:push] Do not throw exception while pushing via rest query.
  [mokaddem]
- [galaxy:import] Set org and orgc to default MISP org. [mokaddem]
- [clusterRelations:view_relation_tree] Avoid id collision for cross-
  referencing clusters. [mokaddem]
- [galaxy:import] Correctly set distribution when importing from
  repository. [mokaddem]
- [clusterRelations:edit] Endpoint access data with/without model key.
  [mokaddem]
- [clusterRelation] Added entry in ACLComponent and improved rest error
  message. [mokaddem]
- [clusterRelations] Corrected conditions allowing the creation/update
  of relations. Plus, get rid of not-used relation's value. [mokaddem]
- [clusterRelation:add] Use the correct key to access cluster info.
  [mokaddem]
- [clusterRelations:add] Removed useless translation. [mokaddem]
- [clusterRelation:restSearch] Allow org to see their own relations if
  they are distribution=org_only. [mokaddem]
- [galaxyCluster] Typo in linked model. [mokaddem]
- [galaxyCluster:fetchClusters] Added missing conditions for
  clusterRelations. [mokaddem]
- [galaxyCluster:pull] Correctly capture the Orgc. [mokaddem]
- [galaxyClusterRelation:getRelations] Could not fetch relations with no
  full group by enabled. [mokaddem]
- [galaxyCluster:captureCluster] Make sure to capture the galaxy if
  unkown. [mokaddem]
- [clusterRelation:captureRelations] Default referenced galaxy id to 0
  if it's unkown. [mokaddem]
- [galaxyCluster:view_relation_tree] Tree links takes into account the
  avg numerical_value. [mokaddem]
- [galaxies:massageTags] Pass user to the model. [mokaddem]
- [clusterRelations:syncUUIDsAndIDs] Make sure to default referenced
  cluster id to 0 if unknown. [mokaddem]
- [galaxy:import] Use correct data path to retrieve galaxy id.
  [mokaddem]
- [galaxyCluster:edit] Fixed key name issues preventing clusters to be
  edited similar to the `add` endpoint. [mokaddem]
- [galaxyCluster:relations_graph] Fixed link id not used consistently.
  [mokaddem]
- [clusterRelations:catpure] More flexible tag capture. [mokaddem]
- [galaxy:import] Set the locked flag for the imported galaxyCluster.
  [mokaddem]
- [galaxyCluster] Make sure to sync id/uuid for the target relation.
  [mokaddem]
- [galaxyCluster:view_relation_tree] Fixed division by 0. [mokaddem]
- [galaxyClusters:relations_graph] Draw relation text only once +
  Physics tweaking. [mokaddem]
- [galaxyClusers:relations_graph] Draw nodes after links. [mokaddem]
- [galaxyCluster:CRUD] Fixed fields not being saved correctly and
  improved API feedback. [mokaddem]
- [clusterRelations:relation_tree] looping with function callback change
  the value of `this` [mokaddem]
- [server:pushGalaxyCluster] Correctly select UUIDs to be pushed.
  [mokaddem]
- [clusterRelations:view_relations] Avoid duplication of targetting
  relations. [mokaddem]
- [clusterRelations:view_relations] Correctly sync ID and UUID when
  adding a relation and repaired view. [mokaddem]
- [clusterRelations:relations_graph] Support of fallback `MISP`
  Organisation and improved tooltip layout. [mokaddem]
- [galaxy:quickViewMini] Prevent multiple `mouseover` listeners.
  [mokaddem]
- [cluster:add_relation] Correctly use the freetext relation if picked.
  [mokaddem]
- [clusters:edit] ClusterElementUI do not duplicate rows each time it's
  displayed. [mokaddem]
- [event:view] Prevent global variable overide. [mokaddem]
- [ClusterRelationsGraphTool] Inject Orgs and SharingGroup info for
  referencing nodes. [mokaddem]
- [events:view] Fixed cluster_relations filename and distribution info.
  [mokaddem]
- [clusterRelations:fork_tree] Prevent division by 0. [mokaddem]
- [galaxy] Few leftovers to be renamed. [mokaddem]
- [galaxy:fork_tree] Better handling of versions. [mokaddem]
- [galaxyCluster:view] Catch if cluster has no `extended_from`
  [mokaddem]
- [galaxy:editCluster] Correctly update galaxyElements. [mokaddem]
- [galaxy:fork_tree] Correctly print default value. [mokaddem]
- [galaxu:index] Corrected cluster base urls locations. [mokaddem]
- [genericIndexTable:extended_generic] Do not duplicate field if both
  `from` and `by` are used. [mokaddem]
- [galaxyCluster:attachToEventIndex] Usage of the correct function.
  [mokaddem]

Other
~~~~~
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge pull request #6638 from korrosivesec/feature/jarm. [Alexandre
  Dulaunoy]

  new: [datamodels] added jarm-fingerprint type
- Merge pull request #6639 from SteveClement/guides. [Steve Clement]
- Merge branch '2.4' into guides. [Steve Clement]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #6636 from MISP/gh_actions_var. [Raphaël Vinot]

  chg: Improve actions
- Merge pull request #6632 from StefanKelm/2.4. [Alexandre Dulaunoy]

  Update Server.php
- Update Server.php. [StefanKelm]

  Tiny re-wording
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge pull request #6630 from SteveClement/guides. [Steve Clement]
- Merge pull request #6628 from JakubOnderka/update-json-speedup. [Jakub
  Onderka]

  chg: [internal] Faster updating JSON structures
- Merge pull request #6629 from SteveClement/guides. [Steve Clement]
- Merge remote-tracking branch 'upstream/2.4' into guides. [Steve
  Clement]
- Merge branch 'guides' of github.com:SteveClement/MISP into guides.
  [Steve Clement]
- Merge pull request #6572 from JakubOnderka/syslog-stderr-disable.
  [Jakub Onderka]

  Syslog stderr disable
- Merge pull request #6625 from JakubOnderka/setting-change-exception.
  [Jakub Onderka]

  chg: [internal] Throw exception if setting name doesn't exists
- Merge pull request #6626 from JakubOnderka/no-empty-job. [Jakub
  Onderka]

  fix: [internal] Do not try to fetch empty job
- Merge remote-tracking branch 'origin/2.4' into JakubOnderka-galaxy-
  cluster-fetch. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #6623 from JakubOnderka/log-search-models. [Jakub
  Onderka]

  fix: [logs] Add missing AuthKey model to log search
- Merge pull request #6586 from JakubOnderka/autkey-fixes. [Jakub
  Onderka]

  Authkey UI  fixes
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge pull request #6559 from JakubOnderka/fist-last-seen-sort. [Jakub
  Onderka]

  new: [UI] Allow to sort attributes or objects by first and last seen
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge pull request #6617 from JakubOnderka/freetext-feed-saving.
  [Jakub Onderka]

  chg: [feed] Optimise freetext feed caching
- Merge pull request #6609 from JakubOnderka/remove-inbox-controller.
  [Jakub Onderka]

  fix: [UI] Remove unused inbox controller and menu link
- Merge pull request #6621 from JakubOnderka/extension-version. [Jakub
  Onderka]

  new: [diagnostic] Check extensions version
- Merge pull request #6120 from mokaddem/galaxy-cluster2.0. [Sami
  Mokaddem]

  [feature] Cluster relations and synchronization - aka Galaxy 2.0
- Merge branch '2.4' into galaxy-cluster2.0. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into galaxy-cluster2.0.
  [mokaddem]
- Merge pull request #6496 from JakubOnderka/experimental-stream-
  convert. [Jakub Onderka]
- Merge pull request #6589 from JakubOnderka/group-search-current-value.
  [Jakub Onderka]

  chg: [UI] For search field, by default put current search term
- Merge pull request #6587 from JakubOnderka/authkey-view. [Jakub
  Onderka]

  Authkey view permission fix
- Merge pull request #6604 from JakubOnderka/github-test-changes. [Jakub
  Onderka]

  GitHub test changes
- Merge pull request #6605 from JakubOnderka/php-extension-diagnostic.
  [Jakub Onderka]

  chg: [diagnostic] Smarter PHP extension diagnostics
- Merge branch 'feature-report-from-event' into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into feature-report-from-
  event. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into feature-report-from-
  event. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into feature-report-from-
  event. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into feature-report-from-
  event. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into galaxy-cluster2.0.
  [mokaddem]
- Merge pull request #6580 from Maddosaurus/fix-plugin-setting-spelling.
  [Sami Mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into galaxy-cluster2.0.
  [mokaddem]
- Merge pull request #6600 from MISP/github_action_2. [Raphaël Vinot]

  chg: try to fix weirdness in PyMISP git history
- Merge pull request #6601 from JakubOnderka/fix-diagnostic-download.
  [Jakub Onderka]

  fix: [internal] Diagnostic data download
- Merge pull request #6599 from JakubOnderka/misp-update-fix. [Jakub
  Onderka]

  fix: [internal] Server::update method
- Merge pull request #6597 from JakubOnderka/zmq-setting-change-fix.
  [Jakub Onderka]

  fix: [internal] Initialize ZMQ just when necessary after setting change
- Merge pull request #6596 from JakubOnderka/bump-pymisp. [Raphaël
  Vinot]

  chg: Bump PyMISP
- Merge pull request #6588 from JakubOnderka/gpg-version-diagnostics.
  [Jakub Onderka]

  new: [diagnostic] Show installed GnuPG version
- Merge remote-tracking branch 'origin/2.4' into galaxy-cluster2.0.
  [mokaddem]
- Merge branch 'session_destruction' into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into galaxy-cluster2.0.
  [mokaddem]
- Merge pull request #6561 from JakubOnderka/rest-attribute-include-
  context. [Jakub Onderka]

  chg: [rest] For attribute REST search with includeContext, fetch events just once
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #6532 from JakubOnderka/user_edit. [Jakub Onderka]

  User edit permissions
- Merge branch 'authkey_fix' into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #6584 from JakubOnderka/authkeys-test-fix. [Jakub
  Onderka]

  fix: [test] Update database before generating new user
- Merge branch '2.4' of github.com:MISP/MISP into galaxy-cluster2.0.
  [mokaddem]
- Merge branch 'CRUD' into 2.4. [iglocska]
- Merge branch '2.4' into CRUD. [iglocska]
- Merge branch '2.4' into CRUD. [iglocska]
- Merge branch '2.4' into CRUD. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into galaxy-cluster2.0.
  [mokaddem]
- Merge pull request #6560 from JakubOnderka/rest-client-handle-
  exceptions. [Jakub Onderka]

  fix: [RestClient] Catch exceptions and show error message to user
- Merge branch '2.4' of github.com:MISP/MISP into galaxy-cluster2.0.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge pull request #6566 from JakubOnderka/distribution-disable-
  correlation. [Jakub Onderka]

  fix: [internal] Do not fetch unnecessary correlations for distributio…
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge pull request #6564 from JakubOnderka/fix-can-modify-report.
  [Jakub Onderka]

  fix: [eventReports] Handle exception for EventReportsController::index
- Merge remote-tracking branch 'origin/2.4' into galaxy-cluster2.0.
  [mokaddem]
- Merge branch 'jakub-event-ui-vol5' into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into jakub-event-ui-vol5.
  [mokaddem]
- Merge pull request #6529 from JakubOnderka/experimenteal-faster-rest-
  fetch. [Jakub Onderka]

  chg: [rest] Faster attributes restSearch
- Merge pull request #6541 from JakubOnderka/head-check-attribute-
  object. [Jakub Onderka]

  new: [API] Fast check object or attribute existence by HEAD method
- Merge pull request #6519 from JakubOnderka/update-login-times. [Jakub
  Onderka]

  fix: [internal] Properly set login time for custom auth
- Merge pull request #6533 from JakubOnderka/shell-no-session. [Jakub
  Onderka]

  fix: [internal] Do not start session for shell commands
- Merge pull request #6538 from JakubOnderka/event-edit-optimisation.
  [Jakub Onderka]

  fix: [internal] Do not load all attributes when editing event
- Merge pull request #6548 from JakubOnderka/related-event-template.
  [Jakub Onderka]

  chg: [UI] Make related event little bit nicer
- Merge branch 'feature-rest-client-codemirror' into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into feature-rest-client-
  codemirror. [mokaddem]
- Merge pull request #6542 from JakubOnderka/speedup-sightings-saving.
  [Jakub Onderka]

  chg: [internal] Speedup sightings saving
- Merge branch '2.4' of github.com:MISP/MISP into feature-rest-client-
  codemirror. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge pull request #6510 from JakubOnderka/event-edit-metadata. [Jakub
  Onderka]

  new: [rest] Allow to return just metadata after creating or editing event
- Merge pull request #6490 from JakubOnderka/json-converter-optim.
  [Jakub Onderka]

  chg: [internal] Slightly optimise JSONConverterTool
- Merge pull request #6528 from JakubOnderka/event-view-head. [Jakub
  Onderka]

  new: [API] Allow event existence check by HEAD method
- Merge pull request #6521 from JakubOnderka/cached-feed-url-match.
  [Jakub Onderka]

  chg: [feed] Check also URL without protocol
- Merge pull request #6514 from JakubOnderka/fix-indefined-index. [Jakub
  Onderka]

  fix: [internal] `Undefined index: value` warning
- Merge remote-tracking branch 'origin/2.4' into galaxy-cluster2.0.
  [mokaddem]
- Merge remote-tracking branch 'origin/2.4' into galaxy-cluster2.0.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into galaxy-cluster2.0.
  [mokaddem]
- Merge remote-tracking branch 'origin/2.4' into galaxy-cluster2.0.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into galaxy-cluster2.0.
  [mokaddem]
- Merge remote-tracking branch 'origin/2.4' into galaxy-cluster2.0.
  [mokaddem]
- Merge branch 'fix-sg-creation' into galaxy-cluster2.0. [mokaddem]
- Merge remote-tracking branch 'origin/2.4' into galaxy-cluster2.0.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into galaxy-cluster2.0.
  [mokaddem]
- Merge remote-tracking branch 'origin/2.4' into galaxy-cluster2.0.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into galaxy-cluster2.0.
  [mokaddem]


v2.4.134 (2020-11-02)
---------------------

New
~~~
- [tag index] simple/advanced view. [iglocska]

  - simple view excludes eventtags / attributetags / sightings
  - helps with heavier instances

  - refactor of the index to the new generators
  - new elements for the generators added
- [UI] Add link to show related feeds attributes. [Jakub Onderka]
- [UI] Allow to set attachment scan settings from user interface. [Jakub
  Onderka]
- [widgets] button for link (#6489) [Loïc Fortemps]
- [statistics shell] year over year org growth added. [iglocska]
- [eventReports] Event auto-tagging from report. [mokaddem]
- [UI] Attachment scan diagnostic. [Jakub Onderka]
- [av] Allow to scan just by file hash. [Jakub Onderka]
- [av] Use misp-module for AV scanning. [Jakub Onderka]
- [av] Malware protection for uploaded files. [Jakub Onderka]
- [UI] Allow to disable hover enrichment. [Jakub Onderka]
- [sync] Show client certificate info in connection test. [Jakub
  Onderka]
- [eventReports] Creation of reports from URL using MISP-modules.
  [mokaddem]
- [eventReport] Added context replacements and suggestions. [mokaddem]
- [eventReports:markdownEditor] Text replacement with existing
  attributes. [mokaddem]
- [eventReports] Attributes suggestion replacement + UI - Draft.
  [mokaddem]

Changes
~~~~~~~
- [version] bump. [iglocska]
- [misp-taxonomies] updated. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [PyMISP] Bump version. [Raphaël Vinot]
- Bump PyMISP for testing. [Raphaël Vinot]
- [misp-objects] updated. [Alexandre Dulaunoy]
- [warning-lists] updated. [Alexandre Dulaunoy]
- [misp-galaxy] updated. [Alexandre Dulaunoy]
- [markdownEditor] Add cancel button for the editor. Fix #6506.
  [mokaddem]
- Bumped queryversion. [mokaddem]
- [cti-python-stix2] Bumped latest version. [chrisr3d]
- [eventsReport:markdownEditor] Increased base number of hints.
  [mokaddem]
- [eventReport:markdownEditor] Adapt hint number based on the length of
  the provided input. [mokaddem]
- [eventReports] Removed confusing edit buton in event view. [mokaddem]
- [statistics shell] yearly growth now takes a local only flag as
  parameter. [iglocska]
- [UI] Cleanup code of default layout. [Jakub Onderka]
- [module] Allow to specify module timeout. [Jakub Onderka]
- [internal] Allow to fetch Mitre Attack matrix also by name. [Jakub
  Onderka]
- [UI] Attach warnings after attribute quick edit. [Jakub Onderka]
- [internal] Move warnings popover generation to value_field template.
  [Jakub Onderka]
- [statistics shell] added org engagement function to get insights on
  first event creation. [iglocska]
- [eventReport] Improved html_to_markdown module handling. [mokaddem]
- [eventReport] Extracted function. [mokaddem]
- [eventReport] Renamed functions. [mokaddem]
- [eventReports:markdownEditor] Added loading screen when extracting
  entities. [mokaddem]
- [misp-galaxy] updated. [Alexandre Dulaunoy]
- [logs] search no longer uses csrf tokens for the form. [iglocska]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy] updated to include ATT&CK sub-techniques. [Alexandre
  Dulaunoy]
- [module] Better error handling. [Jakub Onderka]
- [module] Move serialization into module class. [Jakub Onderka]
- [UI] Update Font Awesome to 5.15.1. [Jakub Onderka]
- [module] Allow module settings to be dict with setting description.
  [Jakub Onderka]
- [module] Serialize post data at one place. [Jakub Onderka]
- [module] Remove unused variable from Module::getModules method. [Jakub
  Onderka]
- [UI] Change quick edit icons also for objects and setting edit. [Jakub
  Onderka]
- [UI] Use 'Event' instead of 'Info' in correlation popover. [Jakub
  Onderka]
- [UI] Add icon for undefined threat level. [Jakub Onderka]
- [UI] Nicer required asterisk. [Jakub Onderka]
- [UI] For revise object, do not validate unique UUID. [Jakub Onderka]
- [internal] Do not load notifications for ajax requests. [Jakub
  Onderka]
- [internal] Add suggested PHP extensions to composer.json. [Jakub
  Onderka]
- [internal] Update composer.phar to 1.10.15. [Jakub Onderka]
- [travis] Do list all directories after failed test. [Jakub Onderka]
- [internal] Save same time and memory in RestResponseComponent. [Jakub
  Onderka]
- [UI] Use standard way how to show attribute values for resolved
  results. [Jakub Onderka]
- [UI] Fixes for user profile admin view. [Jakub Onderka]
- [eventReports:markdownEditor] Improved parsing and provide feedbacks
  if elements cannot be rendered. [mokaddem]
- [eventReport:markdownEditor] Improved parsing of context (reduced
  false positive) + find rendered element in doc. [mokaddem]
- [eventReport:markdownEditor] Interface improvements. [mokaddem]
- [eventReport] Draft support of context auto replacement. [mokaddem]
- [eventReport:markdownEditor] Prevent double extraction for tags.
  [mokaddem]
- [eventReport] Simplified replacement mechanism. [mokaddem]
- [eventReports:markdownEditor] Cleanup and function renaming.
  [mokaddem]
- [eventReport] Support of replacement regex & automatic replacement -
  DRAFT. [mokaddem]
- [eventReports:markdownEditor] Reorganise function position. [mokaddem]
- [eventReports:markdownEditor] Popover to show replacement attribute.
  [mokaddem]
- [evnetReport:markdownEditor] UI improvements on suggestion tables.
  [mokaddem]
- [eventReports:markdownEditor] Suggestion UI improvements. [mokaddem]
- [eventReport:markdownEditor] Do no propose extractions for existing
  replacements. [mokaddem]

Fix
~~~
- [stix import] Avoiding issue with test_mechanisms with no rule value.
  [chrisr3d]
- [internal] Remove warning when modules are not reachable. [Jakub
  Onderka]
- [security] SSRF fixed in the rest client. [iglocska]

  - by using the full path parameter in the rest client, users could issue queries to any server
  - this becomes especially problematic when the MISP server is able to query other internal servers,
    as external users could trigger those

  - new server setting added that allows enabling the full path option, this is now disabled by default
  - new server setting added to add an override baseurl for the rest client, removing the need for the full
    path option in the first place (for example for the training VM with its port forwarding)

  - Thanks to Heitor Gouvêa for reporting this vulnerability
- [eventReport] Function call not adapted after module rework merge.
  [mokaddem]
- [ACL] Add missing controllers from EventReports. [Jakub Onderka]
- [internal] Warning when viewing feed info. [Jakub Onderka]
- [UI] Show error message if genericPopup ajax request fails. [Jakub
  Onderka]
- [eventReport:markdownEditor] Show full attribute value in print mode.
  Fix #6507. [mokaddem]
- [UI] More space in sighting graph for a lot of sightings numbers.
  [Jakub Onderka]
- [UI] Add missing line break. [Jakub Onderka]
- [UI] Remove forgotten removed variable. [Jakub Onderka]
- [UI] Show correct message when saving object after quick edit. [Jakub
  Onderka]
- [UI] Show error if multiSelectAction fails. [Jakub Onderka]
- [eventReport] Correctly tag event if requested + undefined variable.
  [mokaddem]
- #6354. [Nick]

  fix: #6354

  Need escape for quote in regex
- [av] Send to module also attribute UUID and value. [Jakub Onderka]
- [modules] Better error handling for connection problems. [Jakub
  Onderka]
- [module] Throw exception if response JSON is invalid. [Jakub Onderka]
- [UI] Remove unnecessary empty div from seen_field. [Jakub Onderka]
- [UI] Do not allow to add tags when showing event to merge. [Jakub
  Onderka]
- [UI] Fix strikethrough text decoration for deleted reference. [Jakub
  Onderka]
- [UI] Remove unnecessary form element from correlated events. [Jakub
  Onderka]
- [internal] Remove compressing by ZIP PHP extensions. [Jakub Onderka]
- [internal] Avoid warnings in global_menu. [Jakub Onderka]
- [resource-widget] Use redisInfo method for getting info. [Jakub
  Onderka]
- [tools] Variable names typo. [chrisr3d]
- [internal] Check Crypt_GPG version. [Jakub Onderka]
- [UI] Put back missing homepage star. [Jakub Onderka]
- [internal] Unused variable in Event::__generateCachedTagFilters.
  [Jakub Onderka]
- [internal] Remove unused file. [Jakub Onderka]
- [internal] Remove unused AppModel::checkVersionRequirements method.
  [Jakub Onderka]
- [travis] Retry poetry packages installation. [Jakub Onderka]
- [eventReports:markdownEditor] Better parsing of free text value.
  [mokaddem]

Other
~~~~~
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Raphaël Vinot]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Raphaël Vinot]
- Merge pull request #6535 from JakubOnderka/module-warning-fix. [Jakub
  Onderka]

  fix: [internal] Remove warning when modules are not reachable
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge pull request #6527 from JakubOnderka/event-reports-acl-missing.
  [Jakub Onderka]

  fix: [ACL] Add missing controllers from EventReports
- Merge pull request #6518 from JakubOnderka/ui-related-feeds. [Andras
  Iklody]

  chg: [UI] Remove Source Format from related feed popover
- [UI] Remove Source Format from related feed popover. [Jakub Onderka]
- Merge pull request #6524 from trolldbois/2.4. [Andras Iklody]
- Merge pull request #1 from trolldbois/trolldbois-fix-email-
  sendExternal. [Loïc Jaquemet]

  Remove 'text' from required params from sendExternal
- Remove 'text' from required params from sendExternal. [Loïc Jaquemet]

  Bug fix, there is no such fields named 'text' in params. It's probably a typo from reading line 309 too fast
- Merge pull request #6520 from JakubOnderka/feed-view-fix-warning.
  [Jakub Onderka]

  fix: [internal] Warning when viewing feed info
- Merge branch 'feature-report-extract-data' into 2.4. [mokaddem]
- Merge remote-tracking branch 'origin/2.4' into feature-report-extract-
  data. [mokaddem]
- Merge pull request #6516 from JakubOnderka/generic-popup-fail. [Jakub
  Onderka]

  fix: [UI] Show error message if genericPopup ajax request fails
- Merge pull request #6498 from JakubOnderka/attachment-scan-settings.
  [Jakub Onderka]

  new: [UI] Allow to set attachment scan settings from user interface
- Merge pull request #6499 from pettai/more-bro-auto-docs. [Andras
  Iklody]

  Update bro automation docs
- Update bro automation docs. [pettai]

  More of remove allowNonIDS from bro per https://github.com/MISP/MISP/pull/1726
- Merge pull request #6451 from Wachizungu/add-extra-shibbauth-
  documentation. [Alexandre Dulaunoy]

  Extending documentation of ShibbAuth plugin
- Extending documentation of ShibbAuth plugin. [Jeroen Pinoy]
- Merge branch '2.4' of github.com:MISP/MISP into feature-report-
  extract-data. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #6495 from JakubOnderka/fixes. [Jakub Onderka]

  UI Fixes
- Merge pull request #6492 from pettai/bro-automation-docs. [Alexandre
  Dulaunoy]

  Fix Bro IDS export docs
- Fix Bro IDS export docs. [pettai]

  As per https://github.com/MISP/MISP/pull/1726 the "allowNonIDS" option was explicitly removed from Bro IDS export, update the docs accordingly
  (some hairpulling was done prior to this finding...)
- Merge pull request #6485 from JakubOnderka/module-timeout. [Jakub
  Onderka]

  chg: [module] Allow to specify module timeout
- Merge pull request #6494 from JakubOnderka/event-ui-fixes-vol6. [Jakub
  Onderka]

  Event UI fixes vol6
- Merge branch '2.4' of github.com:MISP/MISP into feature-report-
  extract-data. [mokaddem]
- Merge pull request #6488 from JakubOnderka/attachment-scan-diagnostic.
  [Jakub Onderka]

  new: [UI] Attachment scan diagnostic
- Merge pull request #6484 from crowface28/2.4. [Andras Iklody]

  fix: #6354
- Merge pull request #6411 from JakubOnderka/malware-scan. [Jakub
  Onderka]

  Attachment malware protection
- Merge pull request #6483 from JakubOnderka/module-settings. [Jakub
  Onderka]

  Module settings
- Merge pull request #6479 from JakubOnderka/event-ui-vol5-small. [Jakub
  Onderka]

  Event ui vol5 small
- Merge pull request #6478 from JakubOnderka/remove-zip-ext-compression.
  [Jakub Onderka]

  fix: [internal] Remove compressing by ZIP PHP extensions
- Merge pull request #6471 from
  JakubOnderka/enrichment_hover_popover_only. [Jakub Onderka]

  new: [UI] Allow to disable hover enrichment
- Merge pull request #6474 from JakubOnderka/avoid-warnings. [Jakub
  Onderka]

  fix: [internal] Avoid warnings in global_menu
- Merge pull request #6473 from JakubOnderka/misp-resource-widget.
  [Jakub Onderka]

  fix: [resource-widget] Use redisInfo method for getting info
- Merge pull request #6465 from JakubOnderka/ajax-no-notification-
  [Jakub Onderka]

  chg: [internal] Do not load notification count and homepage for AJAX requests
- Merge pull request #6450 from JakubOnderka/client-certificate-info.
  [Jakub Onderka]

  new: [sync] Show client certificate info in connection test
- Merge pull request #6468 from JakubOnderka/bad-commit-fix. [Jakub
  Onderka]

  Revert "fix: [internal] Remove unused AppModel::checkVersionRequireme…
- Revert "fix: [internal] Remove unused
  AppModel::checkVersionRequirements method" [Jakub Onderka]

  This reverts commit ac6761d7
- Merge pull request #6460 from MISP/chrisr3d_features. [Alexandre
  Dulaunoy]

  Small STIX ingestion script
- Merge branch 'chrisr3d_features' of https://github.com/MISP/MISP into
  chrisr3d_features. [chrisr3d]
- Update README.md. [Christian Studer]

  Page layout issue fixed
- Merge branch '2.4' of https://github.com/MISP/MISP into
  chrisr3d_features. [chrisr3d]
- Add: [tools] More documentation for the stix ingestion script.
  [chrisr3d]
- Add: [tools] Small script to ingest STIX files using the restAPI.
  [chrisr3d]

  - Automation of the ingestion for multiple file
    simply by passing all the filenames
  - Using PyMISP to connect to MISP and query the
    /events/upload_stix end point
- Merge pull request #6463 from JakubOnderka/crypt-gpg-version-check.
  [Jakub Onderka]

  fix: [internal] Check Crypt_GPG version
- Merge pull request #6466 from JakubOnderka/homepage-star. [Jakub
  Onderka]

  fix: [UI] Put back missing homepage star
- Merge pull request #6459 from JakubOnderka/composer-update. [Jakub
  Onderka]

  chg: [internal] Update composer.phar to 1.10.15
- Merge pull request #6458 from JakubOnderka/remove-unused. [Jakub
  Onderka]

  Remove unused code
- Fix [internal] Removed unused EventsController::viewEventGraph method.
  [Jakub Onderka]
- Fix [internal] Removed unused Server::__handlePulledProposals method.
  [Jakub Onderka]
- Fix [internal] Removed unused EventsController::__fetchEvent method.
  [Jakub Onderka]
- Merge pull request #6454 from JakubOnderka/travis-fixes-vol3. [Jakub
  Onderka]

  test: Retry poetry install
- Merge pull request #6457 from JakubOnderka/rest-response-optim. [Jakub
  Onderka]

  chg: [internal] Save some time and memory in RestResponseComponent
- Merge pull request #6455 from JakubOnderka/resolved-misp-format-value.
  [Jakub Onderka]

  chg: [UI] Use standard way how to show attribute values for resolved …
- Merge pull request #6456 from JakubOnderka/admin-user-view-fixes.
  [Jakub Onderka]

  chg: [UI] Fixes for user profile admin view


v2.4.133 (2020-10-16)
---------------------

New
~~~
- [UI] Use flag icons from Twemoji. [Jakub Onderka]
- [UI] Show organisation nationality flag. [Jakub Onderka]
- [attribute type] cpe Common Platform Enumeration attribute type added.
  [Alexandre Dulaunoy]
- [attribute] telfhash attribute type added - fix #6435. [Alexandre
  Dulaunoy]
- [GPG] Validate fetched GPG key. [Jakub Onderka]
- [UI] Add icons for threat levels. [Jakub Onderka]
- [internal] Allow to set warning checking for all attributes, not just
  IDS. [Jakub Onderka]
- [warninglist] Allow to check if IP in CIDR is part of another CIDR.
  [Jakub Onderka]
- [warninglist] Cache warninglist results. [Jakub Onderka]
- [build] Validate also feed metadata rules and settings JSON contents.
  [Jakub Onderka]
- [attribute-type] filename-pattern to describe a filename base on a
  pattern. [Alexandre Dulaunoy]

  Fix #403

  There is no specific validation on the field. This allows us to have a clear
  separation between filename and filename-pattern as many users were
  using filename for regexp. This also helps the creation of object
  template which requires a filename pattern.
- [evenReport] Support of extended event. [mokaddem]
- [eventReport:markdownEditor] Toggleable rendering of MISP Elements.
  [mokaddem]
- [eventReport:markdownEditor] Support to reference object attribute.
  [mokaddem]
- [markdownEditor] Added support of fullscreen mode. [mokaddem]
- [eventReport:markdownEditor] Added hints for tags. [mokaddem]
- [eventReport] Added support of tags. [mokaddem]
- [user agent] string changed for MISP -> MISP synchronisation.
  [iglocska]
- [UI] Truncate long values. [Jakub Onderka]
- [UI] Go directly to object reference when referenced object is on the
  same page. [Jakub Onderka]
- [workers] add kill all / force kill all buttons to the worker
  management, fixes #6329. [iglocska]
- [recovery] script added mock method among other changes. [iglocska]

  - also added proposals
  - add/accept/discard should be fully supported now
- [recovery] added event deletion recovery tool. [iglocska]
- [internal] added helper function to get tag id based on cluster id.
  [iglocska]
- [markdownEditor] Possibility to toggle rules on-the-fly. [mokaddem]
- [markdownViewer] Added light support of picture attachment parsing.
  [mokaddem]
- [markdownViewer] Support of hints in editor. [mokaddem]
- [markdownViewer] Added rule and renderer for special MISP elements.
  [mokaddem]

Changes
~~~~~~~
- [VERSION] bump. [iglocska]
- Bump PyMISP. [Raphaël Vinot]
- [warning-lists] updated. [Alexandre Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [UI] Remove famfamfam icon flags. [Jakub Onderka]
- [UI] Use IconHelper for flag icons. [Jakub Onderka]
- [internal] Allow to have empty nationality. [Jakub Onderka]
- [UI] Update country names. [Jakub Onderka]
- [internal] Normalize AS type to asplain notation. [Jakub Onderka]
- [internal] Speedup sending module results. [Jakub Onderka]
- [internal] Sighting saving optimisation. [Jakub Onderka]
- [PyMISP] updated. [Alexandre Dulaunoy]
- [attribute] cpe was already present but not specified in any
  categories. [Alexandre Dulaunoy]
- [UI] Use nicer icon for Restore attribute button. [Jakub Onderka]
- [eventReport] Put back attribute galaxies. [Jakub Onderka]
- [eventReport] proxyMSIPElements are loaded dynamically. [Jakub
  Onderka]
- [eventReport] Do not fetch event reports when it is not necessary.
  [Jakub Onderka]
- [eventReport] Do not fetch attribute tags again, they are included in
  object. [Jakub Onderka]
- [eventReport] Do not fetch unnecessary event and attribute galaxies.
  [Jakub Onderka]
- [eventReport] Do not create separate array, merge is expensive. [Jakub
  Onderka]
- [eventReport] Do not attach sharing groups. [Jakub Onderka]
- [eventReport] Fetch object templates just when event contains objects.
  [Jakub Onderka]
- [eventReport] Fetch parental event just when it is necessary. [Jakub
  Onderka]
- [eventReport] Do not fetch sightings for events. [Jakub Onderka]
- [UI] Use existing implementation for popover also for cortex. [Jakub
  Onderka]
- [UI] Put back all attribute types when selecting empty category.
  [Jakub Onderka]
- [internal] Faster loading od Distribution graph. [Jakub Onderka]
- [UI] Show hostname|port attribute value on one line. [Jakub Onderka]
- [validation] Provide better invalid messages for ip-dst|port, ip-
  src|port and hostname|port. [Jakub Onderka]
- [validation] Simplify composite validation. [Jakub Onderka]
- [copyright] AUTHORS updated. [Alexandre Dulaunoy]
- [copyright] date fixed and top 6 contributors added as copyright
  holder. [Alexandre Dulaunoy]
- [PyMISP] latest version. [Alexandre Dulaunoy]
- [PyMISP] bump version (new telfhash type added) [Alexandre Dulaunoy]
- [cookie] Set session cookie SameSite to Lax to avoid browser warnings.
  [Jakub Onderka]
- [UI] Optimise loading contributors orgs. [Jakub Onderka]
- [UI] Nicer icon for quick edit buttons. [Jakub Onderka]
- [UI] Use quick select for objects UUID. [Jakub Onderka]
- [UI] Enrichment for proposals doesn't exists. [Jakub Onderka]
- [UI] Use nicer icon for accept proposal. [Jakub Onderka]
- [UI] Put space between object action icons. [Jakub Onderka]
- [internal] Provide better exception messages for signing and
  encrypting. [Jakub Onderka]
- [validation] Provide more precise and faster attribute validation.
  [Jakub Onderka]
- [internal] URL is already defang in ComplexTypeTool. [Jakub Onderka]
- [UI] Validate object when revising. [Jakub Onderka]
- [misp-warning] updated to the latest version. [Alexandre Dulaunoy]
- [internal] Do not fetch event reports for view. [Jakub Onderka]
- [internal] Merge EventReports for extended view. [Jakub Onderka]
- [internal] Optimise event fetching. [Jakub Onderka]
- [internal] Cleanup and simplify ShadowAttribute model code. [Jakub
  Onderka]
- [freetext] Send textarea on CMD+ENTER or CTRL+ENTER. [Jakub Onderka]
- [freetext] Nicer remove icon. [Jakub Onderka]
- [UI] Focus freetext textarea after opening popover. [Jakub Onderka]
- [freetext] Process just big number of attributes in background. [Jakub
  Onderka]
- [UI] Better description for password popover. [Jakub Onderka]
- [UI] Automatically select privacy target when is marked as quick
  select. [Jakub Onderka]
- [UI] Allow quickSelect organisation UUID. [Jakub Onderka]
- [UI] Fix some bugs in user view. [Jakub Onderka]
- [internal] Simplified AttributesController::hoverEnrichment method.
  [Jakub Onderka]
- [internal] More checks in Module model. [Jakub Onderka]
- [UI] Show nice pgp form font. [Jakub Onderka]
- [UI] Make external links more secure. [Jakub Onderka]
- [UI] Show error message for hover enrichment when something wrong
  happen. [Jakub Onderka]
- [UI] Put title for hover enrichment icon. [Jakub Onderka]
- [internal] Move hover enrichment script to misp.js. [Jakub Onderka]
- [UI] Better log when for empty results for enrichment. [Jakub Onderka]
- [UI] Make link clickable in enrichment. [Jakub Onderka]
- [UI] Show loading icon when enrichment. [Jakub Onderka]
- [UI] Limit enrichment popover size. [Jakub Onderka]
- [internal] Use async version when fetching enrichment popover. [Jakub
  Onderka]
- [UI] Change design of attribute hover. [Jakub Onderka]
- [internal] Better error messages for unzipping feed file. [Jakub
  Onderka]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [UI] Break words when showing long value in popup. [Jakub Onderka]
- [UI] Use "raw" view for long URLs. [Jakub Onderka]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [UI] Rename Email to Creator user in event index. [Jakub Onderka]
- [UI] Keep term when searching for attribute. [Jakub Onderka]
- [UI] Uppercase ID for event list. [Jakub Onderka]
- [internal] Do not show attribute warning when searching attributes.
  [Jakub Onderka]
- [UI] Support quick select for UUID. [Jakub Onderka]
- [UI] Move privacy toggle code to misp.js. [Jakub Onderka]
- [UI] Focus proposal when going from proposals index. [Jakub Onderka]
- [UI] Use hires icons for event page. [Jakub Onderka]
- [UI] HTML code cleanup. [Jakub Onderka]
- [internal] Validate sighting UUID. [Jakub Onderka]
- [internal] Remove unused code. [Jakub Onderka]
- [internal] Optimise sightings fetching. [Jakub Onderka]
- [internal] Much faster attribute search. [Jakub Onderka]
- [appmodel] Set default value for warninglist_entry_count. [mokaddem]
- [internal] Clean up EventsController::view code. [Jakub Onderka]
- [internal] Remove not necessary GalaxyCluster initialization. [Jakub
  Onderka]
- [internal] Initialize Sighting class just when necessary. [Jakub
  Onderka]
- [optimisation] Load MISP version and commit just once. [Jakub Onderka]
- [internal] Optimise fetching sightings for object. [Jakub Onderka]
- [internal] Use ACL also for side menu. [Jakub Onderka]
- [internal] Move more global menu rules to ACLComponent. [Jakub
  Onderka]
- [internal] Use ACLComponent for menu item permission. [Jakub Onderka]
- [warninglist] Use faster method for fetching data from Redis. [Jakub
  Onderka]
- [warninglist] Hash key in binary and store just for one hour. [Jakub
  Onderka]
- [internal] Fix for exact string match. [Jakub Onderka]
- [internal] Normalize CIDR and hostname warninglists. [Jakub Onderka]
- [internal] Simplified Warninglist::__checkValue. [Jakub Onderka]
- [internal] Change method name to show that it just filter one attr.
  [Jakub Onderka]
- [internal] Save memory when storing warninglist to cache. [Jakub
  Onderka]
- [internal] Start IPv4 checking from zero. [Jakub Onderka]
- [internal] Warninglist code cleanup. [Jakub Onderka]
- [internal] Fix event warnings without redis cache. [Jakub Onderka]
- [internal] Move getting missing tlds list to model. [Jakub Onderka]
- [internal] Refactoring warninglist loading and saving. [Jakub Onderka]
- [internal] Simplified Event::__prepare... methods. [Jakub Onderka]
- [internal] Attach warnings to proposals. [Jakub Onderka]
- [internal] Rename Warninglist::simpleCheckForWarning to
  checkForWarning. [Jakub Onderka]
- [complextype] Support for uppercase hashes. [Jakub Onderka]
- [complextype] Speedup hash parsing from CSVs and freetexts. [Jakub
  Onderka]
- [community] add the pisax.org logo. [Alexandre Dulaunoy]
- [community] new pisax.org community added. [Alexandre Dulaunoy]
- [cleanup] removed duplicate empty queue declaration. [Andras Iklody]
- [appModel] Removed prio worker from the list of available workers to
  perform an update. [mokaddem]
- [PyMISP] bump to latest version. [Alexandre Dulaunoy]
- [Shell] Add MISP.osuser for updates. Fix #6368. [Richard van den Berg]
- [markdownEditor] Adapt popover container if inside modal. [mokaddem]
- [eventReports:markdownEditor] UI indication when hinting object's
  Attribute. [mokaddem]
- [eventReport:markdownEditor] Improved invalid element UI. [mokaddem]
- [mardownEditor] Added loading backdrop container. [mokaddem]
- [eventReport:markdownEditor] Fetch MISP elements with a different
  request. [mokaddem]
- [eventReport:markdownEditor] Changed popover's container. [mokaddem]
- [eventReport:markdownEditor] Improved layout for invalid MISP
  Elements. [mokaddem]
- [eventReports:helpModal] Fixed some typos. [mokaddem]
- [events] Simplified attribute_count condition for `minimal` filter
  parameter. [mokaddem]
- [event:updateEventReportBeforeSync] Make sure remote instance supports
  event report. [mokaddem]
- [eventReport] Added entry in restResponseComponent. [mokaddem]
- [eventReport:markdownEditor] Propose hints based on substring instead
  of start of the value. [mokaddem]
- [eventReport:markdownEditor] Improved rendered object layout.
  [mokaddem]
- [eventReport:markdownEditor] Improved rendered attribute layout.
  [mokaddem]
- [eventReport:markdownEditor] Allow fetching tag data even if it isn't
  created on the instance. [mokaddem]
- [eventReport:markdownEditor] Improved hint UI. [mokaddem]
- [eventReport:markdownEditor] Improved cluster representation.
  [mokaddem]
- [eventReport:markdownEditor] Increased the debounce delay when
  fetching tags. [mokaddem]
- [eventReport] Added entry for referencing tags in markdownEditor's
  help modal. [mokaddem]
- [internal] Simplified menu code. [Jakub Onderka]
- [eventReport] Removed support of eventGraph. [mokaddem]

  - eventGraph can still be used as with attribute picture attachment
- [eventReport] Replace ID by UUID when referencing MISP Elements.
  [mokaddem]
- [missing attachment log] added affected orgs. [iglocska]
- [warning lists] updated to the latest version. [Alexandre Dulaunoy]
- [missing attachments] debug tool now logs event / attribute IDs.
  [iglocska]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- [correlations] Really limit number of correlations, not number of
  attributes. [Jakub Onderka]
- [internal] Initialize Job class just once. [Jakub Onderka]
- [internal] Delete Redis key in pipeline. [Jakub Onderka]
- [feed] Faster feed list fetching. [Jakub Onderka]
- [correlations] Fetch just server of feed that has data in Redis.
  [Jakub Onderka]
- [correlations] Allow to get more info about feed correlations also for
  host org users. [Jakub Onderka]
- [correlations] Refactor feed cached correlations. [Jakub Onderka]
- Bumped queryversion. [mokaddem]
- [UI] Nicer warning box with link to show just warnings. [Jakub
  Onderka]
- [internal] Initialize Log model just once. [Jakub Onderka]
- [internal] Move addMISPExportFile from controller to model. [Jakub
  Onderka]
- [internal] Move hex value convertor to misp.js. [Jakub Onderka]
- [test] Lint all PHP and template files. [Jakub Onderka]
- [UI] Show event creator for users within event org. [Jakub Onderka]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [eventReports:markdownEditor] Suggests available scope to references
  MISP Elements. [mokaddem]
- [eventReports] Updated markdownEditor help modal. [mokaddem]
- [eventReport] Added support of all galaxy matrixes. [mokaddem]
- [eventReports] Event reports in modal use the generic views.
  [mokaddem]
- [eventReport] Added rearrange function. [mokaddem]
- [events:index] Minimal searches returns events having event reports
  and no attributes. [mokaddem]
- [appmodel] Make sure to trigger the event report db update. [mokaddem]
- [UI] Show full title for role permission. [Jakub Onderka]
- [mail] Another code cleanup for alert and contact mails template.
  [Jakub Onderka]
- [mail] Use same format for contact email as for alert. [Jakub Onderka]
- [mail] Add unsubscribe info also for non encrypted mails. [Jakub
  Onderka]
- [mail] Simplified mail generation. [Jakub Onderka]
- [mail] Cleanup mail sending code for event alerts. [Jakub Onderka]
- [mail] TLP in subject should be uppercase. [Jakub Onderka]
- [internal] Simplify objects conditions. [Jakub Onderka]
- [internal] Use cached sharing groups IDs when fetching objects. [Jakub
  Onderka]
- [internal] Invalid message for UUID contains that UUID must be RFC
  4122 compliant. [Jakub Onderka]
- [misp-objects] updated. [Alexandre Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [users] Refined login form selector. [mokaddem]
- [log] Convert shadowAtribute's fs/ls into understood format.
  [mokaddem]
- [log] Convert object's fs/ls into understood format. [mokaddem]
- [events:recover_event] Adapt flash message if mock query requested.
  [mokaddem]
- [aclcomponent] Added recovery features in ACLComponent. [mokaddem]
- [event] Forced usage of worker for event recovery. [mokaddem]
- [events] Usage of `fix_login` in restoreDeletedEvents. [mokaddem]
- [warning-lists] regenerated. [Alexandre Dulaunoy]
- [eventreport] Make sure the format is correct when capturing.
  [mokaddem]
- [eventReport] Includes event data when fetching event report from non-
  admin users. [mokaddem]
- [eventReports] Improved returned data from controller. [mokaddem]
- [restResponseComponent] Allow saveFailResponse and saveSuccessResponse
  to return data. [mokaddem]
- [markdownEditor] Split eventReport related code to their own files.
  [mokaddem]
- [markdownEditor] Move markdown editor to a generic file name.
  [mokaddem]
- [eventReport] Added comments. [mokaddem]
- [eventReports] Prevent fields override. [mokaddem]
- [eventReport] Moved event unpublishing to model. [mokaddem]
- [eventReport] Started refactoring model - WiP. [mokaddem]
- [eventReports] Refactored indexes. [mokaddem]
- [eventReports] Major refactoring - WiP. [mokaddem]
- [eventReport] Improved authorization error reporting. [mokaddem]
- [eventReports] Added event unpublishing. [mokaddem]
- [eventReports] Few UI improvements. [mokaddem]
- [server] Allow to sync events if they only have event report.
  [mokaddem]
- [server] Added distribution downgrade for event report sync.
  [mokaddem]
- [eventReport] Generic improvements and light integration with
  fetchEvent and sync support. [mokaddem]
- [eventReports:edit] Improved title. [mokaddem]
- [eventReports] Improved default index and prevent edition if deleted.
  [mokaddem]
- [eventReport] Allow adding event report from the index. [mokaddem]
- [eventReport] Improved deletion/restoration via the API. [mokaddem]
- [eventReport:edit] Allow to edit individual fields and better error
  reporting. [mokaddem]
- [eventReport] Improved sidemenu integration. [mokaddem]
- [eventReports] Added redirects. [mokaddem]
- [markdownEditor] Moved MISP Element rule menu to correct file.
  [mokaddem]
- [markdownEditor] Prevent scrolling top when clicking on menu links.
  [mokaddem]
- [markdownEditor] Line number for scroll sync should be in default js
  file. [mokaddem]
- [eventreport] Set correct context when POSTing report creation.
  [mokaddem]
- [event:view] Automatically open event report table. [mokaddem]
- [eventreports] Reload event report table after report creation.
  [mokaddem]
- [eventReports] Deleted unused file. [mokaddem]
- [eventReport] Improved UI and added support of soft/hard deletion.
  [mokaddem]
- [eventReport] Started rework on CRUD operations - WiP. [mokaddem]
- [markdownEditor] Increased debounced render timer. [mokaddem]
- [markdownEditor] highlight unsaved changes. [mokaddem]
- [markdownEditor] Support of lastmodified and UI improvements when
  saving. [mokaddem]
- [markdownEditor] Fixes z-index if viewport too small. [mokaddem]
- [markdownEditor] Added support of trailing characters such as `.`
  after MISP element reference. [mokaddem]
- [markdownEditor] Renamed markdownViewer into markdownEditor and split
  web deps from view file. [mokaddem]
- [markdownViewer] Added cache for attackmatrix and eventgraph.
  [mokaddem]
- [markdownViewer] Improved perfs and light support of permissions.
  [mokaddem]
- [eventReport] Centralized elements proxy for markdownViewer.
  [mokaddem]
- [markdownViewer] Displayed objects show the attribute with highest ui-
  priority. [mokaddem]
- [markdownViewer] Improved popover placement. [mokaddem]
- [markdownViewer] Added help for plugins. [mokaddem]
- [markdownViewer] Improved object rendering. [mokaddem]
- [markdownViewer] Improved attribute rendering. [mokaddem]
- [markdownViewer] Simplified help. [mokaddem]
- [markdownViewer] Add support of colors  in attack matrix when
  printing. [mokaddem]
- [markdownViewer] Improved help. [mokaddem]
- [markdownViewer] Added more help. [mokaddem]
- [markdownViewer] Added support of attack matrix. [mokaddem]
- [markdownViewer] Added toggles in editor bottom bar. [mokaddem]
- [markdownViewer] Added notice if couldn't fetch event graph.
  [mokaddem]
- [markdownViewer] Improved support of eventgraph. [mokaddem]
- [markdownViewer] Added drafty support of event graph. [mokaddem]
- [markdownViewer] Added block picture in viewer and text in help.
  [mokaddem]
- [markdownViewer] Added dismiss button for popover. [mokaddem]
- [markdownViewer] Popover support of MISP Elements. [mokaddem]
- [markdownViewer] Checkbox for autocomplete while typing. [mokaddem]
- [markdownViewer] Added more shortcuts. [mokaddem]
- [markdownViewer] Slightly improved help modal. [mokaddem]
- [markdownViewer] Added help modal. [mokaddem]
- [markdownViewer] Ask confirmation before saving. [mokaddem]
- [markdownViewer] Added download button for pdf and md (both types)
  [mokaddem]
- [eventReports:view] Added link to event. [mokaddem]
- [markdownViewr] Autocomplete triggers automatically when typing.
  [mokaddem]
- [markdownViewer] Improve hint suggestions for MISP Elements.
  [mokaddem]
- [markdownViewer] Improved top bar UI and added editor helpers.
  [mokaddem]
- [eventReport] Improved integration with event index. [mokaddem]
- [markdownViewer] Added custom rendering for MISP elements. [mokaddem]
- [markdownViewer] Improved scroll map in modal. [mokaddem]
- [markdownViewer] Improved layout and added draft of sync-scroll.
  [mokaddem]
- [markdownViewer] Improved split layout. [mokaddem]
- [infoModal] Added support of xl modal body. [mokaddem]
- [markdownViewer] Improved layout with resizer. [mokaddem]
- [markdownViewer] Improved layout and added codemirror addons.
  [mokaddem]
- [markdownEditor] Added codemirror dependency. [mokaddem]
- [markdownViewer] Added syntax highlighing. [mokaddem]
- [markdownView] Improved layout. [mokaddem]
- [eventReport] Improved models and markdown editor. [mokaddem]
- [eventReport] Added markdown-it dependency and started integration -
  WiP. [mokaddem]
- [eventReport] Continuation of implementation - WiP. [mokaddem]

Fix
~~~
- [server] caching notice fixed. [iglocska]
- [UI] Do not show quick edit for deleted attributes and when user don't
  have permission. [Jakub Onderka]
- [UI] Show error for user if activateField request fail. [Jakub
  Onderka]
- [eventReport] Include just tags that belongs to requested event or its
  parent, not to other child. [Jakub Onderka]
- [eventReport] Properly validate UUID. [Jakub Onderka]
- [eventReport] Optimize loading by UUID. [Jakub Onderka]
- [eventReport] Template loading condition. [Jakub Onderka]
- [UI] Remove checkbox from objects. [Jakub Onderka]
- [UI] Correctly remove checked attributes after page reload. [Jakub
  Onderka]
- [internal] Missing variable. [Jakub Onderka]
- [internal] Remove unnecessary class initialization. [Jakub Onderka]
- [UI] Remove space after referecence link. [Jakub Onderka]
- [UI] Reset popover box after closing. [Jakub Onderka]
- [UI] Remove underline from icons. [Jakub Onderka]
- [validation] Correct validation for iban, bic, btc, dash and xmr
  attributes. [Jakub Onderka]
- [validation] Normalize mac-address and mac-eui-64 to lowercase. [Jakub
  Onderka]
- [validation] Do not accept floats where should be just integers.
  [Jakub Onderka]
- [correlations] Disable correlation for port part in hostname|port
  type. [Jakub Onderka]
- [stix1 framing] Added Custom objects namespace. [chrisr3d]
- [UI] Set title for atomic/extended switch. [Jakub Onderka]
- [UI] Put current language to HTML element. [Jakub Onderka]
- [UI] Element ID must be unique. [Jakub Onderka]
- [UI] Try to fix broken form quick edit submit with CTRL+ENTER. [Jakub
  Onderka]
- [UI] Provide description for pivot remove button. [Jakub Onderka]
- [UI] Provide description for search button. [Jakub Onderka]
- [UI] Remove unused parts from row_proposal template. [Jakub Onderka]
- [UI] Remove objectType is zero checks. [Jakub Onderka]
- [UI] Normalize quck add attribute for object with other forms. [Jakub
  Onderka]
- [UI] Change new object attribute information margin. [Jakub Onderka]
- [UI] objectAddFieldTr should not cover checkbox. [Jakub Onderka]
- [UI] Proposal to delete should be considered as proposal. [Jakub
  Onderka]
- [UI] Make proposal links visible. [Jakub Onderka]
- [UI] Nicer proposal HTML code. [Jakub Onderka]
- [UI] Base url for OrgImgHelper. [Jakub Onderka]
- [UI] Show warning if notification when creating new user could not be
  send. [Jakub Onderka]
- [UI] Provide proper description for S/MIME cert. [Jakub Onderka]
- [internal] Properly convert `hostname|port` when delimiter is `:`
  [Jakub Onderka]
- [validation] Convert vulnerability attribute to uppercase. [Jakub
  Onderka]
- [validation] Float validation. [Jakub Onderka]
- [mail] S/MIME certificate validation, fixes #6424. [Jakub Onderka]
- [freetext] Do not load event page twice when saving freetext. [Jakub
  Onderka]
- [UI] Add space after icon. [Jakub Onderka]
- [UI] Non breakable space between hidden value and icon. [Jakub
  Onderka]
- [UI] Remove not used organisation landing page. [Jakub Onderka]
- [internal] Remove unused $page variable. [Jakub Onderka]
- [UI] Do not hide some errors. [Jakub Onderka]
- [internal] Check if module has defined userConfig. [Jakub Onderka]
- [db_schema] Bumped schema with the changes. [mokaddem]
- [eventReports] Renamed function to make it more explicit and avoid
  function name override. [mokaddem]
- [ACLComponent] Added missing entry and removed invalid warnings.
  [mokaddem]
- [UI] Hover enrichment popover overflowing. [Jakub Onderka]
- [UI] Remove margin from long value pre. [Jakub Onderka]
- [internal] Array to string conversion when constructing request.
  [Jakub Onderka]
- [freetext] Convert CVE string to uppercase to follow attribute
  validation. [Jakub Onderka]
- [UI] Bigger margin for extend this event button. [Jakub Onderka]
- [UI] Clear input value when clicking cancel for attribute search.
  [Jakub Onderka]
- [UI] #attributesFilterField doesn't exists anymore. [Jakub Onderka]
- [UI] Show loading also for down attribute paginator. [Jakub Onderka]
- [UI] Remove unnecessary br from eventattribute template. [Jakub
  Onderka]
- [UI] Remove unused page argument for sighting form. [Jakub Onderka]
- [UI] Fix IDS toggle permission in attribute view. [Jakub Onderka]
- [UI] Return back sighting popover. [Jakub Onderka]
- [UI] Remove duplicate request for quick filter. [Jakub Onderka]
- [UI] Disable To IDS checkbox if user don't have persmission to modify
  event. [Jakub Onderka]
- [internal] Removed unused template. [Jakub Onderka]
- [UI] Use pointer cusros for template choice button. [Jakub Onderka]
- [decayingModelSimulation] Correctly extract part of atomic tags.
  [mokaddem]
- [tags:attachTagToObject] Respect case when searching tags. [mokaddem]
- [tags:attachTagsToObject] Respect case when attaching tags. Fix #6380.
  [mokaddem]
- [UI] Showing active menu item when viewing noticelist. [Jakub Onderka]
- [UI] Showing item in side menu for org admin. [Jakub Onderka]
- [UI] Check more menu ACLs. [Jakub Onderka]
- [UI] Do not show empty global menu item. [Jakub Onderka]
- [UI] User guide link. [Jakub Onderka]
- [warnings] enforceWarninglist works again. [Jakub Onderka]
- [warnings] Cache deletion. [Jakub Onderka]
- [warninglists] Include warning for merged events. [Jakub Onderka]
- [warnings] Attach warnings to feed and server event preview. [Jakub
  Onderka]
- [internal] IPv6 CIDR warninglist. [Jakub Onderka]
- [server:workerDiagostics] Default queue status to false. [mokaddem]
- [tag filters] fixed ridiculously long lists for tag filters.
  [iglocska]
- [CLI] missing ; [iglocska]
- [server] Do not limit TLD to 5 characters. Fix #6342. [Richard van den
  Berg]
- [internal] Variable should be defined all the time. [Jakub Onderka]
- [proposal] No return when org is not defined. [Jakub Onderka]
- [eventReports:markdownEditor] Force close the popover if parent
  element not found. [mokaddem]
- [eventReport] Do not try to fetch report after successful hard
  deletion. [mokaddem]
- [markdownEditor] Reset width in editor's split mode when swiching to
  fullscreen. [mokaddem]
- [eventReport:markdownEditor] render markdown once MISP elements have
  been fetched. [mokaddem]
- [eventReport] Improved variable name and do not crash if event is not
  extending another one. [mokaddem]
- [eventReports] Typo in variable name. [mokaddem]
- [markdownEditor] Layout glitch with resizeable helper and fullscreen.
  [mokaddem]
- [misp] Allow re-showing hidden popover after creation. [mokaddem]
- [eventReports:index] Fixed quicksearches. [mokaddem]
- [eventReport:markdowEditor] Make add galaxy-matrix shortcut works.
  [mokaddem]
- [server:push] Correctly return message when using API. [mokaddem]
- [event:push] Setup requests headers before sending request. [mokaddem]
- [server:push] Allow pushing events only having event reports.
  [mokaddem]
- [event:updateEventReportBeforeSync] Init httpSocket. [mokaddem]
- [tags:search] Make sure the predicate exists in the taxonomy.
  [mokaddem]
- [eventReport:markdownEditor] Improved colors of attributes and objects
  in printing view. [mokaddem]
- [eventReport:markdownEditor] Parse all tags in a line instead of the
  last one. [mokaddem]
- [eventReport:markdownEditor] Avoid override of legitimate tags if they
  don't have data linked to them. [mokaddem]
- [eventReport:markdownEditor] Prevent error while opening popover for
  unknown tags. [mokaddem]
- [doc] Document "cake Server pullAll" [Richard van den Berg]
- [attachment checker] invalid lookup. [iglocska]
- [missing attachment log] fixed issue with orgs not being logged.
  [iglocska]
- [attachment checks] output of logging cleaned up. [iglocska]
- [events] Added loading indicator when paginating on event's attribute
  table. [mokaddem]
- [hacky] readded org field to shadow attributes - just blank it out for
  old instances where the update failed to remove it a few years ago.
  [iglocska]
- [sync] better logging of error messages and handle the user ID not
  being set by background processes. [iglocska]
- [correlations] Properly delete feeds caches. [Jakub Onderka]
- [internal] Remove duplicates from cancelPopoverForm. [Jakub Onderka]
- [UI] Popup size. [Jakub Onderka]
- [decaying] 2-tag base_score ratio. Fix #6352. [mokaddem]
- [attribute] Typo in regex. Fix #6354. [mokaddem]
- [UI] Make attribute/object focus work again. [Jakub Onderka]
- [internal] Remove dead code from template. [Jakub Onderka]
- [internal] Undefined variable base_url for idTranslator. [Jakub
  Onderka]
- [UI] Show error for user if file for import is invalid. [Jakub
  Onderka]
- [UI] Hex and binary convertor. [Jakub Onderka]
- [UI] Show properly formatted attribute value after quick edit. [Jakub
  Onderka]
- [UI] Show proper menu when using even import module. [Jakub Onderka]
- [internal] Prepare for PHP8. [Jakub Onderka]
- [internal] Fix tests for missing ACL. [Jakub Onderka]
- [UI] Custom password reset link is absolute. [Jakub Onderka]
- [internal] Typo in perm name. [Jakub Onderka]
- [internal] Do not fetch more info than necessary. [Jakub Onderka]
- [eventReports] Use correct data path to access org_c. [mokaddem]
- [eventReport] Deleted report can be restored by non-admin users.
  [mokaddem]
- [ACL] Permissions when sending contact and alert emails. [Jakub
  Onderka]
- [internal] Conditions when object distribution is set to org only.
  [Jakub Onderka]
- [internal] Fetching objects with attachments. [Jakub Onderka]
- [internal] Remove duplicate check for published event when fetch
  objects. [Jakub Onderka]
- [internal] Remove duplicate conditions for object restSearch. [Jakub
  Onderka]
- [internal] Code style. [Jakub Onderka]
- [internal] Invalid conditions for sharing group when fetching objects.
  [Jakub Onderka]
- [internal] Bad merge. [Jakub Onderka]
- [server] Downgrade distribution of objects when pulling. [mokaddem]
- [recovery] various fixes. [iglocska]

  - to_ids fixed
  - background processing made optional
  - first/last seen format conversion altering the data's format for the recovery script fixed
  - added capture of object first/last seen to the recovery script
- [log:event_recovery] Delete blocklist entry for recovered event.
  [mokaddem]
- [objectReference] Do no reset timestamp to current time if already
  provided. [mokaddem]
- [log] Convert attribute's fs/ls into understood format. [mokaddem]
- [events:recover_event] Fixed URL. [mokaddem]
- [merge issue] resolved. [iglocska]
- [attributes] Restored action on tags in mass edit. [mokaddem]
- Added missing test mechanisms mapping mapping. [chrisr3d]
- [validation] make publish_timestamp on the event object more resilient
  to malformed empty values. [iglocska]
- [eventReport] Do not ignore `false` fields when editing. [mokaddem]
- [event] Delete event report when deleting event. [mokaddem]
- [eventReport] changed beforeFilter signature to avoid notice.
  [mokaddem]
- [eventReports] Add view variables before rendering. [mokaddem]
- [event] Use correct function name. [mokaddem]
- [markdownEditor] Make viewer works inside modal. [mokaddem]
- [markdownEditor] Post split bugs. [mokaddem]
- [markdownViewer] Fixed missing event_id. [mokaddem]
- [markdownViewer] Regenerate scroll map after resize + layout
  improvement. [mokaddem]
- [datetime] Failed merge. [mokaddem]
- [attribute tag culling] fixed. [iglocska]

  - no longer hides tags that should be included in the export

Other
~~~~~
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Raphaël Vinot]
- Merge branch 'tagfix' into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into HEAD. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge pull request #6414 from JakubOnderka/user-view-ui. [Jakub
  Onderka]

  Flag icons and country list
- Merge branch '2.4' into event-report-optimisations. [mokaddem]
- Merge pull request #6447 from JakubOnderka/as-normalization.
  [Alexandre Dulaunoy]

  chg: [internal] Normalize AS type to asplain notation
- Merge pull request #6446 from JakubOnderka/module-import-speedup.
  [Jakub Onderka]

  chg: [internal] Speedup sending module results
- Merge pull request #6289 from JakubOnderka/save-sighting-optim. [Jakub
  Onderka]

  chg: [internal] Sighting saving optimisation
- Merge pull request #6442 from JakubOnderka/event-ui-vol4. [Jakub
  Onderka]

  Event UI fixes vol4
- Merge pull request #6416 from JakubOnderka/event-view-fix. [Alexandre
  Dulaunoy]

  Remove object checkbox
- Merge pull request #6440 from JakubOnderka/event-ui-vol3. [Jakub
  Onderka]

  Event ui vol3
- Merge pull request #6439 from nighttardis/2.4. [Jakub Onderka]

  Syntax fix for session.cookie_samesite
- Merge pull request #1 from nighttardis/nighttardis-core-php-syntax.
  [nighttardis]

  Update core.default.php
- Update core.default.php. [nighttardis]

  Fixing PHP syntax error that appears on PHP 7.4
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge pull request #6436 from JakubOnderka/attribute-validation.
  [Jakub Onderka]

  Attribute validation
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge pull request #6429 from cudeso/2.4. [Alexandre Dulaunoy]

  Send a message to ZMQ when an event from a connected server is added or edited
- Send message to ZMQ when there is event add/edit coming from a
  connected server. [Koen Van Impe]
- Merge remote-tracking branch 'MISP/2.4' into 2.4. [Koen Van Impe]
- Merge pull request #6438 from JakubOnderka/hostname-port-correlation.
  [Jakub Onderka]

  fix: [correlations] Disable correlation for port part in hostname|port
- Merge pull request #6400 from JakubOnderka/cookie-samesite-lax. [Jakub
  Onderka]

  chg: [cookie] Set session cookie SameSite to Lax to avoid browser warnings
- Merge pull request #6423 from JakubOnderka/view-event-small-ui-
  changes. [Jakub Onderka]

  View event small ui changes
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge pull request #6432 from JakubOnderka/smime. [Jakub Onderka]

  Smime
- Merge pull request #6418 from JakubOnderka/revise-object-validation.
  [Jakub Onderka]

  Revise object validation
- Merge pull request #6425 from JakubOnderka/fix-smime-certificate-
  validation. [Jakub Onderka]

  fix: [mail] S/MIME certificate validation
- Merge pull request #6417 from JakubOnderka/fetch-event-optimisation.
  [Jakub Onderka]

  Fetch event optimisation
- Merge pull request #6422 from JakubOnderka/shadow-attribute-code-
  cleanup. [Jakub Onderka]

  chg: [internal] Cleanup and simplify ShadowAttribute model code
- Merge pull request #6421 from JakubOnderka/freetext-background. [Jakub
  Onderka]

  Freetext background processing
- Merge pull request #6420 from JakubOnderka/user-organisation-ui-
  changes. [Jakub Onderka]

  User and organisation pages UI changes
- Merge pull request #6419 from JakubOnderka/event-template-cleanup.
  [Jakub Onderka]

  fix: [internal] Remove unused $page variable
- Merge pull request #6395 from JakubOnderka/module-fixes. [Jakub
  Onderka]

  Module fixes
- Merge pull request #6300 from JakubOnderka/validate-gpg-key. [Jakub
  Onderka]

  Validate gpg key
- Merge pull request #6413 from JakubOnderka/external-links-secure.
  [Jakub Onderka]

  chg: [UI] Make external links more secure
- Merge pull request #6412 from mokaddem/feature-event-report.
  [Alexandre Dulaunoy]

  [feature] Event Report
- Merge remote-tracking branch 'origin/2.4' into feature-event-report.
  [mokaddem]
- Merge pull request #6405 from JakubOnderka/hover-ui. [Jakub Onderka]

  Change hover enrichment user interface
- Merge pull request #6397 from JakubOnderka/zip-error-messages. [Jakub
  Onderka]

  chg: [internal] Better error messages for unzipping feed file
- Merge pull request #6398 from JakubOnderka/ui-long-values-vol2. [Jakub
  Onderka]

  fix: [UI] Remove margin from long value pre
- Merge pull request #6393 from JakubOnderka/ui-long-values. [Jakub
  Onderka]

  Ui long values
- Merge pull request #6394 from JakubOnderka/fix-array-to-string-
  conversion. [Jakub Onderka]

  fix: [internal] Array to string conversion when constructing request
- Merge pull request #6396 from JakubOnderka/freetext-cve-import. [Jakub
  Onderka]

  fix: [freetext] Convert CVE string to uppercase
- Merge pull request #6381 from JakubOnderka/ui-small-fixes-vol2. [Jakub
  Onderka]

  UI small fixes
- Merge pull request #6385 from JakubOnderka/sighting-fetch-optim.
  [Jakub Onderka]

  Sighting fetch optim
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge pull request #6388 from JakubOnderka/attribute-search-optim.
  [Jakub Onderka]

  chg: [internal] Much faster attribute search
- Merge pull request #6384 from JakubOnderka/event-load-optim. [Jakub
  Onderka]

  Event load optim
- Merge pull request #6348 from JakubOnderka/version-fetch-optim. [Jakub
  Onderka]

  chg: [optimisation] Load MISP version and commit just once
- Merge pull request #6382 from JakubOnderka/fetch-sightings-faster.
  [Jakub Onderka]

  chg: [internal] Optimise fetching sightings for object
- Merge pull request #6359 from JakubOnderka/acl-menu-item. [Jakub
  Onderka]

  Acl menu item
- Merge pull request #6335 from JakubOnderka/warninglist-cache. [Jakub
  Onderka]

  Warninglist Redis cache
- Merge pull request #6378 from JakubOnderka/feed-metadata-validation.
  [Jakub Onderka]

  new: [build] Validate also feed metadata rules and settings JSON contents
- Merge branch 'fetcher_debug' into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into fetcher_debug.
  [iglocska]
- Merge pull request #6377 from JakubOnderka/freetext-hash-parsing.
  [Jakub Onderka]

  chg: [complextype] Speedup hash parsing from CSVs and freetexts
- Merge pull request #6370 from MISP/fix-update-no-prio. [Andras Iklody]

  Fix update no prio
- Update Server.php. [Andras Iklody]
- Merge pull request #6373 from RichieB2B/issue-6368. [Andras Iklody]

  Allow OS user to be set for upgrades
- Merge pull request #6375 from RichieB2B/issue-6342. [Andras Iklody]

  Do not limit TLD to 5 characters
- Merge pull request #6374 from JakubOnderka/test-fix. [Jakub Onderka]

  Test fix
- Merge branch '2.4' of github.com:MISP/MISP into feature-event-report.
  [mokaddem]
- Merge pull request #6360 from JakubOnderka/menu-simplified. [Jakub
  Onderka]

  chg: [internal] Simplified menu code
- Merge pull request #6372 from RichieB2B/ncsc-nl/pullAll. [Andras
  Iklody]

  Document "cake Server pullAll"
- Merge pull request #6362 from imidoriya/2.4. [Andras Iklody]

  Fix date filter on to / from #6239
- Filter Event Date - convert timestamp to datetime. [deku]

  PyMisp sends the to / from as a timestamp.  MISP needs to convert a timestamp when comparing.
- Merge branch '2.4' of github.com:MISP/MISP into feature-event-report.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Revert "fix: [tag] Show correct count of tag attributes and events"
  [iglocska]

  This reverts commit e644f4ea4c01e1f8018133d2a82aa3c321fff98d.
- Revert "chg: [internal] Optimise fetching sightings for object"
  [iglocska]

  This reverts commit e442a394cd4ee7e3797151d8146992d4b1a2bee6.
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge pull request #6357 from JakubOnderka/feed-correlation-refactor.
  [Jakub Onderka]

  chg: [correlations] Refactor feed cached correlations
- Merge pull request #6346 from JakubOnderka/truncate-long-values.
  [Jakub Onderka]

  Truncate long values
- Merge pull request #6345 from JakubOnderka/pivot-directly. [Jakub
  Onderka]

  new: [UI] Go directly to object reference when referenced object is on the same page
- Merge pull request #6350 from rmkml/2.4. [Andras Iklody]

  fix #6336 vhash
- Fix #6336 vhash. [rmkml]
- Merge pull request #6351 from JakubOnderka/template-dead-code. [Jakub
  Onderka]

  Template dead code
- Merge pull request #6333 from JakubOnderka/id-translator-fix. [Jakub
  Onderka]

  fix: [internal] Undefined variable base_url for idTranslator
- Merge pull request #6349 from JakubOnderka/warninglist-box. [Jakub
  Onderka]

  chg: [UI] Nicer warning box with link to show just warnings
- Merge pull request #6344 from JakubOnderka/misp-file-import. [Jakub
  Onderka]

  Misp file import error message
- Merge pull request #6347 from JakubOnderka/hex-binary-convertor.
  [Jakub Onderka]

  Hex binary convertor
- Merge pull request #6343 from JakubOnderka/after-attribute-edit.
  [Jakub Onderka]

  fix: [UI] Show properly formatted attribute value after quick edit
- Merge pull request #6340 from JakubOnderka/import-ui. [Jakub Onderka]

  fix: [UI] Show proper menu when using even import module
- Merge pull request #6339 from JakubOnderka/lint. [Jakub Onderka]

  chg: [test] Lint all PHP and template files
- Merge pull request #6338 from JakubOnderka/password-reset-absolute.
  [Jakub Onderka]

  fix: [UI] Custom password reset link is absolute
- Merge pull request #6334 from JakubOnderka/role-typo-fix. [Jakub
  Onderka]

  fix: [internal] Typo in perm name
- Merge pull request #6330 from JakubOnderka/event-creator. [Jakub
  Onderka]

  chg: [UI] Show event creator for users from event org
- Merge pull request #6331 from RichieB2B/ncsc-nl/spaces. [Andras
  Iklody]

  Remove extraneous spaces from E-mail subject
- Remove extraneous spaces from E-mail subject. [Richard van den Berg]
- Merge remote-tracking branch 'origin/2.4' into feature-event-report.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #6328 from JakubOnderka/role-ui-full-label. [Jakub
  Onderka]

  chg: [UI] Show full title for role permission
- Merge pull request #6090 from JakubOnderka/tlp-uppercase. [Jakub
  Onderka]

  chg: [mail] Refactor email generating
- Merge pull request #6327 from JakubOnderka/fix-object-conditons-vol2.
  [Jakub Onderka]

  fix: [internal] Conditions when object distribution is set to org only
- Merge pull request #6326 from JakubOnderka/fix-object-conditions.
  [Jakub Onderka]

  Fix object conditions
- Merge branch 'event_recovery' into 2.4. [iglocska]
- Merge branch '2.4' into event_recovery. [iglocska]
- Merge pull request #6325 from rmkml/2.4. [Alexandre Dulaunoy]

  fix #6266 vhash &
- Fix #6266 vhash & [rmkml]
- Merge pull request #6322 from JakubOnderka/invalid-uuid-message.
  [Jakub Onderka]

  chg: [internal] Invalid message for UUID contains that UUID must be RFC 4122
- Merge pull request #6315 from eschultze/2.4. [Alexandre Dulaunoy]

  Fix id 117 column number
- Fix id 117 column number. [eschultze]
- Merge branch 'event_recovery' of github.com:MISP/MISP into
  event_recovery. [iglocska]
- Merge branch 'event_recovery' of github.com:MISP/MISP into
  event_recovery. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into event_recovery.
  [iglocska]
- Merge branch '2.4' into event_recovery. [iglocska]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' into event_recovery. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into feature-event-report.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into feature-event-report.
  [mokaddem]


v2.4.132 (2020-09-15)
---------------------

Changes
~~~~~~~
- [version] bump. [iglocska]
- [queryversion] Bumped. [mokaddem]
- [bootstrap-datepicker] Updated to version 1.9.0. [mokaddem]
- [appmodel] New entry to create an upper bound for the unwanted action
  through login. [mokaddem]

  This will be used by recovery scripts
- [sightings] anonymise pushed sightings using new
  Sightings_anonymise_as setting. [Richard van den Berg]
- [events] Make sure the fetched form is hidden. [mokaddem]
- [events] Index table delete buttons switch to fetch then post.
  [mokaddem]
- [internal] Better error handling when pushing event to remote server.
  [Jakub Onderka]
- [internal] Ensure that UUID is always lowecase and real UUID. [Jakub
  Onderka]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]

Fix
~~~
- [users] Avoid POSTing forms not linked to the login page resulting in
  unwanted actions. [mokaddem]

  - As reported by Michael Kerscher
- [tag filters] fixed a bug introduced with the previous filter fix,
  resulting in multiple OR tags being ignored as a valid filter.
  [iglocska]
- [Server] only push events/sightings when selected. [Richard van den
  Berg]
- [cleanup] [iglocska]
- [cleanup] [iglocska]
- [string concat] fix. [iglocska]
- [cleanup] debug. [iglocska]
- [internal] Correctly handle positive tag filters for non site admins.
  [iglocska]

  - tag filters were ignored incorrectly when it was a positive lookup
- [internal] Nonsense index names. [Jakub Onderka]

Other
~~~~~
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Bumped db_schema. [Sami Mokaddem]
- Merge branch 'fix-login' into 2.4. [mokaddem]
- Merge pull request #6310 from RichieB2B/ncsc-nl/selective-push.
  [Andras Iklody]

  Only push events/sightings when selected for server
- Merge pull request #6308 from RichieB2B/ncsc-nl/anonymise-as. [Andras
  Iklody]

  Anonymise pushed sightings
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge pull request #6286 from JakubOnderka/push-error-handling. [Jakub
  Onderka]

  chg: [internal] Better error handling when pushing event to remote se…
- Merge pull request #6272 from JakubOnderka/uuid-validation. [Jakub
  Onderka]


v2.4.131 (2020-09-08)
---------------------

New
~~~
- [types] pgp-public-key/pgp-private-key added. [iglocska]
- [internal] filter "type" added for the internal fetcher. [iglocska]

  - appends email as a type if email-src/email-dst are found
- [types] email added as a new type, affects #6281. [iglocska]
- [diagnostic] Check if database index is unique. [Jakub Onderka]
- [API] added count returnformat for the REST api, fixes #6233.
  [iglocska]

  - simply counts the number of attributes/events found (on each respective scope)
- [ACL] event blacklisting fully opened up to host org users. [iglocska]

  - also added a new special permission for the ACL system host_org_user - which will evaluate whether the user is in the org configured in the MISP.host_org_id directive

Changes
~~~~~~~
- Bumped MISP objects latest version. [chrisr3d]
- [version] bump. [iglocska]
- [PyMISP] Bump version. [Raphaël Vinot]
- [misp-object] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [blocklist] Add comment for automatic event blocklist. [Jakub Onderka]
- [internal] Faster tag fetching for events. [Jakub Onderka]
- [internal] Little optimise Event::getRelatedAttributes. [Jakub
  Onderka]
- [internal] Optimise Event::getRelatedEvents for non correlated events.
  [Jakub Onderka]
- [internal] Optimise Event::__attachReferences method. [Jakub Onderka]
- [PyMISP] bump. [Alexandre Dulaunoy]
- [attributes] to_ids for new email type. [Alexandre Dulaunoy]
- [PyMISP] bump (due to describetypes) [Alexandre Dulaunoy]
- [attribute] pgp is not php ;-) [Alexandre Dulaunoy]
- [event] Deduplicate related events for extended view. [Jakub Onderka]
- [event] Deduplicate tags for extended view. [Jakub Onderka]
- [type] email-src/email-dst descriptions redefined. Also added email to
  the person category. [iglocska]
- [OpenIOC] email type added to the export tool. [iglocska]
- [complex parser] added email as an option for parsed email addresses.
  [iglocska]
- [openioc] added email type. [iglocska]
- [nids] added email type. [iglocska]
- [bro] added email type. [iglocska]
- Bumped queryversion. [Sami Mokaddem]
- [misp-object] updated to the latest version. [Alexandre Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [db_schema] Updated schema to reflect the change with allowlist and
  blocklist. [mokaddem]
- [misp.js] Correctly check if the variable exists before comparing.
  [mokaddem]
- [misp.js] Make sure the selector path is a valid selection string.
  [mokaddem]
- [jquery] Bumped jQuery to version 3.5.1. [mokaddem]
- [internal] Deduplicate code for event conditions. [Jakub Onderka]
- [internal] Much faster quick filter. [Jakub Onderka]
- [internal] Initialize Feed class just once. [Jakub Onderka]
- [internal] Unsetting SharingGroup is not necessary. [Jakub Onderka]
- [internal] Remove unused Event::getAccessibleEventIds. [Jakub Onderka]
- [internal] Remove duplicate event_creator_email fetching. [Jakub
  Onderka]
- [internal] Simplified putting attributes to objects. [Jakub Onderka]
- [internal] Use faster fetcher for viewing sightings. [Jakub Onderka]
- [JS libraries] Updated to latest version. [mokaddem]
- Bump PyMISP. [Raphaël Vinot]
- Bump PyMISP. [Raphaël Vinot]
- [internal] Using Allowedlist instead of Whitelist. [Golbark]
- [internal] Using blocklist instead of blacklist. [Golbark]
- [internal] Removed unused variables. [Jakub Onderka]
- [internal] Event::__escapeCSVField is not used. [Jakub Onderka]
- [internal] Event::generateRandomFileName just redefines AppModel
  method. [Jakub Onderka]
- [internal] Validation issues are already checked by fetcher. [Jakub
  Onderka]
- [internal] Warninglist::filterWarninglistAttributes takes just two
  arguments. [Jakub Onderka]
- [event] Deduplicate attribute related tags. [Jakub Onderka]
- [db_schema_diagnostic] Do not display remediation queries if an update
  is in progress. [mokaddem]
- Install poetry in home directory. [Raphaël Vinot]
- Bump PyMISP. [Raphaël Vinot]
- [stix import] Importing test mechanisms from indicators as yara rules.
  [chrisr3d]
- [misp-object] updated to the latest version. [Alexandre Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [installer] Made the globalVariables more flexible when you need to
  override them. [Steve Clement]
- [internal] Optimise fetching sightings for object. [Jakub Onderka]
- [internal] Less SQL queries for event index page. [Jakub Onderka]
- [internal] Distribution is checked by SQL. [Jakub Onderka]
- [internal] Remove not necessary code. [Jakub Onderka]
- [internal] Remove unused code. [Jakub Onderka]
- [PyMISP] bump PyMISP. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [API] GET requests on restsearch with no parameters are no longer
  allowed. [iglocska]

  - warn the user of the use of GET queries with posted JSON bodies
- [UI] Nicer selector for attribute search. [Jakub Onderka]
- [correlation] Fetch just necessary fields. [Jakub Onderka]
- [cleanup] removed duplicate check in beforefilter() of the
  eventblacklists controller. [iglocska]

Fix
~~~
- [widgets] Adding images by default on the repository (#6298) [Loïc
  Fortemps]
- [validation] relaxed first/last/middle name validation. [iglocska]
- [objects] edit fails due to invalid URLs used fixed. [iglocska]
- [internal] fix to various CLI commands breaking on the IP field in the
  log table not having a default value, fixes #6263. [iglocska]
- [internal] Fetch related events for merged events just when necessary.
  [Jakub Onderka]
- [db_schema] Missing index for feeds.orgc_id. [Jakub Onderka]
- [UI] Blocklist mass delete. [Jakub Onderka]
- [UI] Event blocklist. [Jakub Onderka]
- Support IE with no template literal support. [Tom King]
- [internal] Respect ACL for event attribute search. [Jakub Onderka]
- [stix2 import] Quick fix on external indicator parsing. [chrisr3d]

  - Specifying the indicator version while testing
    if the object is an indicator to avoid issues
  - Also added a small warning message for debugging
    purposes when we face issues to parse the
    pattern types
- [stix2 import] Making sure we do not lose the event uuid. [chrisr3d]
- [stix2 import] Removed useless test in relationships parsing.
  [chrisr3d]
- [stix2 import] Fixed external patterns parsing. [chrisr3d]

  - Avoiding brackets to be imported with the type
    and value within attributes
  - Going with 55095910c
- [API] blocklist behaviour index via the API returns empty list.
  [iglocska]

  - fixed
- [stix2 import] Fixed external pattern types parsing. [chrisr3d]

  - Avoiding issues with patterns containing parts
    within brackets and separated by OR statements
    giving results like "[file" instead of "file"
- [cluster:index] Prevent highlighting non existing JSON. [mokaddem]
- [popovers] Prevent closing inexisting popovers. [mokaddem]
- [userSettings:set_home_page] Added missing view file. Fix #6245.
  [mokaddem]
- [serverShell:cacheFeeds] Correct usage of __n function. Fix #6238.
  [mokaddem]
- [appmodel] Create indexes after the column has been added. [mokaddem]
- [stix import] Handling potential key errors with test mechanism types.
  [chrisr3d]
- [otp] Allow to send encrypted OTP by mail. [Jakub Onderka]
- [stix import] Preventing external observables & ttps parsing to fail.
  [chrisr3d]

  - Testing if observables have properties before
    trying to parse observable properties
  - Catching exceptions when ttps cannot be parsed
  - Should fix #6250
- [internal] loading a missing proposal attachment leads to an
  exception. [iglocska]

  - should be silently logged and notice error sent
- [enrich event] Typo. [chrisr3d]
- [enrich event] Avoid freetext results to end up lost in the
  interstellar space of orphaned attributes with no event_id. [chrisr3d]
- [tag] Show correct count of tag attributes and events. [Jakub Onderka]
- [UI] Event attribute filters works again. [Jakub Onderka]
- [JS] Issue #6226 when adding object reference. [Jakub Onderka]
- [JS] broken URLs due to the baseurl refactor. [iglocska]

  - no need to prepend URLs taken from the forms themselves directly.
- [internal] Remove unused compositeTypes variable. [Jakub Onderka]

Other
~~~~~
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Raphaël Vinot]
- Merge pull request #6297 from JakubOnderka/fix-merging-events. [Jakub
  Onderka]

  fix: [internal] Fetch related events for merged events just when necessary
- Merge pull request #6296 from JakubOnderka/2.4. [Jakub Onderka]

  fix: [db_schema] Missing index for feeds.orgc_id
- Merge pull request #6293 from JakubOnderka/event-blocklist-view-fix.
  [Jakub Onderka]

  Event blocklist view fix
- Merge pull request #6208 from JakubOnderka/faster_attach_tags. [Jakub
  Onderka]
- Merge pull request #6288 from JakubOnderka/reference-optimisation.
  [Jakub Onderka]

  chg: [internal] Optimise Event::__attachReferences method
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge pull request #6179 from denny-lclin/fix/variable-name-typo.
  [Christian Studer]

  [stix1 export] fix some variables' typo
- [stix1 export] fix some variables' typo. [Denny Lin]
- Merge pull request #6259 from
  JakubOnderka/extended_view_deduplication. [Jakub Onderka]

  Extended view deduplication
- Merge branch 'email_type' into 2.4. [iglocska]
- Merge branch 'js-libs-update' into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into js-libs-update.
  [mokaddem]
- Merge pull request #6282 from tomking2/bug/IE-support. [Andras Iklody]

  fix: Support IE with no template literal support
- Merge pull request #6254 from JakubOnderka/unique_index_diagnostic.
  [Jakub Onderka]

  new: [diagnostic] Check if database index is unique
- Merge pull request #6274 from
  JakubOnderka/acl_filter_attribute_values. [Jakub Onderka]

  fix: [internal] Respect ACL for event attribute search
- Merge branch '2.4' of github.com:MISP/MISP into js-libs-update.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into js-libs-update.
  [mokaddem]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge pull request #6219 from JakubOnderka/event-small-optim. [Jakub
  Onderka]

  Event small optim
- Merge pull request #6271 from JakubOnderka/faster_quick_filter. [Jakub
  Onderka]

  chg: [internal] Much faster quick filter
- Merge pull request #6265 from JakubOnderka/not-necessary-code-vol2.
  [Jakub Onderka]

  Remove not necessary code vol2
- Fixup! chg: [internal] Simplified putting attributes to objects.
  [Jakub Onderka]
- Merge pull request #6268 from JakubOnderka/sightings-faster-fetcher.
  [Jakub Onderka]

  chg: [internal] Use faster fetcher for viewing sightings
- Merge pull request #6267 from Golbark/rename_bl. [Andras Iklody]

  Rename blacklist and whitelist to alternatives
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge pull request #6264 from JakubOnderka/not-necessary-code. [Jakub
  Onderka]

  Remove not necessary code
- Merge branch 'fix-6249' into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into fix-6249. [mokaddem]
- Merge pull request #6262 from JakubOnderka/deduplicate_related_tags.
  [Jakub Onderka]

  chg: [event] Deduplicate attribute related tags
- Merge pull request #6258 from MISP/travis_poetry. [Raphaël Vinot]

  chg: Install poetry in home directory
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge pull request #6214 from JakubOnderka/otp-encryption. [Jakub
  Onderka]

  fix: [otp] Allow to send encrypted OTP by mail
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge pull request #6241 from SteveClement/tools. [Steve Clement]

  chg: [installer] Made the globalVariables more flexible
- Merge pull request #6203 from JakubOnderka/tag-count. [Andras Iklody]

  Show proper number of attributes and events for tags
- Event ID translation feature (#6212) [Loïc Fortemps]

  * new: [sync] Event ID translation between sync servers
- Merge pull request #6237 from jtdroste/expanded-ip-logging. [Andras
  Iklody]

  new: Add the ability to customize the IP header field when logging
- Add the ability to customize the IP header field when logging. [James
  Droste]
- Merge pull request #6234 from JakubOnderka/event-filters-fix. [Jakub
  Onderka]

  fix: [UI] Event attribute filters works again
- Merge pull request #6230 from JakubOnderka/event-small-optim-simple.
  [Jakub Onderka]

  Small optimisation for event index page
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #6228 from JakubOnderka/fix-6226. [Jakub Onderka]

  fix: [JS] Issue #6226 when adding object reference
- Merge pull request #6225 from rmkml/2.4. [Alexandre Dulaunoy]

  add SHA3 Hash on Attribut.php
- Add SHA3 Hash on Attribut.php. [rmkml]
- Feature/achievements widget (#6129) [Christophe Vandeplas, Loïc
  Fortemps, Steve Clement]

  * Additionnal protection against XSS, the response type defaults to html while it should be JSON.
  * new: widget: Achievements widget
  * Update AchievementsWidget.php
  * Update AchievementsWidget.php
  * Visual adjustments, new badges
  * i18n
  * indentation to MISP convention
  * AchievementsWidget minor textual improvements
  * Optimized query and fix issue with i18n
- Merge pull request #6221 from cudeso/2.4. [Alexandre Dulaunoy]

  MISP-SNMP Monitor script
- Add SNMP configuration snippet. [Koen Van Impe]
- MISP-SNMP Monitor script. [Koen Van Impe]

  Script to return statistics which can be picked up via SNMP.
  Post for monitoring with Cacti (inspired by OpenNSM) will follow
  shortly.
- Merge remote-tracking branch 'MISP/2.4' into 2.4. [Koen Van Impe]
- Merge pull request #6200 from JakubOnderka/us-attr-search. [Jakub
  Onderka]

  chg: [UI] Nicer selector for attribute search
- Merge pull request #6222 from JakubOnderka/correlation-fetch-optim.
  [Jakub Onderka]

  chg: [correlation] Fetch just necessary fields
- Merge pull request #6220 from obert01/fix-accessibility. [Andras
  Iklody]

  A few accessibility fixes for users of screen readers
- A few accessibility fixes for users of screen readers: - Added aria
  label and role for the representation of booleans in generic index
  tables, - Fixed Aria label for actions in generic index tables, - Set
  titles for actions in the admin user index table, - Added a few
  missing aria labels in the global menu. [Olivier BERT]


v2.4.130 (2020-08-20)
---------------------

New
~~~
- [internal] cache tags instead of loading them over and over via the
  event fetcher, fixes #6201. [iglocska]

  - should speed things up for exports of datasets that have a lot of recurring tags
  - moved the caching of some internals to the appmodel level to make it more generic
- [internal] Support autocrypt when sending e-mails. [Jakub Onderka]
- [internal] 'GnuPG.obscure_subject' option to not send unencrypted
  subject. [Jakub Onderka]
- [internal] Log if e-mail was send encrypted or not. [Jakub Onderka]
- [administration] lightweight slow query log analysis added. [iglocska]

  usage: /var/www/MISP/app/Console/cake Statistics analyse_slow_logs [path_to_slow_log]
- [widgets] Additional widgets for sharing statistics and layouts.
  [Golbark]
- Allow tag deletion for an event on update. [Tom King]
- Allow for attribute tag deletion via Event or Attribute edit. Clean
  and return the attribute tags on response from editing an attribute,
  update code to remove legacy. [Tom King]
- [UI] Show event preview when merging. [Jakub Onderka]
- [attribute] Add support for IDN domains. [Jakub Onderka]
- [opt] Added non interactive place holder. [Steve Clement]
- New: [freetext] Convert `[at]` to `@` and `hxtp` and `htxp` to `http`
  [Jakub Onderka]

  Fixes #4908 and #4805

Changes
~~~~~~~
- [VERSION] bump. [iglocska]
- [misp-taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [PyMISP] Bump tag. [Raphaël Vinot]
- Bump PyMISP. [Raphaël Vinot]
- [misp-object] updated to the latest version. [Alexandre Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [misp-objects] updated. [Alexandre Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [correlation] Use less memory when generating correlation. [Jakub
  Onderka]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [internal] Break loop when match is found. [Jakub Onderka]
- [UI] Nicer tag removal confirmation. [Jakub Onderka]
- [internal] Reuse AttachmentTool instance. [Jakub Onderka]
- [internal] Generate event date even if attachments doesn't exists.
  [Jakub Onderka]
- [internal] Move attachment handling to one place. [Jakub Onderka]
- [mail] Initialize GPG just once. [Jakub Onderka]
- [mail] Simplified Message-ID generation. [Jakub Onderka]
- [internal] Move GPG initialization to GpgTool. [Jakub Onderka]
- [test] Set correct setting for GPG. [Jakub Onderka]
- [internal] Protect also Reply-To header. [Jakub Onderka]
- [internal] Protect also Date header. [Jakub Onderka]
- [internal] Refactor S/MIME certificate validation. [Jakub Onderka]
- [internal] Rework email sending. [Jakub Onderka]
- [test] Show all logs from /app/tmp/logs/ folder. [Jakub Onderka]
- [test] Do not show progress for composer. [Jakub Onderka]
- [test] Show generated gpg keys. [Jakub Onderka]
- [test] Remove dist-upgrade to speed up build. [Jakub Onderka]
- [test] Run apt-get install just once to speed up build. [Jakub
  Onderka]
- [doc] Added php-zip. [Steve Clement]
- [internal] Update correlations in one query. [Jakub Onderka]

  Before, for every event saving action, four queries for updating correlations were generated
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- [CLI] Allow to fetch remove event by UUID. [Jakub Onderka]
- [internal] Refactor Server::getEventIdsFromServer. [Jakub Onderka]
- [internal] stub for a simple caching mechanism for recurring queries.
  [iglocska]
- [users:login] No longer fetch login form multiple times. - Reverted
  monkey patch - Removed the onclick listener responsible to calling the
  function twice. [mokaddem]
- [posts] Allow to add comment to any user that can see event. [Jakub
  Onderka]
- [UI] Do not exclude local tags when viewing event. [Jakub Onderka]
- [UI] Allow to add local galaxy for non host org user. [Jakub Onderka]
- [proposals:index] Migrated index to the factory index. [mokaddem]
- [api] fixed restresponse for blacklists. [iglocska]
- [feed] Better exception messages for invalid JSON. [Jakub Onderka]
- Bump PyMISP. [Raphaël Vinot]
- [users:login] Removed duplicated submit button. [mokaddem]
- Bumped queryversion. [mokaddem]
- [tags:attachTagToObject] Support array of tags. Fix #5534. [mokaddem]
- [misp.js] Applied codefactor comments. [mokaddem]
- [objects:edit] Typo in comments. [mokaddem]
- [objects:edit] Replaced usage of cookie with session. [mokaddem]
- [objects:edit] Merge data is passed via cookies instead of the URI.
  [mokaddem]
- [attributes:massEditForm] Pass attributes ids to be edited via POST.
  [mokaddem]

  Fix #5500
- [internal] Initialize UserSetting just when needed. [Jakub Onderka]
- [users:acceptRegistration] Displays an error message if saved failed
  Fix #6134. [mokaddem]
- Bump PyMISP. [Raphaël Vinot]
- Bump PyMISP, fix test. [Raphaël Vinot]
- [event:freetextImport] Usage of primaryOnlyCorrelatingTypes and limit
  the number of correlations displayed. [mokaddem]
- [internal] Faster loading sighting. [Jakub Onderka]
- [internal] Small controller cleanup. [Jakub Onderka]
- [warning-lists] major update. [Alexandre Dulaunoy]
- [correlations] Faster loading related attributes. [Jakub Onderka]
- [UI] Side menu optimisations and cleanup. [Jakub Onderka]
- [feed] Use less memory when parsing CSV feeds. [Jakub Onderka]
- [internal] Better error handling for JSON decoding. [Jakub Onderka]
- [UI] Add proposal form refactor. [Jakub Onderka]
- Bump PyMISP. [Raphaël Vinot]
- [attributeTag:handleAttributeTags] Removed useless conditions.
  [mokaddem]
- [AttributeTags:handleAttributeTags] More generic way to handle capture
  and association. [mokaddem]
- [attribute] Added tag handling when saving attributes and objects.
  [mokaddem]
- [tag] Support of untagging in Object's Attribute and other fixes.
  [mokaddem]

  - deleted: 0 is correctly handled
  - stopped usage of `editAttribute` from Attribute Controller
- [attribute:editAttribute] Uage of `editableFields` instead of
  hardcoded array. [mokaddem]
- [object] Avoid notices if some object attributes fields are not set.
  [mokaddem]
- [object:edit] Allow deleting objects by passing `deleted` flag.
  [mokaddem]

  Fix #6024
- [stix2 export] Avoiding testing the same field twice. [chrisr3d]

  - Following #6132 recently merged, which avoids
    potential KeyError exceptions, thanks to
    @denny-lclin
- [internal] Faster generating correlations when enabling for event by
  toggle. [Jakub Onderka]
- [UI] Wait 100 ms before showing event info. [Jakub Onderka]
- [UI] Add link to event in event info. [Jakub Onderka]
- [internal] Better job progress and status logging. [Jakub Onderka]
- [requirements] Aligning requirements file with Pipfile regarding stix
  library requirements. [chrisr3d]
- Bumped latest misp-opendata updates. [chrisr3d]
- [events:index] Renamed `org` into `creator org`. Fix #6012. [mokaddem]
- [opendata export] Support of the search functionality + fixed url
  parameter used in the delete feature. [chrisr3d]
- [internal] Faster checking if warninglist already exists for event.
  [Jakub Onderka]
- [internal] Initialize FinancialTool just when necessary. [Jakub
  Onderka]
- [misp-opendata] Bumped latest version. [chrisr3d]
- [freetext] Various code fixes and optimisations. [Jakub Onderka]
- [internal] More tests for ComplexTypeTool::checkFreeText. [Jakub
  Onderka]
- [internal] Simplified ComplexTypeTool::checkFreeText. [Jakub Onderka]
- [opendata export] Parsing portal url parameter + slight parameters
  parsing changes. [chrisr3d]

  - As the possibility of specifying the url of the
    Open data portal to use instead of the default
    one, we support here this parameter and adapt
    the way we build the command that will launch
    the python script
  - Slight changes to replace some isset tests by
    empty tests to make sure the concerned fields
    are not only set, but also contain a value
- [diagnostic] Updated required stix2 library version. [chrisr3d]

Fix
~~~
- [internal] Syntax error in bootstrap.default.php. [Jakub Onderka]
- [invalid element reference] element filepath was incorrectly treated
  as a url. [iglocska]
- [UI] Show correct options in menu. [Jakub Onderka]
- [internal] Notice when adding tag to collection. [Jakub Onderka]
- [security] Check tag restriction for collection tags. [Jakub Onderka]
- [security] Check tag restriction for attribute tags. [Jakub Onderka]
- [security] Check tag restriction for event tags. [Jakub Onderka]
- [attachment] Do not fetch attachment when accepting deletion proposal.
  [Jakub Onderka]
- [UI] Showing image thumbnail. [Jakub Onderka]
- [test] Use two spaces to pass the test. [Jakub Onderka]
- [internal] Throw exception if invalid event for contact method is
  provided. [Jakub Onderka]
- [test] Set GnuPG.email variable. [Jakub Onderka]
- [internal] Fix undefined index notices. [Jakub Onderka]
- [test] GPG homedir permission. [Jakub Onderka]
- [internal] SendEmail exceptions message and logging. [Jakub Onderka]
- [internal] Do not leak IP address in Message-ID. [Jakub Onderka]
- [internal] Throw exception when invalid event id provided for contact
  email. [Jakub Onderka]
- [intrernal] Undefined index: Organisation notice. [Jakub Onderka]
- [cli] Show error when invalid user ID provided. [Jakub Onderka]
- [test] Install missing python3-redis package. [Jakub Onderka]
- [test] Show error and debug logs also after success test. [Jakub
  Onderka]
- [test] Start workers under www-data group. [Jakub Onderka]
- [doc]  Amended CentOS8 install doc. Removed ssdeep, not working
  anymore. [Steve Clement]
- [events:queryEnrichment] Recovers tag colour. [mokaddem]

  - Fix #6186
- [security] Check if user can access sharing group when uploading
  attachment. [Jakub Onderka]
- [UI] Bad merge for mass edit form. [Jakub Onderka]
- [proposals] Downloading proposal attachment. [Jakub Onderka]
- [ACL] Allow proposal author to discard it. [Jakub Onderka]
- [security] Respect ACL for freetext import. [Jakub Onderka]
- [security] Throw exception if invalid data provided. [Jakub Onderka]
- [ACL] Use common methods for ACL when editing object reference. [Jakub
  Onderka]
- [ACL] Unpublished private for object do not apply for site admin.
  [Jakub Onderka]
- [security] Sharing groups for objects respect permissions. [Jakub
  Onderka]
- [tags] Show just tags that user can really use. [Jakub Onderka]
- [security] Respect ACL for proposals. [Jakub Onderka]
- [proposals] Respect unpublished private event when loading proposals.
  [Jakub Onderka]
- [internal] Check `allow_disabling_correlation` before correlation
  toggle. [Jakub Onderka]
- [security] ACL check when loading ajax tags. [Jakub Onderka]
- [security] ACL check when adding or removing tags. [Jakub Onderka]
- [security] ACL check when editing multiple event attributes. [Jakub
  Onderka]
- [security] Respect ACL when event edit. [Jakub Onderka]
- [stix import] Better TTPs parsing for external STIX. [chrisr3d]
- [stix import] Fixed parameter determining if a ttp should be handled
  as attribute/object or as galaxy. [chrisr3d]
- [stix export] Adding Vulnerability objects created out of attributes
  to the list of leveraged ttps. [chrisr3d]
- [stix import] Same change for external indicator as we just did for
  external observables. [chrisr3d]

  - We also changed the code comments to make them clearer
- [stix import] Handling the case of multiple attributes returned from
  the parsing. [chrisr3d]

  - If we get a list of actual attributes, we then
    handle the MISP object case, otherwise it means
    it is simply a list of attribute values, and we
    add as many attributes as there are values
- [stix import] Splitted threat actors import parsing. [chrisr3d]

  - We now have specific a threat actors parsing for
    external STIX data, since the structure of the
    threat actor objects may not always be the same
  - Parsing threat actors from STIX documents
    produced with MISP remains the same
- [stix import] Using generic Exception instead of specific ones to
  handle the results of the attribute parsing. [chrisr3d]

  - A lot of different exception types may be raised
    while parsing external stix data
- [zmg] failing to publish to the ZMQ channel when MISP.org is invalid
  fixed, fixes #6174. [iglocska]

  - use the host org ID
  - if it's not set (should never happen), just take the lowest ID org
- [login] endless blackholeannoyance fixed via monkey-patch. [iglocska]
- [API] org blacklist copy pasta preventing additions of entries fixed.
  [iglocska]
- [api] minor fix to the blacklist responses. [iglocska]
- [API] blacklisting - don't throw 500 when no valid input is presented
  on the add interface. [iglocska]
- [feed] Make HttpSocket instance optional for local feeds. [Jakub
  Onderka]
- [ACLComponent] Updated permissions. [mokaddem]
- [attributes] Do not override unlockedActions anymore. [mokaddem]
- [attributes:massEditForm] Invalid conditions fixed and performances
  improvements. [mokaddem]
- [attributes:massEditForm] Check if event exists. [mokaddem]
- [users:login] Blackhole on login screen. [mokaddem]

  Fetch, fill and submit a fresh form on login avoiding blackholes due to
  expired form token
- [blacklists] fixed add event blacklist via API calls. [iglocska]
- [internal] older PHP still not happy with the return from a generator.
  [iglocska]
- [db_schema] Added feeds.orgc_id in the index. [mokaddem]

  Fix #5838
- [internal] make ancient PHP versions happy. [iglocska]
- [users:edit] Reset AUTHKey via interface. [mokaddem]

  Fix #6082
- [unicode] Temporarily escape 4 byte characters until we move the
  attribute value fields to mb4, fixes #5123. [iglocska]

  - fixes sync/feed issues related to 4 byte unicode characters
- [administration] added missing column. [iglocska]
- [administration] fixed var name. [iglocska]
- [object:edit] Updating an object to a new template acutally save the
  template version Fix #6083. [mokaddem]
- [pull] Check if url_params in pull filter is empty string. [Jakub
  Onderka]
- [UI] clearer sync error message for no sync privileges. [iglocska]
- [internal] Throw NotFoundException for non exists UUID. [Jakub
  Onderka]
- [UI] Missing echo for decay score table header. [Jakub Onderka]
- [internal] Feed controller cleanup. [Jakub Onderka]
- [UI] Remove PHP warnings from side_menu_link.ctp. [Jakub Onderka]
- [stix export] Fixed child-pid attributes export that used to make the
  process object export fail. [chrisr3d]
- [attribute:editableFields] Typo in variable name. [mokaddem]
- [attributes:edit] Correct error previsouly merged when importing code.
  [mokaddem]
- [stix import] Fixed the remaining failing object references.
  [chrisr3d]
- [stix import] Fixed references between file, pe & pe-section obects +
  moved mapping dict to the mapping script. [chrisr3d]
- [object:edit] Correctly set the SG of the added new attributes Fix
  #6025. [mokaddem]
- [objects:edit] Returns the latest state of the object if it were
  deleted. [mokaddem]
- [attribute] Allow editing attributes. [mokaddem]

  Added raw values fields in the `editableFields`
- [sync] drop the republishing of events when the modification is merely
  a timestamp bump. [iglocska]

  - due to an already fixed issue still lingering, invalid event edits keep getting synchronised between instances
  - these events still generate publish alerts erroneously

  - this fix compares the previous state of the event to the modification, if there are no material changes (attributes, objects, object relations, event tags added/updated) then the publishing is dropped.
- [stix import] Fixed port in ip-port objects import to lose src and dst
  context. [chrisr3d]
- [stix export] Fixed the slight difference between parsing x509
  fingerprint attributes and x509 objects. [chrisr3d]
- [stix export] Fixed x509 fingerprint attributes export & moved mapping
  dictionaries to the mapping script. [chrisr3d]

  - Only the x509-fingerprint-sha1 attribute was
    exported, and as a standard sha1 attribute,
    which was a loss of context, now the x509
    fingerprint attributes (md5, sha1 & sha256) are
    exported as expected within a x509 observable
  - Also moved the mapping dictionaries with the
    appropriate indent to the mapping script, where
    they should belong
- [stix export] Fixed pep8 & changed indentation for better readability.
  [chrisr3d]
- [attribute:edit] Prevent the edition of system reserved fields.
  [mokaddem]
- [feed:importFreeText] Make sure to update the timestamp when soft-
  deleting after delta-merge. [mokaddem]

  Fix #6013
- [events:index] Do not show events if org doesn't belong to the SG.
  [mokaddem]

  Event belonging to an organisation which is not
  included in the sharing group assigned to the event will not see the
  event on the index anymore.
  Fix #6033
  Fix #6107
- [feed] Accept more text content. Fix #5969. [mokaddem]
- [stix import] Importing single vulnerability attributes as
  vulnerability and not as text. [chrisr3d]
- [sync] internal sync now correctly syncs local tags. [iglocska]

  - also fixes a notice about a missing tag in the sync
- [galaxyClusters:view] Fixed full_group_by issue when viewing the
  galaxy matrix. [mokaddem]
- [UI] Show proper menu when editing event info. [Jakub Onderka]
- [attributes:massEdit] proposal option not by default. [Christophe
  Vandeplas]

  this way we do not change the default behavior which was changed in commit 9b33476eedd184bc46665aaae57533ddcf35e5f7
- [proposals] Delete proposals for object attributes. [Jakub Onderka]
- Minor typo. [Christophe Vandeplas]
- [installer] Installer was broken, now fixed. [Steve Clement]
- [bug] Check for non-existen directory fails if exists. [Steve Clement]
- [internal] Remove unused Event::setSimpleConditions method. [Jakub
  Onderka]
- [internal] Remove unused CidrComponent and CIDRTool classes. [Jakub
  Onderka]
- [correlations] Purge ssdeep table after attribute delete. [Jakub
  Onderka]
- [audit] Show all attribute changes in event history. [Jakub Onderka]
- [internal] Do not check event existence twice. [Jakub Onderka]
- [internal] Reduce number of regexp in refang table. [Jakub Onderka]
- [freetext] Handle IPv6 and punycode domains when import. [Jakub
  Onderka]
- [security] xss fix missing part of solution. [iglocska]

  - the previous fix to the xss in the homepage setter was lacking the controller changes due to a partial commit (#bf4610c947c7dc372c4078f363d2dff6ae0703a8)

    - as originally discovered by Mislav Božičević <mislav.bozicevic@nn.cz>
    - persistence of the vulnerability after the lacking fix reported by DIEGO JURADO PALLARES from Ciberinteligencia
- [opendata export] Adding auth param in the python command only if not
  empty. [chrisr3d]

Other
~~~~~
- Merge pull request #6204 from JakubOnderka/2.4. [Jakub Onderka]

  fix: [internal] Syntax error in bootstrap.default.php
- Merge branch 'baseurl' into 2.4. [iglocska]
- Syntax check and fix. [Vito Piserchia]
- Recover from upstream version missing bits. [Vito Piserchia]
- Recover from upstream version missing bits. [Vito Piserchia]
- Merge remote-tracking branch 'upstream/2.4' into baseurl-patch. [Vito
  Piserchia]
- Rebase continue. [Vito Piserchia]
- Rebase continue. [Vito Piserchia]
- Fix genericPopup. [johndoe]
- Use this here. [johndoe]
- Use this here. [johndoe]
- Rebase continue. [Vito Piserchia]
- Fix rebase. [johndoe]
- Fix rebase. [johndoe]
- Fix rebase. [johndoe]
- Fix rebase. [johndoe]
- Fix rebase. [johndoe]
- Fixed Codacy warnings. [Léarch]
- Corrected redirections. [Léarch]

  See the following for an explanation:
  https://stackoverflow.com/questions/6836990/how-to-get-complete-current-url-for-cakephp#comment11184149_6875310
- Rebase continue. [Vito Piserchia]
- Rebase continue. [Vito Piserchia]
- Fix rebase. [johndoe]
- Rebase continue. [Vito Piserchia]
- Added missed variable declaration. [Vito Piserchia]
- Improve code quality. [Vito Piserchia]
- Rebase continue. [Vito Piserchia]
- Rebase continue. [Vito Piserchia]
- Fix genericPopup. [Vito Piserchia]
- Rebase continue. [Vito Piserchia]
- Rebase continue. [Vito Piserchia]
- Fix baseurl use to view organizations. [Léarch]
- Fixed Codacy warnings. [Léarch]
- Corrected redirections. [Léarch]

  See the following for an explanation:
  https://stackoverflow.com/questions/6836990/how-to-get-complete-current-url-for-cakephp#comment11184149_6875310
- Rebase continue. [Vito Piserchia]
- Rebase continue. [Vito Piserchia]
- More merge fixes. [Vito Piserchia]
- Resolve merge. [Vito Piserchia]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #6176 from JakubOnderka/fix-menu. [Jakub Onderka]

  fix: [UI] Show correct options in menu
- Merge pull request #6202 from rmkml/2.4. [Andras Iklody]

  add vhash (VirusTotal Hash) on Attribut.php
- Add vhash (VirusTotal Hash) on Attribut.php. [rmkml]
- Merge pull request #6199 from JakubOnderka/generate-correlation-
  memory. [Jakub Onderka]

  chg: [correlation] Use less memory when generating correlation
- Merge pull request #6196 from JakubOnderka/event-tags. [Jakub Onderka]

  Event tag adding and removing
- Fixup! chg: [UI] Nicer tag removal confirmation. [Jakub Onderka]
- Merge pull request #5865 from JakubOnderka/attachment_tool. [Jakub
  Onderka]

  chg: [internal] Move attachment handling to one place
- Merge pull request #5240 from JakubOnderka/patch-43. [Jakub Onderka]

  chg: [internal] Refactor e-mail sending
- Merge pull request #6192 from JakubOnderka/notices-fix. [Jakub
  Onderka]

  Notices fixes
- Merge pull request #6191 from JakubOnderka/travis-fixes-vol2. [Jakub
  Onderka]

  Travis fixes vol2
- Merge pull request #6190 from JakubOnderka/travis-fixes. [Jakub
  Onderka]

  Travis fixes
- Merge pull request #6187 from SteveClement/guides. [Steve Clement]
- Merge pull request #5948 from JakubOnderka/update-correlations. [Jakub
  Onderka]

  chg: [internal] Update correlations in one query
- Merge pull request #6001 from JakubOnderka/get-events-refactoring.
  [Jakub Onderka]

  chg: [internal] Refactor Server::getEventIdsFromServer
- Merge pull request #6181 from JakubOnderka/checek-sg-perm. [Jakub
  Onderka]

  fix: [security] Check if user can access sharing group when uploading…
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #6178 from JakubOnderka/fix-mass-edit. [Jakub
  Onderka]

  Fix mass edit
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge pull request #6175 from JakubOnderka/shadow-fix. [Jakub Onderka]

  Shadow fix
- Merge pull request #6172 from JakubOnderka/freetext-import-acl2.
  [Jakub Onderka]

  fix: [security] Respect ACL for freetext import
- Merge pull request #6136 from JakubOnderka/acl-can-modify-chekcs.
  [Jakub Onderka]

  fix: [security] Respect ACL when event edit
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #6156 from JakubOnderka/feed-httpsocket-optional.
  [Jakub Onderka]

  fix: [feed] Make HttpSocket instance optional for local feeds
- Merge pull request #6052 from stricaud/2.4. [Andras Iklody]

  Using json parser to parse json configuration output from cake
- Using json parser to parse json configuration output from cake.
  [Sebastien Tricaud]
- Merge branch 'fix-no-more-login-blackhole' into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into fix-no-more-login-
  blackhole. [mokaddem]
- Merge branch 'fix-mass-edit-form-with-post' into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into fix-mass-edit-form-
  with-post. [mokaddem]
- Merge branch 'feature-5534' into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into feature-5534.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into feature-5534.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into fix-mass-edit-form-
  with-post. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into fix-mass-edit-form-
  with-post. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge pull request #6154 from JakubOnderka/tags-fix. [Sami Mokaddem]

  chg: [internal] Initialize UserSetting just when needed
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch 'fix-align-object-with-latest-template' into 2.4.
  [mokaddem]
- Merge pull request #6150 from JakubOnderka/2.4. [Jakub Onderka]

  fix: [pull] Check if url_params in pull filter is empty string
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch 'fix-freetext-correlation-improvements' into 2.4.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into fix-freetext-
  correlation-improvements. [mokaddem]
- Merge pull request #6148 from JakubOnderka/controller-cleanup. [Jakub
  Onderka]

  chg: [internal] Small controller cleanup
- Merge pull request #6146 from JakubOnderka/toolbox-non-exists-uuid.
  [Jakub Onderka]

  fix: [internal] Throw NotFoundException for non exists UUID
- Merge pull request #6144 from JakubOnderka/feeds-controller-cleanup.
  [Jakub Onderka]

  fix: [internal] Feed controller cleanup
- Merge branch 'fix-update-tags-on-attribute-edit' into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into fix-update-tags-on-
  attribute-edit. [mokaddem]
- Merge pull request #5954 from JakubOnderka/get-related-attributes-
  faster. [Jakub Onderka]

  chg: [correlations] Faster loading related attributes
- Merge pull request #6126 from JakubOnderka/side-menu-optim. [Jakub
  Onderka]

  chg: [UI] Side menu optimisations and cleanup
- Merge pull request #6115 from JakubOnderka/freetext-fixes-vol2. [Jakub
  Onderka]

  chg: [feed] Use less memory when parsing CSV feeds
- Merge pull request #6031 from JakubOnderka/json_error_handling. [Jakub
  Onderka]

  chg: [internal] Better error handling for JSON decoding
- Merge pull request #6141 from JakubOnderka/proposal-form-refactor.
  [Jakub Onderka]

  chg: [UI] Add proposal form refactor
- Add: [stix import] Support the import of port, command-line & image
  attributes in process objects. [chrisr3d]
- Add: [stix export] Process objects export now supports port
  attributes. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge pull request #6142 from Golbark/feature/sharing_widgets. [Andras
  Iklody]

  new: [widgets] Additional widgets for sharing statistics and layouts
- Add: [stix export] Process object export has been improved to support
  image & command-line attributes. [chrisr3d]
- Merge branch 'feature/tags-deletion' into fix-update-tags-on-
  attribute-edit. [mokaddem]
- Merge remote-tracking branch 'origin/2.4' into feature/tags-deletion.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into pr-
  feature/tags_deletion. [mokaddem]
- Merge remote-tracking branch 'upstream/2.4' into
  feature/tags_deletion. [Tom King]
- Merge branch '2.4' into feature/tags_deletion. [Tom King]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch 'true-2.4' into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #6132 from denny-lclin/fix/key-error-in-
  stix2-misp2stix2. [Christian Studer]

  fix: check Misp time fields exist before using them
- Check time fields exist before using them. [Denny Lin]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge pull request #6131 from JakubOnderka/toggle-correlation-speedup.
  [Jakub Onderka]

  chg: [internal] Faster generating correlations when enabling
- Merge pull request #6135 from JakubOnderka/merge_show_event_preview.
  [Jakub Onderka]

  new: [UI] Show event preview when merging
- Merge pull request #6065 from JakubOnderka/job-progress. [Jakub
  Onderka]

  chg: [internal] Better job progress and status logging
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge pull request #6099 from JakubOnderka/idn-support. [Jakub
  Onderka]

  new: [attribute] Add support for IDN domains
- Merge pull request #6112 from JakubOnderka/attr-fetch-optim. [Jakub
  Onderka]

  Attr fetch optim
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge pull request #6119 from MISP/JakubOnderka-patch-1. [Jakub
  Onderka]

  fix: [UI] Show proper menu when editing event info
- Additionnal protection against XSS, the response type defaults to html
  while it should be JSON. (#6118) [Loïc Fortemps]
- Merge pull request #6117 from JakubOnderka/delete-object-proposal.
  [Jakub Onderka]

  fix: [proposals] Delete proposals for object attributes
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #6116 from SteveClement/guides. [Steve Clement]
- Merge branch 'guides' of github.com:SteveClement/MISP into guides.
  [Steve Clement]
- Merge pull request #6114 from JakubOnderka/remove-cidr. [Jakub
  Onderka]

  fix: [internal] Remove unused CidrComponent and CIDRTool classes
- Merge pull request #5929 from JakubOnderka/fuzzy-purge. [Jakub
  Onderka]

  fix: [correlations] Purge ssdeep table after attribute delete
- Merge pull request #6113 from JakubOnderka/freetext-fixes-vol2. [Jakub
  Onderka]

  chg: [freetext] Various code fixes and optimisations
- Merge pull request #6085 from JakubOnderka/event_log_fix. [Jakub
  Onderka]

  fix: [audit] Show all attribute changes in event history
- Merge pull request #6091 from JakubOnderka/existence-checking. [Jakub
  Onderka]

  fix: [internal] Do not check event existence twice
- Merge pull request #6097 from JakubOnderka/freetext-fixes. [Jakub
  Onderka]

  fix: [freetext] Handle IPv6 and punycode domains when import


v2.4.129 (2020-07-13)
---------------------

New
~~~
- [diag] Check if ZIP extension is installed. [Jakub Onderka]
- [merge] functionality reworked. [iglocska]

  - handle objects, tags, etc via @chrisr3d's module result parsing
  - handle sharing groups correctly - as reported by Jakub Onderka
  - using standardised fetchers internally
  - API enabled (which will directly merge all contents of the source event into the target event)
- [event block rule system] added. [iglocska]

  - add simple tag filters to block events from being added.
  - it will not stop a manual creation of an event with subsequent adding of the tag in a later stage
  - it will however block synced events
- [statistics] shell added for the git codebase's contributor counters.
  [iglocska]

  - to be extended with other similar tasks

Changes
~~~~~~~
- [version] bump. [iglocska]
- [stix2 library] Bumped latest version. [chrisr3d]
- [UI] Add attribute fixes. [Jakub Onderka]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [correlations] Faster checking if CIDR is IPv4 or IPv6 version. [Jakub
  Onderka]
- [correlations] Just check if redis key exists. [Jakub Onderka]
- [feed] Faster freetext feed caching. [Jakub Onderka]
- [UI] Sort tags by name for server rules. [Jakub Onderka]
- [internal] Use tmp file fro Feed::getCache. [Jakub Onderka]
- [internal] Attribute REST search optimisations and error handling.
  [Jakub Onderka]
- [internal] Simplify and optimise eventUI method. [Jakub Onderka]
- [warning-list] updated to the latest version. [Alexandre Dulaunoy]
- [ACL] Allow to access to fetchOrgsForSG and fetchServersForSG just
  with perm_sharing_group. [Jakub Onderka]
- [users:resgister] Use the trimmed data instead. [mokaddem]
- [stix2] Bumped latest python stix2 library. [chrisr3d]
- [sightings] Check if sighting already exists before getting attribute
  info. [Jakub Onderka]
- [sightings] Save one SQL query when saving sighting if event UUID is
  given. [Jakub Onderka]
- [internal] Move getting sightings range to one place. [Jakub Onderka]
- [internal] Faster loading sightings if the same attribute is
  requested. [Jakub Onderka]
- [statistics shell] added total commit count. [iglocska]

Fix
~~~
- [installer] Update to latest. [Steve Clement]
- [StixExport] suppress unlink warnings. [Richard van den Berg]
- [stix export] log stack trace on error, support 'AMBER NATO ALLIANCE'
  TLP tags. [Richard van den Berg]
- [misp_retention] Support objects, use lists for build_complex_query()
  [Richard van den Berg]
- [attributes] Possible duplicate attributes. [Jakub Onderka]
- [internal] Missing field for server model when editing event. [Jakub
  Onderka]
- [stix2 import] Fixed some object reference issues. [chrisr3d]

  - With the newest PyMISP version, the object
    references creation had to get some slight
    changes:
    - We add the referenced object in the event
      before the add the reference between the 2
      objects, when it is possible
    - ** has been removed while calling add_object
      since we are adding already verified MISP
      objects, and using ** was actually the reason
      why the references were not present in the
      objects when they had been created before the
      referenced object were added to the event
- [stix2 import] Fixed Observable object type checking, following the
  recent changes on the stix2 python library. [chrisr3d]
- [stix upload] Removed 'isset' already tested with 'empty' at the same
  place. [chrisr3d]
- [stix2 import] Avoid duplication of original-imported-file objects
  during the import process. [chrisr3d]

  - Duplication can happen when the result of the
    import process is an event that already exists
- [security] setting a favourite homepage was not CSRF protected.
  [iglocska]

  - a user could be lured into setting a MISP home-page outside of the MISP baseurl
  - switched the endpoint to be CSRF protection enabled

  - as discovered by Mislav Božičević <mislav.bozicevic@nn.cz>
- [opendata export] Fixed resource deletion query creation to avoid
  silent syntax errors. [chrisr3d]
- [stix] Store synonymsToTagNames.json file in tmp folder. [Jakub
  Onderka]
- [mail] Contacting only event creator. [Jakub Onderka]

  Fix sending e-mails in Contact Reporter for when 'Submit only to the person that created the event' is checked
- [mail] Contact reporter body. [Jakub Onderka]

  Do not send that GPG or Public key are sent as attachment, when user don't have them
- [proposals] re-edded the edit view for propsoals. [iglocska]
- [security] Remove ShadowAttributesController::{getProposalsByUuid,getP
  roposalsByUuidList} [Jakub Onderka]

  These methods are not used, but they let sync users to access proposals for any event.
- [security] Remove
  ShadowAttributesController::{fetchEditForm,editField} [Jakub Onderka]

  These methods are not used, but they allow to access attribute data without proper ACL checks.
- [MispObject] Do not unpublish synced events, fixes #4838. [Richard van
  den Berg]
- [UI] Attribute category select. [Jakub Onderka]
- [internal] Do not try to access bool as array. [Jakub Onderka]
- [stix2 import] Better markings parsing for both created with MISP and
  external STIX. [chrisr3d]
- [stix2 export] Fixed Markings export following the recent changes on
  ListProperty. [chrisr3d]
- [sharingGroup:captureSharingGroup] Fix failing capture in case of
  roaming mode. [mokaddem]

  - The server list check was incorrect
  - When capturing, roaming mode was always defaulted to false
  - The logs could not be written due to non-initialized class
- [acl] Added event block rule. [iglocska]
- [security] Check event ACL before allowing user to send event contact
  form. [Jakub Onderka]
- [stix2 export] Fixed first_seen/last_seen field parsing. [chrisr3d]
- [returnAttributes] remap small cleanup. [iglocska]

  - no need to set xml as returnformat, it's the default based on the injected params
- [security] deprecated function with lacking ACL removed. [iglocska]

  - replaced deprecated, sharing group unaware, broken function with one that follows the documentation of the deprecated endpoint
  - keeping it alive until we purge the deprecated ones in the move to MISP 3/next whatever

  - Thanks to Jakub Onderka for reporting it!
- [security] Insufficient ACL checks in the attachment downloader fixed
  - Thanks to Jakub Onderka for reporting it. [mokaddem]
- [tag:checkForOverride] Catch if tag didn't have a numerical value
  before the override. [mokaddem]
- [user:registration] Report field validations to the user. Fix #6072
  and #6073. [mokaddem]
- [stix2] Fixed conversion of object relations containing dots into
  custom object values. [chrisr3d]

  - Also includes changes to support the import of
    custom objects into MISP objects containing
    object relations with dots, to avoid issues or
    changes on the mapping
- [stix2] Fixed issue with custom object created from MISP object with
  underscore in the name. [chrisr3d]

  - Includes fix to export the objects into custom
    objects, and to import custom objects into MISP
    objects back
  - Should fix #6046
- [UI] Fetching from not enabled feed should be error. [Jakub Onderka]
- [feed] Incorrect call in Feed::__saveEvent. [Jakub Onderka]
- [internal] Do not create empty link for anonymized org sighting.
  [Jakub Onderka]
- [UI] Expanding attribute correlations on other pages. [Jakub Onderka]
- [stix2 export] Fixed datetime issue with the 'created' field of some
  stix objects. [chrisr3d]

  - Following some changes on the python stix2
    library, that caused an issue with the previous
    way we created the 'created' field
- [mail] Fix body of passwordReset/newUser emails. [Václav Bartoš]

  When MISP sends an email with new credentials, the body is generated from one of the configured templates - passwordResetText or newUserText. However, these two templates were swapped - the newUserText was used for password reset, while passwordResetText was used when new account is created.

  This commit fixes it.
- [internal] HTML code fix. [Jakub Onderka]

Other
~~~~~
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #6110 from RichieB2B/ncsc-nl/unlink. [Andras
  Iklody]

  fix: [StixExport] suppress unlink warnings
- Merge pull request #6109 from RichieB2B/nscc-nl/stixfix. [Andras
  Iklody]

  fix: [stix export] log stack trace on error, support 'AMBER NATO ALLI…
- Merge pull request #6108 from RichieB2B/ncsc-nl/fix-retention. [Andras
  Iklody]

  fix: [misp_retention] Support objects, use lists for build_complex_qu…
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge pull request #6067 from JakubOnderka/fix-composite-type-
  uniquenes. [Andras Iklody]

  fix: [attributes] Possible duplicate attributes
- Merge pull request #6069 from JakubOnderka/patch-119. [Andras Iklody]

  fix: [internal] Missing field for server model when editing event
- Merge pull request #6089 from JakubOnderka/add-attribute-ui-fixes.
  [Andras Iklody]

  chg: [UI] Add attribute fixes
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge pull request #6071 from JakubOnderka/patch-120. [Andras Iklody]

  fix: [stix] Store synonymsToTagNames.json file in tmp folder
- Merge pull request #6070 from JakubOnderka/cidr-correlation-optim.
  [Andras Iklody]

  Cidr correlation optim
- Merge pull request #6036 from JakubOnderka/cache-freetext-feed-optim.
  [Andras Iklody]

  chg: [feed] Faster freetext feed caching
- Merge pull request #6044 from JakubOnderka/sort-tags-by-name. [Andras
  Iklody]

  chg: [UI] Sort tags by name for server rules
- Merge pull request #6035 from JakubOnderka/rest-search-optim. [Andras
  Iklody]

  chg: [internal] Attribute REST search optimisations and error handling
- Merge pull request #5963 from JakubOnderka/patch-108. [Andras Iklody]

  fix: [mail] Contact reporter body
- Merge pull request #6092 from JakubOnderka/event-ui. [Andras Iklody]

  chg: [internal] Simplify and optimise eventUI method
- Merge pull request #6087 from JakubOnderka/zip-ext. [Andras Iklody]

  new: [diag] Check if ZIP extension is installed
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch 'fix-sg-creation' into 2.4. [mokaddem]
- Merge remote-tracking branch 'origin/2.4' into fix-sg-creation.
  [mokaddem]
- Merge pull request #6095 from JakubOnderka/shadow-attribute-unused-
  vol2. [Andras Iklody]

  fix: [security] Remove ShadowAttributesController::{getProposalsByUuid,getProposalsByUuidList}
- Merge pull request #6093 from JakubOnderka/shadow-attribute-unused.
  [Andras Iklody]

  fix: [security] Remove ShadowAttributesController::{fetchEditForm,editField}
- Merge pull request #6094 from RichieB2B/ncsc-nl/stop-loop. [Andras
  Iklody]

  fix: [MispObject] Do not unpublish synced events, fixes #4838
- Merge pull request #6088 from JakubOnderka/patch-121. [Andras Iklody]

  fix: [UI] Attribute category select
- Merge pull request #6075 from JakubOnderka/bool-is-not-array. [Andras
  Iklody]

  fix: [internal] Do not try to access bool as array
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge pull request #6078 from JakubOnderka/fix-acl. [Andras Iklody]

  chg: [ACL] Allow to access to fetchOrgsForSG and fetchServersForSG...
- Merge pull request #6079 from legoguy1000/update_AuthkeyShell. [Andras
  Iklody]

  Allow you to mannually set the API key for automation purposes
- Allow you to mannually set the API key for automation purposes. [Alex
  Resnick]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #6077 from JakubOnderka/contact-acl. [Andras
  Iklody]

  fix: [security] Check event ACL before allowing user to send event contact form
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge pull request #6063 from JakubOnderka/patch-118. [Andras Iklody]

  fix: [UI] Fetching from not enabled feed should be error
- Merge pull request #6062 from JakubOnderka/feed-incorect-call. [Andras
  Iklody]

  fix: [feed] Incorrect call in Feed::__saveEvent
- Merge pull request #6064 from obert01/fix-diag-accessibility. [Andras
  Iklody]
- Added proper ARIA properties for the "fix" button in the DB index and
  DB schema diagnostic tables. [Olivier BERT]
- Merge pull request #6061 from JakubOnderka/list-sightings-ui. [Andras
  Iklody]

  fix: [internal] Do not create empty link for anonymized org sighting
- Merge pull request #6060 from JakubOnderka/correlation-expand-fi.
  [Andras Iklody]

  fix: [UI] Expanding attribute correlations on other pages
- Ch: Bump warninglists. [Raphaël Vinot]
- Ch: Bump misp-objects. [Raphaël Vinot]
- Merge pull request #5985 from vaclavbartos/2.4. [Andras Iklody]

  fix: [mail] Fix body of passwordReset/newUser emails
- Merge pull request #6026 from JakubOnderka/save-sightings-
  optimisation. [Andras Iklody]

  Save sightings optimisation
- Merge pull request #6043 from StefanKelm/2.4. [Andras Iklody]

  Update side_menu.ctp
- Update side_menu.ctp. [StefanKelm]

  Adjusts menu to be in line with "Global Actions"
- Merge pull request #6045 from JakubOnderka/sightings-loading-optim.
  [Andras Iklody]

  chg: [internal] Faster loading sightings if the same attribute is req…
- Merge pull request #6049 from JakubOnderka/patch-116. [Andras Iklody]

  fix: [internal] HTML code fix


v2.4.128 (2020-06-22)
---------------------

New
~~~
- [correlations] Enable CIDR correlations for ip-src|port and ip-
  dst|port types. [Jakub Onderka]

Changes
~~~~~~~
- [version] bump. [iglocska]
- [PyMISP] Bump. [Raphaël Vinot]
- [stix2 import] Parsing external pattern made with 'OR' separators the
  same way we do for pattern with 'AND' [chrisr3d]

  - Also slight update of some mapping dictionaries
    to go with the changes introduced with this
    commit on the main script
- [stix2 tests] Bumped the latest MISP & STIX2 test files. [chrisr3d]
- [correlations] Faster IPv4 CIDR correlation. [Jakub Onderka]
- [correlations] Faster IPv6 correlation. [Jakub Onderka]
- [correlations] Big speedup when correlating CIDR. [Jakub Onderka]
- [widget] remove unused var, make test pass. [Jean-Louis Huynen]
- [stix2 import] Moved all the mapping dictionaries to the mapping
  script. [chrisr3d]
- [stix2 import] Temporary rework stix2 to misp script should now be
  ready to replace the original stix2 to misp script. [chrisr3d]
- Bump PyMISP. [Raphaël Vinot]
- [stix2 import] Better parsing for patterns we always import as single
  attributes. [chrisr3d]
- [stix2 import] Generic way of dealing with payloads in external file &
  artifact patterns. [chrisr3d]

  - After struggling a lot with the different use
    cases, we ended up with the following process:
      - checking if any file:content_ref is there
        and grouping the content refs features
        together if possible
      - After all the content refs have been parsed,
        we check if there still is some payloads
- [stix2 export] Moved the Attributes parsing functions into the main
  script. [chrisr3d]

  - Also checked the mapping to find potential bugs,
    and fixed/updated some fields (in observed-data
    and indicators)
- [stix2 import] Observable single attributes parsing functions are now
  in the main script. [chrisr3d]

  - Also update of the mapping dictionary with the
    latest updated functions moved from the mapping
    script to the main script
- [stixtest] JQing MISP event result from a STIX import for more visual
  ease. [chrisr3d]
- [stix1 import] Better parsing of ttps, threat actors & courses of
  action. [chrisr3d]
- [stixtest] Updated the STIX1 test files following the changes on the
  test MISP events. [chrisr3d]
- [stixtest] Updated stix2 test files with the most recent changes on
  the related MISP events, and on the export script. [chrisr3d]
- [stixtest] Test MISP events up-to-date. [chrisr3d]
- [stix2 export] Exporting Course of Action object attributes as custom
  properties if not supported. [chrisr3d]
- [stix2] Bumped latest stix2 python library. [chrisr3d]
- [stixtest] Updated the stix1 test files. [chrisr3d]
- [stix1 export] Exporting Galaxies per TTP, Threat Actor or COA.
  [chrisr3d]

  - Exporting each galaxy as one TTP, Threat Actor,
    or Course of Action instead of exporting each
    Galaxy Cluster individually
  - All clusters of a same galaxy are exported in
    the same TTP, Threat Actor or Course of Action
- [stix2 import] Mapping galaxy cluster names with their corresponding
  tag names. [chrisr3d]

  - We map existing cluster names with the json file
    of synonyms mapped with tag names generated by
    MISP and introduced in the latest commit
  - If there is not association, we just add a tag
    looking like a galaxy tag name. The difference
    is this tag will not be recognized as a proper
    galaxy tag name and will stay as a tag
- [stix import] Passing a mapping of cluster name with tag names as
  parameter of the import scripts. [chrisr3d]

  - We map GalaxyCluster names and synonyms with the
    associated tag names
  - This mapping will be used in the python stix 1&2
    import scripts so they can return the correct
    tag names about galaxies

Fix
~~~
- [stix2 import] Quick issues fixing. [chrisr3d]

  - Fixed issue that could happen sometimes during
    an external pattern parsing when we split the
    identifier of the pattern from the value.
    We now make sure the identifier is stripped, so
    we avoid issues with the mapping dictionaries
    that could not recognize it
  - Also displaying  a warning message when we have
    no attributes resulting from the parsing of an
    external pattern or observable object
- [stix2 import] Small update on the mapping to work with some external
  patterns seen recently. [chrisr3d]
- [stix2 import] Fixed some external observable objects import.
  [chrisr3d]
- [stix2 import] Fixed no longer existing variable in the mapping
  script. [chrisr3d]
- [stix2 import] Added the function to parse external email-address
  observable objects, that was missing. [chrisr3d]
- [UI] Typo. [Jakub Onderka]
- [stix2 import] Better way of parsing some attributes and objects.
  [chrisr3d]

  - For single attributes that could be part of an
    object and would lose some context if imported
    as single attribute without their object
    relation (mostly attributes of type 'text'),
    we decide to import them as object anyway to
    avoid the increase of context-less attributes
  - Also cleaner way to parse observable objects and
    patterns that will alwyas give single attributes
- [stix2 export] Typo in variable name. [chrisr3d]
- [stix2 export] Reverted the email object attribute 'from' export as
  observable object. [chrisr3d]

  - From-ref is always a single value, we cannot use
    a list of references
- [stix2 export] Fixed email object attributes export into pattern.
  [chrisr3d]
- [stix2 export] Avoiding issues with attributes with no Galaxy field.
  [chrisr3d]
- [stix2 export] Fixed x509 object export. [chrisr3d]

  - x509 fingerprint hashes parsing was pointing to
    a part of a mapping dict which does not exist
- [stix2 import] Fixed external pattern parsing for pe section
  attributes. [chrisr3d]

  - As an example, instead of storing the full
    pattern identifiers, like:
    "file:extensions.'windows-pebinary-ext'.section.name"
    we only store what is usefull (name) for the
    parsing part where we check the mapping dict
    to find the corresponding attribute type and
    object_relation
- [stix2 import] Importing external vulnerabilities as single attribute
  or object depending on the case. [chrisr3d]

  - In other words, we made available the import of
    vulnerabilities as single attributes when only
    a name is present in the STIX object
  - Was only importing vulnerability objects before,
    which does not change if there is more than only
    the name within the STIX vulnerability object
- [stix2 import] Removed unused variable that was used for debug
  purposes. [chrisr3d]
- [stix2 import] Cleaner autonomous system observable import. [chrisr3d]

  (for STIX documents generated with MISP)
- [stix2 import] Parsing timeline features on single attributes.
  [chrisr3d]

  - As it is parsed for imported objects
  - It adds timestamp, first_seen & last_seen values
    on single attributes accordingly
- [stix2 import] Fixed email reply-to single attribute import.
  [chrisr3d]
- [stix2 import] Fixed payload_bin import into single MISP attribute.
  [chrisr3d]
- [stix2 export] Fixed email-reply-to export in observable object.
  [chrisr3d]
- [stix2 export] Removed unused import. [chrisr3d]
- [stix2 import] Importing PyMISP from the submoduled library.
  [chrisr3d]

  - As it is in the currently used stix2 import
    script which is going to be replaced by this one
  - Avoids issues when the python library is not
    installed with pip
- [stix2 import] More generic network-traffic references parsing.
  [chrisr3d]

  - Also fixing some edge cases of reference parsing
    with the wrong mapping
    (network_traffic_references_mapping no longer exists)
- [stix2 import] Fixed single attributes import following changes on the
  export part. [chrisr3d]
- [stix2 export] Making sure we have the required name field set while
  exporting regkey values from a MISP regkey object to a STIX observed
  data. [chrisr3d]
- [stix2 export] Fixed regkey|value expor. [chrisr3d]

  - Revert to the initial mapping that has been
    changed to the wrong field: the value should be
    mapped to the data field and instead of name
- [stix2 export] Removed unused mapping dictionary fields. [chrisr3d]
- [stix2 export] Removed object attributes added in file patterns for
  test purposes. [chrisr3d]
- [stix2 export] Removed object attributes added for test purposes.
  [chrisr3d]
- [stix2 import] Writing import results as expected in the result file.
  [chrisr3d]
- [stix2 import] Fixed relationships parsing. [chrisr3d]

  - Using iterators is good for a single iteration,
    but not for more, including an if test
  - Using tuples instead is better and avoids then
    losing our relationships
- [stix1 import] Better parsing of malware instances within ttps.
  [chrisr3d]

  - In some cases when malware instances within ttps
    do not have a title but one or more name(s), we
    need to use them instead of the title
- [stix1 import] Fixed malware instance parsing. [chrisr3d]
- [stix2 import] Typo. [chrisr3d]
- [stix2 test] Typo. [chrisr3d]
- [stix2 import] Handling external STIX file pattern properly.
  [chrisr3d]

  - If there is no extension (case which has been
    fixed in the few last commit), we need to check
    if we have to create a MISP attribute or object
  - We then check if we exctracted one attribute
    from the pattern or more, and create respectively
    a MISP attribute or object
- [stix2 import] Fixed monkey issues... [chrisr3d]
- [stix2 import] Using the expected parameters to handle the file, pe &
  sections objects. [chrisr3d]
- [stix1 import] Some quick fixes on MISP objects parsing. [chrisr3d]

  - Better handling on MISP object name parsing
  - Importing properly MISP object uuid for course
    of action objects
- [stix2 import] Importing event uuid from report. [chrisr3d]

  - The event uuid is set when there is one report
- [stix2 import] Fixed timestamp parsing following the latest changes on
  STIX2 export. [chrisr3d]
- [stix2 import] Fixed timestamp parsing. [chrisr3d]

  - Fixed timestamp parsing of custom objects
- [stix2 import] Fixed attack-pattern & course-of-action object
  attributes parsing. [chrisr3d]

  - Avoids setting the ids flag to false when object
    attributes do not come from an observable object
- [stix2 import] Fixed attack-pattern external_references parsing.
  [chrisr3d]
- [stix2 export] Fixed attack-pattern object export. [chrisr3d]

  - Fixed the id attribute export
  - Supporting expport of the newest 'references'
    attribute added to the object template
- [stix2 import] Fixed file objects import. [chrisr3d]

  - As it has been updated for file objects export,
    we now better support potential multiple fields
    like filename, path and fullpath
  - Also handling properly the special case of a
    file object with an extension field
- [stix2 export] Fixed special case of file with a path property and a
  PE extension. [chrisr3d]

  - If a file object had a path property and a PE
    extension, the extension could be added to the
    wrong part of the observable object
  - We make sure here the extension is attached to
    the observable object related to the file, and
    not to the directory referenced by the file as
    its path
- [stix2 export] Fixed files objects export (patterns & observable
  object) [chrisr3d]

  - Better handling of the data field for attributes
    like malware-sample and attachment
  - Support of path & fullpath attributes export
  - Better handling of potential multiple attributes
    like filename, path and fullpath
- [stix2 export] Fixed artifact name export in pattern as custom
  property. [chrisr3d]
- [stix2 export] Fixed x509-fingerprint-sha1 single attribute export.
  [chrisr3d]
- [stix2 export] Fixed regkey|data attribute export. [chrisr3d]
- [stix2 import] Fixed regkey values observable objects parsing.
  [chrisr3d]
- [stix2 import] Fixed & cleaned network traffic objects. [chrisr3d]
- [stix2 export] Fixed reference typo in network traffic pattern.
  [chrisr3d]
- [stix2 import] Passing mapping variable name instead of the
  dictionary. [chrisr3d]

  - For all the generic parsing functions, we pass
    the mapping variable name and get the attribute
    afterwards instead of passing the dictionary
- [stix2 import] Fixed some observable and pattern parsing issues.
  [chrisr3d]

  - Quick custom property in pattern parsing fixed
  - Fixed file and network socket observable objects
    parsing
- [stix2 export] Fixed SocketExt properties exceptions catching.
  [chrisr3d]

  - address_family is a required property, thus we
    need to handle it separately
  - protocol_family is optional and thus easier to
    handle
- [stix2 import] Some patterns import fixed. [chrisr3d]

  - AS attribute in asn object is now imported with
    the 'AS' prefix
  - Importing properly attachment attributes in file
    objects
  - pe mapping enhanced
- [stix2 export] Fixed file & vulnerability patterns export. [chrisr3d]
- [stix2 import] Fixed malware sample import in file objects. [chrisr3d]
- [stix2 export] Fixed custom properties for vulnerability and attack
  pattern objects. [chrisr3d]

  - Dashes ('-') in object relations should be
    replaced by underscores as custom properties
    only accept underscores
- [stix2 export] Better file objects export and joining patterns from
  list instead of concatenating strings. [chrisr3d]
- [stix2 import] Better import for some objects. [chrisr3d]

  - Support of custom properties that are lists
  - Support of protocol attribute in network socket
    object
  - Support of group attribute in user account
    object
- [stix2 export] Better export for object attributes of vulnerability
  and attack pattern objects. [chrisr3d]

  - Need to use custom properties in some cases
- [stix2 import] Importing pe attributes from patterns within the pe
  object and not in the file object. [chrisr3d]
- [stix2 import] Fixed file pattern import. [chrisr3d]
- [stix2 import] Better network connection patterns parsing. [chrisr3d]
- [stix2 export] Fixed export of port attribute in network traffic
  patterns. [chrisr3d]
- [stix2 export] Fixed network traffic references in patterns.
  [chrisr3d]
- [stix2 import] Fixed network socket pattern values parsing. [chrisr3d]

  - We do not want to import the single quotes that
    are all around the pattern values
- [stix2 export] Exporting TLP tags as marking definition. [chrisr3d]

  - Marking definition in the case of TLP was
    missing and only the reference to the marking
    definition was exported, but not the actual
    marking definition object
- [stix2 import] Fixed MISP Object creation. [chrisr3d]

  - MISP Object creation function used for attack
    pattern & course of action objects, so they get
    the correct uuid
  - MISP Object creation trying to parse the first
    seen & last seen values without raising issues
    when the object parsed does not have any
- [stix2 export] Fixed file content ref for malware sample exports.
  [chrisr3d]
- [stix2 export] Fixed email attachment export. [chrisr3d]
- [stix2 export] Exporitng process attributes in patterns as intended.
  [chrisr3d]

  - Handling the child ref(s), parent ref, and image
    name values in process patterns
- [stix1 import] Parsing COA_Taken objects as MISP object. [chrisr3d]
- [stix1 export] Exporting category and value in STIX objects title and
  not the attribute/object id. [chrisr3d]
- [stix1 export] No longer exporting object IDs. [chrisr3d]

  - ThreatActors and TTPs titles only use categories
    and values of the attribute/object to define the
    title, and not the attribute/object id anymore
- [stix1 export] Various fixes. [chrisr3d]

  - Got rid of some variables and calling some
    functions directly to parse data withtout
    storing it
  - TTPs, Courses of action and Threat Actors are
    now referenced in related objects only when they
    come from attributes/objects in MISP and not
    when they come from galaxies
- [stix1 export] Tiny fixes. [chrisr3d]

  - Making sure adding an indicator type fails
    because of the mapping between attribute types
    and indicator types does not support a specific
    type, and not because of the indicator not
    accepting the type we want it to have
  - Making sure CAPEC IDs are always starting with
    'CAPEC' in the AttackPattern objects we create
- [stix1 export] Fixed email attachment related objects uuid. [chrisr3d]

  - Email message related objects representing the
    email attachments now have the correct uuid of
    the attachment attribute
  - Before, a random uuid was used, due to the file
    object losing its parent properties while being
    switched from a File object type to a related
    object type
- [stix1 export] Referencing COAs as RelatedCOAs. [chrisr3d]
- [stix1 export] Removed function no longer used. [chrisr3d]
- [stix1 export] Export only cluster values as name or title. [chrisr3d]

  - No longer exporting the Galaxy name within the
    name or title, since we have this information
    somewhere else and the name or title should
    only be the Galaxy cluster name value
- [stix import] Some strings are defined in a cleaner way. [chrisr3d]
- [stix2 import] Skipping adding Galaxy info in the Galaxy field and
  only importing it as tag. [chrisr3d]
- [ACL] unpublished_private global setting tightened to include
  correlations. [iglocska]

  - Thanks to Jakub Onderka for reporting and providing a fix to this!
- [security] missing ACL lookup on attribute correlations. [iglocska]

  - attribute correlation ACL checks are skipped when querying the attribute restsearch API revealing metadata about a correlating but unreachable attribute.

  - Thanks to Jakub Onderka for his tireless work and for reporting this!

Other
~~~~~
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch 'rework_stix' into 2.4. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Merge pull request #6028 from JakubOnderka/patch-115. [Andras Iklody]

  fix: [UI] Typo
- Merge pull request #6022 from MISP/rework_stix. [Andras Iklody]

  STIX parsing updates
- Cleanup: [stix] Cleaned up the recently changed scripts. [chrisr3d]

  Including:
  - Removed some unused imports and variable
  - Renamed some variable which could have been
    built-in methods redefinition
  - Typos
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Merge pull request #5916 from JakubOnderka/patch-100. [Andras Iklody]

  chg: [correlations] Big speedup when correlating CIDR
- Merge pull request #6019 from D4-project/2.4. [Andras Iklody]

  add [widget] Authentication failure widget
- Add [widget] Authentication failure widget. [Jean-Louis Huynen]
- Wip: [stix2 import] More complete external patterns mapping.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Wip: [stix2 import] Importing external domain, ip & network traffic
  patterns. [chrisr3d]
- Wip: [stix2 import] Importing external network traffic patterns.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Wip: [stix2 import] Importing external email patterns. [chrisr3d]

  - Parsing function to split attachments fields
    from all the other fields already implemented,
    we just added the attachment parsing and the
    attributes handling at the end
  - Also slight fixes on the from, to and cc refs
    following the last fix on the export side
- Wip: [stix2 import] Handling import case for indicators of which we
  already parsed the pattern. [chrisr3d]
- Wip: [stix2 import] Importing external process indicators. [chrisr3d]
- Wip: [stix2 import] Importing external url indicator based on the
  pattern mapping already implemented. [chrisr3d]

  - tl;dr: We just took the parsed attributes and
    callled the appropriate function to handle the
    import case (attribute or object)
- Wip: [stix2 import] Importing external user-account indicators.
  [chrisr3d]

  - Also fixed some user-account and credential
    mapping dictionaries
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Fix"[stix2 import] Fixed process observable objects parsing for STIX
  documents generated with MISP. [chrisr3d]

  - Little typo and copy-paste issue
- Wip: [stix2 import] Parsing external process observable objects.
  [chrisr3d]

  - Also changed parsing of process observable
    objects from STIX documents generated with MISP
    to apply the same logic to both use cases
- Wip: [stix2 import] Parsing external user_account observable objects.
  [chrisr3d]

  - Mapping into credential or user-account MISP
    objects depending on the case
- Wip: [stix2 import] Finally parsing properly external network traffic
  observable objects with their references and potential extensions.
  [chrisr3d]

  - After struggling a lot on it, we ended up
    parsing external network traffic observable
    objects independently depending on the actual
    references they have or not
  - Chosing this approach instead of the common
    parsing function handling the different use
    cases, we can parse each observable object
    depending on the case, and use common function
    then when we are sure we determined the actual
    situation
  - We no longer start from a common function trying
    to determine the case using lots of tests, we
    already know which case it is and go to the
    common point afterwards
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Wip: [stix2 import] Network traffic references parsing function for
  further reuse. [chrisr3d]
- Wip: [stix2 import] Importing external autonomous system observable
  objects. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Wip: [stix2 import] Importing external x509 observable objects.
  [chrisr3d]
- Wip: [stix2 import] Importing mac-address external observable objects.
  [chrisr3d]

  - Also changed the recently changed mutex import
    to reuse a function to parse all observable
    objects of an observed-data object at once to
    import single attributes
- Wip: [stix2 import] Importing external mutex observable objects.
  [chrisr3d]

  - Also change on a function name for more clarity
    and to differenciate more easily functions for
    observable objects and patterns
- Wip: [stix2 import] Importing external registry-key observable
  objects. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Wip: [stix2 import] Updated external observable mapping: files with
  artifact & directory references. [chrisr3d]

  - The parsing logic is already there since files
    with artifact references and files with directory
    references are supported. We just updated here
    the mapping dictionary
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Wip: [stix2 import] Importing external url observable objects.
  [chrisr3d]
- Wip: [stix2 import] Added warning message if not all the observable
  objects are referenced by an email-message object. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Wip: [stix2 import] Import of external email message & address
  observable objects. [chrisr3d]

  - Reuse of some parsing functions for external and
    MISP generated STIX files
  - Added an email references mapping dict to help
    parsing email addresses, body & content refs
    references by email message objects
  - Fixed another indentation issue
- Wip: [stix2 import] Import of domain and ip observable objects.
  [chrisr3d]

  - Also quick indentation fix
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Wip: [stix2 import] Import of network-traffic and ip external
  observable objects. [chrisr3d]

  - Ongoing rework for external observable objects
    and patterns in progress
- Wip: [stix2 import] Import of external file observable objects.
  [chrisr3d]

  - Support of PE extension to create PE object(s)
    with the corresponding section(s) alongside the
    file object import
  - As always with pe and sections, the appropriate
    references are added too
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Wip: [stix2 import] Starting parsing external observable objects.
  [chrisr3d]

  - Started with file observables
  - Making 'filter_main_object' function available
    for both subclasses to split the observable
    object type we want and all the references
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Wip: [stix2 import] Struggling with the files and payloads import.
  [chrisr3d]
- Wip: [stix2 import] Removed unused mapping dict + moved constant to
  the mapping script. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Wip: [stix2 export] Moved dictionaries in the mapping file & using the
  complete import path instead of import * from the mapping file.
  [chrisr3d]

  - We control and know which mapping dictionary we
    call and that they come from the mapping script
  - Started moving all the mapping dictionaries in
    the mapping file
  - Attributes parsing function will be moved into
    the main script
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Wip: [stix2 import] Moving small parsing functions to the main script.
  [chrisr3d]

  - Also passing the function names only instead of
    storing functions themselves in the dictionary
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Wip: [stix2 import] Parsing single external IP v4 or v6 address.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Wip: [stix2 import] Parsing external relationships, galaxies, tags &
  reports. [chrisr3d]

  (+ Quick fix on internal tags handling)
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Add: [stix2test] New argument to evaluate events using filenames only
  and avoid to query MISP. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Wip: [stix2 import] Handling File objects with PE extension &
  sections. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Wip: [stix2 import] Separating file extensions to be parsed later.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Wip: [stix2 import] Better attack-pattern external references parsing
  + parsing external galaxies. [chrisr3d]
- Wip: [stix2 import] Parsing attack-pattern, course-of-action and
  vulnerability objects from external stix files. [chrisr3d]
- Wip: [stix2 import] Making difference between external and from MISP
  for some STIX object types. [chrisr3d]

  - Including Attack Pattern, Course of Action and
    Vulnerability
  - Also better file pattern parsing
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Wip: [stix2 import] Better parsing for more external patterns.
  [chrisr3d]
- Wip: [stix2 import] Some more external pattern mapped. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Wip: [stix2 import] Starting parsing external patterns. [chrisr3d]
- Wip: [stix2 import] Some quick clean-up. [chrisr3d]

  - Preparing for the future 2.1 import
  - Removing mapping variables no longer used
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Wip: [stix2 import] Importing reports external references as links.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Wip: [stix2 import] Proper parsing of galaxies, and tags. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into rework_stix.
  [chrisr3d]
- Wip: [stix2 import] Loading relationships in a dictionary. [chrisr3d]

  - Thus we can parse them afterwards depending on
    the type of objects they put into relationship
- Wip: [stix2 import] Properly loading galaxies as tags. [chrisr3d]
- Wip: [stix2 import] Import of CourseOfAction, AttackPattern and
  Vulnerability as objects reworked. [chrisr3d]
- Wip: [stix2 export] Defining relationships between observed-data and
  galaxy objects. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Wip: [stix2 import] Updated mapping library + removed
  disable_correlation flags. [chrisr3d]

  - Since we use the object templates directly for
    the objects creation, we do not need to have
    the flag here.
- Wip: [stix2 import] Observable import rework completed. [chrisr3d]
- Wip: [stix2 import] Process observables import reworked. [chrisr3d]
- Wip: [stix2 import] More observable objects reworked. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Wip: [stix2 import] User Account objects import reworked. [chrisr3d]
- Wip: [stix2 import] ASN observable import reworked + functions
  ordered. [chrisr3d]
- Wip: [stix2 import] Credential observable import + standard observable
  parsing function reworked. [chrisr3d]
- Wip: [stix2 import] Network socket import reworked. [chrisr3d]
- Wip: [stix2 import] Import of network connection objects from
  observable. [chrisr3d]
- Wip: [stix2 import] Started reworking observable objects import.
  [chrisr3d]
- Wip: [stix2 import] All known MISP objects mapped with STIX patterning
  are now reworked. [chrisr3d]
- Wip: [stix2 import] Email pattern import. [chrisr3d]
- Wip: [stix2 import] File patterns import reworked. [chrisr3d]
- Wip: [stix2 import] Cleaner pattern import into objects. [chrisr3d]
- Add: [stix2 export] Exporting process image attribute in observable
  objects. [chrisr3d]
- Wip: [stix2 import] Reworking stix2 import. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Add: [stix1 export] Added malpedia in the list of mapped galaxies.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]


v2.4.127 (2020-06-16)
---------------------

New
~~~
- [cli] Command for pulling from all remote servers. [Jakub Onderka]
- [Tag] Allow Tag's numerical_values to be overriden by userSettings.
  [mokaddem]
- [userSettings] New setting `default_restsearch_parameters` [mokaddem]

  It allows users to supply restSearch parameters that will be injected
  (and possibly overridden) into the restSearch filters.
- [type] git-commit-id. [Raphaël Vinot]
- [UI] Add event ID to page table. [Jakub Onderka]

  With more tabs, navigation between tabs with different events can be pain, when all of them has the same title.

Changes
~~~~~~~
- [PyMISP] Bump. [Raphaël Vinot]
- [version] bump. [iglocska]
- [internal] Log exception if exception is thrown during event
  downloading. [Jakub Onderka]
- [misp-warninglists] updated to the latest version. [Alexandre
  Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [submodules] Use repository default branch (main) [Raphaël Vinot]
- [PyMISP] Rename branch master -> main. [Raphaël Vinot]
- [misp-taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [misp-warninglists] updated to the latest version. [Alexandre
  Dulaunoy]
- [internal] Bump CakePHP to 2.10.22. [Jakub Onderka]
- [internal] Drop
  correlations.{org_id,sharing_group_id,a_sharing_group_id} indexes.
  [Jakub Onderka]
- [internal] Drop correlations.value index. [Jakub Onderka]
- [taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [internal] Log exception when querying modules. [Jakub Onderka]
- [decayingModel:listTaxoWithNumericalValue] Cleaner usage of uppercased
  tag. [mokaddem]
- [taxonomy] Fixed typo. [mokaddem]
- [UI] Make Enrichment Results little bit nicer. [Jakub Onderka]
- [events:distributionGraph] Added close button in popover. Fix #5978.
  [mokaddem]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [tags:checkForOverride] Do not duplicate user id variable. [mokaddem]
- [tools] re-add fixed module. [Steve Clement]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [decaying] `last_seen` takes precedence over `timestamp` [mokaddem]

  If `last_seen` is set, it will take precedence over the timestamp if no
  sightings have been recorded.
  By doing so, we prevent the score to be refreshed if the attribute is
  slightly modified (a tag is added/removed)
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [usernamehelper] cheese. [iglocska]
- [PyMISP] Dump. [Raphaël Vinot]
- [correlation] When generating correlation, just fetch attributes that
  can correlate. [Jakub Onderka]
- [correlations] Refactored correlation saving. [Jakub Onderka]

  * Always show other correlating value (useful for CIDR correlations)
  * Make correlation saving faster (move more work to database, do not fetch not necessary fields)
  * Fix some small bugs
- [doc] Updates to OpenBSD Install (which fails ATM) [Steve Clement]
- [doc] Variable updates. [Steve Clement]
- [doc] Reshuffled docs. [Steve Clement]
- [doc] Update to OpenBSD 6.7. [Steve Clement]
- [cakephp] bump. [iglocska]

  - updates cakephp to include the UUID generation fix by @RichieB2B to solve the deficiency discovered by @JakubOnderka. You guys rock.
- [internal] Faster removing galaxy cluster tags from attributes. [Jakub
  Onderka]
- [UI] Nicer icon for form info. [Jakub Onderka]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [installer] Updated to latest Installer. [Steve Clement]
- [var] Wrapped vars {} - Made loops around git clones (for ctrl-c
  resumeability) [Steve Clement]
- [galaxy] bump. [iglocska]
- [feed] Provide more info when caching feeds about failures. [Jakub
  Onderka]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]

Fix
~~~
- [UI] Double Discussion header when sending comment. [Jakub Onderka]
- [internal] object level restsearch issues resolved when querying via
  filters on the attribute scope, fixes #6016. [iglocska]

  - use subqueries instead of trying to query on the current scope
  - associated find queries don't work on habtm relationships
- [pull] Correct progress for pull job. [Jakub Onderka]
- [internal] Removing attributes from empty event. [Jakub Onderka]
- [feeds:saveFreetext] Soft-delete Attributes when performing a delta-
  merge. [mokaddem]
- [EventShell:enrichment] Improved reporting of error messages.
  [mokaddem]
- [users:change_pw] Return error message when trying to use the same
  password. Fix #5961. [mokaddem]
- [galaxy] Fetch all events for galaxy cluster. [Jakub Onderka]
- [UI] Show feed caching just for site admins. [Jakub Onderka]

  Without this patch, when user is not site admin, for all feeds is showed 'Not cached', that is not true. And it also generates a lot of warnings to debug log.
- [www] webserver user is www on OpenBSD. [Steve Clement]
- [attribute:fetchAttribute] Prevent notices if tags not set while
  computing decay. [mokaddem]
- [internal] Remove unused method. [Jakub Onderka]
- [UI] Module diagnostic colors. [Jakub Onderka]
- [attribute] Do not allow for IPv4 CIDR masklen bigger than 32. [Jakub
  Onderka]
- [internal] Notices in PHP 7.4 for login page. [Jakub Onderka]
- [UI] Bootstrap 2 doesn't support auto position for popover. [Jakub
  Onderka]
- [internal] Fix notice in PHP7.4 when loading events attrs by ajax.
  [Jakub Onderka]
- [internal] Branch setting don't have level value. [Jakub Onderka]
- [internal] Remove duplicate code that cause error in PHP 7.4. [Jakub
  Onderka]
- [internal] Check if user is logged before checking if he is site
  admin. [Jakub Onderka]
- [internal] Set notifications count and loggedInUserName just for
  logged users. [Jakub Onderka]
- [documentation] Typo with the CLI function name. Fix #5931. [Sami
  Mokaddem]
- [UI] Do not show Good-Bye when using custom logout. [Jakub Onderka]

  Becuse without this patch, Good-Bye is show when user successfully log in.
- [UI] Galaxy cluster links should be clickable. [Jakub Onderka]
- [whitelist] Correclty refresh the cached values. Fix #3772. [mokaddem]

Other
~~~~~
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Raphaël Vinot]
- Merge pull request #5992 from JakubOnderka/download-event-log-
  exception. [Andras Iklody]

  chg: [internal] Log exception if exception is thrown during event dow…
- Merge pull request #6017 from JakubOnderka/patch-114. [Andras Iklody]

  fix: [UI] Double Discussion header when sending comment
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #6015 from GlennHD/patch-2. [Andras Iklody]

  Removed hosts-file.net feeds from default feeds
- Removing hosts-files.net files. [GlennHD]

  Malwarebytes has discontinued the feed:  https://forums.malwarebytes.com/topic/258056-hosts-filenet-domain-lists-are-broken-what-happened/
- Merge pull request #5993 from JakubOnderka/pull-progress. [Andras
  Iklody]

  fix: [pull] Correct progress for pull job
- Merge pull request #6007 from imidoriya/2.4. [Andras Iklody]

  Fix issue #6006 - sgsids is never set
- Fix issue #6006 - sgsids never set. [deku]

  This value is never set.  I expect it should be $sgids from the incoming function variable.
- Merge pull request #5990 from cudeso/2.4. [Alexandre Dulaunoy]

  Dashboard widgets
- Avoid us of extra variable treshold. [Koen Van Impe]
- Dashboard widgets. [Koen Van Impe]

  - Widget to display system resources (df, cpu, mem)
  - Widget to display the latest sightings
  - Widget to display the false positive sightings above certain treshold
- Merge pull request #6003 from GlennHD/patch-1. [Alexandre Dulaunoy]

  Fixed typo
- Fixed typo. [GlennHD]

  Fixed typo
- Merge pull request #5999 from JakubOnderka/pull-all. [Andras Iklody]

  new: [cli] Command for pulling from all remote servers
- Merge pull request #5996 from JakubOnderka/bump-cake. [Andras Iklody]

  chg: [internal] Bump CakePHP to 2.10.22
- Merge pull request #5991 from JakubOnderka/drop-big-index. [Andras
  Iklody]

  chg: [internal] Drop correlations indexes
- Merge branch 'decaying-v2' into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into decaying-v2.
  [mokaddem]
- Merge pull request #5988 from JakubOnderka/patch-113. [Andras Iklody]

  fix: [internal] Removing attributes from empty event
- Merge pull request #5984 from JakubOnderka/patch-112. [Alexandre
  Dulaunoy]

  chg: [internal] Log exception when querying modules
- Merge branch '2.4' of github.com:MISP/MISP into decaying-v2.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge pull request #5972 from JakubOnderka/patch-111. [Andras Iklody]

  chg: [UI] Make Enrichment Results little bit nicer
- Merge pull request #5973 from MISP/fix-soft-delete-feed-delta-merge.
  [Andras Iklody]

  Soft-delete Attributes when performing a feed delta-merge
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Add: [stix2] Supporting import & export of file encoding attributes in
  file objects. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into decaying-v2.
  [mokaddem]
- Merge pull request #5964 from JakubOnderka/patch-109. [Andras Iklody]

  fix: [galaxy] Fetch all events for galaxy cluster
- Merge pull request #5965 from JakubOnderka/patch-110. [Andras Iklody]

  fix: [UI] Show feed caching just for site admins
- Merge pull request #5958 from eschultze/eschultze-phishstats.
  [Alexandre Dulaunoy]

  [feed] Add phishstats.info
- Add phishstats.info. [eschultze]
- Merge pull request #5959 from SteveClement/tools. [Steve Clement]
- Merge pull request #5952 from JakubOnderka/patch-107. [Andras Iklody]

  fix: [internal] Remove unused method
- Merge pull request #5955 from JakubOnderka/confusing-module-
  diagnostic. [Andras Iklody]

  fix: [UI] Module diagnostic colors
- Merge pull request #5941 from MISP/git-commit-id. [Raphaël Vinot]

  new: [type] git-commit-id
- Merge pull request #5942 from JakubOnderka/correlation-saving. [Andras
  Iklody]

  Correlation saving
- Merge pull request #5906 from JakubOnderka/fix-ipv4-cidr-validation.
  [Andras Iklody]

  fix: [attribute] Do not allow for IPv4 CIDR masklen bigger than 32
- Merge pull request #5938 from SteveClement/guides. [Steve Clement]
- Merge pull request #5937 from SteveClement/guides. [Steve Clement]
- Merge pull request #5936 from JakubOnderka/php74-errors. [Andras
  Iklody]

  fix: [internal] Notices in PHP 7.4 for login page
- Merge pull request #5935 from JakubOnderka/patch-106. [Andras Iklody]

  fix: [UI] Bootstrap 2 doesn't support auto position for popover
- Merge pull request #5924 from JakubOnderka/php74-errors. [Andras
  Iklody]

  Fix notices in PHP 7.4
- Merge pull request #5934 from JakubOnderka/remove-galaxy-tags. [Andras
  Iklody]

  chg: [internal] Faster removing galaxy cluster tags from attributes
- Merge pull request #5933 from JakubOnderka/patch-105. [Andras Iklody]

  chg: [UI] Nicer icon for form info
- Merge pull request #5930 from SteveClement/guides. [Steve Clement]
- Merge pull request #5928 from JakubOnderka/patch-104. [Andras Iklody]

  fix: [UI] Do not show Good-Bye when using custom logout
- Merge pull request #5925 from JakubOnderka/patch-102. [Alexandre
  Dulaunoy]

  fix: [UI] Galaxy cluster links should be clickable
- Merge pull request #5926 from JakubOnderka/patch-103. [Andras Iklody]

  new: [UI] Add event ID to page table
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch 'pr-5256' into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into pr-5256. [mokaddem]


v2.4.126 (2020-05-18)
---------------------

New
~~~
- [internal] Do not log auhtkeys. [Jakub Onderka]
- [tool] Generates communities webpage. [Christophe Vandeplas]
- [pubsub] Show info about processed messages. [Jakub Onderka]
- [UI] Make clear that the textarea under event is discussion. [Jakub
  Onderka]
- [sync] (for now) undocumented force pull added. [iglocska]

  - can only be triggered via the CLI for now
  - usage: /var/www/MISP/app/Console/cake Server pull [user_id] [server_id] [technique] [force]
    - the force flag has to be passed as 'force' to avoid accidentally triggering it

  - What it does:
    - pulls ignoring the timetamp differences
    - this means that even older states of events, attributes, objects are ingested
    - useful for when wanting to reset an event / all events to align with an upstream server
  - Caveats:
    - attributes added on the low side are maintained
    - tags added on the low side are maintained
    - keep in mind this WILL override attributes that are soft deleted
- [restsearch] object restsearch now has the metadata flag. [iglocska]

  - when set, no attributes are returned
- [API] added threat_level_id as a restSearch filter. [iglocska]
- [statistics] added contributing org count. [iglocska]

Changes
~~~~~~~
- Bump PyMISP. [Raphaël Vinot]
- [version] bump. [iglocska]
- [misp-taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [ui] Simplified code for OrgImgHelper. [Jakub Onderka]
- [installer] Version bump. [Steve Clement]
- [installer] Version bump. [Steve Clement]
- [installer] Update after Kali Linux fix. [Steve Clement]
- [kali] More fixes, perhaps installing cake is useful?! 200QI. [Steve
  Clement]
- [kali] More kali fixes and do not udpate apt all the time. [Steve
  Clement]
- [kali] Added more kali tweaks, remove 2019.x compat. [Steve Clement]
- [kali] Some more tweaks and a check if enough space available. [Steve
  Clement]
- [installer] Version bump. [Steve Clement]
- [bash] various bash specific enhances
  (https://stackoverflow.com/questions/3427872/whats-the-difference-
  between-and-in-bash) [Steve Clement]
- [PyMISP] Bump. [Raphaël Vinot]
- [opendata] Bumped latest misp-opendata submodule version. [chrisr3d]
- [PyMISP] Bump. [Raphaël Vinot]
- [server:dbSchema] Added support of mysql's `extra` column. Fix #5860.
  [mokaddem]
- [pubsub] Refactored PubSub tool. [Jakub Onderka]
- [feed] Use https when fetching DGAs feed. [Jakub Onderka]
- [feed] Modify value when checking if value exists in current event.
  [Jakub Onderka]
- [internal] Do not call Configure method for every attribute. [Jakub
  Onderka]
- [correlations] Faster inserting data to Redis. [Jakub Onderka]
- [correlations] Use faster algorithm for IPv6 correlations. [Jakub
  Onderka]
- [installer] Installer bump. [Steve Clement]
- [doc] Various install guide updates. [Steve Clement]
- [internal] Faster saving attributes. [Jakub Onderka]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [test] Set required GnuPG setting. [Jakub Onderka]
- [test] Use debug transport for sending emails. [Jakub Onderka]
- [restSearch] Option to skip fetching attributes/events when only the
  metadata is wanted. [chrisr3d]

  - As for the opendata export we do not need to get
    the attributes or event, and are only interested
    in using the metadata, a parameter to skip
    fetching the actual data collection has been
    added, and we avoid iterating through the entire
    data collection.
- [opendata] Bumped latest misp-opendata updates. [chrisr3d]
- [opendata export] Checking opendata setup and raising exception in
  case of error. [chrisr3d]
- [opendata] Bumped the latest updates on the opendata python script.
  [chrisr3d]
- [user:finaliseAndSendEmail] Aggresively catch errors and log them
  while sending email. [mokaddem]
- Bump PyMISP. [Raphaël Vinot]
- [roles] allow the creation site admin enabled roles without auth
  access. [iglocska]
- [i18n] Updated: zh-s. [Applenice]
- [i18n] Updated: zh-s. [Applenice]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [installer] Bump version. [Steve Clement]
- [doc] Make misp-modules work again. [Steve Clement]
- [installer] Version Bump. [Steve Clement]

Fix
~~~
- [security] xss in the resolved attributes view. [iglocska]

  - thanks to Jakub Onderka for reporting it
- [UI] Always use capital UUID. [Jakub Onderka]
- [feed] Follow redirect when fetching manifest. [Jakub Onderka]
- Allow_disabling_correlation not taken into account. [Golbark]
- [ui] Always show full logo for related events box. [Jakub Onderka]
- [correlations] Ssdeep check all chunks. [Jakub Onderka]
- [bug] '' != "" especially when trying to eval vars. [Steve Clement]
- [kali] Some issues with function aliasing. [Steve Clement]
- [bash] Alias functions need a function and not a string... [Steve
  Clement]
- [kali] More fixes to make sure composer install correctly. [Steve
  Clement]
- [kali] More kali fixes. [Steve Clement]
- [installler] Little bug, code would never detect a VM... [Steve
  Clement]
- [kali] When it's ugly, it looks like this. [Steve Clement]
- [doc] mkdocs needs to be kept below a certain version. [Steve Clement]
- [kali] Kali installer fixes. [Steve Clement]
- [kali] Kali is now 2020.x need to fix. [Steve Clement]
- [opendata export] Using external_baseurl if set, before baseurl.
  [chrisr3d]

  - If external_baseurl is not set, baseurl is used
- [opendata export] Internalization of the error messages. [chrisr3d]
- [opendata export] Less confusing variable name for the parameter to
  only skip exporting the data and keep only the header. [chrisr3d]
- [stix2 export] Fixed CustomObject creation for MISP objects.
  [chrisr3d]
- [stix2 export] Fixed custom objects export from misp objects.
  [chrisr3d]
- [stix1 import] Fixed ttps list attribute name for STIX document
  created with MISP. [chrisr3d]
- [feed:edit] Do not override feed settings if not provided via the API.
  Fix #5896. [mokaddem]
- [indexTable:quickFulltextSearch] Encode additional characters enabling
  more search possibilities. Fix #5890. [mokaddem]
- [sightingdbs:model] Added default value for `timestamp`. Fix #5887.
  [mokaddem]
- [attribute:simpleAddMalwareSample] Typo in loading `Object` class. Fix
  #5864. [mokaddem]

  - Was not spotted before because the fixed line was if fact doing
  nothing as the class's key was already used
- [correlations] Do not check all attributes when cache is empty. [Jakub
  Onderka]
- [correlations] Correlate ShadowAttribute just if exists. [Jakub
  Onderka]
- [correlations] Do not correlate CIDR with CIDR. [Jakub Onderka]
- [attribute] modifyBeforeValidation fix for `domain|ip` type. [Jakub
  Onderka]
- [correlations] Return just unique values for CIDR list. [Jakub
  Onderka]
- [correlations] IPv6 CIDR correlations works. [Jakub Onderka]
- [correlations] Removed unnecessary Redis call. [Jakub Onderka]
- [correlations] Remove references to not exists type 'domain-ip' [Jakub
  Onderka]
- [diagnostic] Updated required version for the stix python library.
  [chrisr3d]
- [stix1 import] Fixed uuids parsing. [chrisr3d]

  - Using the built-in uuid parsing method to avoid
    potential issues when some uuids are provided
    without dashes, instead of getting is as a
    string, which fails when there is no dash
- [stix1 import] Fixed ttps list attribute name. [chrisr3d]
- [feed] Job progressbar fix. [Jakub Onderka]
- [feed] Optimise saving freetext feeds with a lot of attributes. [Jakub
  Onderka]
- [gitmodules] Using https instead of ssh to avoid permission denied
  error. [chrisr3d]
- [opendata export] No longer using the returnFormat field as the
  dataset resource format. [chrisr3d]

  - The resource format can be defined with a
    'format' field within the resource field in the
    setup filter
- [attributes:edit] Do not required the distribution anymore. [mokaddem]
- [attributes:add] Do not required the distribution anymore. [mokaddem]
- [registration] log entry action shortened to not cause issues.
  [iglocska]
- Fixes STIX2 export bugs when trying to use TLP Tags other than
  TLP_WHITE, resolve attempted dual registration of custom STIX objects.
  [Tom King]
- [JS] left off admin enforced check for the role permission. [iglocska]

  - to allow auth to be unchecked for site admins
- [object restsearch] fixed, no more trailing commas. [iglocska]
- [registration] acceptRegistration now accepts non User wrapped input.
  [iglocska]
- [users] accepting registration requests can throw a badly mapped
  exception. [iglocska]

  - changed to 400
- [object restsearch] fixed. [iglocska]

  Endless loop fixed
- [ACL] added objects/restSearch. [iglocska]
- [UI] Always use UUID with capital letter. [Jakub Onderka]
- [registrations] multi-delete fixed. [iglocska]
- [API] metadata filter description changed. [iglocska]
- [github] Release type no needed :) [Jakub Onderka]
- [json converter] fixed an issue if an expected key was not found.
  [iglocska]

  - was only accessible due to another bug, but it's more graceful either way
- [export] JSON export used the wrong handler for /objects/restSearch.
  [iglocska]
- [stix export] Bump minimum CybOX version to 2.1.0.21. [Richard van den
  Berg]
- [stix2 export] Fixed stix2 imports. [chrisr3d]

  - All the required features are imported and we no
    longer import them with *
- [installer] Embarassing typo no1, 7.3!=7.4. [Steve Clement]

Other
~~~~~
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Raphaël Vinot]
- Merge branch 'pr-5917' into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into pr-5917. [mokaddem]
- Merge branch 'pr-5902' into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into pr-5902. [mokaddem]
- Merge branch 'pr-5907' into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into pr-5907. [mokaddem]
- Merge branch 'pr-5911' into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into pr-5911. [mokaddem]
- Merge branch 'pr-5862' into 2.4. [mokaddem]
- Merge branch '2.4' into pr-5862. [mokaddem]
- Merge branch 'pr-5856' into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into pr-5856. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into pr-5856. [mokaddem]
- Clean up errors when trying to update warning lists. [Jason Kendall]
- Merge remote-tracking branch 'MISP/2.4' into 2.4. [Christophe
  Vandeplas]
- Merge pull request #5915 from SteveClement/guides. [Steve Clement]
- Merge pull request #5914 from SteveClement/guides. [Steve Clement]
- Merge pull request #5913 from SteveClement/guides. [Steve Clement]
- Merge branch 'guides' of github.com:SteveClement/MISP into guides.
  [Steve Clement]
- Merge remote-tracking branch 'upstream/2.4' into guides. [Steve
  Clement]
- Merge pull request #5912 from SteveClement/guides. [Steve Clement]
- Merge pull request #5891 from MISP/opendata. [Christian Studer]

  Opendata export via restSearch
- Merge branch '2.4' of https://github.com/MISP/MISP into opendata.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into opendata.
  [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge pull request #5876 from JakubOnderka/pubsub. [Andras Iklody]

  chg: [pubsub] Refactored PubSub tool
- Merge pull request #5863 from JakubOnderka/discussion-header. [Andras
  Iklody]

  new: [UI] Make clear that the textarea under event is discussion
- Merge pull request #5895 from JakubOnderka/patch-98. [Andras Iklody]

  chg: [feed] Use https when fetching DGAs feed
- Merge pull request #5897 from
  JakubOnderka/fixed_event_freetext_feed_speedup. [Andras Iklody]

  chg: [feed] Modify value when checking if value exists in current event
- Merge pull request #5904 from stricaud/2.4. [Andras Iklody]

  Few improvements to misp-config
- Few improvements: put the help print in a function. Make sure all the
  things we update are commented and do not push commented
  configuration. [Sebastien Tricaud]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5903 from JakubOnderka/correlation-speedup.
  [Andras Iklody]

  Correlation speedup
- Merge pull request #5889 from JakubOnderka/attribute_correlation.
  [Andras Iklody]

  IPv6 CIDR correlations
- Merge pull request #5870 from SteveClement/guides. [Steve Clement]
- Merge pull request #5892 from
  JakubOnderka/fixed_event_freetext_feed_speedup. [Andras Iklody]

  Fixed event freetext feed speedup
- Merge branch '2.4' of https://github.com/MISP/MISP into opendata.
  [chrisr3d]
- Merge pull request #5882 from JakubOnderka/build-fix. [Alexandre
  Dulaunoy]

  Build fix
- Merge branch '2.4' of https://github.com/MISP/MISP into opendata.
  [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Raphaël Vinot]
- Add: [opendata export] Support of the deleting abilities. [chrisr3d]

  - Deleting a dataset or its resource(s) is now
    available from the restSearch side as it already
    is with the python script
- Merge branch '2.4' of github.com:MISP/MISP into opendata. [chrisr3d]
- Merge pull request #5871 from tomking2/bug/stix2_bugs. [Christian
  Studer]

  fix: Fixes STIX2 export bugs when trying to use TLP Tags other than T…
- Add: [restSearch] OpenData export module. [chrisr3d]
- Add: [restSearch] Added opendata to the valid formats. [chrisr3d]
- Add: [opendata] Submoduling misp-opendata. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5861 from JakubOnderka/capital-uuid. [Alexandre
  Dulaunoy]

  fix: [UI] Always use UUID with capital letters
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5866 from JakubOnderka/patch-97. [Steve Clement]

  fix: [github] Release type no needed :)
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5859 from stricaud/mispconfig. [Steve Clement]

  Adding misp-config, a Perl tool to configure MISP.
- Adding misp-config, the Perl tool which configures MISP. It dumps the
  actual configuration to a prefixed tree, which defaults to
  /etc/misp/misp.conf.d/ and it sets all the configuration options
  existing from those files. [Sebastien Tricaud]
- Merge pull request #5853 from Applenice/2.4. [Steve Clement]

  chg: [i18n] Updated: zh-s
- Merge pull request #5858 from stricaud/debian. [Steve Clement]

  Adding the apache modules enablement in preinst
- Adding the apache modules enablement in preinst. [Sebastien Tricaud]
- Merge pull request #5857 from RichieB2B/ncsc-nl/cybox-version.
  [Christian Studer]

  fix: [stix export] Bump minimum CybOX version to 2.1.0.21
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge pull request #5850 from stricaud/debian_2_4_125. [Andras Iklody]

  Updates on debian package for 2.4.125
- Merge branch '2.4' into debian_2_4_125. [stricaud]
- Merge pull request #5846 from SteveClement/guides. [Steve Clement]

  chg: [doc] Make misp-modules work again
- Some changes which improve how Mysql user can be accessed by default,
  remove the enablement of apache modules in postinst (moved them to
  preinst). [Sebastien Tricaud]
- Added new version bump in changelog. [Sebastien Tricaud]
- Adding installation of cakeresque config. [Sebastien Tricaud]
- Adding the preinst where required apache modules are enabled.
  [Sebastien Tricaud]
- If the submodules have not been initialized and updated, the debian
  package will build. However the installation will not be a success.
  [Sebastien Tricaud]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5843 from SteveClement/tools. [Steve Clement]

  fix: [installer] Embarassing typo no1, 7.3!=7.4
- Merge remote-tracking branch 'upstream/2.4' into tools. [Steve
  Clement]


v2.4.125 (2020-04-30)
---------------------

New
~~~
- [feed] Support for compressed feeds. [Jakub Onderka]
- Implementation of email-based OTP. [Golbark]
- [security] added policy for github. [iglocska]
- [doc] Initial copy for Ubuntu 20.04. [Steve Clement]
- [installer] updated template to prepare grounds for 20.04 (php7.4)
  [Steve Clement]
- [misp-wipe] Add option to enable notice and warninglists. [Richard van
  den Berg]
- [internal] cache the sharing group access lookups. [iglocska]

  - should reduce the number of queries drastically for events heavy on object/attribute level sharing groups
- [privacy] filter added for the authkeys in the admin section to make
  giving trainings easier. [iglocska]
- [feeds] index refactor and new features. [iglocska]

  - added the ability to select an orgc ID for CSV/freetext feeds
    - all events created from this feed will carry the selected orgc_id

  - Refactored the index fully
    - using the factories
    - better warnings against the dangerous new feed each pull setting
    - event index search added
    - several settings cleaned up / made more clear

  - auto reload of default feed configuration disabled, fixes #2542, fixes #5789
    - added a button / endpoint to handle that instead to allow for the deleted default feeds to stay deleted
- [IndexTable] improvements all around. [iglocska]

  - several new field types added (target event, caching)
  - several updated with new features and functionalities
  - tied into the new data path collector among other changes
- [UI Helper] DataPathCollector helper added. [iglocska]

  - helps the index factory fields retrieve data from the currently processed object based on a set of paths
- [tool] MISP to Slack messaging using ZMQ. [Christophe Vandeplas]
- [tool] MISP to Slack messaging using ZMQ. [Christophe Vandeplas]
- [database] New MySQL data source added for debugging. [iglocska]

  - MySQLObserver datasource added - prepends all queries with the requested controller/action and user ID for better debugging
- [dashboard] COVID active cases backported from widget collections.
  [iglocska]
- [community] added the COVID-19 MISP community to the list. [iglocska]
- [communities] self-registration links now exposed in the communities
  index. [iglocska]
- [registration] fall back to the e-mail domain if no org info is
  provided. [iglocska]

  - also, make the org info optional
- [inbox] stub controller. [iglocska]
- [inbox] system added. [iglocska]

  - user self-registration is the first use-case
  - if the feature is enabled, users can unauthenticated send a registration request to MISP
    - request includes information on desired org and some privileges (sync / org admin / publisher)
  - requests land in the inbox, admins can inspect the registration requests
    - they can accept/discard them individually or en masse
    - users will be notified of their credentials automatically
    - quick user creation if the user asks for an org that doesn't exist yet

Changes
~~~~~~~
- [VERSION] bump. [iglocska]
- [pymisp] bump. [iglocska]
- [new] Added QEMU support. [Steve Clement]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [installer] Version bump. [Steve Clement]
- [db_schema] bumped. [iglocska]
- [installer] Update installer to latest. [Steve Clement]
- [installer] Initial 20.04 support. [Steve Clement]
- [otp] monor changes. [iglocska]

  - i18n
  - function naming convention
- [internal] Cache result of AppController::_isRest method. [Jakub
  Onderka]
- [advanced extraction] is now the default. [iglocska]
- [small changes] improve double loading of models. [iglocska]

  - some minor changes to improve performance slightly
  - some i18n additions (weren't present before the PR either)
- [Log:beforeSave] Fallback to `SYSTEM` Org if field empty. [mokaddem]
- [internal] Removed unused function. [Jakub Onderka]

  This function has typo in name `beforeValid*e*te`, so its never called. And because everything works, I think it is safe to remove it.
- [internal] Speed up of loading event page. [Jakub Onderka]
- [events:view] Support of `extended` for posted data. [mokaddem]
- [installer] Updated installer to latest version. [Steve Clement]
- [doc] Small CLI hint. [Steve Clement]
- [doc] Minor updates. [Steve Clement]
- [PyMISP] Bump. [Raphaël Vinot]
- [doc] Added preliminary 20.04 files. [Steve Clement]
- [decaying:restSearch] Always includes computed base_score in the
  response. [mokaddem]
- [i18n] More fr-updates. [Steve Clement]
- [i18n] Updated: de, dk, fr, it, jp, no, ru, zh-s. [Steve Clement]
- [i18n] Full jpn translation as of 2 months ago. [Steve Clement]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [users:registrations] Catch if no org_id was provided. [mokaddem]
- [internal] Log also previous exception. [Jakub Onderka]
- [UI] Disable Advanced extraction button if it is not installed. [Jakub
  Onderka]
- [internal] Refactored AttributesController:add_attachment. [Jakub
  Onderka]
- [internal] Refactoring malware handling. [Jakub Onderka]
- [sharingGroup:capture] Prevent capture of SG in some specific cases -
  Need more testing. [mokaddem]

  Should fix #5784
- [event:timeline] Prevent item selection while in the sighting context.
  [mokaddem]
- [event:timeline] Added Sightings visualisation. [mokaddem]
- [user:registration] Added audit log. [mokaddem]
- [user:acceptRegistration] Added fail message. [mokaddem]
- [user:acceptRegistration] Default to instance's default role if
  role_id not passed. [mokaddem]
- [user:regitration] Accept/Discard registration accept UUID as
  parameter. [mokaddem]
- Bumped db_schema.json. [mokaddem]
- [ACL] updated. [iglocska]
- [ACL] added the feed data reload. [iglocska]
- [misp-objects] bump. [iglocska]
- [objects] bump. [iglocska]
- [stix2] Bumped latest STIX2 python library version. [chrisr3d]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [widgets:multiline] Allow to ctrl+click on labels to hide the others.
  [mokaddem]
- [logs:search] Added support of JSON return format. [mokaddem]
- [event:restSearch] Added `includeEventCorrelations` parameter.
  [mokaddem]
- [taxonomies] updated. [iglocska]
- [events:exports] Migrated majority of export type to use restSearch.
  [mokaddem]
- [index field] org field updated to allow for org information not local
  to the current instance (no ID set) [iglocska]
- [registrations] show the time of request's creations. [iglocska]
- [db_schema] Bumped schema. [mokaddem]
- [registration:index] Added titles to buttons. [mokaddem]
- [warninglists] bump. [iglocska]
- [cakephp] version bump to get TLS 1.3 support, fixes #5764. [iglocska]

  - #yolo
- [taxonomies] revert. [Alexandre Dulaunoy]
- [taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [widgets:trendingTags] Added threshold parameter to let user decide
  the # to show. [mokaddem]
- [dashboard] Added COVID widgets to the default installation from
  widget-collections. [iglocska]

  - should be interesting enough for all at this point. We might remove it again once COVID-19 is finally gone from our lives
- [stix2 libray] Bumped latest python library version. [chrisr3d]
- [stix2 export] Setting datetime fields. [chrisr3d]

  - Instead of letting the created and modified
    fields set by default, we set them with the
    timestamp value (or date in case of an event)
  - The first_seen & last_seen values (or equivalent
    like valid_from, valid_until, depending on the
    STIX object type) are set to the first_seen /
    last_seen if possible, otherwise timestamp
- [warninglists] bump. [iglocska]
- [cleanup] removed bad idea that got barfed into the codebase.
  [iglocska]
- [syslog] added title of log entry. [iglocska]
- [warninglists] updated. [iglocska]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- [server:dbSchemaDiagnostic] Support of display width and updated
  `db_schema.json` [mokaddem]
- [settings] disabling background jobs now counts as a misconfiguration.
  [iglocska]
- [publish alert] linebreak issue fixed, added notification about why
  the user receives the e-mail. [iglocska]

Fix
~~~
- [internal] Just site admin can force when saving freetext. [Jakub
  Onderka]
- [installer] Bug where the wrong php deps would get installed. [Steve
  Clement]
- [installer] Fix a bug where the installer fails if apt update has
  never been run. [Steve Clement]
- [user settings] corrected field name. [iglocska]
- [internal] Edge case where due to an old invalid update script an
  instance could end up with the wrong key in user settings. [iglocska]

  - this should resolve the issue for affected users
  - no change for everyone else
- [otp] pre-auth action list only expanded if otp is enabled. [iglocska]
- [otp] enabling it requires e-mailing to be enabled. [iglocska]
- [ACL] a private function was missing the __ causing the ACL checker to
  return it as an unmapped accessible function. [iglocska]
- [internal] syslog shouldn't end with new line. [Jakub Onderka]

  Because then two lines are logged
- [internal] Remove unused code. [Jakub Onderka]
- Remove unused variable. [Jakub Onderka]
- [event] fixes missing correlations with combined types (#5832)
  [Christophe Vandeplas]

  * fix: [event] fixes missing correlations with combined types

  also some other missing variable bug
- [internal] Deleting multiple Redis keys. [Jakub Onderka]
- [UI] Proper object table header when includeRelatedTags. [Jakub
  Onderka]
- [doc] MISP expects lief 0.10.1. [Steve Clement]
- [cake] more new defaults as per
  https://github.com/MISP/MISP/issues/5803. [Steve Clement]
- [templates:add] Adding tag do not submit the form anymore. Fix #5826.
  [mokaddem]
- [Console:Server] Added `configLoad` task. Fix #5793. [mokaddem]
- [galaxyCluster:index] Restored search functionality. [mokaddem]
- [feed:add] Do not override `new_event_at_each_pull` value. Fix #5815.
  [mokaddem]
- [attribute:restSearch] Make sure to always pass all tags to Decaying's
  computation function. [mokaddem]
- [internal] HTML code in view_event_distribution_graph. [Jakub Onderka]
- Correct flash message when sending e-mail. [Jakub Onderka]
- [misp-wipe] bring wiping up to date with MYSQL.sql. [Richard van den
  Berg]
- [pagination] Fixed bottom pagination links on the bottom. [iglocska]
- [registrations] Users can now register using the API without a valid
  key, affects #5783. [iglocska]
- [attribute:edit] Prevent save for invalid sharing_groups ids.
  [mokaddem]
- [attribute:add] Prevent save for invalid sharing_groups ids.
  [mokaddem]
- [event:view] Restored disabled_correlation toggle. [mokaddem]
- [correlations] Update correlations on Attribute or Event
  `distribution` change. [mokaddem]
- [event:fetchEvent] Block viewing Objects/Attributes if the user does
  not belong to the sharing_group. [mokaddem]

  Even if these elements belong to the user. Similar explanation than for 7cd2175
- [event:fetchEvent] Block viewing the event if user does not belong to
  the sharing_group. [mokaddem]

  Even if the event belongs to the user. This scenario can happen if a
  remote sync is badly configured where the remote sync user have
  site_admin right, thus allowing the user to see the event even though
  he is not part of the SG
- [user:registration] Default undefined message to empty string.
  [mokaddem]
- [internal] Remove already removed git modules. [Jakub Onderka]
- [stix2 export] Fixed STIX JSON Encoder import. [chrisr3d]

  - With the latest update it is no longer part of
    stix2.base but stix2.v20.base by default, so we
    need to import it from stix2.base manually
- [feed index] Converted to static tags to skip erroneous add tag
  buttons. [iglocska]
- [ajaxTags] resolved not set searchURL string. [iglocska]
- [observer datasource] fixed for the QueryTool. [iglocska]
- [internal] Added a setting to skip positive attribute level filters on
  the event scope. [iglocska]

  - when running a large MISP community, it is bound to happen that your instance will be used as the back-end for internal tooling
  - often these tools are configured to fetch aggressively, often with heavy consequences on the server load
  - some filter that serves mostly edge-case lookups can mistakenly lead to heavy server load for no good reason

  We have identified attribute level positive filters on the event scope to be such a filter and made them optionally toggle-able
  via the MISP.attribute_fitlers_block_only flag. Turning the setting on will remove all event level filters such as "type" from
  being viable filter candidates unless used to block the inclusion of attribute types. Some examples:

  "type": {"OR": ["ip-dst", "ip-src", "hostname", "domain"]} would normally return ANY event that has at least one of the listed
  attribute types. This is the behaviour that can now be disabled.

  "type": {"NOT": ["iban", "cc-number"]} would normally remove any attributes with the given types from the list of returned
  events. This functionality is NOT affected by the toggle.
- [stix1 import] Fixed object name handling causing errors in some
  cases. [chrisr3d]

  - With a wrong object name, the correct function
    was not reached, reaching some unexpected errors
- [API] event index queries refactored. [iglocska]

  - fixed ID lookups to be more graceful (IN() instead of OR-d statements)
  - removed default sorting which is the default anyway but introduces a massive overhead
- [database] made MySQLObserver php < 7.2 compliant. [iglocska]
- [database] bruteforce check relaxed for datasource. [iglocska]
- [database] added missing file. [iglocska]
- [restresponse] invalid keyword for controllers blocked SQL data to be
  appended on demand. [iglocska]
- [tool] slackbot cosmetic change. [Christophe Vandeplas]
- [genericTable:rowDblclick] Made row selector more lax. [mokaddem]
- [decaying:base] MAke sure to return a tag event if it's not part of a
  taxonomy. [mokaddem]
- [stix1 export] Exporting all tags as Marking. [chrisr3d]

  - Not only for TLP tags
  - Not TLP tags are SimpleMarking and no longer
    journal entry as they were before
- [server:DBSchemaDiagnostic] Quote index column's name and added
  missing keyword. [mokaddem]
- [events:export-csv] Default to_ids to be 1. [mokaddem]
- [stix1 import] Avoiding Php notice because of the end function.
  [chrisr3d]

  - Same as 8f90f79
- [stix1 import] Updated the email message mapping to support the
  message-id attribute import. [chrisr3d]
- [UI] Added missing delete button for organisations, fixes #5773.
  [iglocska]
- [self-registration] added missing field. [iglocska]
- [user:email] Replaced query parameters by cake's named parameters.
  Hopefully fix #5745. [mokaddem]
- [user registration] reverted bug introduced in previous commit
  restricting the org choice to the suggested org if there was a match.
  [iglocska]
- [console:admin] getSetting can be used to retrieve all settings.
  [mokaddem]
- [user registration] minor bug fixes. [iglocska]
- [user registration] automatically convert selected orgs to local as
  described in the tool. [iglocska]
- [trialing commas] removed. [iglocska]
- [stix2 export] Avoiding the "end" function to return a notice.
  [chrisr3d]

  - It looks like depending on the Php version, the
    end function does not like to have the reference
    of an array. By delaying its call, we pass the
    actual array and the notice no longer appears
- [stix2 export] Fixed datetime fields format in custom objects.
  [chrisr3d]
- [widgets:trendingTags] Removes unused vars. fix #5761. [mokaddem]
- [API] fixes to set_filter_uuid. [iglocska]
- [search] Fixed the UUID / ID searches on the attribute scope, fixes
  #5636. [iglocska]
- [UI] API reset link fixed on the automation page, fixes #5749.
  [iglocska]

Other
~~~~~
- Merge pull request #5207 from JakubOnderka/patch-33. [Steve Clement]

  fix: [internal] Just site admin can force when saving freetext
- Merge pull request #5842 from SteveClement/tools. [Steve Clement]

  chg: [new] Added QEMU support
- Merge branch 'eventTimeline-sightings' into 2.4. [mokaddem]
- Merge remote-tracking branch 'origin/2.4' into eventTimeline-
  sightings. [mokaddem]
- Merge branch '5802' into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 5802. [iglocska]
- Merge pull request #5841 from SteveClement/guides. [Steve Clement]

  fix: [installer] Bug where the wrong php deps would get installed
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Revert "Merge branch '5835' into 2.4" [iglocska]

  This reverts commit 48132af1796b13e888ecdc77fa0e25787d517242, reversing
  changes made to 9a22aa1f3c1295ab4715e7043e09fa3797b592cb.
- Merge branch '5834' into 2.4. [iglocska]
- Merge branch '5835' into 2.4. [iglocska]
- Merge branch 'stix2-info-patch' of https://github.com/pan-unit42/MISP
  into stix2-info-patch. [kscheetz]
- Merge branch '2.4' into stix2-info-patch. [kscheetz]
- Fixes missing self argument bug. [kscheetz]
- Moved info assignment to method. [kscheetz]
- Simplification for code complexity reqs. [kscheetz]
- Merge branch '2.4' into stix2-info-patch. [kscheetz]
- Preserve report order. [kscheetz]
- Stix2 importer naming change. [kscheetz]
- Fixes missing self argument bug. [kscheetz]
- Moved info assignment to method. [kscheetz]
- Simplification for code complexity reqs. [kscheetz]
- Preserve report order. [kscheetz]
- Stix2 importer naming change. [kscheetz]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5840 from SteveClement/tools. [Steve Clement]

  chg: [installer] Initial 20.04 support
- Merge branch '5726' into 2.4. [iglocska]
- Hook into native authentication flow instead of beforefilter which
  prevents any after-auth bypass and rely on framework session
  management. [Golbark]
- Merge branch '2.4' into email-otp-implementation. [Golbark]

  Conflicts:
  	app/Model/Server.php
- Add consistent i18n support for all strings. [Golbark]
- Rely on session_id instead of user_id and address minor comments.
  [Golbark]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5561 from JakubOnderka/is_rest_cache. [Andras
  Iklody]

  chg: [internal] Cache result of AppController::_isRest method
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5816 from Applenice/2.4. [Andras Iklody]

  Modify the default parsing settings of Phishtank feed
- Modify the default parsing settings of Phishtank feed. [Applenice]
- Merge branch '5272' into 2.4. [iglocska]
- Merge branch '2.4' into 5272. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch 'pr-5827' into 2.4. [mokaddem]
- Merge remote-tracking branch 'origin/2.4' into pr-5827. [mokaddem]
- Merge branch 'pr5709' into 2.4. [mokaddem]
- Merge remote-tracking branch 'origin/2.4' into pr5709. [mokaddem]
- Merge branch 'JakubOnderka-event_loading_speedup' into 2.4. [mokaddem]
- Merge remote-tracking branch 'origin/2.4' into JakubOnderka-
  event_loading_speedup. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Update SECURITY.md. [Andras Iklody]
- Merge pull request #5833 from MISP/Rafiot-patch-5. [Andras Iklody]

  Update SECURITY.md
- Update SECURITY.md. [Raphaël Vinot]
- Merge branch 'JakubOnderka-patch-96' into 2.4. [mokaddem]
- Merge branch '2.4' into JakubOnderka-patch-96. [mokaddem]
- Fixes failed insert on existing records. [kscheetz]
- Fixes missing MySQL ignore table statements. [kscheetz]
- Merge branch '5819' into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch 'JakubOnderka-redis-delete-multiple' into 2.4. [mokaddem]
- Merge branch '2.4' into JakubOnderka-redis-delete-multiple. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5606 from JakubOnderka/patch-82. [Sami Mokaddem]

  fix: [UI] Proper object table header when includeRelatedTags
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge pull request #5824 from SteveClement/guides. [Steve Clement]

  fix: [py] Updated lief to a recent known working version
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge pull request #5821 from Cooper-Dale/patch-1. [Andras Iklody]

  bugfix in Suricata export template
- Bugfix in Suricata export template. [Cooper Dale]

  PR for reported bug https://github.com/MISP/MISP/issues/5766 based on suggestion @stacsirt, tested on my instance and it is working great
- Merge pull request #5823 from SteveClement/guides. [Steve Clement]

  chg: [doc] Added preliminary 20.04 files
- Merge pull request #5822 from SteveClement/tools. [Steve Clement]

  new: [installer] updated template to prepare grounds for 20.04 (php7.4)
- Merge pull request #5574 from JakubOnderka/patch-80. [Andras Iklody]

  fix: [internal] HTML code in view_event_distribution_graph
- Merge pull request #5818 from JakubOnderka/patch-93. [Andras Iklody]

  fix: Correct flash message when sending e-mail
- Merge pull request #5158 from Kortho/patch-1. [Steve Clement]

  added libcxx-devel to yum install list
- Added libcxx-devel to yum install list. [Kortho]

  Needed to compile LIEF
- Merge pull request #5811 from RichieB2B/ncsc-nl/fillwipe. [Steve
  Clement]

  Enable notice- and warninglists after misp-wipe
- Update misp-wipe.conf.sample. [Steve Clement]

  prefer false atm
- Merge pull request #5776 from srikwit/patch-1. [Steve Clement]

  Removing mentioned stable support for Debian 9
- Removing mentioned stable support for Debian 9. [srikwit]

  As there is no file `INSTALL.debian9.txt` and we only have a file with the name `xINSTALL.debian9.txt`. The Debian 9 support seems to be experimental.
- Merge pull request #5763 from RichieB2B/ncsc-nl/fix-gpg. [Steve
  Clement]

  Set SELinux context for crypt-gpg-pinentry
- Set SELinux contect for crypt-gpg-pinentry, fixes #4796. [Richard van
  den Berg]
- Merge pull request #5651 from Kortho/patch-5. [Steve Clement]

  username for service set from environment variable
- Username for service set from environment variable. [Kortho]

  Username is now fetched from environment variable instead of being hard coded
- Merge pull request #5644 from Kortho/patch-4. [Steve Clement]

  moved and added install to python-cybox
- Moved and added install to python-cybox. [Kortho]

  python-cybox missed the installation, moved the cd, and added the install
- Merge pull request #5812 from SteveClement/i18n. [Steve Clement]

  chg: [i18n] Updated: de, dk, fr, it, jp, no, ru, zh-s
- Merge branch 'i18n' of github.com:MISP/MISP into i18n. [Steve Clement]
- Merge branch '2.4' into i18n. [Steve Clement]
- Merge branch '2.4' into i18n. [Steve Clement]
- Merge branch '2.4' into i18n. [Steve Clement]
- Merge branch '2.4' into i18n. [Steve Clement]
- Merge branch '2.4' into i18n. [Steve Clement]
- Merge remote-tracking branch 'origin/2.4' into i18n. [Steve Clement]
- Merge branch '2.4' into i18n. [Steve Clement]
- Merge branch '2.4' into i18n. [Steve Clement]
- Merge remote-tracking branch 'upstream/2.4' into i18n. [Steve Clement]
- Merge branch '2.4' into i18n. [Steve Clement]
- Merge branch '2.4' into i18n. [Steve Clement]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge pull request #5255 from JakubOnderka/patch-46. [Andras Iklody]

  fix: [internal] Remove already removed git modules
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch 'feed_index' into 2.4. [iglocska]
- Add: [stixtest] Scripts to get a visual evaluation of the STIX2 export
  & import. [chrisr3d]

  - We get the initial MISP event, we export it in
    STIX2 format, and use the import script on this
    file to compare the initial MISP event with the
    one created with the STIX2 import
  - Since the export to STIX2 and import from STIX2
    are lossy, we do not expect the results to be
    perfect, but the enumeration of the differences
    confirm what we already know as lost in the
    full process, so we can see what is not going as
    expected
  - The API key could be gathered from MISP, but
    these small testing scripts were first intended
    to be standalone, and are only for testing
    purposes
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge remote-tracking branch 'MISP/2.4' into 2.4. [Christophe
  Vandeplas]
- Add: [stix1 framing] Added the Simple marking in the STIX namespaces.
  [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge pull request #5767 from MISP/fix-csv-toids. [Andras Iklody]

  fix: [events:export-csv] Default to_ids to be 1
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge pull request #5672 from patriziotufarolo/2.4. [Andras Iklody]

  Fixes STIX2 export failing with "ANTLR runtime and generated code versions disagree: 4.8!=4.7.1"
- Ensure we only have the last line from the shell command when
  exporting STIX2. [Patrizio Tufarolo]

  Same as  e3b1e8c74a0b40cdb54be938bcea4d9b28a7f0b9 but for exporting STIX2
- Merge pull request #1 from MISP/2.4. [Patrizio Tufarolo]

  Align fork
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5727 from stricaud/debian. [Alexandre Dulaunoy]
- Various improvements: * Do not push a string for VERSION.json but use
  the file in the repository * If database already exist, move on.
  [Sebastien Tricaud]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5746 from 4ekin/pg_branch. [Andras Iklody]

  Fixed bugs with PostgreSQL in bruteforce and feed models
- Fixed bugs with PostgreSQL in bruteforce and feed models. [Bechkalo
  Evgeny]


v2.4.124 (2020-03-30)
---------------------

New
~~~
- [attributes:massEdit] Possibility to create proposals instead of edit.
  [mokaddem]
- Add support for RHEL in the install script. [Golbark]
- [audit] Added user monitoring. [iglocska]

  - site admins can set the monitoring flag on a user if the feature is enabled on the instance
  - monitored users will have all requests logged along with POST bodies

  - keep in mind this functionality is quite heavy and intrusive - so use it with care. The idea is that this allows us to track potentially malicious users during an investigation
- [UI] indexTable new fields / some refactoring. [iglocska]
- [helper:scopedCSS] Moved implementation in a helper. [mokaddem]
- Country galaxy generator. [iglocska]
- [dashboard] multi line chart UI added. [iglocska]

Changes
~~~~~~~
- [server:dbSchemaDiagnostic] UI Improvement to hide tables containing
  only non-critical entries. [mokaddem]
- [security] Added setting to restrict the encoding of local feeds.
  [iglocska]

  - By adding local feeds, a malicious administrator could point MISP to ingest configuration files that the apache user has access to
  - This includes some more sensitive files (database.php / config.php / .gnupg data)
  - Whilst this is currently not leading to an exploitable vulnerability as the current implementation wouldn't trigger on the values,
    having a setting to disable this will become much more interesting once we have a system in place for custom feed parsers
  - The setting can only be enabled/disabled via the CLI

  - As reported by Matthias Weckbecker
- Bump PyMISP. [Raphaël Vinot]
- [version] bump. [iglocska]
- [publish alert] default added to user creation via the API. [iglocska]
- Bumped queryversion. [mokaddem]
- [attribute:edit] Added support of chosen - fix #5736. [mokaddem]
- [widgets:mutliline] Usage of bootstrap's tooltip and fixed another
  loading race-condition. [mokaddem]
- [alert] emails now have instructions on how to disable them.
  [iglocska]
- [widgets:multiline] Added possibility to pick datapoint and see the
  deltas. [mokaddem]
- [warninglist] bump. [iglocska]
- [warninglist] bump. [iglocska]
- [genericElement:indexTable-links] Allow to craft an URL with custom
  data_path. [mokaddem]
- [genericElement:IndexTable] Allow to pass pagination options to
  paginator element. [mokaddem]
- [widgets:multilines] Improved tooltip placement strategy. [mokaddem]
- [taxonomies] bumped. [iglocska]
- [widgets:multiline] Improved label wrapping. [mokaddem]
- [widgets:multiline] Integrated CSS and new config `hideAxis`
  [mokaddem]
- [widgets:worlmap] Resize map on widget container resize. [mokaddem]
- [widgets:ui] Added possibility to listen to widget-resize events.
  [mokaddem]
- [widgets:multiline] Support of linear x-axis. [mokaddem]
- [widgets:multiline] Pass widget_config to the view. [mokaddem]
- [widgets:multiline] Flip tooltip position if necessary. [mokaddem]
- [widgets:multiline] Adapt left margin for big numbers. [mokaddem]
- [widgets:multiline] Added more Options, datapoints and total serie.
  [mokaddem]
- [widgets:multiline] Layout, UI and interactivity improvements - WiP.
  [mokaddem]
- [galaxy:view] Commented `altered galaxy` for now. [mokaddem]
- [galaxyCluster:index] Migrated to use the genericElement factory +
  added sparkline and icon genericIndex fields. [mokaddem]
- [galaxyCluster:view] Migrated to use the genericElement factory.
  [mokaddem]
- [galaxy:index] Cleaned up artifacts from galaxy2.0. [mokaddem]
- [galaxy:view] Migrated to use the genericElement factory. [mokaddem]
- [galaxy:index] Migrated to use the genericElement factory. [mokaddem]
- [views:genericElements] Multiple addition and improvements for generic
  IndexTable, TopBar and Form. [mokaddem]
- [feeds metadata] fix incorrect timestamp field. [Alexandre Dulaunoy]
- [style] Added spaces in JSON used for the automation examples.
  [iglocska]
- [community] CogSec Collab disinformation sharing community :D. [VVX7]
- [taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [galaxy] bump. [iglocska]
- [helper:ScopedCSS] Usage of PHP_EOL. [mokaddem]
- [scopedCSS] Added more doc and allow having scoped and not scoped mix.
  [mokaddem]
- [scopedCSS] Simplified usage and added documentation. [mokaddem]
- [widgets:multiline] Switched to scoped css usage. [mokaddem]
- [widgets] Added support of scoped CSS. [mokaddem]
- [travis] cat exec errors file. [Raphaël Vinot]

Fix
~~~
- [sync] Added function to handle older MISP instances despite the new
  way of passing org filter options. [iglocska]
- [event:view] Show correct number of related events to be shown - Fix
  #5732. [mokaddem]
- [objecs:reviseObject] Pass forgotten template data - Fix #5733.
  [mokaddem]
- [event index] org filter correctly accepts array in addition to pipe
  delimited values. [iglocska]

  - fixes pull org filters
- [emailing] Added setting for default publish alert behaviour when
  creating new users. [iglocska]
- [installer] Updated installer checksums. [Steve Clement]
- [attribute:edit] Create chosen picker when modal is shown. [mokaddem]
- [eventGraph:picture] Take correct Attribute picture's name. [mokaddem]
- [widget:mutlieline] Take into account scrollY position. [mokaddem]
- [widgets:multiline] Racecondition executing `init` and fetching d3.js
  twice. [mokaddem]
- [pull] pull filters fixed. [iglocska]
- [widgets:multiline] Ensure that d3.js is loaded only once. [mokaddem]
- [widgets:SimpleList] Fit minimum vertical space. [mokaddem]
- [widgets:multiline] Correctly parse boolean text for `showAxis`
  [mokaddem]
- [galaxy:view] View altered galaxies/clusters buttton correctly
  redirect. [mokaddem]
- [php] compatibility with older versions. [iglocska]
- [servers:pull_rules] Allows sync parameter rules to be above 40 chars.
  [Sami Mokaddem]
- [message] user creation shouldn't include the "User notified of new
  credentials" part of the notification mesage if emailing is disabled.
  [iglocska]
- [install] Updated installer and checksums. [Steve Clement]
- [INSTALL] Properly run tests. [Raphaël Vinot]
- [suricata] fixed an invalid validation of https hostnames that blocked
  the attributes from being included in the exports. [iglocska]
- [dashboard] css conflict resolved. [iglocska]

  - in a really hacky way for now
- [side menu] Fixed Dashboard link from the side menu in the statistic
  view. [chrisr3d]
- [thread:view] Threads are no longer rendered for not related Event on
  rare occasion. [mokaddem]
- [user:login] Added support of `RFC822` for older PHP version.
  [mokaddem]
- [stix export] Fixed cybox object import. [chrisr3d]

Other
~~~~~
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge pull request #5643 from Kortho/patch-3. [Steve Clement]

  fixed python venv creation command
- Fixed python venv creation command. [Kortho]

  The command for creating virtual environment in RHEL was wrong, fixed it :)
- Merge pull request #5706 from RichieB2B/ncsc-nl/venv-ssdeep. [Steve
  Clement]

  Fix venv and ssdeep for RHEL 7
- Update INSTALL.rhel7.md. [Steve Clement]
- Install ssdeep PHP module on RHEL 7. [Richard van den Berg]
- Fix virtualenv creation on RHEL 7. [Richard van den Berg]
- Merge pull request #5705 from Golbark/redhat-install-script-support.
  [Steve Clement]

  new: usr: add support for RHEL in the install script
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge pull request #5721 from stricaud/debian2. [Andras Iklody]

  Debian improvements
- Add installation files: workers and VERSION.json. [Sebastien Tricaud]
- Adding missing packages. [Sebastien Tricaud]
- Adding compat file. [Sebastien Tricaud]
- Bump version in changelog. [Sebastien Tricaud]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch 'feature-widget-multipleline' into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into feature-widget-
  multipleline. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into view-migration-galaxy.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch 'GlennHD-2.4' into 2.4. [Alexandre Dulaunoy]
- Merge branch '2.4' of https://github.com/GlennHD/MISP into
  GlennHD-2.4. [Alexandre Dulaunoy]
- Fixed indentation of DigitalSide & Metasploit CVEs. [GlennHD]

  Fixed indentation of DigitalSide & Metasploit CVEs to align with others.
- Added Malware Bazaar. [GlennHD]

  Added abuse.ch Malware Bazaar
- Merge pull request #5717 from VVX7/2.4. [Andras Iklody]

  chg: [community] CogSec Collab disinformation sharing community :D
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5707 from MISP/feature-widgets-scoped-css. [Andras
  Iklody]

  Scoped css for widget
- Merge branch '2.4' of github.com:MISP/MISP into feature-widgets-
  scoped-css. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5697 from MISP/chrisr3d_patch. [Andras Iklody]

  Fix link to the dashboard from the statistics page
- Merge remote-tracking branch 'origin/2.4' into chrisr3d_patch.
  [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]


v2.4.123 (2020-03-10)
---------------------

New
~~~
- [dashboard] added template delete functionality. [iglocska]
- [dashboard] persistence package. [iglocska]

  - export dashboard state
  - import dashboard state
  - save dashboard state
    - make it available to others on the instance on demand
    - admins can set a default password for users that don't have anything configured yet
    - load another template based on what the community has shared
  - added Whoami widget which was an outcome of the ESDC training
  - various improvements, new fields for genericElements, etc
- [workers] restart all dead workers. [iglocska]
- [widgets] Whoami widget added. [iglocska]
- [dashboard] various fixes / improvements. [iglocska]

  - simple list now accepts arrays for values
  - fixed margin issues
  - fixed empty sync test issues
- [dashboard] added a way to auto reload widgets. [iglocska]

  - has to be defined in the code of the widget
- [widget] World map widget added. [iglocska]
- [dashboard] Resource widget added. [iglocska]
- [favourite] glow orange when on the page that is already bookmarked.
  [iglocska]

  - thanks to @mokaddem (graphman) for the idea
- [dashboard] Added cachelifetimg setting as opposed to hard-coded
  value. [iglocska]
- [dashboard] Added server resource module and some fixes. [iglocska]
- [Dashboard] added hook to check for permissions on module load.
  [iglocska]

  - allows for modules to have role / host org restrictions
- [Dashboard] system. [iglocska]

  - Dashboard
    - modular similar to restSearch
    - build your own widgets
    - use a set of visualisation options (more coming!)
    - full access to internal functions for queries
    - auto discover core and 3rd party widgets
    - rearrange / configure widgets for each user individually
    - rearrange / resize widgets
    - settings can be configured by a site-admin on behalf of others
    - modules have a self-explain mode to guide users
    - caching mechanism for the modules / org

  - set homepage / user
  - various other fixes
- [API] object level restSearch added. [iglocska]

  still WiP

Changes
~~~~~~~
- [stix2] Bumped latest stix2 python library version. [chrisr3d]
- Bump PyMISP. [Raphaël Vinot]
- [version] bump. [iglocska]
- [cleanup] removed alert. [iglocska]
- [misp-warninglists] updated to the latest version. [Alexandre
  Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [misp-taxonimies] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [dashboard] world map scale parameterised. [iglocska]
- [widget:worldmap] Reusage of declated variable. [mokaddem]
- [widget:worldmap] Various JS and UI Improvements. [mokaddem]

  - Variables and function have their own scope, not overridin each other
  - Scale color ranges from blue to red
  - Tooltip picks the correct data instead of the latest declared one
  - PHP no longuer printed in JS, avoiding the need of `eval` command
  - Widget redraw itself after a page resize
- [login] Display last time the user logged in. [mokaddem]
- [response header] Added `X-XSS-Protection` header. [mokaddem]

  - As reported by an external pentest company on behalf of the Centre for Cyber security Belgium (CCB)
- [server:rest] Query builder gets loaded with body after the POST.
  [mokaddem]

  fix #5680
- Removed unwanted indentation. [mokaddem]
- [dashboard] show owner email of template to site owners and the owner
  themselves. [iglocska]
- [dashboard]  cleanup. [iglocska]

  prevent @mokaddem's and @rommelfs's eyes from bleeding
- [misp-object] updated to the latest version. [Alexandre Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [dashboard] Allow for the use of subdirectories in
  /app/Lib/Dashboard/Custom to be able to git clone repos. [iglocska]
- [querystring] bumped. [iglocska]
- [dashboard] views for widgets updated. [iglocska]
- [clenaup] removed old dashboard. [iglocska]
- [dashboard] Custom dir added. [iglocska]
- [wip] test. [iglocska]
- [misp-object] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- Make contact reporter gender neutral. [Raphaël Vinot]
- [i18n] Updated: Simplified Chinese, German, Italian, Spanish, Russian.
  [Steve Clement]
- [i18n] Updated pot files. [Steve Clement]

Fix
~~~
- [travis] ANTLR 4.8 works again. [Raphaël Vinot]
- [ACL] added deleteTemplate. [iglocska]
- [dashboards:edit] Prevent overriding the edited template with data
  stored in user-settings. [mokaddem]
- [dashboard:saveTemplate] Prevent array re-indexing causing issue with
  HTML select's option value. [mokaddem]
- [dashboard] grid scope fix. [iglocska]
- [sfv] Checksums wrong. [Steve Clement]
- [dashboard] several small fixes. [iglocska]

  - fixed issue of first few updates failing right after adding a self updating widget
  - don't try to reload a removed widget
  - fixed the internal random parametrised widget refresh to something more sane
- [user:resetAuthkey] Allows the function to be called. [mokaddem]
- [flashErrorMessage] Sanitized error message printed by session that
  should never contains user-made text. [mokaddem]

  - Better safe than sorry
- [user:edit] Prevent password change with the current password.
  [mokaddem]

  - As reported by an external pentest company on behalf of the Centre for Cyber security Belgium (CCB)
- [user:edit] Correctly re-insert form data wipping password
  information. [mokaddem]
- [security] Fixed presistent xss in the sighting popover tool.
  [mokaddem]

  - As reported by an external pentest company on behalf of the Centre for Cyber security Belgium (CCB)
- [user:resetauthkey] Method can only be accessed via POST request.
  [mokaddem]

  - As reported by an external pentest company on behalf of the Centre for Cyber security Belgium (CCB)
- [security] Fix reflected xss via unsanitized URL parameters.
  [mokaddem]

  - As reported by an external pentest company on behalf of the Centre for Cyber security Belgium (CCB)
- [settings] `require_password_confirmation` set to true by default.
  [mokaddem]
- [attribute:validation] Better validation of IPv6-[dst/src] and
  improved display. [mokaddem]

  fix #5682
- [logs] pagination settings are lost when flipping pages after a
  search. [iglocska]
- [widgets] worldmap fixed. [iglocska]
- [dashboards] fixed invalid recall of dashboard template. [iglocska]
- [ACL] added new function to ACL. [iglocska]
- [js] fixed invalid defaults passed from php. [iglocska]
- [cleanup] removed disabling the caching of dashboard widgets for debug
  purposes. [iglocska]
- [dashboard] Some widget visualisation fixes. [iglocska]
- [cleanup] [iglocska]
- [synctool] tests improved. [iglocska]
- [CLI] change authkey description fixed. [iglocska]
- [homepage] redirects fixed. [iglocska]
- [user settings] fixed unlocking of API routes. [iglocska]
- [dashboard] fixed an issue when adding a widget with an empty config.
  [iglocska]
- [API] Json converter fixed. [iglocska]
- [dashboard] fixed multiple adds failing. [iglocska]
- [dashboard] Fixed adding widgets losing their config settings.
  [iglocska]
- [dashboard] custom routing fixed. [iglocska]
- [i18n] Various edits and small __('') addeage. [Steve Clement]

Other
~~~~~
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Bumped db_version. [Sami Mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge pull request #5687 from MISP/feature-widget-improvement. [Andras
  Iklody]

  chg: [widget:worldmap] Various JS and UI Improvements
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch 'feature/dashboard' into 2.4. [iglocska]
- Merge branch '2.4' into feature/dashboard. [iglocska]
- Merge pull request #5670 from SteveClement/i18n. [Steve Clement]

  chg: [i18n] Updated: Simplified Chinese, German, Italian, Spanish, Russian
- Merge pull request #5669 from SteveClement/i18n. [Steve Clement]

  chg: [i18n] Updated pot files
- Merge branch '2.4' into i18n. [Steve Clement]
- Merge pull request #5668 from SteveClement/i18n. [Steve Clement]

  fix: [i18n] Various edits and small __('') addeage.


v2.4.122 (2020-02-26)
---------------------

New
~~~
- [logging] Log user IPs on login. [iglocska]

  - feature is optional and needs to be enabled in the server settings
  - on successful login logs the associated user ID for a given IP (30 day retention)
  - also logs the IP for the associated user ID (indefinite retention)
  - added two command line tools to query
    - Get IPs For User ID: MISP/app/Console/cake Admin UserIP [user_id]
    - Get User ID For User IP: MISP/app/Console/cake Admin IPUser [ip]
- [communities] Added Danish community and some fixes to the community
  system. [iglocska]

Changes
~~~~~~~
- [pymisp] bump. [iglocska]
- Use poetry in travis. [Raphaël Vinot]
- [version] bump. [iglocska]
- Bump PyMISP. [Raphaël Vinot]
- [database] Added db entry to re-correlate Attributes. [mokaddem]
- [submodule] updates. [iglocska]
- [UI] show customauth header. [iglocska]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [internal] Removed unused function. [Jakub Onderka]
- [internal] Little bit faster ssdeep saving. [Jakub Onderka]
- [mispzmq] Do not create array every 0.1 sec. [Jakub Onderka]

  Should lead to little bit lower CPU usage
- [internal] Update composer.phar to version 1.9.0. [Jakub Onderka]
- [objects] updated to the latest version. [Alexandre Dulaunoy]
- [version] bump. [jcarter]

Fix
~~~
- Run python tests from python. [Raphaël Vinot]
- [CLI] allow for calling the update via the CLI without passing a
  process ID. [iglocska]
- Properly install PyMISP with poetry. [Raphaël Vinot]
- Missing dependency for poetry. [Raphaël Vinot]
- [correlations] fix to an issue where attribute edits could purge
  correlations. [iglocska]

  - bug introduced by a merge gone wrong
  - attribute edits that modify fields that do not affect the correlations (such as to_ids, comment, etc) would cause correlations to be purged
- [sync] allow for both the minimal and searchminimal keywords to be
  used on the event index. [iglocska]

  - until now due to a bug only searchminimal was used
  - sync negotiation uses minimal as the key
  - this should greatly speed up the negotiation phase
- [decaying:tool] Support strict sql mode while fetching available
  Object type. [mokaddem]
- [decaying] Attributes not having a DM associated will be defaulted as
  `not decayed` [mokaddem]
- [eventGraph] Request picture for valid attachement only. [mokaddem]
- [server:edit] Prevent undefined variable. [mokaddem]
- [custom auth] correctly use HTTP_ as the default header namespace.
  [iglocska]
- [installer] Some typos. [Steve Clement]
- Force schema columns lowercase to match expected. [Jason Kendall]
- [enveloping] Fixed typo and added actual event ID to the message
  saved. [iglocska]

  gremmar meestakes are anoying.
- [dash] Dashboard not working at the moment. [Steve Clement]
- [server:edit] Always echo internal instance notice. [mokaddem]
- [UI] Correct title for '+' button. [Jakub Onderka]
- [pubsub] Do not fetch setting for every push. [Jakub Onderka]
- [UI] UUID term should be uppercase. [Jakub Onderka]
- [internal] Remove unused function. [Jakub Onderka]

Other
~~~~~
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Raphaël Vinot]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Raphaël Vinot]
- Bumped db_version. [Sami Mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Raphaël Vinot]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch 'feature-recorrelate' into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- :magic: [Raphaël Vinot]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge pull request #5659 from SteveClement/misp-dash. [Steve Clement]

  fix: [dash] Dashboard not working at the moment
- Merge branch '2.4' into misp-dash. [Steve Clement]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5654 from coolacid/issue-5653. [Andras Iklody]

  fix: Force schema columns lowercase to match expected
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge pull request #5647 from coolacid/issue-5598. [Andras Iklody]

  Allow forcing tag creation for galaxies
- Allow forcing tag creation for galaxies. [Jason Kendall]
- Merge pull request #5639 from JakubOnderka/patch-92. [Andras Iklody]

  fix: [UI] Correct title for '+' button
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5612 from coolacid/issue-5611. [Andras Iklody]

  Ensure we only have the last line from the shell command
- Ensure we only have the last line from the shell command. [Jason
  Kendall]
- Merge pull request #5633 from JakubOnderka/patch-91. [Andras Iklody]

  chg: [internal] Removed unused function
- Merge pull request #5628 from JakubOnderka/patch-87. [Andras Iklody]

  chg: [internal] Little bit faster ssdeep saving
- Merge pull request #5631 from JakubOnderka/patch-90. [Andras Iklody]

  fix: [pubsub] Do not fetch setting for every push
- Merge pull request #5630 from JakubOnderka/patch-89. [Andras Iklody]

  chg: [mispzmq] Do not create array every 0.1 sec
- Merge pull request #5629 from JakubOnderka/patch-88. [Andras Iklody]

  fix: [UI] UUID term should be uppercase
- Merge pull request #5623 from stricaud/2.4. [Andras Iklody]

  version 2.4.221 + ask about baseurl during package installation
- * Adding baseurl as a question when finalizing the package
  installation. * bump to version 2.4.221. [Sebastien Tricaud]
- Merge pull request #5625 from JakubOnderka/patch-86. [Andras Iklody]

  fix: [internal] Remove unused function
- Merge pull request #5149 from JakubOnderka/update-composer. [Andras
  Iklody]

  chg: [internal] Update composer.phar to version 1.9.0
- Merge pull request #5616 from jay-carter/patch-1. [Andras Iklody]

  chg: [version] bump
- Merge pull request #5617 from stricaud/debian. [Andras Iklody]

  Adding instructions to build a Debian Package
- Remove useless test. [Sebastien Tricaud]
- Adding instructions to build a Debian Package. [Sebastien Tricaud]

  It does not build a Debian package that can be pushed to the distribution yet, but it provides
  an easy way to have a Debian package for MISP for minimal configuration efforts.

  It is installed in /usr/share/misp and there are too many things happening in that directory,
  such as logs, instead of being in /var/log/misp/.

  However it can be useful to a lot of people, and I will gradually improve it over time.

  -- STR


v2.4.121 (2020-02-10)
---------------------

New
~~~
- [config load task] Added a task that will reload the settings on any
  console shell execution, fixes #5498. [iglocska]

  - helps with background workers being forced to fetch new settings whenever they start a new job
- [objects] pass the /breakOnDuplicate:1 flag to the /objects/add
  endpoint to deduplicate. [iglocska]

  - returns an error if the object already exists
    - objects of the same template_uuid are compared
    - non deleted attributes only
    - type + category + value + object_relation tuple is compared
- [API] Enveloping improvements. [iglocska]

  - user controlled envelope settings to control memory estimation for attribute/event sizes
  - logging of potentially too large events for the current memory envelope
  - tuning of the default values
  - added a divider for the event:attribute conversion to account for objects / event level contextualisation / correlations
- [UI] Show thumbnails at List Attributes view. [Jakub Onderka]
- [internal] Attribute::isImage method. [Jakub Onderka]
- [sync] Add additional pull filters to the sync, fixes #5510.
  [iglocska]

  - uses the same format as the index filters

Changes
~~~~~~~
- [version] bump. [iglocska]
- [internal] mispzmqtest.py. [Jakub Onderka]

  - Also check if Redis Python library is installed
  - Do not print "OK" if libraries doesn't exists
  - Return error code 1 if library doesn't exists
- [cleanup] Taking out the trash. [iglocska]

  - old unused functions removed
- [pgpPopover] Transformed text into i18n. [mokaddem]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- Bump PyMISP. [Raphaël Vinot]
- [dbSchema] Removed log table from the whitelisted tables. [mokaddem]
- [diagnostic:dbSchema] Added SQL queries to fix issues. [mokaddem]
- [UI] Check if ssdeep PHP extension is installed. [Jakub Onderka]
- Bump expected PyMISP version. [Raphaël Vinot]
- Bump PyMISP. [Raphaël Vinot]
- Bump PyMISP. [Raphaël Vinot]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [misp-taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [user] GPG key fetching by server. [Jakub Onderka]
- [attribute:add] Actually show invalid datetime format message in the
  UI. [mokaddem]
- [attribute:add] Rephrased missing timezone message. [mokaddem]
- [attribute:type] Datetime value is forced to be a valid ISO format.
  [mokaddem]

  - It is converted into UTC in the server
  - /attribute/add Form includes javascript validation part
- [misp-object] updated to the latest version. [Alexandre Dulaunoy]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- Do not use the merge functionality. [Raphaël Vinot]
- [PyMISP] Bump. [Raphaël Vinot]
- [Feed] Change all non MISP feed format feeds to fixed events. [Raphaël
  Vinot]
- [PyMISP] Bump, fix tz issues. [Raphaël Vinot]
- [PyMISP] Bump. [Raphaël Vinot]
- Changed error messages into translatable strings. [mokaddem]
- [internal] Much better error handling for feed preview. [Jakub
  Onderka]
- [UI] Resizing images. [Jakub Onderka]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [dbschema] Pretty print db_schema and removed Object.comment and
  ShadowAttr.comment from the index list. [mokaddem]
- Selectively choose what you want to import. [Pierre-Jean Grenier]
- [internal] Much faster GalaxyCluster::attachClustersToEventIndex.
  [Jakub Onderka]
- [console:server] Stop execution if user does not exists. [mokaddem]

Fix
~~~
- [security] Correctly sanitize search string in Galaxy view. [mokaddem]

  - As reported by Dawid Czarnecki
- [object] object deduplication fixed. [iglocska]
- [UI] Disable autocomplete for authkey. [Jakub Onderka]

  To prevent saving it into browser cache
- [internal] Remove unused line. [Jakub Onderka]
- [indexes] Added SQL index for tag numerical_value. [mokaddem]
- [security] Further fixes to the bruteforce handling. [iglocska]

  - resolved a potential failure of the subsystem when the MySQL and the webserver time settings are diverged
    - as reported by Dawid Czarnecki
  - several tightenings of the checks to avoid potential foul play
- [security] discussion thread ACL issues fixed. [iglocska]

  - as reported by Dawid Czarnecki
- [security] brutefoce protection rules tightened. [iglocska]

  - as reported by Dawid Czarnecki
- [API] make param tag alias of tags for /events/restSearch. [Jeroen
  Pinoy]
- [kali] Fixed kali install script (#5586) [Steve Clement]

  fix: [kali] Fixed kali install script
- [tools] Removed Viper until working again, fixed #5582. [Steve
  Clement]
- [sum] Fixed checksums. [Steve Clement]
- [kali] Fixed kali install script. [Steve Clement]
- [sync] Pull filters ignored if no custom url params added, fixes
  #5594. [iglocska]
- [export] fixed the export page breaking for text exports, fixes #5563.
  [iglocska]
- [UI] Icons in network distribution graph. [Jakub Onderka]
- [internal] cleanup of unused line. [iglocska]
- [API] several fixes to the Bro API. [iglocska]

  - always use flatten:1 to also include object attributes
  - fix the generated full export to only include the header once
- [internal] fetcher logic fail fixed. [iglocska]
- A few feeds should use fixed events by default. [Raphaël Vinot]

  Related to https://github.com/MISP/MISP/issues/5544
- [API] taxonomies controller index call fixed for API calls. [iglocska]

  - no longer limiting at 60 elements
- [log] Proper format log message for reset auth key. [Jakub Onderka]

  In future, it will be also possible to filter auth keys in logs.
- [objects:edit] Added *_seen validation and error reporting. [mokaddem]
- [CLI] Die if setting name is not correct. [Jakub Onderka]
- [server:edit] Correctly escape `%` re-enabling server setting editing.
  [mokaddem]
- Proper logout when `CustomAuth_custom_logout` is set. [Jakub Onderka]
- `DefaultRoleId` is not implemented for ApacheShibbAuth. [Jakub
  Onderka]
- [UI] Remove double escaping. [Jakub Onderka]
- [ui:galaxy] Correctly display galaxy info. [mokaddem]
- [attribute:search] Unset filtering rules on *_seen if unset.
  [mokaddem]
- [internal] AttributesController::viewPicture can be used just for
  fetching images. [Jakub Onderka]
- [UI] small username helper changes. [iglocska]
- [internal] slight tuning to the attribute restsearch memory envelop
  size. [iglocska]
- [UI] Add space after ':' in error text. [Jakub Onderka]
- [serverShell] Stopped usage of reserver keyword. [Sami Mokaddem]

  Renamed function name to let PHP 5.x parse the shell script correctly
- [diagnostic:dbSchema] Updated schema with the Attribute.comment
  indexing change nad pretty-printed it. [mokaddem]

Other
~~~~~
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5615 from JakubOnderka/patch-85. [Andras Iklody]

  chg: [internal] mispzmqtest.py
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' into enforce-iso-datetime. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into pr-5210. [mokaddem]
- Merge pull request #5614 from JakubOnderka/patch-84. [Andras Iklody]

  fix: [UI] Disable autocomplete for authkey
- Merge pull request #5607 from JakubOnderka/patch-83. [Andras Iklody]

  fix: [internal] Remove unused lines
- Merge branch '2.4' of github.com:MISP/MISP into pr-5210. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge pull request #5601 from JakubOnderka/ssdeep_ext. [Andras Iklody]

  chg: [UI] Check if ssdeep PHP extension is installed
- Fixup! chg: [user] GPG key fetching by server. [Jakub Onderka]
- Merge remote-tracking branch 'origin/2.4' into enforce-iso-datetime.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5585 from Wachizungu/fix-tag-alias-events-
  restsearch. [Andras Iklody]

  fix: [API] make param 'tag' alias of 'tags' for /events/restSearch
- Merge branch '2.4' into tools. [Steve Clement]
- Merge pull request #5579 from StefanKelm/2.4. [Andras Iklody]

  tiny typo
- Update update_progress.ctp. [StefanKelm]

  tiny typo
- Update db_schema_diagnostic.ctp. [StefanKelm]

  tiny typo
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5573 from JakubOnderka/patch-79. [Andras Iklody]

  fix: [UI] Icons in network distribution graph
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5569 from MISP/Rafiot-patch-4. [Andras Iklody]

  chg: Do not use the merge functionality.
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5562 from raw-data/2.4. [Alexandre Dulaunoy]

  [add] malsilo.domain feed
- [add] malsilo.domain feed. [raw-data]
- Merge pull request #5559 from JakubOnderka/patch-77. [Andras Iklody]

  fix: [log] Proper format log message for reset auth key
- Merge branch 'pr-5295' into 2.4. [mokaddem]
- Merge remote-tracking branch 'origin/2.4' into pr-5295. [mokaddem]
- Merge pull request #5555 from JakubOnderka/patch-76. [Andras Iklody]

  fix: [CLI] Die if setting name is not correct
- Merge pull request #5541 from JakubOnderka/proper_logout. [Andras
  Iklody]

  fix: Proper logout when `CustomAuth_custom_logout` is set
- Merge pull request #5553 from ZeroDot1/patch-1. [Andras Iklody]

  Fix the CoinBlockerLists
- Fix the CoinBlockerLists. [ZeroDot1]

  Delete the MiningServerIPList.txt feed because the feed is no longer available.

  All current downloads can be found via the CoinBlockerLists homepage.
  https://zerodot1.gitlab.io/CoinBlockerListsWeb/downloads.html

  Thanks to everyone for using the CoinBlockerLists, I appreciate it very much.

  '
  {
      "Feed": {
        "id": "68",
        "name": "This list contains all IPs - A additional list for administrators to prevent mining in networks",
        "provider": "CoinBlockerLists",
        "url": "https://gitlab.com/ZeroDot1/CoinBlockerLists/raw/master/MiningServerIPList.txt?inline=false",
        "rules": "",
        "enabled": true,
        "distribution": "3",
        "sharing_group_id": "0",
        "tag_id": "0",
        "default": false,
        "source_format": "freetext",
        "fixed_event": false,
        "delta_merge": false,
        "event_id": "0",
        "publish": false,
        "override_ids": false,
        "settings": "{\"csv\":{\"value\":\"\",\"delimiter\":\",\"},\"common\":{\"excluderegex\":\"\"}}",
        "input_source": "network",
        "delete_local_file": false,
        "lookup_visible": true,
        "headers": ""
      }
    },
  '
- Merge pull request #5548 from JakubOnderka/patch-75. [Andras Iklody]

  fix: `DefaultRoleId` is not implemented for ApacheShibbAuth
- Merge branch '2.4' of github.com:MISP/MISP into pr-view_picutre.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge pull request #5542 from JakubOnderka/patch-74. [Sami Mokaddem]

  fix: [UI] Remove double escaping
- Merge branch '2.4' of github.com:MISP/MISP into pr-patch-67.
  [mokaddem]
- Merge remote-tracking branch 'origin/2.4' into pr-selective_import_v2.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge pull request #5530 from legoguy1000/2.4. [Andras Iklody]

  Add SAML (Shibboleth) login button
- Add SAML (Shibboleth) login button. [Alex Resnick]

  With Shibboleth and SAML you have 2 options, for SAML login and don't allow local login or allow both.  The example in the documentation forces (requires) SAML authentication and thus doesn't allow you to use local credentials if needed.  This adds a button below the login form to redirect to the Shibboleth login page if using passive Shibboleth auth.  To use passive auth set "ShibRequestSetting requireSession 0/false" instead of "ShibRequestSetting requireSession 1/true"
- Merge pull request #5527 from JakubOnderka/patch-72. [Andras Iklody]

  fix: [UI] Add space after ':' in error text


v2.4.120 (2020-01-21)
---------------------

New
~~~
- [shadowAttribute] first_seen and last_seen on shadowAttributes.
  [mokaddem]
- [timeline/*-seen] Initial import of the timeline code from the
  zoidberg branch. [mokaddem]
- [attribute type] kusto-query attribute type. [Alexandre Dulaunoy]

  Kusto query is the query language for the Kusto services in Azure used
  to search large dataset. It's used in Windows Defender ATP Hunting-Queries
  and also Azure Sentinel (Cloud-native SIEM).

  To fix #5475
- [generic index] added lambda function based requirements for actions.
  [iglocska]
- [diagnostic:DBIndexes] Added complete diagnostic for database indexes.
  [mokaddem]
- [diagnostic:DBIndex] Show table columns having indexes. [mokaddem]
- [UI] first implementation of the modal forms. [iglocska]

Changes
~~~~~~~
- [PyMISP] update to the latest version. [Alexandre Dulaunoy]
- [attributes] new attribute type 'chrome-extension-id' [Alexandre
  Dulaunoy]

  This attribute is used by Chrome to uniquely identify extension.
- [timeline:display_threshold] Increased display threshold. [mokaddem]
- [worker:diagnostic] typo. [mokaddem]
- Cleanup python install on travis. [Raphaël Vinot]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [queryVersion] Bumped version. [mokaddem]
- [pymisp] bump. [iglocska]
- [UI:formSeenInput] Re-vamped the UI to be more usuable. [mokaddem]
- [stix2] Bumped the latest stix2 python library version. [chrisr3d]
- [versions] requirements for languages changed. [iglocska]
- [VERSION] bump. [iglocska]
- [PyMISP] bump. [iglocska]
- [Attribute:seen] Moved conversion iso<->utc of fs/ls in dedicated
  functions. [mokaddem]
- [eventTimeline] Cleaner array append. [mokaddem]
- [popoverPopup] Display errors whenever available. [mokaddem]
- [timeline] Synchronize *-seen at Object and ObjectAttribute level, few
  fixes and Improved UI. [mokaddem]
- [appModel] Fixed merge conflict. [mokaddem]
- [object:quickAddAttribute] Improved feedback when creation fails.
  [mokaddem]
- [timeline:ui] Replaced typeahead by chosen. [mokaddem]
- [timeline] Improved loading icon UI. [mokaddem]
- [object:quickAddAttribute:ui] Adjusted qcuik add buton placement.
  [mokaddem]
- [object:edit] Reverted useless code. [mokaddem]
- [attribute:edit] reverted useless line of code. [mokaddem]
- [mysql] Reverted all changes in `MYSQL.sql` as the update is done when
  logging in for the first time. [mokaddem]
- [shadow_attributes:edit] Support of first_seen and last_seen.
  [mokaddem]
- [attribute:restSearch] Search support for first_seen and last_seen.
  [mokaddem]
- [object:edit] Support of fs/ls sync on object for `edit` and
  `addQuickField` [mokaddem]
- [object] Set fs/ls on all attributes when an object got its fs/ls
  sets. [mokaddem]
- [attribute:restSearch] Added filtering conditions for first_seen and
  last_seen. [mokaddem]
- [restResponse] Updated doc about first_seen and last_seen. [mokaddem]
- [event:view] Added first_seen/last_seen column (event, server and
  feed) [mokaddem]
- [diagnostic] Style tweaking to be consistent with the UI. [mokaddem]
- [index] Index Attribute.comment. [mokaddem]
- Bumped queryversion. [mokaddem]
- [internationalisation] Support of multi-lang for the administrator
  update notice message. [mokaddem]
- [update:seen] Switch back to the usage of worker for the update.
  [mokaddem]
- [update] DO not execute pre-update test for the timeline update
  anymore (pre-update feature not fully supported yet) [mokaddem]
- [timeline] Removed missleading text in tooltip. [mokaddem]
- [update] Usage of `indexArray` instead of raw sql. [mokaddem]
- [object:delta] No deletion of ObjectAttribute when sync. with Object's
  FS/LS. [mokaddem]
- [timeline] Improved controller name parsing (used in form) - WiP.
  [mokaddem]
- [object:quickAttributeAdd] Replace popover selection by the generic
  picker. [mokaddem]
- [app] Improved and integrated *-seen database update. [mokaddem]
- Use default bionic release. [Raphaël Vinot]
- Bump PyMISP. [Raphaël Vinot]
- [attributeTag] Stop pruning outdated attribute tag when syncing. Will
  be re-enabled in the future. [mokaddem]
- Bump PyMISP, fix dummy event creator. [Raphaël Vinot]
- Bump PyMISP. [Raphaël Vinot]
- [taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [install] Updated the way the SHASUM of composer-setup.php… (#5494)
  [Steve Clement]

  chg: [install] Updated the way the SHASUM of composer-setup.php is handled
- [install] Updated the way the SHASUM of composer-setup.php is handled
  as per: https://getcomposer.org/doc/faqs/how-to-install-composer-
  programmatically.md. [Steve Clement]
- [install] Updated installer (#5493) [Steve Clement]

  chg: [install] Updated installer
- [install] Updated installer. [Steve Clement]
- [composer] Updated composer checksum. [Steve Clement]
- [decaying-model] updated to the latest version. [Alexandre Dulaunoy]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [PyMISP] updated to the latest version which includes kusto-query
  attribute type. [Alexandre Dulaunoy]

  new: [attribute type] kusto-query attribute type

  Kusto query is the query language for the Kusto services in Azure used
  to search large dataset. It's used in Windows Defender ATP Hunting-Queries
  and also Azure Sentinel (Cloud-native SIEM).
- [view:genericIndex] Auto extract datapaths and pass them to evaluation
  function. [mokaddem]
- [screenshots] updates with new functionalities. [Alexandre Dulaunoy]
- [diagnostic:DBIndexes] Hide notice message if index diagnostic not
  shown. [mokaddem]
- [diagnostic:DBIndexes] Cleanup, bug fix and updated db_schema.
  [mokaddem]
- Bump PyMISP. [Raphaël Vinot]
- Bump PyMISP, again. [Raphaël Vinot]
- Bump PyMISP. [Raphaël Vinot]
- [dianostic:DBSchema] Consider quoted default_value as non-critical.
  [mokaddem]
- [diagnostic:DBSchema] Hide non-critical issues by default. [mokaddem]
- [diagnostic:DBSchemaDiagnostic] Added datasource. [mokaddem]
- [internal] Faster loading list of attributes. [Jakub Onderka]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- New feature to selectively choose to import objects (or not) [Pierre-
  Jean Grenier]
- Bump PyMISP. [Raphaël Vinot]
- [Console:admin] Allow `travis` user to bring the database up to date.
  [Sami Mokaddem]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- Update object templates on travis. [Raphaël Vinot]
- Bump PyMISP. [Raphaël Vinot]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version (including new galaxy such
  as dark patterns and surveillance vendors) [Alexandre Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [taxonomies] updated to the latest version (including the ML-abuse
  one) [Alexandre Dulaunoy]
- [internal] Simplify UserController::admin_edit. [Jakub Onderka]
- [internal] Simplify User::extralog method. [Jakub Onderka]
- [UI] clown solutions. [iglocska]
- [UI] refactor of the genericForm/submitbutton to support ajax.
  [iglocska]
- [add attribute view] Controller changes for adding attribute.
  [chrisr3d]
- [types] new eppn attribute type added - EduPersonPricincipalName.
  [Alexandre Dulaunoy]

  Fix #5448
- Bumped queryversion. [mokaddem]

Fix
~~~
- [install] Update .sfv. [Steve Clement]
- [stix2] Fix stix2 for the Docs and Installer (#5526) [Steve Clement]

  fix: [stix2] Fix stix2 for the Docs and Installer
- [tools] re-generated INSTALL.sh fixed small issue in ubu. [Steve
  Clement]
- [stix] small fix to get around a current cti-python-stix2 glitch (to
  be undone) [Steve Clement]
- [form_seen] Filling *_seen field with no value remove the *_seen time.
  [mokaddem]
- [worker:diagnostic] Prevent failing if no worker are running.
  [mokaddem]
- [workers:diagnostic] Consider a queue to be healthy if one worker is
  running. [mokaddem]
- [adminSetting] Avoid trying to create new entries if previous save
  failed. [mokaddem]
- [update] fixed an issue blocking the updates from executing.
  [iglocska]

  - invalid check for the admin role - too early to check for _isSiteAdmin() at that point
- [stix 1&2 export] Checking is an error message is returned. [chrisr3d]
- [internal] upgrade issues fixed. [iglocska]
- [updateProgress] Display errors in between updates Return empty
  progress when the current progress can't be fetched. [mokaddem]
- [upgrade] removed test change. [iglocska]
- [upgrade] Added a safety net for launching superfluous updates.
  [iglocska]
- [update] typo fixed. [iglocska]
- [settings] purge previous setting, push new one. [iglocska]
- [UI] small fixes. [iglocska]
- [model:comment] Do not index the `comment` field anymore for
  shadowAttribute and Objects. [mokaddem]
- [Attribute:comment] Do not index the `comment` field anymore.
  [mokaddem]
- [db_schema] Bumped db schema to support *-seen and indexes. [mokaddem]
- [Object:DeltaMerge] Gracefully catch if *_seen field is not present in
  the pushed Object. [mokaddem]
- [update:index] Correctly log index addition errors. [mokaddem]
- [Object:quickAddAttribute] Correctly closes the popover after
  submission. [mokaddem]
- [update] Function name conflict introduced by the merge + UI
  Improvements. [mokaddem]
- [database] bumped db update number for fs/ls update. [mokaddem]
- [object:save] Inversed condition. copy/pasta fail... [mokaddem]
- [object:save] fail-safe if Object doesn't have fs/ls set. [mokaddem]
- [object:add] Catch exception if fs/ls doesn't exists. [mokaddem]
- [event:view] Icons color set to white when applicable. [mokaddem]
- [sql] updated MySQL.sql and modified comment column type. [mokaddem]
- [update] liveOff recognition and logs when updates are locked.
  [mokaddem]
- [timeline] Prevent collision for Object and Attribute having the same
  ID. [mokaddem]
- [object:setMetraFromAttribte] Pass Object reference instead of value.
  [mokaddem]
- [timeline] Removed illusion of editing timeline objects if you are not
  the owner. [mokaddem]
- [timeline] Prevent `Column not found` error if user has the `user`
  role. [mokaddem]
- [restResponse] Added support of *-seen fields. [mokaddem]
- [time_precision_tool] Support of IE. Usage of prototypes instead of a
  class. [mokaddem]
- [attribute:view] Correctly pick the matching form. [mokaddem]
- [attribute:*-seen] Force seconds to be integers and allows editForm
  for *-seen fields. [mokaddem]
- [timeline] correctly adapt time scale when expanding items. [mokaddem]
- [event:timeline] Error when trying to restore non-existing backup
  entries. [mokaddem]
- [object:quickEdit] fix input selector. [mokaddem]
- [object:quickEdit] Fixed response to be of JSON type and improved
  layout. [mokaddem]
- [object:quickAttributeAdd] Fixed response to be of JSON type and
  improved layout. [mokaddem]
- [Object:editObject] Removed Event unpublishing that induced a
  divergence of Event.timestamp. Chances are that it was causing ghost
  loggins and useless sync loops. [mokaddem]
- [attribute:quickEdit] Escalate the timestamp refresh to the Object.
  [mokaddem]
- [Attribute:editTag] Correctly escalate the timestamp refresh to the
  Object. [mokaddem]
- [Objects] editing refactored. [iglocska]

  - code made more readable
  - resolved an issue where objects could not be edited via the API without having the correct template
- [Discussion] threads cannot link to other events, fixes #5506.
  [iglocska]
- Incorrect directionality for oldest_timestamp comparisons. [Tom King]
- Make feeds a searchable scope in the logs, fixes #5501. [Andras
  Iklody]
- [PyMISP] Dummy creator. [Raphaël Vinot]
- Remove python 2 test suite. [Raphaël Vinot]
- [compat] The env variable SUDO_USER is a reserved variable (#5492)
  [Steve Clement]

  fix: [compat] The env variable SUDO_USER is a reserved variable
- [compat] The env variable SUDO_USER is a reserved variable. [Steve
  Clement]
- [module results handler] Setting attribute category/ies accordingly.
  [chrisr3d]

  - Depending on whether there is one or more type(s)
    and the category is not already set
- [module results view] No need to add "selected" [chrisr3d]
- [modules] Making sure the module format is set. [chrisr3d]

  - Making sure the module format is not empty is
    better than only making sure the variable is set
- [module results handler] Fixed wrong call. [chrisr3d]

  - $this->Attribute directly instead of
    $this->Event->Attribute
- [view:genericIndex] Fallback if `options` is not defined. [mokaddem]
- [STIX] import fixed. [iglocska]

  ________________   ___/-\___     ___/-\___     ___/-\___
       / /             ||  |---------|   |---------|   |---------|
      / /              ||   |       |     | | | | |     |   |   |
     / /             __||   | STIX  |     | | | | |     | | | | |
    / /   \\        I  ||   |       |     | | | | |     | | | | |
   (-------------------||   | | | | |     | | | | |     | | | | |
   ||               == ||   |_______|     |_______|     |_______|
   ||   TAXII       | =============================================
   ||          ____    |                                ____      |
  ( | o      / ____ \                                 / ____ \    |)
   ||      / / . . \ \                              / / . . \ \   |
  [ |_____| | .   . | |____________________________| | .   . | |__]
            | .   . |                                | .   . |
             \_____/                  -cfbd-          \_____/
- [diagnostic:DBIndexes] Typo keyname. [mokaddem]
- [internal] fixed newly introduced error with full_group_by directive
  when adding galaxies to tag collections. [iglocska]
- [internal] avoid loading outdated versions of galaxies. [iglocska]
- [diagnostic:DBSchema] Select tables schema with UPPER case. [mokaddem]
- [diagnostic:DBSchema] Force column `table_name` to be lower case.
  [mokaddem]
- [diagnostic:DBSchema] Improved UI with label. [mokaddem]
- [UI] adding attack-like galaxy clusters to tag collections was slow.
  [iglocska]

  - was generating a heatmap out of all event metadata each time for no good reason
- Don't show an empty error when there is no error. [Pierre-Jean
  Grenier]
- UpdateObjectTemplates with user ID 1. [Raphaël Vinot]
- [CLI] updateObjectTemplates handles fetching the user correctly now.
  [iglocska]
- [stix import] Storing methods names in the mapping dictionary so we do
  not store the methods themselves. [chrisr3d]
- [stix export] Storing methods names in the mapping dictionary so we do
  not store the methods themselves. [chrisr3d]
- [stix2 export] Storing methods names in the mapping dictionary so we
  do not store the methods themselves. [chrisr3d]
- [stix2 import] Storing methods names and calling them with getattr
  instead of storing the methods themselves. [chrisr3d]
- [stix2 import] Fixed import of observables with no marking attached.
  [chrisr3d]
- [tags] Fixed the taxonomy view incorrectly fetching mistyped tags over
  the actual taxonomy tags. [iglocska]
- [stix2 import] Avoid issues with relationships list when there is no
  relationship object in the stix file we want to import. [chrisr3d]
- [cleanup] removed wtf inducing debug message. [iglocska]
- [taxonomies] Fixed invalid tags being shown on the taxonomy index if
  mistyped versions exist. [iglocska]
- [event add view] Avoided setting the action variable. [chrisr3d]

  - That is available from the view side within $this->request->params
- (#5277) remove out of scope var causing weird behavior when adding an
  invalid attribute. [Will]
- [decaying:simulation] Allow ObjectAttributes to be simulated.
  [mokaddem]
- [API] include the local flag in tags when using restSearch. [iglocska]
- [add event view] Reuse of variable. [chrisr3d]
- [CLI] invalid variable used for server caching log entry. [iglocska]
- [internal] attribute restsearch - handle empty lines returned from the
  module better. [iglocska]

  - no more empty lines hopefully in some exports
- Removed useless spaces. [mokaddem]
- [decaying:basescoreComputation] Correctly support 2-tag and 3-tag.
  [mokaddem]
- [decaying:simulation] base_score popover override shows the correct
  one. Instead of always the first one. [mokaddem]
- [eventGraph] Typing do not trigger eventGraph action anymore. Fix
  #5442. [mokaddem]
- [eventGraph:addReference] Adding reference to unreferenced nodes do
  not link to the root unreferenced nodes anymore. [mokaddem]
- [event:view] Correctly display `Edit Event` when Editing instead of
  `Add Event` [mokaddem]
- [feed:previewEvent] Added `Fetch Event` button on the sidemenu.
  [mokaddem]
- [event:add] Restored extended event preview. [mokaddem]
- [event:publishRouter] Fixed parenthesis issue. [mokaddem]
- [event:view] Pivot form related event fixed. [mokaddem]
- Remove unusued config option. [Jakub Onderka]
- [internal] hard delete of attributes after a soft delete fixed.
  [iglocska]

Other
~~~~~
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Add reference to stix2-patterns issue. [Raphaël Vinot]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge pull request #5525 from Rafiot/rework_python_install. [Raphaël
  Vinot]

  chg: cleanup python install on travis
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge remote-tracking branch 'origin/zoidberg-final' into 2.4.
  [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch 'zoidberg-final' into 2.4. [iglocska]
- Merge branch 'zoidberg_final' into zoidberg-final. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into zoidberg-final.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into zoidberg-final.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into zoidberg-final.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into zoidberg-final Not a
  simple merge. Needed to fix forms and simplified how form_seen_input
  works. [mokaddem]
- Merge branch 'zoidberg-timeline' into zoidberg-final. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into zoidberg-timeline.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into zoidberg-timeline.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into zoidberg-timeline.
  [mokaddem]
- Merge remote-tracking branch 'origin/2.4' into zoidberg-timeline.
  [mokaddem]
- Merge branch '2.4' into zoidberg-timeline. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into zoidberg-timeline.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into zoidberg-timeline.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into zoidberg-timeline.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into zoidberg-timeline.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge pull request #5515 from Applenice/2.4. [Andras Iklody]

  remove invalid default feed
- Remove invalid default feed. [Applenice]
- Merge branch 'fix-sync-objectattributetags' into 2.4. [mokaddem]
- Merge pull request #5504 from tomking2/bug/first_recorded_change.
  [Andras Iklody]

  fix: Incorrect directionality for oldest_timestamp comparisons
- Merge pull request #5490 from RichieB2B/ncsc-nl/schema-status. [Andras
  Iklody]

  Mark NULL vs "" as not critical
- Mark NULL vs "" as not critical. [Richard van den Berg]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge pull request #5488 from RichieB2B/ncsc-nl/stix-json. [Alexandre
  Dulaunoy]

  Return STIX in JSON format when Accept header asks for it
- Return STIX in JSON format when Accept header asks for it. [Richard
  van den Berg]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch 'sqlIndexDiagnostic' into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5473 from airbus-cert/Fix_PHP_composer_hash.
  [Andras Iklody]

  Wrong hash composer-setup.php
- Fix composer-setup.php hash. [Amaury Leroy]
- Fix composer-setup.php hash. [Amaury Leroy]
- Fix composer-setup.php hash. [Amaury Leroy]
- Fix composer-setup.php hash. [Amaury Leroy]
- Fix composer-setup.php hash. [Amaury Leroy]
- Fix composer-setup.php hash. [Amaury Leroy]
- Fix composer-setup.php hash. [Amaury Leroy]
- Merge pull request #1 from MISP/2.4. [devnull-]

  Update fork
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge pull request #5459 from mokaddem/schemaDiagnosticImprovement.
  [Andras Iklody]

  Schema diagnostic improvement
- Merge pull request #5341 from JakubOnderka/patch-68. [Andras Iklody]

  chg: [internal] Faster loading list of attributes
- Merge pull request #5463 from
  zaphodef/feature/selective_import_objects. [Andras Iklody]

  chg: new feature to selectively choose to import objects (or not)
- Merge pull request #5464 from zaphodef/fix/empty_error_panel. [Andras
  Iklody]

  fix: Don't show an empty error when there is no error
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Raphaël Vinot]
- Merge branch 'add_attribute' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into add_attribute.
  [iglocska]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5208 from JakubOnderka/patch-34. [Andras Iklody]

  Simplify user profile logging
- Merge branch 'move_forms' into 2.4. [chrisr3d]
- Merge branch 'add_attribute_fix' into add_attribute. [iglocska]
- Merge branch '2.4' of https://github.com/MISP/MISP into add_attribute.
  [chrisr3d]
- Add: [add attribute view] Starting moving add attribute view to
  generic form. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Add: [genericForm} Added 'empty' in simple fields white list.
  [chrisr3d]

  - Allows to have default values in inputs with
    options, as opposed to inputs with no options
    where 'placeholder' works.
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge pull request #5445 from RichieB2B/ncsc-nl/fixSaveRole. [Andras
  Iklody]

  Set rate_limit_count to 0 when not defined
- Set rate_limit_count to 0 when not defined. [Richard van den Berg]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge pull request #5443 from RichieB2B/ncsc-nl/sightingDistribution.
  [Andras Iklody]

  Push sightings regardsless of distribution level
- Push sightings regardsless of distribution level. [Richard van den
  Berg]
- Merge pull request #5375 from JakubOnderka/patch-71. [Andras Iklody]

  fix: Remove unusued config option
- Add: [stix import] Importing LinkObjects as link attribute. [chrisr3d]


v2.4.119 (2019-12-02)
---------------------

New
~~~
- [server:fixDBSchema] Preliminary work to fix database schema.
  [mokaddem]
- [refactor] Massive internal refactor and cleanup of deprecated APIs.
  [iglocska]

  - new centralised restSearch function in AppController as entry point via all controllers
  - new component handling restSearch related support functions, such as parameter mapping
  - hollowed out all deprecated export functions on the event/attribute controller
    - replaced with a new functionality that remaps them to restSearch
    - all functionality should be maintained with all additional advantages introduced with restsearch
  - additional cleanup (some unused functions removed)
- [internal] Log exact error for GPG diag in error log. [Jakub Onderka]
- [statistics] Added organisation activity over time. [mokaddem]
- [API] refactored deprecated APIs to use the legacy system. [iglocska]
- [legacy] handler added for Legacy APIs. [iglocska]

  - allows for a remap of the parameters and subsequent calls to modern functions
- [sync] Added sighting sync publish button to the event view.
  [iglocska]
- [doc] Support request template (#5420) [Steve Clement]

  new: [doc] Support request template
- [doc] Support request template. [Steve Clement]
- [deprecation] Added a new library to handle deprecations. [iglocska]

  - send X-Deprecation-Warning via the API
  - set new Warning flash messages via the UI
  - counting the use of these functionalities / API endpoint and / user
    - added a diagnsitic tool to view the outcome of the collection
    - sharing of these collections with the MISP-Project will be optionally available in the future

  - two modes of operation:
    - hard deprecation (functions certainly to be removed, reported to the users via API/UI)
    - soft deprecation (gauging interest for the continued use of these functions)
- [sql diagnostics] Started work on a system to automatically generate
  scripts to fix issues. [iglocska]

  - currently somewhat limited
  - requires additional input to generate correct queries, needs an update for the default schemas
  - generated, but not exposed for now
- [sync] view remote user tool added to the server index. [iglocska]

  - should help with debugging what user is being used
- [API] Added attribute_timestamp flag to attributes/restSearch.
  [iglocska]

  Explanation of the 4 timestamp filters:
  timestamp: Filters on attribute AND event timestamp
  event_timestamp: Filters on event timestamp
  attribute_timestamp: Filters on attribute timestamp
  publish_timestamp: Filters on event.publish_timestamp
- [UI] formInfo element added to the form generator. [iglocska]
- [API] SQL dump now includes two modes. [iglocska]

  - sql_dump:1 - append the SQL dump to the response
  - sql_dump:2 - only return the SQL dump in the response
- [API] Cleaner API debugging via the API. [iglocska]

  - passing sql:1 as a url parameter will try to add the sql_dump key to the response if SQL debugging is enabled
  - allows for the easier debugging of for example search queries

Changes
~~~~~~~
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [warning-lists]  updated. [Alexandre Dulaunoy]
- [taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [VERSION] bump. [iglocska]
- [deprecation] Show data in an easier to understand format. [iglocska]
- Bump PyMISP. [Raphaël Vinot]
- [i18n] Updated norwegian translation (#5438) [Steve Clement]

  chg: [i18n] Updated norwegian translation
- [i18n] Updated norwegian translation. [Steve Clement]
- Bump PyMISP, fix lief. [Raphaël Vinot]
- Bump PyMISP. [Raphaël Vinot]
- [db_schema] updated. [iglocska]
- [diagnostic:DBSchema] Added warning for `missing_table` errors.
  [mokaddem]
- [dianostic:fixDBSchema] Added warning message. [mokaddem]
- [diagnostic:fixDBSchema] Support of missing table + support of non-
  critical warnings. [mokaddem]
- [diagnostic:fixDBSchema] Updated ACLComponent and added clean cache.
  [mokaddem]
- [diagnostic:db_schema] Added support of default_value and quick fix.
  [mokaddem]
- [galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [objects] updated to the latest version. [Alexandre Dulaunoy]
- [taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [feed] Use precomputed hashes to speedup attaching correlation. [Jakub
  Onderka]
- [statistics] Added Attribute count. [mokaddem]
- [CSRF] disable CSRF if you absolutely feel like setting yourself up
  for failure. [iglocska]
- Bump PyMISP. [Raphaël Vinot]
- [API] users/edit refactor. [iglocska]

  - load only what is needed
  - handle API requests in a cleaner way
- [REST] Updated to ExpandedPyMISP. [Steve Clement]
- [cleanup] debug() removed. [iglocska]
- [installer] Installer checksum updates. [Steve Clement]
- [doc] Updated viper-framework (-web is broken) and updated… (#5425)
  [Steve Clement]

  chg: [doc] Updated viper-framework (-web is broken) and updated Debian 10 (minor)
- [doc] Minor note on composer update. [Steve Clement]
- [doc] Tried to fix viper. Is semi-fixed viper-web broken. [Steve
  Clement]
- [doc] Better wording. [Steve Clement]
- [doc] Added 2 templates with automatic labelling. [Steve Clement]
- [internal] switch intval to (int) [iglocska]
- [internal] Renamed log action name for db worker issues to be <= 20
  characters in length. [iglocska]

  - it was a restriction based on the db schema of the log table from before
- [API] described how to add attachments to /attributes/add and
  /attributes/edit. [iglocska]
- [diagnostic:dbSchema] Whitelist columns to ignore and highlight
  critical differences. [mokaddem]
- [dbDiagnostic] Removed datefield precision as it's only available on
  MySQL 5.6+ [mokaddem]
- [dbDiagnostic] Diagnostic result is stored in a keyed array instead of
  indexed array. [mokaddem]
- [UI] Small refactor of the event add/edit views. [iglocska]

  - added new flag to form elements for the generator: stayInLine:1 - skip linebreak after field
  - removed edit view
  - modified add view to work as both add/edit
- [UI] Using generic form in the edit event view. [chrisr3d]
- [PyMISP] updated to the latest version. [Alexandre Dulaunoy]
- [UI] Using generic form in the add event view. [chrisr3d]
- [internal] Hooked the sql_dump flag into the normal flow. [iglocska]
- [feed] # ZeuS Tracker has been discontinued on Jul 8th, 20… (#5377)
  [Steve Clement]

  chg: [feed] # ZeuS Tracker has been discontinued on Jul 8th, 2019
- [feed] # ZeuS Tracker has been discontinued on Jul 8th, 2019. [Steve
  Clement]
- [installer] Updated installer to latest and amended a zmq… (#5390)
  [Steve Clement]

  chg: [installer] Updated installer to latest and amended a zmq issue
- [installer] Updated installer to latest and amended a zmq issue.
  [Steve Clement]
- [internal] Sharing group loader was grabbing organisations one by one,
  refactored. [iglocska]

  - simply fetch all org objects for the ACL checks in one shot instead of doing it on demand
    - has no real performance impact even on large sharing instances
    - reduces the number of queries greatly making debugging easier

Fix
~~~
- [diagnostic:DBSchema] Aligned schema to a clean non-tampered instance.
  [mokaddem]
- [internal] When capturing an object, avoid throwig notice errors if no
  attributes are set, fixes #5439. [iglocska]
- [internal] fixed the hacky removal of passwords on returned user
  objects for /users/edit. [iglocska]

  - this commit gets 1*
- Deleted useless comments. [mokaddem]
- [diagnostic:DBSchema] Removed query execution and soften the warning
  message. [mokaddem]
- [diagnostic:fixDBSchema] Typo. [mokaddem]
- [API] fix to a double negation fail in the tagging. [iglocska]
- [API] Better error reporting for attaching tags to events/attributes.
  [iglocska]
- [API] /users/edit modifications. [iglocska]

  - remove sanitised password when directly posting back a user object
  - more graceful error handling if something goes critically wrong
- [user API] users/edit now avoids having to set confirm_password when
  setting a password via the API. [iglocska]
- [internal] taxonomy exclusive flag now handles the key not existing in
  the JSON format. [iglocska]
- [internal] sighting restSearch. [iglocska]

  - some small fixes
- [ACL] added restsearch on the appcontroller. [iglocska]
- [stix2 export] Fixed pattern mapping for stix2 pattern objects.
  [chrisr3d]
- [internal] potential fix to uninitialised AdminSetting model errors
  when calling changeSetting() in the upgrade process. [iglocska]
- [API] Don't strip empty usersettings from users/view. [iglocska]
- [API] users/edit fixed. [iglocska]
- [internal] fixed weird user massage code. [iglocska]

  - I have no idea what I was thinking there...
- [internal] Remove unused function. [Jakub Onderka]
- [internal] Remove unused ShadowAttributesController method. [Jakub
  Onderka]
- [internal] potential fix to the sighting_timestamp missing issue when
  syncing with older instances. [iglocska]
- [UI] includeSightingdb flag not set correctly in the event attribute
  index. [iglocska]
- [tag] do not show actions column for non-admins. [Christophe
  Vandeplas]
- [security] tightened checks for restricting users from tagging data
  they shouldn't be allowed to tag. [iglocska]

  As reported by Christophe Vandeplas
- [REST] Python has no 'Null' type, it is called 'None' [Steve Clement]
- [ACL] added /events/publishSightings. [iglocska]
- [sync] Set org_id to 0 on proposal push if the sighting is anonymised.
  [iglocska]

  - correctly prevents the remote side from misattributing the sighting to the sync user's org
- [sync] Some minor changes to the sighting push. [iglocska]

  - correctly handle anonymisation
  - only push sightings, not rest of the event (decide on sender side)
  - handle receiving sanitised sightings
- [UI] duplicate entries in the attribute correlation column on the
  event view, fixes #5421. [iglocska]
- [doc] composer update missing. [Steve Clement]
- [ACL] added missing function. [Andras Iklody]
- [user view] server issues fixed. [iglocska]
- [API] bro deprecation message was premature. [iglocska]

  - needs to be added to restsearch first
- [deprecation] Added missing component. [iglocska]
- [attribute:massEdit] Allow removal of non exportable tags. Fix #5408.
  [mokaddem]
- [stix2 export] Adding attribute type or object name in the custom
  object id. [chrisr3d]

  - Should fix #5410
- [API] fixed notice errors for compact() in PHP 7.3+ [iglocska]
- [stix2 export] Exporting stix2-pattern objects as pattern. [chrisr3d]

  ... Instead of failing and being exported as custom object
- [indextable] Fixed the link field. [iglocska]
- [stix2 import] Avoids importing an object_relation value for single
  attributes. [chrisr3d]
- [stix2 import] Importing stix2-pattern object only if the pattern
  parsing failed. [chrisr3d]

  - Also adding the uuid of the stix2-pattern object
  - It avoids patterns to be exported twice if we
    export the misp event created from the import
    afterwards
- [internal] site admins should not have to be host org users to see
  server correlations. [iglocska]
- [API] adding objects now has better validation errors. [iglocska]

  - instead of silently dropping attributes in certain cases
- [tagging] Events will be unpublished when a local tag is removed
  #5363. [iglocska]
- [attribute:massTagging] Check for POST data in `post` code path. Fix
  #5359. [mokaddem]
- [temporary] Dirty fix for the diagnostic page failing on MySQL < 5.6.
  [iglocska]
- [UI] Removed console.log call for debugging purposes. [chrisr3d]
- [UI] With the correct field name, it works better ;-) [chrisr3d]

  - threat_level_id is the name of the field, and
    now the hover description works :D
- [UI] Passing the distribution, threat level & analysis description for
  the edit event view. [chrisr3d]
- Just an indent fix for the eyes. [chrisr3d]
- [internal] Removed duplicate loading of configuration. [iglocska]

  - lazy-loading the event model after an on-the-fly config change would purge the change otherwise
  - config already loaded in bootstrap anyway
- [UI] Cosmetic changes on the add event form. [chrisr3d]
- [internal] better error messages for attaching a tag failing.
  [iglocska]
- [UI] Fixed sharing group & threat level field names in add event view.
  [chrisr3d]
- [internal] Attribute/Event connectors for attribute_timestamp added.
  [iglocska]
- [UI] formInfo fixed. [iglocska]
- [internal] Load MISP version just once in AppController. [Jakub
  Onderka]
- [internal] tag attacher could run into a situation where an invalid
  tag's creation failure is not caught. [iglocska]

  - returns puzzling error messages

Other
~~~~~
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Raphaël Vinot]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Raphaël Vinot]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch 'db_fix' into 2.4. [iglocska]
- Merge branch 'db_fix' into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into feature-fix-db-
  inconsistencies. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5435 from RichieB2B/ncsc-nl/fix-sightings-push.
  [Andras Iklody]

  Select right servers for pushing sightings
- Select right servers for pushing sightings. [Richard van den Berg]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5430 from RichieB2B/ncsc-nl/perm-sighting. [Andras
  Iklody]

  Allow pushing of sightings only for perm_sighting
- Allow pushing of sightings only for perm_sighting. [Richard van den
  Berg]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5280 from vpiserchia/fix-feed-cli. [Andras Iklody]

  Server shell: use the right array key
- Server shell: use the right array key. [Vito Piserchia]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Raphaël Vinot]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5248 from JakubOnderka/patch-44. [Andras Iklody]

  new: [internal] Log exact error for GPG diag in error log
- Merge pull request #5273 from JakubOnderka/patch-54. [Andras Iklody]

  fix: [internal] Remove unused function
- Merge pull request #5317 from JakubOnderka/patch-65. [Andras Iklody]

  fix: [internal] Remove unused ShadowAttributesController method
- Merge pull request #5342 from JakubOnderka/patch-69. [Andras Iklody]

  chg: [feed] Use precomputed hashes to speedup attaching correlation
- Merge pull request #5404 from MISP/feature-OrgsStats. [Andras Iklody]

  Added more Organisation statistics
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5400 from SteveClement/REST_Client_python. [Andras
  Iklody]

  fix: [REST] Python has no 'Null' type, it is called 'None'
- Merge branch '2.4' into REST_Client_python. [Steve Clement]
- Merge branch 'push_sightings_final' into 2.4. [iglocska]
- Sync sightings on push, pull and push on add. [Richard van den Berg]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge pull request #5417 from StefanKelm/2.4. [Andras Iklody]

  Update AdminShell.php
- Update AdminShell.php. [StefanKelm]

  Adding "wwwrun" as a user since it is common under SUSE Linux
- Merge pull request #5416 from SteveClement/ISSUE_TEMPLATE. [Alexandre
  Dulaunoy]

  chg: [doc] Added 2 templates with automatic labelling
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Revert "Revert "Merge pull request #5304 from JakubOnderka/version-
  loading"" [iglocska]

  This reverts commit 623bb20cb09a79da83d31eed8ae0993bca07db13.
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Revert "Merge pull request #5304 from JakubOnderka/version-loading"
  [Raphaël Vinot]

  This reverts commit 71fb7fcbd7d4e63480e6a63c3de5e8beb019ccbe, reversing
  changes made to 11ee95aeb3d18806ea4753707a0b2c45745cf475.
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5304 from JakubOnderka/version-loading. [Andras
  Iklody]

  fix: [internal] Load MISP version just once in AppController
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]


v2.4.118 (2019-11-08)
---------------------

New
~~~
- [attribute:restSearch] Support of Orgc and GalaxyElement meta
  searches. [mokaddem]
- [event:restSearch] Support of Orgc meta searches. [mokaddem]
- [event:restSearch] Initial work for GalaxyElement searches. [mokaddem]
- [SightingDB] Added integration with SightingDB. [iglocska]

  - Added configuration tool
  - Added lookups from the event view
  - Added includeSightingdb flag for the restSearch searches
  - Added SightingDB search tool
  - Added SightingDB connection test tool
- [UI] Added the index filter component. [iglocska]
- [UI] Added new/improved index and form builder generators - Added form
  Builder generator - Added new fields to the index table generator -
  updated some existing fields for the index table generator. [iglocska]
- [tags] Preminilary support of exclusive tags based on taxonomy data.
  [mokaddem]
- [cli] server connectivity test. [Jan Skalny]
- [servers:DBDiagnostic] Improved indexTable and added new DB schema
  diagnostic (WiP) [mokaddem]

Changes
~~~~~~~
- [version] bump. [iglocska]
- [diagnostic] Exposed dbSchemaDiagnostic to the API. [mokaddem]
- [restSearch] Improved meta-search code - Correctly returns nothing if
  search on metas does not return anything - Renamed `orgc.sector` into
  `org.sector` while still being `orgc` behind the hood - Removed
  duplicated code. [mokaddem]
- [db_schema] Updated to the latest version. [mokaddem]
- [queryversion] Bumped queryversion. [mokaddem]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- [sightingdb] Added support for bulk lookups and namespacing.
  [iglocska]

  - aligned with the latest version of the sightingdb (support for the /rb endpoint)
  - added namespacing as an option / sightingdb connection, defaults to "all" if left empty
- [misp-taxonomies] updated to the latest version (exclusivity review)
  [Alexandre Dulaunoy]
- [PyMISP] updated to the latest version. [Alexandre Dulaunoy]
- [event:view] Exclusive notice UI improvements. [mokaddem]
- [attribute:addTag] Added support of `exclusive` at Attribute level.
  [mokaddem]
- [tag:exclusive] Added support of local while checking for exclusivity.
  [mokaddem]
- [event:view] Added notice and improved inconsistency text message.
  [mokaddem]
- [PyMISP] bump PyMISP to the latest version. [Alexandre Dulaunoy]
- [default] old default 'TLP Amber' is now 'tlp:amber' to be consistent
  and use MISP taxonomy naming. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version of ATT&CK October 2019.
  [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [doc] Various updates for RHEL8/CentOS8/Debian10.1. [Steve Clement]
- [stix2 import] Loading the input file once everything is initialysed.
  [chrisr3d]

  - We no longer pass the loaded stix data as parameter
    to the parser but we load it once the required
    variables are initialysed
  - Instead of passing a potentially big dictionary
    and parsing it into different variables after the
    initiation of the parser class, we directly set
    the different data structures while parsing
    the loaded file
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- Enable mailing in travis. [Raphaël Vinot]
- Bump PyMISP. [Raphaël Vinot]
- Bump PyMISP. [Raphaël Vinot]
- [taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [installer] Updated installer to support latest Kali Linux chg: [doc]
  Amended Centos7 mirror foo. [Steve Clement]
- [stix2 library] Bumped latest version. [chrisr3d]
- [doc] ssdeep can be installed via pkg_add. [Marcelo H. P. C. Chaves]
- Usage of camelCase instead of snake_case. [mokaddem]
- [update] Added special log action for workers performing the DB
  update. [mokaddem]
- [update] Remove lock notice when updates finishes. [mokaddem]
- [update] Actually reset `UpdateFailNumber` when manually unlocking.
  [mokaddem]
- [update] Improved feedback for update lock type in the UI. [mokaddem]
- [updateProgress] Improved UI. [mokaddem]
- [ACL] Added missing route to ACLComponent. [mokaddem]
- [taskScheduler] Correctly link checkbox and removed useless variable
  declaration. [mokaddem]
- [travis&install] Updated to use `runUpdates` instead of
  `updateDatabase` [mokaddem]
- [update] Added postgresql allowed DB update errors. [mokaddem]
- [updateProgress] Default to success when no pre-update-test.
  [mokaddem]
- [updateProgress] No strict validation for db_number (allow also allow
  string) [mokaddem]
- [updateProgress] Do no show negative remaining update anymore in the
  UI. [mokaddem]
- [update] Parametrized ignore_disabled in ondemand_action and support
  of string update in update_progress. [mokaddem]
- [updateProgress] fixed infinit restart loop and added support of
  autoThrottle in taskScheduler. [mokaddem]
- [taskScheduler] Improved listener registration. [mokaddem]
- [update] Added endpoint to release lock and integration with UI.
  [mokaddem]
- [update] Do not release the lock if update fails more than 3 times.
  [mokaddem]
- [updates] Disabled time-remaining animation and fixed typos.
  [mokaddem]
- [updateProgress] Added 2-way binding task status with switch button.
  [mokaddem]
- [updateProgress] Cancel animation if switch turned off. [mokaddem]
- [updateProgress] Added number of remaining db updates. [mokaddem]
- [updateProgress] Usage of GPU for animation, deleted sleeps and
  improved task. [mokaddem]
- [updateProgress:ui] Prevent text selection for switch label.
  [mokaddem]
- [updateProgress] Added threshold preventing animations. [mokaddem]
- [updateProgress] Redraw the switch if it gets overriden. [mokaddem]
- [updateProgress] Pooling task now use the taskScheduler. [mokaddem]
- [updateProgress] Started taking into account stack of updates - WiP.
  [mokaddem]
- [diagnostic] Exposed mysql and redis diagnostic on the API. [mokaddem]
- [dbSchemaDiagnostic] UI improvements. [mokaddem]
- [dbSchemaDiagnostic] Added `db_schema.json` and `dumpDBSchema.sh`
  [mokaddem]
- [update] Usage of sprintf instead of string concatenation. [mokaddem]
- [dbSchemaDiagnostic] Added big warning if dabase is in inconsistent
  state. [mokaddem]
- [dbSchemaDiagnostic] show remaining time before update unlock and
  columns that should not be there. [mokaddem]
- [update] Added new worker type `update` to perform updates. [mokaddem]
- [update] Correctly terminate parallels workers doing updates - WiP.
  [mokaddem]
- [update] Moved locking system from `updateDatase` to `runUpdates` -
  WiP. [mokaddem]

  So that `updateMISP` is also locked and workers benefits of more context
- [update] Keep track of update number in job - WiP. [mokaddem]
- [dbSchemaDiagnostic] Improved wording. [mokaddem]
- [dbSchemaDiagnostic] Improved code quality. [mokaddem]
- [dbSchemaDiagnostic] Adapt label color. [mokaddem]
- [dbSchemaDiagnostic] Catches errors and display them in the UI.
  [mokaddem]
- [dbSchemaDiagnostic] Added support of db_version. [mokaddem]
- [dbSchemaDiagnostic] Improved parsing and UI - WiP. [mokaddem]
- [dbSchemaDiagnostic] changing diagnostic - WiP. [mokaddem]
- [update] Update function name are more explicit. [mokaddem]
- [update] `updateDatabase` returns the result of the update (duplicated
  column are nbot counted as an error) [mokaddem]

Fix
~~~
- [attributes:restSearch] Fixed typo. [mokaddem]
- [UI] Automatic logout. [Jakub Onderka]
- [UI] Server diagnostics download link. [Jakub Onderka]
- [releaseUpdateLock] Fixed error message to reflect the reality.
  [mokaddem]
- [proxy] Skip_proxy was broken up until now, fixes #5324. [iglocska]

  - was simply ignored, added the hook for it for the sync tool
- [Tagging] Fixed the user/org restrictions not being adhered to when
  tagging. [iglocska]
- [Tag:exclusive] Code clean up. [mokaddem]
- MIssing quotes in test cases setup. [Raphaël Vinot]

  Fix https://github.com/MISP/PyMISP/issues/484
- [UI] Proposal attachment downloading. [Jakub Onderka]
- [stix2 import] Importing directory patterns from external stix.
  [chrisr3d]
- Bumped latest stix2 python version + Updated expected version in the
  diagnostic. [chrisr3d]
- [internal] Remove dead code from AttributesController. [Jakub Onderka]
- [UI] Show image attachment for previewing event. [Jakub Onderka]
- [stix2 import] Fixed registry-key pattern mapping. [chrisr3d]
- Do not test users settings on travis. [Raphaël Vinot]
- Revert PyMISP bump. [Raphaël Vinot]
- Buggy bump of PyMISP. [Raphaël Vinot]
- [stix diagnostic] Updated the latest stix2 version. [chrisr3d]
- [user] Include user settings in /users/view. [iglocska]
- [internal] Load Regexp just when they are requested. [Jakub Onderka]
- [stix export] Making stix json download return json instead of xml.
  [chrisr3d]
- [UI] Remove double id attribute. [Jakub Onderka]
- [UI] Remove unused code from Communities view template. [Jakub
  Onderka]
- [UI] Removed unused JS from galaxy view. [Jakub Onderka]
- [UI] Input is not pair element. [Jakub Onderka]
- [stix2 import] Better pattern parsing for values containing an '='
  [chrisr3d]
- [stix2 import] Avoid errors with report object refs not actually
  present in the bundle. [chrisr3d]
- [stix2 import] Removed unused variable in dictionary loop. [chrisr3d]
- [live:notice UI] Fixed baseurl variable. [mokaddem]
- [live:notice UI] Fixed baseurl variable. [mokaddem]
- [updateProgress] Fixed return message to better handle translation.
  [mokaddem]
- [update] Apply restriction of only 1 running process for only the
  `update` workers. [mokaddem]
- [update] Fixed bad merge and added more comments. [mokaddem]
- [update] Correctly sets liveOff and do not consider MySQL index
  addition as an error anymore. [mokaddem]
- [update] Init class before using it.. [mokaddem]
- [update] do not longer start update job if no update available.
  [mokaddem]
- [update] Switched to default usage of worker for the update.
  [mokaddem]
- [update] Started changing worker place in the update process.
  [mokaddem]

Other
~~~~~
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge pull request #5311 from JakubOnderka/patch-63. [Andras Iklody]

  fix: [UI] Automatic logout
- Merge pull request #5259 from JakubOnderka/patch-47. [Alexandre
  Dulaunoy]

  fix: [UI] Server diagnostics download link
- Merge pull request #5381 from MISP/feature-meta-search. [Sami
  Mokaddem]

  Feature meta search
- Merge branch '2.4' of github.com:MISP/MISP into feature-meta-search.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into feature-meta-search.
  [mokaddem]
- Merge pull request #5002 from MISP/revisedUpdateProcess. [Sami
  Mokaddem]

  Revised update process
- Merge branch '2.4' of github.com:MISP/MISP into revisedUpdateProcess.
  [mokaddem]
- Merge branch 'sightingdb' into 2.4. [iglocska]
- Merge branch '2.4' into sightingdb. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into revisedUpdateProcess.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into revisedUpdateProcess.
  [mokaddem]
- Merge pull request #5378 from MISP/feature-exclusive-taxonomy. [Sami
  Mokaddem]

  Feature exclusive taxonomy
- Merge branch '2.4' of github.com:MISP/MISP into feature-exclusive-
  taxonomy. [mokaddem]
- Merge pull request #5352 from MISP/Rafiot-patch-3. [Alexandre
  Dulaunoy]

  fix: MIssing quotes in test cases setup
- Merge pull request #5318 from JakubOnderka/patch-66. [Andras Iklody]

  fix: [UI] Proposal attachment downloading
- Merge pull request #5373 from cudeso/2.4. [Andras Iklody]

  Force botvrij.eu feed to use HTTPS
- Force botvrij.eu feed to use HTTPS. [Koen Van Impe]
- Update eventattributetoolbar.ctp. [Andras Iklody]
- Merge branch '2.4' of github.com:MISP/MISP into revisedUpdateProcess.
  [mokaddem]
- Merge pull request #5348 from JanSkalny/2.4. [Andras Iklody]

  new: [cli] server connectivity test
- Merge pull request #5366 from RichieB2B/ncsc-nl/logrotate. [Alexandre
  Dulaunoy]

  Allow python scripts to write to exec-errors.log
- Allow python scripts to write to exec-errors.log. [Richard van den
  Berg]
- Merge pull request #5353 from SteveClement/guides. [Andras Iklody]

  chg: [doc] Various updates for RHEL8/CentOS8/Debian10.1
- Merge pull request #5351 from RuneBergh/2.4. [Alexandre Dulaunoy]

  Adding commenting for key to use with ldap
- Adding commenting for key to use with ldap. [RuneBergh]

  Commenting in the PHP_AUTH_USER key which is set by basic auth if using ldap or AD authentication.
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge pull request #5344 from davidonzo/2.4. [Andras Iklody]

  Minor visual bug in event view
- Minor visual bug in event view. [Davide Baglieri]

  Creating a new event with no attributes the "First recorded change" value displayed is "1970-01-01 01:00:00".

  ![MISP_Event](https://raw.githubusercontent.com/davidonzo/host/master/misp_loves_70s_me_too.png)

  This is quite normal looking at the php code in "app/Controller/EventsController.php" from line 1277 to 1289
  ```
  $oldest_timestamp = false;
          if (!empty($event['Object'])) {
              foreach ($event['Object'] as $k => $object) {
                  if (!empty($object['Attribute'])) {
                      foreach ($object['Attribute'] as $attribute) {
                          if ($oldest_timestamp == false || $oldest_timestamp < $attribute['timestamp']) {
                              $oldest_timestamp = $attribute['timestamp'];
                          }
                      }
                      $attributeCount += count($object['Attribute']);
                  }
              }
          }
  ```
  Since no attributes/objects are added to the event $oldest_timestamp will always be false.
  It's just a little visual bug. So my pragmatic solution was change line 200 in "app/view/Events/view.ctp from

  ```'value' => date('Y-m-d H:i:s', $oldest_timestamp)```

  to

  ```'value' => (!$oldest_timestamp) ? '' : date('Y-m-d H:i:s', $oldest_timestamp)```
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge pull request #5343 from JakubOnderka/patch-70. [Andras Iklody]

  fix: [internal] Remove dead code from AttributesController
- Merge pull request #5306 from JakubOnderka/patch-60. [Andras Iklody]

  fix: [UI] Show image attachment for previewing event
- Add: [stix2 import] Updated the external pattern mapping with
  directory & email address objects. [chrisr3d]
- Merge pull request #5320 from eCrimeLabs/2.4. [Alexandre Dulaunoy]

  Added CVE Feed from Metasploit
- Added CVE Feed from Metasploit. [eCrimeLabs]

  The feed contains CVE numbers of vulnerabilities in Metasploit.
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge pull request #5313 from JakubOnderka/patch-64. [Andras Iklody]

  fix: [internal] Load Regexp just when they are requested
- Add: [restSearch] Support of stix1 json export. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge pull request #5312 from RichieB2B/ncsc-nl/retention-update.
  [Andras Iklody]

  Update misp_retention.py to new api, use local tags
- Update misp_retention.py to new api, use local tags. [Richard van den
  Berg]
- Merge pull request #5310 from JakubOnderka/patch-62. [Andras Iklody]

  fix: [UI] Remove double id attribute
- Merge pull request #5307 from JakubOnderka/patch-61. [Andras Iklody]

  fix: [UI] Remove unused code from Communities view template
- Merge pull request #5308 from JakubOnderka/galaxy-unused-code. [Andras
  Iklody]

  fix: [UI] Removed unused JS from galaxy view
- Merge pull request #5309 from JakubOnderka/not-pair-input. [Andras
  Iklody]

  fix: [UI] Input is not pair element
- Merge pull request #5303 from SteveClement/guides. [Steve Clement]

  chg: [installer] Updated installer to support latest Kali Linux
- Merge branch '2.4' into guides. [Steve Clement]
- Merge pull request #5296 from RichieB2B/ncsc-nl/fix-docs. [Alexandre
  Dulaunoy]

  Fix RHEL 7 / CentOS 7 docs
- Fix logrotate module for RHEL 7/CentOS 7. [Richard van den Berg]
- Use PATH_TO_MISP consistently. [Richard van den Berg]
- Make chcon's more generic. [Richard van den Berg]
- Use $WWW_USER everywhere. [Richard van den Berg]
- Keep ini files out of php-fpm.d. [Richard van den Berg]
- Use python3 from base repo. [Richard van den Berg]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge pull request #5293 from mhpchaves/patch-1. [Alexandre Dulaunoy]

  chg: [doc] ssdeep can be installed via pkg_add
- Merge branch '2.4' of github.com:MISP/MISP into revisedUpdateProcess.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into revisedUpdateProcess.
  [mokaddem]
- Merge branch 'revisedUpdateProcess' of github.com:MISP/MISP into
  revisedUpdateProcess. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into revisedUpdateProcess.
  [mokaddem]
- Merge remote-tracking branch 'origin/2.4' into revisedUpdateProcess.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into revisedUpdateProcess.
  [mokaddem]
- Merge branch '2.4' into revisedUpdateProcess. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into revisedUpdateProcess.
  [mokaddem]
- Merge branch 'workerForDBUpdate' into revisedUpdateProcess. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into workerForDBUpdate.
  [mokaddem]


v2.4.117 (2019-10-10)
---------------------

New
~~~
- [user settings] Added restrictions for certain settings. [iglocska]

  - based on role permissions
  - enforce the checks on set/delete
  - add it to the UI elements
  - /users/view /admin/users/view now include the user settings in a simplified format
- [API] Added rate limiting option to the API. [iglocska]

  - / role setting
  - can be enabled/disabled and if enabled a limit can be set
  - limit counter / 15 minutes starting from the first query
  - x-headers inform the user about their limit/remaining queries/reset in seconds
- [internal] New AppModel::logException method. [Jakub Onderka]
- [ca_path] added setting in setting manager. [iglocska]
- [internal] Allow to use custom CA. [Jakub Onderka]
- [user settings] Finalised first revision. [iglocska]

  More to come in the future
- [index table] added json field. [iglocska]
- [User settings] Added user settings system. [iglocska]

  - set settings / user
  - settings can be set by user themselves or their org admin / site admin
  - added first setting: publish_alert_filter
  - accepts boolean branched filter options
    - supports deep logical trees
    - OR/NOT/AND
    - currently supports filtering on tags and the creator organisation
- [internal] Redis diagnostic. [Jakub Onderka]
- [UI] Added JSON as valid index table field. [iglocska]
- [API] Netfilter added as new export format. [iglocska]

Changes
~~~~~~~
- Bump recommended PYMISP version. [Raphaël Vinot]
- [PyMISP] Bump. [Raphaël Vinot]
- [sync] Code cleanup. [Jakub Onderka]
- [internal] Remove unused code from AttributesController::index. [Jakub
  Onderka]
- Version bump. [iglocska]
- Bumped queryversion. [mokaddem]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [eventGraph] Renamed `rotation key` to `pivot key` and do not collaspe
  when adding/removing edges. Fix #3683. [mokaddem]
- [event:view] Displays sighting popover if button has been hovered for
  a specifig time. Fix #5211. [mokaddem]
- [PyMISP] Bump. [Raphaël Vinot]
- [UI] updated the generic element index fields. [iglocska]

  - json should accept single values without embedding them in a list
  - generic field should automatically cast a list to a comma separated string
- [internal] Refactored Events\value_field view. [Jakub Onderka]
- [internal] Removed unused value_field template from Feeds and Servers
  view. [Jakub Onderka]
- [user:me] Added `Role` object in the return value for the rest
  context. [mokaddem]
- [UI] Collapse S/MIME or GPG key. [Jakub Onderka]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [tool] gen_misp_types_categories uses jq. [Christophe Vandeplas]
- [PyMISP] updated to the latest version. [Alexandre Dulaunoy]
- [feed] Use new AppModel::logException method. [Jakub Onderka]
- [feed] Compute md5 value just once. [Jakub Onderka]
- [i18n] Updated translations. [Steve Clement]
- [cakephp] updated to latest 2.x commit. [iglocska]
- [mysql.sql] updated. [iglocska]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [internal] Use checkMISPVersion rather than duplicate impl. [Jakub
  Onderka]
- [decaying-model] Track latest version of misp-decaying-models.
  [mokaddem]
- [internal] Do not log passwords. [Jakub Onderka]
- [stix test] Updated test files with the recent changes on stix 1/2
  import/export. [chrisr3d]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [feeds] ensuring that format is following feed format standard.
  [Alexandre Dulaunoy]
- [feeds] all IPsum feeds added including the different levels.
  [Alexandre Dulaunoy]

  Thanks to @stamparm for the idea during the Cyber Exchange program
- [AppController] move debugMode setup code to a function so it can be
  reused. [Andreas Rammhold]

  There were already two places in AppComponent that implemented the same
  functionality. It makes sense to move this to a common function so it
  can also be used from Controllers that do not inherit the full
  beforeFilter functionality.

  Since `__preAuthException` is private and only called from the
  beforeFilter method after the variable has been setup we can remove
  the explicit init from there.
- [AppController] move the database connection setup to a dedicated
  function on the AppComponent. [Andreas Rammhold]

  This removes a bit of clutter from the already large beforeFilter
  method and allows other views to resuse the logic without having to
  duplicate it.
- [AppController] move the `baseurl` configuration into a helper method.
  [Andreas Rammhold]

  This makes the beforeFilter function a bit smaller while keeping all the
  functionality. It will also help with reusing the setup logic in views
  that can not execute all of AppComponent::beforeFilter, like the
  LinOTPAuth plugin.
- [AppController] move loading and initialisation of Auth plugins to
  reuseable method. [Andreas Rammhold]

  For some authentication workflows it might be desireable to execute the
  exact same code without having to call the entire beforeFilter method
  from the base class. That way you do not have to work around all the
  edge cases without having to reinvent the same code in multiple
  locations.
- [AppController] move login redirects to dedicated functions. [Andreas
  Rammhold]

  This makes it easier to modify the login redirect behaviour in a unified
  way. For now this just uses the default Auth loginAction while setting
  the `admin` attribute to `false`. Thus application behaviour should be
  unchanged.
- [PyMISP] latest version. [Alexandre Dulaunoy]
- [stix2 export] Better vulnerability object parsing. [chrisr3d]

Fix
~~~
- [PyMISP] Travis tests. [Raphaël Vinot]
- [internal] missing org object for users/view. [iglocska]
- [internal] Remove closing PHP tag. [Jakub Onderka]
- [UI] Showing whitespaces for 'text' field. [Jakub Onderka]
- Check if variables are defined. [Pierre-Jean Grenier]
- [iternal] Remove unused method EventShell::__recursiveEcho. [Jakub
  Onderka]
- [eventGraph] Fixed UI issue with duplicated ID (attributes and
  objects) Fix #5181. [mokaddem]
- [API] rate limit should only run on the API. [iglocska]
- [missing] component added. [iglocska]
- [UI] Show advanced and SG input when page is reload. [Jakub Onderka]
- [AttributesController] Fix issues related to undefined variables.
  [Pierre-Jean Grenier]
- [hover enrichment] Fixed variable name that caused issues with hover
  enrichment for more than 1 module called on 1 single attribute.
  [chrisr3d]
- [stix export] Typo. [chrisr3d]
- [internal] Set attribute restsearch page to 1 if limit is set without
  setting the page number. [iglocska]
- [UI] Linebreak between global/public tag add buttons on the attribute
  list fixed. [iglocska]

  - was driving me nuts
- [UI] Removed unused JS variable. [Jakub Onderka]
- [API] massive performance boost for large events with many
  correlations. [iglocska]

  - the logic of the JSON converter was heavy and unnecesary
- [UI] Do not show Advanced extraction when not possible. [Jakub
  Onderka]
- [sightings] Fix undefined variable with REST search. [Pierre-Jean
  Grenier]
- [internal] massive performance boost when loading events with a lot of
  objects. [iglocska]
- [internal] user_count variable is already number. [Jakub Onderka]
- [internal] Correct error handling for invalid taxonomies. [Jakub
  Onderka]
- Undefined variable when no feed was enable. [Pierre-Jean Grenier]
- [feed] fix REST problems. [Pierre-Jean Grenier]
- [feed] array from NULL is not NULL. [Pierre-Jean Grenier]
- [UI] Error handling for submitPopoverForm function. [Jakub Onderka]
- [performance] Small speed boost to the publishing process. [iglocska]

  - don't fetch the event's first degree relations when preparing to publish it
- [performance] notifications lookup on each UI page load was slow.
  [iglocska]

  - introduced a major bottleneck on large instances
  - massively reduced the load times for pages that warranted none
- [performance] notifications lookup on each UI page load was slow.
  [iglocska]

  - introduced a major bottleneck on large instances
  - massively reduced the load times for pages that warranted none
- [mysql.sql] typo resolved. [iglocska]
- [user_settings] added timestamp field. [iglocska]
- [internal] removed debug calls. [iglocska]
- [debug] Removed internal breakpoint that was left in. [iglocska]
- [correlation] Skip correlation on tasks that modify an attribute in a
  way that wouldn't warrant a recorrelation, fixes #5204. [iglocska]

  - Only recorrelate attribute if:
    - attribute is new
    - attribute already exists and value, disable_correlation, type is updated
- [API] proposals overriding attributes wasn't always working as
  expected, fixes #4032. [iglocska]

  - until now it was bound to the to_ids setting (badly) which caused nothing but headache
  - moved the new configuration to instead use the non-permissive nature of the given export formats

  - non-permissive export: if the proposal block is enabled, override attributes
  - permissive export types: ignore the proposals

  The reasoning is simple: we use the permissive export types for types that can express additional structures such as proposals, IDS flags, publish flags etc (meaning the MISP JSON/XML formats for example)
- [user setting] Left off missing changes to the controller. [iglocska]
- [logging] paranoid log entry not logging request body via the API.
  [iglocska]
- [UI] Double side menu fixed. [iglocska]
- [internal] Proposals block attributes setting broken when to_ids is an
  array. [iglocska]
- [stix 1/2 export] Catching potential exceptions and returning it as
  result in restSearch. [chrisr3d]
- [UI] GnuPG diagnostic message. [Jakub Onderka]
- [UI] Notices margin. [Jakub Onderka]
- [UI] MISP logo is in center at login page. [Jakub Onderka]
- [shell] Update updateWarningLists from CLI. [Jakub Onderka]
- [UI] Remove duplicate condition in footer.ctp. [Jakub Onderka]
- [stix 1/2 import] Making the publish checkbox work as expected.
  [chrisr3d]

  - Publishing as exxpected when the option is
    checked AND the user has the right to publish
- [stix 1/2 import] Avoid adding the original stix file in the event if
  the option is not checked. [chrisr3d]
- [stix 1/2 import] Adding misp event json data within the 'Event' field
  if it is not already in. [chrisr3d]
- [internal] paranoid log body didn't contain full body for API calls.
  [iglocska]
- [stix 1/2 restSearch] Deleting temporary files in case of an error in
  the python side. [chrisr3d]
- [stix2 export] Catching errors that could happen with custom tags.
  [chrisr3d]
- [stix import] Avoiding error with no hashes in pe objects. [chrisr3d]
- [stix test] Updated STIX1 test files with the most recent fixes on the
  export script. [chrisr3d]
- [stix export] Fixed dictionary key used to check pe sections to parse.
  [chrisr3d]
- [stix test] Fixed stix2 test file generated with changes on the script
  and the misp event test file. [chrisr3d]
- [stix test] Fixed relationship type between a file and a pe object.
  [chrisr3d]
- [stix2 export] Make Relationship objects happy with relationship
  types. [chrisr3d]
- [internal] Clear also cake core and model caches. [Jakub Onderka]
- [UI] Loading of local tags fixed via the UI, fixes #5197. [iglocska]

  - over-zealous ACL removed local tags for non sync users
  - UI only functionality, no need for the restriction at al
- [rest client] Fix overflow in the JSON parsed rest response view.
  [iglocska]
- [rest client] Add delete as a valid http method. [iglocska]
- [API] Added DELETE http method to the rest client and fixed the JSON
  response of the API info. [iglocska]
- [API] remove weird line breaks from the API descriptions. [iglocska]
- [diagnostic] Fixed stix python libraries requirements. [chrisr3d]
- [index view] Fixed index table in the case where row_element is not
  set. [chrisr3d]
- [ui] pass static_tags_only to the feed view. [iglocska]
- [sfv] Fix checksums. [Steve Clement]
- [community access requests] fixed serveral issues, fixes #5194.
  [iglocska]

  - added missing view to preview the request
  - don't throw errors when possible, instead show what should have been sent
- [UI] If a server add with a newly created external organisation fails,
  set the external organisation as the currently selected option after
  the validation fail redirect, fixes #5182. [iglocska]
- [tools] Updated installer SUMS (#5177) [Steve Clement]

  fix: [tools] Updated installer SUMS
- [tools] Updated installer SUMS. [Steve Clement]
- [sync] Single event fetch via the side menu would trigger a full pull.
  [iglocska]
- [UI] Annoying race condition fixed causing redirects to the login,
  fixes #5172. [iglocska]
- [diagnostic] Updated expected stix2 library version. [chrisr3d]
- [import modules] Avoiding issues with empty module parameter.
  [chrisr3d]
- [stix2 import] Fixed Galaxy description parsing. [chrisr3d]
- [stix2 import] Fixed vulnerability object import. [chrisr3d]

  - Better vulnerability object attributes parsing
  - Including mapping dict for direct call of the
    parsing function depending on the STIX object
    type (indicator, observable or vulnerability)

Other
~~~~~
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5263 from JakubOnderka/patch-51. [Andras Iklody]

  chg: [sync] Code cleanup
- Merge pull request #5290 from JakubOnderka/patch-59. [Andras Iklody]

  chg: [internal] Remove unused code from AttributesController::index
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Raphaël Vinot]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Raphaël Vinot]
- Merge pull request #5288 from JakubOnderka/closing-php-tag-remove.
  [Andras Iklody]

  fix: [internal] Remove closing PHP tags
- Merge pull request #5287 from JakubOnderka/patch-56. [Andras Iklody]

  fix: [UI] Showing whitespaces for 'text' field
- Merge pull request #5291 from MISP/fixEventGraphCollapse. [Sami
  Mokaddem]

  Fixes some eventGraph bugs
- Merge branch '2.4' of github.com:MISP/MISP into fixEventGraphCollapse.
  [mokaddem]
- Merge pull request #5284 from RichieB2B/ncsc-nl/no-index. [Andras
  Iklody]

  Check if Organisation index exists
- Check if Organisation index exists, fixes #4809. [Richard van den
  Berg]
- Merge pull request #5285 from zaphodef/fix/undefined_variables.
  [Andras Iklody]

  fix: check if variables are defined
- Merge pull request #5275 from JakubOnderka/patch-55. [Andras Iklody]

  fix: [iternal] Remove unused method EventShell::__recursiveEcho
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5278 from JakubOnderka/value-field. [Andras
  Iklody]

  Value field template
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge pull request #5271 from JakubOnderka/patch-53. [Andras Iklody]

  fix: [UI] Show advanced and SG input when page is reload
- Merge pull request #5269 from zaphodef/fix/attributes_undef_var.
  [Andras Iklody]

  fix: [AttributesController] Fix issues related to undefined variables
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5267 from garanews/2.4. [Andras Iklody]

  Fix some typo
- Fix some typo. [garanews]

  Fix some typo
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5261 from JakubOnderka/patch-49. [Andras Iklody]

  fix: [UI] Removed unused JS variable
- Merge pull request #5254 from JakubOnderka/gpg_key_view. [Andras
  Iklody]

  chg: [UI] Collapse S/MIME or GPG key
- Merge pull request #5262 from JakubOnderka/patch-50. [Andras Iklody]

  fix: [UI] Do not show Advanced extraction when not possible
- Merge pull request #5266 from
  zaphodef/fix/undefined_variable_sightings. [Andras Iklody]

  fix: [sightings] Fix undefined variable with REST search
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5260 from JakubOnderka/patch-48. [Andras Iklody]

  fix: [internal] user_count variable is already number
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge pull request #5253 from zaphodef/fix/import_empty_feed. [Andras
  Iklody]

  fix Feed API
- Merge branch '2.4' into fix/import_empty_feed. [Andras Iklody]
- Merge pull request #5252 from JakubOnderka/patch-45. [Andras Iklody]

  fix: [internal] Correct error handling for invalid taxonomies
- Merge pull request #5251 from zaphodef/fix/message_fetch_no_feed.
  [Andras Iklody]

  fix: undefined variable when no feed was enable
- Merge pull request #5247 from ancailliau/fixes_5244. [Andras Iklody]

  Fixes #5244.
- Fixes #5244. [Antoine Cailliau]

  AttributeController->addTag was searching for attribute id
  without flattening.
- Add: [attributes] new dash cryptocurrency address attribute type.
  [Alexandre Dulaunoy]
- Merge pull request #5245 from ancailliau/fixes-5242. [Andras Iklody]

  Fixes #5242
- Fixes #5242. [Antoine Cailliau]
- Merge pull request #5205 from JakubOnderka/patch-31. [Andras Iklody]

  fix: [UI] Error handling for submitPopoverForm function
- Merge pull request #5217 from JakubOnderka/patch-36. [Andras Iklody]

  new: [internal] New AppModel::logException method
- Merge pull request #5226 from JakubOnderka/patch-39. [Alexandre
  Dulaunoy]

  chg: [feed] Compute md5 value just once
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5239 from SteveClement/i18n. [Andras Iklody]

  chg: [i18n] Updated translations
- Merge branch 'cacert' into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch 'dev_session' into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge pull request #5198 from JakubOnderka/redis-info. [Andras Iklody]

  new: [internal] Redis diagnostic
- Merge pull request #5202 from JakubOnderka/patch-30. [Andras Iklody]

  fix: [UI] GnuPG diagnostic message
- Merge pull request #5222 from JakubOnderka/patch-37. [Andras Iklody]

  fix: [UI] Notices margin
- Merge pull request #5225 from JakubOnderka/patch-38. [Andras Iklody]

  fix: [UI] MISP logo is in center at login page
- Merge pull request #5230 from JakubOnderka/patch-41. [Andras Iklody]

  fix: [shell] Update updateWarningLists from CLI
- Merge pull request #5231 from StefanKelm/2.4. [Andras Iklody]

  Update global_menu.ctp
- Update global_menu.ctp. [StefanKelm]

  Align menu with other entries
- Merge pull request #5233 from JakubOnderka/patch-42. [Andras Iklody]

  fix: [UI] Remove duplicate condition in footer.ctp
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge pull request #5215 from ancailliau/add_localtag_api. [Andras
  Iklody]

  Add support to add local tags to an event using the API.
- Add support to add local tags to an event using the API. [Antoine
  Cailliau]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge pull request #5216 from JakubOnderka/patch-35. [Andras Iklody]

  chg: [internal] Use checkMISPVersion rather than duplicate impl
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Relaxed defanging rules, fixes #5203. [Andras Iklody]

  Removed multiple dot implosion for links/urls
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge pull request #5201 from JakubOnderka/disable-password-logging.
  [Andras Iklody]

  chg: [internal] Do not log passwords

  - affects passwords from server settings, user passwords already sanitised
- Merge pull request #5200 from davidonzo/2.4. [Alexandre Dulaunoy]

  Added DigitalSide OSINT Feed
- Added DigitalSide OSINT Feed. [Davide Baglieri]

  Added DigitalSide OSINT Feed to the list of available OSINT sources.
  Here is the home page of the project: https://osint.digitalside.it/

  As reported in the project home page the MISP feed cointains a set of Open Source Cyber Threat Intellegence information, monstly based on malware analysis and compromised URLs, IPs and domains. The purpose is to develop new wayes to hunt, analyze, collect and share relevants sets of IoCs to be used by SOC/CSIRT/CERT with minimun effort.

  Hope this help the community.
  Hope the community will help me to share relevant infos as well.

  Regards
- Merge pull request #5169 from JakubOnderka/clean-caches. [Andras
  Iklody]

  fix: [internal] Clear also cake core and model caches
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5187 from challs/refactor-appController. [Andras
  Iklody]

  Refactor app controller
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]


v2.4.116 (2019-09-16)
---------------------

New
~~~
- [sync] Added sync priority system to prioritise the order of instances
  to push to. [iglocska]
- [CLI] Added cleanup tool to purge all events related to a feed.
  [iglocska]

  - Simply run /var/www/MISP/app/Console/cake Admin purgeFeedEvents [user_id] [feed_id]
  - works for CSV/Freetext feeds
- [stix2 export] Parsing relationships between objects. [chrisr3d]

  - Which includes of course relationships between
    objects and objects, and the ones between
    objects and attributes
- [API] verbose output for /servers/update. [iglocska]
- [event:view] Added support of decay score. [mokaddem]
- [decaying:rest] Filtering out of decayed attributes. [mokaddem]
- [decaying] Partial API support - WiP. [mokaddem]
- [restResponse] Added entries in Attribute/RestSearch for decaying
  model support. [mokaddem]
- [decaying] Added models import and export feature. [mokaddem]
- [restSearch] restSearch module for ATT&CK Sightings. [chrisr3d]

  - Returning ATTA&CK Sightings in json format for
    events and attributes with mitre-attack-pattern
    galaxies attached
  - For further details on the ATT&CK Sightings,
    please visit https://attack.mitre.org/resources/sightings/
  - Also thanks to @johnwunder for the clarification
    on the output format
- [auth key fail logging throttle] Throttle the auth key failed log
  entries to 1 / hour / key. [iglocska]

Changes
~~~~~~~
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [misp-objects] updated to the latest one. [Alexandre Dulaunoy]
- [taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- Bump PyMISP. [Raphaël Vinot]
- [version] bump. [iglocska]
- [feed] Break loop when match is found. [Jakub Onderka]
- [PyMISP] Bump. [Raphaël Vinot]
- [API] /events/view now accepts the deleted parameter via posted
  parameters too. [iglocska]
- [decaying:simulation] Disabled sorting on score (will be implemented
  in the next `decaying` version) [mokaddem]
- [decaying] Changed `name` column type from `text` to `varchar(255)`
  [mokaddem]
- [decaying] Added log entry if formula cannot be loaded. [mokaddem]
- [internal] Simplify installation with composer. [Jakub Onderka]
- [decaying:(en|dis)able] Converted empty form with built-in cakephp
  `postLink` [mokaddem]
- [decaying] Improve UI when multiple eventTags get overriden by
  attributeTag. [mokaddem]
- [decaying:simulation] Swapped round to floor when rounding sightings
  timestamp. [mokaddem]
- [decaying:model] Seventh batch of fix from the PR review - WiP (not
  tested) [mokaddem]
- [decaying:model] Sixth batch of fix from the PR review - WiP (not
  tested) [mokaddem]
- [decaying:model] Fith batch of fix from the PR review - WiP (not
  tested) [mokaddem]
- [decaying:model] Fourth batch of fix from the PR review - WiP (not
  tested) [mokaddem]
- [decaying:model] Third batch of fix from the PR review - WiP (not
  tested) [mokaddem]
- [decaying:model] Second batch of fix from the PR review - WiP (not
  tested) [mokaddem]
- [decaying:model] First batch of fix from the PR review - WiP (not
  tested) [mokaddem]
- [database] Added indexes to decaying models and related tables.
  [mokaddem]
- [event] applying few PSR2 rules. [mokaddem]
- [decaying:simulation] restSearch comments added to be fixed in next
  decaying version. [mokaddem]
- [decaying] First batch of fix from the PR review - WiP (not tested)
  [mokaddem]
- Added CR/LF. [mokaddem]
- [sql] align initial perm with sightings. [mokaddem]
- [app] bumped queryversion. [mokaddem]
- [decaying:update] Added a warning in case the folder is empty.
  [mokaddem]
- [server:submodule_version] Whitelisted `misp-decaying-models` for the
  UI. [mokaddem]
- [gitmodule] Added git-submodule `misp-decaying-models` [mokaddem]
- [decaying:import] When importing a model, mapping is imported as
  custom mapping. [mokaddem]
- [decaying] Round all sightings at once. [mokaddem]
- [decaying:simulation] Support of `score` on-the-fly threshold
  override. [mokaddem]
- [decaying] Added alias `score` to override on-the-fly the treshold of
  a model. [mokaddem]
- [decaying] `includeFullModel` parameter support in the UI. [mokaddem]
- [attribute:restSearch] New paramter `includeFullModel` to attach full
  model information. [mokaddem]
- [decaying] Added `default` column in decayingModels table, code path
  for `rest` and improved ACL. [mokaddem]
- [decaying:add] Added help for parameters. [mokaddem]
- Bumped query version. [mokaddem]
- [decaying] Added default models to selection when fetching associated
  models. [mokaddem]
- [decaying:simulation] UI Tweakings for screen resize. [mokaddem]
- [decaying] Improved embedded JSONs saving. [mokaddem]
- [decaying] Pre-process element to be added just to be sure. [mokaddem]
- [decaying:base_score_config] Simulation at predicate level in the user
  interface. [mokaddem]
- [decaying:base_score_config] Improved UI responsiveness. [mokaddem]
- [decaying:base_score_config] Consider predicate weight UI only - WiP.
  [mokaddem]
- [decaying:base_score_config] Added reason of taxonomy exclusion.
  [mokaddem]
- [roles] Initially sets perm_decaying permission to mirror sighting
  permission. [mokaddem]
- [decaying] Improved response when adding a model. [mokaddem]
- [decaying] Deleted unused lines creating mapping for default models.
  [mokaddem]
- [decaying:simulation] Basescore computation steps UI improvements.
  [mokaddem]
- [decaying:effectiveRatio] Tags not having numerical_value doesn't
  impact effective taxonomy ration anymore. [mokaddem]
- [decaying:JS] refacto - declare local variable. [mokaddem]
- [decaying:tool] Stringify objects in table. [mokaddem]
- [decaying] Few views tweakings. [mokaddem]
- [decaying] More sanitization and indentation is important.. [mokaddem]
- [decaying] Better Inheritance and comments. [mokaddem]
- [decaying] Added formula description in multiple location. [mokaddem]
- [decayingMapping] Refacto - Comments and code optimization. [mokaddem]
- [decaying] Refacto - Few renames and comments. [mokaddem]
- [decaying] refact -  Accept PUT and added comment for attribute
  removal in restSearch. [mokaddem]
- [decaying] Code refactoring, commenting and slight optimization.
  [mokaddem]
- [decaying:basescore_config] Tooltip does not modify talbe layout
  anymore. [mokaddem]
- [decaying:tool] Handle is placed closer to t=0. [mokaddem]
- [decaying] Renamed `tau` and `delta` into `lifetime` and `decay_speed`
  [mokaddem]
- [roles] Added `perm_decaying` role. [mokaddem]
- [decaying] Improved sidemenu for decaying. [mokaddem]
- [decaying:simulation] Added sidemenu. [mokaddem]
- [decaying:tool] Highlight models edition compared to creation.
  [mokaddem]
- [decaying] Improved ACL integration for the UI. [mokaddem]
- [decaying] Added `DESCRIPTION` variable for each `.php` formula files.
  [mokaddem]
- [decaying:tool] Added table filtering buttons. [mokaddem]
- [decaying:index] Added quick filter buttons. [mokaddem]
- [decaying] Improved coverage of model overrides to the API. [mokaddem]
- [decaying] Slightly improved `Model/DecayingModel` with shortcuts code
  quality and options. [mokaddem]
- [decaying] Usage of cakePHP folder API. [mokaddem]
- [decaying:add] `all_orgs`` checked by default. [mokaddem]
- [decaying:index] Improved UI. [mokaddem]
- [decaying] More consistency about `parameters.settings` when empty.
  [mokaddem]
- [decaying] `isDefault` for every models and added more JS robustness.
  [mokaddem]
- [decaying:edit] Notice if editing a default model. [mokaddem]
- [decaying] `FetchAllowedModels` now supports `all_orgs` [mokaddem]
- [decaying] Renamed function and started true implemention of ACL for
  models. [mokaddem]
- [decaying] Added restricted edition and `all_orgs`` flag - WiP.
  [mokaddem]
- [globalmenu] Added link to `/decayingModel/index` [mokaddem]
- [decaying:view] Added logo to distinguish between custom and default
  models. [mokaddem]
- [decaying:index] Added logo to distinguish between custom and default
  models. [mokaddem]
- [decaying] Added some FIXME and changed FontAwesome classes.
  [mokaddem]
- [decaying] Allow for model parameteres override. [mokaddem]
- [decaying] Usage of classname instead of const, support of `retention`
  taxonomy and small fix. [mokaddem]
- [decaying] Added list of available formulas and model settings - WiP.
  [mokaddem]
- [decaying] Changed default formula name to polynomial. [mokaddem]
- [sidemenu:decayingModel] Added dividers. [mokaddem]
- [event:view] Link to simulation page. [mokaddem]
- [decaying:rest] Renamed `decayed` into `excludeDecayed` for better
  usability. [mokaddem]
- [decaying] Added axis labels. [mokaddem]
- [decaying] Added formula field in the index. [mokaddem]
- [decaying] Split score computation part into classes for more
  flexibility. [mokaddem]
- [decaying] Full support of enable/disable model. [mokaddem]
- [decaying:index] Added support of enable/disable on the index.
  [mokaddem]
- [decaying:tool] Added support of enabled model in the UI. [mokaddem]
- [decaying:tool] Small UI tweek. [mokaddem]
- [decaying:basescore] Moved JS in its own file. [mokaddem]
- [decaying] Usage of the assetLoader. [mokaddem]
- [decaying] UI/UX improvements. [mokaddem]
- [decaying] Slight refactoroing for styling. [mokaddem]
- [decaying] static file renaming and moved to its own style file.
  [mokaddem]
- [decaying:simulation] Added responsiveness to SVG. [mokaddem]
- [decaying:simulation] Improved feedback on how default_base_score is
  set. [mokaddem]
- [decaying:simulation] No more modal support for simulation tool.
  [mokaddem]
- [decaying:tool] Dynamic redraw of the model table to support dynamic
  update. [mokaddem]
- [decaying:simulation] Hints for tag override and change to larger
  popover. [mokaddem]
- [decaying:simulation] Added current time and score and improved UI.
  [mokaddem]
- [decaying:model] Added support of default base_score. [mokaddem]
- [decaying:simulation] Alert user if base_score has not been configured
  yet. [mokaddem]
- [decaying:simulation] Base score computation steps and improved UI.
  [mokaddem]
- [decaying:simulation] Added support of base_score computation, various
  UI improvements and different method to compute scores. [mokaddem]
- [attribute:search] Added support of `contain` in
  fetchAttributeSimple() [mokaddem]
- [decaying:simulation] Improved tooltip generation. [mokaddem]
- [decaying:simulation] Removed commented out lines. [mokaddem]
- [decaying:simulation] Improved UI. [mokaddem]
- [decaying:simulation] Support of both modal and fullscreen simulation.
  [mokaddem]
- [decaying:simulation] Support of sightings in the decaying simulation.
  [mokaddem]
- [decaying:simulation] Draft 2 of simulation chart line - WiP.
  [mokaddem]
- [decaying:simulation] Draft of simulation chart line - WiP. [mokaddem]
- [decaying:simulation] Support of row clicking. [mokaddem]
- [decaying:simulation] Attribute searches. [mokaddem]
- [decaying:simulation] Started simulation view - WiP. [mokaddem]
- [decaying:tool] Object categories are treated as an array. [mokaddem]
- [decaying] Improved UI and limit number of digit in parameters.
  [mokaddem]
- [decaying:tool] Full support of base_score configuration. [mokaddem]
- [decayingModel:controller] Updated edit endpoint to match the correct
  view. [mokaddem]
- [decayingModel:add] Edit view based on Add view. [mokaddem]
- [decaying:base_score] base_score computation for custom tags and
  Improved UI. [mokaddem]
- [decaying:base_score] Custom tagging in base score examples.
  [mokaddem]
- [decaying:tool] Show available tags in the taxonomy. [mokaddem]
- [decaying:tool] Added example table with automatic tags picking and
  pass config to the model - WiP. [mokaddem]
- [decaying:tool] Started implementation of tag support and examples in
  the `adjust base_score` [mokaddem]
- [decaying:tool] Filter taxonomies not having numerical score.
  [mokaddem]
- [decaying] UI tweaking on the galaxy tree map. [mokaddem]
- [css] Increase z-index of popover. [mokaddem]
- [decaying] Improved UI - WiP. [mokaddem]
- [decaying] slight UI Improvement - WiP. [mokaddem]
- [decaying] Improved UI - WiP. [mokaddem]
- [decaying] Started support of taxonomies (base_score) - WiP.
  [mokaddem]
- [decaying] Started taxonomies integretion - WiP. [mokaddem]
- [decayingTool] Added missing class. [mokaddem]
- [decayingTool] Added number of type assigned to a model. [mokaddem]
- [decayingTool] Added selection history and selection restoration.
  [mokaddem]
- [decayingTool] Improved UI - WiP. [mokaddem]
- [decaying] fixed bug (array_values) and improved layout - WiP.
  [mokaddem]
- [decaying] Improved getAssociatedModels - WiP. [mokaddem]
- [decaying] Clean-up - WiP. [mokaddem]
- [Decaying] Improved mapping reset and started integration with the
  interface. [mokaddem]
- [decayingTool] Improved related type retreival and improved UI - WiP.
  [mokaddem]
- [DecayingTool] Added more fields. [mokaddem]
- [decayingModel] Added update mechanism from local files and started
  `decaying_model_mappings` [mokaddem]
- [decayingTool] Added grid in the chart. [mokaddem]
- [decayingTool] Added filtering/search on the Attribute type table.
  [mokaddem]
- [decayingTool] Switched to JQuery plugin instead of raw JS. [mokaddem]
- [decayingTool] Improved bounding rect - WiP. [mokaddem]
- [decayingTool] removed comments. [mokaddem]
- [decayingTool] UI improvement - WiP. [mokaddem]
- [decayingTool] Majority has been moved to d3. Still WiP. [mokaddem]
- [devayingTool] UI improvement - WiP. [mokaddem]
- [DecayingTool] Playing around with d3 - WiP. [mokaddem]
- [decayingTool] Moving from chart.js to d3.js. [mokaddem]
- [DecayingTool] Added list of available Object Attribute. [mokaddem]
- [decaying] Improved selection performance. [mokaddem]
- [decayingTool] Added more description and started support of Object
  and non-ToIDS Attributes. [mokaddem]
- [decayingTool] Moved JS in its own file + added table checkbox.
  [mokaddem]
- [decayingModel] Improved UI (selectable behavior) - WiP. [mokaddem]
- [decayingModel] Added Col org and splitted json into input fields.
  [mokaddem]
- [decaying] Model and UI improvement - WiP. [mokaddem]
- [decayingTool] Added model and controller. [mokaddem]
- [decayingTool] More info on Attribute types and model loading - WiP.
  [mokaddem]
- [decayingTool] More info and help text. [mokaddem]
- [deacyingTool] Improved UI - WiP. [mokaddem]
- [decayingTool] Added var. [mokaddem]
- [decaying] UI skeleton - WiP. [mokaddem]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- Set composer vendor dir right in composer.json. [Jakub Onderka]
- Put require PHP version and extension into composer.json. [Jakub
  Onderka]
- [users] Remove unused method UsersController::arrayCopy. [Jakub
  Onderka]
- Remove not used Net_GeoIP submodule. [Jakub Onderka]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [sync] Further improvements to the connection test logging. [iglocska]
- [sync] Connection test POST test logs the full response, not just the
  expected part. [iglocska]

Fix
~~~
- [stix2] Fixed custom objects parsing when an attribute is multiple.
  [chrisr3d]

  - Avoids loss of attributes that are multiple,
    during the export, by returning them in a list
  - Supporting import of of custom values that are
    in a list, as single multiple attributes
- [internal] Added a code branch to check if saddarray is available - if
  yes, use it. [iglocska]

  - for the warninglist model's cacheWarninglistEntries function
- [UI] Allow to skip pagination in IndexTable. [Jakub Onderka]
- [internal] warninglist missing Redis::sAddArray() fixed. [Andras
  Iklody]
- [prio] changePriority function responses fixed. [iglocska]
- [API] hard delete passable via different methods to /attributes/delete
  than just ordered URL parameters. [iglocska]
- [internal] Fix post check for attribute delete function via the API.
  [iglocska]
- [server prio] Don't block the reordering even when the requested move
  is invalid. [iglocska]

  - helps with fixing misaligned server lists
- [server prio] reprioritise should be more lenient if there's a messed
  up priority order as the starting point. [iglocska]

  - should still return false for the rearranging, but should re-set the priority list based on the current positions
- [UI] Attribute search sort by date fixed. [iglocska]
- [ACL] priority change for servers tied into the ACL. [iglocska]
- [server prio] Automatically put new servers to lowest prio instead of
  highest. [iglocska]
- [UI] Fix typo in community view. [Jakub Onderka]
- [decaying:base_score] Create temporary false tags when they are
  defined in their taxonomy but not created yet. [mokaddem]
- [decaying:base_score] Single taxonomy appear in the correct namespace.
  [mokaddem]
- [decaying:base_score] Round base_score config up to 4 digits.
  [mokaddem]
- [decaying] `.json` view in `decaying/view` [mokaddem]
- [decaying:import] Force somes fields to be present while importing a
  decaying model. [mokaddem]
- [UI] removed obsolete logo preview tool from org add/edit. [iglocska]
- [stix2 export] Avoids passing variable already contained in another
  variable passed at the same time. [chrisr3d]
- [stix2 export] Removed some useless processing. [chrisr3d]
- [decaying] fixed `const` error. [mokaddem]
- [decaying] Correctly add database indexes. [mokaddem]
- [regression] removed readded invalid acl entry. [Andras Iklody]
- [ACL] removed two unused functions. [iglocska]
- [API] Empty strings should be embedded in an array for the JSON
  output. [iglocska]
- [decaying:simulation] Make sure every sightings have a rounded
  timestamp. [mokaddem]
- [decaying] typo 4. [mokaddem]
- [decaying] typo 3. [mokaddem]
- [event] typo 2. [mokaddem]
- [event] typo. [mokaddem]
- [decaying:tool] Replaced `title` function into `text` [mokaddem]
- [decaying:import] imported models from directory are correctly saved
  as default. [mokaddem]
- [decaying:import] Correctly remove id, uuid and preserve the import
  data. [mokaddem]
- [event:view] Toggle boolean buttons. [mokaddem]
- [acl:decaying] Fixed ACL permissions. [mokaddem]
- [decaying:add] Name should be input rather than textarea. [mokaddem]
- [decaying:add] Formula field should be a select. [mokaddem]
- [event:fetch] DO not duplicate scores for object's attributes anymore.
  [mokaddem]
- [decaying:tool] Enabled icon is correctly displayed in the model
  table. [mokaddem]
- [appModel] SQL query syntax fixed. [mokaddem]
- [decaying] UI - Interface errors and sanitization. [mokaddem]
- [decaying:base_score_config] basescore computation steps works again -
  WiP. [mokaddem]
- [appmodel] Added db_change number for the decaying update. [mokaddem]
- [Sightings] Plugin.Sightings_policy=Event Owner now shows sightings
  that belong to the creating org. [mokaddem]
- [decaying] Include EventTags for score computation in `event/view`
  [mokaddem]
- [Tags] Correctly records `numerical_value` when enabling a taxonomy
  for the first time. [mokaddem]
- [decaying:tool] Correctly update the state of the enable/disable
  button after editing. [mokaddem]
- [decaying:tool] Prevent Object types overriding attribute types.
  [mokaddem]
- [decayingMapping:tool] Returns all allowed mapping if type list is
  empty. [mokaddem]
- [decaying:tool] Set `isEditable` parameter after editing a model.
  [mokaddem]
- [decaying] Set default value and pre-checks. [mokaddem]
- [decaying:basescore_config] Fixed CSS for large tags. [mokaddem]
- [decaying:tool] UI - Basescore does not override table anymore.
  [mokaddem]
- [decaying:simulation] Sorting result is displayed properly. [mokaddem]
- [decaying:simulation] Support of object_attribute in the simulation
  graph. [mokaddem]
- [decaying:tool] Attribute type table searching regression fixed.
  [mokaddem]
- [decaying] Adjust score if the attribute was modified after the last
  sighting. [mokaddem]
- [decaying] Fixes on UI, Basescore overflow and unauthorized edition.
  [mokaddem]
- [decaying:acl] Various ACL fixes. [mokaddem]
- [decaying:.json] Restored working behavior of `.json` views.
  [mokaddem]
- [decaying:tool] Correctly record type mapping if assigned during model
  creation. [mokaddem]
- [decaying] Do not access existing keys anymore. [mokaddem]
- [decaying:tool] Correctly save formula changes. [mokaddem]
- [decaying] attribute_types count fix. [mokaddem]
- [decaying:tool] Quick fix for mapping attribute type to models.
  [mokaddem]
- [decayingModel] Correctly skip tags if taxonomomy has not been
  configured. [mokaddem]
- [Taxnomy:updateTag] Do not throw an error if taxonomy does not contain
  a numerical value. [mokaddem]
- [taxonomy:update] numerical_value gets updated correctly. [mokaddem]
- [taxonomy] Keep taxonomy predicates. [mokaddem]
- [decayingTool] Selection for checkboxes are correctly handled.
  [mokaddem]
- [decaying] Allow translation on errors. [mokaddem]
- [decayingTool] Prevent drawing illegal parameters. [mokaddem]
- [customauth] default setting for use_header_namespace should adhere to
  what is displayed (true) [iglocska]

  - as requested by the MELiCERTES consortium for CSP
- [feed] When fetching feeds, accept also text/plain in HTTP. [Jakub
  Onderka]
- Require exact monolog version 1.24. [Jakub Onderka]
- [internal] blackhole function default fixed. [iglocska]
- [audit] Correct title in audit log when admin edit user. [Jakub
  Onderka]
- [ACL] Added resetremoteauthkey to the ACL system. [iglocska]
- [sync] Post test fixed for sync users. [iglocska]
- [stix import] Fixed ttps malware from external stix files parsing.
  [chrisr3d]
- [stix import] Additional test if leveraged ttps are not None to avoid
  issues. [chrisr3d]
- [stix export] Typo on course of action galaxy type. [chrisr3d]
- [stix export] Making the validator happy with capec ids. [chrisr3d]
- [stix export] Avoiding custom vocabularies for an easier parsing of
  the result file. [chrisr3d]
- [stix export] Specifying tool name for mitre-tool galaxies. [chrisr3d]
- [stix export] Exporting tool type. [chrisr3d]

  - Type is what we call galaxy name, for instance
    Tool, Enterprise Attack - Tool, etc.
- [stix export] Exporting malware type. [chrisr3d]

  - Type is what we call galaxy name, for instance
    Stealer, Malware, Ransomware, etc.
- [stix import] Separation between vulnerability objects & attributes.
  [chrisr3d]
- [stix import] Keeping attack pattern, vulnerability & weakness objects
  uuid. [chrisr3d]
- [stix import] Listing ttps uuids instead of the full ttp ids.
  [chrisr3d]

  - Easier to compare directly uuids in related ttps
- [stix import] Fixed some typos. [chrisr3d]

Other
~~~~~
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge pull request #5097 from JakubOnderka/patch-18. [Andras Iklody]

  chg: [feed] Break loop when match is found
- Merge pull request #5163 from JakubOnderka/patch-28. [Andras Iklody]

  fix: [UI] Allow to skip pagination in IndexTable
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge pull request #5098 from JakubOnderka/patch-19. [Alexandre
  Dulaunoy]

  fix: [UI] Fix typo in community view
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into decaying. [mokaddem]
- Merge pull request #5032 from mokaddem/decaying. [Andras Iklody]

  Decaying Models
- Merge branch '2.4' of github.com:MISP/MISP into decaying. [mokaddem]
- Merge pull request #5148 from JakubOnderka/composer-simplify. [Andras
  Iklody]

  chg: [internal] Simplify installation with composer
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge remote-tracking branch 'origin/2.4' into decaying. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into decaying. [mokaddem]
- Merge remote-tracking branch 'origin/2.4' into decaying. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into decaying. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into decaying. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into decaying. [mokaddem]
- Merge remote-tracking branch 'origin/2.4' into decaying. [mokaddem]
- Merge remote-tracking branch 'origin/2.4' into decaying. [mokaddem]
- Merge remote-tracking branch 'origin/2.4' into decaying. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into decaying. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into decaying. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into decaying. [mokaddem]
- Merge remote-tracking branch 'origin/2.4' into decaying. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into decaying. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into decaying. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into decaying. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into decaying. [mokaddem]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5106 from JakubOnderka/composer-requirements.
  [Andras Iklody]

  chg: Put require PHP version and extension into composer.json
- Merge branch '2.4' into composer-requirements. [Jakub Onderka]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5132 from JakubOnderka/patch-27. [Andras Iklody]

  fix: [feed] When fetching feeds, accept also text/plain in HTTP
- Merge pull request #5121 from JakubOnderka/remove-netgeoip. [Andras
  Iklody]

  chg: Remove not used Net_GeoIP submodule
- Merge branch '2.4' into remove-netgeoip. [Andras Iklody]
- Merge pull request #5125 from JakubOnderka/patch-25. [Andras Iklody]

  fix: Require exact monolog version 1.24
- Merge pull request #5129 from JakubOnderka/array-copy-remove. [Andras
  Iklody]

  chg: [users] Remove unused method UsersController::arrayCopy
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5128 from JakubOnderka/patch-26. [Andras Iklody]

  fix: [audit] Correct title in audit log when admin edit user
- Add: [stix import] Importing Galaxies supported during stix export.
  [chrisr3d]
- Add: [stix export] Exporting Branded Vulnerability galaxies.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Add: [stix import] Importing attack pattern galaxies. [chrisr3d]
- Wip: [stix import] Functions to import attack pattern, vulnerability &
  weakness objects. [chrisr3d]

  - Functions to parse galaxies to come soon
- Add: [stix import] Getting IDs of threat actors, courses of action and
  ttps related to the incident. [chrisr3d]

  - Will be usefull to separate threat actors, courses
    of action and ttps that are related to incidents
    and will be imported as galaxies, form the ones
    not related that will be imported as attributes
    or objects


v2.4.115 (2019-09-09)
---------------------

Changes
~~~~~~~
- [version] bump. [iglocska]
- Install crypt_gpg by composer. [Jakub Onderka]
- Allow to load Crypt_GPG from composer. [Jakub Onderka]
- [user] Remove unused private method. [Jakub Onderka]
- [user] Use machine readable format for fetching PGP keys. [Jakub
  Onderka]
- [feed] Error handling for saveFreetextFeedData. [Jakub Onderka]
- [feed] Handle exceptions for ServerShell::enqueueFeedCache. [Jakub
  Onderka]
- [feed] Throw exception if feed filter rules is not valid JSON. [Jakub
  Onderka]
- [feed] Better error handling for cacheFeedInitiator method. [Jakub
  Onderka]
- [feed] More accurate progress logging for downloadFromFeed. [Jakub
  Onderka]
- [feed] Better exception logging. [Jakub Onderka]
- [feed] New method Feed::jobProgress. [Jakub Onderka]
- [feed] New private method Feed::isFeedLocal. [Jakub Onderka]
- [feed] Use Feed::feedGetUri in Feed::getFreetextFeed. [Jakub Onderka]
- [feed] Feed::getNewEventUuids always return array with 'add' and
  'edit' fields. [Jakub Onderka]
- [feed] Proper error handling for fetching feed cache. [Jakub Onderka]
- [feed] New method Feed::feedGetUri to deduplicate code. [Jakub
  Onderka]
- [feed] Proper error handling for fetching feed events. [Jakub Onderka]
- [feed] Deduplicate preparing filter rules. [Jakub Onderka]
- [feed] Proper error handling for fetching freetext feed. [Jakub
  Onderka]
- [feed] Follow redirects by internal HttpSocket functionality. [Jakub
  Onderka]
- [feed] Proper error handling for fetching feed manifest. [Jakub
  Onderka]
- [stix2] Bumped latest STIX2 python library changes. [chrisr3d]

Fix
~~~
- [UI] Removed duplicate button title in userIndexTable.ctp. [Jakub
  Onderka]
- Throw exception when GnuGP homedir is not set. [Jakub Onderka]
- [UI] GPG keys are fetched from CIRCL keyserver. [Jakub Onderka]
- [UI] Fetching GPG keys. [Jakub Onderka]

  This error was introduced in 600e54051694ca4d479a9e2c82db45fe19a46a6c
- [stix2 import] Fixed hash patterns import for external STIX files.
  [chrisr3d]
- [security] Fix to a vulnerability related to the server index.
  [iglocska]

  - along with various support tools
  - more information coming soon
- [internal] orgs restricted to a domain displayed incorrectly.
  [iglocska]

  - afterfind messes up the keys by reusing the same var for an inner loop
- [feed] Fetching event manifest. [Jakub Onderka]
- [sync] Fixed major performance blocker. [iglocska]

  - fix based on the insights of @RichieB2B, the hero we need, not the one we deserve
  - added orgc_uuid to the minimal event index
  - added handlers for it on the pull side
  - when pulling from old instances the new functionality is skipped, resulting in the behaviour we had pre-patch
  - both sides of the sync are encouraged to update, especially if the slow pulls are causing issues
- [feed] Use own solution how to redirect when fetching feeds. [Jakub
  Onderka]
- [feed] shell_exec don't throw Exception. [Jakub Onderka]
- [UI] Remove rest of unused code. [Jakub Onderka]

  Inner code was removed in 3f03ceb22974352648e5163ee4b19eb94bc21106
- [server] on-demand action does not redirect to the updateProgress page
  anywmore. [mokaddem]
- [stix2 import] Dealing with the case of named pipe attribute being
  imported from custom object. [chrisr3d]
- [stix2 export] Avoid fails with named pipe export as custom object.
  [chrisr3d]
- [export] Add a proper filename to the event restsearch API's output to
  make downloading events a bit more convenient, fixes #4905. [iglocska]
- [authentication] prepend the baseurl to the login/logout redirects -
  fixes #3871. [iglocska]

Other
~~~~~
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5119 from JakubOnderka/patch-24. [Sami Mokaddem]

  fix: [UI] Removed duplicate button title in userIndexTable.ctp
- Merge pull request #5120 from JakubOnderka/gpg-composer. [Andras
  Iklody]

  Install Crypt_GPG by composer
- Merge pull request #5103 from JakubOnderka/circl-key-server-
  description. [Alexandre Dulaunoy]

  fix: [UI] GPG keys are fetched from CIRCL keyserver
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge pull request #5117 from JakubOnderka/patch-23. [Andras Iklody]

  fix: [UI] Fetching GPG keys
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5116 from JakubOnderka/patch-22. [Andras Iklody]

  chg: [user] Remove unused private method
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5115 from RichieB2B/ncsc-nl/speedup-pull. [Andras
  Iklody]

  Speedup pull
- Log reason for event download failure. [Richard van den Berg]
- Log all errors from server pull. [Richard van den Berg]
- Loose a find when adding existing event. [Richard van den Berg]
- Merge pull request #5112 from JakubOnderka/fix-feed-get-manifest.
  [Andras Iklody]

  fix: [feed] Fetching event manifest
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge pull request #5101 from JakubOnderka/patch-20. [Andras Iklody]

  chg: [user] Use machine readable format for fetching PGP keys
- Merge pull request #5052 from JakubOnderka/error-handling. [Andras
  Iklody]

  Better error handling for fetching feeds
- Merge pull request #5102 from JakubOnderka/patch-21. [Andras Iklody]

  fix: [UI] Remove rest of unused code
- Add: [stix import] Importing pipe objects as named pipe attribute.
  [chrisr3d]
- Add: [stix export] Exporting named pipe attributes. [chrisr3d]
- Merge pull request #5084 from RichieB2B/patch-6. [Andras Iklody]

  Fix Declaration of RestResponseComponent warning
- Fix Declaration of RestResponseComponent warning. [Richie B2B]


v2.4.114 (2019-08-30)
---------------------

New
~~~
- [API] Added event delegations to the list of API enabled functions.
  [iglocska]

  - last minute feature creep
- [requestAccess] Made the requestAccess endpoint more API friendly and
  some UI improvements. [iglocska]

  - better handling of empty parameters
  - added the mock functionality to both API and UI, this will generate the e-mail to be sent and return it with no actual sending happening
  - defaulting to mock if emailing is disabled
  - fixed some minor bugs
- [communities] Added version and did some cleanup on the e-mail sent in
  a request. [iglocska]
- [communities] Descriptions added to the request form along with the
  anonymise checkbox. [iglocska]
- [communities] Include information about the server used to issue the
  request. [iglocska]
- [community] Added the first revision of the community metadata.
  [iglocska]
- [communities] Added support for requesting access for known
  communities. [iglocska]

  - site admins can list the misp-project maintained community list
  - request access to any of the communities
- [Internal] Index generator refactor. [iglocska]

  - loads of new features added
  - bunch of helpers updated
  - mainly a back/forward port from the frozen feed-rework branch with some custom changes
- [delegations] Added delegation index, fixes #5023. [iglocska]

  /event_delegations/index

  accepts context as a parameter with the following possible values:
  - pending: all delegations awaiting my organisation's review (default)
  - issued: all delegations issued by my organisation

  parameters can be passed via key:value parameters or via json objects
- [diagnostics] Added SQL table size tool. [iglocska]

  - along with various other small fixes
  - increased recommended memory size additionally

Changes
~~~~~~~
- [VERSION] bump. [iglocska]
- [PyMISP] Bump for release, take 2. [Raphaël Vinot]
- [PyMISP] Bump for release. [Raphaël Vinot]
- Enable debug. [Raphaël Vinot]
- [PyMISP] Bump for Communities. [Raphaël Vinot]
- [misp-objects] relationships updated. [Alexandre Dulaunoy]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [feed] Name variables after explore in Feed::attachFeedCorrelations.
  [Jakub Onderka]
- [feed] Compute Redis cache key prefix just once. [Jakub Onderka]
- [feed] Fetch sources just when there is correlation. [Jakub Onderka]
- [feed] Compute composite types just once. [Jakub Onderka]
- [communities] Change keys (name, uuid, type) [Raphaël Vinot]
- [field rename] Renamed all community fields with redundancy to
  something more simple (community_uuid -> uuid, etc) [iglocska]
- [PyMISP] Bump for communities. [Raphaël Vinot]
- [restresponse] Added tooltips to the translatable strings, added
  communities/requestAccess. [iglocska]
- [API] communities/requestAccess made more API friendly. [iglocska]

  - defaults set automatically if not set
  - tied into self-describe API on GET
  - fixed the attached PGP key to be the one supplied if it deviates from the user's key
- [cleanup] empty lines removed. [iglocska]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- No need to encapsulate data in API request. [Pierre-Jean Grenier]
- [PyMISP] Bump tests for Travis. [Raphaël Vinot]
- [ACL] Added new community functions to the ACL component. [iglocska]
- [travis] PyMISP bump. [Raphaël Vinot]
- [PyMISP] Bump tests for Travis. [Raphaël Vinot]
- [Tests] Bump PyMISP. [Raphaël Vinot]
- Bump PyMISP. [Raphaël Vinot]
- Delegate to org by UUID. [Pierre-Jean Grenier]
- [doc] MISP works on the latest 18.04.3 ISO, just sayin' (#5051) [Steve
  Clement]

  chg: [doc] MISP works on the latest 18.04.3 ISO, just sayin'
- [doc] MISP works on the latest 18.04.3 ISO, just sayin' [Steve
  Clement]
- [taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [tools] Updated installer to consider the memory_limit change. [Steve
  Clement]
- [doc] Updated: memory_limit=512M -> memory_limit=2048M (#5038) [Steve
  Clement]

  chg: [doc] Updated: memory_limit=512M -> memory_limit=2048M
- [doc] Updated: memory_limit=512M -> memory_limit=2048M. [Steve
  Clement]
- [doc] Updated composer hash (#5037) [Steve Clement]

  chg: [doc] Updated composer hash
- [doc] Updated composer hash. [Steve Clement]
- [updateProgress] Added sidebar (and sidebar link) [mokaddem]
- Show descriptions in import modules. [Pierre-Jean Grenier]
- /events/contact/{event_id} can now be properly called from API.
  [Pierre-Jean Grenier]
- [warning-list] Use different algorithm for IPv4 CIDR comparsion.
  [Jakub Onderka]
- [warning-list] Filter CIDR warning list before eval. [Jakub Onderka]
- Setting the 'Tag' key when editing a tag through API is not mandatory
  (consistency) [Pierre-Jean Grenier]
- [PyMISP] Bump, changes with sightings. [Raphaël Vinot]
- [warninglist] Do not check twice if key in cache exists. [Jakub
  Onderka]
- [cache] Do not check if class exists when cache is already connected.
  [Jakub Onderka]
- Return the sighting when adding one through REST API. [Pierre-Jean
  Grenier]
- [UI] Some more username helper changes. [iglocska]
- [UI] Small change to the user name helper. [iglocska]
- [PyMISP] Bump tests for Travis. [Raphaël Vinot]
- Do not log ForbiddenException by default. [Jakub Onderka]

  This exception is thrown when not logged access `users/checkIfLoggedIn.json`

Fix
~~~
- [API] Messages fixed for event delegations. [iglocska]
- [API] event delegation inverted invalid IF branch. [iglocska]
- [internal] return true from the external email sender if no mocking is
  happening instead of the full email. [iglocska]
- [API] Set gpgkey to '' instead of array() if user has no pgp key set.
  [iglocska]
- [feed] Remove unused variables. [Jakub Onderka]
- [ui] Missing space and dot at export page. [Jakub Onderka]
- [invalid link] fixed. [iglocska]
- [API] Added gpgkey as a valid parameter for requestAccess in the API
  description. [iglocska]
- [UI] Fixed the annoying link underlines under action buttons.
  [iglocska]
- More issues with PostgreSQL. [Bechkalo Evgeny]

  - fixed error during update Job date_modified field (SQLSTATE[22008]:
  Datetime field overflow: 7 ERROR:  date/time field value out of range)
  - fixed error during fetching events while updating from feeds (
  SQLSTATE[42P01]: Undefined table: 7 ERROR: missing FROM-clause entry for
  table events)
  - fixed Feed edit view with wrong boolean forms (combobox instead
  checkbox)
- [invalid url] fixed. [iglocska]
- [communtiies] Added correct responses to the community request
  interface. [iglocska]
- [menu] Added community index to the top menu. [iglocska]
- SQL-error during obtaining dbSpaceUsage. [Bechkalo Evgeny]

  Fixed SQL-error in PostgreSQL for viewing Diagnostics Page
  Added check for datasource, added PostgreSQL handling (without
  reclaimable memory).
- Contact reporter via API. [Pierre-Jean Grenier]
- [ui] Show proper error message for ForbiddenException again. [Jakub
  Onderka]
- [appController] Fixed updateProgress redirection link. Fix #5068.
  [mokaddem]
- [cleanup] removed unused functions. [iglocska]
- [API] Fixed output of the attribute histogram. [iglocska]

  - no more STIX-ish barf inducing numeric string keys for dictionaries
- Fix 'contain' param in app/Model/Attribute.php:fetchAttributes()
  [Pierre-Jean Grenier]

  When we specified eg. 'contain': array('Event'), the merge done by the function was incorrect, and only kept more restrictive stuff,
  while we wanted to get all the keys related to the Event.
- Default to 0 when no distribution is specified. [Pierre-Jean Grenier]

  The current behavior conducted to set distribution to -1 in the returned json, and raise an 'Undefined index' notice
- [ACL] allow users to see delegations. [iglocska]
- [contact reporter] Rules somewhat relaxed. [iglocska]
- [UI] Correct class name in View/Elements/Feeds/View/row_attribute.ctp.
  [Jakub Onderka]
- [feed] Preview feed event don't have id. [Jakub Onderka]
- [feed] Prevent MITM for feeds that support HTTPS. [Jakub Onderka]
- [ui] Link to REST client at Automation page. [Jakub Onderka]
- [UI] Info message should not be error. [Jakub Onderka]
- [contact reporter] Various fixes, fixes #5040. [iglocska]

  - don't offer contacting a reporter of an event that doesn't have users on the platform
  - fixes to various bugs that broke this feature in the first place
  - Massive potential performance blocker removed from contacting individual reporters
- [UI] Multi select on the event index fixed, fixes #5047. [iglocska]
- [UI] Multi select and deletion of events fixed, #5046. [iglocska]
- [Tags] Correctly records `numerical_value` when enabling a taxonomy
  for the first time. [mokaddem]
- [ui] Show proper error message for ForbiddenException. [Jakub Onderka]
- [object:merge] Fix #5041, Duplicated value gets unique UUID and
  relaxed javascript equality check. [mokaddem]
- [updateProgress] Usage of correct FontAwesome class. [mokaddem]
- [sightings] Remove unused method. [Jakub Onderka]
- [organisations] Trim the domain restrictions both on load and on save,
  fixes #5034. [iglocska]
- [admin] Invalid domain restriction check for site admins, fixes #5035.
  [iglocska]
- Fix messages when we try to delete an attribute. [Pierre-Jean Grenier]
- [API] Made delegateEvent API friendly, fixes #5026. [iglocska]
- [API] delegate events by UUID, fixes #5024. [iglocska]
- Replace not exists MethodNotFoundException with NotFoundException.
  [Jakub Onderka]
- [tests] Some changes were not commited. [Raphaël Vinot]
- [UI] Fixed tag buttons not being in-line on the event view's attribute
  list. [iglocska]
- [warninglist] Entries cache is properly deleted. [Jakub Onderka]
- Import modules using 'misp_standard' format can be called via REST
  API. [Pierre-Jean Grenier]
- [ACL] Fixed read only users not being able to list the sightings,
  fixes #5022. [iglocska]

Other
~~~~~
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Raphaël Vinot]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5017 from JakubOnderka/feed-optimisations. [Andras
  Iklody]

  Feed correlations optimisations
- Merge pull request #5044 from JakubOnderka/patch-9. [Andras Iklody]

  fix: [ui] Missing space and dot at export page
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5083 from 4ekin/fix-postgresql-issues. [Andras
  Iklody]

  fix: more issues with PostgreSQL
- Merge pull request #5081 from StefanKelm/2.4. [Andras Iklody]

  Update index.ctp
- Update index.ctp. [StefanKelm]

  Tiny typos
- Merge branch 'feature/communities' into 2.4. [iglocska]
- Merge branch '2.4' into feature/communities. [iglocska]
- Merge pull request #5072 from 4ekin/fix-postgresql-issues. [Andras
  Iklody]

  fix: SQL-error during obtaining dbSpaceUsage
- Merge pull request #5079 from zaphodef/fix/contact_event_api. [Andras
  Iklody]

  fix: contact reporter via API
- Merge pull request #5073 from JakubOnderka/patch-16. [Andras Iklody]

  fix: [ui] Show proper error message for ForbiddenException again
- Merge pull request #5066 from zaphodef/feature/encapsulation_api.
  [Andras Iklody]

  chg: No need to encapsulate data in API request
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Raphaël Vinot]
- Merge pull request #5063 from zaphodef/fix/contain_fetchAttributes.
  [Andras Iklody]

  fix: Fix 'contain' param in app/Model/Attribute.php:fetchAttributes()
- Merge pull request #5062 from zaphodef/fix/undefined_distribution.
  [Andras Iklody]

  fix: Default to 0 when no distribution is specified
- Chd: [travis] Check date. [Raphaël Vinot]
- Merge pull request #5061 from
  zaphodef/feature/delegate_to_org_by_uuid. [Andras Iklody]

  chg: Delegate to org by UUID
- Merge pull request #5059 from tk-hendrik/2.4_small_cssfix. [Andras
  Iklody]

  attributeTagContainer wrapping
- AttributeTagContainer wrapping. [Hendrik]

  This change ensures that the attribute table won't explode in width if
  one uses more tags on an attribute.
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5054 from JakubOnderka/patch-15. [Andras Iklody]

  fix: [UI] Correct class name in View/Elements/Feeds/View/row_attribute.ctp
- Merge pull request #5053 from JakubOnderka/patch-14. [Andras Iklody]

  fix: [feed] Preview feed event don't have id
- Merge pull request #5050 from JakubOnderka/patch-13. [Alexandre
  Dulaunoy]

  fix: [feed] Prevent MITM for feeds that support HTTPS
- Merge pull request #5048 from JakubOnderka/patch-11. [Alexandre
  Dulaunoy]

  fix: [ui] Link to REST client at Automation page
- Merge pull request #5049 from JakubOnderka/patch-12. [Alexandre
  Dulaunoy]

  fix: [UI] Info message should not be error
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5043 from JakubOnderka/patch-8. [Andras Iklody]

  fix: [ui] Show proper error message for ForbiddenException
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge pull request #5042 from StefanKelm/2.4. [Andras Iklody]

  Tiny typos
- Update default.pot. [StefanKelm]

  tiny typo
- Update add.ctp. [StefanKelm]

  tiny typo
- Merge pull request #5039 from SteveClement/tools. [Steve Clement]

  chg: [tools] Updated installer to consider the memory_limit change
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5005 from JakubOnderka/remove-toplist. [Andras
  Iklody]

  fix: [sightings] Remove unused method
- Merge pull request #5033 from
  zaphodef/feature/import_module_description. [Andras Iklody]

  chg: Show descriptions in import modules
- Wrap description in a h() [Pierre-Jean Grenier]
- Merge pull request #5036 from zaphodef/feature/events_contact_api.
  [Andras Iklody]

  chg: /events/contact/{event_id} can now be properly called from API
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5014 from JakubOnderka/filter-cidr. [Andras
  Iklody]

  Much faster IPv4 warninglists
- Merge pull request #5031 from zaphodef/feature/tag_edit_json. [Andras
  Iklody]

  chg: Setting the 'Tag' key when editing a tag through API is not mand…
- Merge pull request #5030 from
  zaphodef/feature/delete_attribute_messages. [Andras Iklody]

  duh, fix a typo
- Duh, fix a typo. [Pierre-Jean Grenier]
- Merge pull request #5029 from
  zaphodef/feature/delete_attribute_messages. [Andras Iklody]

  fix: Fix messages when we try to delete an attribute
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5006 from JakubOnderka/not-found-exception.
  [Andras Iklody]

  fix: Replace not exists MethodNotFoundException with NotFoundException
- Merge pull request #5015 from JakubOnderka/redis-optimisations.
  [Andras Iklody]

  Redis optimisations
- Merge pull request #5021 from
  zaphodef/feature/return_sighting_add_rest. [Andras Iklody]

  chg: Return the sighting when adding one through REST API
- Merge pull request #5020 from zaphodef/rest_import_module. [Andras
  Iklody]

  fix: Import modules using 'misp_standard' format can be called via RE…
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5010 from JakubOnderka/patch-7. [Andras Iklody]

  chg: Do not log ForbiddenException by default


v2.4.113 (2019-08-16)
---------------------

New
~~~
- [API] get a single server setting via
  /servers/getSetting/[setting_name], fixes #4964. [iglocska]
- [API] Allow posting freetext data for ingestion via the event uuid
  instead of ID, fixes #4995. [iglocska]
- [internal / API] new component added to handle repeatable code across
  all controllers (toolbox controller) [iglocska]

  - added UUID -> ID lookup function and integrated it across several functions
  - fixes #4990
  - fixes #4999
  - fixes #4993
  - fixes #4991
  - fixes #4989
  - fixes #4987
- [session handling] Session handling fixes. [iglocska]

  - changed the cookie name to MISP-[MISP.uuid] to rely on a unique data-point instead of the URL. This solves issues with multiple MISPs running on the same host via port based virtualhosts sharing sessions
  - timeout issues potentially fixed when using the recommended PHP session handler. If the garbage collection is configured in php.ini it could previously purge sessions that based on the session timeout should still be valid
- [sync] Added a protection from receiving empty published events from
  other instances. [iglocska]

  - a temporary solution to some older, bugged instances emitting them
- [debug] Added an on-demand sync debug to assist some debug sessions.
  [iglocska]

  - very primitives, simply concatenates events to be pushed into a file
- Reminder to run gen_misp_types_categories when model changes.
  [Christophe Vandeplas]
- [API] Attribute add rework - WIP. [iglocska]

  - handle attribute creation in a unified manner via captureAttributes
- [internal] Default field list added for attributes. [iglocska]

  - let's try to standardised on things we output instead of doing it manually. It's a first step

Changes
~~~~~~~
- [version] bump. [iglocska]
- [PyMISP] Bump version. [Raphaël Vinot]
- [Travis] Use default python3 version on the image (3.6+), fix perms
  on. [Raphaël Vinot]
- [Travis] Set strict mode on MariaDB. [Raphaël Vinot]
- [Travis] Initial fix. [Raphaël Vinot]
- Show sharing groups' uuids. [Pierre-Jean Grenier]
- Delete an object by its uuid, similar syntax to attribute's deletion.
  [Pierre-Jean Grenier]
- [stix test] Updated STIX1 test files with the updated MISP event files
  export results. [chrisr3d]
- [stix test] Updated MISP event test files with the latest objects
  supported. [chrisr3d]
- [logging] Truncate description lengths that would be longer than what
  the DB can store with the default setup. [iglocska]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [stix export] Change on leveraged ttp at incident level. [chrisr3d]

  - No longer referencing ttps created out of MISP
    objects as leveraged ttps at incident level
  - Making sure all ttps, course of actions, threat
    actors and so on created from MISP galaxies are
    referenced at incident level
- [stix export] Handling vulnerability attributes the same way as
  objects. [chrisr3d]

  - Fixing at the same time some references (with
    vulnerability objects related to vulnerability
    attributes) that were lost
- Modules can now pre-check a checkbox from userConfig. [Pierre-Jean
  Grenier]
- [warning-list] Filter CIDR warning list before eval. [Jakub Onderka]
- [stix export] Keeping references between ttps. [chrisr3d]

  - Keeping references between ttps coming from MISP
    objects that have references between each others
- [indentation] small fix. [iglocska]
- [PyMISP] Bump repo. [Raphaël Vinot]
- [CLI] server shell -> push now allows passing the event ID to push.
  [iglocska]

  - also, changed tabs to spaces
- Bump pymisp. [Raphaël Vinot]
- [pymisp] enable more tests. [Raphaël Vinot]
- [internal] Potential fix for a race condition generating orphaned
  attributes, fixes #4886. [iglocska]

  - This fix will avoid issues where the delay is introduced by the deferred start of the execution via the background workers
  - deleting an event whilst data is being actively added will still not be interrupted
- [stix2 export] Exporting labels with the Attack Pattern object.
  [chrisr3d]
- Bump PyMISP. [Raphaël Vinot]
- [types] email-subject added as a valid type for network activity.
  [iglocska]

  - used to describe outgoing e-mail subjects for exfiltration. Perhaps consider adding a new category for exfiltration altogether.
- Bump Pymisp again. [Raphaël Vinot]
- [API] servers/serverSettingsEdit now accepts the force parameter in a
  posted JSON object. [iglocska]

Fix
~~~
- [PyMISP] Bump, missing change. [Raphaël Vinot]
- [internal] Feed lookup by UUID removed as feeds don't actually have
  UUIDs, fixes #4998. [iglocska]
- [ToolboxComponent] fixed model name lookup by moving to Model->alias
  over Model->name, fixes #5003. [iglocska]
- [internal] Breaking bug with the feed edit fixed. [iglocska]
- [API] invalid object reference fixed in objects/view, fixes #5003.
  [iglocska]

  - the Copy Pasta God(tm) strikes again
- [API] get organisation by uuid for sightings/listSightings, fixes
  #4992. [iglocska]
- [API] Misp object delete's uuid lookup fixed. [iglocska]
- [API] removed testing exception. [iglocska]
- [API] Swapped error messages' content from "don't" to "do not" to
  avoid weird sanitisation artifacts coming from the exception handler.
  [iglocska]
- [API] error message. [iglocska]
- [API] Attribute edit fixed. [iglocska]
- Fix error messages. [Pierre-Jean Grenier]
- [API] /galaxies/view by uuid added, fixes #4993. [iglocska]
- [API] sightings restSearch now accepts uuids as org_id, fixes #4992.
  [iglocska]
- [API] Delete sightings by UUID, fixes #4987. [iglocska]
- [API] /objects/view should accept UUID as a parameter instead of just
  ID, fixes #4991. [iglocska]
- [API] Delete organisations by UUID, fixes #4989. [iglocska]
- [API] Access event proposals by uuid via
  shadow_attributes/index/[uuid], fixes #4988. [iglocska]
- [API] Adding an event without the info field set should never work,
  fixes #4984. [iglocska]
- [sharing groups] Fix the behaviour of roaming mode sharing groups,
  fixes #4983. [iglocska]

  - creating sharing groups without roaming mode and without any sharing group servers should automatically add the own server
  - adapt the new roaming mode behaviour from a few months ago on push: No explicit roaming mode set means no push, even if no servers are added
- [Sharing groups] Various fixes to align the reported local instance
  URL as the external_baseurl if set, as opposed to always using the
  baseurl, fixes #4982. [iglocska]
- [stix export] Dealing with course of action and threat actor objects
  the same way as for ttps. [chrisr3d]
- [sync] Sync object builder tool fixed. [iglocska]

  - was picking the wrong org as the owner of the remote side
- [warning-list] Split value just if type is malware-sample or contains
  `|` char. [Jakub Onderka]
- [stix export] No longer referencing all ttps from galaxies for each
  indicator. [chrisr3d]

  - Will save it later for galaxies at attribute level
- [stix export] Dealing with threat actors from attributes. [chrisr3d]

  - Using the recently added functions
- [API] /events/delete now accepts UUID as parameter. [iglocska]
- [stix export] Reusing uuid variable already defined. [chrisr3d]
- [sessions] Several minor fixes to the session handling. [iglocska]

  - cookieTimeout setting fixed
  - moved the session massaging into a separate function
  - added some translation calls for some of the setting errors involved
- [sync] Fixed an invalid massaging of object attributes before a sync.
  [iglocska]

  - on a push, object attributes were not correctly filtered out based on distribution settings
- [enrichment] Handling correctly comments at objects level. [chrisr3d]

  - Objects level comments were displayed but not
    handled at the end, they are now displayed,
    users can modify them as comments at attributes
    level, and they are handled then with the saved
    results
- [stix export] STIX objects id standardization. [chrisr3d]
- [internal] Double lookup during the pull resolved. [iglocska]
- [tools] Fixes gen types categories script. [Christophe Vandeplas]
- [stix export] Replaced try statements with if conditions for more
  readability. [chrisr3d]

  - It is better we are aware something fails
    unexpectedly instead of being caught by a try
    catch statement
- [stix export] Dictionary name typo. [chrisr3d]
- [stix export] Better tags handling. [chrisr3d]

  - Avoid passing event level tags everywhere
  - Using class variable for the tlp markings
- [stix export] Avoiding creation of some objects before we are sure
  they will be used. [chrisr3d]
- [API] /servers/restartWorkers response fixed for API users, fixes
  #4966. [iglocska]
- [API] Further fixes to /attributes/add. [iglocska]
- [API] Fixes to the new attribute add. [iglocska]
- [API] fixed an incorrect fix to the object references add function
  from earlier today, fixes #4866. [iglocska]
- [API] Posting on taxonomies/update returns an exception if taxonomies
  have no numerical_value set, fixes #4899. [iglocska]
- [API] the returned data when adding object references doesn't include
  the object_uuid, fixes #4866. [iglocska]
- [UI] Empty objects threw a notice on the event view. [iglocska]
- [API] Consistency in returned attribute fields when modifying it.
  [iglocska]
- [UI] tag index invalid tag name copy fixed. [iglocska]
- [API] Object edit clusterfudge fixed. [iglocska]
- [objects] Fix various issues with objects/edit. [iglocska]

  - value1 and value2 should not be included in the repsonse, fixes #4944
  - fixed input being misunderstood in certain situations
- [UI] Handle settings being removed from config.php more gracefully in
  the UI. [iglocska]
- [UI] Row description in View Warninglists. [Jakub Onderka]
- [PyMISP] Test cases are working again. [Raphaël Vinot]
- [UI] Event index tag display default setting fixed. [iglocska]

  - Resolving the fix that really wasn't...
- [internal] testBoolFalse logic error fixed. [iglocska]

Other
~~~~~
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Raphaël Vinot]
- Revert "chg: [warning-list] Filter CIDR warning list before eval"
  [iglocska]

  This reverts commit 20632d5e1027d2a6dfc66639ac384e5761988e18.
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #5001 from zaphodef/feature/uuid_sharing_group.
  [Andras Iklody]

  chg: Show sharing groups' uuids
- Revert "Revert "fix: Fix error messages"" [iglocska]

  This reverts commit a12ea04a4caab6be2593d13ead56187b775e336d.
- Revert "fix: Fix error messages" [iglocska]

  This reverts commit d501c56e5fec7f69aa0a17a3bb0c8a0cf97b4e69.
- Merge pull request #5000 from zaphodef/bad_permissions. [Andras
  Iklody]

  fix: Fix error messages
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4986 from zaphodef/delete_object_by_uuid. [Andras
  Iklody]

  chg: delete an object by its uuid, similar syntax to attribute's dele…
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4980 from JakubOnderka/patch-6. [Alexandre
  Dulaunoy]

  [fix] Remove double `:`
- [fix] Remove double `:` [Jakub Onderka]
- Merge pull request #4981 from StefanKelm/2.4. [Alexandre Dulaunoy]

  Replace http with https
- Replace http with https. [StefanKelm]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Add: [stix export] Updated STIX header with the course of action
  header. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Add: [stix export] Exporting course-of-action objects. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4971 from JakubOnderka/patch-5. [Andras Iklody]

  fix: [warning-list] Split value just if type is malware-sample or contains `|` char
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Add: [stix export] Mapping some galaxies to STIX objects. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4972 from zaphodef/import_module. [Andras Iklody]

  chg: modules can now pre-check a checkbox from userConfig
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge pull request #4965 from JakubOnderka/patch-4. [Andras Iklody]

  chg: [warning-list] Filter CIDR warning list before eval
- Merge pull request #4969 from obert01/fix-matrix-accessibility.
  [Andras Iklody]

  Improved the accessibility of the galaxy matrix view.
- Improved the accessibility of the galaxy matrix view for screen
  readers. The table elements are now focusable, and only a short text
  is brailled/spoken by default. [Olivier BERT]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Add: [stix export] Exporting attack-pattern, vulnerability & weakness
  objects. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Raphaël Vinot]
- Merge branch 'feature/attribute_add_rework' into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Add: [stix2 export] Exporting Attack Pattern objects. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4955 from JakubOnderka/patch-3. [Andras Iklody]

  fix: [UI] Row description in View Warninglists


v2.4.112 (2019-08-02)
---------------------

New
~~~
- [sync] Event index cleaned up, total count of listd events added as
  X-Result-Count header. [iglocska]
- [sync] Previewing a remote instance now passes pagination rules in the
  request instead of fetching the full data-set and paginating in
  memory. [iglocska]

  - fixes issues with empty preview pages
  - massive performance boost
  - requires the remote side to be the same version or newer
- [API] new parameters added to attributes/restSearch to include
  additional context, fixes #4935, fixes #4940, affects MISP/PyMISP#415.
  [iglocska]

  - includeSightings: include sightings for all attributes returned
  - includeCorrelations: include the correlations to other attributes (includes a light-weight event object with each attribute)
- [CLI] Added cleanCaches command. [iglocska]
- [API] Disable background processing on-demand via URL parameters.
  [iglocska]
- [setting] Disable DB logging completely, fixes #4921. [iglocska]

  - Not recommended, but for certain use-cases it might be desirable
- [API] Some more context for includeContext, fixes #4935. [iglocska]
- [API] includeContext now includes the additional event fields in the
  attributes/restSearch results (in JSON format) [iglocska]
- [API] Allow adding tags via /attributes/add directly. [iglocska]
- [alerting] Block the alerting of events based on the date field as an
  alternative to the timestamp, fixes #4937. [iglocska]

Changes
~~~~~~~
- [pymisp] bumped. [iglocska]
- [version] bump. [iglocska]
- [taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- Use faster algorithm for Warninglist::__ipv6InCidr. [Jakub Onderka]
- [pymisp] Bump. [Raphaël Vinot]
- More efficient Warninglist::__evalCIDR. [Jakub Onderka]
- [View] Setting default link value for vulnerability & weakness.
  [chrisr3d]
- [misp-object] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version + ATT&CK July edition.
  [Alexandre Dulaunoy]
- [UI] Added the new user name helper. [iglocska]
- [UI] Add a quick button for the event attribute toolbar for the
  showing of related tags. [iglocska]

  - therapeutic patch for @neok0
- [pymisp] Bump. [Raphaël Vinot]
- [stix test] Updated the STIX2 test files. [chrisr3d]

  - Including the newest supported objects added in
    the mapping, and the latest fixes for some
    objects previously mapped as custom object and
    now properly supported
- [stix test] Updated the test MISP events. [chrisr3d]

  - Added some of the new objects added recently and
    supported in the mapping
- Server pull/push endpoints allow the passing of the parameters as a
  POSTed JSON in addition to URL parameters, partially fixes #4889.
  [iglocska]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- [restClient] Do not override query body if url hasn't changed.
  [mokaddem]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- [Submodules] Bump Taxonomies and objects. [Raphaël Vinot]
- [PyMISP] Bump. [Raphaël Vinot]
- [PyMISP] Bump. [Raphaël Vinot]
- [PyMISP] Bump. [Raphaël Vinot]
- [travis] Cleanup pymisp install. [Raphaël Vinot]
- [pymisp] Bump it. [Raphaël Vinot]
- [travis] Start workers. [Raphaël Vinot]
- [travis] Delete the event created by curl test. [Raphaël Vinot]
- Bump PyMISP. [Raphaël Vinot]
- [feed-metadata] Panels Tracker feed added. [Alexandre Dulaunoy]
- [PyMISP] Bump to full deprecation warnings. [Raphaël Vinot]
- [genericPicker] Adapt fontAwesome namespace based on the icon.
  [mokaddem]
- [galaxy:view] Added missing titles and translation. [mokaddem]
- Bumped queryversion. [mokaddem]
- [eventGraph:search] Usage of chosen instead of bootstrap with non-
  stripped label. [mokaddem]

Fix
~~~
- [pymisp / querystring] versions bumped. [iglocska]
- [enrichment] Getting objects description from the view. [chrisr3d]
- [enrichment view] Passing description & template information about
  objects. [chrisr3d]
- [UI] enable buttons to add local galaxy clusters for host org users,
  fixes #4925. [iglocska]
- [local tags] Host org non admin users should be able to tag data owned
  by others, partially fixes #4925. [iglocska]
- [API] csv export incorrect handling of include context parameter if it
  was pushed and set to 0. [iglocska]
- [GalaxyCluster] relaxed the matching of cluster names to tags, fixes
  #4154. [iglocska]
- [enrichment] Encrypting attribute data if encrypt field is set.
  [chrisr3d]
- [webroot] Catching encrypt fields from the enrichment view. [chrisr3d]
- [enrichment view] Keeping encrypt field in attributes. [chrisr3d]
- [CSV] headerless flag fixed, fixes #2761. [iglocska]
- [UI] Fix to the related tags not being shown in the UI due to a local
  tag related exception. [iglocska]
- [API] Exception on /sharingGroups/removeOrg fixed, fixes #4884.
  [iglocska]
- [stix import] Fixed observable id fetching. [chrisr3d]

  - Avoid issues with observable composition ids
- [API] /attriutes/index fixed for non admin users. [iglocska]
- [sync] Fixed local tag sync filter events not being synced on a push
  as expected. [iglocska]
- [stix export] Fixed some code + using mapping dictionaries. [chrisr3d]

  - Using another file for mapping dictionaries, as
    we already do for all the other stix scripts
- [stix export] Reordered import list for more clarity. [chrisr3d]

  - Helps finding all the imports since their are in
    alphabetical order, avoiding any miss of STIX or
    Cybox object while adding/updating some
- [API] Freetext import now correctly handles the response of non-
  background processed tasks. [iglocska]
- [rest client] Potential fix to the skip ssl validation flag not
  working on wrong CN name. [iglocska]
- [rest client] Potential fix to the SSL validation skip not working.
  [iglocska]
- [UI] tag style on the index now correctly adheres to the default if
  not set. [iglocska]
- [UI] tags in minimal view can throw notice errors on the event index.
  [iglocska]
- [UI] Notice errors when the local tag on a viewed tag is not set,
  partially fixes #4938. [iglocska]
- Error during creating and deleting Attributes on PostgreSQL. [Bechkalo
  Evgeny]
- MariaDB error for quoting tablename. [Bechkalo Evgeny]
- Some PostgreSQL issues. [Bechkalo Evgeny]

  Closes: #3066, #3067
  Fixes issues:
  - wrong boolean and smallint conversion;
  - postgresql table and field naming (field 1_event_id is wrong name for
  field for example);
  - postgresql grouping (you cannot select columns without grouping them);
  - wrong checkbox rendering without keyword.
- [UI] notice errors thrown by tags in the event view. [iglocska]
- [proposals] POST on shadow_attributes/edit/{attribute_id}
  inconsistent, fixes #4857. [iglocska]
- [API] taxonomy/addTag now correctly responds if queried via the API
  instead of redirecting, fixes #4865. [iglocska]
- [API] sightings/listSightings should also support JSON parameters,
  fixes #4875. [iglocska]
- [API] Organisation edit now also accepts UUID instead of ID via the
  URL param, fixes #4896. [iglocska]
- [API] Fixed an edge case when the attribute historgram throws a notice
  error. [iglocska]

  - no idea how to reproduce it, the organisation referenced in an event orgc_id not existing is a pre-condition

  - fixes #4880
- [API] Adding attributes via the freetext importer using the API
  resulted in several issues. [iglocska]

  - adhereToWarninglists was not correctly adhered to
  - the response didn't reflect what was saved, only what was pushed to be saved (excluding removals by warnintlists, several attributes added by adding more than one valid type, etc)

  fixes #4881
- [sharing groups] Add sharing group returns a list instead of a sharing
  group object, fixes #4882. [iglocska]
- [API] Exception on POST sharingGroups/addOrg, fixes #4884. [iglocska]
- [settings] Fixed the text for the block_old_event_alert_age setting,
  fixes #4909. [iglocska]
- [proposals] shadow_attributes/index default behavior modified to show
  all proposals by default, fixes #4936. [iglocska]
- [proposals] Fixed automatic setting of the category when adding
  proposals, fixes #4868. [iglocska]
- [API] Empty 'restricted to domains' returns string instead of array,
  fixes #4928. [iglocska]
- [UI] Rest client form validation disabled. [iglocska]

  - it was trying to validate using the Server model validation rules, which is obviously incorrect
- [UI] Tags were not shortened correctly on the event index since the
  refactor, fixes #4932. [iglocska]
- [servers] Adding a server now requires the name to be set, partially
  fixes #4889. [iglocska]
- [API] Server deletion now responds correctly via the API. [iglocska]
- [security] Fix to stored XSS. [mokaddem]

  - as reported by David Heise
- Removed unnecessary uuid rewriting in objects. [chrisr3d]

  - uuid is defined when the object is created
- Fixed direction of the relationship between files, PEs and their
  sections. [chrisr3d]

  - The file object includes a PE, and the PE
    includes sections, not the other way round
  - Backward compatibility with the events created
    with 'included-in' at the relationship_type
    between those objects
- Views invalid marker content fixed (#4820) [Steve Clement]

  fix: Views invalid marker content fixed
- Views invalid marker content fixed. [4ekin]

  Views fixed to avoid errors during POT file generating:

  Invalid marker content in
  /var/www/MISP/app/View/Elements/Events/View/related_event.ctp:23
  * __(
  sprintf('This related event contains %s unique
  correlation(s)',h($relatedEventCorrelationCount[$related['id']])))

  Invalid marker content in
  /var/www/MISP/app/View/Elements/Objects/object_similarities.ctp:102
  * __(
  Inflector::humanize($field))

  Invalid marker content in
  /var/www/MISP/app/View/Elements/Objects/object_similarities.ctp:108
  * __(
  Inflector::humanize($field))

  Invalid marker content in
  /var/www/MISP/app/View/Elements/Objects/object_similarities.ctp:126
  * __(
  Inflector::humanize($field))

  Invalid marker content in
  /var/www/MISP/app/View/Elements/Objects/object_similarities.ctp:132
  * __(
  Inflector::humanize($field))
- Load Galaxy mappings for misp2stix2 seperately from Objects. [Tom
  King]
- [travis] STIX modules. [Raphaël Vinot]
- [travis] resque stuff. [Raphaël Vinot]
- [travis] Fix composer things. [Raphaël Vinot]
- [Travis] Update the installation. [Raphaël Vinot]
- [travis] Installation (redis & co) [Raphaël Vinot]
- [event:view] Ensure sync users do not get local tags through ajax.
  [mokaddem]
- [tag_collection:index] Download configuration button is back.
  [mokaddem]
- [massageTag] Fallback on global tag if local parameter not set.
  [mokaddem]

  (Tag collections tags do not contain a local parameter)
- [tag_collection:index] Admin no longer have access to local tag if
  they are disabled. [mokaddem]
- [tag_collection:index] Correctly assign `isAclTagger` [mokaddem]
- [tagCollection:view] Do not show `add LOCAL galaxy` button anymore.
  [mokaddem]
- [tag:local] Allow users (with correct authorization) to detach tags.
  [mokaddem]
- Typo when the validation fails on an object. [Raphaël Vinot]

  Fix #4903
- [Taxnomy:updateTag] Do not throw an error if taxonomy does not contain
  a numerical value. [mokaddem]
- [taxonomy:update] numerical_value gets updated correctly. [mokaddem]
- [travis] Remove legacy tests. [Raphaël Vinot]
- [kali] Kali was not in the support map (#4887) [Steve Clement]

  fix: [kali] Kali was not in the support map
- [kali] Kali was not in the support map. [Steve Clement]
- [galaxy:view] Adapt fontAwesome namespace based on the icon.
  [mokaddem]
- [CLI] Response after a CLI pull threw notice error. [Andras Iklody]

  Proposal pull now returns int instead of a list of proposals, meaning that count($data) was trying to count an int.
- [debug] Remove debug call. [Raphaël Vinot]

Other
~~~~~
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4951 from JakubOnderka/patch-2. [Andras Iklody]

  chg: Use faster algorithm for Warninglist::__ipv6InCidr
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge pull request #4949 from JakubOnderka/patch-1. [Andras Iklody]

  chg: More efficient Warninglist::__evalCIDR
- Merge pull request #4947 from chrisr3d/2.4. [Andras Iklody]

  New attribute type 'weakness'
- Add: [View] Added link to the defined CWE url for weakness attributes.
  [chrisr3d]
- Add: [Config] Added CWE url for the new attribute type. [chrisr3d]
- Add: [Model] New attribute type weakness. [chrisr3d]

  - Describing links linking to the provided CWE lookup
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Add: [stix import] Importing user account object. [chrisr3d]

  - Suppoting UnixUserAccount, UserAccount and
    WindowsUserAccount objects
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Add: [stix framing] Added the latest supported objects to the STIX
  header namespaces. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Add: [stix export] Exporting user-account objects. [chrisr3d]
- Revert "fix: [rest client] Potential fix to the SSL validation skip
  not working" [iglocska]

  This reverts commit 293871cee85522a9bb83fa91ea1ca1017924230b.
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4939 from 8ear/patch-3. [Andras Iklody]

  Update MYSQL.sql
- Update MYSQL.sql. [Max H]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4927 from 4ekin/fix-postgresql-issues. [Andras
  Iklody]

  fix: some PostgreSQL issues
- Slightly modified logroate config which rotates all logs in MIS…
  (#4924) [Steve Clement]

  slightly modified logroate config which rotates all logs in MISP/app/…
- Update misp.logrotate. [Steve Clement]
- Update misp.logrotate. [Steve Clement]
- Slightly modified logroate config which rotates all logs in
  MISP/app/tmp/logs when they reach a 50MB limit, with maximum log size
  set to 500M. rotation is checked every hour. [michael]
- Merge branch 'tomking2-bug/misp2stix2_galaxies' into 2.4. [chrisr3d]
- Merge branch 'bug/misp2stix2_galaxies' of
  git://github.com/tomking2/MISP into tomking2-bug/misp2stix2_galaxies.
  [chrisr3d]
- Merge pull request #4919 from MISP/travis_foo. [Raphaël Vinot]

  Fix travis.
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge pull request #4915 from MISP/localtag-fixes. [Sami Mokaddem]

  Various fixes
- Merge pull request #4904 from MISP/fix_4903. [Andras Iklody]

  fix: Typo when the validation fails on an object
- Merge pull request #4893 from RichieB2B/ncsc-nl/fix-nidsexport.
  [Andras Iklody]

  Fix errors on NIDS export when whitelist is empty
- Fix errors on NIDS export when whitelist is empty. [Richard van den
  Berg]
- Merge pull request #4894 from RichieB2B/ncsc-nl/fix-canpush-error.
  [Andras Iklody]

  Make error clearer when canPush bit is missing
- Make error clearer when canpush bit is missing. [Richard van den Berg]
- Merge pull request #4878 from RichieB2B/ncsc-nl/fix-destroy. [Andras
  Iklody]

  Fix session_destroy errors
- Destroy the CakeSession, not the php one. Fixes #4808. [Richard van
  den Berg]
- Merge pull request #4877 from tom564/patch-2. [Alexandre Dulaunoy]

  Allow SSL verification to be disabled with config
- Allow SSL verification to be disabled with config. [tom564]

  Allow SSL verification to be disabled with config. If I understand this right this will need to be scheduled with a cronjob if the expiration framework is wanted?


v2.4.111 (2019-07-14)
---------------------

New
~~~
- [attribute-type] community-id added. [Alexandre Dulaunoy]

  Community-id is a new attribute type to describe a flow hashing algorithm allowing
  the consumers of output from multiple traffic monitors to link each system's
  flow records more easily.
- [API] Proposal sync rework done. [iglocska]
- [proposal sync rework] WIP. [iglocska]
- [doc] "Hidden" NetBSD install (core works) (#4847) [Steve Clement]

  new: [doc] "Hidden" NetBSD install (core works)
- [doc] Hidden NetBSD install (core works) [Steve Clement]

Changes
~~~~~~~
- [version] bump version 2.4.111. [Alexandre Dulaunoy]
- [version] align PyMISP version with core. [Alexandre Dulaunoy]
- [PyMISP] updated to the latest version. [Alexandre Dulaunoy]
- [error code] Attribute delete now responds with 403 if user is not
  allowed to delete, instead of 405. [iglocska]
- [installer] Updated installer. [Steve Clement]
- [style] This is better. [Steve Clement]
- [installer] Updated to latest. [Steve Clement]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [doc] Minor updates. Only core works for now. [Steve Clement]
- [doc] Various NetBSD updates, global vars makes sure PATH_TO_MISP is
  correct. [Steve Clement]
- [genericPicker] Prevent submission if no item has been picked.
  [mokaddem]

Fix
~~~
- [internal] Explicit conditions to avoid ambiguous lookups. [iglocska]
- [UI] Fixed galaxy add buttons on event index. [iglocska]
- [bug] RestClient notice error fixed. [iglocska]
- [objects] delete now accepts delete HTTP method. [iglocska]
- [install] Do not modify testlive_comprehensive.py (#4864) [Steve
  Clement]

  fix: [install] Do not modify testlive_comprehensive.py
- [install] Do not modify testlive_comprehensive.py. [Raphaël Vinot]
- [hover enrichement] Fixed index in attribute. [chrisr3d]

  - Depending on the format of attribute passed to
    the function
- [utils] Added missing util "sponge" via moreutils (#4861) [Steve
  Clement]

  fix: [utils] Added missing util "sponge" via moreutils
- [utils] Added missing util "sponge" via moreutils. [Steve Clement]
- [proposal] sync fix stage 1. [iglocska]

  - added new capture function
  - reworked the proposal index
- [sync] Proposal pull restricted to 14 days. [iglocska]

  - no need to pull ancient proposals each time
- [api fix] Deletes broken due to invalid boolean. [iglocska]

  - /facepalm
- [API] delete http requests properly accepted by some /delete
  endpoints. [iglocska]
- [galaxy:add] Prevent bug when submitting empty galaxy. [mokaddem]
- [sync] Fixed a bug breaking the sync. [iglocska]

Other
~~~~~
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch 'hotfix/sync_rework' into 2.4. [iglocska]
- Merge branch '2.4' into hotfix/sync_rework. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Add: [stix2 import] Importing external User Account objects.
  [chrisr3d]

  - Reusing parsing functions
- Add: [stix2 import] Importing User Account objects. [chrisr3d]

  - From STIX documents generated with MISP
  - External STIX documents support of User Account
    object to come very soon


v2.4.110 (2019-07-08)
---------------------

New
~~~
- [tags]  Local tags feature added. [iglocska]

  - Create tags locally if you are a host org user that allows in-place tagging for sync / export filtering
  - Events are NOT modified using these tags
  - Local tags always get stripped before syncing
  - Local tags allow host org users to violate the ownership model of MISP
  - galaxies, attack matries also included

  - some sync fixes
- [correlation graph] Toggle physics on/off. [iglocska]

  .,/#&&@@@@@@@@&%(*.
                                                           #@@@@%*..,..,.,,.,,.,.,.,,,,..,*#@@@@(
                                                    .&@@%,,.,,.,,,*#%&&&%#(/**,,**/(%&&&%(/,.......(@@@,
                                                %@@(,,,,,,(&&%*..........  ...*,*..,.........../&,....,%@@,
                                            &@&,,,,,*&&(....  .*....*..//.../../(...*.*(...%..........#&(....*@@/
                                        ,@@,,,.,#......#..#*..(#..(*./,..,...*(...*.,.*..........#/#.....%&,..,/@@.
                                     /@%,,,,(&(.....#/,...#../.(#...,/.,,../,..*(...*...%,.........,*...#./....#&,.,,@@.
                                  .@&,.,,%&....,,....(*,.../.(,..(...,..,..*#..,,..,..,...*,....../#...,..(//.....,&/..,&@.
                                %@,,,,#&...,,/./**....(,,..(,.//..,*..............................,.....././(.,..*...,&/,,,@&
                              @%,,.(&,../(*..(#../#....(*. /....................................../,..*.*..//,,..,/.....,&...%@
                           .@(..,&&,......%,,/..../(..(................................................/(..(.,.*.....**....%#,,*@,
                          @(,,*&%*.........*((....*#.......................................................(*.,,.......*,#...*&..,@*
                        @#,,/&%,.(*..........#,/.............................................................../...*..*(.......*&.,*@,
                      #@,.,&&*.#&/(.,...............................................................................,...(...,.,,.*%..*@
                     @*,,%@/......#*(................................................................................./. (./.#.....#%..%@
                   &@,,/..........#,../................................................................................,.#.........&*,,@*
                  @/,,&@,............/(..................................................................................#............*&../@
                 @*,/&&.................................................................................................................&,..@
               (@,,(&(...................................................................................................................%%..@(
              (&,,#&*.....................................................................................................................,%../%
             #@,,%&........................................................*/,...../(*......................................................&..*@
            /&,,%&....................................................,                  **..................................................&..,@
           *@,,%&..................................................,     . . ..       .  .  *,................................................&..*@
           @*,#%,................................................*   ..                       (................................................&.,*%
          @/,*#*...............................................*%/,,,***,...,,.  ..............,&..............................................,&..&(
         %&,,%@...............................................%**,..,,,,,,,......,. ........   ,,%#............................................./(,.@
         @*,(%................................................*,..*(*.*,,...*,/..*,.. ... .,.*... ...............................................&*..@
        &(,,#,...............................(/**,,,.,,(.*/,%&&%#*/#(....,* .,...... */. ..,/**/(##% *,,.,,.( .   .(..............................&..##
        @*,%#................................*.... .(/..... %,,.,,*.,**.,,,,,,*((*,..... .(. . . .. ,.,,,..,. .....,..............................#(..@
       ,,/,................................*.  ...........#,*.,/*.,,,,,,,,,,,...,*.......  .(. .  *              %...............................&..*#
       @/,##.................#*..,*,,,,..(/,,,*.,***/,,,,/*/*.,,,,,,,,,,,//***,,,**...... ..   ./.%.,*.(*,,,..,.,/,..,***/*#...*%(...............%(..@
      .@*.#*..........,,,,,*,%....,/,**/...,//(/...*/((,.,/&%((/***/*//**///////********,,,,......./%(..........      . .,,,,.....#*.. ...,.........%..%/
      #(*//..........%,.,,,,.%........... . ...............*/****,*,,,,**,,,,,,,,,,,,,..,,.........(,,,,,*,,,*,,,.........     ....( ...../.........&.,.@
      @/,(/........%%,.,,*,(%/*/*...,.,,*,..............,,.,/%%%###%%##%####(#%####%%(/((###(//(%((..................,   .  ....,%%((((//(&.......#/..@
      @/,((..........%......#*...........,..............,.../,//****/***/**,,*/,,/(*,*,,........**.(.,.................*...........&     .*.........,%..@
      @/,#/..........(,,.,,,(*.........../..............,.../,/*/((((//*//*,*#***,./,/,,,........*./...................*...........%....../..........%..%.
      @/,#*..........#......*/...........*..................*.**/,.,*(//**/,..,..,...*,,,..,*,...*.(...................*...........%   .../..........&..(,
     .@(*#,..........%......//...........,.,......,,*,**....*./**(,##,(//*/,/%&&&%%&//,,,..,//,.,*.(...../,,,,.........*.,.,.,.....& .. ../..........&../,
      @(*#,..........#...(,,&/.....,%##(,*.......,,/*,(.,..,*./*/(*/**(/*,/,///***,.*/,,,..,../.,*./.....*/..(........./,*,*#......&,../..*..........&..(,
      @(*#/..........#..*...%/...,.*,..#,,.......,,,..#,,.,,*./*/(*//*(//,(**//,,,,.*/,.,.,*../../,/...../(..(.........(.,..(.,....#. ..*.,,.........%..%
      @/*/*..........#..,...%*...,.*,..#.,.......,*,..(.,,..*,**(#*((/(//,/********,*/*,,,.*..*.,/,(.,...*(..(.........(.,..(......#... *.*,.........%..@
      &//*,..........%..*...&,...../...(,,......,,*...(.,,,,,.///(*/////(*(,/*/***,,*/*.,.,*..*.,*./.,...*(../.........#,,..(......#.   /./..........#..@
      *%/,#..........%..,...%,...........,.......,*...#.,,,./.**((*//*(//*(,/*/**,*,//*,,..,..*.,/,(...,.*#../,........#. .,......./.   /.*.........**..@
       @/,(,.........%..    %....,..,....,,......,*...(,,,,/.,/,./*/(,(((/%#*,(///*//((,...*..*.,*,,#.,,,//  ,.........#...........#.   . ,.........&..%/
       @(/,/....,.........,*..,.........,,.....,.,.,,*,,,*//***,,,,,,**,***,****//(((##%%#######(#(#(..,.***,,,........#............./...    ..,*...%..@
       ,@/,#,...,..,.,**,,,..,,,.,,.....,.,.,...,,/***/,,//(/////////**///(////**,,,,,,**,,,,......./.*,,**,,,,........#.............*,,,*,,,..**..#*.,%
        @/**/...............................,,,,,,,,,,,*&&%%%###%%%%%%%%%&&&&&&%%##((/////***,*,,,,*/#%(&%###%%%%%&&&&&&%########((//**,...........%..@
         @/,/...........,%...............................**,,,,,,,*******//((###%%%&&&&@@@@@@@@@@@@@@%...............................,,,,,,,*/*.**.*&
         /,#.....,*.,%&&%...........,.,..,*.....*,&/......*.*,/....&(#%......,.....*. ,.....,,,............../*........ .............../,..#*,..%..@
          @/*,/..,*@*...../(...........%*(,*%....,/#../#....*%( /.....(*.....,*,....(,......../.,......(,......#(.....#...#...........,.....//...&..%,
           @/,**.*(....(,%./%.........*%,#.,&.....,(..&.....*%.##.....((.....,/.....*/........(........(,......#(....../../........../.......((.**.*&
           (@/,(*..%#....,.,&........................................................................................................#*....../.,%..@
            #%/,(,..**/,..*%..*....................................................................................................,..#,.**(#..#..@
             @%/*#*.,....%*.#*%,,...................................................................................................%.........%.,@
              /,(/...,%.%./.*@*,................../&//...................................................,#*................../#*....&*./..%.,@
               &&/,(%..,./.(&....,/,..............,#(/,/. ,..............................................(*,,.,,...............,*..&..*../.,#.,@
                /&/,*%..,%,....*.(&*%............##.,...*&., ,....................................../.#...,,.../................%,..../&,.*,.,@
                 ,@/**%*......,&(...&.#................*&..,(,./(,*.............................*..%./*.....#*,............*......,%.*,..&.,/%
                   @(/*#&..*/@.......%#(%............,/&...,(*#..(#./#.................,*.,.%,, .( ....,*.................,#...,.....(..#,.@*
                    #&/**&%......,,(&/..*.,................,%..../%(,..........///,#(.,*.....(.#,.,....#(...............%.*..%.....(..%,,,@
                      @(/*(&*...*&.((...../%/..................,/(.............*......./##,...(,..#*.....................,#.,..%.*..,/,,@*
                       #@//*#@..##%..../.%...%....................,............(/.../..(*..,../...................#/.....#..%...,..%..*@
                         @&(**%@,.,/.,.(*...//...................................%&(................................& &,..*..%,..%,,.@
                           @&(*/#&(..((..,.#/....../.*.*.......................................................%.,...%*..%/....%...@.
                             @&(//(&@...%#/.......#/%..*.( /,..........................................*,,...../*%*,...#..../(.,.@.
                               &@(///%&/...........,/#.....*/##(.....................................,*,........(.%%#,/...%,.,*@
                                 /@#((/(%&*.....*/..((%...*/#...,*((#&.  ,,*///*..............(*.../*.,.*,......&......%#.,,@%
                                    &@((//#%&*...#(**#.../,/...*#*/../,,.*.*...(*,,..((....../,.....,,./........(...%/,,,#@
                                       @@(((((%%&,....../,/...,.**/..*,*..,,,(/..,,.,.,......(,.....(,..(, ...../%*.,,(@*
                                          #@%////#%%&*....#.,(.,#*,..*,...*,./*.....#(........(,....(.......(%/,,,,&@.
                                             .&@#////(#%%&(.....*&&*/*(...*,,..*./,...(...............,/%/,,,,,%@#
                                                  #@@/*////(#%%&&/.........,*(#*..(,/*.........,*#%//,,*,,*@@(
                                                       /@@@(/(////((((###%&&&&%%%%%%%%&%%##(/*******/&@@(
                                                              ,%@@@@%#((//////******/////(/#%@@@@%,
                                                                            .,***/***,.
- [UI] Filter the object template index using the quick search.
  [iglocska]
- [API] On-demand inclusion of attribute relations via the event view
  endpoint. [iglocska]

  - new URL param, includeGranularCorrelations:1 added

                                   |\    /|
                                ___| \,,/_/
                             ---__/ \/    \
                            __--/     (D)  \
                            _ -/    (_      \
                           // /       \_ / ==\
     __-------_____--___--/           / \_ O o)
    /                                 /   \==/
   /                                 /
  ||          )                   \_/\
  ||         /              _      /  |
  | |      /--______      ___\    /\  :
  | /   __-  - _/   ------    |  |   \ \
   |   -  -   /                | |     \ )
   |  |   -  |                 | )     | |
    | |    | |                 | |    | |
    | |    < |                 | |   |_/
    < |    /__\                <  \
    /__\                       /___\
- [stix import] Parsing observable compositions from external STIX
  files. [chrisr3d]
- [security] Made certain settings modifiable via the CLI only.
  [iglocska]

  - some settings are too risky to be exposed, even to site admins, so made them CLI accessible only
- [server settings] Added option to disable the write collision safe
  rotating config.php handler. [iglocska]

Changes
~~~~~~~
- [docs] Added excludeLocalTags to events/restSearch. [iglocska]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [version] bumped. [iglocska]
- [travis] Print permissions on error with travis. [Raphaël Vinot]
- [doc] Minor update, added known-issues section. [Steve Clement]
- [doc] Updated Debian testing install docs (#4840) [Steve Clement]

  chg: [doc] Updated Debian testing install docs
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [doc] Update to Debian 10 install guide, everything works as expected.
  chg: [doc] OpenBSD is broken for misp-modules (OpenCV etc) [Steve
  Clement]
- [doc] Updated Debian testing install docs. [Steve Clement]
- [travis] Fix perms (?) [Raphaël Vinot]
- [travis] Try to fix upload_sample. [Raphaël Vinot]
- [PyMISP] Bump version. [Raphaël Vinot]
- [PyMISP] Bump version. [Raphaël Vinot]
- [PyMISP] updated to the latest version. [Alexandre Dulaunoy]
- [travis] more gpg experiments. [Alexandre Dulaunoy]
- [travis] It's not my week with GnuPG and OpenPGP. [Alexandre Dulaunoy]
- [i18n] Uploaded version from crowdin. Updated default.pot (#4835)
  [Steve Clement]

  chg: [i18n] Uploaded version from crowdin. Updated default.pot
- [i18n] Uploaded version from crowdin. Updated default.pot. [Steve
  Clement]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [enrichment] Reusing the new function fetchInitialObject. [chrisr3d]

  - New function that is exactly the copy paste of
    what is removed in this commit and replaced by
    the function call
- [enrichment] New modules available from event enrichment. [chrisr3d]
- [installer] Added fork checker. [Steve Clement]
- [installer] One step closer to "sane" aka. generic os-detection.
  [Steve Clement]
- [doc] Leveled RHEL7/RHEL8 Install procedure (WiP) (#4824) [Steve
  Clement]

  chg: [doc] Leveled RHEL7/RHEL8 Install procedure (WiP)
- [installer] Updated Installer. [Steve Clement]
- [doc] Updated Debian Install. [Steve Clement]
- [doc] More CentOS/RHEL updates towards some sort of installer. [Steve
  Clement]
- [doc] Leveled RHEL7/RHEL8 Install procedure (WiP) [Steve Clement]
- [i18n] Updated Russian Translation to >30% (#4821) [Steve Clement]

  chg: [i18n] Updated Russian Translation to >30%
- [i18n] Updated Russian Translation to >30% [Steve Clement]
- Bumped query version. [chrisr3d]
- [enrichment] Import modules now support new modules format. [chrisr3d]

  - Import module results are sent to the new view
    (same as for expansion modules) whenever they
    support objects import
  - Function handling the results right after they
    are returned from the module has also been moved
    to Model/Event and is used for both expansion &
    import modules
- [enrichment] Making attributes category & type changeable. [chrisr3d]

  - To keep possibility to select the attribute type
    or category, as it is in freetext import
  - Category and Type values that can be selected by
    users should be specified in the results, using
    an array. Otherwise, they are set and cannot be
    changed in the view (as it is the case for the
    other fields like value and uuid)
  - This feature is only applicable on attributes
    level, and not on object attributes level
- [enrichment] Passing the initial object to the form. [chrisr3d]

  - If the attribute we query the module on is an
    object attribute, we want to have this object
    information se we do not add or overwrite
    attributes already here
- [ObjectReference] Referenced id, uuid & type set now from a function
  that could be reused. [chrisr3d]
- [enrichment] Defined function to appy inflector on strings. [chrisr3d]

  So we can use it each time we want to display the
  freetext import / module results status message
- [stix2] Bumped latest version. [chrisr3d]

  - Fixing issues with 'parse' called on bundles
    containing custom objects
- [installer] If unattended do not switch user. (#4812) [Steve Clement]

  chg: [installer] If unattended do not switch user.
- [installer] If unattended do not switch user. [Steve Clement]
- Remove php 7.0 from travis. [Raphaël Vinot]
- Try to solve the entropy problem on travis. [Raphaël Vinot]
- [doc] More tweaks to the CentOS howto. [Steve Clement]
- [installer] Updated installer. [Steve Clement]
- [doc] Fixed some issues with dashboard. [Steve Clement]
- [doc] Added more steps to make it work on RHEL/CentOS. [Steve Clement]
- [event:view] More UI tweaking on related-* [mokaddem]
- [event:view] UI tweaking on related-* [mokaddem]
- [event:view] Make `Related *` scrollable. [mokaddem]
- [relatedEvent:view] Display the number of unique correlation.
  [mokaddem]
- [view:relatedEvents] Improved UI. [mokaddem]
- [relatedEvent:view] Started integration into event:view - WiP.
  [mokaddem]
- [previewEvent] Improved UI of related events - WiP. [mokaddem]
- [misp-taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [stix2] Bumped latest version. [chrisr3d]
- [installer] Update installer to Fix Auto-VMs. [Steve Clement]
- [installer] Updated installer. [Steve Clement]
- [doc] Added plyara to kali installer, amended RHEL misp-modules
  (#4787) [Steve Clement]

  chg: [doc] Added plyara to kali installer, amended RHEL misp-modules
- [doc] Added plyara to kali installer, amended RHEL misp-modules.
  [Steve Clement]
- [tools] ask_o () wants -e (for colorz) (#4764) [Steve Clement]

  chg: [tools] ask_o () wants -e (for colorz)
- [tools] ask_o () wants -e (for colorz) [Steve Clement]
- [installer] This tweak allows us to reset ssh-keys/ssl-
  certs/other_things_that_want_to_be_uniqe on firstBoot. (#4751) [Steve
  Clement]

  chg: [installer] This tweak allows us to reset ssh-keys/ssl-certs/other_things_that_want_to_be_uniqe on firstBoot.
- [installer] Regen Installer. [Steve Clement]
- [installer] This tweak allows us to reset ssh-keys/ssl-
  certs/other_things_that_want_to_be_uniqe on firstBoot. [Steve Clement]
- [doc] Added more bits to GPG key. (#4749) [Steve Clement]

  chg: [doc] Added more bits to GPG key.
- [doc] Added more bits to GPG key. [Steve Clement]
- [tools] Added MISPvars from the installer. Added PATH_TO_MISP as a
  standard. (#4748) [Steve Clement]

  chg: [tools] Added MISPvars from the installer. Added PATH_TO_MISP as a standard.
- [tools] Added MISPvars from the installer. Added PATH_TO_MISP as a
  standard. [Steve Clement]
- [installer] Added ask_o () for input validation, fixed tr to be more
  uniform. Updated installer checksums. (#4747) [Steve Clement]

  chg: [installer] Added ask_o () for input validation, fixed tr to be more uniform. Updated installer checksums.
- [installer] Added ask_o () for input validation, fixed tr to be more
  uniform. Updated installer checksums. [Steve Clement]
- [reusability] Further modifications - have an on-demand static mode
  for ajaxTags. [iglocska]
- [reusability] modified ajaxTags to massage the data a bit for code-
  reuse. [iglocska]

Fix
~~~
- [stix2 export] Fixed user account pattern creation. [chrisr3d]
- [stix2 export] Fixed user account observable extension. [chrisr3d]
- [galaxies] several minor issues fixed in the UI. [iglocska]
- [CLI] admin->setDatabaseVersion fixed. [iglocska]
- [discussions] Fix to a potential black-hole inducing issue. [iglocska]

  - this totally won't do anything
- [tmpdir] fixed invalid file path. [iglocska]
- [UI] Fixed erroneous tag add buttons from the index. [iglocska]
- [internal] upload sample had a hard coded tmp path that would fail to
  the php fallback if MISP is not installed in /var/www/MISP. [iglocska]
- [stix2 import] Quick variable simplification. [chrisr3d]
- [stix2 import] Reusing functions to simplify the code & avoid
  duplicates. [chrisr3d]
- [stix2 import] Fixed network socket values from pattern. [chrisr3d]
- [stix import] Fixed backward compatibility of an exception. [chrisr3d]
- [eventGraph] Correctly pick the first-matching requiredOneOff to
  generate the object's label. [mokaddem]
- [enrichment] Avoiding issues with failing references. [chrisr3d]

  - In our case of handling module results, we don't
    especially want the results parsing to stop
    because of a missing/failing reference, we just
    want to skip it
- [events] Create massive dummy events. [mokaddem]
- [enrichment] Fixed meta-category fetching. [chrisr3d]

  - Due to the javascript part, we need to set a
    'meta_category' field, which we then translate
    to the expected 'meta-category' field, but which
    is not required when enrichment is called from
    the event level
- [installer] Variable regression (#4829) [Steve Clement]

  fix: [installer] Variable regression
- [installer] Variable regression. [Steve Clement]
- [doc] Fixed systemd unit (#4827) [Steve Clement]

  fix: [doc] Fixed systemd unit
- [doc] Fixed systemd unit. [Steve Clement]
- [installer] Update to correct checksums. [Steve Clement]
- [installer] Installer had some bugs for os-detection. [Steve Clement]
- [doc] Added missing misp-modules centos (#4825) [Steve Clement]

  fix: [doc] Added missing misp-modules centos
- [doc] Added missing misp-modules centos. [Steve Clement]
- [modules] Added full attribute to full event enrichment's module
  query. [iglocska]
- [stix2 import] Fixed socket extension parsing + reusing code.
  [chrisr3d]

  - Reusing the function defined to avoid duplicates
    for network socket objects generated via the
    MISP to STIX2 export
- [stix2 import] Replacing unnecessary defaultdict by dict. [chrisr3d]
- [stix2 import] Reusing function & avoiding duplicates. [chrisr3d]
- [stix2 export] Making stix2-validator happy with email additional
  header fields. [chrisr3d]
- [stix2 export] Making stix2-validator happpy with registry key
  patterns. [chrisr3d]
- [internal] processing freetext data without background workers fixed.
  [iglocska]
- [enrichment view] Testing if event metadata elements exist before
  displaying them. [chrisr3d]
- [enrichment] Applying regular expressions to values before displaying
  them. [chrisr3d]

  - So when the DB is queried to find if object
    attributes with those values already exist,
    we do not miss some stored values
- [enrichment] Strengthened query conditions to find existing object
  attributes. [chrisr3d]
- [enrichment view] Displaying Tags only if not empty (error otherwise)
  [chrisr3d]
- [enrichment] Added missing variable. [chrisr3d]
- Returning tags & galaxies from module results. [chrisr3d]
- [enrichment view] Fixed attributes display wwwwwwwwwww. [chrisr3d]

  - Making attribute value display accept to be on
    multilines to let more space for uuids to be on
    1 line
  - This makes the global display lighter with long
    attribute values, because they were displayed on
    only 1 line, making uuids displayed on 3 or 4
    lines, making the complete view height way bigger
    than expected
- [enrichment view] Displaying forgotten header when there is no object
  in module results. [chrisr3d]
- [enrichment] Setting importComment value before going to the view.
  [chrisr3d]

  - Saving a variable & will avoid issues when reusing
    the view for import modules
- [enrichment] Json format of validation errors. [chrisr3d]
- [enrichment view] Fixed mispositioned closing tags. [chrisr3d]
- [enrichment] Fixed tags classes names following the latest changes on
  the module results view. [chrisr3d]
- [enrichment view] Using some MISP event view parts. [chrisr3d]

  - Using the same design as objects and attributes as in
    the MISP event view
- [enrichment] Fixed change on types & categories. [chrisr3d]

  ... that should be applied on attributes level and
  not on object attributes level
- [enrichment] Removing traces of some variables related to the freetext
  import. [chrisr3d]
- [enrichment] Removed possibility to display freetext result in the new
  module results view. [chrisr3d]
- [hover enrichment] Displaying information of empty results when
  needed. [chrisr3d]
- [enrichment] Displaying reference saving errors in the job status.
  [chrisr3d]

  - Finaly using the dedicated list to display
    validation errors for references
- [enrichment] Better references handling. [chrisr3d]

  - References are all handled at the end, after the
    attributes and objects are all saved (or skipped
    when needed).
  - Since we no longer have any data in '$failed',
    we simply skip every reference related to uuids
    present in this list.
  - '$recovered_uuids' is the list used to handle
    uuids of resolved attributes/objects already
    in the event.
  - We also skip references already present in the
    event (i.e same source, same target and same
    relationship type).
- [enrichment] Better resolved objects handling. [chrisr3d]

  - We handle the initial object independently from
    all the other objects.
  - We make sure Object attributes are not already
    in the event (i.e the object is not already in
    the event) before saving it
  - Some other cases handled a better way to make
    sure we skip saving object attributes or
    references when they should not be, or to skip
    what should be skipped.
- [enrichment] Redefinition of the '$failed' array. [chrisr3d]

  - Used as list and not as dict
  - Used to keep a list of failing attribute & objects
  - Attributes already present in the event are no
    longer saved in this list, and their uuid is saved
    in the '$recovered_uuids' list which is used to
    redirect the resolved attribute / object uuid to
    the same already present attribute / object
- [enrichment] Fixed inflector typo. [chrisr3d]
- [enrichment] Simplified tests if not empty. [chrisr3d]

  - In those specific cases, we can simply skip
    testing if something is set or equals 0, '' or
    false, since it is all implied in 'empty'
- [enrichment view] Quick change, using variable. [chrisr3d]

  ... Instead of going twice through the dictionary
  keys to fetch the same value
- [enrichment] Displaying error value in the job status instead of the
  json format. [chrisr3d]
- Removed test variables. [chrisr3d]

  - Also pardon my French
- [enrichment] Typo on Object references field relationship_type.
  [chrisr3d]
- [enrichment] Fixed missing object_relation field. [chrisr3d]

  ... for object attributes fetched from module
  results form
- [enrichment view] Quick display fix. [chrisr3d]

  - Making sure the submit button is always at the
    bottom of the page
  - Fixed missing closing tags
- [freetext import] Deleted not used variable. [chrisr3d]
- [cleanup] Fixed indentations. [chrisr3d]
- [enrichment] Fixed handleModuleResults input variable name. [chrisr3d]
- [enrichment] Fixed missing merge conflict. [chrisr3d]
- [enrichment] Set sharing group id to 0 when distribution is not
  'Sharing Group' [chrisr3d]

  - Also setting some return data & fields
- [enrichment view] Added missing form fields + button typo. [chrisr3d]

  - Those form inputs are the ones that are used in
    the javascript part to submit results
- [enrichment view] Fixed Object sharing group field location.
  [chrisr3d]
- [enrichment view] Trying to avoid submit button to be somewhere not
  intended. [chrisr3d]
- [enrichment] Avoiding errors on distribution and sharing group data.
  [chrisr3d]

  - Making sure we do have a value for distribution
    and sharing group
  - Avoid translating distribution levels into their
    human meaning because the output process capturing
    data from the form will anyway use the numeric
    values. Readable values are btw displayed in the
    form for users confort
  - Also sanitized data displayed
- [enrichment] Testing if an object has attributes before looping over
  them. [chrisr3d]
- [stix2 export] Making stix2-validator happy about mac addresses.
  [chrisr3d]
- [stix2 export] Fixed TLP marking definition objects creation.
  [chrisr3d]
- [stix2 export] Fixed registry-key keys and values parsing for
  patterns. [chrisr3d]

  - There was an issue with back slashes that made
    sometime indicators creation fail
  - Also switched from concatenation to join
- Libonig2 -> libonig4 (ubuntu bionic) [Raphaël Vinot]
- [stix2 export] Making reusable subfunctions. [chrisr3d]

  - Useful for the next functions to come using the
    same pieces of code
- [stix2 export] Defining pattern with join intead of concatenation.
  [chrisr3d]

  - Started splitting functions with sub-functions
    for a reuse
- [stix2 export] Improved network socket object creation. [chrisr3d]
- [stix2 export] Fixed credential objects mapping to avoid missing
  required stix fields. [chrisr3d]
- [stix import] Fixed stix_edh library import error catching. [chrisr3d]
- [row_attribute] feed correlation popover not being displayed for feed
  type other than MISP format. [mokaddem]
- [relatedEvent:view] catch if number of correlation cannot be found.
  [mokaddem]
- [event:addTag] User can add multiple tag collection at once.
  [mokaddem]
- [stix2 import] Fixed wrong function used. [chrisr3d]
- [installer] Currently misp-packer fails on waiting for user inpu…
  (#4788) [Steve Clement]

  fix: [installer] Currently misp-packer fails on waiting for user inpu…
- [installer] Currently misp-packer fails on waiting for user input
  during upgrade. [Steve Clement]
- [data-massaging] Removed massaging for float type attributes.
  [iglocska]

  - it not only stripped anything but floats as expected, but additionally also rounded the value
- [js] fixes #4678 and javascript errors. [Christophe Vandeplas]
- [API] Simple worker management added. [iglocska]

  - /servers/startWorker/[queue]
  - /servers/stopWorker/[pid]
  - /servers/getWorkers
- [object:proposeValidTemplate] Support only_full_group_by sql mode. Fix
  #4746. [mokaddem]
- [UI] Enrichment hover should also work after sorting / changing the
  event attribute context, etc. [iglocska]
- [stix import] Fixed address objects parsing. [chrisr3d]
- [shell] ask_o () needed some quotes, regenerated installer. (#4750)
  [Steve Clement]

  fix: [shell] ask_o () needed some quotes, regenerated installer.
- [shell] ask_o () needed some quotes, regenerated installer. [Steve
  Clement]
- [stix import] Better handling of missing python libraries. [chrisr3d]
- [security] Fixed an RCE vulnerability with user controled entries
  being fed to file_exists. [iglocska]

  - phar protocol paths for php file instructions can lead to RCE via meta-data deserialization
  - mitigated by the functionalities enabling this being only accessible to site admins

  - Reported by Dawid Czarnecki
- [ajaxTypes] copy pasta fixed. [iglocska]

Other
~~~~~
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4841 from SteveClement/guides. [Steve Clement]

  chg: [doc] Minor update, added known-issues section
- Merge branch '2.4' into guides. [Steve Clement]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch '2.4' into guides. [Steve Clement]
- Add: [stix2 export] Exporting user-account objects. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Add: [stix2 import] Importing credential objects. [chrisr3d]
- Add: [stix2 import] Parsing network traffic in the case of network
  connection object. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Added norwegian translation (#4832) [Steve Clement]

  Added norwegian translation
- Added norwegian. [Kortho]

  Added norwegian translation
- Merge pull request #4807 from RichieB2B/ncsc-nl/IOCImport. [Andras
  Iklody]

  Support empty attribute type in IOC import
- Support empty attribute type in IOC import. [Richard van den Berg]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4826 from SteveClement/tools. [Steve Clement]

  chg: [installer] One step closer to "sane" aka. generic os-detection
- Merge branch '2.4' into tools. [Steve Clement]
- Merge branch '2.4' into tools. [Steve Clement]
- Merge branch '2.4' into guides. [Steve Clement]
- Merge pull request #4822 from Kortho/patch-1. [Andras Iklody]

  fixed mixed dbuser - dbname
- Fixed mixed dbuser - dbname. [Kortho]

  changed so the script uses the correct var
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch 'module_rework2' into 2.4. [iglocska]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Add: [enrichment] Fetching data fields from the view. [chrisr3d]
- Add: [enrichment view] Added data fields + cancel button to the form.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Add: [enrichment] Displaying + returning tags at attributes level from
  the module results. [chrisr3d]

  - If one of our UI master could review this and find
    a better way of displaying the tags at attribute
    level in the module results view, it would be
    very cool :D
- Add: [enrichment] Attaching event level tags returned by the module
  results. [chrisr3d]
- Add: [enrichment view] Displaying event level tags. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Add: [enrichment view] Displaying events metadata & number of returned
  attributes. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Wip: [enrichment] Handling the potential uuids differences. [chrisr3d]

  - We want to be sure the references we add to an
    event are pointing to the right target, so
    when an attribute/object is already in the event
    and is a reference target, we want to point to
    this already existing attribute/object, and not
    to the one we get from the module results, which
    will afterall be skipped.
  - Also to to that, attributes already in the event
    are simply not saved, but we need to find in the
    event if an event already exists or not, using
    its attributes
  - More care to the references themselves to come
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Wip: [enrichment] Avoiding duplicate object attributes. [chrisr3d]

  - It concerns obviously the case where we query a
    module using an attribute within an object as input
  - More to come about the ObjectReference field that
    should not be overwritten/duplicated either
- Wip: [enrichment] Passing initial object references as well.
  [chrisr3d]

  - Also testing if the initial object found is not empty
- Wip: [enrichment] Passing the initial object within the request data.
  [chrisr3d]

  - Makes its parsing easier afterwards
- Add: [hover enrichment] Displaying resolved objects & attributes from
  new modules results. [chrisr3d]

  - Also quick indentation fix
- Wip: [hover enrichment] Passing new modules results to the hover
  enrichment view. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Wip: [enrichment] Support of object references. [chrisr3d]

  - Handling the references between objects and
    attributes or objects that are displayed in the
    form and saving them.
  - Avoiding issue when an attribute or object can
    not be saved and is referenced: trying to find
    in the event if it is an attribute, returning
    a warning message if it is an object or if
    nothing corresponding to the failing referenced
    object or attribute is found.
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Wip: [enrichment] Returning a status message after the module results
  handling is done. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Wip: [enrichment] Saving attributes & objects from module results.
  [chrisr3d]

  - Need to handle specific cases, relationships,
    and to update the progress status information
- Add: [enrichment] Added possibility to get object template version &
  uuid. [chrisr3d]
- Wip: [enrichment] Capturing objects & attributes. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into
  rework_modules. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Add: [stix2 export] Added network connection to the mapped objects.
  [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge pull request #4802 from SteveClement/guides. [Steve Clement]

  chg: [doc] More tweaks to the CentOS howto
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge pull request #4798 from SteveClement/guides. [Steve Clement]

  chg: [doc] Various updates to RHEL/Ubuntu
- Add: [stix2 export] Mapping credential MISP objects. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge pull request #4570 from mokaddem/relatedEventUI. [Andras Iklody]

  Related event ui
- Merge branch '2.4' of github.com:MISP/MISP into relatedEventUI.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into relatedEventUI.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into relatedEventUI.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4769 from cvandeplas/2.4. [Andras Iklody]

  fix: [js] fixes #4678 and javascript errors
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4674 from juju4/devel-globalstrict. [Andras
  Iklody]

  strict typing - snuffleupagus tests
- Strict typing - snuffleupagus tests. [juju4]
- Merge pull request #4741 from StefanKelm/2.4. [Andras Iklody]

  Update EventBlacklistsController.php
- Update edit.ctp. [StefanKelm]

  Clarification that "Fetch GnuPG key" actually connects to the MIT key server
- Update EventBlacklistsController.php. [StefanKelm]

  (minor) aligns the text with app/Controller/Component/BlackListComponent.php
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' into tools. [Steve Clement]
- Merge branch '2.4' into tools. [Steve Clement]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' into guides. [Steve Clement]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]


v2.4.109 (2019-06-13)
---------------------

New
~~~
- [eventblacklist] Added search filters. [iglocska]

  - We really need a DISP - development information sharing platform
- [eventBlacklist] Added support of bulk deletion of entries. Fix.
  [mokaddem]
- [statistics:galaxyMatrix] Added filtering capabilities. [mokaddem]
- [object:fromAttribute] Started dev on merging selected attributes into
  an object - WiP. [mokaddem]
- [API] added new restSearch filter - date. [iglocska]

  - deprecated to and from
  - date works similarly to timestamp, accepted syntax options:
    - time ranges in the shorthand format (7d or 24h, etc)
    - timestamps
    - fallback parsing for other formats (2019-01-01, "fortnight ago", etc)
    - date ranges using lists [14d, 7d]
- [cleanup] Added admin tool to remove all published empty events.
  [iglocska]

  - part of the solution to the empty event sync issue introduced in 2.4.107
  - skips the event blacklisting
- [sync] Block pulled events from being saved if they contain no
  attributes/objects. [iglocska]
- [emailing] Server admins can get a threshold for per org e-mail
  alerts, fixes #4714. [iglocska]

Changes
~~~~~~~
- [VERSION] bump. [iglocska]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [installer] Updated Installer and chksums to latest (#4740) [Steve
  Clement]

  chg: [installer] Updated Installer and chksums to latest
- [installer] Updated Installer and chksums to latest. [Steve Clement]
- [doc] Added ZMQ to the procedure. [Steve Clement]
- Bumped queryversion. [mokaddem]
- [querystring] bump. [iglocska]
- Bumped queryversion. [mokaddem]
- [galaxyMatrix] Added check if event not found. [mokaddem]
- [galaxyMatrix] Improved `getTagScores` to allow with and without ACL
  tag score fetching. [mokaddem]
- [textColourHelper] Little tweaking to prefer black text. [mokaddem]
- [attributeTag:getTagScore] Largely improved code. [mokaddem]
- [restSearch:attack] Only expose attack return format to the `event`
  scope. [mokaddem]
- [galaxyMatrix:stats] Only take into account occurences of galaxy once
  per event. [mokaddem]
- [galaxyMatrix] Fix typos. [mokaddem]
- [galaxyMatrix] Transformed query into cakephp model query. [mokaddem]
- Bumped queryversion. [mokaddem]
- [export:attack] Performance improvements. [mokaddem]
- [galaxyMatrix] Slight UI improvement on number of items. [mokaddem]
- [galaxyMatrix:popup] Layout improvement. Make it scrollable!
  [mokaddem]
- [galaxyMatrix] Added sorting by score. Fix #4608. [mokaddem]
- [galaxyMatrix] number of entry per column. Fix #4601. [mokaddem]
- [object:fromAttributes] Deleted comments and hardcoded table name.
  [mokaddem]
- [attribute:delete] Simplified search options. [mokaddem]
- [object:fromAttributes] Enforce minimum popover size. [mokaddem]
- [object:fromAttributes] Method only accesible via AJAX and regular
  users can use the feature. [mokaddem]
- [object:fromAttributes] Added support of hard delete if event not
  published yet. [mokaddem]
- [object:fromAttributes] Changed warning message during the merge
  review. [mokaddem]
- [object:fromAttributes] Improved styling of reference table.
  [mokaddem]
- [object:fromAttributes] Added a bit more styling on the reference
  table. [mokaddem]
- [object:fromAttributes] Show object references that will be dropped.
  [mokaddem]
- [object:fromAttributes] Slightly improved layout. [mokaddem]
- [ACL] Updated routing. [mokaddem]
- [object:fromAttributes] Added object_relation description. [mokaddem]
- [object:fromAttributes] Returns correct value if attribute list is
  empty. [mokaddem]
- [object:fromAttributes] Created Object from Attribute now works.
  [mokaddem]
- [object:fromAttributes] Shows selected types and started implementaion
  of the actual object creation - WiP. [mokaddem]
- [object:fromAttributes] Added support of form submission - WiP.
  [mokaddem]
- [object:fromAttributes] Better Attribute filtering - WiP. [mokaddem]
- [object:fromAttributes] Greatly improved UI - WiP. [mokaddem]
- [object:fromAttribute] Continue of web and controller implementation -
  WiP. [mokaddem]
- Bumped queryversion. [mokaddem]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]

Fix
~~~
- [installer] added missing python zmq lib. [Christophe Vandeplas]
- [installer] Commit: https://github.com/MISP/MISP/commit/1716ca7da9d671
  a5e103069d4b74c867a17b1020 regressed the installer to an earlier
  version. [Steve Clement]
- [UI] weird blue button fixed. [iglocska]
- [galaxyMatrix] Handle case if deprecated galaxy does not exists.
  [mokaddem]
- [galaxyMatrix] Catch error if no element in column. [mokaddem]
- [event:galaxyMatrix] Apply ACL on the galaxy matrix scores (event
  view) [mokaddem]
- [galaxyMatrix:export] Removed multiple bugs providing inconsistent
  result. [mokaddem]
- [Attribute:restSearch] Prevent failing if file empty. [mokaddem]
- [galaxyMatrix] fixed layout for other views. [mokaddem]
- [attributes] Correctly pass the user object and renamed delete
  function. [mokaddem]
- Few typos. [mokaddem]
- [object:fromAttributes] SYNC support for older instances (duplicate
  attributes and their contexts) [mokaddem]
- [sync] Correctly capture the attributes from a groupment into an
  object during the sync. [mokaddem]
- [attribute:editAttribute] synchronisation support when attributes got
  merged into an object. [mokaddem]
- [object:fromAttributes] Catch if `requiredType` is empty. [mokaddem]
- [object:fromAttributes] Correctly skip non valid attributes.
  [mokaddem]
- [galaxy:add] Fix #4733 (adding galaxies on attribute) [mokaddem]
- [security] Org admins could reset credentials for site admins.
  [iglocska]

  - org admins have the inherent ability to reset passwords for all of their org's users
  - this however could be abused if for some reason the host org of an instance would create org admins
    - the org admin could set a password manually for the site admin or simply use the API key of the site admin to impersonate them
  - the potential for abuse is very circumstancial as it requires the host org to create lower privilege org admins instead of the usual site admins
  - only org admins of the same organisation as the site admin could abuse this

  - as reported by Raymond Schippers
- [sync] Push all bug with empty events fixed. [iglocska]
- [permissions] Fixed the default sync/user/publisher permissions to
  include perm_tagger and perm_tag_editor(sync only) [iglocska]
- [CSRF] END THIS NIGHTMARE. [iglocska]
- [CSRF] Potential fix for the CSRF issues via tag/galaxy additions.
  [iglocska]
- [session] Fix to automatic session destruction in previous attempt to
  fix the overflow of API sessions. [iglocska]
- [API] Destroy the session at the end of the execution. [iglocska]
- [sync] Temporary fix for empty events showing up in syncs when pulling
  from a new instance via an outdated one. [iglocska]

Other
~~~~~
- Merge branch '2.4' into guides. [Steve Clement]
- Merge pull request #4734 from cvandeplas/2.4. [Steve Clement]

  fix: [installer] added missing python zmq lib
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch 'eventblacklist' into 2.4. [iglocska]
- Merge pull request #4635 from mokaddem/galaxyMatrixImprovements.
  [Andras Iklody]

  Galaxy matrix improvements
- Merge branch '2.4' of github.com:MISP/MISP into
  galaxyMatrixImprovements. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into
  galaxyMatrixImprovements. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into
  galaxyMatrixImprovements. [mokaddem]
- Merge pull request #4672 from mokaddem/mergeAttributeIntoObjects.
  [Andras Iklody]

  Merge attributes into objects
- Merge branch '2.4' of github.com:MISP/MISP into
  mergeAttributeIntoObjects. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into
  mergeAttributeIntoObjects. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into
  mergeAttributeIntoObjects. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into
  mergeAttributeIntoObjects. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into
  mergeAttributeIntoObjects. [mokaddem]
- Merge pull request #4722 from certbe-trey/2.4. [Andras Iklody]

  enable misp-wipe where MySQL datastore isn't on localhost
- Enable misp-wipewhere MySQL datastore isn't on localhost. [Trey
  Darley]

  The misp-wipe script grabs the MYSQL host parameter from database.conf but it wasn't included in the call to mysqldump.
- Merge pull request #1 from MISP/2.4. [Trey Darley]

  merge with upstream
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Add: [stix import] Supporting additional marking & namespace.
  [chrisr3d]


v2.4.108 (2019-06-04)
---------------------

New
~~~
- [Sync] Add a tool to create MISP sync configuration JSONs and to
  ingest them, fixes #4696. [iglocska]

  - sync user can log into remote instance, extract config JSON
  - paste it into own instance as site admin to add MISP sync connection
- [API] AND for tag filters in restSeach added. [iglocska]
- [API] Added object_relation as a filter for both the event/attribute
  restSearch functions. [iglocska]
- [paranoid logging] Added POST/PUT body logging on demand. [iglocska]
- [logging] Added paranoid logging mode. [iglocska]

  - will log ANY query's (UI/API):
    - http method
    - requested URL

  - optionally disable DB logging for paranoid log entries
- [logging] Added verbose logging to the server sync test throwing an
  unexpected error. [iglocska]

Changes
~~~~~~~
- [doc] CentOS 7 updates (#4718) [Steve Clement]

  chg: [doc] CentOS 7 updates
- [doc] CentOS 7 updates chg: [doc] Cake command failing. [Steve
  Clement]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [version] bump. [iglocska]
- [installer] Updated the installer to the latest version. [Steve
  Clement]
- [doc] RHEL8 updates. [Steve Clement]
- [tools] unused import module removed. [Alexandre Dulaunoy]
- [feeds] Benkow.cc RAT feed added. [Alexandre Dulaunoy]
- [default feeds] additional properties is allowed. [Alexandre Dulaunoy]
- [doc] Updated SQL (#4670) [Steve Clement]

  chg: [doc] Updated SQL
- [doc] Updated SQL chg: [installer] Updated installer. [Steve Clement]
- [restResponse] Added documentation for adding tags on Objects.
  [mokaddem]
- [diagnostic:view] Improved visibility of the `updateAllJson` update
  button. [mokaddem]
- [event:view] Correctly display title to large by truncating
  (+ellipsis) [mokaddem]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [feeds] malshare.com - current all added. [Alexandre Dulaunoy]
- [PyMISP] updated to the latest version. [Alexandre Dulaunoy]
- [misp-taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- Bumped queryversion. [mokaddem]
- Bumped queryversion. [mokaddem]
- [font-awesome] Bumped version to 5.8.2 and updated glyphs. [mokaddem]
- [doc] adde --no-cache to wget to make sure we always have the la…
  (#4648) [Steve Clement]

  chg: [doc] adde --no-cache to wget to make sure we always have the la…
- [doc] adde --no-cache to wget to make sure we always have the latest
  checksums. [Steve Clement]

  chg: [installer] Updated installer
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [installer] Checksum update. [Steve Clement]
- Bumped queryVersion. [mokaddem]
- [doc] Updated Changelog (#4642) [Steve Clement]

  chg: [doc] Updated Changelog
- [doc] Updated Changelog. [Steve Clement]
- [object:add] Disable the first select's option when adding a new row.
  [mokaddem]
- [object:add] Added empty option support in select inputs when creating
  an object. [mokaddem]
- [installer] If shasum is not found, install it (#4634) [Steve Clement]

  chg: [installer] If shasum is not found, install it
- [installer] Update installer to latest. [Steve Clement]
- [installer] Added todo. [Steve Clement]
- [installer] If shasum is not found, install it. [Steve Clement]
- [installer] Update to latest version (#4633) [Steve Clement]

  chg: [installer] Update to latest version
- [installer] Update to latest version chg: [installer] Set a dynamic
  GnuPG passphrase. [Steve Clement]
- [installer] Update installer (#4631) [Steve Clement]

  chg: [installer] Update installer
- [installer] Update installer. [Steve Clement]
- [installer] Installer now checks his own checksum (#4630) [Steve
  Clement]

  chg: [installer] Installer now checks his own checksum
- [installer] Installer now checks his own checksum. [Steve Clement]
- [yara export] fix the correct Python version is used. [Alexandre
  Dulaunoy]

Fix
~~~
- [UI] Event lock concatinating quoted empty strings. [iglocska]
- [UI] Double sanitisation of org view fixed, fixes #4704. [iglocska]
- [sync] Further fixes to the deleted flag changes breakig things.
  [iglocska]
- [authkey] Fixed The authkey variable (Viper should work again) (#4694)
  [Steve Clement]

  fix: [authkey] Fixed The authkey variable (Viper should work again)
- [authkey] Fixed The authkey variable (Viper should work again next
  run) fix: [doc] Upated RHEL formatting and added $RUN_MYSQL (scl
  enable foo) variable. [Steve Clement]
- [sync] Critical bug fixed that blocked attributes from being included
  in a push. [iglocska]

  - due to the change to the deleted flag that was not reflected in the way we prepare events for the synchronisation
- [sync] Fixed an issue that dropped the remote org. [iglocska]
- [UI] Add the create server sync description menu to the server list.
  [iglocska]
- [sync] whitelist fields that can be added via the JSON config.
  [iglocska]
- [UI] Invalid redirect fixed. [iglocska]
- [organisation:view] Fixed spinner when viewing events from an org.
  [mokaddem]
- [API] Weird responses from JSON objects fixed when data returned is
  empty. [iglocska]
- [API]  Wrong JSON output when /events/index returns empty result,
  fixes #4690. [iglocska]
- [UI] Org index filter fixed. [iglocska]
- [stix2 import] Fixed external domain & x509 patterns import.
  [chrisr3d]
- [freetext import] Fixed shadow attribute import. [chrisr3d]
- [feed] Feodo  tracker blocklist URL replaced. [Sascha Rommelfangen]
- [submodule version check] fixed. [iglocska]
- [event:view] Correctly support the new `deleted` parameter behavior.
  [mokaddem]
- Fix: [restSearche] Correctly interpret the `deleted` parameter on
  `event` and `attribute` scope. -- Pair programming with @iglocksa.
  [mokaddem]
- [UI] Fixed checklocks polluting the top bar. [iglocska]
- [upgrade process] For the recovery script, also take "failed" upgrades
  into account. [iglocska]

  - not all update script errors are actual failures, some insertions of table rows that already exist to resolve potential previous update issues would otherwise not be flagged
- On-Demand Action missed side menu fixed. [4ekin]
- [API] Allow more flexibility on the return content types. [iglocska]

  - also set RPZ as txt
- [enrichment:popover] Correctly fadeout when clicking on the close
  button. [mokaddem]
- [eventGraph] Patch to support new font-awesome 5.8. [mokaddem]
- [STIX] STIX upload fixed for API use. [iglocska]
- [installer] Piping large shell scripts to bash needs more testin…
  (#4644) [Steve Clement]

  fix: [installer] Piping large shell scripts to bash needs more testin…
- [galaxy:add] Consider both model names when doing a mass cluster
  addition. [mokaddem]
- [installer] Piping large shell scripts to bash needs more testing and
  should not be used, for a very long time. [Steve Clement]
- [installer] Checksum checker had a bug (#4632) [Steve Clement]

  fix: [installer] Checksum checker had a bug
- [installer] Checksum checker had a bug. [Steve Clement]
- [stix import] Fixed email attachments parsing. [chrisr3d]

  - Being less restrictive and supporting email
    attachments that are referencing objects not
    under the related object fields of the email,
    but referencing another object at the same level
    as the email, within the STIX incident
  - Also parsing potential references even when the
    STIX file is coming from MISP export
- [stix import] Supporting multi attachment attributes for the email
  object. [chrisr3d]

  - As specified in the object template
- [Logs] Event history missing proposal entries and deletions.
  [iglocska]

Other
~~~~~
- Merge pull request #4671 from Kortho/patch-1. [Steve Clement]

  fixed sql-statement for creating user RHEL
- Fixed sql-statement for creating user. [Kortho]

  fixed error with creating db-user from $DBNAME to $DBUSER_MISP
- Merge pull request #4716 from certbe-trey/patch-1. [Andras Iklody]

  enable misp-backup where MySQL datastore isn't on localhost
- Enable misp-backup where MySQL datastore isn't on localhost. [Trey
  Darley]

  The misp-backup script grabs the MYSQL host parameter from database.conf but it wasn't included in the call to mysqldump.
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4706 from deralexxx/patch-8. [Alexandre Dulaunoy]

  This assignment assigns a variable to itself.
- This assignment assigns a variable to itself. [Alexander J]

  Think that line is not needed.
- Merge pull request #4707 from deralexxx/patch-9. [Alexandre Dulaunoy]

  Import of 'b64encode' is not used.
- Import of 'b64encode' is not used. [Alexander J]

  Remove the import
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4683 from MISP/chrisr3d_patch. [Christian Studer]

  fix: [freetext import] Fixed shadow attribute import
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4639 from wasserman/patch-1. [Andras Iklody]

  GRANTs updated to DBUSER_MISP instead of DBNAME.
- GRANTs updated to DBUSER_MISP instead of DBNAME. [wasserman]

  Two spots were GRANTing to the DBNAME instead of the DBUSER_MISP.  It still works if the user and DBNAME are the same.
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4638 from 4ekin/fix-ui-ondemand-action. [Sami
  Mokaddem]

  fix: On-Demand Action missed side menu fixed
- Merge pull request #4647 from RichieB2B/ncsc-nl/snort. [Alexandre
  Dulaunoy]

  Match EDNS packets with snort rules
- Match EDNS packets with snort rules. [Richard van den Berg]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4661 from RichieB2B/ncsc-nl/retention. [Alexandre
  Dulaunoy]

  Add script for expiring IP based IOC's
- Add script for expiring IP based IOC's. [Jop van der Lelie]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge pull request #4649 from cudeso/2.4. [Steve Clement]

  misp-wipe ; delete all non-default orgs & users
- Misp-wipe ; delete all non-default orgs & users. [Koen Van Impe]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' into guides. [Steve Clement]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge pull request #4629 from RichieB2B/ncsc-nl/wipe-exports. [Andras
  Iklody]

  Clean cached-exports
- Wipe all tmp files, not just the logs. [Richard van den Berg]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]


v2.4.107 (2019-05-13)
---------------------

New
~~~
- [installer] Added rhash and an sfv file for the installer chg:
  [installer] Updated installer to latest. [Steve Clement]
- [ATT&CK] Added new export system for restsearch for ATT&CK. [iglocska]

  - Return the ATT&CK matrix data as HTML via the API
  - Directly viewable via the REST client

  - Greetings from the ATT&CK workshop @ Eurocontrol
- [API] Added includeWarninglistHits to the attribute search API.
  [iglocska]
- [API] Added includeWarninglistHits as a possible filter for the event
  level restsearch. [iglocska]
- [installer] First scaffolding of an OS detector. [Steve Clement]
- [update] Injected update-related files/changes from zoidberg.
  [mokaddem]
- [yara] Added diagnostics. [iglocska]
- [object:add] UI to propose to merge into similar objects - WiP.
  [mokaddem]

Changes
~~~~~~~
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]

  fix: MITRE ATT&CK kill-chain missing
- [version] bump. [iglocska]
- [installer] Updated installer to latest (#4624) [Steve Clement]

  chg: [installer] Updated installer to latest
- [installer] Updated installer to latest. [Steve Clement]
- [conf] Added http to https redirection. [Steve Clement]
- [installer] Added systemd unit file for workers (#4623) [Steve
  Clement]

  chg: [installer] Added systemd unit file for workers
- [installer] Added systemd unit file for workers. [Steve Clement]
- [doc] Added kafka ass a function. [Steve Clement]
- [installer] Update installer to latest. [Steve Clement]
- [doc] Various documentation updates (#4621) [Steve Clement]

  chg: [doc] Various documentation updates
- [doc] Better handling of sudoers. [Steve Clement]
- [doc] Added 2 more hardening sources. [Steve Clement]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [installer] Updated to latest installer (#4617) [Steve Clement]

  chg: [installer] Updated to latest installer
- [installer] Updated to latest installer. [Steve Clement]
- [doc] Updated RHEL8 to not be BETA chg: [vars] WWW_USER is now
  autodedected. [Steve Clement]
- [installer] Updated Installer (#4611) [Steve Clement]

  chg: [installer] Updated Installer
- [installer] Updated Installer. [Steve Clement]
- [doc] Finally got rid of the RHELL/CentOS specific Cake commands
  (_yay_) [Steve Clement]
- [tools] Enabled more modules by default and tweaked some settings.
  [Steve Clement]
- [doc] Kafka export is now included in the list of features. [Alexandre
  Dulaunoy]
- [galaxy/taxonomy/warninglists] updated to the latest version.
  [Alexandre Dulaunoy]
- [installer] If we detect packer, we behave accordingly. (#4602) [Steve
  Clement]

  chg: [installer] If we detect packer, we behave accordingly.
- [installer] updated installer. [Steve Clement]
- [installer] If we detect packer, we behave accordingly. chg:
  [installer] Updated installer. [Steve Clement]
- [installer] Updated installer to latest changes. (#4593) [Steve
  Clement]

  chg: [installer] Updated installer to latest changes.
- [installer] Updated installer to latest changes. [Steve Clement]
- [doc] Update RHEL/CentOS install guides. [Steve Clement]
- [doc] Moved tsurugi away from /INSTALL. [Steve Clement]
- [doc] Moved tsurugi install out of the way, to be implemented way
  later into installer. [Steve Clement]
- [adminShell] Added recovery function to replay updates. [mokaddem]

  It fetches the last successful DB update number in the log, then
  re-apply all of them up to the latest available.
- [AdminShell] Some comments on current state of bugs. [Steve Clement]
- [AdminShell] Let's at least tell what ID was not found. [Steve
  Clement]
- Bump PyMISP. [Raphaël Vinot]
- [PyMISP] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy/misp-objects] updated to the latest version. [Alexandre
  Dulaunoy]
- [AdminShell] Let the user know as which user he exectued the script.
  [Steve Clement]
- [doc] MISP works on OpenBSD 6.5, partially (#4577) [Steve Clement]

  chg: [doc] MISP works on OpenBSD 6.5, partially
- [doc] MISP works on OpenBSD 6.5, partially chg: [doc] Removed link to
  Debian PostgreSQL. [Steve Clement]
- [event:view] Added button to quickly extend an event. Fix #4481.
  [mokaddem]
- [eventgraph] Force constant color for the eventgraph's nodes. Fix
  #4536. [mokaddem]
- [installer] Updated installer. [Steve Clement]
- [doc] Updated to Debian 9.9 via python source install (#4571) [Steve
  Clement]

  chg: [doc] Updated to Debian 9.9 via python source install
- [doc] Some changes to misp-modules install. [Steve Clement]
- [doc] Updated to Debian 9.9 via python source install. [Steve Clement]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [default-feeds] abuse.ch SSL IP fixed. [Alexandre Dulaunoy]
- [distributionNetwork] Filter out organisations not being marked as
  local. Fix #4568. [mokaddem]
- [event:view] Collapse related event in preview[Feed/Event]. Fix #4561.
  [mokaddem]
- [cluster:matrix] Slightly imporved memory performance. [mokaddem]
- [diagnostic] Improved worker's message when updating the submodules.
  [mokaddem]
- [diagnostic] Changed update button with more relevant icons.
  [mokaddem]
- [diagnostic] Added message if `.git` can't be read by MISP. [mokaddem]
- [object:add] Changed back button text into `Back` [mokaddem]
- [update] Avoid executing pre-update test multiple times. [mokaddem]
- [updates] Implented changes requested by the PR's review #4534.
  [mokaddem]
- [updateProgress] bit of cleanup. [mokaddem]
- [updateProgress] Moved CSS in its own file and usage of the
  assetLoader. [mokaddem]
- [onDemandAction] Redirect on updateProgress page is no longueur de
  default behavior. [mokaddem]
- [update] repaired badly merged file. [mokaddem]
- [AdminShell] Adde PHP_EOLs where it made sense. (QoL enhancement)
  [Steve Clement]
- [AdminShell] return the name of the setting change and what we changed
  it to. [Steve Clement]
- [doc] Added plyara (#4554) [Steve Clement]

  chg: [doc] Added plyara
- [doc] Added plyara. [Steve Clement]
- [INSTALL] Updated installer. (#4553) [Steve Clement]

  chg: [INSTALL] Updated installer.
- [INSTALL] Updated installer. [Steve Clement]
- [doc] rhel8/fedora30/debian Install guide updates (#4552) [Steve
  Clement]

  chg: [doc] rhel8/fedora30/debian Install guide updates
- [doc] Added updates to rhel8, which partially works with Fedora Server
  30. [Steve Clement]
- [doc] Debian stable install doc still not working, until Python3.6
  will be default. Debian 10 will fix that. [Steve Clement]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version of ATT&CK. [Alexandre
  Dulaunoy]
- [event:row_attribute] Added `title` to the checkboxes. [mokaddem]

  This reveal to be useful if the table header is not visible.
- [object:revise] Improved text and added a back button. [mokaddem]
- [addTag] Force no caching on the submitTag request. [mokaddem]
- [object:revise] Changed text of back button. [mokaddem]
- [object:revise] Improved help text. [mokaddem]
- [object:add] Improved help text. [mokaddem]
- [object:similiar] Added back button, improved highlight and text.
  [mokaddem]
- [object_revise] Deleted useless comment. Also, fix #3897. [mokaddem]
- [object:reivse] Improved layout. [mokaddem]
- [object:revise] Increase threshold of
  similar_objects_display_threshold and fixed count. [mokaddem]
- [object:edit] Moved listener binding into doc.ready. [mokaddem]
- [object:element] Transformed `object_similarities` view into a
  parametrized view. [mokaddem]

  Greatly improved flexibility of the of the view by only displaying
  available component
- [object:revise] Moved object difference view into `Elements`
  [mokaddem]
- [object] Refacto renamed variables and added comments. [mokaddem]
- [object:edit] Added possibility to inject invalid type + UI
  improvements - WiP. [mokaddem]
- [object:revise] Little perf improvement. [mokaddem]
- [object:edit] Clean up. [mokaddem]
- [object:edit] Avoid duplicating same multiple entries and usage of
  threshold instead of harcdoded value. [mokaddem]
- [object:edit] Added similarity amount between objects. [mokaddem]
- [object:edit] Improved UI and diff recognition - WiP. [mokaddem]
- [object:edit] Continuation integration with template update and object
  merge - WiP. [mokaddem]
- [object:edit] Started integration to allow updating object templates -
  WiP. [mokaddem]
- [object:add] Improved UI for similar objects - WiP. [mokaddem]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [doc/misp-modules generic] update the dependency list. [Alexandre
  Dulaunoy]
- [modules] module choice screen updated. [iglocska]

  - nicer looks
  - sorting
- [doc] Updates to Debian install document (#4531) [Steve Clement]

  chg: [doc] Updates to Debian install document
- [doc] Updated misp-modules install howto chg: [doc] /usr/local/src
  permission fix. [Steve Clement]
- [doc] Updates to Debian install document. [Steve Clement]

Fix
~~~
- [genericPicker] allow tagging when the ATT&CK Matrix has been opened.
  [mokaddem]
- [object:revise] Removed useless ACL conditions; was failing for users
  not being admin. [mokaddem]
- [installer] Identify VMware machinery. [Steve Clement]
- [doc] CentOS specific cake commands do not exist anymore. [Steve
  Clement]
- [sql] SQL Syntax error fix. [Steve Clement]
- [age based publish blocking] Fixed and using the timestamp. [iglocska]
- [docs] Added attackGalaxy as a valid option for the restsearch APIs.
  [iglocska]
- [bug] getPythonVersion undefined, pull in where it is defined. (#4615)
  [Steve Clement]

  fix: [bug] getPythonVersion undefined, pull in where it is defined.
- [bug] getPythonVersion undefined, pull in where it is defined. [Steve
  Clement]
- [API] Some fixes for the restsearch -> attack export. [iglocska]
- [installer] Installer Checksums out-of-sync. [Steve Clement]
- [doc] Let the user know he wants to be the "webserver" user (#4603)
  [Steve Clement]

  fix: [doc] Let the user know he wants to be the "webserver" user
- [doc] Let the user know he wants to be the "webserver" user. [Steve
  Clement]
- [dashboard] netstat is needed for dashboard (#4598) [Steve Clement]

  fix: [dashboard] netstat is needed for dashboard
- [dashboard] netstat is needed for dashboard. [Steve Clement]
- PyMISP install was failing on Travis. [Raphaël Vinot]
- [AdminShell] Yet another tyope :( (#4590) [Steve Clement]

  fix: [AdminShell] Yet another tyope :(
- [AdminShell] Yet another tyope :( [Steve Clement]
- [AdminShell] Fixed typo (#4589) [Steve Clement]

  fix: [AdminShell] Fixed typo
- [AdminShell] Fixed typo. [Steve Clement]
- [AdminShell] Added apache user. [Steve Clement]
- [AdminShell] Misplaced the debug message. [Steve Clement]
- [stix export] Fixed email attachment export. [chrisr3d]

  - Fixed condition trying to reach the case where
    we have an attachment attribute in the object,
    which was never true because of a wrong key
    testing
  - Fixed the email attachment related file object
    creation initiation
- [galaxy clusters] Choosing them via the UI was dog slow. [iglocska]

  - now it's just plain slow
- [update] Disabled background processing until it's fixed. [iglocska]
- [AdminShell] very dirt fix to get updateObjectTemplates working
  (#4585) [Steve Clement]

  fix: [AdminShell] very dirt fix to get updateObjectTemplates working
- [AdminShell] very dirt fix to get updateObjectTemplates working from
  the CLI. [Steve Clement]
- [UI] Notice errors fixed in the discussion threads. [iglocska]
- [bug] Fixed a bug in the update process that caused updates to fail
  due to an invalid value assigned as default for org_id. [iglocska]
- [security] Fix persistent xss due to invalid sanitisation of image
  names in titles. [iglocska]

  - triggered by expanding a screenshot

  - as reported by João Lucas Melo Brasio from Elytron Security S.A. (https://elytronsecurity.com)
- [security] Fix persistent xss via link type attributes containing
  javascript:// links. [iglocska]

  - low impact as it requires user interaction to trigger

  - as reported by João Lucas Melo Brasio from Elytron Security S.A. (https://elytronsecurity.com)
- [security] Fix persistent xss via discussion links via javascript://
  links. [iglocska]

  - low impact as it requires user interaction to trigger

  - as reported by João Lucas Melo Brasio from Elytron Security S.A. (https://elytronsecurity.com)
- [AdminShell] CentOS/RHEL use 'apache' by default (#4580) [Steve
  Clement]

  fix: [AdminShell] CentOS/RHEL use 'apache' by default
- [AdminShell] CentOS/RHEL use 'apache' by default. [Steve Clement]
- [doc] Remove CentOS 7 from xINSTALL list. (#4579) [Steve Clement]

  fix: [doc] Remove CentOS 7 from xINSTALL list.
- [doc] Remove CentOS 7 from xINSTALL list. [Steve Clement]
- [export] Yara Export variable typo fix. Use getPythonVersion. (#4578)
  [Steve Clement]

  fix: [export] Yara Export variable typo fix. Use getPythonVersion.
- [export] Yara Export variable typo fix. Use getPythonVersion. [Steve
  Clement]
- [object:revise] Force field to be `value1`, preventing bug in some
  cases. [mokaddem]
- [cluster:galaxyMatrix] Increased coverage of attack matrix. [mokaddem]

  Now consider the following new links for the pivot tag:
  Attributes -> Events
  Events -> Attributes
- [installer] Fixed installer misp-modules permissions. (#4558) [Steve
  Clement]

  fix: [installer] Fixed installer misp-modules permissions.
- [doc] misp-modules failed to install because of a Permission issue.
  (#4557) [Steve Clement]

  fix: [doc] misp-modules failed to install because of a Permission issue.
- [install] Fixed the endless loop in viper db update (#4555) [Steve
  Clement]

  fix: [install] Fixed the endless loop in viper db update
- [i18n] Added yara/yara-export. [Steve Clement]
- Fixed i18n strings in Event controller, model and view. [4ekin]
- Typos in controllers. [4ekin]
- [installer] Fixed installer misp-modules permissions. [Steve Clement]
- [doc] misp-modules failed to install because of a Permission issue.
  [Steve Clement]
- [install] Fixed the endless loop in viper db update. [Steve Clement]
- [required taxonomies] not firing via regular publishing only via
  publish (no email), fixes #4546. [iglocska]
- [UI] Sightings could not be added by read only users, even if they had
  sighting rights. [iglocska]
- [updateSubmodule] Simplified calculation of time difference.
  [mokaddem]
- [object:edit] Removed faulty line. [mokaddem]
- [object:revise] Reverted correct `endif` position - WiP. [mokaddem]
- [diagnostic:submodules] [Sami Mokaddem]

  Time difference is correctly calculated. Should solve #4538
- [enrichment] typo causing enrichments to redirect to the event view
  fixed. [iglocska]
- [UI] removed <small> tags embedded in translated text. [iglocska]
- [freetext] Also trim out no-break spaces. [iglocska]

  ░░░░░░░░░░░░░░░░░░░░░░░░░░░░░░░░░
  ░░░░░░░░███████████████░░░░░░░░░░
  ░░░░░░███████████████████░░░░░░░░
  ░░░░░███░░░░░░░░░░░░░░████░░░░░░░
  ░░░░██░░░░░░░░░░░░░░░░░░░███░░░░░
  ░░░██░░░░░░░░░░░░░░░░░░░░░███░░░░
  ░░██░░███████░░░░░░██████░░██░░░░
  ░██░░██─────██░░░░██────██░░██░░░
  ░██░░█▄▄▄▄▄▄▄██░░░█▄▄▄▄▄▄██░░██░░
  ░██░░████─────█░░░████────█░░░██░
  ░██░░█────────█░░░█───────█░░░██░
  ██░░░██──────██░░░██─────██░░░░██
  ██░░░░████████░░░░░███████░░░░░██
  █░░░░░░░░░░░░░░░░░░░░░░░░░░░░░░░█
  █░░░░░░░░░░░░░░░░░░░░░░░░░░░░░░░█
  █░░░░░░░░░░░░░░░░░░░░░░░░░░░░░░░█
  █░░░░░███████████████░░░░░░░░░░░█
  █░░░████░░░░░░░░░░░░░░░░░░░░░░░░█
  █░░░░░░░░░░░░░░░░░░░░░░░░░░░░░░░█
  █░░░░░░░░░░░░░░░░░░░░░░░░░░░░░░░█
  ██░░░░░░░░░░░░░░░░░░░░░░░░░░░░░██
  ░██░░░░░░░░░░░░░░░░░░░░░░░░░░░░█░
  ░░███░░░░░░░░░░░░░░░░░░░░░░░░░██░
  ░░░░██░░░░░░░░░░░░░░░░░░░░░░░██░░

Other
~~~~~
- Merge pull request #4622 from SteveClement/guides. [Steve Clement]

  fix: [sql] SQL Syntax error fix
- Merge remote-tracking branch 'upstream/2.4' into guides. [Steve
  Clement]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4616 from SteveClement/guides. [Steve Clement]

  chg: [doc] Updated RHEL8 to not be BETA
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' into tools. [Steve Clement]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge pull request #4607 from pettai/new-rpz-action-fix. [Andras
  Iklody]

  rpz: fix missing rpz policy actions
- Rpz: add missing rpz policy actions. [frpet]
- Merge pull request #4600 from pettai/local-data. [Andras Iklody]

  rpz: Local-Data
- Fix description. [frpet]

  make the description clearer
- Rpz: action policy rename (to Local-Data) [frpet]

  Rename action policy "walled-garden" to "Local-Data" as per the IETF draft (and other documentation for RPZ)
- Merge branch '2.4' into tools. [Steve Clement]
- Merge pull request #4595 from pettai/action-policy-update. [Andras
  Iklody]

  rpz: make NXDOMAIN default
- Rpz: make NXDOMAIN default. [frpet]

  Update default action policy from DROP --> NXDOMAIN
- Merge pull request #4592 from SteveClement/guides. [Steve Clement]

  chg: [doc] Update RHEL/CentOS install guides
- Merge branch '2.4' into guides. [Steve Clement]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge pull request #4588 from SteveClement/tools. [Steve Clement]

  fix: [AdminShell] Added apache user
- Merge branch '2.4' into tools. [Steve Clement]
- Merge pull request #4587 from pettai/lint-RPZexport. [Andras Iklody]

  Lint RPZexport
- Update Serial description. [frpet]

  Hint about $time, which also is a valid setting
- Fix the testForRPZ... functions. [frpet]

  Make the testForRPZ... functions happy too.
- Merge pull request #4581 from pettai/RPZ-policy-action. [Andras
  Iklody]

  RPZ - Add additional policy actions
- Add additional policy actions. [frpet]

  Add the last policy actions from the RPZ draft.
  * rpz-passthru allows for testing without applying changes on the returned answer.
  * TCP-only forces the client over to use TCP.
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch '2.4' into tools. [Steve Clement]
- Merge pull request #4556 from SteveClement/tools. [Steve Clement]

  chg: [AdminShell] return the name of the setting change and what we changed it to
- Zoidberg's son: Update system (#4534) [Steve Clement]

  Zoidberg's son: Update system
- Fix typos and i18n in Event controller, model and views (#4541) [Steve
  Clement]

  Fix typos and i18n in Event controller, model and views
- Merge branch '2.4' into fix-i18n. [Steve Clement]
- Merge branch 'guides' into tools. [Steve Clement]
- Merge remote-tracking branch 'upstream/2.4' into 2.4. [Steve Clement]
- Merge remote-tracking branch 'upstream/2.4' into 2.4. [Steve Clement]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch 'yara2' into 2.4. [iglocska]
- Cleaning up imports. [edhoedt]
- Yara export. [edhoedt]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4545 from MISP/mergeSimilarObject. [Alexandre
  Dulaunoy]

  Several improvement on objects manipulation
- Merge branch '2.4' of github.com:MISP/MISP into mergeSimilarObject.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]


v2.4.106 (2019-04-25)
---------------------

New
~~~
- [tools] Added local forward in case we run under a VM. [Steve Clement]
- [tools] Added (official) checksums for the Installer. [Steve Clement]
- [row_attribute] Added `title` containing the `event.info` data for the
  attribute. [mokaddem]
- [tools] A developer tool to test Pull Requests. [Steve Clement]
- [thumbnail] Thumbnail are now saved on the disk, greatly improving
  performance when viewing an event. [mokaddem]
- [API] Update JSON exposed to the API. [iglocska]
- [CLI] Update all JSON structures in one shot. [iglocska]
- [refanging] Attributes automatically refanged in beforeValidate, fixes
  #4442. [iglocska]
- [CLI] Worker management added. [iglocska]

  - Added a more exhaustive worker management CLI script package
    - list workers
    - start a worker
    - restart a worker
    - kill a worker
- [CLI] reset / set a user's API key via the CLI. [iglocska]
- [CLI] Change password with the --override_password_change (or -o) flag
  to avoid forcing a password reset. [iglocska]
- [diagnostic:submodule] Added output message after update - WiP.
  [mokaddem]
- [CLI] Set default role via the CLI. [iglocska]
- WIP LinOTP authentication. [Andreas Rammhold]
- [UI] refactor of the asset loading. [iglocska]
- [tags] refactor of the tag picker. [iglocska]

  - massive performance boost
  - re-introduction of the custom tags
- [CLI] Added restartworkers and update MISP. [iglocska]
- [feeds] Feed/Server cache search added. [iglocska]

  - /feeds/searchCaches added
- [UI] First version of the generic index list system. [iglocska]
- [Attribute] Added possibility to view and resize images. Added php-gd
  dependency! [mokaddem]
- [eventindex] clicking on sightings count redirect to the event with
  `sighting only` filter activated. [mokaddem]
- [eventFiltering] Added support of sighting filtering. [mokaddem]

Changes
~~~~~~~
- [VERSION] bump. [iglocska]
- [doc] Updated RHEL8(BETA) doc, core works, misp-modules do not, LIEF
  does not. (#4529) [Steve Clement]

  chg: [doc] Updated RHEL8(BETA) doc, core works, misp-modules do not, LIEF does not.
- [doc] Updated RHEL8(BETA) doc, core works, misp-modules do not, LIEF
  does not. chg: [doc] Some notes for rhel7. [Steve Clement]
- [doc] Added more changes to the RHEL/CentOS install doc. [Steve
  Clement]
- Bump PyMISP. [Raphaël Vinot]
- [PyMISP] updated to the latest version. [Alexandre Dulaunoy]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- [galaxy/taxonomies/warninglists] updated to the latest version.
  [Alexandre Dulaunoy]
- [eventTag] Improved perfs of extraction. [mokaddem]
- [event:EventFilteringTool] Forced maximum height. [mokaddem]
- [event:EventFilteringTool] Added comments and deleted useless
  `htmlspecialchars` [mokaddem]
- [event:eventFilteringTool] Improved UI and changted sanitization to
  allow tag/galaxy pre-filling. [mokaddem]
- [event:view] Increase tag colleciton efficiency. [mokaddem]
- [event:EventFilteringTool] Display active filtering rules
  (tags/galaxies) even if not available. [mokaddem]

  Due to a recent performance fix, only tags and galaxies of the event are
  shown, the rule is still displayed event if not matching attributes are
  found
- [event:view] Major performance improvement for large event. [mokaddem]

  Due to the introduction of the event filtering widget, attributes were
  fetched 2 additional times.
- [doc] CentOS/RHEL udpates. Merge towards unity. (#4527) [Steve
  Clement]

  chg: [doc] CentOS/RHEL udpates. Merge towards unity.
- [doc] CentOS/RHEL udpates. Merge towards unity. [Steve Clement]
- [performance] Reworked the pre-fetching of event IDs for the
  events/restSearch endpoint. [iglocska]

  - no need to count all existing hits in a non paginated situation. Simply use the result count
- [misp-warninglists] updated with the latest version. [Alexandre
  Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [i18n] Updated language files new: [i18n] Added: Portuguese and
  Arabic. [Steve Clement]
- [i18n] Updated default.pot fix: [i18n] Fixed parser error. [Steve
  Clement]
- More russian translation. [4ekin]
- [doc] Added note about 19.04. [Steve Clement]
- [tools] Updated installer. [Steve Clement]
- [doc] More variable updates. [Steve Clement]
- [tools] Updated installer. [Steve Clement]
- [doc] support function variable updates. [Steve Clement]
- [doc] More variable updates. [Steve Clement]
- [tools] Some variable changes. [Steve Clement]
- [tools] Updated installer. [Steve Clement]
- [tools] 19.04 test. [Steve Clement]
- [tools] Updated installer. [Steve Clement]
- [tools] Updated installer. [Steve Clement]
- [tools] If staff does not exist do not run commands with that group.
  [Steve Clement]
- [tools] Updated installer after doc update. [Steve Clement]
- [doc] minor note. [Steve Clement]
- [doc] Testing manual/installer fixing some minor variables. [Steve
  Clement]
- [doc] Added -1 to rhel/centos and a future note. [Steve Clement]
- [tools] Changes to reflect the rename of the installer and generated
  latest installer. [Steve Clement]
- [tools] Renamed installer to be more Generic. [Steve Clement]
- [doc] Reflected INSTALL.sh rename. [Steve Clement]
- [doc] Brought CentOS6 more in-line with CentOS7 (still needs more
  testing). Minor changes in CentOS7. [Steve Clement]
- [doc] Redirect debug error output. [Steve Clement]
- [UI] Show event info on attribute search results page (via hover),
  fixes #4490. [iglocska]
- [tools] Renamed the script, added a few more tweaks. [Steve Clement]
- [doc] RHEL Install doc updates. [Steve Clement]
- [doc] CentOS lief how-to added fix: [doc] Fixed the MISP Dashboard
  Cake commands (if you run as root, config.php permissions will be
  b0rked) [Steve Clement]
- [doc] More syntactic sugar (in light of an impending installer script)
  [Steve Clement]
- [doc] Updated CentOS 7.x Install guide chg: [doc] Now installs most
  things correctly under a standard CentOS minimal install. [Steve
  Clement]
- [queryversion] bumped queryversion. [mokaddem]
- [popovers] Added dedicated popover container for expansions and
  sightings (instead of a shared one with the screenshots) [mokaddem]
- [misp-objects] object templates updated + relationships. [Alexandre
  Dulaunoy]
- [download as] updated - now works on non published events in all cases
  and uses restsearch whenever possible. Fixes #4468. [iglocska]
- [UI] server settings double clicking on setting name brings up the
  value text box. [iglocska]
- [viewPicture] Added comments. [mokaddem]
- [eventGraph] Added support of picture. Fix #4433. [mokaddem]
- [eventGraph] initial work before implementing thumbnails support.
  [mokaddem]
- Bump PyMISP. [Raphaël Vinot]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- [taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [generic_picker] select_threshold is now parametrized. [mokaddem]
- [diagnostic:submodules] added `updateJSON` in the web interface.
  [mokaddem]
- [CLI] line-break added at the end of execution. [iglocska]
- [diagnostic:submodule] Better control of the glue merging command
  outputs. [mokaddem]
- [diagnostic:submodules] Added support and feedbacks if workers not
  available. [mokaddem]
- [diagnostic:submodule] continued sync DB after pull done - WiP.
  [mokaddem]
- [diagnostic:submodule] Started integration of update DB after pull
  with workers. [mokaddem]
- [docs] Added update JSON CLI command description. [iglocska]
- [misp.js] Moved all listeners inside $.ready() [mokaddem]
- [user] Usage of the assetLoader instead of echo. [mokaddem]
- [diag] Added grep -v ^- to make sure we always only get the submodules
  that are available. [Steve Clement]
- [taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [diag] Considered the case if submodules are not checked out and added
  a local check for the submodule hash. [Steve Clement]
- [documentation] Added setDefaultRole CLI command to the list of
  described CLI tasks on the automation page. [iglocska]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [diagnostic:submodule] General improvements (see below) [mokaddem]

  - Allow update button reuse (avoiding blackhole)
  - Improved feedback when errors
  - Check if submodules are readable
- [doc] Debian testing is working. [Steve Clement]
- [doc] Tried to update the debian install guide. [Steve Clement]
- [diagnostic] Renamed variable names. [mokaddem]
- [disagnostic] Handling submodule younger case. [mokaddem]
- [diagnostic] Improved submodules version and added individual update.
  [mokaddem]
- [diagnostic] Beter parsing of submodule output. [mokaddem]
- Bump PyMISP. [Raphaël Vinot]
- [cti-python-stix2] Bumped latest version. [chrisr3d]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [restClient:querybuilder] bit of cleanup. [mokaddem]
- [restClient:querybuilder] Prefil the QB when picking a saved query -
  WiP. [mokaddem]
- [INSTALL] Do not touch the auto-generated installation file anymore.
  [mokaddem]
- [viewPicture] Echo base64decoded data with GIF image type as php-gd
  does not support animated gif. [mokaddem]
- [Attribute] Implemented Iglocska review - Do not pass image data to
  the view anymore - Improved conditions - Added light support of gif.
  [mokaddem]
- [INSTALL] Added GD dependency. [mokaddem]
- [diagnostic] Added GD in PHP extension. [mokaddem]
- [viewPicture] Adaptative behavior if php-gd not loaded. [mokaddem]
- [Attribute] Added loading icon when downloading pictures. [mokaddem]
- Cleanup 2. [mokaddem]
- Clean-up. [mokaddem]
- [Attribute] Image thumbnail and view image. [mokaddem]
- [diag] Added a more dynamic way for submodule version status. [Steve
  Clement]
- [matrixPopup] UI improvement to better support small screens.
  [mokaddem]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- Removed duplicate. [mokaddem]
- [i18n] Fix filename typo. [Steve Clement]

Fix
~~~
- [doc] Fixed symlink for kali. [Steve Clement]
- [object:edit] attachment field when empty. [mokaddem]
- [Sightings] ACL fixed. [iglocska]
- [event:querybuilder] Force QB wrapper to fit the rules. [mokaddem]
- [event:EventFilteringTool] Using ``toggleBoolFilter`` button does not
  reset the rules. Fix #4418. [mokaddem]
- [JS] Correctly handle event locks. [iglocska]
- [sightings] Users with sighting permissions should be able to add
  sightings even if they don't have event write access. [iglocska]
- [cleanup] Fixed indentation. [chrisr3d]
- [UI] Event lock warnings missing due to missing ctp file. [iglocska]
- [performance] Manually inject index hints for the value lookup.
  [iglocska]

  - Disgusting fix for old versions of MySQL
  - I need a shower after this
- [API] Invalid negative lookup fixed. [iglocska]
- [debug] Removed breakpoint. [iglocska]
- [tools] Correct iptables command. [Steve Clement]
- [tools] fix iptables typo. [Steve Clement]
- Fixed wrong link to feed event from event attribute hit. [4ekin]
- I18n fixed in some views. [4ekin]
- [tools] Somehow there are issues with groups and sudo  :( [Steve
  Clement]
- [doc] Fixed broken RHEL8 BETA link. [Steve Clement]
- [stats:galaxyMatrix] No longer trim the end of the cluster name.
  [mokaddem]
- [UI] Minor font-awesome switch related issues fixed. [iglocska]
- [UI] Modifying push/pull rules fails via the server edit. [iglocska]
- [export] Fixed broken bro export, fixes #4050. [iglocska]
- [stix2 export] Fixed labels duplication while exporting multiple
  events from MISP. [chrisr3d]
- [stix restSearch] Fixed output json format in case of empty results.
  [chrisr3d]
- [stix restSearch[ Quick file extension clarification. [chrisr3d]

  - Depending on the format (.stix or .stix2)
  - Impacting temporary files, it is thus for
    debugging purpose in case of error
- [restClient] nationality is not a integer anymore. [mokaddem]
- [statistics] Don't show types with no values. [iglocska]
- [taxonomies] non initialised variable throwing notices fixed.
  [iglocska]
- [CLI] Worker start script reverted. [iglocska]

  - new script moved to start_dynamic.sh
  - stuck workers could not be restarted
- [UI] Jobs index removed old style tabs. [iglocska]
- Fix: [ACL] HELLO @RichieB2B! fixed invalid capitalisation in the
  queryACL. [iglocska]
- [updates] I can't boolean. [iglocska]
- [merge] issue. [iglocska]
- [refanging] Removed invalid pattern. [iglocska]
- [bug] Typo causing "\" to be stripped from attributes where it
  shouldn't be stripped. [iglocska]
- [advanced extraction] Fixed invalid double encryption of the malware
  samples. [iglocska]
- [User] Fixed missing files for distribution_network (events index)
  [mokaddem]
- [bug] Fixed broken multi-attribute tagger. [iglocska]
- [acl] added route. [mokaddem]
- [diagnostic] Fixed required stix2 version to the latest one.
  [chrisr3d]
- [acl] added missing entry. [Andras Iklody]

  This message was sent from my Blackberry.
- [feeds] Stop the reset of the attribute count after a feed pull is
  completed, fixes #4414. [iglocska]
- [distributionGraph] Fix fa icon. [mokaddem]
- [UI] First recorded change fixed to not be copy pasta of the last
  change's timestamp. [iglocska]
- [API] role_id is not required when POSTing users if a default role is
  set on the instance. [iglocska]
- Missing test files in PyMISP. [Raphaël Vinot]
- [UI] Reverted some breaking changes. [iglocska]
- [API] Correctly embed attributes and the event metadata in the object
  via /objects/view/[ID] [iglocska]
- [API] /objects/view should return dictionary not list. [iglocska]
- [JS] fixed a JS breaking bug. [iglocska]
- Allow x-frames in apache configs. [iwitz]
- [UI] Changed the querystring loading for css/js. [iglocska]
- TODO i18n strings in Attribute Model and updated default.pot. [4ekin]
- Fixed i18n strings in Views. [4ekin]
- Fixed i18n strings in Controllers. [4ekin]
- [enrichment view] Fixed distribution display at attribute level.
  [chrisr3d]
- [UI] Performance boost for the tag selector. [iglocska]
- [UI] Check if user is logged in switched to on-demand JSON version.
  [iglocska]
- [Training] Further fixes. [iglocska]
- [Training] typos fixed. [iglocska]
- [Training] Fixed user password reset remotely. [iglocska]
- [Training] Minor fixes. [iglocska]
- [Training] org name vs id mixup fixed. [iglocska]
- [Training] Further tuning. [iglocska]
- [Training] Further error handling. [iglocska]
- [Training] added more debugging. [iglocska]
- [Training] host org fixed. [iglocska]
- [Training] Org ID for sync users fixed. [iglocska]
- [Training] small fixes. [iglocska]
- [Training] Fix to the setup script. [iglocska]
- [feed] Added missing feed search view. [iglocska]
- Missing libonig on travis with PHP nightly. [Raphaël Vinot]
- [API] Feed index shouldn't adhere to pagination defaults of the UI,
  fixes MISP/misp-book#149. [iglocska]
- [UI] Colours for feed index buttons fixed. [iglocska]
- [ACL] Added ACL for the new cache searches. [iglocska]
- [UI] Missing sync / feed pull/push buttons re-added. [iglocska]
- [restClient:querybuilder] Fixed a bug where multiple rules where not
  added correctly and show API info box. [mokaddem]
- [RestClient:queryBuilder] Distribution level in the query builder. Fix
  #4280. [mokaddem]
- [Accessibility] Added titles to the role index icons, affects #4258.
  [iglocska]
- [thumbnail] picture preview was not showing up all the time.
  [mokaddem]
- [picturePreview] Don't show the fullscreen button if php-gd is not
  installed. [mokaddem]
- [ACL] Whitelisted `viewPicture` [mokaddem]
- [viewField] Reversed condition (initially set for testing) [mokaddem]
- [enrichment view] Making sure the document is ready before calling any
  javascript. [chrisr3d]
- [enrichment] Set potentially missing category, ids & distribution
  values before going to the view. [chrisr3d]

  - Set the default values in the controller's side instead of the view's side
- [enrichment view] Fixed typo. [chrisr3d]

Other
~~~~~
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge pull request #4484 from obert01/fix-tag-search. [Andras Iklody]

  Fixed case sensitivity in the tag search API (/tags/search).
- Fixed case sensitivity in the tag search API (/tags/search). [Olivier
  BERT]

  There was still a problem for matching the search on a cluster name. I have also slightly simplified the construction of the SQL request for better code readability.
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4492 from mokaddem/eventViewPerfImprov. [Andras
  Iklody]

  [event:view] Major performance improvement for large event
- Merge branch '2.4' of github.com:MISP/MISP into eventViewPerfImprov.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into eventViewPerfImprov.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge pull request #4517 from SteveClement/i18n. [Steve Clement]

  chg: [i18n] Updated language files
- Merge pull request #4512 from 4ekin/russian_translation. [Steve
  Clement]

  chg: More russian translation
- Merge pull request #4516 from SteveClement/INSTALL_19.04. [Steve
  Clement]

  chg: [tools] Tested and adapted the installer to work with latest Ubuntu Server 19.04
- Merge pull request #4515 from SteveClement/tools. [Steve Clement]

  chg: [tools] Updated installer
- Merge pull request #4514 from SteveClement/tools. [Steve Clement]

  fix: [tools] Correct iptables command
- Merge pull request #4513 from 4ekin/fix-i18n. [Andras Iklody]

  Fix i18n and wrong link to feed event
- Merge pull request #4511 from SteveClement/tools. [Steve Clement]

  new: [tools] Added local forward in case we run under a VM.
- Merge pull request #4509 from SteveClement/guides. [Steve Clement]

  fix: [doc] Fixed broken RHEL8 BETA link.
- Merge pull request #4503 from SteveClement/tools. [Steve Clement]

  chg: [tools] Updated installer after doc update
- Merge pull request #4502 from SteveClement/guides. [Steve Clement]

  chg: [doc] Testing manual/installer fixing some minor variables
- Merge pull request #4501 from SteveClement/tools. [Steve Clement]

  new: [tools] Added (official) checksums for the Installer.
- Merge pull request #4498 from SteveClement/tools. [Steve Clement]

  chg: [tools] Renamed installer to be more Generic
- Merge pull request #4500 from SteveClement/guides. [Steve Clement]

  chg: [doc] Reflected INSTALL.sh rename
- Merge pull request #4499 from SteveClement/i18n. [Steve Clement]

  chg: [i18n] Polish Translation typo fixed
- Merge branch '2.4' into i18n. [Steve Clement]
- Merge pull request #4493 from obert01/fix-accessibility. [Steve
  Clement]

  New bunch of accessibility fixes.
- New bunch of accessibility fixes. [Olivier BERT]

  This affects EventBlacklists, Feeds, GalaxyClusters, News (index), OrgBlacklists (index), Organisations (index), SharingGroups (index), Taxonomies (view), Event Discussions, Event attribute table, Event proposal table.
- Merge pull request #4496 from SteveClement/guides. [Steve Clement]

  chg: [doc] Brought CentOS6 more in-line with CentOS7
- Merge branch '2.4' into guides. [Steve Clement]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4488 from SteveClement/tools. [Steve Clement]

  new: [tools] A developer tool to test Pull Requests
- Merge branch '2.4' into tools. [Steve Clement]
- Merge pull request #4478 from RichieB2B/ncsc-nl/centos6. [Steve
  Clement]

  Make xINSTALL.centos6.md work again
- Make xINSTALL.centos6.md work again. [Richard van den Berg]
- Merge pull request #4487 from SteveClement/guides. [Steve Clement]

  chg: [doc] RHEL Install doc updates
- Merge pull request #4486 from SteveClement/guides. [Steve Clement]

  chg: [doc] CentOS lief how-to added
- Merge pull request #4480 from SteveClement/guides. [Steve Clement]

  chg: [doc] Updated CentOS 7.x Install guide
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4470 from pettai/ShibbAuth. [Andras Iklody]

  Update README.md
- Update README.md. [frpet]

  Makes API Authorization work
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4441 from mokaddem/eventGraph_thumbnail. [Andras
  Iklody]

  EventGraph thumbnails
- Merge pull request #4451 from obert01/fix-delete-user. [Andras Iklody]

  Fix for broken "delete user" link in side menu.
- Fix for broken "delete user" link in side menu. [Olivier BERT]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch 'feature/attribute_references' into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into
  feature/attribute_references. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4435 from MISP/submoduleUpdatev4. [Steve Clement]

  Diagnostic - Submodule update v4
- Merge branch '2.4' into submoduleUpdatev4. [Steve Clement]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4438 from liedekef/patch-1. [Alexandre Dulaunoy]

  Install doc fixes
- LD_LIBRARY_PATH setting needed for rh-git218. [Franky Van Liedekerke]
- Update INSTALL.rhel7.md. [Franky Van Liedekerke]
- Redhat install doc updates. [Franky Van Liedekerke]

  Selinux simplications (otherwise web-based update won't work anyway)
  haveged is optional
  Crypt_GPG was being installed 2 times
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4434 from SteveClement/tools. [Steve Clement]

  chg: [diag] Considered the case if submodules are not checked out
- Merge branch '2.4' into tools. [Steve Clement]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge pull request #4427 from mokaddem/submoduleUpdatev3. [Steve
  Clement]

  Submodule updateV3
- Update Server.php. [Steve Clement]

  Small typo
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4430 from SteveClement/guides. [Steve Clement]

  chg: [doc] Updated debian guides
- Merge pull request #4399 from GOVCERT-LU/chg_add_pipenv. [Raphaël
  Vinot]

  Install python dependencies via Pipfile instead of manually cloning / installing them
- Added "fileobjects" to PyMISP; updated PyMISP and stix2 refs. [Georges
  Toth]
- Add Pipfile and Pipfile.lock. [Georges Toth]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Wip: [enrichment] Removed debug calls. [chrisr3d]

  - Before having new modules fully operational, let
    us at least not keep only 2 debugs within an
    exposed function
- Merge pull request #4425 from mokaddem/improvedSubmoduleDiagnostic.
  [Andras Iklody]

  Improved submodule diagnostic
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4419 from RichieB2B/ncsc-nl/sql-cleanup. [Andras
  Iklody]

  Be consistent in quoting table names
- Be consistent in quoting table names. [Richard van den Berg]
- Merge pull request #4421 from andir/2.4-linotp. [Andras Iklody]

  new: WIP LinOTP authentication
- Merge pull request #4420 from RichieB2B/ncsc-nl/misp-wipe-update.
  [Andras Iklody]

  Update misp-wipe
- Wipe new SQL tables in misp-wipe. [Richard van den Berg]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Raphaël Vinot]
- Merge branch 'feature/assetloader' into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4416 from tom564/patch-1. [Steve Clement]

  Fix blank $PATH_TO_MISP
- Fix blank $PATH_TO_MISP. [tom564]

  Move  PATH_TO_MISP=${PATH_TO_MISP:-$(locate MISP/app/webroot/index.php|sed 's/\/app\/webroot\/index\.php//')} outside of if statement checking if manual input is required otherwise is only executed if locate is unable to determine path.
- Merge pull request #4413 from iwitz/2.4. [Steve Clement]

  fix: allow x-frames in apache configs
- Merge pull request #4410 from 4ekin/fix-i18n. [Steve Clement]

  Fix i18n in controllers, views, Attribute model
- Update WarninglistsController.php. [Steve Clement]

  Added more __()
- Update WarninglistsController.php. [Steve Clement]

  typo
- Wip: [enrichment] Added javascript function to fetch all elements from
  the view. [chrisr3d]
- Wip: [enrichment view] Displaying multiple additional fields.
  [chrisr3d]

  - Object ID of the object containing the attribute
    which was used to query the module is displayed,
    if it is this attribute is part of an object
  - Displaying Object meta-category and uuid as well
  - Multiple displaying arragements
  - Redefinition of some classes to help finding
    every element of the form
- Add: [enrichment] Added MISP Objects distribution in the view.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4390 from couchuser12345/couchuser12345-patch-1.
  [Steve Clement]

  Add updateUser to default config
- Add updateUser to default config. [couchuser12345]
- Merge pull request #4408 from iwitz/patch-6. [Steve Clement]

  add: RHEL7 php-gd installation
- Add: php-gd installation. [iwitz]
- Merge pull request #4411 from obert01/fix-iconlinks-accessibility.
  [Andras Iklody]
- Accessibility: added roles and aria labels for many icons and icon
  links (server list, tags, users, roles, attributes, ...) [Olivier
  BERT]

  There is still much work to be done. But we are on the road.

  Ideally, and in order to avoid code dupplicates, we should have some utility functions to generate a proper and accessible yes/no icon, an accessible icon link, etc. This would prevent the code from being filled with "aria-label" tags, since the "title" and "aria-label" properties are nearly always the same.
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Add: [freetext import] Added disable_correlation checkbox. [chrisr3d]

  - We can now disable correlation on attributes from
    the resolved attributes view
- Wip: [enrichment view] Reordered different elements and classes.
  [chrisr3d]

  - Making the next step iterations easier
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Wip: [enrichment view] Displaying Object References information.
  [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' into i18n. [Steve Clement]
- Merge pull request #4387 from mokaddem/prefillQB. [Andras Iklody]

  Prefill the restclient querybuilder when picking a saved query
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch 'thumbnail' into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into thumbnail. [mokaddem]
- Merge pull request #4392 from SteveClement/tools. [Andras Iklody]

  chg: [diag] Added a more dynamic way for submodule version status.
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge branch '2.4' of https://github.com/MISP/MISP into 2.4.
  [chrisr3d]
- Merge pull request #4252 from mokaddem/sightingFiltering. [Steve
  Clement]

  Sighting filtering
- Merge branch '2.4' of github.com:MISP/MISP into sightingFiltering.
  [mokaddem]
- Merge branch '2.4' into i18n. [Steve Clement]
- Merge branch '2.4' into i18n. [Steve Clement]


v2.4.105 (2019-03-28)
---------------------

New
~~~
- [diagnostic] Fetch submodules git status. [mokaddem]
- [export] Replaced the old non-cached export page. [iglocska]

  - uses restsearch
  - similar UI to the cached exports
- [UI] FA5 update finalised. [iglocska]

  - includes helpers to untangle the branded icon mess
- [UI] disable threat level from the UI based on a server setting, fixes
  #4359. [iglocska]

  - bye shitty deprecated field
- [UI] Move to FA 5. [iglocska]

Changes
~~~~~~~
- [version] bump. [iglocska]
- [diagnostic] Added reload button for submodules git status. [mokaddem]
- [diagnostic] Changed submodule header table text. [mokaddem]
- [submodules] added skeleton for submodules git status - WiP.
  [mokaddem]
- Additional Russian translation. [4ekin]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [UI] explain the authkey's source in the new server view, fixes #4368.
  [iglocska]
- Bump PyMISP (test case bug) [Raphaël Vinot]
- Add details when the ACLs are broken. [Raphaël Vinot]
- Bump warninglists. [Raphaël Vinot]
- Bump pymisp (improve test cases) [Raphaël Vinot]
- Bump pymisp (more details in test cases) [Raphaël Vinot]
- Bump PyMISP - tests for #4355. [Raphaël Vinot]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]

Fix
~~~
- [security] Fix to a reflected XSS in the default layout template.
  [iglocska]

  - as reported by Tuscany Internet eXchange | Misp Team | TIX CyberSecurity
- [stix import] Fixed issues with additional namespaces. [chrisr3d]

  - Using a list where any additional namespace can
    be added
  - Catching any missing additional namespace with
    the return code '4' raised in case of namespace
    not found error
- I18n fixed in Views and updated default.pot. [4ekin]

  Updated default.pot file according Views and Controllers changes
  Updated Views with i18n issues
- [enrichment view] Avoid displaying empty fields. [chrisr3d]
- Fixed i18n string representation and android logo. [4ekin]

  Fixed i18n string representation in views:
  * Diagnostics
  * Files
  * Tabs
  Fixed android icon dissapear in workers tab.
- Fixed i18n string representation in Server Controller and Model.
  [4ekin]
- [stix export] Fixed tlp markings that were obscurly set to a wrong
  value in some cases. [chrisr3d]

  - Setting incident handling object correctly
  - Avoid using distribution levels to set tlp color
- [sync] Adding a new server caused the pull/push rules to be
  incorrectly set to an empty string over '[]' causing sync issues,
  fixes #4369. [iglocska]

  - this fix resolves the issue - new servers added should be fine
  - it also retroactively fixes broken server connections
- [enrichment view] Fixed typo. [chrisr3d]
- [enrichment] Fixed results handling function name typo. [chrisr3d]
- [ACL Component] Added new function (for new modules format) in the
  list. [chrisr3d]
- [bug] Fixed a bug that caused attributes not to save via the UI.
  [iglocska]
- [UI] Inconsistend pluralisation fixed, fixes #4360. [iglocska]
- [UI] Remvoed broken edit org button for admins, fixes #4358.
  [iglocska]
- Fixed i18n string representation in Views. [4ekin]

  Fix for a plenty of Views with incorrect localizations (only English
  text shown)
- Fixed i18n string representation in Controllers. [4ekin]

  Fixed i18n string representation (flash and exception messages) in
  controllers:
  * OrganisationController
  * RolesController
  * TaxonomiesController
- [API] fixed adding malware-samples unencrypted with the encrypt key
  set, fixes #4355. [iglocska]

Other
~~~~~
- Merge pull request #4337 from mokaddem/submoduleDiagnostic. [Steve
  Clement]

  Submodule diagnostic
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge pull request #4381 from 4ekin/fix-i18n. [Steve Clement]

  Fix i18n in Views and updated default.pot
- Merge pull request #4350 from 4ekin/russian_translation. [Steve
  Clement]

  chg: additional Russian translation
- Merge pull request #4373 from 4ekin/fix-i18n. [Andras Iklody]

  Fix i18n and Android icon in workers
- Merge pull request #4370 from obert01/fix-matrix-submit-btn-
  accessibility. [Andras Iklody]

  Make the submit button focusable (tabindex) in the matrix view.
- Make the submit button focusable (tabindex) in the matrix view. This
  is necessary  for use with screen readers. [Olivier BERT]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Wip: [enrichment view] Displaying sharing group distribution if
  needed. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Wip: [enrichment view] Test returning data from the new form.
  [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Wip: [enrichment view] Made IDS, comment and distribution changeable.
  [chrisr3d]

  - Applied on each attribute and object attribute
    returned as part of the module results
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge pull request #4351 from 4ekin/fix-i18n. [Andras Iklody]

  Fix i18n in Controllers and Views


v2.4.104 (2019-03-21)
---------------------

New
~~~
- [cluster] Display heatmap on the Att&ck Matrix for all tagged data.
  fix #4344. [mokaddem]
- [tagging] Stop pre-populating forms for tagging / attaching of
  galaxies. [iglocska]

  - avoids any potential CSRF issues, the form is fetched just in time for the submission
- [galaxyMatrix] Added possibility to pick a galaxy to view it's
  statistic. [mokaddem]
- [Required taxonomies] [iglocska]

  - Flip taxonomies into required mode to ensure that events cannot be published without at least one tag from each required taxonomy to be set
- [REST client] Added history/bookmarks. [iglocska]
- [DistributionGraph] Added pie chart on sharing group. fix #4101.
  [mokaddem]
- [galaxies] Allow deleting full galaxies. [iglocska]
- [exercises] Added a new setup script for configuring exercise
  infrastructures rapidly. [iglocska]

  - assumes a hub MISP and a set of training MISPs for different participating teams
  - This script is to be executed on the hub MISP and assuming a consecutively incrementing numeric component in the training MISPs' URL it will pre-configure them
  - each instance has to have the same API key for the site admin (the idea is to clone training VMs)

  - configuration creates users, organisations, sync users, sync connections across both the hub and the individual trainee instances
  - Just copy /var/www/MISP/app/Console/Command/training.default.json to /var/www/MISP/app/Console/Command/training.json and configure it to get started
- [Feeds] New overlap tool finished. [iglocska]

  - compare a feed against a combination of feeds/servers to find if you can cover the contents with a combination of other cached feeds
- [Feeds] Implementation of the feed coverage tool (WIP) [iglocska]
- [API] Add pagination related parameters to event index, fixes #4270.
  [iglocska]

Changes
~~~~~~~
- [version] bump. [iglocska]
- Bump PyMISP. [Raphaël Vinot]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [statisticsMatrix] Improved redirection URL. [mokaddem]
- [db script] version bump. [iglocska]
- Updated comments. [mokaddem]
- [distributionNetwork] Prevent interactive picking in event index.
  [mokaddem]
- [distributionNetwork] Improved consistency in event index and improved
  UX - WiP. [mokaddem]
- [distributionNetwork] Added missing JS. [mokaddem]
- [distributionNetwork] Integration with event index - WiP. [mokaddem]
- [distributionGraph] Added bar chart and deferred distribution data
  fetching process. [mokaddem]
- [distributionGraphNetwork] Improved sharing accuracy. [mokaddem]
- [distributionGraphNetwork] Adjusted gravitationalConstant and mass.
  [mokaddem]
- [distributionGraph] Improved UI and added close button. [mokaddem]
- [distributionGraph] Added description on blocked distribution edge.
  [mokaddem]
- [distributionGraph] Added possibility to focus on an organisation.
  [mokaddem]
- [distributionGraph] Show `event is empty` if the event is empty.
  [mokaddem]
- [distributionGraph] Added interactive plotting feature. [mokaddem]
- [distributionGraph] Pin node after drag. [mokaddem]
- [distributionGraph] Added support of sharing group - WiP. [mokaddem]
- [distributionGraph] Continuation of integration, basic distribution is
  supported - WiP. [mokaddem]
- [distributionGraph] Started advanced distribution view. [mokaddem]
- [distributionGraph] Replaced all tabs by spaces. [mokaddem]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [Training] Further cleanup and interactive mode. [iglocska]

  - splitting of some nastier unreadable functions
  - added interactive mode
- [REST] Disable all SSL validation if requested by the user. [iglocska]
- [REST] Disable all SSL validation if requested by the user. [iglocska]
- [Training script] Improvements. [iglocska]

  - Create reverse sync accounts/link on demand
  - Create admin users for the player teams on demand
  - Some minor fixes
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [cakephp version] bump. [iglocska]
- [training] Some additional changes. [iglocska]
- [training script] Added server indication. [iglocska]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [i18n] Various updates to translations, most notably French is at 100%
  again. new: [i18n] Added initial Swedish and Polish translations chg:
  [i18n] Updated default.pot. [Steve Clement]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [feeds] removed broken MISP feed. [Alexandre Dulaunoy]
- [feeds] inThreat feed removed as it's no longer available. [iglocska]
- [tasks] anchor typo fixed. [Alexandre Dulaunoy]
- [warning-lists] updated to the latest version. [Alexandre Dulaunoy]
- [taxonomies] updated to the latest version (LS19 exercise) [Alexandre
  Dulaunoy]
- [tools] misp-restore updates. Still WIP. Not working ATM. [Steve
  Clement]
- [tools] Various changes to the misp-backup script to make it more
  stable. Still WIP. [Steve Clement]
- [workers] Worker start script has initial support to only restart the
  workers that are not running. [Steve Clement]

Fix
~~~
- [tools] Fixed empty variable check function. [Steve Clement]
- [stix2 export] Fixed comma typo. [chrisr3d]
- [stix2 export] Support of previous versions of python that are more
  restrictive with arguments syntax. [chrisr3d]
- [exports] Fixed copy pasta fail breaking the cached exports.
  [iglocska]
- [enrichment] Set distributions & sgs for all the possible views.
  [chrisr3d]
- [enrichment] Fixed variable name typo. [chrisr3d]
- [freetext] Stop parsing dates as phone numbers. [iglocska]
- [bro] typo fixed that caused an exception, fixes #4343. [iglocska]
- Added missing view. [mokaddem]
- [taxonomies] Counts fixed. [iglocska]
- [ACL] fixed. [iglocska]
- [Galaxy:update] Cast GalaxyElement into a String Ensuring the correct
  type before the insertion. [mokaddem]
- [ACL] Fixed ACL. [iglocska]
- [rest client] Made the links more obvious. [iglocska]
- [enrichment] Fixed $event variable handling + monkey typo. [chrisr3d]
- [diagnostics] search field removed from worker tab. [iglocska]
- [Training] Some clarifications. [iglocska]
- [Training] Function extraction fail. [iglocska]

  - Shame. Shame. Shame.
- [Training] Invalid user input capture fixed. [iglocska]
- [distributionNetwork] Added a threshold on the number of organisation
  that can be displayed a time. Will need some more love later on.
  [mokaddem]
- [ACL] Whitelisted `genDistributionGraph` [mokaddem]
- [disitributionNetwork] Empty cached org on redraw. [mokaddem]
- [distributionGraph] Transform associative array into regular array.
  [mokaddem]
- [distributionGraph-network] fixed sharing group singleton. [mokaddem]
- [distributionGraph:network] Only use sharing group part of the event.
  [mokaddem]
- [distributionGraph] Org's name with spaces can be focused. [mokaddem]
- [training] Added created sync users to the reporting. [iglocska]
- [enrichment] Added missing data field in attribute in case of
  attachement type attribute. [chrisr3d]
- [eventFiltering] quickfilter on value does not filter on wrong
  category anymore. [mokaddem]
- [Training] Interesting link. [iglocska]

  - Someone just told us about fmylife.com - if this day continues like this I might have to post there about the development
- [training] Inverse conditional fixed. [iglocska]
- [Training] Duplicate user add handling. [iglocska]
- [Training] Handle sync connections failing to be saved better.
  [iglocska]
- [training] Small fix. [iglocska]
- [training] fixes to the org creation. [iglocska]
- News View add, index and Controller (flash messages i18n bug. [4ekin]
- Admin User index, view, edit i18n bug fix: User view i18n bug. [4ekin]
- Attributes index wrong ditribution field fix: Logs search bug i18n
  fix: Organisations index bug i18n. [4ekin]
- Merge issue chg: Russian translation. [4ekin]
- [Training] Cause I'm a lumberjack and I'm ok. [iglocska]
- [Training] AAARGH. [iglocska]
- [training] Further work on the script. [iglocska]
- [training] Allow for self signed certs. [iglocska]
- [training] Siplified key management. [iglocska]
- [Training] Further fixes. [iglocska]
- [training script] Added some resilience to prior partial executions.
  [iglocska]
- [training] Fixes based on failed executions. [iglocska]
- [training script] Case sensitivty fixed. [iglocska]
- [training script] verbose mode added. [iglocska]
- [training script] Minor fixes. [iglocska]
- [training] training setup script now correctly handles settings.
  [iglocska]
- [UI] Removed input field from form where it's not applicable.
  [iglocska]
- [API] resetting the authkey didn't respond with the new key before,
  making automation difficult. [iglocska]
- [object references] Fixed an issue with the reference type not being
  loaded correctly. [iglocska]
- ['rest client'] Python script generator fixed. [iglocska]
- [export] cached exports for bro were broken. [iglocska]

  - bro still hasn't been migrated to restsearch
  - the exception for this in the caching algorithm called the wrong function
- [tools] misp-restore works a little better... still WiP. [Steve
  Clement]
- [i18n] Stray file removed. [Steve Clement]
- [UI] Missing org logos added to statistics -> organisations page,
  fixes #4271. [iglocska]
- More filter element i18n bug. [4ekin]
- Events index filter button i18n bug. [4ekin]

Other
~~~~~
- Merge pull request #4349 from SteveClement/tools. [Steve Clement]

  fix: [tools] Fixed empty variable check function
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge pull request #4346 from mokaddem/matrixOnGalaxyLevel. [Andras
  Iklody]

  new: [cluster] Display heatmap on the Att&ck Matrix for all tagged data.
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Wip: [enrichment view] First version of the view for objects &
  attributes returned from misp modules. [chrisr3d]

  - Visualization atm
  - Submit button + related actions to come soon
  - Possible changes on visual aspects to come too
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4308 from mokaddem/galaxyMatrixStat. [Andras
  Iklody]

  Galaxy matrix statistics available for eligible galaxy
- Merge branch '2.4' of github.com:MISP/MISP into galaxyMatrixStat.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4342 from liviuvalsan/bug_fix_bro_export. [Andras
  Iklody]

  Fixing bug when exporting to Bro MISP attributes from events that contain a percentage sign inside the event info
- Fixing bug when exporting to Bro MISP attributes from events that
  contain a percentage sign inside the event info. [Liviu Valsan]
- Merge branch 'kafka' into 2.4. [iglocska]
- Publish events to Kafka. [Nikos Filippakis]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4341 from
  liviuvalsan/attribute_performance_improvements. [Andras Iklody]

  Addressing performance issues for fetching attributes when blocking attributes via proposals
- Addressing performance issues for fetching attributes when blocking
  attributes via proposals. [Liviu Valsan]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Add: [enrichment view] Added side menu indications. [chrisr3d]

  - Same as for Freetext results.
  - Replacing freetext results when no simplified
    format is returned as module result
  - Actual results view coming soon
- Wip: [enrichment] Handling module results and passing it to the view.
  [chrisr3d]

  - Work in progress on the view right now
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4313 from pettai/RPZexport. [Andras Iklody]

  Add $time for Plugin.RPZ_serial
- Add $time for serial. [frpet]

  Add $time for generating unixtime as serial
- Merge branch 'extendedDistributionGraph' into 2.4. [mokaddem]
- Merge pull request #4309 from mokaddem/extendedDistributionGraph.
  [Alexandre Dulaunoy]

  Improvement on distribution visualization
- Merge branch '2.4' of github.com:MISP/MISP into
  extendedDistributionGraph. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into
  extendedDistributionGraph. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into
  extendedDistributionGraph. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into
  extendedDistributionGraph. [mokaddem]
- Merge remote-tracking branch 'origin/2.4' into
  extendedDistributionGraph. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Wip: [enrichment] Capturing attributes & objects returned by modules.
  [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4293 from 4ekin/russian_translation. [Steve
  Clement]

  fix: Merge issue
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4299 from nikofil/zmq_flag_fix. [Andras Iklody]

  Fix checking of incorrect flags when publishing to ZMQ
- Fix checking of incorrect flags when publishing to ZMQ. [Nikos
  Filippakis]

  * Check Plugin.ZeroMQ_event_notifications_enable instead of Plugin.ZeroMQ_attribute_notifications_enable in Event.php
  * Check Plugin.ZeroMQ_audit_notifications_enable instead of Plugin.ZeroMQ_user_notifications_enable in Log.php
  * Check Plugin.ZeroMQ_object_notifications_enable instead of Plugin.ZeroMQ_attribute_notifications_enable in MispObject.php
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Wip: [hover enrichment] Started changing hover enrichment as well.
  [chrisr3d]

  - As for enrichment modules, it does not change
    the support of the current modules, and should
    not interfere with them either
- Wip: [enrichment] Started changing enrichment modules. [chrisr3d]

  - Passing full attributes to the new modules
  - No changes for the currently used modules
  - Using a parameter to specify which format to use
  - Current format used if no parameter is set
  /!\ WIP, more to be updated soon /!\
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge pull request #4285 from SteveClement/tools. [Steve Clement]

  chg: [tools] More work on misp-restore, still WiP but a little more functional
- Merge branch '2.4' into tools. [Steve Clement]
- Merge pull request #4276 from SteveClement/i18n. [Steve Clement]

  chg: [i18n] Various updates to translations, most notably French is at 100% again.
- Merge branch '2.4' into i18n. [Steve Clement]
- Merge branch '2.4' into i18n. [Steve Clement]
- Merge branch '2.4' into i18n. [Steve Clement]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4275 from RichieB2B/ncsc-nl/workers-stop. [Andras
  Iklody]

  Add workers stop script
- Add workers stop script. [Richard van den Berg]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4266 from RichieB2B/ncsc-nl/fix-sys-path. [Andras
  Iklody]

  Add correct PyMISP_dir to sys.path
- Add correct PyMISP_dir to sys.path. [Richard van den Berg]
- Merge pull request #4265 from obert01/fix-index-accessibility. [Andras
  Iklody]

  Event index: Aria label properties on view/edit/publish/delete links …
- Event index: Aria label properties on view/edit/publish/delete links
  for better consistancy accross screen readers and accessibility
  standards compliance. [Olivier BERT]
- Merge pull request #4262 from 4ekin/fix-wrong-i18n. [Andras Iklody]

  fix: Events index filter button i18n bug
- Merge pull request #4263 from SteveClement/tools. [Steve Clement]

  chg: [Tools] misp-backup/-restore improvements, quality of life improvements of worker start.sh


v2.4.103 (2019-03-04)
---------------------

New
~~~
- Added ldapEmailField example and exaplanation. [iwitz]
- Add ldapEmailField config option. [iwitz]

  The ldapEmailField option can be used to specify different fields in which email addresses of Kerberos-authenticated users can be found. If this option is not used, it defaults to the 'mail' field, which makes it compatible with old configurations.
- [API] exposed change_pw function to the API, fixes #4256. [iglocska]
- [installer] Added tests. [Steve Clement]
- [cli] Added getWorkers to cake Admin Shell. It returns a JSON with the
  status of the current workers. [Steve Clement]
- Add tests after install. [Raphaël Vinot]
- [eventview] Shows number of object in the event. [mokaddem]
- [UI] Rework of the attribute index toolbar on the event view.
  [iglocska]
- [UI] Added quickfilter for the server settings. [iglocska]

  - no more **** around trying to find the right settings!
- [UI] Further work on the server settings UI. [iglocska]

  - overview reworked
  - some minor adjustements
- [UI] Reworked the sharing group add/edit tool. [iglocska]
- [UI] rework of the server settings. [iglocska]
- [UI] Updated the server preview index to follow the new tab UI
  standards. [iglocska]
- [UI] Refactored the feed preview index UI to the new tab system.
  [iglocska]
- [Feed preview UI] Added quick filter to the MISP feed preview.
  [iglocska]
- [UI] Added javascript to support the index filtering. [iglocska]
- [UI] Tied the index filter system into all indeces. [iglocska]

  - WIP: Event view
- [UI] Added new system to template index filters. [iglocska]
- [setting] Use the new setting to set the urls to the current instance
  on sharing groups when pushing the info via the API. [iglocska]
- [setting] Added new setting to set external baseurl. [iglocska]

  - idea is to decouple the baseurl (used to prepend links) from the announce baseurl (for sharing groups / emailing)
- [Rest client] Download results as file. [iglocska]
- [API] restsearch returns more information about the export system used
  via headers. [iglocska]
- [eventFiltering] Added support of toIDS. [mokaddem]
- [eventFiltering] Added support of server and feed hits filtering.
  [mokaddem]
- [eventView] Attribute filtering tool - WIP. [mokaddem]
- Add pre-pagination result count to headers. [Hannah Ward]

  Fixes #4161
- [galaxies] Added support of `kill_chain_order` in galaxies. [mokaddem]
- [matrix] Replaced the Att&ck matrix by a generic matrix viewer,
  allowing custom matrix to be displayed. Also added the external id to
  the chosen input. [mokaddem]
- Add CORS settings for external integration. [Hannah Ward]
- [UI] Moved the global menu to the new system. [iglocska]
- [UI] Added templates for the new global menu system. [iglocska]
- [installer] Added progress bar and spinner. [Steve Clement]
- [installer] Added function to build the installer. [Steve Clement]
- [installer] Generic support functions. [Steve Clement]
- [installer] Initial scaffolding and notice about upcoming installer
  scripts. [Steve Clement]
- [UI] Finished refactor of the side menu. [iglocska]
- [UI] side menu post link element added. [iglocska]
- [CLI] verbose mode added to runUpdates. [iglocska]
- [Tag API] New tag search api to search for tags. [iglocska]

  - simply pass the value you want to search for. Use % for wildcards
  - case insensitive
  - taxonomy and galaxy metadata returned with tag
- [CLI] execute all db updates to bring MISP up to date with any
  changes. [iglocska]

  - mimics logging in via the UI
- [UI] Further refactoring to use the modern meta table UI. [iglocska]
- [UI] metaview refactor. [iglocska]

  - event view uses the new parametrised system
  - massive reduction of weird custom UI stuff to prepare MISP for a move to bootstrap 4
  - should fix the dodgy UI issues that @rommelfs was experiencing on his Playmobil laptop
- [API] Log search API now allows for last style time ranges using the
  created field. [iglocska]
- [UI] Added change tracking sparkline to the event view. [iglocska]
- [tools] Experimental tool to upgrade MISP via GitHub. [Steve Clement]

Changes
~~~~~~~
- [version] bump. [iglocska]
- Remove debug. [mokaddem]
- Reduce complexity of authenticate function. [iwitz]

  * create function getEmailAddress to reduce the complexity of the authenticate function
  * fix indentation of comments in the authenticate function
- [installer] Shortened usr-local-src checker. Added better curl install
  example. [Steve Clement]
- Bump PyMISP to 2.4.103. [Raphaël Vinot]
- [ReST interface] fix typo in label. [Alexandre Dulaunoy]
- [galaxy_matrix] Added submit button again to please.. they will
  recognize themselves. [mokaddem]
- [installer] Level installer. [Steve Clement]
- [doc] One more line to make SSL a little more secure. [Steve Clement]
- [doc] Some formatting for the apache conf files and some incentives to
  be more secure by default. [Steve Clement]
- [doc] Added small apache hardening tip chg: [installer] regenerated
  installer. [Steve Clement]
- [installer] Do not try and initialize mysql if the user table exists
  new: [installer] Nuke an instance. [Steve Clement]
- [installer] Make php versions more flexible if not 7.2. [Steve
  Clement]
- [recommended versions] Added note on deprecating PHP 7.1 and Python
  2.7. [iglocska]
- Bump PyMISP, new object templates, fix failing tests. [Raphaël Vinot]
- Bump PyMISP, again. [Raphaël Vinot]
- Bump PyMISP. [Raphaël Vinot]
- [UI] Event index icons switched to FA in preparation of the BS4 move.
  [iglocska]
- [objects] updated to the latest version. [Alexandre Dulaunoy]
- [installer] Updated script to use systemd for workers and modules.
  [Steve Clement]
- [doc] Bumped Kali version, updated misp-modules startup way, CentOS
  typo fix. [Steve Clement]
- [tools] misp-workers.service need to be able to be installed on a
  stick MISP install (Ubuntu) other flavours want to be marked as such.
  (and in a seperate directory, ideally, etc/systemd/system) chg:
  [tools] Backup script todo added chg: [tools] worker start script todo
  and fix me added. [Steve Clement]
- [attribute row] to_ids flag edition is done with a checkbox + prompt.
  [mokaddem]

  Previously, was a select.
- [quickEdit UI] Does not resize a column anymore. [mokaddem]
- [PyMISP] updated to the latest version. [Alexandre Dulaunoy]
- [eventMatrix] Added description of the cluster title and set default
  score to 0. [mokaddem]
- [UI] Highlight scope toggle if scope is selected. [iglocska]
- [taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [PyMISP] updated to the latest version. [Alexandre Dulaunoy]
- Added a dot and sanitization of the id. [mokaddem]
- [eventIndex] When clicking on the correlation count in the event
  index, filter the viewed event with `correlation only` [mokaddem]
- [UI] added icon for background workers. [iglocska]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [querystring] bumped. [iglocska]
- [cleanup] Junk removed. [iglocska]
- [UI] nav tabs ontop of lists should be able to display custom titles
  on hover. [iglocska]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [PyMISP] updated to the latest version. [Alexandre Dulaunoy]
- [internal] Allow the quickfilters to work on URLs that include more
  than just the baseurl+controller+action. [iglocska]
- [CS] indentation. [iglocska]
- [doc] Move Debian9 stable install instructions to xPerimental status
  as only Python 3.5 is supported by default but PyMISP needs 3.6 (There
  are no easy clean ways to install >3.5) chg: [installer] various
  changes and cleanups in the installer. [Steve Clement]
- [installer] Parsed installer update. [Steve Clement]
- [doc] Minor OpenBSD 6.4 tweaks (works again now ;) [Steve Clement]
- [installer] Make installer more verbose again, some output is actually
  needed. [Steve Clement]
- Update hover UI. [wagena]

  - add some logic to choose better hover placement
  - make hover hide on outside click, to allow using the scrollbar to view
  full hover
  - add an icon in the hover tooltip to turn it into a popup
  - move popup close button to better position
  - group attributes for each module in hover UI
  - prevent duplicate enrichment api queries once the first one is done
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [cleanup] removed unused template. [iglocska]
- [eventFiltering] Added support of feed and server while filtering
  objects. [mokaddem]
- [eventFiltering] IU/UX Improvements. [mokaddem]
- [tags] Improved perfs on tag retrieval (all tags belonging to an
  event) [mokaddem]
- [eventFiltering] Started integration of tag filtering - WiP.
  [mokaddem]
- [eventFiltering] Prevent multiple `searchFor` entries. [mokaddem]
- [eventfiltering] Added more sanitization. [mokaddem]
- [eventFiltering] Prepend base url. [mokaddem]
- [eventFiltering] display the number of active rules. [mokaddem]
- [eventFiltering] Improved detection of advanced filtering. [mokaddem]
- [eventFiltering] Simplified filtering conditions and fixed `deletion`
  proposal layout. [mokaddem]
- [eventFiltering] First version on the event filter tool. [mokaddem]
- [eventFiltering] WIP - UI displays all elements. [mokaddem]
- [eventFiltering] WIP - Simplified filtering conditions. [mokaddem]
- [eventFiltering] WIP - fixed filtering bugs and improved warning
  filtering. [mokaddem]
- [eventFiltering] WIP -Improved filtering and UI. [mokaddem]
- [eventFiltering] WIP - Integrating new filtering behavior into Model.
  [mokaddem]
- [eventFiltering] Bumped flag skip_empty. [mokaddem]
- [eventFiltering] Moved searchFor to the top. [mokaddem]
- [eventFiltering] Improved UI - WIP. [mokaddem]
- [eventFiltering] Improved UI and added filter link. [mokaddem]
- [eventFiltering] Improved filtering tool - WIP. [mokaddem]
- [eventFiltering] renamed file. [mokaddem]
- [eventView] moved attribute filtering tool in its own file. [mokaddem]
- Simplified condition 2. [mokaddem]
- Simplified condition. [mokaddem]
- [galaxy_matrix] TEMPORARY - Merge scores of both deprecated and mitre-
  attack galaxy namespace for the matrix view. [mokaddem]

  This commit aims to still have correct scores in the galaxy_matrix until the fixMitreTags functions is not live and running
- [generic_picker] added an icon to show that a galaxy will trigger the
  matrix galaxy picker. [mokaddem]
- [galaxy] json_encode kill_chain_order in beforeValidate. [mokaddem]
- [galaxy_matrix] renamed view_matrix into view_galaxy_matrix.
  [mokaddem]
- [galaxy_matrix] cleanup in variable names to be more generic.
  [mokaddem]
- Removed test code. [mokaddem]
- Deleted (now useless) attack matrix view. [mokaddem]
- [galaxies] Updated view to support `kill_chain_order` [mokaddem]
- [attackMatrix] Improved layout + fixed bug (carret on scale do not go
  out of bound anymore) [mokaddem]
- [attackMatrix] UI: improved color scale - WiP. [mokaddem]
- [attackMatrix] Updated the matrix to match the changes in the mitre
  galaxies and improved layout - WiP. [mokaddem]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- Security warning at step 5. [iwitz]
- [installer] Added missing final Install script. [Steve Clement]
- [kali] Final kali tests done. [Steve Clement]
- [kali] Last tweaks to make sure all deps are present. [Steve Clement]
- [installer] Added checkLocale. [Steve Clement]
- [kali]  undo evil hack, sleep a while, maybe the disable sleep
  interferes with the execution of the script. [Steve Clement]
- [kali] Make sure redis-server is installed early. [Steve Clement]
- [installer] More fixes to the installer, mostly kali. [Steve Clement]
- [m2m] Added libcaca for faup. [Steve Clement]
- [installer] Considered Web Installer option new: [installer] Added
  ssdeep. [Steve Clement]
- [installer] mail2misp typo. [Steve Clement]
- [installer] Nicer end. [Steve Clement]
- [installer] First working version. [Steve Clement]
- [installer] Make sure the template engine is called correctly chg:
  [installer] If we su to MISP_USER, make sure we are not already.
  [Steve Clement]
- [installer] Minor tweak. [Steve Clement]
- [installer] Pre-Install place holder. [Steve Clement]
- [installer]  Added more documentation chg: [kali] Fixed /usr/local/src
  perm issue. [Steve Clement]
- [installer] -A considered. [Steve Clement]
- [installer] Moved some dependencies around. [Steve Clement]
- [installer] First version of potentially working installer. [Steve
  Clement]
- [kali] More fixes. [Steve Clement]
- [kali] added venv. [Steve Clement]
- [kali] A new kali install locks APT, added progressive sleep. [Steve
  Clement]
- [kali] Installer wants to wait until apt is released chg: [installer]
  Update from template. [Steve Clement]
- [installer] Ran template, commiting changes. [Steve Clement]
- [installer] Minor tweaks. [Steve Clement]
- [installer] Added autognerated script and template. [Steve Clement]
- [installer] Symlink to template. [Steve Clement]
- [doc] More fixes to installer builder. [Steve Clement]
- [doc] Temporary installer workaround. [Steve Clement]
- [doc] Search and replace vars. [Steve Clement]
- [doc] Added more details on how to stitch the file together. [Steve
  Clement]
- [doc] Added missing file. [Steve Clement]
- [doc] Move some code out of the doc and into a file chg: [installer]
  Moved all the scripts into respective snippet tags. [Steve Clement]
- [doc] More shuffling around to make it more logical chg: [installer]
  More cake tweaks, misp-modules grouping. [Steve Clement]
- [installer] Various tweaks and functionizing stuff. [Steve Clement]
- [installer] Main install script wants to pull in all function
  depenecies. Please avoid to source shell scripts somewhere else, it
  breaks overview. [Steve Clement]
- [installer] Misp global vars. [Steve Clement]
- [installer] Seperated dependencies for php 7.3 and 7.2. [Steve
  Clement]
- [installer] Added some known Debian based falvours. [Steve Clement]
- Remove unnecessary settings. [iwitz]
- Set apache as files owner. [iwitz]

  this is to be able to update through the web interface
- Update software versions. [iwitz]
- [refactor] Side menu generic templates moved. [iglocska]
- [UI] Some modifications to the side menu link element. [iglocska]
- Test url for proxy. [iwitz]

  this way the check works even if only github is whitelisted by the web proxy
- [doc] license for the logos added. [Alexandre Dulaunoy]
- Add stix2 installation. [iwitz]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [Tag search API] now also accepts synonyms as input. [iglocska]
- [documentation] Added new CLI function to automation page. [iglocska]
- Improved setup bug workaround. [iwitz]
- Update php version warning. [iwitz]
- No more assumption that only 1 shell is used. [iwitz]

  scl enable was used in step 3 to make php, mysql and redis available in a new shell and during the rest of the installation process it was assumed that the same shell was used. The steps are a bit less interdependent now.
- Add index to all commands. [iwitz]

  this is useful when only some steps apply to a particular environment
- Tell people to *not* use this document. [Raphaël Vinot]
- Bump PyMISP. [Raphaël Vinot]
- [internal] Moved time resolution to appmodel. [iglocska]
- [objects] misp object templates updated to the latest version.
  [Alexandre Dulaunoy]
- [PyMISP] Bump version. [Raphaël Vinot]
- [generic_picker] Prevents multiple useless redrawing. [mokaddem]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [tools] Made it a little more universal. [Steve Clement]

Fix
~~~
- [API] hacky fix to capitalisation issues between the old /events/index
  camelcased parameters and the newer lowercased one, fixes #3855.
  [iglocska]
- [grammar] Pluralisation fixed for the freetext import results, fixes
  #4021. [iglocska]

  - Sunday last minute commit aced
- [installer] Tests should now run correctly chg: [m2m] Added more
  functions to faup. [Steve Clement]
- [API] Allow adding objects without having the correct template via the
  API fixed. [iglocska]
- [installer] Installer will never execute due to misplaced ; [Steve
  Clement]
- [installer] Minor install fix. [Steve Clement]
- [installer] Various fixes of missing dependencies. [Steve Clement]
- [vulnerability] Fixes a vulnerability where a user can view sightings
  that they should not be eligible for. [iglocska]

  - requires access to the event that has received the sighting
  - affects instances with restrictive sighting settings (event only / sighting reported only)

  - as reported by Tyler McLellan of CanCyber.org
- RunTests method was totally broken. [Raphaël Vinot]
- [UI] Contributors - file left off. [iglocska]
- [UI] Contributor list fixed. [iglocska]
- [feed] Feed pulls don't update the timestamp of the event. [iglocska]

  - affects freetext feeds
  - this blocks the further propagation of the modifications
- [ACL] added toggleToIDS. [iglocska]
- [generic_picker] fix #4219 (Adding ObjectReference) [mokaddem]
- [docs] added object template update CLI command to the automation
  page. [iglocska]
- [API] Attribute edit error response fixes, #4221. [iglocska]
- [UI] show object UUID via the UI. [iglocska]
- [performance] Massive performance bug resolved for taxonomy tag
  selector. [iglocska]
- [UI] Fixed exclamation point for critical alerts in server settings.
  [chrisr3d]
- Typo parameter. [mokaddem]
- [UI] Fixed issues with the eventattribute tabs, fixes #4211.
  [iglocska]
- [UI] Worker tab missing in diagnostic tool. [iglocska]
- [UI] Invalid requirements passed to scaffolding system in regards to
  the show attribute context button. [iglocska]
- [UI] Another switch to FA. [iglocska]
- [UI] Switched to FA for the warning icons on the attribute values.
  [iglocska]
- [correlation UI] Fixed an issue where the cache contained correlations
  to a feed/server that is no longer in the DB. [iglocska]
- [enrichment] UI errors fixed when no modules are enabled. [iglocska]

  - also fixed the weird indentation
- [UI] Don't show the filter bar in the server settings where it
  wouldn't do any good. [iglocska]
- [UI] Fix add object menu item. [iglocska]

  - make the scaffolding system aware of the possibility that "this" might get passed along to javascript
- [UI] Side menu missing the update warninglists button. [iglocska]
- [UI] Alignment issue resolved on the user view. [iglocska]
- [UI] Fixed a bug in the UI that caused the event filtering to break.
  [iglocska]
- [UI] Pass the server ID to the view for the menu's consistency.
  [iglocska]
- [DB] removed not null constraint of the kill chain order field, fixing
  4198. [iglocska]
- Object could not be added with no full group by enabled, fixes #4195.
  [iglocska]
- [installer] unary operator... chg: [installer] dirty notes in pre-
  flight check function. [Steve Clement]
- [installer] small fix to check if dmidecode is present. [Steve
  Clement]
- Fixed list regex menu option, fixes #4197. [iglocska]
- [UI] New thread button fixed. [iglocska]
- [UI] Terms and conditions &amp; removed from button. [iglocska]
- [UI] Add sharing group button removed if no permissions present.
  [iglocska]
- [UI] trash icon was black on black on event multi delete. [iglocska]
- [stix2 import] Fixed marking parsing to avoid trying to add None.
  [chrisr3d]
- [UI] side menu truncated settings in the global actions scope.
  [iglocska]
- [SMIME] Formating issues resolved. [iglocska]
- [API] Invalid URL parameter suggested in rest client templates for the
  attribute edit endpoint, fixes #4159. [iglocska]
- [UI] Logout fixed. [iglocska]
- [eventview] too many arguments. [mokaddem]
- [massEdit] UI bug in the synonyms. [mokaddem]
- [distributionGraph] restaured filtering capabilities. [mokaddem]

  Broken since the new event filtering tool
- [eventFiltering] Removed debug commands. [mokaddem]
- Do not increment count after DB query. [Hannah Ward]
- Expose x-result-count to CORS. [Hannah Ward]
- [matrix_score] get values regardless of the galaxy. [mokaddem]
- [UI] UI monkey cannot z-index. [iglocska]
- Re-add CORS headers on REST Response. [Hannah Ward]
- [galaxy] prevent drawing view when galaxy_cluster does not exist.
  [mokaddem]
- [merge] added forgotten file... [mokaddem]
- [doc] gitchangelo from pip now works un Python 3.7 as expected chg:
  [doc] Tried to have a more or less clean new Changelog in docs. [Steve
  Clement]
- [installer] Variable typo for Base URL chg: [installer] Renamed
  installCoredDeps. [Steve Clement]
- [installer] Various changes to where we output messages. [Steve
  Clement]
- [installer] More kali fixes and some ubuntu tweaks. [Steve Clement]
- [installer] Kali was missing maec. [Steve Clement]
- [installer] Kali still had bugs. Most fixed. [Steve Clement]
- [installer] Various fixes for depency installs. [Steve Clement]
- [installer] Options setting now works. [Steve Clement]
- [kali] Various kali fixes to make it install in unattended mode fix:
  [installer] Various fixes to the installer. [Steve Clement]
- [kali] On kali, some times apt is locked, we need to consider that.
  [Steve Clement]
- [installer] Viper is stuborn. [Steve Clement]
- [installer] Updated main installer fix: [doc] Viper can be installed
  with Python3.7. [Steve Clement]
- [installer] fix typo. [Steve Clement]
- [installer] -ne (== NOT EQUAL != NOT EXIST Grr...) [Steve Clement]
- [installer] Added apt update for Kali, fixed some ifs' [Steve Clement]
- [installer] fix typo. [Steve Clement]
- [UI] post links broken in the side menu. [iglocska]
- [UI] removed org would throw notice errors if they are still contained
  in a sharing group. [iglocska]

  - a situation that should not occur without tampering that is normal on a dev instance anyway, but just in case
- [UI] Fixed extended by field. [iglocska]
- Rhel7 diagnostics page detection. [iwitz]
- Working directory in update function. [iwitz]

  fixes a path problem mentioned in issue #3528
- [UI] Fixed menu linking for change_pw action. [iglocska]
- [CS] tab fixes. [iglocska]
- [CS] indentation fix. [iglocska]
- [UI] Potential fix for the weird popover behaviour. [iglocska]
- [UI] restored user menu when viewing a user's profile as admin.
  [iglocska]
- Typo in tag ID query. [Hannah Ward]
- [Feeds API] blackholes due to invalid csrf check relaxation call.
  [iglocska]
- Bugfix of event info not shown when MISP.showorgalternate is on.
  [Christophe Vandeplas]
- [UI] Trailing \ removed from org names on the event index. [iglocska]
- [API] Galaxies still present as Tag in JSON export fixes #4133.
  [Christophe Vandeplas]
- [style] consistent space indentation. [Christophe Vandeplas]
- [ACL] tags/search added to the ACL. [iglocska]
- Do not use obsolete rc.local init file. [iwitz]
- [stix import] Fixed detection of observable_composition objects.
  [chrisr3d]

  - Was sometimes passing the text even if no observable
    composition object was actually defined, because an
    observable object can have the observable_composition
    attribute even when it has no actual value
- [stix 1&2 import] Using local version of PyMISP & MISP Objects.
  [chrisr3d]

  - So the PyMISP part will not depend on the version
    installed with pip anymore
  - Need also to specify the MISP Objects path because
    it is not available from PyMISP subdirectories
- Lief installation. [iwitz]

  * unnecessary steps removed
  * irrelevant comment removed
  * instructions updated to compile lief for python 3.6 instead of 2.7
  * install lief in the folder where the other dependencies are so that it is detected by the diagnostics page
- Grammar. [iwitz]
- [API] Events add/edit return correct error code on failure. [iglocska]
- [stix export] Support of deprecated python versions. [chrisr3d]
- [UI] org view with domain restrictions had a layout breaking long key.
  [iglocska]
- [restsearch] download as a first parameter should default to json.
  [iglocska]
- [UI] event view UUIDs capitalised. [iglocska]
- [UI] title of org images fixed. [iglocska]
- [ui] Safari.... [iglocska]
- [UI] lol. [iglocska]
- [UI] UI experts at work. [iglocska]
- [UI] small fix. [iglocska]
- [ui] small fix. [iglocska]
- [ui] small fix. [iglocska]
- Disable stix test with PyMISP on travis. [Raphaël Vinot]
- [generic_picker] fix #4083. When picking, force exact match (instead
  of `contains`) [mokaddem]
- [ui] small ui fix. [iglocska]
- [stix2 export] Fixed attribute counting on restSearch. [chrisr3d]
- [php min version] Bumped to 7. [iglocska]

  - not enforced yet

Other
~~~~~
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #3827 from MISP/fix3819. [Steve Clement]

  Allow getting object attribute via rest query. fix #3819
- Allow getting object attribute via rest query. fix #3819. [mokaddem]
- Merge pull request #3589 from iwitz/add-email-field-option-for-
  kerberos-authentication. [Steve Clement]

  Add email field option for kerberos authentication
- Merge branch '2.4' into add-email-field-option-for-kerberos-
  authentication. [Steve Clement]
- Merge pull request #3658 from ancailliau/issue-3639. [Steve Clement]

  Fixes issue #3639
- Fixes issue #3639. [Antoine Cailliau]
- Merge pull request #4259 from SteveClement/guides. [Steve Clement]

  chg: [installer] Various updates including PyMISP tests
- Merge pull request #4243 from raw-data/2.4. [Alexandre Dulaunoy]

  [add] MalSilo feeds tracking commodity malware
- [add] MalSilo feeds tracking commodity malware. [raw-data]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4250 from SteveClement/tools. [Steve Clement]

  new: [cli] Added getWorkers to cake Admin Shell. It returns a JSON with the status of the current workers.
- Merge remote-tracking branch 'upstream/2.4' into tools. [Steve
  Clement]
- Merge pull request #4249 from SteveClement/guides. [Steve Clement]

  chg: [installer] Added tests
- Merge pull request #4248 from SteveClement/guides. [Steve Clement]

  chg: [installer] Various updates to the installer. Also tested towards latest Ubuntu 18.04.2
- Merge branch '2.4' into guides. [Steve Clement]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4237 from Rafiot/install_tests. [Andras Iklody]

  new: Add tests after install
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4230 from SteveClement/guides. [Steve Clement]

  new: [installer] Update installer to make use of systemd service units
- Merge pull request #4229 from SteveClement/tools. [Steve Clement]

  chg: [tools] Various updates to CLI tools
- Merge branch '2.4' into tools. [Steve Clement]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4203 from eCrimeLabs/2.4. [Andras Iklody]

  Update defaults.json (Phishtank - Exclude through regex)
- Updated defaults.json. [eCrimeLabs]

  Bugfixed Phishtank
- Update defaults.json. [eCrimeLabs]

  Updated Phishtank feed with regex to exclude Phishtank url's
  \/^http:\\\/\\\/www.phishtank.com\/i
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4202 from obert01/fix-tag-search. [Andras Iklody]

  Fixed search for cluster value in /tags/search
- /tags/search was only looking for cluster synonyms, but not in cluster
  values. [Olivier BERT]
- Merge pull request #4201 from bartblaze/2.4. [Alexandre Dulaunoy]

  Update README.md
- Update README.md. [Bart]

  * Several small fixes
  * Add Zeek (new Bro name)
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4194 from gallypette/hotfixGlobalMenuSeparator.
  [Andras Iklody]

  Fix #4193 GlobalMenuSeparator not checking Roles
- Fix #4193 GlobalMenuSeparator not checking Roles. [Jean-Louis Huynen]
- Merge pull request #4187 from RichieB2B/patch-5. [Alexandre Dulaunoy]

  Fix errors in TagCollections import
- Fix errors in TagCollections import. [Richie B2B]
- Merge pull request #4185 from SteveClement/guides. [Steve Clement]

  chg: [doc] Move Debian9-stable install instructions to xPerimental
- Merge branch '2.4' into guides. [Steve Clement]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4183 from DomainTools/update-hover-ui. [Alexandre
  Dulaunoy]

  chg: Update hover UI
- Fix Useless assignment to local variable. [wagena]
- Fix missing variable declaration. [wagena]
- Merge branch '2.4' into update-hover-ui. [wagena]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4169 from RichieB2B/patch-4. [Alexandre Dulaunoy]

  Fix broken "List Tags" link
- Fix broken "List Tags" link. [Richie B2B]
- Merge pull request #4076 from mokaddem/eventFiltering. [Alexandre
  Dulaunoy]

  Event filtering tool
- Merge branch '2.4' of github.com:MISP/MISP into eventFiltering.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into eventFiltering.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into eventFiltering.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into eventFiltering.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into eventFiltering.
  [mokaddem]
- Merge remote-tracking branch 'origin/2.4' into eventFiltering.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into eventFiltering.
  [mokaddem]
- Merge branch '2.4' into eventFiltering. [mokaddem]
- Merge pull request #4165 from MISP/bugfix/x-result-count. [Andras
  Iklody]

  [fix] Correct X-Result-Count
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4164 from MISP/tempoparyFixMatrixStat. [Alexandre
  Dulaunoy]

  Tempopary fix galaxy_matrix heatmap (mitre-attack)
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4158 from MISP/bugfix/disappearing-cors-headers.
  [Andras Iklody]

  fix: re-add CORS headers on REST Response
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge pull request #4156 from mokaddem/udpatedMatrix. [Alexandre
  Dulaunoy]

  Improved Att&ck Matrix
- Merge branch '2.4' of github.com:MISP/MISP into udpatedMatrix.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into udpatedMatrix.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into udpatedMatrix.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into udpatedMatrix.
  [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge pull request #4157 from MISP/feature/cors-options-request.
  [Andras Iklody]

  new: Add CORS settings for external integration
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4155 from iwitz/patch-5. [Andras Iklody]

  RHEL7 installation security warning at step 5
- Merge pull request #4152 from SteveClement/guides. [Steve Clement]

  new: [installer] MISP has now an Install Script for Ubuntu 18.04 - 18.10 and Kali
- Merge branch '2.4' into guides. [Steve Clement]
- Merge branch '2.4' into guides. [Steve Clement]
- Merge pull request #4146 from hackunagi/2.4. [Alexandre Dulaunoy]

  Fix on folder with misp.local.key
- Merge pull request #2 from hackunagi/hackunagi-patch-1. [Carlos
  Borges]

  Fixing folder with misp.local.key
- Fixing folder with misp.local.key. [Carlos Borges]

  ### Work environment

  | Questions                 | Answers
  |---------------------------|--------------------
  | Type of issue             | Documentation Update
  | OS version (server)       | CentOS
  | OS version (client)       | Ubuntu, ...
  | PHP version               | 7.1
  | MISP version / git hash   | 2.4
  | Browser                   | If applicable

  ### Expected behavior
  Follow procedures to install, with no errors.

  ### Actual behavior
  Error to create ssl keys, while following procedures.
  The steps to create openssl private keys on line 335 point to file in /etc/pki/tls/certs/misp.local.key, while later in line 338 it looks for file in /etc/pki/tls/certs/misp.local.key.


  ### Steps to reproduce the behavior


  ### Logs, screenshots, configuration dump, ...
- Merge pull request #1 from MISP/2.4. [Carlos Borges]

  Merge to original MISP repository
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4136 from iwitz/fix-rhel7-diagnostics-page.
  [Andras Iklody]

  Fix rhel7 diagnostics page
- Merge pull request #4147 from iwitz/patch-3. [Andras Iklody]

  fix: working directory in update function
- Merge pull request #4149 from iwitz/patch-4. [Andras Iklody]

  Update software versions in RHEL7 installation procedure
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4139 from iwitz/patch-1. [Andras Iklody]

  Change test URL for proxy
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4138 from obert01/warning-icon-fix. [Andras
  Iklody]
- Accessibility: added aria properties for the warning list icon, which
  was not visible for screen readers. [Olivier BERT]
- Merge pull request #4140 from iwitz/patch-2. [Andras Iklody]

  Add STIX2 installation to RHEL7 installation procedure
- Merge pull request #4137 from MISP/bugfix/tag-rest-edit-incorrect-id.
  [Andras Iklody]

  fix: Typo in tag ID query
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4128 from iwitz/add-systemd-unit-rhel7. [Steve
  Clement]

  chg: [RHEL7] Add systemd unit file in installation procedure
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Add: [diagnostic] Added check for STIX2 python library. [chrisr3d]
- Merge pull request #4123 from czechnology/2.4. [Andras Iklody]

  Add LDAP network timeout
- Add LDAP network timeout. [Martin Kulhavy]
- Merge pull request #4121 from iwitz/remove-centos-install-step. [Steve
  Clement]

  Remove CentOS step in RHEL7 installation procedure
- Remove centos step. [iwitz]

  The instruction to enable the SCL repos is already provided in step 1.4,
  and the package centos-release-scl does not exist on RHEL7. The fact
  that step 1.4 may not work on a trial subscription is not relevant
  because assumptions 0.1 and 0.2 specifically state that a support
  agreement is required to be able to complete the installation.
- Merge pull request #4118 from iwitz/fix-rhel7-lief-installation.
  [Steve Clement]

  Fix RHEL7 lief installation instructions
- Merge pull request #4125 from iwitz/fix-scl-shell. [Andras Iklody]

  RHEL7 installation fix implicitly SCL-enabled commands
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4117 from kara-1234/patch-2. [Andras Iklody]

  Allow HTTPD to send Emails
- Allow HTTPD to send Emails. [kara-1234]

  Update to allow httpd to send emails.
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Raphaël Vinot]
- [stix2] Bumped stix2 python library latest updates. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Revert "fix: [UI] small fix" [iglocska]

  This reverts commit 1c8d725f8ddaeaab7384faf104c83db2fa7741be.
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]


v2.4.102 (2019-02-01)
---------------------

New
~~~
- [kali] Added debug function and breakpoints. [Steve Clement]
- [doc] Initial MISP with Letsencrypt doc. [Steve Clement]
- [installer] Initial bash installer functions. [Steve Clement]
- [doc] moved kali script to generic debian installer script. [Steve
  Clement]
- [CLI] Server settings refactored, fixes #4074. [iglocska]

  - moved most of the codebase to the model
  - streamlining of the setting change
  - hooked the callback system into the CLI version of the setter
- [sighting] Searching for attributes allows to add sightings on the
  attribute id or value. [mokaddem]
- [objectReference] Usage of the generic_picker for improved UX.
  [mokaddem]
- [dependencies] Added CryptGPG and a dependency thereof to the INSTALL
  dir. [iglocska]

  - workaround for the pear.php.net pwnage
- [Tag collections] Export/import tag collections added. [iglocska]

Changes
~~~~~~~
- [version] bump. [iglocska]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [installer] Added more comments and implemented base parameter logic.
  [Steve Clement]
- [datamodel] me being stupid. [Alexandre Dulaunoy]
- [datamodel] anonymised updated. [Alexandre Dulaunoy]
- [datamodel] second step validation for anonymised attribute type.
  [Alexandre Dulaunoy]
- [datamodel] anonymised is any category. [Alexandre Dulaunoy]
- [doc] Copyright dates updated. [Alexandre Dulaunoy]
- [PyMISP] updated to the latest version. [Alexandre Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [kali] Major rewrite of install script. [Steve Clement]
- [doc] Added CentOS vs. RHEL note. [Steve Clement]
- [doc] script name change. [Steve Clement]
- [doc] pear needs root permissions as it is installed to /usr/lib.
  [Steve Clement]
- [doc] Partially fixed Centos 7 install procedure. Now uses https by
  default. [Steve Clement]
- [doc] Remove update-alternatives, dumb idea to change default Python,
  for now. [Steve Clement]
- [doc] Added initial misp-modules cake sugar. [Steve Clement]
- [doc] Added symlink to generic debian installer for bward compat.
  [Steve Clement]
- [restsearch] Improvements to the restSearch APIs to function better
  with URL parameters. [iglocska]

  - fixed returnFormat for events/restSearch
  - added page and limit to the list of parameters
- [sightings] Hover sighting UI improvement. [iglocska]
- [feed correlations] Don't attach feed correlations to attributes that
  have correlations disabled. [iglocska]
- [PyMISP] updated to the latest version. [Alexandre Dulaunoy]
- [type] zeek attribute added (Zeek is the new name of Bro) [Alexandre
  Dulaunoy]

  Both attribute types, zeek and bro will coexist as exchange of NIDS
  rules under the old names is common in various MISP sharing communities.
- [sighting] Added generic hovering support for `openPopover` + added
  support of this feature for sightings. [mokaddem]
- [org view] show creation/modification times. [iglocska]
- [rest] Bumped `sighting/add{values}`` documentation. [mokaddem]
- Bump PyMISP. [Raphaël Vinot]
- [generic_picker] Improved the way option templates/data are passed to
  the view (now done by JS only) [mokaddem]
- [generic_picker] Improved memory usage + use of sprintf. [mokaddem]
- [galaxy clusters] selectCluster function opened up to the API for
  reasons. [iglocska]
- [doc] add standard MISP logo in SVG format. [Alexandre Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [documentation] Added the description of URL parameters to the
  automation page. [iglocska]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- Pump PyMISP, use pipenv in travis. [Raphaël Vinot]
- [eventIndex] replaced tag HTML node from <span> to <a> [mokaddem]

  So that it indicates that cliking on the tag triggers an action (search
  in this case), but also to be consistent UI-wise

  Part of the project: ~ Making Deborah happy! ~
- [generic_picker] Prevent decoding if additionalData is not set.
  [mokaddem]
- Deleted useless commented line. [mokaddem]
- [generic_picker] fixed icon path and added more resilience in case of
  resizing. [mokaddem]
- [layouts] Removed doT.js dependency (not needed anymore) [mokaddem]
- [generic_picker] Improved UI. [mokaddem]
- [ObjectReference] this was bugging me.. [mokaddem]
- [generic_picker] Improved UI. [mokaddem]
- [generic_picker] improved layout. [mokaddem]
- [generic_picker] added support of infoExtra for pills. [mokaddem]
- [generic_picker] moved sanitization to views. [mokaddem]
- [generic_picker] all view using the generic_picker now use the
  generic_picker view elements - WIP. [mokaddem]
- [generic_picker] use php generic_picker elements for constructing the
  template server side. - WIP. [mokaddem]

  Previously, it was done client side
- [doc] Fix kali script, php7.2 was used by apache. Add reference to
  mkdocs depency. [Steve Clement]
- [doc] Added gengeric update section update Debian testing for new
  stix2. [Steve Clement]
- [i18n] Updated: Czech 4%, Danish 53%, German 21%, French 95%, Italian
  39%, Japanese 95%, Korean 3%, Brazilian Portuguese 6%, Spanish 3% new:
  [i18n] Hungarian, Russian, Ukrainian, Simplified Chinese. [Steve
  Clement]
- [composer] composer.json updated. [iglocska]
- [query] Query string bump. [iglocska]

Fix
~~~
- [restsearch] CSV special parameters added to the URL parameters.
  [iglocska]
- [stix 1&2 export] Switched attachment parameter to make it work.
  [chrisr3d]

  - When using the url to query restSearch, withAttachements
    is the correct parameter to use instead of includeAttachements
    which works btw well with the rest Client anyway
- [eventGraph] Adding relation via the graph correctly pick the correct
  element in the confirm modal. [mokaddem]
- [proposal] Repaired deletion proposal (db save) [mokaddem]
- [proposal] Repaired deletion proposal. [mokaddem]
- [stix 1&2 export] Using the restSearch API instead of the old download
  one. [chrisr3d]
- [kali] updated composer chksum. [Steve Clement]
- [installer] Fixed a bug when run on kali. [Steve Clement]
- [stix export] Monkey typo. [chrisr3d]
- [stix export] Fixed malware samples (within file objects) parsing.
  [chrisr3d]

  - Depending if there is the attachment or not
- [deprecated stix export] fixed, parameters weren't correctly taken
  into account. [iglocska]

  - affects /events/stix
- [API] Use restresponse to view an added event via /events/add.
  [iglocska]
- [Tagging] MITRE galaxies fixing function. [Christophe Vandeplas]

  This function still needs to be called from an upgrade script.
- [redirect on login] Fixed an issue where ajax queries would store
  their URL in the redirect URL field. [iglocska]
- Check also event.org_id when validating event ownership in order to
  fetch attributes. [Patrizio Tufarolo]

  Fixes #1918
- [Tagging] Tagging an element with multiple tag collection works as
  expected. [mokaddem]

  Previously, it would only add the latest tag collection
- [sighting] Bug adding sightings on every attributes. [mokaddem]

  When trying to add a sighting to a value via the REST API,
  if a value was given to the key `values` instead of an array,
  the Model function `addSighting` would *crash* and skip the condition on
  the value, consequently adding a sighting on every attributes.
- [UI] Popover gets closed correctly if button clicked twice. reuse
  generated popover id instead of one-side generation. [mokaddem]
- [tagging] attachTagToObject wasn't updating the timestamp of the
  target object. [iglocska]
- [description] setSetting CLI command description fixed. [iglocska]
- [api] attirbutes/restSearch forced json format by mistake, fixes
  #4064. [iglocska]
- [redirect] Correctly redirect to the requested URL after a login,
  fixes #4005, fixes #1301. [iglocska]
- [events ui] fix to the event view pagination reseting sorting, fixes
  #4058. [iglocska]
- [sightings] Re-added advanced sightings to the search results.
  [iglocska]
- [Model] Fixed includeAttachments parameters for stix 1&2 export.
  [chrisr3d]
- [internal] Fetching galaxies broken into atomic queries to avoid
  massive parameter lists. [iglocska]
- [automation] Clarification of the different timestamp parameters.
  [iglocska]

  - we missed describing the input formats
- [API] removed invalid parameter lookup. [iglocska]
- [API] Fixed the handling of AND-ed and OR-ed URL parameters.
  [iglocska]
- [Model] Added disable_correlation flag to the attributes of the
  original imported file object. [chrisr3d]
- [stix import] Updated one condition test to avoid failing with Custom
  Objects. [chrisr3d]
- [stix import] Removed unexpected print. [chrisr3d]
- [stix import] Quick variable cleanup. [chrisr3d]
- [stix import] Importing data frfom malware-sample single attributes.
  [chrisr3d]
- [stix import] Importing malware-sample attributes and their data
  fields within File objects. [chrisr3d]
- [stix import] Fixed syntax typo issue. [chrisr3d]
- [stix export] Exporting malware-sample value within the corresponding
  observable. [chrisr3d]

  - In case the malware-sample values are not the
    same as the filename & md5 ones in the object
- [attribute] Prevent undefined index on tag filtering. [mokaddem]

  As tags are popped from the attribute scope first, they will not be
  available in the event scope.
- [restsearch] Added returnformat to URL parameters. [iglocska]

  - attributes/restSearch was additionally missing the published filter
- [interna] deprecated text() function's tag filter fixed. [iglocska]
- [filters] Negative tag filters ignored event tags on the attriute
  search. [iglocska]

  - as reported by @hel10wor1d
- [copy-pasta] Oops. [iglocska]
- [stix] Missing data fields added to object malware samples. [iglocska]
- [stix export] Syntax quick fix. [chrisr3d]
- [ObjectReference] Making everyone happier. [mokaddem]
- Mass edit and AttackMatrix work again on objectAttributes. [mokaddem]
- [stix export] Avoid loss of filename and md5 values in File object.
  [chrisr3d]

  - We take them from malware-sample value if they do not exist
- [stix export] Faster & Shorter attributes dictionary creation
  function. [chrisr3d]
- [stix export] Removed not used additional param of the artifact object
  creation function. [chrisr3d]
- [stix export] Exporting data from malware-sample attributes in file
  objects. [chrisr3d]

  - Observable composition for the file object
  - Data in malware-sample attribute is exported as Artifact Object
  - The rest of the file rermains unchanged and exported as File
- [performance] query tweak to fool old crappy versions of mysql.
  [iglocska]
- [sighting] prevent ID collision in the UI. Sighting canvas is now
  correctly positioned regardless of the id. [mokaddem]
- [doc] The kali script should work again now. [Steve Clement]
- [stix import] Passing observable title to avoid None value on
  attachment attributes imported. [chrisr3d]
- [stix import] Fixed id fetching. [chrisr3d]
- [server correlation] Fixed broken correlation link on the event level.
  [iglocska]
- [UI] annoying empty event warning removed when filtering event
  attributes. [iglocska]
- [attribute warnings] financial warnings not showing up in the warnings
  tab. [iglocska]
- [gitmodules] updated. [iglocska]
- [stix2] added attachment inclusion to the download from stix2 UI
  element. [iglocska]
- [freetext import] Handle cases where a value can be both a hash and a
  btc address better. [iglocska]
- [performance] Potential performance fix for older MySQL versions using
  the wrong index as key during fetchAttributes() [iglocska]

  - observer a server prioritising the deleted flag index when filtering attributes, leading to a massive performance loss
  - hacky solution to make deleted and object_id (during flattening) indeces unusable
- [stix2 export] Fixed event labels fecthing. [chrisr3d]
- [stix2 import] Importing TLP Marking definition objects only.
  [chrisr3d]

  - Following the changes on export script
- [stix2 export] Faster tags handling function. [chrisr3d]

  - Compressed the function, removing some useless
    lines / variables
- [stix2 export] Exporting only TLP tags as MarkingDefinition.
  [chrisr3d]

  - The other tags are (as before a recent change)
    exported as labels

Other
~~~~~
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4075 from obert01/cluster-detach-accessibility.
  [Andras Iklody]
- Accessibility: Added ARIA properties on the "detach" button for
  clusters. [Olivier BERT]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge pull request #4073 from SteveClement/guides. [Steve Clement]

  chg: [installer] Added more comments and implemented base parameter logic
- Add: [datamodel] anonymise type added. [Alexandre Dulaunoy]

  Anonymised value - described with the anonymisation object via a relationship

  Anonymisation object definition: https://www.misp-project.org/objects.html#_anonymisation
- Merge pull request #4071 from SteveClement/guides. [Steve Clement]

  chg: [kali] Major update to Kali Install script
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Revert "fix: [API] Use restresponse to view an added event via
  /events/add" [iglocska]

  This reverts commit 66037a36c55c66d4d2fe41f71619bc79e27dfdc5.
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #3995 from patriziotufarolo/2.4. [Andras Iklody]

  fix: check also event.org_id when validating event ownership in order to fetch attributes. Fixes #1918
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge pull request #4053 from Rafiot/pipenv. [Raphaël Vinot]

  chg: Pump PyMISP, use pipenv in travis
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4049 from obert01/logs-accessibility-fix. [Andras
  Iklody]

  Accessibility fix in the Logs view
- Accessibility: Fixed the aria-label properties of the filter buttons
  in the Logs view. [Olivier BERT]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge pull request #4041 from mokaddem/UIObjectReferences. [Sami
  Mokaddem]

  Improved generic_picker and object references
- Merge branch '2.4' into UIObjectReferences. [mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4046 from SteveClement/guides. [Steve Clement]

  fix: [doc] Kali installer now working again
- Merge branch '2.4' into guides. [Steve Clement]
- Merge pull request #4037 from SteveClement/i18n. [Steve Clement]

  chg: [i18n] Updated and added Localizations
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Add: [stix framing] Added Artifact Object in  the list. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Update INSTALL.ubuntu1804.md. [Andras Iklody]
- Update INSTALL.debian9.md. [Andras Iklody]
- Update INSTALL.rhel7.md. [Andras Iklody]
- Added crypt_gpg alternate installer. [Andras Iklody]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #4033 from andreybolonin/patch-1. [Alexandre
  Dulaunoy]

  add php 7.3 to travis
- Add php 7.3 to travis. [Andrey Bolonin]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]


v2.4.101 (2019-01-20)
---------------------

New
~~~
- [feeds] Opened up feed inspection to host org users and added servers
  to overlap matrix. [iglocska]
- [remote caching] First release version of the remote caching.
  [iglocska]
- [server caching] Initial version WIP. [iglocska]
- [UI] PopoverConfirm now support shortcut (<ENTER>/<CTRL>+<ENTER> to
  submit and <ESC> to Cancel) [mokaddem]
- [attackMatrix] Added support of chosen in the ATT&CK Matrix.
  [mokaddem]
- [addObject] adding objects is done via the generic_picker. [mokaddem]
- [galaxy] Added bulk galaxy tagging. [mokaddem]
- [UI] generic_picker - WIP. [mokaddem]
- [cache export] Added the includeEventUuid flag to the output.
  [iglocska]
- [publishing] Unpublish function added. [iglocska]

  - users were jumping through hoops to unpublish an event
- [UI] disable attribute correlation during creation / modification.
  [iglocska]
- [config backup] Added logging and a second protective measure.
  [iglocska]

  - if the current config.php is hosed, don't start the backup process and overwrite the backup
- [galaxies] adding galaxies no longer needs a full refresh of the page.
  [iglocska]

  - use the new ajax function to get the galaxy information returned
- [galaxies] added new function to show galaxies in ajax queries.
  [iglocska]
- [tag collections] Add default tag collection per instance. [iglocska]
- [tag collections] First feature complete minimal version of the tag
  collection system. [iglocska]
- [tag collections] Added missing views. [iglocska]
- [tag collections] Renamed tagCollectionElement to tagCollectionTag.
  [iglocska]
- [tag collections] WIP. [iglocska]
- [WIP] tag collections WIP. [iglocska]
- [tag_collections] Added db upgrade. [iglocska]
- [Tag collections] Added boilerplate models. [iglocska]

Changes
~~~~~~~
- [remote cache] Further progress on caching remote instances.
  [iglocska]
- [tagging] Added more ordering while displaying results. [mokaddem]
- [Object] Added pre-choice of object meta-category. [mokaddem]
- [refactor] Slight refactor for getAttributesTags() [iglocska]
- [cleanup] Removal of duplicate code. [iglocska]
- [generic_popover] Pressing <ESC> destroy the popover. [mokaddem]
- Fixed LGTM JavaScript analysis alerts. [mokaddem]
- [refacto] removed useless code and views. [mokaddem]
- [css] indent. [mokaddem]
- [eventView] Replaced link by span. [mokaddem]

  So that the focus is not done when clicking on it
- [attackMatrix] removed useless view. [mokaddem]
- [UI] WIP - generic_picker improved title management of popover.
  [mokaddem]
- [UI] WIP - generic_picker remove popover on tag deletion. [mokaddem]
- [UI] WIP - generic_picker popover is attached to body. [mokaddem]

  Needed to add reference to the original node that toggle the popover
- [UI] WIP - generic_picker slightly improved tag template. [mokaddem]
- [UI] WIP - generic_picker replaced galaxy deletion alert by confirm
  popover. [mokaddem]
- [UI] WIP - generic_picker deleting tags uses popover. [mokaddem]
- [UI] WIP - generic_picker add warning message if number of option is
  to large. [mokaddem]
- [UI] WIP - generic_picker filter galaxies by synonyms. [mokaddem]
- [UI] WIP - generic_picker display expanded taxonomy info. [mokaddem]
- [UI] WIP - generic_picker added tag styling and additional data in
  option. [mokaddem]
- [UI] WIP - generic_picker automatically switch to submit pills if
  applicable. [mokaddem]
- [UI] WIP - generic_picker added custom chosen event to support
  redrawing after searches. [mokaddem]
- [UI] WIP - generic_picker prevnet drawing empty option. [mokaddem]
- [UI] WIP - generic_picker improved template (show more fields)
  [mokaddem]
- [UI] WIP - generic_picker added templating system for select options.
  [mokaddem]
- [tagging] WIP - bulk galaxy tagging on attribute and event. [mokaddem]
- [tagging] WIP - bulk tagging via generic picker on event and complete
  support for TagCollection. [mokaddem]
- [tagging] WIP - bulk tagging via generic picker on tag level.
  [mokaddem]
- [taxonomy choice] replace old popup view by the generic pre-picker.
  [mokaddem]
- [doc] Updated date of testing. [Steve Clement]
- [doc] Updated Ubuntu 18.04 install and all generic generic
  dependencies. [Steve Clement]
- [Taxonomy] disable (hide) tags when disabling parent taxonomy.
  [mokaddem]
- [galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [internal] timestamp resolution for time ranges should reorder the
  conditions. [iglocska]

  - always take from (smaller timestamp) to (larger timestamp), no matter the order which they were entered in
- [taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [UI] Added publish timestamp to the event view. [iglocska]
- [stix] Bumped latest version of cti-python-stix2. [chrisr3d]
- [PyMISP] updated to the latest version. [Alexandre Dulaunoy]
- [datamodels] fix hassh and hasshserver typo. [Alexandre Dulaunoy]
- [PyMISP] updated to the latest version (hassh-md5 and hasshserver-md5)
  added. [Alexandre Dulaunoy]
- [datamodels] new types hassh-md5 and hasshserver-md5 added. [Alexandre
  Dulaunoy]

  "HASSH" is a network fingerprinting standard which can be used
  to identify specific Client and Server SSH implementations.
  The fingerprints can be easily stored, searched and shared
  in the form of an MD5 fingerprint.

  Fix #4007
- [feeds] mirai.security.gives feed added. Fix #4009. [Alexandre
  Dulaunoy]
- [MISP objects] Bumped latest version. [chrisr3d]
- [stix2 import] Importing Marking Definition objects from STIX files
  generated with MISP. [chrisr3d]

  - Import of Marking Definition objects as tags
  - Import at attribute and event level
  - Import of Marking Definition objects from external STIX files at event
    level only
- [doc] Updated documentation about stix2 python library installation.
  [chrisr3d]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [stix2] Bumped latest cti-python-stix2 version. [chrisr3d]
- [stix2 export] Exporting tags as Marking Definition. [chrisr3d]
- [taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [cleanup] removed some more leftover junk. [iglocska]
- [cleanup] Removed obsolete CLI tasks. [iglocska]
- [automation] described feed previews via the API template system.
  [iglocska]
- [session] Added warning about setting the timeout to 0. [iglocska]
- [documentation] Added JSON structure update commands to CLI
  documentation. [iglocska]
- [refactor] Refactoed attachCluster to be more model agnostic.
  [iglocska]
- [tag collection tag] Renamed Model references in the codebase.
  [iglocska]
- [generic index] Fixed scoping issue with rows. [iglocska]

Fix
~~~
- [caching] Some minor fixes. [iglocska]
- [ACL] ACL updated. [iglocska]
- [AttackMatrix] Stopped comparing string with integer. [mokaddem]
- [generic_picker] avoid having option's name as an array key.
  [mokaddem]
- [generic_picker] hide div if `empty` is selected. [mokaddem]
- [tags] picking all tags removed galaxies in the picker. [mokaddem]
- [tag collections] Adding tags to tag collections fixed. [iglocska]
- [ACL] small ACL fix. [iglocska]
- [Tag collections] Fix case of several tag IDs being passed. [iglocska]
- [ACL] Restrict tag collection modification to tag editors. [iglocska]
- Added some more escaping. [mokaddem]
- [UI] prevent failing if generic_picker is not in a popover. [mokaddem]
- [JS] switch to local variable. [mokaddem]
- [App] Bump queryVersion. [mokaddem]
- [attackMatrix] do not throw an error for an edge case where the user
  did not have full permission. [mokaddem]
- [tagCollection] typo in variable name preventing addition of tag for
  non-admin users. [mokaddem]
- [massageTag] variable name collision causing tags to disappear.
  [mokaddem]
- [tagCollection] galaxies can be removed from tag collections.
  [mokaddem]
- [MassEdit] Prevent undefined clusters/tags if unset + enforce
  attribute perms. [mokaddem]
- [UI] generic_picker prevented nested redrawing. [mokaddem]
- [Unpublish] variable not set when not in event context (i.e.
  revise_object) [mokaddem]
- [internal] EventID filter now accepts uuid and ID correctly.
  [iglocska]
- [UI] notice error fixed for tag filters in attributes/search.
  [iglocska]
- [internal] Fixed uuid/id lookups not working on the attribute level.
  [iglocska]
- [UI] mismatched button class usage for discussions. [iglocska]

  - this was driving me nuts.
- [doc] Updated Kali scripts. [Steve Clement]
- [stix2 import] Fixed copy paste monkey 'self' missing error.
  [chrisr3d]
- Avoid ignoring stix2 scripts. [chrisr3d]
- [stix2 import] Fixed default event & attribute distribution values.
  [chrisr3d]
- [stix import] Fixed default event & attribute distribution values.
  [chrisr3d]
- [attribute search] Restore pivoting from attribute tag to the
  attribute search results. [iglocska]

  - contrary to the pre-API-refactor versions, inherited event tags are also taken into account
- [attribute search] Trigger the result screen instead of the search
  form if the tags parameter is provided via the URL in a GET request.
  [iglocska]
- [API] correctly handle custom delimiters in the filter builder.
  [iglocska]
- [stix2 import] Fixed imported galaxyCluster uuids. [chrisr3d]

  - Which are actually collection_uuids
- [stix2 export] Fixed GalaxyCluster uuid fetching. [chrisr3d]

  - Which is actually collection_uuid
- [stix2 import] Using a STIX2 object attribute instead of its
  dictionary format. [chrisr3d]
- [stix2 export] Fixed MISP tags parsing. [chrisr3d]

  - To support composite predicates
  - Also changed variable names to match with
    the actual tag part names
- [stix2 export] Fixed wrong variable name. [chrisr3d]
- [stix2 export] Parsing relationships at the end of the event.
  [chrisr3d]

  - Minor change only impacting the order of the STIX Objects
  - But cleaner code (relationship parsing code in a function)
- [event] attributes quick tagging. [mokaddem]

  scope used to be singular (attribute instead of attributes), it is know set accordingly
- Fixes javascript issue #3952. [Christophe Vandeplas]
- [eventView] restored bulk tagging feature. [mokaddem]

  Since the introduction of the tag collection, bulk tagging of items in
  the event view stopped working (Behavior of tag's view changed to use scoping instead
  of calculated variables in the tag's Controller)
- [stix2 export] Cleaned up the link attributes parsing. [chrisr3d]

  - Removed useless class attribute
  - Cleaned up the parsing code itself
- [stix2 import] Avoid error on fetching relationship by uuid.
  [chrisr3d]

  - Fixes an issue that did not put (for instance)
    Galaxies on attribute level within the attribute
    because of the uuid fetching error
- [stix2 import] Better parsing of external single attributes.
  [chrisr3d]

  - To parse relationships concerned by the attribute,
    at the same time, if needed
- [timeout setting] Fixed invalid cooke timeout name. [iglocska]
- [tag collections] Fixed hook to reload galaxies. [iglocska]
- [ACL] Added ajax function to ACL. [iglocska]
- Bumped cti-python-stix2 latest version. [chrisr3d]
- [api] editing organisation attributes, other than name. [Jan Skalny]
- [galaxies] Some minor fixes with the ajaxification. [iglocska]
- [galaxies] added new view that wasn't finished for the previous commit
  (stil WIP) [iglocska]
- [over-sanitisation] cleared up over-sanitised message in the events
  controller. [iglocska]
- [ACL] Added missing function. [iglocska]
- [tag collections] Fixed several bugs linking to the wrong tag
  collection when attaching them to an event/attribute. [iglocska]
- [tag collections] Fixed an issue where if a collection was added that
  already had all tags attached from before, the process would get stuck
  with no feedback to the user. [iglocska]
- [taxonomies] Tag list empty fixed. [iglocska]
- [data model] added the fix to the org_id field in the tag table to the
  mysql.sql file. [iglocska]
- [data model] fixed a bug that caused org_id fields to be tinyint(1)
  for org_ids on tags. [iglocska]
- [tag collections] fixed galaxies not showing up. [iglocska]
- [added missing controller] tag collections controller. [iglocska]
- [model linking] Made tag collection tag dependent of tag. [iglocska]
- [db update] Fixed update script for tag collection tags. [iglocska]
- [cleanup] removed tagCollectionElement. [iglocska]
- [js] Various fixes with adding/removing tags. [iglocska]

Other
~~~~~
- Merge branch 'features/server_caching' into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge branch 'UISelector' into 2.4. [mokaddem]
- Merge branch '2.4' into UISelector. [mokaddem]
- Fix/new: [attackMatrix] Attack Matrix works again + added support in
  tag collection. [mokaddem]
- New/fix: [MassEdit] Allow addition/deletion of tags and clusters on
  selected attributes + Lots of usage bug fixes. [mokaddem]
- [UI] generic_picker merged the pre_picker into the picker - WIP.
  [mokaddem]
- Merge pull request #4028 from SteveClement/guides. [Steve Clement]

  Guides
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge pull request #4020 from chkp-aliaksandrt/fix-issue-3977-tagged-
  attributes-search. [Andras Iklody]

  Fix of tagged attributes search
- Fix of tagged attributes search, displaying tag name instead of
  numeric Tag ID Closes #3977. [chkp-aliaksandrt]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge pull request #4018 from SteveClement/guides. [Steve Clement]

  fix: [doc] Updated Kali scripts.
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Add: [stix2 import] Importing Marking Definition objects from external
  STIX files at attribute level. [chrisr3d]
- Add: Added stix2 scripts subdirectory to gitignore. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [mokaddem]
- Merge pull request #3989 from cvandeplas/2.4. [Andras Iklody]

  fix: Fixes javascript issue #3952
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch 'tag_collections' into 2.4. [iglocska]
- Merge branch '2.4' into tag_collections. [iglocska]
- Add: [stix2 import] Added a  pattern type in the mapping. [chrisr3d]
- Merge pull request #3980 from JanSkalny/2.4. [Andras Iklody]

  fix: [api] editing organisation attributes, other than name
- Merge branch '2.4' into tag_collections. [iglocska]


v2.4.100 (2018-12-31)
---------------------

New
~~~
- [restClient] Added support of URL param in the querybuilder widget.
  [mokaddem]
- [restClient] Transform query to json, more descriptions and layout
  changes. [mokaddem]

  - Added a lightweight query parser to construct the JSON body from the query builder
  - Added more help text on API fields
  - Added help hoover on API fields (when applicable)
  - Added `optgroup` in template select
  - Slight CSS modification on the overall page
  - Changed behavior of template fetching (template existance is checked locally, do not wait before pulling the API info HTML)
- [rest client] added first draft of querybuilder widget. [mokaddem]
- [attributes] Add cdhash attribute, 40+ digit hash, default Payload
  delivery, ids=1 (#3965) [Daniel Roethlisberger]
- [eventview] value quickedit are triggered by clicking a button And no
  longer using double-click. [Sami Mokaddem]

Changes
~~~~~~~
- [version] bump. [iglocska]
- [objects] updated to the latest version. [Alexandre Dulaunoy]
- [PyMISP] updated to the latest version. [Alexandre Dulaunoy]
- [PyMISP] updated to the latest version. [Alexandre Dulaunoy]
- [PyMISP] updated to the latest version. [Alexandre Dulaunoy]
- [restClient] small css change. [Sami Mokaddem]
- [restClient] Still show help for nested parameters instead of
  crashing. [Sami Mokaddem]
- [restResponse] removed space in parameters. [Sami Mokaddem]
- Deleted comments. [Sami Mokaddem]
- [restClient] Do not show empty rule if builder shown after template
  picking. Reset the query builder rules if templates is not picked
  before showing the builder. [Sami Mokaddem]
- Re-indented view file. [Sami Mokaddem]
- [restClient] prevent usage of query builder if template not picked.
  [Sami Mokaddem]
- [restClient] added `show query builder` button. [Sami Mokaddem]
- [restClient] re-indented the whole file. [Sami Mokaddem]
- [restclient] moved all javascript into its own file. [Sami Mokaddem]
- [querybuilder] added new js dependencies (chosen, query-builder, doT,
  extendext and moment) [root]
- [querybuilder] injected tags are now injected by name instead of ID
  (allowing sql LIKE) [Sami Mokaddem]
- [Model] swapped openioc and json so that json is selected by default.
  [mokaddem]
- [rest client] re-ordered fields by alphabetical order. [mokaddem]
- [rest client] added some overwrite functions. [mokaddem]
- Bump PyMISP, again. [Raphaël Vinot]
- Bump PyMISP. [Raphaël Vinot]
- Bump PyMISP. [Raphaël Vinot]
- [taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- [PyMISP] updated to the latest version. [Alexandre Dulaunoy]
- [Objects] Sorts object references types in add reference form (#3969)
  [Christophe Vandeplas]
- [PyMISP] updated to the latest version. [Alexandre Dulaunoy]
- [misp-objects] updated to the latest version. [Alexandre Dulaunoy]
- [eventView] added quickEdit button for Category, Type and IDS fields +
  Changed IDS representation (from YES/NO to checkbox) [Sami Mokaddem]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [PyMISP] updated to the latest version. [Alexandre Dulaunoy]
- [UI] Clarify the definition of "hide_tag" to an unselectable tag.
  [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version (major update in Malpedia)
  [Alexandre Dulaunoy]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [eventView] applied quick-edit button for comment field. [Sami
  Mokaddem]
- [quickEditHover] change variable scope to local. [Sami Mokaddem]
- [eventGraph] added fail save if requiredOneOff is not set. [Sami
  Mokaddem]
- [WIP] added function meant to resolve id vs uuid issues for the UI
  attribute search. [iglocska]

  - still needs some love
- Bumped lastest cti-python-stix2 changes from our fork. [chrisr3d]
- [stix] Changed cti-python-stix2 submodule to our fork. [chrisr3d]
- [misp-galaxy] updated to the latest version. [Alexandre Dulaunoy]
- [taxonomies] updated to the latest version. [Alexandre Dulaunoy]
- Bump PyMISP recommended version. [Raphaël Vinot]
- [PyMISP] updated to the latest version. [Alexandre Dulaunoy]
- Bump PyMISP. [Raphaël Vinot]

Fix
~~~
- [cleanup] Fixed a few issues. [iglocska]

  - unnecesary access to controller from component fixed (load component instead)
  - confusion between private and public variables resolved
  - some minor fixes for rules
- [restClient] form submission is working again. was blackholed due to
  form tampering. [Sami Mokaddem]
- [ui] prevent glitchy popover by increasing item size. [Sami Mokaddem]
- [object references] Editing an event failed to save new object
  references. [iglocska]
- [expansion] Hover broken after pagination fixed. [iglocska]
- [stix2 export] Fixed number_of_sections field in STIX PE extenstion.
  [chrisr3d]

  - Avoiding issues when the section referenced in the
    MISP pe object is actually not in the event
- [stix2 export] Added required field pe_type in STIX PE extension.
  [chrisr3d]
- [stix2 export] Fixed GalaxyCluster UUID fetching. [chrisr3d]

  - Supporting the latest changes on UUID field name
    for Galaxy clusters
  - Still supporting the previous UUID field name in
    the case of a terminal execution, with a former
    version of Galaxy clusters
- [stix2 export] Some fixes on 'Attribute' ObjectReference key + missing
  self argument. [chrisr3d]
- [stix2 export] Removed not used function. [chrisr3d]
- [stix2 export] Added interoperability parameter to all created STIX
  objects. [chrisr3d]

  - In order to avoid crashes on MISP data generated via the STIX import
- [stix2 export] Fixed GalaxyCluster uuids key fetching. [chrisr3d]
- [tools] Fixes missing sort in the PyMISP describeTypes generation
  (#3966) [Christophe Vandeplas]
- [publishing] Fixed several bugs in the background job responsible for
  publishing events. [iglocska]
- [stix2 export] Fixed field name Attribute for ObjectReference
  checking. [chrisr3d]
- [stix 1&2 export] Checking if a referenced pe-section is indeed in the
  event before trying to parse it. [chrisr3d]
- [correlations] Invalid orgc loaded in the attribute level
  correlations, fixes #3948. [iglocska]
- Make IE11 compliant by adding startsWith polyfill. [Tom King]
- Make IE11 compliant by removing default param value from ES2015. [Tom
  King]
- Make IE11 compliant by removing default param value from ES2015. [Tom
  King]
- [CLI] usage output fixed for the server shell tasks. [iglocska]
- [sync] Fixed an incorrectly formatted event index output when
  minimal:1 is passed, breaking the sync pull. [iglocska]

  - ffs
- [server preview] fixed sharing groups linking to the equivalent ID
  sharing group on the local instance. [iglocska]
- [api] Fixed event index to include sharing group metadata. [iglocska]
- [Restresponse] fixed XML converter. [iglocska]
- [compatibility] reverted IE11 breaking change in misp.js, fixes #3939.
  [iglocska]
- [feeds] Fixed an issue that caused a misp format feed fetch to fail
  intermittently. [iglocska]
- [upload_analysis_file] Prevent object creation on non-existing events.
  [Sami Mokaddem]
- [eventGraph] Object's label gets set correctly Add both requiredOneOf
  and required (forgotten one) fields in the Object's label. [Sami
  Mokaddem]
- [sync] Issue with events not updating on a pull. [iglocska]

  - overzealous protection removed
  - Conditions blocking an event edit via a pull now rely on the locking mechanism, relaxed via an internal sync link
- [UI] hover size fixed and scroll bar added. [iglocska]

  - part of the keep @rommelfs happy project
- [stix import] Fixed parsing of Custom objects. [chrisr3d]
- [stix 1&2 import] Fixed version attribute of the original filename.
  [chrisr3d]
- [doc] Updated install guide to include the latest changes on STIX2
  python library. [chrisr3d]
- [stix2 import] Allowing import of STIX 2.0 documents that have non v4
  UUIDs. [chrisr3d]

  - Some further operations may be done on those UUIDs later
  - Atm, we (at least) avoid loading errors from the stix2 python library
- [API] Attribute tags could be added by 3rd parties via the API.
  [iglocska]

  - fixed
- [objecttemplates] fixes issue #3921. [Christophe Vandeplas]
- [API] tags/attachTagToObject wasn't unpublishing events correctly.
  [iglocska]
- [attachement] prevent creation of empty event. [Sami Mokaddem]
- [restSearch] Using the correct python version to call STIX scripts.
  [chrisr3d]

  - Using the correct python defined in virtual env,
    if available, and the default global python3
    otherwise

Other
~~~~~
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #3974 from eCrimeLabs/2.4. [Alexandre Dulaunoy]

  Update Attribute.php
- Update Attribute.php. [eCrimeLabs]

  Added ja3-fingerprint-md5 as a deticated data type. Also updating the object for ja3
- Merge branch 'qb' into 2.4. [iglocska]
- Fix+new [restClient] fixed merge glitch and added support of
  `includeProposals` [Sami Mokaddem]
- Merge remote-tracking branch 'origin/2.4' into querybuilder. [Sami
  Mokaddem]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Raphaël Vinot]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [Alexandre
  Dulaunoy]
- Merge pull request #3909 from ruiwen/fix_postgres. [Andras Iklody]

  fix: dev: Update POSTGRES-*.sql files
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #3956 from dawid-czarnecki/fix/disable_correlation.
  [Andras Iklody]

  Fix disabling correlations for single attributes
- Fix disabling correlations for single attributes. [Dawid Czarnecki]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [chrisr3d]
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #3954 from kfinny/fix-enrich-event-job-not-marked-
  as-completed. [Andras Iklody]

  Fixes #3907, enrich event job not marked as completed.
- Fixes #3907, enrich event job not marked as completed. [Kevin]

  The enrichment background process did not do anything to update the job
  after completing its task.  I used the same logic as the adjcacent
  'publish' function to record progress, update the message and create a
  log entry.
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request #3942 from tomking2/2.4. [Andras Iklody]

  fix: Make IE11 compliant by adding startsWith polyfill
- Merge branch '2.4' of github.com:MISP/MISP into 2.4. [iglocska]
- Merge pull request 