#### MISP configuration variables

If you are doing a manual install, copy and pasting from this document, please do the following before starting:

```bash
eval "$(curl -fsSL https://raw.githubusercontent.com/MISP/MISP/2.4/docs/generic/globalVariables.md | awk '/^# <snippet-begin/,0' | grep -v \`\`\`)"
MISPvars
```

!!! notice
    Do NOT leave your session after this mid-install as some initial passwords have been generated and thus would be lost.
    Consider using a mux like [screen or tmux](https://superuser.com/questions/423310/byobu-vs-gnu-screen-vs-tmux-usefulness-and-transferability-of-skills).

```bash
# <snippet-begin 0_global-vars.sh>
# $ eval "$(curl -fsSL https://raw.githubusercontent.com/MISP/MISP/2.4/docs/generic/globalVariables.md | awk '/^# <snippet-begin/,0' | grep -v \`\`\`)"
# $ MISPvars
MISPvars () {
  debug "Setting generic ${LBLUE}MISP${NC} variables shared by all flavours" 2> /dev/null
  # Some distros have no openssl installed by default, catch that exception.
  $(openssl help 2> /dev/null) || (echo "No openssl, please install to continue"; exit -1)
  # Local non-root MISP user
  MISP_USER="${MISP_USER:-misp}"
  MISP_PASSWORD="${MISP_PASSWORD:-$(openssl rand -hex 32)}"

  # Cheap distribution detector
  FLAVOUR="$(. /etc/os-release && echo "$ID"| tr '[:upper:]' '[:lower:]')"
  STREAM="$(. /etc/os-release && echo "$NAME"| grep -o -i stream |tr '[:upper:]' '[:lower:]')"
  DIST_VER="$(. /etc/os-release && echo "$VERSION_ID")"
  DISTRI=${FLAVOUR}${DIST_VER}${STREAM}

  # The web server user
  # RHEL/CentOS
  if [[ -f "/etc/redhat-release" ]]; then
    SE_LINUX=$(sestatus  -v -b |grep "^SELinux status"| grep enabled ; echo $?)
    WWW_USER="apache"
    SUDO_WWW="sudo -H -u ${WWW_USER} "
  # Debian flavoured
  elif [[ -f "/etc/debian_version" ]]; then
    WWW_USER="www-data"
    SUDO_WWW="sudo -H -u ${WWW_USER} "
  # OpenBSD
  elif [[ "$(uname -s)" == "OpenBSD" ]]; then
    WWW_USER="www"
    PATH_TO_MISP="${PATH_TO_MISP:-/var/www/htdocs/MISP}"
    SUDO_WWW="doas -u www "
    SUDO_CMD="doas "
  # NetBSD
  elif [[ "$(uname -s)" == "NetBSD" ]]; then
    WWW_USER="www"
    PATH_TO_MISP="$PATH_TO_MISP:-/usr/pkg/share/httpd/htdocs/MISP}"
    SUDO_WWW="sudo -H -u ${WWW_USER} "
  else
    # I am feeling lucky
    WWW_USER="www-data"
    SUDO_WWW="sudo -H -u ${WWW_USER} "
  fi

  # MISP configuration variables
  PATH_TO_MISP="${PATH_TO_MISP:-/var/www/MISP}"
  PATH_TO_MISP_SCRIPTS="${PATH_TO_MISP}/app/files/scripts"
  ## For future use
  # TMPDIR="${TMPDIR:-$PATH_TO_MISP/app/tmp}"

  FQDN="${FQDN:-misp.local}"

  MISP_BASEURL="${MISP_BASEURL:-""}"

  MISP_LIVE="1"

  # Database configuration
  DBHOST="${DBHOST:-localhost}"
  DBNAME="${DBNAME:-misp}"
  DBUSER_ADMIN="${DBUSER_ADMIN:-root}"
  DBPASSWORD_ADMIN="${DBPASSWORD_ADMIN:-$(openssl rand -hex 32)}"
  DBUSER_MISP="${DBUSER_MISP:-misp}"
  DBPASSWORD_MISP="${DBPASSWORD_MISP:-$(openssl rand -hex 32)}"

  # OpenSSL configuration
  OPENSSL_CN=${FQDN}
  OPENSSL_C="LU"
  OPENSSL_ST="State"
  OPENSSL_L="Location"
  OPENSSL_O="Organization"
  OPENSSL_OU="Organizational Unit"
  OPENSSL_EMAILADDRESS="info@${FQDN}"

  # GPG configuration
  GPG_REAL_NAME="Autogenerated Key"
  # On a REAL install, please do not set a comment, see here for why: https://www.debian-administration.org/users/dkg/weblog/97
  GPG_COMMENT="WARNING: MISP AutoGenerated Key consider this Key VOID!"
  GPG_EMAIL_ADDRESS="admin@admin.test"
  # 3072 bits used as per suggestions here: https://riseup.net/en/security/message-security/openpgp/best-practices
  GPG_KEY_LENGTH="3072"
  GPG_PASSPHRASE="$(openssl rand -hex 32)"

  # debug alias to make sure people are not confused when blindly copy pasting blobs of code
  alias debug="echo -e"

  # checkAptLock alias to make sure people are not confused when blindly copy pasting blobs of code
  alias checkAptLock="echo 'Function used in Installer to make sure apt is not locked'"

  # php.ini configuration
  upload_max_filesize="50M"
  post_max_size="50M"
  max_execution_time="300"
  memory_limit="2048M"
  session0sid_length="32"
  session0use_strict_mode="1"

  CAKE="${PATH_TO_MISP}/app/Console/cake"

  # sudo config to run $LUSER commands
  if [[ "$(groups ${MISP_USER} |grep -o 'staff')" == "staff" ]]; then
    SUDO_CMD="sudo -H -u ${MISP_USER} -g staff"
  else
    SUDO_CMD="sudo -H -u ${MISP_USER}"
  fi
  
  echo "The following DB Passwords were generated..."
  echo "Admin (${DBUSER_ADMIN}) DB Password: ${DBPASSWORD_ADMIN}"
  echo "User  (${DBUSER_MISP}) DB Password: ${DBPASSWORD_MISP}"
}
# <snippet-end 0_global-vars.sh>
```
