package org.roda_project.commons_ip2.validator.constants;

/** {@author João Gomes <jgomes@keep.pt>}. */
public final class ConstantsAIPspec {
  /**
   * Constant specification id "AIP9".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP9_ID = "AIP9";

  /**
   * Constant specification name for id "AIP9".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP9_NAME = "File ID";

  /**
   * Constant specification location for id "AIP9".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP9_LOCATION = "file/@ID";

  /**
   * Constant specification description for id "AIP9".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP9_DESCRIPTION = "Identifier of a file which is part "
    + "of the AIP File identifier; " + "must be unique and start with the prefix ID";

  /**
   * Constant specification cardinality for id "AIP9".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP9_CARDINALITY = "0..1";

  /**
   * Constant specification level for id "AIP9".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP9_LEVEL = "MUST";

  /**
   * Constant specification id "AIP10".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP10_ID = "AIP10";

  /**
   * Constant specification name for id "AIP10".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP10_NAME = "File ADMID";

  /**
   * Constant specification location for id "AIP10".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP10_LOCATION = "file/@ADMID";

  /**
   * Constant specification description for id "AIP10".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP10_DESCRIPTION = "Used to link it to relevant "
    + "administrative metadata sections that " + "relate to the digital object described. "
    + "Can be a white space separated list of identifiers.";

  /**
   * Constant specification cardinality for id "AIP10".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP10_CARDINALITY = "0..n";

  /**
   * Constant specification level for id "AIP10".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP10_LEVEL = "MAY";

  /**
   * Constant specification id "AIP11".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP11_ID = "AIP11";

  /**
   * Constant specification name for id "AIP11".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP11_NAME = "File CHECKSUMTYPE";

  /**
   * Constant specification location for id "AIP11".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP11_LOCATION = "file/@CHECKSUMTYPE";

  /**
   * Constant specification description for id "AIP11".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP11_DESCRIPTION = "Hash-sum calculator algorithm";

  /**
   * Constant specification cardinality for id "AIP11".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP11_CARDINALITY = "0..1";

  /**
   * Constant specification level for id "AIP11".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP11_LEVEL = "MUST";

  /**
   * Constant specification id "AIP12".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP12_ID = "AIP12";

  /**
   * Constant specification name for id "AIP12".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP12_NAME = "File CHECKSUM";

  /**
   * Constant specification location for id "AIP12".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP12_LOCATION = "file/@CHECKSUM";

  /**
   * Constant specification description for id "AIP12".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP12_DESCRIPTION = "Hash-sum";

  /**
   * Constant specification cardinality for id "AIP12".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP12_CARDINALITY = "0..1";

  /**
   * Constant specification level for id "AIP12".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP12_LEVEL = "MUST";

  /**
   * Constant specification id "AIP13".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP13_ID = "AIP13";

  /**
   * Constant specification name for id "AIP13".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP13_NAME = "File CREATED";

  /**
   * Constant specification location for id "AIP13".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP13_LOCATION = "file/@CREATED";

  /**
   * Constant specification description for id "AIP13".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP13_DESCRIPTION = "Date when the file "
    + "entry was created.";

  /**
   * Constant specification cardinality for id "AIP13".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP13_CARDINALITY = "0..1";

  /**
   * Constant specification level for id "AIP13".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP13_LEVEL = "MUST";

  /**
   * Constant specification id "AIP14".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP14_ID = "AIP14";

  /**
   * Constant specification name for id "AIP14".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP14_NAME = "File SIZE";

  /**
   * Constant specification location for id "AIP14".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP14_LOCATION = "file/@SIZE";

  /**
   * Constant specification description for id "AIP14".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP14_DESCRIPTION = "Size of the file in bytes.";

  /**
   * Constant specification cardinality for id "AIP14".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP14_CARDINALITY = "0..1";

  /**
   * Constant specification level for id "AIP14".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP14_LEVEL = "MUST";

  /**
   * Constant specification id "AIP15".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP15_ID = "AIP15";

  /**
   * Constant specification name for id "AIP15".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP15_NAME = "File MIMETYPE";

  /**
   * Constant specification location for id "AIP15".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP15_LOCATION = "file/@MIMETYPE";

  /**
   * Constant specification description for id "AIP15".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP15_DESCRIPTION = "Mime-type.";

  /**
   * Constant specification cardinality for id "AIP15".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP15_CARDINALITY = "0..1";

  /**
   * Constant specification level for id "AIP15".
   */
  public static final String VALIDATION_REPORT_SPECIFICATION_AIP15_LEVEL = "MUST";

  /**
   * Constant "Not Defined".
   */
  public static final String NOT_DEFINED = "Not Defined";

  private ConstantsAIPspec() {
    // do nothing
  }

  /**
   * Get the name of the requirement of given id.
   *
   * @param id
   *          {@link String} id of the requirement
   * @return the {@link String} name of the requirement.
   */
  public static String getSpecificationName(final String id) {
    if (VALIDATION_REPORT_SPECIFICATION_AIP9_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP9_NAME;
    }
    if (VALIDATION_REPORT_SPECIFICATION_AIP10_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP10_NAME;
    }
    if (VALIDATION_REPORT_SPECIFICATION_AIP11_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP11_NAME;
    }
    if (VALIDATION_REPORT_SPECIFICATION_AIP12_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP12_NAME;
    }
    if (VALIDATION_REPORT_SPECIFICATION_AIP13_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP13_NAME;
    }
    if (VALIDATION_REPORT_SPECIFICATION_AIP14_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP14_NAME;
    }
    if (VALIDATION_REPORT_SPECIFICATION_AIP15_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP15_NAME;
    }
    return NOT_DEFINED;
  }

  /**
   * Get the location of the requirement of given id.
   *
   * @param id
   *          {@link String} id of the requirement
   * @return the {@link String} location of the requirement.
   */
  public static String getSpecificationLocation(final String id) {
    if (VALIDATION_REPORT_SPECIFICATION_AIP9_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP9_LOCATION;
    }
    if (VALIDATION_REPORT_SPECIFICATION_AIP10_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP10_LOCATION;
    }
    if (VALIDATION_REPORT_SPECIFICATION_AIP11_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP11_LOCATION;
    }
    if (VALIDATION_REPORT_SPECIFICATION_AIP12_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP12_LOCATION;
    }
    if (VALIDATION_REPORT_SPECIFICATION_AIP13_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP13_LOCATION;
    }
    if (VALIDATION_REPORT_SPECIFICATION_AIP14_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP14_LOCATION;
    }
    if (VALIDATION_REPORT_SPECIFICATION_AIP15_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP15_LOCATION;
    }
    return NOT_DEFINED;
  }

  /**
   * Get the description of the requirement of given id.
   *
   * @param id
   *          {@link String} id of the requirement
   * @return the {@link String} description of the requirement.
   */
  public static String getSpecificationDescription(final String id) {
    if (VALIDATION_REPORT_SPECIFICATION_AIP9_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP9_DESCRIPTION;
    }
    if (VALIDATION_REPORT_SPECIFICATION_AIP10_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP10_DESCRIPTION;
    }
    if (VALIDATION_REPORT_SPECIFICATION_AIP11_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP11_DESCRIPTION;
    }
    if (VALIDATION_REPORT_SPECIFICATION_AIP12_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP12_DESCRIPTION;
    }
    if (VALIDATION_REPORT_SPECIFICATION_AIP13_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP13_DESCRIPTION;
    }
    if (VALIDATION_REPORT_SPECIFICATION_AIP14_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP14_DESCRIPTION;
    }
    if (VALIDATION_REPORT_SPECIFICATION_AIP15_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP15_DESCRIPTION;
    }
    return NOT_DEFINED;
  }

  /**
   * Get the cardinality of the requirement of given id.
   *
   * @param id
   *          {@link String} id of the requirement
   * @return the {@link String} cardinality of the requirement.
   */
  public static String getSpecificationCardinality(final String id) {
    if (VALIDATION_REPORT_SPECIFICATION_AIP9_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP9_CARDINALITY;
    }
    if (VALIDATION_REPORT_SPECIFICATION_AIP10_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP10_CARDINALITY;
    }
    if (VALIDATION_REPORT_SPECIFICATION_AIP11_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP11_CARDINALITY;
    }
    if (VALIDATION_REPORT_SPECIFICATION_AIP12_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP12_CARDINALITY;
    }
    if (VALIDATION_REPORT_SPECIFICATION_AIP13_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP13_CARDINALITY;
    }
    if (VALIDATION_REPORT_SPECIFICATION_AIP14_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP14_CARDINALITY;
    }
    if (VALIDATION_REPORT_SPECIFICATION_AIP15_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP15_CARDINALITY;
    }
    return NOT_DEFINED;
  }

  /**
   * Get the level of the requirement of given id.
   *
   * @param id
   *          {@link String} id of the requirement
   * @return the {@link String} level of the requirement.
   */
  public static String getSpecificationLevel(final String id) {
    if (VALIDATION_REPORT_SPECIFICATION_AIP9_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP9_LEVEL;
    }
    if (VALIDATION_REPORT_SPECIFICATION_AIP10_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP10_LEVEL;
    }
    if (VALIDATION_REPORT_SPECIFICATION_AIP11_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP11_LEVEL;
    }
    if (VALIDATION_REPORT_SPECIFICATION_AIP12_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP12_LEVEL;
    }
    if (VALIDATION_REPORT_SPECIFICATION_AIP13_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP13_LEVEL;
    }
    if (VALIDATION_REPORT_SPECIFICATION_AIP14_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP14_LEVEL;
    }
    if (VALIDATION_REPORT_SPECIFICATION_AIP15_ID.equals(id)) {
      return VALIDATION_REPORT_SPECIFICATION_AIP15_LEVEL;
    }
    return NOT_DEFINED;
  }
}
