title: Package Inclusion Policy and Guidance

<div class="alert alert-warning">
	<b>Note:</b> This is a draft
</div>

## 0. Overview

ContentDB is for the community, and as such listings should be useful to the
community. To help with this, there are a few rules to improve the quality of
the listings and to combat abuse.

* No inappropriate content. <sup>2.1</sup>
* Content must be playable/useful, but not necessarily finished. <sup>2.2</sup>
* Don't use the name of another mod unless your mod is a fork or reimplementation. <sup>3</sup>
* Licenses must allow derivatives, redistribution, and must not discriminate. <sup>4</sup>
* Don't put promotions or advertisements in package listings, except for
  donation and personal website links which are permitted in the
  long description. <sup>5</sup>
* The ContentDB admin reserves the right to remove packages for any reason,
  including ones not covered by this document, and to ban users who abuse
  this service. <sup>1</sup>


## 1. General

The ContentDB admin reserves the right to remove packages for any reason,
including ones not covered by this document, and to ban users who abuse this service.

Also see the [help page on tags](/help/package_tags/).


## 2. Accepted Content

### 2.1. Acceptable Content

Sexually-orientated content is not permitted.

Mature content, including that relating to drugs, excessive gore, violence, or
excessive horror, is not currently permitted - but will be in the future.

The submission of malware is strictly prohibited. This includes software which
does not do as it advertises, for example if it posts telemetry without stating
clearly that it does in the package meta.

### 2.2. State of Completion

ContentDB should only currently contain playable content - content which is
sufficiently complete to be useful to end users. It's fine to add stuff which
is still a work in progress (WIP) as long as it adds sufficient value -
MineClone 2 is a good example of a WIP package which may break between releases
but still has value. Note that this doesn't mean that you should add a thing
you started working on yesterday, it's worth adding all the basic stuff to
make your package useful.

Adding non-player facing mods, such as libraries and server tools, is perfectly fine
and encouraged. ContentDB isn't just for player-facing things, and adding
libraries allows them to be installed when a mod depends on it.


## 3. Technical Names

### 3.1 Right to a name

The first package to use a name based on the creation of its forum topic or
contentdb submission has the right to the technical name. The use of a package
on a server or in private doesn't reserve its name. No other packages of the same
type may use the same name, except for the exception given by 3.2.

If it turns out that we made a mistake by approving a package and that the
name should have been given to another package, then we *may* unapprove the
package and give the name to the correct one.

If you submit a package where you don't have the right to the name you will be asked
to change the name of the package, or your package won't be accepted.

We reserve the right to issue exceptions for this where we feel necessary.

### 3.2. Mod Forks and Reimplementations

An exception to the above is that mods are allowed to have the same name as a
mod if its a fork of that mod (or a close reimplementation). In real terms, it
should be possible to use the new mod as a drop-in replacement.

We reserve the right to decide whether a mod counts as a fork or
reimplementation of the mod that owns the name.


## 4. Licenses

### 4.1. Allowed Licenses

Please ensure that you correctly credit any resources (code, assets, or otherwise)
that you have used in your package.

**The use of licenses which do not allow derivatives or redistribution is not
permitted. This includes CC-ND (No-Derivatives) and lots of closed source licenses.
The use of licenses which discriminate between groups of people or forbid the use
of the content on servers or singleplayer is also not permitted.**

However, closed sourced licenses are allowed if they allow the above.

If the license you use is not on the list then please select "Other", and we'll
get around to adding it.

Please note that the definitions of "free" and "non-free" is the same as that
of the [Free Software Foundation](https://www.gnu.org/philosophy/free-sw.en.html).

### 4.2. Recommended Licenses

It is highly recommended that you use a free and open source software license.
FOSS licenses result in a sharing community and will increase the number of potential users your package has.
Using a closed source license will result in your package being massively penalised in the search results and package lists.

It is recommended that you use a proper license for code with a warranty
disclaimer, such as the (L)GPL or MIT. You should also use a proper media license
for media, such as a Creative Commons license.

The use of WTFPL is discouraged as it doesn't contain a [valid warranty disclaimer](https://cubicspot.blogspot.com/2017/04/wtfpl-is-harmful-to-software-developers.html),
and also includes swearing which prevents settings like schools from using your content.
[Read more](/help/wtfpl/).

Public domain is not a valid license in many countries, please use CC0 or MIT instead.


## 5. Promotions and Advertisements (inc. asking for donations)

You may note place any promotions or advertisements in any meta data including
screensthos. This includes asking for donations, promoting online shops,
or linking to personal websites and social media. Please instead use the
fields provided on your user profile page to place links to websites and
donation pages.

ContentDB is for the community. We may remove any promotions if we feel that
they're inappropriate.


## 6. Reporting Violations

See the [Reporting Content](/help/reporting/) page.
