"""empty message

Revision ID: 9fc23495713b
Revises: de004661c5e1
Create Date: 2018-07-04 00:03:20.123285

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '9fc23495713b'
down_revision = 'de004661c5e1'
branch_labels = None
depends_on = None
from sqlalchemy.dialects.postgresql import ENUM

type_enum = ENUM('MOD', 'GAME', 'TXP', name='packagetype', create_type=False)

def upgrade():
    type_enum.create(op.get_bind(), checkfirst=True)

    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('krock_forum_topic')
    op.create_table('forum_topic',
    sa.Column('topic_id', sa.Integer(), autoincrement=False, nullable=False),
    sa.Column('author_id', sa.Integer(), nullable=False),
    sa.Column('type', type_enum, nullable=True),
    sa.Column('title', sa.String(length=200), nullable=False),
    sa.Column('name', sa.String(length=30), nullable=True),
    sa.Column('link', sa.String(length=200), nullable=True),
    sa.Column('posts', sa.Integer(), nullable=False),
    sa.Column('views', sa.Integer(), nullable=False),
    sa.Column('created_at', sa.DateTime(), nullable=False),
    sa.ForeignKeyConstraint(['author_id'], ['user.id'], ),
    sa.PrimaryKeyConstraint('topic_id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('forum_topic')
    op.create_table('krock_forum_topic',
    sa.Column('topic_id', sa.Integer(), autoincrement=False, nullable=False),
    sa.Column('author_id', sa.Integer(), nullable=False),
    sa.Column('ttype', sa.Integer(), nullable=False),
    sa.Column('title', sa.String(length=200), nullable=False),
    sa.Column('name', sa.String(length=30), nullable=True),
    sa.Column('link', sa.String(length=50), nullable=True),
    sa.ForeignKeyConstraint(['author_id'], ['user.id'], ),
    sa.PrimaryKeyConstraint('topic_id')
    )
    # ### end Alembic commands ###
