# Breaking changes to bundler dependency enumeration in v3

**NOTE** If you are migrating from a version earlier than v2, please first [migrate to v2](./v2.md) before continuing.

Licensed v3 includes a breaking change to bundler dependency enumeration when using the executable form of licensed.  Bundler dependency enumeration will no longer work with the licensed executable as of 3.0.0.

**If your project does not use bundler, or if you already install the licensed gem, you are not affected by this breaking change.**

## Migrating bundler enumeration for v3

When using licensed v3 with bundler dependencies, licensed must be installed from its [gem](https://rubygems.org/gems/licensed).  This can be accomplished with `gem install`, or by adding licensed to a bundler gem file.

### Usage in a GitHub Actions workflow

Using licensed to enumerate bundler dependencies in a GitHub Actions workflow will require ruby to be available in the actions VM environment.  Ruby can be setup in an actions workflow using [ruby/setup-ruby](https://github.com/ruby/setup-ruby)(preferred) or [actions/setup-ruby](https://github.com/actions/setup-ruby)(deprecated).

If you are using licensed in a GitHub Actions workflow, [github/setup-licensed](https://github.com/github/setup-licensed) has been updated according to this breaking change.  `setup-licensed` will install the licensed gem when ruby is available, or the licensed executable when ruby is not available.  Alternatively, you can `gem install` licensed directly as an actions step.

This is an example workflow definition that runs [github/licensed-ci](https://github.com/github/licensed-ci)'s opinionated license compliance workflow in CI.  It includes jobs that demonstrate installing licensed using 
- `gem install`
- [github/setup-licensed](https://github.com/github/setup-licensed)
- installing when included in a bundler gem file

```yml
name: Cache and verify dependency license metadata

on:
  # run when PRs are opened, reopened or updated
  pull_request:
    types:
      - opened
      - reopened
      - synchronize

  # run on demand
  workflow_dispatch:

jobs:
  # install licensed with setup-licensed
  licensed-ci-setup-licensed:
    runs-on: ubuntu-latest

    steps:
      # checkout the repo
      - uses: actions/checkout@v1
      
      # install ruby
      - uses: ruby/setup-ruby@v1
        with:
          ruby-version: "3.0"

      # install licensed gem using setup-licensed
      - uses: github/setup-licensed@v1
        with:
          version: '3.x'

      # install dependencies in CI environment
      - run: bundle install

      # run licensed-ci to cache any metadata changes and verify compliance
      - uses: github/licensed-ci@v1

  # OR 
  
  # install licensed using gem install
  licensed-ci-gem:
    runs-on: ubuntu-latest

    steps:
      # checkout the repo
      - uses: actions/checkout@v1
      
      # install ruby and bundler
      - uses: ruby/setup-ruby@v1
        with:
          ruby-version: "3.0"

      # install licensed gem using setup-licensed
      - run: gem install licensed -v '~> 3.0'

      # install dependencies in CI environment
      - run: bundle install

      # run licensed-ci to cache any metadata changes and verify compliance
      - uses: github/licensed-ci@v1

  # OR

  # install licensed as part of bundle installation
  licensed-ci-bundle:
    runs-on: ubuntu-latest

    steps:
      # checkout the repo
      - uses: actions/checkout@v1
      
      # install ruby and bundler
      - uses: ruby/setup-ruby@v1
        with:
          ruby-version: "3.0"

      # install licensed and other dependencies in CI environment
      - run: bundle install

      # run licensed-ci to cache any metadata changes and verify compliance
      - uses: github/licensed-ci@v1
        with:
          command: 'bundle exec licensed' # run licensed within the bundler context
```
