/*
 *
 * Licensed under the Apache License, Version 2.0 (the “License”);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an “AS IS” BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import React from "react";

export const PASSWORD_INFO =
  "Password must be of length 8-16 characters having one lower case, one upper case and one numeric character.";
export const NAME_REQUIRED = "Please enter your full name!";
export const EMAIL_REQUIRED = "Please enter a valid email!";
export const PHONE_NO_REQUIRED = "Please enter phone number";
export const INVALID_PHONE = "Contact number should have only numbers and -";
export const PASSWORD_REQUIRED = "Please enter your password";
export const INVALID_PASSWORD = (
  <>
    Password should contain at least one digit, one small letter, one capital
    letter and one special character.
    <br />
    Should be at least contain 8 characters and maximum 16 characters.
    <br />
    Allowed special characters are #$@!%&*?
  </>
);
export const CONFIRM_PASSWORD = "Please confirm your password!";
export const PASSWORD_DO_NOT_MATCH = "Passwords do not match!";
export const OTP_REQUIRED = "Please enter the OTP!";
export const COMPANY_REQUIRED = "Please select a company!";
export const MODEL_REQUIRED = "Please select a brand!";
export const PIN_CODE_REQUIRED = "Please enter the pincode";
export const VEHICLE_NO_REQUIRED = "Please enter the vehicle number!";
export const INVALID_PIN_CODE = "Please enter a valid pin code";
export const VIN_REQUIRED = "Please enter a VIN of your vehivle";
export const MECHANIC_REQUIRED = "Please select a mechanic";
export const PROBLEM_REQUIRED = "Please describe problem of your vehicle";
export const TOKEN_REQUIRED =
  "Please enter the token sent to your new email id";
export const INVALID_VIN = "Please enter a valid VIN!";
export const VIDEO_NAME_REQUIRED = "Please enter video name!";
export const POST_TITLE_REQUIRED = "Please enter title for post!";
export const POST_DESC_REQUIRED = "Please enter description for Post!";
export const COMMENT_REQUIRED = "Please enter a comment!";
export const COUPON_CODE_REQUIRED = "Please enter a coupon code!";

export const NO_VEHICLE_DESC_1 =
  "Your newly purchased Vehicle Details have been sent to you email address. Please check your email for the VIN and PIN code of your vehicle using the MailHog web portal.";
export const NO_VEHICLE_DESC_2 = " Click here ";
export const NO_VEHICLE_DESC_3 = "to send the information again";

export const SUCCESS_MESSAGE = "Success";
export const FAILURE_MESSAGE = "Failed";

export const NO_POSTS = "Could not get posts";
export const NO_POST = "Could not get post";
export const POST_CREATED = "Post Created.";
export const POST_NOT_CREATED = "Could not add new post";
export const COMMENT_ADDED = "Comment Added";
export const COMMENT_NOT_ADDED = "Could not add comment";
export const PROFILE_PIC_UPDATED = "Profile pic updated successfully";
export const PROFILE_PIC_NOT_UPDATED = "Could not upload Picture";
export const VIDEO_UPDATED = "Video updated successfully";
export const VIDEO_NOT_UPDATED = "Could not upload video";
export const VIDEO_NAME_CHANGED = "Video Name Changed";
export const VIDEO_NAME_NOT_CHANGED = "Could not change video";
export const VIDEO_NOT_CONVERTED = "Could not convert video";
export const NO_PRODUCTS = "Could not get product details";
export const PRODUCT_NOT_BOUGHT = "Try again after sometime...";
export const NO_ORDERS = "Could not get orders";
export const NO_ORDER = "Could not get order";
export const ORDER_NOT_RETURNED = "Could not return order";
export const INVALID_COUPON_CODE = "Invalid Coupon Code";
export const COUPON_APPLIED = "Coupon applied";
export const COUPON_NOT_APPLIED = "Could not validate coupon";
export const INVALID_CREDS = "Invalid Username or Password";
export const INVALID_CODE_CREDS = "Invalid Email or Code";
export const SIGN_UP_SUCCESS = "User Registered Successfully!";
export const SIGN_UP_FAILED = "Could not sign up";
export const OTP_SENT = "OTP has been sent to your registered emailid";
export const OTP_NOT_SENT = "Could not send OTP";
export const OTP_VERIFIED = "Otp verified and your password has been set.";
export const OTP_NOT_VERIFIED = "Could not verify OTP";
export const PASSWORD_CHANGED = "Password Reset Successfully";
export const PASSWORD_NOT_CHANGED = "Could not reset your password";
export const TOKEN_NOT_SENT = "Could not send token to email address";
export const EMAIL_CHANGED = "Token Verified and email changed";
export const EMAIL_NOT_CHANGED = "Could not change email id";
export const NO_SERVICES = "Could not get mechanic details";
export const EMAIL_NOT_SENT = "Could not resend mail";
export const VEHICLE_NOT_ADDED = "Internal Server error! Wrong VIN!";
export const NO_VEHICLES = "Could not get vehicles";
export const NO_MECHANICS = "Could not get mechanic details";
export const SERVICE_REQUEST_SENT = "Service Request sent to the mechanic";
export const SERVICE_REQUEST_NOT_SENT = "Could not contact mechanic";
export const LOC_NOT_REFRESHED = "Could not refresh location";
