# Contributing

We love when people help us out, it makes Wing better.


## How to Contribute

Here are guides for submitting issues and pull requests.

### Issues

Issues let us know of things we should fix, things we should add, questions, etc. 

1) Head [here](https://github.com/KingPixil/wing/issues/new) to submit a new issue.

2) Include a descriptive title that is straight to the point.

3) Write a detailed description on what the issue is all about.

4) Wait for someone to get to the issue and add labels.

5) The issue will be fixed soon!


### Pull Requests

Pull Requests allow you to share your own code with us, and we can merge it into the main repo.

**Adding Code**

1) Fork the repo.

2) Clone the repo **you forked** by running 
```sh
$ git clone https://github.com/YOUR-USERNAME-HERE/wing.git
```

3) Install node.js if you haven't already, and run `npm install`. This installs the required dependencies for building Wing.

4) Edit files in the `src/` folder. For example, if you are fixing up forms, head to `src/forms.css` and add changes. Don't edit any files in the `dist/` folder, this is only for distribution builds, which are automated. 

5) Run `gulp` to run builds, and the new distribution files will be in the `dist/` folder ready to go.



**Fixing an Issue**

Have you found a solution to an issue? Here is how you can submit your code to Wing.

1) Fork the repo, and refer above for how to change up code.

1) Head to your local fork of the repo, and click the "New Pull Request" button.

2) Include a title that is straight to the point.

3) Wait for someone to review the pull request, and then merge your pull request!



## Contributor Code of Conduct

As contributors and maintainers of this project, and in the interest of fostering an open and 
welcoming community, we pledge to respect all people who contribute through reporting issues, 
posting feature requests, updating documentation, submitting pull requests or patches, and other 
activities.

We are committed to making participation in this project a harassment-free experience for everyone, 
regardless of level of experience, gender, gender identity and expression, sexual orientation, 
disability, personal appearance, body size, race, ethnicity, age, religion, or nationality.

Examples of unacceptable behavior by participants include:

* The use of sexualized language or imagery
* Personal attacks
* Trolling or insulting/derogatory comments
* Public or private harassment
* Publishing other's private information, such as physical or electronic addresses, without explicit
  permission
* Other unethical or unprofessional conduct.

Project maintainers have the right and responsibility to remove, edit, or reject comments, commits, 
code, wiki edits, issues, and other contributions that are not aligned to this Code of Conduct. By 
adopting this Code of Conduct, project maintainers commit themselves to fairly and consistently 
applying these principles to every aspect of managing this project. Project maintainers who do not 
follow or enforce the Code of Conduct may be permanently removed from the project team.

This code of conduct applies both within project spaces and in public spaces when an individual is 
representing the project or its community.

Instances of abusive, harassing, or otherwise unacceptable behavior may be reported by opening an 
issue or contacting one or more of the project maintainers.

This Code of Conduct is adapted from the [Contributor Covenant](http://contributor-covenant.org), 
version 1.2.0, available at 
[http://contributor-covenant.org/version/1/2/0/](http://contributor-covenant.org/version/1/2/0/)
