## Autotuner and custom Triton kernels

### Environment variables

`TORCHAO_AUTOTUNER_ENABLE=0`

Set this to a nonzero value to enable the kernels generated by the autotuner. This is turned off by default, because it is still an experimental feature and also can take a long time to run.

`TORCHINDUCTOR_MAX_AUTOTUNE_GEMM_SEARCH_SPACE=EXHAUSTIVE`
Use this to enable exhaustive search for both int8mm and scaled_mm kernels.

Searching a new config can take a long time and we'll save the updated data in `data.pkl`. If you'd like to contributed updated configs for your hardware or shapes, please open a pull request.

`TORCHAO_AUTOTUNER_DATA_PATH=torchao/kernel/configs/data_a100.pkl`

By default we load precomputed configs for A100. If we're not on an A100, we search set the path to `data.pkl`.

Updated configs are always stored in the current working directory as `data.pkl` to avoid accidentally overwriting the supplied configs.
