# Copyright (c) Meta Platforms, Inc. and affiliates.
# All rights reserved.
#
# This source code is licensed under the BSD 3-Clause license found in the
# LICENSE file in the root directory of this source tree.
import torch


# hadamard matrices for had12, had36.pal2, had52,will,
# # had60.pal, had108.pal, had140.pal, had156.will, had172.will:
# http://www.neilsloane.com/hadamard/index.html
def get_had12():
    return torch.FloatTensor(
        [
            [+1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1],
            [+1, +1, -1, +1, -1, -1, -1, +1, +1, +1, -1, +1],
            [+1, +1, +1, -1, +1, -1, -1, -1, +1, +1, +1, -1],
            [+1, -1, +1, +1, -1, +1, -1, -1, -1, +1, +1, +1],
            [+1, +1, -1, +1, +1, -1, +1, -1, -1, -1, +1, +1],
            [+1, +1, +1, -1, +1, +1, -1, +1, -1, -1, -1, +1],
            [+1, +1, +1, +1, -1, +1, +1, -1, +1, -1, -1, -1],
            [+1, -1, +1, +1, +1, -1, +1, +1, -1, +1, -1, -1],
            [+1, -1, -1, +1, +1, +1, -1, +1, +1, -1, +1, -1],
            [+1, -1, -1, -1, +1, +1, +1, -1, +1, +1, -1, +1],
            [+1, +1, -1, -1, -1, +1, +1, +1, -1, +1, +1, -1],
            [+1, -1, +1, -1, -1, -1, +1, +1, +1, -1, +1, +1],
        ]
    )


def get_had44():
    return torch.FloatTensor(
        [
            [
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
            ],
            [
                1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
            ],
            [
                1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
            ],
            [
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
            ],
            [
                1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
            ],
            [
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
            ],
            [
                1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
            ],
            [
                1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
            ],
            [
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
            ],
            [
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
            ],
            [
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
            ],
            [
                1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
            ],
            [
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
            ],
            [
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
            ],
            [
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
            ],
            [
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
            ],
            [
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
            ],
            [
                1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
            ],
            [
                1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
            ],
            [
                1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
            ],
            [
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
            ],
            [
                1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
            ],
            [
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
            ],
            [
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
            ],
            [
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
            ],
            [
                1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
            ],
            [
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
            ],
            [
                1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
            ],
            [
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
            ],
            [
                1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
            ],
            [
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
            ],
            [
                1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
            ],
            [
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
            ],
            [
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
            ],
            [
                1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
            ],
            [
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
                1,
            ],
            [
                1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
                -1,
            ],
            [
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
                1,
            ],
            [
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
                1,
            ],
            [
                1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
                -1,
            ],
            [
                1,
                -1,
                1,
                1,
                -1,
                1,
                -1,
                1,
                1,
                -1,
                -1,
                -1,
                1,
                -1,
                -1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                -1,
                1,
                -1,
                -1,
                -1,
                1,
                1,
                1,
                1,
                1,
                -1,
                1,
                1,
                1,
                -1,
                -1,
                1,
                -1,
                1,
                -1,
                -1,
                1,
                1,
            ],
        ]
    )


def get_had40():
    return torch.FloatTensor(
        [
            [
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
            ],
        ]
    )


def get_had20():
    return torch.FloatTensor(
        [
            [
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
            ],
        ]
    )


def get_had28():
    return torch.FloatTensor(
        [
            [
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
            ],
            [
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
            ],
        ]
    )


def get_had36():
    return torch.FloatTensor(
        [
            [
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
            ],
        ]
    )


def get_had60():
    return torch.FloatTensor(
        [
            [
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
            ],
        ]
    )


def get_had52():
    return torch.FloatTensor(
        [
            [
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
            ],
            [
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
            ],
            [
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
            ],
            [
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
            ],
            [
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
            ],
            [
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
            ],
            [
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
            ],
            [
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
            ],
            [
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
            ],
            [
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
            ],
            [
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
            ],
            [
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
            ],
            [
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
            ],
            [
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
            ],
            [
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
            ],
            [
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
            ],
            [
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
            ],
            [
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
            ],
            [
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
            ],
        ]
    )


def get_had108():
    return torch.FloatTensor(
        [
            [
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
            ],
        ]
    )


def get_had140():
    return torch.FloatTensor(
        [
            [
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
            ],
        ]
    )


def get_had156():
    return torch.FloatTensor(
        [
            [
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
            ],
            [
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
            ],
            [
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
            ],
            [
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
            ],
            [
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
            ],
            [
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
            ],
            [
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
            ],
            [
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
            ],
            [
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
            ],
            [
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
            ],
            [
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
            ],
            [
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
            ],
            [
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
            ],
            [
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
            ],
            [
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
            ],
            [
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                +1,
            ],
            [
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
            ],
            [
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                +1,
            ],
            [
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
            ],
            [
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
            ],
            [
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
            ],
            [
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                -1,
                +1,
                +1,
                -1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                +1,
                -1,
                +1,
                +1,
                -1,
                +1,
                -1,
                -1,
                -1,
                +1,
                -1,
                +1,
                -1,
                -1,
 