### `Notable Changes`

> ✏️ Describe the big picture of your changes here to communicate to the maintainers why we should accept this pull request. If it fixes a bug or resolves a feature request, be sure to link to that issue down below.

#### `Commit Message Summary (CHANGELOG)`

```
commit message body...
```

### `Type`

> ℹ️  What types of changes does your code introduce?

> 👉 _Put an `x` in the boxes that apply and delete all others_

- [ ] CI
- [ ] Fix
- [ ] Perf
- [ ] Docs
- [ ] Test
- [ ] Chore
- [ ] Style
- [ ] Build
- [ ] Feature
- [ ] Refactor

### `SemVer`

> ℹ️  What changes to the current `semver` range does your PR introduce?

> 👉  _Put an `x` in the boxes that apply and delete all others_

- [ ] Fix (:label: Patch)
- [ ] Feature (:label: Minor)
- [ ] Breaking Change (:label: Major)

### `Issues`

> ℹ️ What issue(s) (if any) are closed by your PR?

> 👉  _Replace `#1` with the issue number that applies and remove the ``` ` ```_

- Fixes `#1`

### `Checklist`

> ℹ️  You can also fill these out after creating the PR. If you're unsure about any of them, don't hesitate to ask. This is a reminder of what we are going to look for before merging your code.

> 👉  _Put an `x` in the boxes that apply and delete all others._

- [ ] Lint and unit tests pass with my changes
- [ ] I have added tests that prove my fix is effective/works
- [ ] I have added necessary documentation (if appropriate)
- [ ] Any dependent changes are merged and published in downstream modules
