/*
 * This file is part of spark.
 *
 *  Copyright (c) lucko (Luck) <luck@lucko.me>
 *  Copyright (c) contributors
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package me.lucko.spark.minestom;

import me.lucko.spark.common.tick.AbstractTickHook;

import net.minestom.server.MinecraftServer;
import net.minestom.server.timer.Task;
import net.minestom.server.timer.TaskSchedule;

public class MinestomTickHook extends AbstractTickHook {
    private Task task;

    @Override
    public void start() {
        this.task = MinecraftServer.getSchedulerManager()
                .buildTask(this::onTick)
                .delay(TaskSchedule.tick(1))
                .repeat(TaskSchedule.tick(1))
                .schedule();
    }

    @Override
    public void close() {
        if (this.task != null) {
            this.task.cancel();
        }
    }
}
