import os

def add_source_files(self, sources, filetype, lib_env = None, shared = False):
	import glob;
	import string;
	#if not lib_objects:
	if not lib_env:
		lib_env = self
	if type(filetype) == type(""):

		dir = self.Dir('.').abspath
		list = glob.glob(dir + "/"+filetype)
		for f in list:
			sources.append( self.Object(f) )
	else:
		for f in filetype:
			sources.append(self.Object(f))


def build_shader_header( target, source, env ):

	for x in source:
		print x

		name = str(x)
		name = name[ name.rfind("/")+1: ]
		name = name[ name.rfind("\\")+1: ]
		name = name.replace(".","_")


		fs = open(str(x),"r")
		fd = open(str(x)+".h","w")
		fd.write("/* this file has been generated by SCons, do not edit! */\n")
		fd.write("static const char *"+name+"=\n")
		line=fs.readline()
		while(line):
			line=line.replace("\r","")
			line=line.replace("\n","")
			line=line.replace("\\","\\\\")
			line=line.replace("\"","\\\"")
			fd.write("\""+line+"\\n\"\n")
			line=fs.readline()

		fd.write(";\n")

	return 0


def build_glsl_header( filename ):

	fs = open(filename,"r")
	line=fs.readline()

	vertex_lines=[]
	fragment_lines=[]
	uniforms=[]
	attributes=[]
	fbos=[]
	conditionals=[]
	texunits=[]
	texunit_names=[]
	ubos=[]
	ubo_names=[]

	reading=""
	line_offset=0
	vertex_offset=0
	fragment_offset=0

	while(line):

		if (line.find("[vertex]")!=-1):
			reading="vertex"
			line=fs.readline()
			line_offset+=1
			vertex_offset=line_offset
			continue

		if (line.find("[fragment]")!=-1):
			reading="fragment"
			line=fs.readline()
			line_offset+=1
			fragment_offset=line_offset
			continue

		if (line.find("#ifdef ")!=-1):
			ifdefline = line.replace("#ifdef ","").strip()
			if (not ifdefline in conditionals):
				conditionals+=[ifdefline]

		if (line.find("#elif defined(")!=-1):
			ifdefline = line.replace("#elif defined(","").strip()
			ifdefline = ifdefline.replace(")","").strip()
			if (not ifdefline in conditionals):
				conditionals+=[ifdefline]


		import re
		if re.search(r"^\s*uniform", line):

			if (line.lower().find("texunit:")!=-1):
				#texture unit
				texunit = str(int( line[line.find(":")+1:].strip() ))
				uline=line[:line.lower().find("//")]
				uline = uline.replace("uniform","");
				uline = uline.replace(";","");
				lines = uline.split(",")
				for x in lines:

					x = x.strip()
					x = x[ x.rfind(" ")+1: ]
					if (x.find("[")!=-1):
						#unfiorm array
						x = x[ :x.find("[") ]

					if (not x in texunit_names):
						texunits+=[(x,texunit)]
						texunit_names+=[x]

			elif (line.lower().find("ubo:")!=-1):
				#ubo
				uboidx = str(int( line[line.find(":")+1:].strip() ))
				uline=line[:line.lower().find("//")]
				uline = uline[uline.find("uniform")+len("uniform"):];
				uline = uline.replace(";","");
				uline = uline.replace("{","");
				lines = uline.split(",")
				for x in lines:

					x = x.strip()
					x = x[ x.rfind(" ")+1: ]
					if (x.find("[")!=-1):
						#unfiorm array
						x = x[ :x.find("[") ]

					if (not x in ubo_names):
						ubos+=[(x,uboidx)]
						ubo_names+=[x]



			else:
				uline = line.replace("uniform","");
				uline = uline.replace(";","");
				lines = uline.split(",")
				for x in lines:

					x = x.strip()
					x = x[ x.rfind(" ")+1: ]
					if (x.find("[")!=-1):
						#unfiorm array
						x = x[ :x.find("[") ]

					if (not x in uniforms):
						uniforms+=[x]

		if ((line.strip().find("in ")==0 or line.strip().find("attribute ")==0) and line.find("attrib:")!=-1):
			uline = line.replace("in ","");
			uline = uline.replace("attribute ","");
			uline = uline.replace(";","");
			uline = uline[ uline.find(" "): ].strip()


			if (uline.find("//")!=-1):
				name,bind = uline.split("//")
				if (bind.find("attrib:")!=-1):
					name=name.strip()
					bind=bind.replace("attrib:","").strip()
					attributes+=[(name,bind)]

		if (line.strip().find("out ")==0):
			uline = line.replace("out","").strip();
			uline = uline.replace(";","");
			uline = uline[ uline.find(" "): ].strip()


			if (uline.find("//")!=-1):
				name,bind = uline.split("//")
				if (bind.find("drawbuffer:")!=-1):
					name=name.strip()
					bind=bind.replace("drawbuffer:","").strip()
					fbos+=[(name,bind)]

		line=line.replace("\r","")
		line=line.replace("\n","")
		line=line.replace("\\","\\\\")
		line=line.replace("\"","\\\"")
		#line=line+"\\n\\" no need to anymore

		if (reading=="vertex"):
			vertex_lines+=[line]
		if (reading=="fragment"):
			fragment_lines+=[line]

		line=fs.readline()
		line_offset+=1

	fs.close();

	out_file = filename+".h"
	fd = open(out_file,"w")

	fd.write("/* WARNING, THIS FILE WAS GENERATED, DO NOT EDIT */\n");

	out_file_base = out_file
	out_file_base = out_file_base[ out_file_base.rfind("/")+1: ]
	out_file_base = out_file_base[ out_file_base.rfind("\\")+1: ]
#	print("out file "+out_file+" base " +out_file_base)
	out_file_ifdef = out_file_base.replace(".","_").upper()
	fd.write("#ifndef "+out_file_ifdef+"\n")
	fd.write("#define "+out_file_ifdef+"\n")

	out_file_class = out_file_base.replace(".glsl.h","").title().replace("_","").replace(".","")+"ShaderGL";
	fd.write("\n\n");
	fd.write("#include \"drivers/opengl/shader_gl.h\"\n\n\n");
	fd.write("class "+out_file_class+" : public ShaderGL {\n\n");
	fd.write("\t virtual String get_shader_name() const { return \""+out_file_class+"\"; }\n");
	fd.write("public:\n\n");

	if (len(conditionals)):
		fd.write("\tenum Conditionals {\n");
		for x in conditionals:
			fd.write("\t\t"+x+",\n");
		fd.write("\t};\n\n");
	if (len(uniforms)):
		fd.write("\tenum Uniforms {\n");
		for x in uniforms:
			fd.write("\t\t"+x.upper()+",\n");
		fd.write("\t};\n\n");

	fd.write("\t_FORCE_INLINE_ int get_uniform(Uniforms p_uniform) const { return _get_uniform(p_uniform); }\n\n");
	if (len(conditionals)):

		fd.write("\t_FORCE_INLINE_ void set_conditional(Conditionals p_conditional,bool p_enable)  {  _set_conditional(p_conditional,p_enable); }\n\n");
	fd.write("\t#define _FU if (get_uniform(p_uniform)<0) return; ERR_FAIL_COND( get_active()!=this );\n\n ");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, float p_value) { _FU glUniform1f(get_uniform(p_uniform),p_value); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, double p_value) { _FU glUniform1f(get_uniform(p_uniform),p_value); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, uint8_t p_value) { _FU glUniform1i(get_uniform(p_uniform),p_value); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, int8_t p_value) { _FU glUniform1i(get_uniform(p_uniform),p_value); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, uint16_t p_value) { _FU glUniform1i(get_uniform(p_uniform),p_value); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, int16_t p_value) { _FU glUniform1i(get_uniform(p_uniform),p_value); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, uint32_t p_value) { _FU glUniform1i(get_uniform(p_uniform),p_value); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, int32_t p_value) { _FU glUniform1i(get_uniform(p_uniform),p_value); }\n\n");
	#fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, uint64_t p_value) { _FU glUniform1i(get_uniform(p_uniform),p_value); }\n\n");
	#fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, int64_t p_value) { _FU glUniform1i(get_uniform(p_uniform),p_value); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, unsigned long p_value) { _FU glUniform1i(get_uniform(p_uniform),p_value); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, long p_value) { _FU glUniform1i(get_uniform(p_uniform),p_value); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, const Color& p_color) { _FU GLfloat col[4]={p_color.r,p_color.g,p_color.b,p_color.a}; glUniform4fv(get_uniform(p_uniform),1,col); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, const Vector2& p_vec2) { _FU GLfloat vec2[2]={p_vec2.x,p_vec2.y}; glUniform2fv(get_uniform(p_uniform),1,vec2); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, const Vector3& p_vec3) { _FU GLfloat vec3[3]={p_vec3.x,p_vec3.y,p_vec3.z}; glUniform3fv(get_uniform(p_uniform),1,vec3); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, float p_a, float p_b) { _FU glUniform2f(get_uniform(p_uniform),p_a,p_b); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, float p_a, float p_b, float p_c) { _FU glUniform3f(get_uniform(p_uniform),p_a,p_b,p_c); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, float p_a, float p_b, float p_c, float p_d) { _FU glUniform4f(get_uniform(p_uniform),p_a,p_b,p_c,p_d); }\n\n");

	fd.write("""\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, const Transform& p_transform) {  _FU

		const Transform &tr = p_transform;

		GLfloat matrix[16]={ /* build a 16x16 matrix */
			tr.basis.elements[0][0],
			tr.basis.elements[1][0],
			tr.basis.elements[2][0],
			0,
			tr.basis.elements[0][1],
			tr.basis.elements[1][1],
			tr.basis.elements[2][1],
			0,
			tr.basis.elements[0][2],
			tr.basis.elements[1][2],
			tr.basis.elements[2][2],
			0,
			tr.origin.x,
			tr.origin.y,
			tr.origin.z,
			1
		};


	glUniformMatrix4fv(get_uniform(p_uniform),1,false,matrix);


	}

	""");

	fd.write("""\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, const Matrix32& p_transform) {  _FU

		const Matrix32 &tr = p_transform;

		GLfloat matrix[16]={ /* build a 16x16 matrix */
			tr.elements[0][0],
			tr.elements[0][1],
			0,
			0,
			tr.elements[1][0],
			tr.elements[1][1],
			0,
			0,
			0,
			0,
			1,
			0,
			tr.elements[2][0],
			tr.elements[2][1],
			0,
			1
		};


	glUniformMatrix4fv(get_uniform(p_uniform),1,false,matrix);


	}

	""");

	fd.write("""\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, const CameraMatrix& p_matrix) {  _FU

		GLfloat matrix[16];

		for (int i=0;i<4;i++) {
			for (int j=0;j<4;j++) {

				matrix[i*4+j]=p_matrix.matrix[i][j];
			}
		}

		glUniformMatrix4fv(get_uniform(p_uniform),1,false,matrix);
	}; """);

	fd.write("\n\n#undef _FU\n\n\n");


	fd.write("\tvirtual void init() {\n\n");
	if (len(conditionals)):

		fd.write("\t\tstatic const char* _conditional_strings[]={\n")
		if (len(conditionals)):
			for x in conditionals:
				fd.write("\t\t\t\"#define "+x+"\\n\",\n");
		fd.write("\t\t};\n\n");
	else:
		fd.write("\t\tstatic const char **_conditional_strings=NULL;\n")

	if (len(uniforms)):

		fd.write("\t\tstatic const char* _uniform_strings[]={\n")
		if (len(uniforms)):
			for x in uniforms:
				fd.write("\t\t\t\""+x+"\",\n");
		fd.write("\t\t};\n\n");
	else:
		fd.write("\t\tstatic const char **_uniform_strings=NULL;\n")

	if (len(attributes)):

		fd.write("\t\tstatic AttributePair _attribute_pairs[]={\n")
		for x in attributes:
			fd.write("\t\t\t{\""+x[0]+"\","+x[1]+"},\n");
		fd.write("\t\t};\n\n");
	else:
		fd.write("\t\tstatic AttributePair *_attribute_pairs=NULL;\n")



	if (len(fbos)):
		fd.write("\t\tstatic FBOPair _fbo_pairs[]={\n")
		for x in fbos:
			fd.write("\t\t\t{\""+x[0]+"\","+x[1]+"},\n");
		fd.write("\t\t};\n\n");
	else:
		fd.write("\t\tstatic FBOPair *_fbo_pairs=NULL;\n")

	if (len(ubos)):
		fd.write("\t\tstatic UBOPair _ubo_pairs[]={\n")
		for x in ubos:
			fd.write("\t\t\t{\""+x[0]+"\","+x[1]+"},\n");
		fd.write("\t\t};\n\n");
	else:
		fd.write("\t\tstatic UBOPair *_ubo_pairs=NULL;\n")

	if (len(texunits)):
		fd.write("\t\tstatic TexUnitPair _texunit_pairs[]={\n")
		for x in texunits:
			fd.write("\t\t\t{\""+x[0]+"\","+x[1]+"},\n");
		fd.write("\t\t};\n\n");
	else:
		fd.write("\t\tstatic TexUnitPair *_texunit_pairs=NULL;\n")

	fd.write("\t\tstatic const char* _vertex_code=\"\\\n")
	for x in vertex_lines:
		fd.write("\t\t\t"+x+"\n");
	fd.write("\t\t\";\n\n");

	fd.write("\t\tstatic const int _vertex_code_start="+str(vertex_offset)+";\n")


	fd.write("\t\tstatic const char* _fragment_code=\"\\\n")
	for x in fragment_lines:
		fd.write("\t\t\t"+x+"\n");
	fd.write("\t\t\";\n\n");

	fd.write("\t\tstatic const int _fragment_code_start="+str(fragment_offset)+";\n")

	fd.write("\t\tsetup(_conditional_strings,"+str(len(conditionals))+",_uniform_strings,"+str(len(uniforms))+",_attribute_pairs,"+str(len(attributes))+",_fbo_pairs,"+str(len(fbos))+",_ubo_pairs,"+str(len(ubos))+",_texunit_pairs,"+str(len(texunits))+",_vertex_code,_fragment_code,_vertex_code_start,_fragment_code_start);\n")
	fd.write("\t};\n\n")

	fd.write("};\n\n");
	fd.write("#endif\n\n");
	fd.close();


def build_glsl_headers( target, source, env ):

	for x in source:

		build_glsl_header(str(x));


	return 0



def build_hlsl_dx9_header( filename ):

	fs = open(filename,"r")
	line=fs.readline()

	vertex_lines=[]
	fragment_lines=[]
	uniforms=[]
	fragment_uniforms=[]
	attributes=[]
	fbos=[]
	conditionals=[]

	reading=""
	line_offset=0
	vertex_offset=0
	fragment_offset=0

	while(line):

		if (line.find("[vertex]")!=-1):
			reading="vertex"
			line=fs.readline()
			line_offset+=1
			vertex_offset=line_offset
			continue

		if (line.find("[fragment]")!=-1):
			reading="fragment"
			line=fs.readline()
			line_offset+=1
			fragment_offset=line_offset
			continue

		if (line.find("#ifdef ")!=-1):
			ifdefline = line.replace("#ifdef ","").strip()
			if (not ifdefline in conditionals):
				conditionals+=[ifdefline]

		if (line.find("#elif defined(")!=-1):
			ifdefline = line.replace("#elif defined(","").strip()
			ifdefline = ifdefline.replace(")","").strip()
			if (not ifdefline in conditionals):
				conditionals+=[ifdefline]
		if (line.find("uniform")!=-1):
			uline = line.replace("uniform","");
			uline = uline.replace(";","");
			lines = uline.split(",")
			for x in lines:

				x = x.strip()
				x = x[ x.rfind(" ")+1: ]
				if (x.find("[")!=-1):
					#unfiorm array
					x = x[ :x.find("[") ]

				if (not x in uniforms):
					uniforms+=[x]
					fragment_uniforms+=[reading=="fragment"]
		line=line.replace("\r","")
		line=line.replace("\n","")
		line=line.replace("\\","\\\\")
		line=line.replace("\"","\\\"")
		line=line+"\\n\\"

		if (reading=="vertex"):
			vertex_lines+=[line]
		if (reading=="fragment"):
			fragment_lines+=[line]

		line=fs.readline()
		line_offset+=1

	fs.close();

	out_file = filename+".h"
	fd = open(out_file,"w")

	fd.write("/* WARNING, THIS FILE WAS GENERATED, DO NOT EDIT */\n");

	out_file_base = out_file
	out_file_base = out_file_base[ out_file_base.rfind("/")+1: ]
	out_file_base = out_file_base[ out_file_base.rfind("\\")+1: ]
#	print("out file "+out_file+" base " +out_file_base)
	out_file_ifdef = out_file_base.replace(".","_").upper()
	fd.write("#ifndef "+out_file_ifdef+"\n")
	fd.write("#define "+out_file_ifdef+"\n")

	out_file_class = out_file_base.replace(".hlsl.h","").title().replace("_","").replace(".","")+"ShaderDX9";
	fd.write("\n\n");
	fd.write("#include \"drivers/directx9/shader_dx9.h\"\n\n\n");
	fd.write("class "+out_file_class+" : public ShaderDX9 {\n\n");
	fd.write("\t virtual String get_shader_name() const { return \""+out_file_class+"\"; }\n");
	fd.write("public:\n\n");

	if (len(conditionals)):
		fd.write("\tenum Conditionals {\n");
		for x in conditionals:
			fd.write("\t\t"+x+",\n");
		fd.write("\t};\n\n");
	if (len(uniforms)):
		fd.write("\tenum Uniforms {\n");
		for x in uniforms:
			fd.write("\t\t"+x.upper()+",\n");
		fd.write("\t};\n\n");


	if (len(conditionals)):
		fd.write("\t_FORCE_INLINE_ void set_conditional(Conditionals p_conditional,bool p_enable)  {  _set_conditional(p_conditional,p_enable); }\n\n");

	fd.write("\t#define _FU if (!_uniform_valid(p_uniform)) return; ERR_FAIL_COND( get_active()!=this );\n\n ");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, bool p_value) { _FU set_uniformb(p_uniform,p_value); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, float p_value) { _FU set_uniformf(p_uniform,p_value); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, double p_value) { _FU set_uniformf(p_uniform,p_value); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, uint8_t p_value) { _FU set_uniformi(p_uniform,p_value); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, int8_t p_value) { _FU set_uniformi(p_uniform,p_value); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, uint16_t p_value) { _FU set_uniformi(p_uniform,p_value); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, int16_t p_value) { _FU set_uniformi(p_uniform,p_value); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, uint32_t p_value) { _FU set_uniformi(p_uniform,p_value); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, int32_t p_value) { _FU set_uniformi(p_uniform,p_value); }\n\n");
	#fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, uint64_t p_value) { _FU set_uniformi(p_uniform,p_value); }\n\n");
	#fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, int64_t p_value) { _FU set_uniformi(p_uniform,p_value); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, unsigned long p_value) { _FU set_uniformi(p_uniform,p_value); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, long p_value) { _FU set_uniformi(p_uniform,p_value); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, const Color& p_color) { _FU float col[4]={p_color.r,p_color.g,p_color.b,p_color.a}; set_uniformfv(p_uniform,col); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, const Vector2& p_vec2) { _FU float vec2[4]={p_vec2.x,p_vec2.y,0,0}; set_uniformfv(p_uniform,vec2); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, const Vector3& p_vec3) { _FU float vec3[4]={p_vec3.x,p_vec3.y,p_vec3.z,0}; set_uniformfv(p_uniform,vec3); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, float p_a, float p_b) { _FU float vec2[4]={p_a,p_b,0,0}; set_uniformfv(p_uniform,vec2); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, float p_a, float p_b, float p_c) { _FU float vec3[4]={p_a,p_b,p_c,0}; set_uniformfv(p_uniform,vec3); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, float p_a, float p_b, float p_c, float p_d) { _FU float vec4[4]={p_a,p_b,p_c,p_d}; set_uniformfv(p_uniform,vec4); }\n\n");

	fd.write("""\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, const Transform& p_transform) {  _FU

		const Transform &tr = p_transform;

		float matrix[16]={ /* build a 16x16 matrix */
			tr.basis.elements[0][0],
			tr.basis.elements[0][1],
			tr.basis.elements[0][2],
			tr.origin.x,
			tr.basis.elements[1][0],
			tr.basis.elements[1][1],
			tr.basis.elements[1][2],
			tr.origin.y,
			tr.basis.elements[2][0],
			tr.basis.elements[2][1],
			tr.basis.elements[2][2],
			tr.origin.z,
			0,
			0,
			0,
			1
		};

		set_uniformfv(p_uniform,&matrix[0],4);

	}

	""");

	fd.write("""\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, const CameraMatrix& p_matrix) {  _FU

		float matrix[16];

		for (int i=0;i<4;i++) {
			for (int j=0;j<4;j++) {

				matrix[i*4+j]=p_matrix.matrix[j][i];
			}
		}

		set_uniformfv(p_uniform,&matrix[0],4);
	}; """);

	fd.write("\n\n#undef _FU\n\n\n");


	fd.write("\tvirtual void init(IDirect3DDevice9 *p_device,ShaderSupport p_version) {\n\n");
	if (len(conditionals)):

		fd.write("\t\tstatic const char* _conditional_strings[]={\n")
		if (len(conditionals)):
			for x in conditionals:
				fd.write("\t\t\t\""+x+"\",\n");
		fd.write("\t\t};\n\n");
	else:
		fd.write("\t\tstatic const char **_conditional_strings=NULL;\n")

	if (len(uniforms)):

		fd.write("\t\tstatic const char* _uniform_strings[]={\n")
		if (len(uniforms)):
			for x in uniforms:
				fd.write("\t\t\t\""+x+"\",\n");
		fd.write("\t\t};\n\n");

		fd.write("\t\tstatic const bool _fragment_uniforms[]={\n")

		if (len(uniforms)):
			for x in fragment_uniforms:
				if (x):
					fd.write("\t\t\ttrue,\n");
				else:
					fd.write("\t\t\tfalse,\n");
		fd.write("\t\t};\n\n");
	else:
		fd.write("\t\tstatic const char **_uniform_strings=NULL;\n")
		fd.write("\t\tstatic const bool *_fragment_uniforms=NULL;\n")


	fd.write("\t\tstatic const char* _vertex_code=\"\\\n")
	for x in vertex_lines:
		fd.write("\t\t\t"+x+"\n");
	fd.write("\t\t\";\n\n");

	fd.write("\t\tstatic const int _vertex_code_start="+str(vertex_offset)+";\n")


	fd.write("\t\tstatic const char* _fragment_code=\"\\\n")
	for x in fragment_lines:
		fd.write("\t\t\t"+x+"\n");
	fd.write("\t\t\";\n\n");

	fd.write("\t\tstatic const int _fragment_code_start="+str(fragment_offset)+";\n")

	fd.write("\t\tsetup(p_device,p_version,_conditional_strings,"+str(len(conditionals))+",_uniform_strings,"+str(len(uniforms))+",_fragment_uniforms,_vertex_code,_fragment_code,_vertex_code_start,_fragment_code_start);\n")
	fd.write("\t};\n\n")

	fd.write("};\n\n");
	fd.write("#endif\n\n");
	fd.close();


def build_hlsl_dx9_headers( target, source, env ):

	for x in source:

		build_hlsl_dx9_header(str(x));


	return 0


def build_legacygl_header( filename, include, class_suffix, output_attribs ):

	fs = open(filename,"r")
	line=fs.readline()

	vertex_lines=[]
	fragment_lines=[]
	uniforms=[]
	attributes=[]
	fbos=[]
	conditionals=[]
	enums={}
	enum_constants=[]
	texunits=[]
	texunit_names=[]
	ubos=[]
	ubo_names=[]

	reading=""
	line_offset=0
	vertex_offset=0
	fragment_offset=0

	while(line):

		if (line.find("[vertex]")!=-1):
			reading="vertex"
			line=fs.readline()
			line_offset+=1
			vertex_offset=line_offset
			continue

		if (line.find("[fragment]")!=-1):
			reading="fragment"
			line=fs.readline()
			line_offset+=1
			fragment_offset=line_offset
			continue

		if (line.find("#ifdef ")!=-1 or line.find("#elif defined(")!=-1):
			if (line.find("#ifdef ")!=-1):
				ifdefline = line.replace("#ifdef ","").strip()
			else:
				ifdefline = line.replace("#elif defined(","").strip()
				ifdefline = ifdefline.replace(")","").strip()

			if (line.find("_EN_")!=-1):
				enumbase = ifdefline[:ifdefline.find("_EN_")];
				ifdefline = ifdefline.replace("_EN_","_")
				line = line.replace("_EN_","_")
#				print(enumbase+":"+ifdefline);
				if (enumbase not in enums):
					enums[enumbase]=[]
				if (ifdefline not in enums[enumbase]):
					enums[enumbase].append(ifdefline);

			elif (not ifdefline in conditionals):
				conditionals+=[ifdefline]

		if (line.find("uniform")!=-1 and line.lower().find("texunit:")!=-1):
			#texture unit
			texunitstr = line[line.find(":")+1:].strip()
			if (texunitstr=="auto"):
				texunit="-1"
			else:
				texunit = str(int(texunitstr ))
			uline=line[:line.lower().find("//")]
			uline = uline.replace("uniform","");
			uline = uline.replace("highp","");
			uline = uline.replace(";","");
			lines = uline.split(",")
			for x in lines:

				x = x.strip()
				x = x[ x.rfind(" ")+1: ]
				if (x.find("[")!=-1):
					#unfiorm array
					x = x[ :x.find("[") ]

				if (not x in texunit_names):
					texunits+=[(x,texunit)]
					texunit_names+=[x]



		elif (line.find("uniform")!=-1):
			uline = line.replace("uniform","");
			uline = uline.replace(";","");
			lines = uline.split(",")
			for x in lines:

				x = x.strip()
				x = x[ x.rfind(" ")+1: ]
				if (x.find("[")!=-1):
					#unfiorm array
					x = x[ :x.find("[") ]

				if (not x in uniforms):
					uniforms+=[x]


		if ((line.strip().find("in ")==0 or line.strip().find("attribute ")==0) and line.find("attrib:")!=-1):
			uline = line.replace("in ","");
			uline = uline.replace("attribute ","");
			uline = uline.replace("highp ","");
			uline = uline.replace(";","");
			uline = uline[ uline.find(" "): ].strip()


			if (uline.find("//")!=-1):
				name,bind = uline.split("//")
				if (bind.find("attrib:")!=-1):
					name=name.strip()
					bind=bind.replace("attrib:","").strip()
					attributes+=[(name,bind)]


		line=line.replace("\r","")
		line=line.replace("\n","")
		#line=line.replace("\\","\\\\")
		#line=line.replace("\"","\\\"")
		#line=line+"\\n\\"

		if (reading=="vertex"):
			vertex_lines+=[line]
		if (reading=="fragment"):
			fragment_lines+=[line]

		line=fs.readline()
		line_offset+=1

	fs.close();

	out_file = filename+".h"
	fd = open(out_file,"w")

	fd.write("/* WARNING, THIS FILE WAS GENERATED, DO NOT EDIT */\n");

	out_file_base = out_file
	out_file_base = out_file_base[ out_file_base.rfind("/")+1: ]
	out_file_base = out_file_base[ out_file_base.rfind("\\")+1: ]
#	print("out file "+out_file+" base " +out_file_base)
	out_file_ifdef = out_file_base.replace(".","_").upper()
	fd.write("#ifndef "+out_file_ifdef+class_suffix+"_120\n")
	fd.write("#define "+out_file_ifdef+class_suffix+"_120\n")

	out_file_class = out_file_base.replace(".glsl.h","").title().replace("_","").replace(".","")+"Shader"+class_suffix;
	fd.write("\n\n");
	fd.write("#include \"" + include + "\"\n\n\n");
	fd.write("class "+out_file_class+" : public Shader"+class_suffix+" {\n\n");
	fd.write("\t virtual String get_shader_name() const { return \""+out_file_class+"\"; }\n");


	fd.write("public:\n\n");

	if (len(conditionals)):
		fd.write("\tenum Conditionals {\n");
		for x in conditionals:
			fd.write("\t\t"+x.upper()+",\n");
		fd.write("\t};\n\n");


	if (len(uniforms)):
		fd.write("\tenum Uniforms {\n");
		for x in uniforms:
			fd.write("\t\t"+x.upper()+",\n");
		fd.write("\t};\n\n");

	fd.write("\t_FORCE_INLINE_ int get_uniform(Uniforms p_uniform) const { return _get_uniform(p_uniform); }\n\n");
	if (len(conditionals)):

		fd.write("\t_FORCE_INLINE_ void set_conditional(Conditionals p_conditional,bool p_enable)  {  _set_conditional(p_conditional,p_enable); }\n\n");
	fd.write("\t#define _FU if (get_uniform(p_uniform)<0) return; ERR_FAIL_COND( get_active()!=this );\n\n ");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, float p_value) { _FU glUniform1f(get_uniform(p_uniform),p_value); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, double p_value) { _FU glUniform1f(get_uniform(p_uniform),p_value); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, uint8_t p_value) { _FU glUniform1i(get_uniform(p_uniform),p_value); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, int8_t p_value) { _FU glUniform1i(get_uniform(p_uniform),p_value); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, uint16_t p_value) { _FU glUniform1i(get_uniform(p_uniform),p_value); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, int16_t p_value) { _FU glUniform1i(get_uniform(p_uniform),p_value); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, uint32_t p_value) { _FU glUniform1i(get_uniform(p_uniform),p_value); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, int32_t p_value) { _FU glUniform1i(get_uniform(p_uniform),p_value); }\n\n");
	#fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, uint64_t p_value) { _FU glUniform1i(get_uniform(p_uniform),p_value); }\n\n");
	#fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, int64_t p_value) { _FU glUniform1i(get_uniform(p_uniform),p_value); }\n\n");
	#fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, unsigned long p_value) { _FU glUniform1i(get_uniform(p_uniform),p_value); }\n\n");
	#fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, long p_value) { _FU glUniform1i(get_uniform(p_uniform),p_value); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, const Color& p_color) { _FU GLfloat col[4]={p_color.r,p_color.g,p_color.b,p_color.a}; glUniform4fv(get_uniform(p_uniform),1,col); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, const Vector2& p_vec2) { _FU GLfloat vec2[2]={p_vec2.x,p_vec2.y}; glUniform2fv(get_uniform(p_uniform),1,vec2); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, const Vector3& p_vec3) { _FU GLfloat vec3[3]={p_vec3.x,p_vec3.y,p_vec3.z}; glUniform3fv(get_uniform(p_uniform),1,vec3); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, float p_a, float p_b) { _FU glUniform2f(get_uniform(p_uniform),p_a,p_b); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, float p_a, float p_b, float p_c) { _FU glUniform3f(get_uniform(p_uniform),p_a,p_b,p_c); }\n\n");
	fd.write("\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, float p_a, float p_b, float p_c, float p_d) { _FU glUniform4f(get_uniform(p_uniform),p_a,p_b,p_c,p_d); }\n\n");

	fd.write("""\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, const Transform& p_transform) {  _FU

		const Transform &tr = p_transform;

		GLfloat matrix[16]={ /* build a 16x16 matrix */
			tr.basis.elements[0][0],
			tr.basis.elements[1][0],
			tr.basis.elements[2][0],
			0,
			tr.basis.elements[0][1],
			tr.basis.elements[1][1],
			tr.basis.elements[2][1],
			0,
			tr.basis.elements[0][2],
			tr.basis.elements[1][2],
			tr.basis.elements[2][2],
			0,
			tr.origin.x,
			tr.origin.y,
			tr.origin.z,
			1
		};


	glUniformMatrix4fv(get_uniform(p_uniform),1,false,matrix);


	}

	""");

	fd.write("""\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, const Matrix32& p_transform) {  _FU

		const Matrix32 &tr = p_transform;

		GLfloat matrix[16]={ /* build a 16x16 matrix */
			tr.elements[0][0],
			tr.elements[0][1],
			0,
			0,
			tr.elements[1][0],
			tr.elements[1][1],
			0,
			0,
			0,
			0,
			1,
			0,
			tr.elements[2][0],
			tr.elements[2][1],
			0,
			1
		};


	glUniformMatrix4fv(get_uniform(p_uniform),1,false,matrix);


	}

	""");

	fd.write("""\t_FORCE_INLINE_ void set_uniform(Uniforms p_uniform, const CameraMatrix& p_matrix) {  _FU

		GLfloat matrix[16];

		for (int i=0;i<4;i++) {
			for (int j=0;j<4;j++) {

				matrix[i*4+j]=p_matrix.matrix[i][j];
			}
		}

		glUniformMatrix4fv(get_uniform(p_uniform),1,false,matrix);
	}; """);

	fd.write("\n\n#undef _FU\n\n\n");


	fd.write("\tvirtual void init() {\n\n");


	enum_value_count=0;

	if (len(enums)):

		fd.write("\t\t//Written using math, given nonstandarity of 64 bits integer constants..\n");
		fd.write("\t\tstatic const Enum _enums[]={\n")

		bitofs=len(conditionals)
		enum_vals=[]

		for xv in enums:
			x=enums[xv]
			bits=1
			amt = len(x);
#			print(x)
			while(2**bits < amt):
				bits+=1
#			print("amount: "+str(amt)+" bits "+str(bits));
			strs="{"
			for i in range(amt):
				strs+="\"#define "+x[i]+"\\n\","

				v={}
				v["set_mask"]="uint64_t("+str(i)+")<<"+str(bitofs)
				v["clear_mask"]="((uint64_t(1)<<40)-1) ^ (((uint64_t(1)<<"+str(bits)+") - 1)<<"+str(bitofs)+")"
				enum_vals.append(v)
				enum_constants.append(x[i])

			strs+="NULL}"

			fd.write("\t\t\t{(uint64_t(1<<"+str(bits)+")-1)<<"+str(bitofs)+","+str(bitofs)+","+strs+"},\n");
			bitofs+=bits


		fd.write("\t\t};\n\n");

		fd.write("\t\tstatic const EnumValue _enum_values[]={\n")

		enum_value_count=len(enum_vals);
		for x in enum_vals:
			fd.write("\t\t\t{"+x["set_mask"]+","+x["clear_mask"]+"},\n");

		fd.write("\t\t};\n\n");
	else:
		fd.write("\t\tstatic const Enum *_enums=NULL;\n")
		fd.write("\t\tstatic const EnumValue *_enum_values=NULL;\n")

	if (len(conditionals)):

		fd.write("\t\tstatic const char* _conditional_strings[]={\n")
		if (len(conditionals)):
			for x in conditionals:
				fd.write("\t\t\t\"#define "+x+"\\n\",\n");
		fd.write("\t\t};\n\n");
	else:
		fd.write("\t\tstatic const char **_conditional_strings=NULL;\n")

	if (len(uniforms)):

		fd.write("\t\tstatic const char* _uniform_strings[]={\n")
		if (len(uniforms)):
			for x in uniforms:
				fd.write("\t\t\t\""+x+"\",\n");
		fd.write("\t\t};\n\n");
	else:
		fd.write("\t\tstatic const char **_uniform_strings=NULL;\n")

	if output_attribs:
		if (len(attributes)):

			fd.write("\t\tstatic AttributePair _attribute_pairs[]={\n")
			for x in attributes:
				fd.write("\t\t\t{\""+x[0]+"\","+x[1]+"},\n");
			fd.write("\t\t};\n\n");
		else:
			fd.write("\t\tstatic AttributePair *_attribute_pairs=NULL;\n")


	if (len(texunits)):
		fd.write("\t\tstatic TexUnitPair _texunit_pairs[]={\n")
		for x in texunits:
			fd.write("\t\t\t{\""+x[0]+"\","+x[1]+"},\n");
		fd.write("\t\t};\n\n");
	else:
		fd.write("\t\tstatic TexUnitPair *_texunit_pairs=NULL;\n")

	fd.write("\t\tstatic const char _vertex_code[]={\n")
	for x in vertex_lines:
		for i in range(len(x)):
			fd.write(str(ord(x[i]))+",");

		fd.write(str(ord('\n'))+",");
	fd.write("\t\t0};\n\n");

	fd.write("\t\tstatic const int _vertex_code_start="+str(vertex_offset)+";\n")


	fd.write("\t\tstatic const char _fragment_code[]={\n")
	for x in fragment_lines:
		for i in range(len(x)):
			fd.write(str(ord(x[i]))+",");

		fd.write(str(ord('\n'))+",");
	fd.write("\t\t0};\n\n");

	fd.write("\t\tstatic const int _fragment_code_start="+str(fragment_offset)+";\n")

	if output_attribs:
		fd.write("\t\tsetup(_conditional_strings,"+str(len(conditionals))+",_uniform_strings,"+str(len(uniforms))+",_attribute_pairs,"+str(len(attributes))+", _texunit_pairs,"+str(len(texunits))+",_vertex_code,_fragment_code,_vertex_code_start,_fragment_code_start);\n")
	else:
		fd.write("\t\tsetup(_conditional_strings,"+str(len(conditionals))+",_uniform_strings,"+str(len(uniforms))+",_texunit_pairs,"+str(len(texunits))+",_enums,"+str(len(enums))+",_enum_values,"+str(enum_value_count)+",_vertex_code,_fragment_code,_vertex_code_start,_fragment_code_start);\n")

	fd.write("\t};\n\n")


	if (len(enum_constants)):

		fd.write("\tenum EnumConditionals {\n")
		for x in enum_constants:
			fd.write("\t\t"+x.upper()+",\n");
		fd.write("\t};\n\n");
		fd.write("\tvoid set_enum_conditional(EnumConditionals p_cond) { _set_enum_conditional(p_cond); }\n")


	fd.write("};\n\n");
	fd.write("#endif\n\n");
	fd.close();


def build_legacygl_headers( target, source, env ):

	for x in source:

		build_legacygl_header(str(x), include = "drivers/legacygl/shader_lgl.h", class_suffix = "LGL", output_attribs = False);


	return 0

def build_gles2_headers( target, source, env ):

	for x in source:
		build_legacygl_header(str(x), include="drivers/gles2/shader_gles2.h", class_suffix = "GLES2", output_attribs = True)

def update_version():

	rev = "custom_build"

	if (os.getenv("BUILD_REVISION")!=None):
		rev=os.getenv("BUILD_REVISION")
		print("Using custom revision: "+rev)
	import version


	f=open("core/version.h","wb")
	f.write("#define VERSION_SHORT_NAME "+str(version.short_name)+"\n")
	f.write("#define VERSION_NAME "+str(version.name)+"\n")
	f.write("#define VERSION_MAJOR "+str(version.major)+"\n")
	f.write("#define VERSION_MINOR "+str(version.minor)+"\n")
	if (hasattr(version, 'patch')):
	    f.write("#define VERSION_PATCH "+str(version.patch)+"\n")
	f.write("#define VERSION_REVISION "+str(rev)+"\n")
	f.write("#define VERSION_STATUS "+str(version.status)+"\n")
	import datetime
	f.write("#define VERSION_YEAR "+str(datetime.datetime.now().year)+"\n")

def parse_cg_file(fname, uniforms, sizes, conditionals):

	import re
	fs = open(fname, "r")
	line=fs.readline()

	while line:

		if re.match(r"^\s*uniform", line):

			res = re.match(r"uniform ([\d\w]*) ([\d\w]*)")
			type = res.groups(1)
			name = res.groups(2)

			uniforms.append(name);

			if (type.find("texobj") != -1):
				sizes.append(1);
			else:
				t = re.match(r"float(\d)x(\d)", type);
				if t:
					sizes.append(int(t.groups(1)) * int(t.groups(2)))
				else:
					t = re.match(r"float(\d)", type);
					sizes.append(int(t.groups(1)))

			if line.find("[branch]") != -1:
				conditionals.append(name);

		line = fs.readline();


def build_cg_shader(sname):

	vp_uniforms = []
	vp_uniform_sizes = []
	vp_conditionals = []

	parse_cg_file("vp_"+sname+".cg", vp_uniforms, vp_uniform_sizes, vp_conditionals);

	fp_uniforms = []
	fp_uniform_sizes = []
	fp_conditionals = []

	parse_cg_file("fp_"+sname+".cg", fp_uniforms, fp_uniform_sizes, fp_conditionals);

	fd = open("shader_"+sname+".cg.h", "w");

	fd.write('\n#include "shader_cell.h"\n');
	fd.write("\nclass Shader_" + sname + " : public ShaderCell {\n");
	fd.write("\n\tstatic struct VertexUniforms[] = {\n");

	offset = 0;
	for i in range(0, len(vp_uniforms)):

		fd.write('\t\t{ "%s", %d, %d },\n' % (vp_uniforms[i], offset, vp_uniform_sizes[i]))
		offset = offset + vp_uniform_sizes[i];
	fd.write("\t};\n\n");

	fd.write("public:\n\n");

	fd.write("\tenum {\n");

	for i in range(0, len(vp_uniforms)):

		fd.write('\t\tVP_%s,\n' % vp_uniforms[i].upper())

	fd.write("\t};\n");



import glob
def detect_modules():

	module_list=[]
	includes_cpp=""
	register_cpp=""
	unregister_cpp=""

	for x in glob.glob("modules/*"):
		if (not os.path.isdir(x)):
			continue
		x=x.replace("modules/","") # rest of world
		x=x.replace("modules\\","") # win32
		module_list.append(x)
		try:
			with open("modules/"+x+"/register_types.h"):
				includes_cpp+='#include "modules/'+x+'/register_types.h"\n'
				register_cpp+='#ifdef MODULE_'+x.upper()+'_ENABLED\n'
				register_cpp+='\tregister_'+x+'_types();\n'
				register_cpp+='#endif\n'
				unregister_cpp+='#ifdef MODULE_'+x.upper()+'_ENABLED\n'
				unregister_cpp+='\tunregister_'+x+'_types();\n'
				unregister_cpp+='#endif\n'
		except IOError:
			pass

	modules_cpp="""
// modules.cpp - THIS FILE IS GENERATED, DO NOT EDIT!!!!!!!
#include "register_module_types.h"


"""+includes_cpp+"""

void register_module_types() {

"""+register_cpp+"""

}

void unregister_module_types() {

"""+unregister_cpp+"""

}

"""

	f=open("modules/register_module_types.cpp","wb")
	f.write(modules_cpp)

	return module_list



def win32_spawn(sh, escape, cmd, args, env):
	import subprocess
	newargs = ' '.join(args[1:])
	cmdline = cmd + " " + newargs
	startupinfo = subprocess.STARTUPINFO()
	#startupinfo.dwFlags |= subprocess.STARTF_USESHOWWINDOW
	for e in env:
		if type(env[e]) != type(""):
			env[e] = str(env[e])
	proc = subprocess.Popen(cmdline, stdin=subprocess.PIPE, stdout=subprocess.PIPE,
		stderr=subprocess.PIPE, startupinfo=startupinfo, shell = False, env = env)
	data, err = proc.communicate()
	rv = proc.wait()
	if rv:
		print "====="
		print err
		print "====="
	return rv

"""
def win32_spawn(sh, escape, cmd, args, spawnenv):
	import win32file
	import win32event
	import win32process
	import win32security
	for var in spawnenv:
		spawnenv[var] = spawnenv[var].encode('ascii', 'replace')

	sAttrs = win32security.SECURITY_ATTRIBUTES()
	StartupInfo = win32process.STARTUPINFO()
	newargs = ' '.join(map(escape, args[1:]))
	cmdline = cmd + " " + newargs

	# check for any special operating system commands
	if cmd == 'del':
		for arg in args[1:]:
			win32file.DeleteFile(arg)
		exit_code = 0
	else:
		# otherwise execute the command.
		hProcess, hThread, dwPid, dwTid = win32process.CreateProcess(None, cmdline, None, None, 1, 0, spawnenv, None, StartupInfo)
		win32event.WaitForSingleObject(hProcess, win32event.INFINITE)
		exit_code = win32process.GetExitCodeProcess(hProcess)
		win32file.CloseHandle(hProcess);
		win32file.CloseHandle(hThread);
	return exit_code
"""

def android_add_maven_repository(self,url):
	self.android_maven_repos.append(url)

def android_add_dependency(self,depline):
	self.android_dependencies.append(depline)

def android_add_java_dir(self,subpath):
	base_path = self.Dir(".").abspath+"/modules/"+self.current_module+"/"+subpath
	self.android_java_dirs.append(base_path)

def android_add_res_dir(self,subpath):
	base_path = self.Dir(".").abspath+"/modules/"+self.current_module+"/"+subpath
	self.android_res_dirs.append(base_path)
def android_add_aidl_dir(self,subpath):
	base_path = self.Dir(".").abspath+"/modules/"+self.current_module+"/"+subpath
	self.android_aidl_dirs.append(base_path)
def android_add_jni_dir(self,subpath):
	base_path = self.Dir(".").abspath+"/modules/"+self.current_module+"/"+subpath
	self.android_jni_dirs.append(base_path)

def android_add_to_manifest(self,file):
	base_path = self.Dir(".").abspath+"/modules/"+self.current_module+"/"+file
	f = open(base_path,"rb")
	self.android_manifest_chunk+=f.read()
def android_add_to_permissions(self,file):
	base_path = self.Dir(".").abspath+"/modules/"+self.current_module+"/"+file
	f = open(base_path,"rb")
	self.android_permission_chunk+=f.read()
def android_add_to_attributes(self,file):
	base_path = self.Dir(".").abspath+"/modules/"+self.current_module+"/"+file
	f = open(base_path,"rb")
	self.android_appattributes_chunk+=f.read()

def disable_module(self):
	self.disabled_modules.append(self.current_module)

def use_windows_spawn_fix(self, platform=None):

    if (os.name!="nt"):
	return #not needed, only for windows

    self.split_drivers=True

    import subprocess

    def mySubProcess(cmdline,env):
	    prefix = ""
	    if(platform == 'javascript'):
	        prefix = "python.exe "

	    startupinfo = subprocess.STARTUPINFO()
	    startupinfo.dwFlags |= subprocess.STARTF_USESHOWWINDOW
	    proc = subprocess.Popen(prefix + cmdline, stdin=subprocess.PIPE, stdout=subprocess.PIPE,
		    stderr=subprocess.PIPE, startupinfo=startupinfo, shell = False, env = env)
	    data, err = proc.communicate()
	    rv = proc.wait()
	    if rv:
		    print "====="
		    print err
		    print "====="
	    return rv

    def mySpawn(sh, escape, cmd, args, env):

	    newargs = ' '.join(args[1:])
	    cmdline = cmd + " " + newargs

	    rv=0
	    if len(cmdline) > 32000 and cmd.endswith("ar") :
		    cmdline = cmd + " " + args[1] + " " + args[2] + " "
		    for i in range(3,len(args)) :
			    rv = mySubProcess( cmdline + args[i], env )
			    if rv :
				    break
	    else:
		    rv = mySubProcess( cmdline, env )

	    return rv

    self['SPAWN'] = mySpawn


def save_active_platforms(apnames,ap):

	for x in ap:
		pth = x+"/logo.png"
#		print("open path: "+pth)
		pngf=open(pth,"rb");
		b=pngf.read(1);
		str=" /* AUTOGENERATED FILE, DO NOT EDIT */ \n"
		str+=" static const unsigned char _"+x[9:]+"_logo[]={"
		while(len(b)==1):
			str+=hex(ord(b))
			b=pngf.read(1);
			if (len(b)==1):
				str+=","

		str+="};\n"

		wf = x+"/logo.h"
		logow = open(wf,"wb")
		logow.write(str)


def colored(sys,env):

	#If the output is not a terminal, do nothing
	if not sys.stdout.isatty():
		return

	colors = {}
	colors['cyan']   = '\033[96m'
	colors['purple'] = '\033[95m'
	colors['blue']   = '\033[94m'
	colors['green']  = '\033[92m'
	colors['yellow'] = '\033[93m'
	colors['red']    = '\033[91m'
	colors['end']    = '\033[0m'

	compile_source_message        = '%sCompiling %s==> %s$SOURCE%s' % (colors['blue'], colors['purple'], colors['yellow'], colors['end'])
	java_compile_source_message   = '%sCompiling %s==> %s$SOURCE%s' % (colors['blue'], colors['purple'], colors['yellow'], colors['end'])
	compile_shared_source_message = '%sCompiling shared %s==> %s$SOURCE%s' % (colors['blue'], colors['purple'], colors['yellow'], colors['end'])
	link_program_message          = '%sLinking Program        %s==> %s$TARGET%s' % (colors['red'], colors['purple'], colors['yellow'], colors['end'])
	link_library_message          = '%sLinking Static Library %s==> %s$TARGET%s' % (colors['red'], colors['purple'], colors['yellow'], colors['end'])
	ranlib_library_message        = '%sRanlib Library         %s==> %s$TARGET%s' % (colors['red'], colors['purple'], colors['yellow'], colors['end'])
	link_shared_library_message   = '%sLinking Shared Library %s==> %s$TARGET%s' % (colors['red'], colors['purple'], colors['yellow'], colors['end'])
	java_library_message          = '%sCreating Java Archive  %s==> %s$TARGET%s' % (colors['red'], colors['purple'], colors['yellow'], colors['end'])

	env.Append( CXXCOMSTR=[compile_source_message] )
	env.Append( CCCOMSTR=[compile_source_message] )
	env.Append( SHCCCOMSTR=[compile_shared_source_message] )
	env.Append( SHCXXCOMSTR=[compile_shared_source_message] )
	env.Append( ARCOMSTR=[link_library_message] )
	env.Append( RANLIBCOMSTR=[ranlib_library_message] )
	env.Append( SHLINKCOMSTR=[link_shared_library_message] )
	env.Append( LINKCOMSTR=[link_program_message] )
	env.Append( JARCOMSTR=[java_library_message] )
	env.Append( JAVACCOMSTR=[java_compile_source_message] )

