import Image from "next/image";
import hero_light from "@/app/assets/hero.png";
import hero_mobile_light from "@/app/assets/hero-mobile.png";
import hero_dark from "@/app/assets/hero-dark.png";
import hero_mobile_dark from "@/app/assets/hero-mobile-dark.png";

export function Browser() {
  return (
    <>
      <svg
        viewBox={`0 0 ${1203} ${753}`}
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        className="m-8 hidden size-full max-h-[753px] max-w-[1203px] lg:block"
      >
        <g clipPath="url(#path0)">
          <path
            d="M0 52H1202V741C1202 747.627 1196.63 753 1190 753H12C5.37258 753 0 747.627 0 741V52Z"
            className="fill-neutral-200 dark:fill-neutral-700"
          />
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M0 12C0 5.37258 5.37258 0 12 0H1190C1196.63 0 1202 5.37258 1202 12V52H0L0 12Z"
            className="fill-neutral-200 dark:fill-neutral-700"
          />
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M1.06738 12C1.06738 5.92487 5.99225 1 12.0674 1H1189.93C1196.01 1 1200.93 5.92487 1200.93 12V51H1.06738V12Z"
            className="fill-white dark:fill-neutral-800"
          />
          <circle
            cx="27"
            cy="25"
            r="6"
            className="fill-neutral-200 dark:fill-neutral-700"
          />
          <circle
            cx="47"
            cy="25"
            r="6"
            className="fill-neutral-200 dark:fill-neutral-700"
          />
          <circle
            cx="67"
            cy="25"
            r="6"
            className="fill-neutral-200 dark:fill-neutral-700"
          />
          <path
            d="M286 17C286 13.6863 288.686 11 292 11H946C949.314 11 952 13.6863 952 17V35C952 38.3137 949.314 41 946 41H292C288.686 41 286 38.3137 286 35V17Z"
            className="fill-neutral-200 dark:fill-neutral-700"
          />
          <g className="mix-blend-luminosity">
            <path
              d="M566.269 32.0852H572.426C573.277 32.0852 573.696 31.6663 573.696 30.7395V25.9851C573.696 25.1472 573.353 24.7219 572.642 24.6521V23.0842C572.642 20.6721 571.036 19.5105 569.348 19.5105C567.659 19.5105 566.053 20.6721 566.053 23.0842V24.6711C565.393 24.7727 565 25.1917 565 25.9851V30.7395C565 31.6663 565.418 32.0852 566.269 32.0852ZM567.272 22.97C567.272 21.491 568.211 20.6785 569.348 20.6785C570.478 20.6785 571.423 21.491 571.423 22.97V24.6394L567.272 24.6458V22.97Z"
              fill="#A3A3A3"
            />
          </g>
          <g className="mix-blend-luminosity">
            <text
              x="580"
              y="30"
              className="fill-neutral-800 dark:fill-neutral-400"
              fontSize="12"
              fontFamily="Arial, sans-serif"
            >
              cup.local
            </text>
          </g>
          <g className="invisible xl:visible">
            <g className="mix-blend-luminosity">
              <path
                d="M265.5 33.8984C265.641 33.8984 265.852 33.8516 266.047 33.7422C270.547 31.2969 272.109 30.1641 272.109 27.3203V21.4219C272.109 20.4844 271.742 20.1484 270.961 19.8125C270.094 19.4453 267.18 18.4297 266.328 18.1406C266.07 18.0547 265.766 18 265.5 18C265.234 18 264.93 18.0703 264.672 18.1406C263.82 18.3828 260.906 19.4531 260.039 19.8125C259.258 20.1406 258.891 20.4844 258.891 21.4219V27.3203C258.891 30.1641 260.461 31.2812 264.945 33.7422C265.148 33.8516 265.359 33.8984 265.5 33.8984ZM265.922 19.5781C266.945 19.9766 269.172 20.7656 270.344 21.1875C270.562 21.2656 270.617 21.3828 270.617 21.6641V27.0234C270.617 29.3125 269.469 29.9375 265.945 32.0625C265.727 32.1875 265.617 32.2344 265.508 32.2344V19.4844C265.617 19.4844 265.734 19.5156 265.922 19.5781Z"
                fill="#A3A3A3"
              />
            </g>
            <g className="mix-blend-luminosity">
              <path
                d="M936.273 24.9766C936.5 24.9766 936.68 24.9062 936.82 24.7578L940.023 21.5312C940.195 21.3594 940.273 21.1719 940.273 20.9531C940.273 20.7422 940.188 20.5391 940.023 20.3828L936.82 17.125C936.68 16.9688 936.5 16.8906 936.273 16.8906C935.852 16.8906 935.516 17.2422 935.516 17.6719C935.516 17.8828 935.594 18.0547 935.727 18.2031L937.594 20.0312C937.227 19.9766 936.852 19.9453 936.477 19.9453C932.609 19.9453 929.516 23.0391 929.516 26.9141C929.516 30.7891 932.633 33.9062 936.5 33.9062C940.375 33.9062 943.484 30.7891 943.484 26.9141C943.484 26.4453 943.156 26.1094 942.688 26.1094C942.234 26.1094 941.93 26.4453 941.93 26.9141C941.93 29.9297 939.516 32.3516 936.5 32.3516C933.492 32.3516 931.07 29.9297 931.07 26.9141C931.07 23.875 933.469 21.4688 936.477 21.4688C936.984 21.4688 937.453 21.5078 937.867 21.5781L935.734 23.6875C935.594 23.8281 935.516 24 935.516 24.2109C935.516 24.6406 935.852 24.9766 936.273 24.9766Z"
                fill="#A3A3A3"
              />
            </g>
            <g className="mix-blend-luminosity">
              <path
                d="M1134 33.0156C1134.49 33.0156 1134.89 32.6094 1134.89 32.1484V27.2578H1139.66C1140.13 27.2578 1140.54 26.8594 1140.54 26.3672C1140.54 25.8828 1140.13 25.4766 1139.66 25.4766H1134.89V20.5859C1134.89 20.1172 1134.49 19.7188 1134 19.7188C1133.52 19.7188 1133.11 20.1172 1133.11 20.5859V25.4766H1128.34C1127.88 25.4766 1127.46 25.8828 1127.46 26.3672C1127.46 26.8594 1127.88 27.2578 1128.34 27.2578H1133.11V32.1484C1133.11 32.6094 1133.52 33.0156 1134 33.0156Z"
                fill="#A3A3A3"
              />
            </g>
            <g className="mix-blend-luminosity">
              <path
                d="M1161.8 31.0703H1163.23V32.375C1163.23 34.0547 1164.12 34.9219 1165.81 34.9219H1174.2C1175.89 34.9219 1176.77 34.0547 1176.77 32.3828V24.0469C1176.77 22.375 1175.89 21.5 1174.2 21.5H1172.77V20.2578C1172.77 18.5859 1171.88 17.7109 1170.19 17.7109H1161.8C1160.1 17.7109 1159.23 18.5781 1159.23 20.2578V28.5234C1159.23 30.1953 1160.1 31.0703 1161.8 31.0703ZM1161.9 29.5078C1161.18 29.5078 1160.78 29.1328 1160.78 28.3828V20.3984C1160.78 19.6406 1161.18 19.2656 1161.9 19.2656H1170.09C1170.8 19.2656 1171.2 19.6406 1171.2 20.3984V21.5H1165.81C1164.12 21.5 1163.23 22.375 1163.23 24.0469V29.5078H1161.9ZM1165.91 33.3672C1165.19 33.3672 1164.8 32.9922 1164.8 32.2422V24.1875C1164.8 23.4297 1165.19 23.0625 1165.91 23.0625H1174.1C1174.81 23.0625 1175.21 23.4297 1175.21 24.1875V32.2422C1175.21 32.9922 1174.81 33.3672 1174.1 33.3672H1165.91Z"
                fill="#A3A3A3"
              />
            </g>
            <g className="mix-blend-luminosity">
              <path
                d="M1099.51 28.4141C1099.91 28.4141 1100.24 28.0859 1100.24 27.6953V19.8359L1100.18 18.6797L1100.66 19.25L1101.75 20.4141C1101.88 20.5547 1102.06 20.625 1102.24 20.625C1102.6 20.625 1102.9 20.3672 1102.9 20C1102.9 19.8047 1102.82 19.6641 1102.69 19.5312L1100.06 17.0078C1099.88 16.8203 1099.7 16.7578 1099.51 16.7578C1099.32 16.7578 1099.14 16.8203 1098.95 17.0078L1096.33 19.5312C1096.2 19.6641 1096.12 19.8047 1096.12 20C1096.12 20.3672 1096.41 20.625 1096.77 20.625C1096.95 20.625 1097.14 20.5547 1097.27 20.4141L1098.35 19.25L1098.84 18.6719L1098.78 19.8359V27.6953C1098.78 28.0859 1099.11 28.4141 1099.51 28.4141ZM1095 34.6562H1104C1105.7 34.6562 1106.57 33.7812 1106.57 32.1094V24.4297C1106.57 22.7578 1105.7 21.8828 1104 21.8828H1101.89V23.4375H1103.9C1104.61 23.4375 1105.02 23.8125 1105.02 24.5625V31.9688C1105.02 32.7188 1104.61 33.0938 1103.9 33.0938H1095.1C1094.38 33.0938 1093.98 32.7188 1093.98 31.9688V24.5625C1093.98 23.8125 1094.38 23.4375 1095.1 23.4375H1097.13V21.8828H1095C1093.31 21.8828 1092.43 22.75 1092.43 24.4297V32.1094C1092.43 33.7812 1093.31 34.6562 1095 34.6562Z"
                fill="#A3A3A3"
              />
            </g>
            <g className="mix-blend-luminosity">
              <path
                d="M99.5703 33.6016H112.938C114.633 33.6016 115.516 32.7266 115.516 31.0547V21.5469C115.516 19.875 114.633 19 112.938 19H99.5703C97.8828 19 97 19.8672 97 21.5469V31.0547C97 32.7266 97.8828 33.6016 99.5703 33.6016ZM99.6719 32.0469C98.9531 32.0469 98.5547 31.6719 98.5547 30.9141V21.6875C98.5547 20.9297 98.9531 20.5547 99.6719 20.5547H103.234V32.0469H99.6719ZM112.836 20.5547C113.555 20.5547 113.953 20.9297 113.953 21.6875V30.9141C113.953 31.6719 113.555 32.0469 112.836 32.0469H104.711V20.5547H112.836ZM101.703 23.4141C101.984 23.4141 102.219 23.1719 102.219 22.9062C102.219 22.6406 101.984 22.4062 101.703 22.4062H100.102C99.8203 22.4062 99.5859 22.6406 99.5859 22.9062C99.5859 23.1719 99.8203 23.4141 100.102 23.4141H101.703ZM101.703 25.5156C101.984 25.5156 102.219 25.2812 102.219 25.0078C102.219 24.7422 101.984 24.5078 101.703 24.5078H100.102C99.8203 24.5078 99.5859 24.7422 99.5859 25.0078C99.5859 25.2812 99.8203 25.5156 100.102 25.5156H101.703ZM101.703 27.6094C101.984 27.6094 102.219 27.3828 102.219 27.1094C102.219 26.8438 101.984 26.6172 101.703 26.6172H100.102C99.8203 26.6172 99.5859 26.8438 99.5859 27.1094C99.5859 27.3828 99.8203 27.6094 100.102 27.6094H101.703Z"
                fill="#A3A3A3"
              />
            </g>
            <g className="mix-blend-luminosity">
              <path
                d="M143.914 32.5938C144.094 32.7656 144.312 32.8594 144.562 32.8594C145.086 32.8594 145.492 32.4531 145.492 31.9375C145.492 31.6797 145.391 31.4453 145.211 31.2656L139.742 25.9219L145.211 20.5938C145.391 20.4141 145.492 20.1719 145.492 19.9219C145.492 19.4062 145.086 19 144.562 19C144.312 19 144.094 19.0938 143.922 19.2656L137.844 25.2031C137.625 25.4062 137.516 25.6562 137.516 25.9297C137.516 26.2031 137.625 26.4375 137.836 26.6484L143.914 32.5938Z"
                fill="#A3A3A3"
              />
            </g>
            <g className="mix-blend-luminosity">
              <path
                d="M168.422 32.8594C168.68 32.8594 168.891 32.7656 169.07 32.5938L175.148 26.6562C175.359 26.4375 175.469 26.2109 175.469 25.9297C175.469 25.6562 175.367 25.4141 175.148 25.2109L169.07 19.2656C168.891 19.0938 168.68 19 168.422 19C167.898 19 167.492 19.4062 167.492 19.9219C167.492 20.1719 167.602 20.4141 167.773 20.5938L173.25 25.9375L167.773 31.2656C167.594 31.4531 167.492 31.6797 167.492 31.9375C167.492 32.4531 167.898 32.8594 168.422 32.8594Z"
                fill="#A3A3A3"
              />
            </g>
          </g>
          <foreignObject
            width="1200"
            height="700"
            x="1"
            y="52"
            preserveAspectRatio="xMidYMid slice"
            clipPath="url(#roundedBottom)"
          >
            <Image
              src={hero_light}
              alt="Screenshot of Tipi's dashboard"
              className="h-full object-cover dark:hidden"
            />
            <Image
              src={hero_dark}
              alt="Screenshot of Tipi's dashboard"
              className="hidden h-full object-cover dark:block"
            />
          </foreignObject>
        </g>
        <defs>
          <clipPath id="path0">
            <rect width={1203} height={753} fill="white" />
          </clipPath>
          <clipPath id="roundedBottom">
            <path
              d="M1 52H1201V741C1201 747.075 1196.08 752 1190 752H12C5.92486 752 1 747.075 1 741V52Z"
              fill="white"
            />
          </clipPath>
        </defs>
      </svg>
      <svg
        viewBox={`0 0 ${433} ${882}`}
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        className="m-8 size-full max-h-[882px] max-w-[433px] lg:hidden"
      >
        <path
          d="M2 73C2 32.6832 34.6832 0 75 0H357C397.317 0 430 32.6832 430 73V809C430 849.317 397.317 882 357 882H75C34.6832 882 2 849.317 2 809V73Z"
          className="fill-neutral-200 dark:fill-neutral-700"
        />
        <path
          d="M0 171C0 170.448 0.447715 170 1 170H3V204H1C0.447715 204 0 203.552 0 203V171Z"
          className="fill-neutral-200 dark:fill-neutral-700"
        />
        <path
          d="M1 234C1 233.448 1.44772 233 2 233H3.5V300H2C1.44772 300 1 299.552 1 299V234Z"
          className="fill-neutral-200 dark:fill-neutral-700"
        />
        <path
          d="M1 319C1 318.448 1.44772 318 2 318H3.5V385H2C1.44772 385 1 384.552 1 384V319Z"
          className="fill-neutral-200 dark:fill-neutral-700"
        />
        <path
          d="M430 279H432C432.552 279 433 279.448 433 280V384C433 384.552 432.552 385 432 385H430V279Z"
          className="fill-neutral-200 dark:fill-neutral-700"
        />
        <path
          d="M6 74C6 35.3401 37.3401 4 76 4H356C394.66 4 426 35.3401 426 74V808C426 846.66 394.66 878 356 878H76C37.3401 878 6 846.66 6 808V74Z"
          className="fill-white dark:fill-neutral-800"
        />
        <path
          opacity="0.5"
          d="M174 5H258V5.5C258 6.60457 257.105 7.5 256 7.5H176C174.895 7.5 174 6.60457 174 5.5V5Z"
          className="fill-neutral-200 dark:fill-neutral-700"
        />
        <path
          d="M21.25 75C21.25 44.2101 46.2101 19.25 77 19.25H355C385.79 19.25 410.75 44.2101 410.75 75V807C410.75 837.79 385.79 862.75 355 862.75H77C46.2101 862.75 21.25 837.79 21.25 807V75Z"
          className="fill-neutral-200 stroke-neutral-200 stroke-[0.5] dark:fill-neutral-700 dark:stroke-neutral-700"
        />
        <foreignObject
          x="21.25"
          y="68"
          width="389.5"
          height="843.5"
          preserveAspectRatio="xMidYMid slice"
          clipPath="url(#roundedCorners)"
        >
          <Image
            src={hero_mobile_light}
            alt="Screenshot of Tipi's dashboard"
            className="size-full object-cover dark:hidden"
          />
          <Image
            src={hero_mobile_dark}
            alt="Screenshot of Tipi's dashboard"
            className="hidden size-full object-cover dark:block"
          />
        </foreignObject>
        <rect
          x="21.25"
          y="19.25"
          width="389.5"
          height="50"
          className="fill-neutral-50 dark:fill-neutral-950"
          clipPath="url(#roundedCorners)"
        />
        <path
          className="fill-black dark:fill-white"
          strokeWidth={0.0103687}
          d="m 299.17846,52.203267 h -1.83298 q -0.35746,0 -0.57802,-0.228169 -0.22056,-0.228165 -0.22056,-0.600837 v 0 -3.4149 q 0,-0.372675 0.22056,-0.597035 0.22056,-0.224369 0.57802,-0.224369 v 0 h 1.83298 q 0.35742,0 0.578,0.224369 0.22055,0.22436 0.22055,0.597035 v 0 3.4149 q 0,0.372672 -0.22055,0.600837 -0.22058,0.228169 -0.578,0.228169 z m 5.69654,0 h -1.83298 q -0.35744,0 -0.57802,-0.228169 -0.22056,-0.228165 -0.22056,-0.600837 v 0 -5.787842 q 0,-0.372668 0.22056,-0.600836 0.22058,-0.228166 0.57802,-0.228166 v 0 h 1.83298 q 0.35742,0 0.57802,0.228166 0.22055,0.228168 0.22055,0.600836 v 0 5.787842 q 0,0.372672 -0.22055,0.600837 -0.2206,0.228169 -0.57802,0.228169 z m 5.69653,0 h -1.8329 q -0.35751,0 -0.57807,-0.228169 -0.2205,-0.228165 -0.2205,-0.600837 v 0 -8.541051 q 0,-0.372678 0.2205,-0.600846 0.22056,-0.228166 0.57807,-0.228166 v 0 h 1.8329 q 0.35745,0 0.57803,0.228166 0.22056,0.228168 0.22056,0.600846 v 0 8.541051 q 0,0.372672 -0.22056,0.600837 -0.22058,0.228169 -0.57803,0.228169 z m 5.70418,0 h -1.84815 q -0.35745,0 -0.57801,-0.228169 -0.22057,-0.228165 -0.22057,-0.600837 v 0 -11.545259 q 0,-0.372668 0.22057,-0.600834 Q 314.07011,39 314.42756,39 v 0 h 1.84816 q 0.35747,0 0.57425,0.228168 0.21673,0.228166 0.21673,0.600834 v 0 11.545259 q 0,0.372672 -0.21673,0.600837 -0.21678,0.228169 -0.57426,0.228169 z m 16.57616,0 v 0 q -0.13541,0 -0.27084,-0.07944 -0.13541,-0.07944 -0.36643,-0.301879 v 0 l -1.9357,-1.858947 q -0.0956,-0.08737 -0.11552,-0.190661 -0.02,-0.103272 0.0358,-0.198599 v 0 q 0.39033,-0.516381 1.09134,-0.905641 0.70098,-0.38927 1.56131,-0.38927 v 0 q 0.83641,0 1.53342,0.373381 0.69704,0.373374 1.08736,0.873858 v 0 q 0.0876,0.103283 0.0678,0.226415 -0.02,0.123136 -0.10754,0.210517 v 0 l -1.94369,1.858948 q -0.23101,0.230384 -0.36643,0.305846 -0.13541,0.07549 -0.27084,0.07549 z m -4.66004,-4.321643 v 0 l -1.23472,-1.231358 q -0.1036,-0.103273 -0.10754,-0.222439 -0.004,-0.11916 0.0836,-0.22243 v 0 q 0.60541,-0.738811 1.51351,-1.318742 0.90812,-0.579924 2.0353,-0.917553 1.12717,-0.337632 2.36986,-0.337632 v 0 q 1.24268,0 2.36987,0.337632 1.12717,0.337629 2.03927,0.917553 0.91208,0.579931 1.50954,1.318742 v 0 q 0.0876,0.103272 0.0798,0.226406 -0.007,0.123134 -0.10362,0.218463 v 0 l -1.2347,1.223407 q -0.12746,0.119166 -0.26688,0.119166 -0.1394,0 -0.25092,-0.119166 v 0 q -0.73286,-0.794417 -1.83216,-1.32271 -1.0993,-0.528286 -2.31012,-0.520341 v 0 q -1.19489,-0.008 -2.29417,0.50843 -1.0993,0.516371 -1.81624,1.310791 v 0 q -0.11947,0.12711 -0.27083,0.139029 -0.15138,0.01189 -0.27882,-0.107248 z m -3.30587,-3.320679 v 0 l -1.09929,-1.112192 q -0.0956,-0.111214 -0.0996,-0.230383 -0.004,-0.11916 0.0758,-0.222437 v 0 q 0.93199,-1.151905 2.35789,-2.057547 1.4259,-0.905641 3.1545,-1.422014 Q 331.00378,39 332.85187,39 v 0 q 1.84812,0 3.57671,0.520347 1.7286,0.520343 3.1545,1.422014 1.42591,0.901667 2.3579,2.053572 v 0 q 0.0876,0.103272 0.0836,0.222437 -0.004,0.119169 -0.10756,0.230383 v 0 l -1.09928,1.096304 q -0.11947,0.119159 -0.26287,0.123136 -0.14338,0.0037 -0.25491,-0.107248 v 0 q -1.45776,-1.557067 -3.3616,-2.367376 -1.90385,-0.810306 -4.08653,-0.810306 v 0 q -2.16671,0 -4.0666,0.806338 -1.89987,0.806332 -3.36558,2.3634 v 0 q -0.11156,0.119159 -0.26288,0.123136 -0.15137,0.0037 -0.27086,-0.115192 z m 39.74027,4.939216 h -11.11276 q -0.4676,0 -0.7656,-0.08295 -0.298,-0.08295 -0.49054,-0.287874 v 0 q -0.19256,-0.20493 -0.27047,-0.517203 -0.0779,-0.312278 -0.0779,-0.819716 v 0 -4.362059 q 0,-0.517201 0.0779,-0.834351 0.0779,-0.317151 0.27047,-0.52208 v 0 q 0.18338,-0.20493 0.48595,-0.287875 0.30259,-0.08295 0.7977,-0.08295 v 0 h 11.08525 q 0.46763,0 0.7656,0.08295 0.29799,0.08293 0.49054,0.287875 v 0 q 0.19256,0.204929 0.27049,0.517202 0.0779,0.312272 0.0779,0.819717 v 0 4.38157 q 0,0.956334 -0.34842,1.33692 v 0 q -0.19255,0.20492 -0.48596,0.287867 -0.29341,0.08296 -0.77018,0.08297 z m 4.03434,2.703106 h -14.4136 q -1.1736,0 -2.14091,-0.200053 -0.96734,-0.200051 -1.67334,-0.951457 v 0 q -0.70599,-0.74164 -0.8894,-1.771166 -0.18337,-1.029524 -0.18337,-2.278611 v 0 -2.829968 q 0,-1.219812 0.18798,-2.244459 0.18794,-1.024647 0.88479,-1.776044 v 0 q 0.706,-0.741651 1.67334,-0.946579 Q 353.07337,39 354.22866,39 v 0 h 14.43191 q 1.17362,0 2.14551,0.200051 0.97191,0.200046 1.67792,0.951458 v 0 q 0.69683,0.741641 0.88481,1.771167 0.18796,1.029524 0.18796,2.278611 v 0 2.800693 q 0,1.249087 -0.18796,2.278611 -0.18798,1.029526 -0.88481,1.771166 v 0 q -0.70601,0.751406 -1.67792,0.951459 -0.97189,0.200051 -2.14551,0.200051 z m -14.66114,-1.571123 v 0 h 14.91784 q 0.70604,0 1.38912,-0.141495 0.68309,-0.141502 1.09568,-0.580636 v 0 q 0.42176,-0.448889 0.55014,-1.16614 0.12837,-0.717246 0.12837,-1.478416 v 0 -3.337411 q 0,-0.751406 -0.12837,-1.468651 -0.12838,-0.717252 -0.55014,-1.166142 v 0 q -0.41259,-0.439133 -1.09568,-0.580636 -0.68308,-0.141494 -1.38912,-0.141494 v 0 h -14.89034 q -0.72434,0 -1.41659,0.136618 -0.69227,0.136617 -1.10487,0.585512 v 0 q -0.41259,0.439135 -0.54094,1.166142 -0.12838,0.727008 -0.12838,1.497925 v 0 3.308137 q 0,0.76117 0.12838,1.478416 0.12835,0.717251 0.54094,1.16614 v 0 q 0.42178,0.439134 1.10487,0.580636 0.68309,0.141495 1.38909,0.141495 z m 20.80431,-2.507939 v 0 -5.045152 q 0.36674,0.01951 0.76103,0.341555 0.39426,0.322028 0.66473,0.878266 0.2705,0.556232 0.2705,1.297881 v 0 q 0,0.751407 -0.2705,1.307638 -0.27047,0.556231 -0.66473,0.87339 -0.39429,0.317147 -0.76103,0.346422 z M 80.679739,39.008693 c -2.456447,0 -4.179739,1.893628 -4.179739,4.456101 v 0.01738 c 0,2.371381 1.428517,4.108652 3.552398,4.108652 1.51166,0 2.418655,-0.868637 2.811687,-1.832825 h 0.151166 c 0,0.09555 0,0.191102 0,0.277965 -0.08314,2.284517 -0.778504,4.06522 -2.358188,4.06522 -0.876764,0 -1.496542,-0.52987 -1.761083,-1.311643 l -0.02268,-0.07818 h -2.237252 l 0.01511,0.07818 c 0.340124,1.963119 1.904691,3.396373 4.013455,3.396373 2.79657,0 4.519861,-2.49299 4.519861,-6.688506 v -0.01738 c 0,-4.403995 -1.980274,-6.471345 -4.504744,-6.471345 z m 0,6.645071 c -1.141304,0 -1.972718,-0.946812 -1.972718,-2.267146 v -0.01738 c 0,-1.276896 0.884322,-2.275827 1.987832,-2.275827 1.111071,0 1.980276,1.016301 1.980276,2.327942 v 0.01738 c 0,1.294265 -0.869205,2.215024 -1.99539,2.215024 z m 7.323989,-1.693845 c 0.778504,0 1.330259,-0.651473 1.330259,-1.50274 0,-0.859951 -0.551755,-1.511429 -1.330259,-1.511429 -0.770949,0 -1.330261,0.651478 -1.330261,1.511429 0,0.851267 0.559312,1.50274 1.330261,1.50274 z m 0,6.288934 c 0.778504,0 1.330259,-0.651478 1.330259,-1.502745 0,-0.859951 -0.551755,-1.511429 -1.330259,-1.511429 -0.770949,0 -1.330261,0.651478 -1.330261,1.511429 0,0.851267 0.559312,1.502745 1.330261,1.502745 z m 8.155399,1.624347 h 2.17679 v -2.301887 h 1.42096 v -2.1021 h -1.42096 V 39.338772 H 95.1312 c -1.451193,2.571162 -2.932619,5.3508 -4.315788,8.173872 v 2.058669 h 5.343715 z m -3.287858,-4.334492 v -0.138987 c 0.982579,-2.023922 2.154114,-4.204199 3.212276,-6.071774 h 0.120932 v 6.210761 z M 103.52091,51.8732 h 2.28259 V 39.338772 h -2.27503 l -2.81925,2.249772 v 2.362689 l 2.67563,-2.136846 h 0.13606 z"
        />
        <path
          d="M154 48.5C154 38.2827 162.283 30 172.5 30H259.5C269.717 30 278 38.2827 278 48.5C278 58.7173 269.717 67 259.5 67H172.5C162.283 67 154 58.7173 154 48.5Z"
          className="fill-black"
        />
        <path
          d="M249 48.5C249 42.701 253.701 38 259.5 38C265.299 38 270 42.701 270 48.5C270 54.299 265.299 59 259.5 59C253.701 59 249 54.299 249 48.5Z"
          className="fill-neutral-950"
        />
        <path
          d="M254 48.5C254 45.4624 256.462 43 259.5 43C262.538 43 265 45.4624 265 48.5C265 51.5376 262.538 54 259.5 54C256.462 54 254 51.5376 254 48.5Z"
          className="fill-neutral-900"
        />
        <defs>
          <clipPath id="roundedCorners">
            <rect
              x="21.25"
              y="19.25"
              width="389.5"
              height="843.5"
              rx="55.75"
              ry="55.75"
            />
          </clipPath>
        </defs>
      </svg>
    </>
  );
}
