context("PreprocWrapperRemoveOutliers")

test_that("PreprocWrapperRemoveOutliers", {
  lrn1 = makeLearner("classif.rpart", minsplit=10)
  lrn2 = makePreprocWrapperRemoveOutliers(lrn1, ro.alpha=1)
  m = train(lrn2, multiclass.task)  
  p = predict(m, multiclass.task)
  perf = performance(p, mmce)
  expect_equal(m$task.desc$size, 150)
  expect_true(perf < 0.1)
  lrn2 = makePreprocWrapperRemoveOutliers(lrn1, ro.alpha=1)
  
  lrn2 = setHyperPars(lrn2, ro.alpha=0.5)
  m = train(lrn2, multiclass.task)  
  p = predict(m, multiclass.task)
  expect_true(getLeafModel(m)$task.desc$size < 150)
})

test_that("PreprocWrapperPCA works with factors", {
  f = function() as.factor(sample(1:2, 100, replace=TRUE))
  data = data.frame(x1=f(), x2=runif(100), x3=runif(100), y=f())
  task = makeClassifTask(data=data, target="y")
  lrn1 = makeLearner("classif.multinom")
  lrn2 = makePreprocWrapperRemoveOutliers(lrn1)
  m = train(lrn2, task)  
  p = predict(m, task)
  perf = performance(p, mmce)
  expect_true(!is.na(perf))
  
  f = function() as.factor(sample(1:2, 100, replace=TRUE))
  data = data.frame(x1=f(), x2=runif(100), y=f())
  task = makeClassifTask(data=data, target="y")
  lrn1 = makeLearner("classif.multinom")
  lrn2 = makePreprocWrapperRemoveOutliers(lrn1)
  m = train(lrn2, task)  
  p = predict(m, task)
  perf = performance(p, mmce)
  expect_true(!is.na(perf))
  
  f = function() as.factor(sample(1:2, 100, replace=TRUE))
  data = data.frame(x1=f(), x2=f(), y=f())
  task = makeClassifTask(data=data, target="y")
  lrn1 = makeLearner("classif.multinom")
  lrn2 = makePreprocWrapperRemoveOutliers(lrn1)
  m = train(lrn2, task)  
  p = predict(m, task)
  perf = performance(p, mmce)
  expect_true(!is.na(perf))
})
