
# Google summer of code 2022

Join the sktime team for a summer full of coding, learning and fun. Be part of our diverse community and join our efforts to advance machine learning and time series analysis capabilities, by helping create one of the first comprehensive time series ML toolboxes!

## The application process and key dates

Here is the timeline for the application process until the coding begins. Each of the steps is explained in detail below.

- **April 19, 18:00 (UTC)**: You must complete an entrance task, the sktime application form and GSoC proposal by this deadline.
- **April 26**: We will inform you of the outcome of your application *latest* by April 26, but hopefully sooner.
- **April 25** - **May 8**: Interviews will happen during this time. Preferred dates are **April 29** and **May 6**. Please keep these dates free if possible.
- **May 15**: We will take at most one week to inform you of the outcome of the interview. We submit our list of ranked candidates to GSoC committee.
- **May 20**: GSoC will inform you of final outcome of the process.
- **May 20** - **June 12**:  Community Bonding Period
- **June 12**: Deadline to notify Google Admins of an inactive GSoC Contributor that you wish to remove from the program
- **June 13**: Coding begins

### Entrance task, sktime application and GSoC proposal

The deadline to complete all of these is **April 19, 18:00 (UTC)**.

1. Entrance task. Make a pull request (PR) to sktime to show you are able to contribute meaningfully.
    - Your PR does not need to be merged at the time of application.
    - To find out how to contribute to sktime, look at our [new contributor starter issue](https://github.com/sktime/sktime/issues/1147) and [developer guide](https://www.sktime.net/en/latest/developer_guide.html).
    - Alternatively, if you are already experienced in using git and GitHub in a collaborative environment, you can skip this step. In this case, in the form in step 2 below, please provide a link to publicly visible evidence for your experience.
2. Fill in and submit the sktime application form at (https://forms.gle/MVcf9Q45Ui1ByMxM8).
    - You should have completed your entrance task (point 1 above) before submitting the form, since you need to provide a link to it in the form.
    - Note: this form is separate from your GSoC proposal below.
3. Submit a proposal on the GSoC platform (https://summerofcode.withgoogle.com).
    - You can base this on the list of proposed projects (see below), your entrance task, or your own independent idea - whichever you choose, we aim to evaluate fairly and primarily on quality.
    - We do not have any special or extra requirements for the proposal, so please follow the guidelines from GSoC: https://google.github.io/gsocguides/student/writing-a-proposal.

After the deadline on **April 19th** has passed, we will process the information provided and tell you the outcome no later than **April 26th**. There are two possible outcomes:
- Progress to interview. See below.
- Rejection. Though this will be disheartening for you, this is only a rejection for GSoC (which is particularly demanding of participants) and should not discourage you from pursuing open source contributions, either with sktime or another package. E.g. you may still be eligible for our (unpaid) 1-1 mentoring.

### Getting feedback on proposal
If you want feedback on your proposal, then you must complete the entrance task, the sktime application form and a GSoC proposal by April 12, 18:00 (UTC).

1. Entrance task. Same as above.
2. Fill in and submit the sktime application form. Same as above except:
    - Select 'Yes' for the question 'Are you requesting feedback on your application/proposal?'
3. Submit a proposal on the GSoC platform (https://summerofcode.withgoogle.com). Same as above.

After the deadline on April 12th has passed, we will try to provide feedback to you within three working days. Unfortunately, due to having limited time, we cannot *guarantee* that all people who want feedback will receive feedback, but we will do our best. If we cannot provide feedback to all people, then we will give preference to people who completed the steps earlier.

Depending on the feedback, you should then update your GSoC proposal.

### Interview

If successful in the above steps, we will invite you to a structured interview (ca. 30 to 60 minutes length; to be finalised) with core community members of sktime.
The interview will happen in the two-week period **April 26** to **May 8**, and our preferred dates are **April 29** and **May 6**. Please keep these dates free if possible.

During the interview:

- we will ask you to give a short (5 to 10 minutes; to be finalised) presentation on a piece of Python code that you wrote. Please be ready to screen share your code or to send a link to the repo containing your code.
- we will ask about your motivation to join sktime, your previous experience, your suitability for the specified project, and technical questions on data science and Python.

After the interview, we will rank the candidates and send a shortlist of our preferred candidates to GSoC, who will make the final decisions and allocations.
We will inform you of *our* perspective on the interviews (see below for possible outcomes) at most one week after the final candidate is interviewed, and GSoC will inform you of the final decision by May 20.

When we inform you of the outcome of the interview, there are two possibilities:
* Conditional acceptance. This means you are in our shortlist sent to GSoC.  This means likely - but not guaranteed - acceptance to the sktime GSoC program.
* A rejection. This means you are not in our shortlist sent to GSoC for 2022.
  - We understand this will be disheartening for you, but this is only a rejection for GSoC, which is particularly demanding of participants. We will always welcome anybody interested in joining sktime outside of GSoC.


## Join the community and get in touch

If you get stuck or have questions, please feel free to reach out to us on [GitHub discussions](https://github.com/sktime/sktime/discussions).


- join the [sktime discord server](https://discord.com/invite/54ACzaFsn7) and say Hi :wave: in the lobby
- check out the [sktime community calendar](https://calendar.google.com/calendar/u/0/embed?src=sktime.toolbox@gmail.com&ctz=UTC) to keep track of the upcoming events and meetings
- follow us [twitter](https://twitter.com/sktime_toolbox)


## What we expect from you
GSoC is a marathon, not a sprint, and we expect good performance over the whole project.

Our expectations for GSoC participants before GSoC starts:

- You are interested in time series, machine learning, statistics, API design and software architecture.
- You like coding in Python.
- You are familiar with the basic data science ecosystem in Python, including numpy, pandas and scikit-learn.
- You enjoy working with a vibrant team of experienced ML scientists and software engineers.
- You are enthusiastic about open-source.

Our expectations for GSoC participants during GSoC:

- You follow our [Code of Conduct](https://www.sktime.net/en/stable/get_involved/code_of_conduct.html).
- You work full time on your GSoC project.
- You maintain daily contact with your mentor(s).
- You engage with the sktime community and other GSoC participants.
- You peer-review a fellow student's work in the middle and at the end of GSoC.
- You write weekly blog posts and a final summary post at the end of the project.
- You consider becoming a *long-term* developer and contributor, stepping up to become a leader in open source toolbox development.

## What you can expect from us

The expectations on you are high, but you can expect just as much from us. You should expect:

- We follow the [Code of Conduct](https://www.sktime.net/en/stable/get_involved/code_of_conduct.html).
- 1-1 mentoring with an experienced contributor, with weekly meetings.
- Regular feedback and help on your efforts, including blog posts, with quick responses from us (usually respond within 2 working days).
- 'Agile' ways of working, used throughout the tech industry, e.g. daily standups.
- Cutting edge projects in highly sought-after areas of data science: time series, toolboxes, applications to healthcare and industry.
- The opportunity to acquire a variety of transferrable skills, both technical skills (like coding, design, testing, documentation) and soft skills (teamwork, giving and receiving feedback, goal setting).
- The opportunity to engage and socialise with the sktime community and other GSoC participants.
- The opportunity to become a core developer of sktime.


## Projects

For potential projects, see our [list of suggested projects](https://github.com/sktime/mentoring/blob/main/internships/projects_2022.md) and [good first issues](https://github.com/sktime/sktime/labels/good%20first%20issue).
We also appreciate applications with your own ideas!

## Mentors 2022

| Name  | GitHub | Website |
|---|---|---|
| Franz Király | [@fkiraly](https://github.com/fkiraly) | [website](https://uk.linkedin.com/in/franz-kir%C3%A1ly-10a1391ba) |
| Guzal Bulatova | [@guzalbulatova](https://github.com/guzalbulatova) | |
| Lovkush Agarwal | [@lovkush-a](https://github.com/lovkush-a) | [personal website](http://www.lovkush.com/?i=1)|
| Lukasz Mentel | [@lmmentel](https://github.com/lmmentel) | [website](https://no.linkedin.com/in/lukasz-mentel) |
| Martin Walter | [@aiwalter](https://github.com/aiwalter) | |

## Useful resources

- [sktime's mentoring](https://github.com/sktime/mentoring)
- [GSoC project page](https://summerofcode.withgoogle.com/programs/2022/organizations/sktime)
