"""Pre-calculated tags for UCR UEA datasets."""

DATASET_TAGS = {
    "BirdChicken": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 40,
        "n_instances_train": 20,
        "n_instances_test": 20,
        "n_classes": 2,
    },
    "AllGestureWiimoteY": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 1000,
        "n_instances_train": 300,
        "n_instances_test": 700,
        "n_classes": 10,
    },
    "AsphaltPavementTypeCoordinates": {
        "n_splits": 1,
        "is_univariate": False,
        "n_instances": 2111,
        "n_instances_train": 1055,
        "n_instances_test": 1056,
        "n_classes": 3,
    },
    "WordSynonyms": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 905,
        "n_instances_train": 267,
        "n_instances_test": 638,
        "n_classes": 25,
    },
    "MixedShapesSmallTrain": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 2525,
        "n_instances_train": 100,
        "n_instances_test": 2425,
        "n_classes": 5,
    },
    "FaceDetection": {
        "n_splits": 1,
        "is_univariate": False,
        "n_instances": 9414,
        "n_instances_train": 5890,
        "n_instances_test": 3524,
        "n_classes": 2,
    },
    "Plane": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 210,
        "n_instances_train": 105,
        "n_instances_test": 105,
        "n_classes": 7,
    },
    "CricketZ": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 780,
        "n_instances_train": 390,
        "n_instances_test": 390,
        "n_classes": 12,
    },
    "ProximalPhalanxOutlineCorrect": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 891,
        "n_instances_train": 600,
        "n_instances_test": 291,
        "n_classes": 2,
    },
    "ACSF1": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 200,
        "n_instances_train": 100,
        "n_instances_test": 100,
        "n_classes": 10,
    },
    "CinCECGTorso": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 1420,
        "n_instances_train": 40,
        "n_instances_test": 1380,
        "n_classes": 4,
    },
    "ItalyPowerDemand": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 1096,
        "n_instances_train": 67,
        "n_instances_test": 1029,
        "n_classes": 2,
    },
    "CricketY": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 780,
        "n_instances_train": 390,
        "n_instances_test": 390,
        "n_classes": 12,
    },
    "ElectricDevices": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 16637,
        "n_instances_train": 8926,
        "n_instances_test": 7711,
        "n_classes": 7,
    },
    "PigCVP": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 312,
        "n_instances_train": 104,
        "n_instances_test": 208,
        "n_classes": 52,
    },
    "Adiac": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 781,
        "n_instances_train": 390,
        "n_instances_test": 391,
        "n_classes": 37,
    },
    "Lightning7": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 143,
        "n_instances_train": 70,
        "n_instances_test": 73,
        "n_classes": 7,
    },
    "CBF": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 930,
        "n_instances_train": 30,
        "n_instances_test": 900,
        "n_classes": 3,
    },
    "FreezerRegularTrain": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 3000,
        "n_instances_train": 150,
        "n_instances_test": 2850,
        "n_classes": 2,
    },
    "HouseTwenty": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 159,
        "n_instances_train": 40,
        "n_instances_test": 119,
        "n_classes": 2,
    },
    "Haptics": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 463,
        "n_instances_train": 155,
        "n_instances_test": 308,
        "n_classes": 5,
    },
    "Cricket": {
        "n_splits": 1,
        "is_univariate": False,
        "n_instances": 180,
        "n_instances_train": 108,
        "n_instances_test": 72,
        "n_classes": 12,
    },
    "BasicMotions": {
        "n_splits": 1,
        "is_univariate": False,
        "n_instances": 80,
        "n_instances_train": 40,
        "n_instances_test": 40,
        "n_classes": 4,
    },
    "GestureMidAirD3": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 338,
        "n_instances_train": 208,
        "n_instances_test": 130,
        "n_classes": 26,
    },
    "OSULeaf": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 442,
        "n_instances_train": 200,
        "n_instances_test": 242,
        "n_classes": 6,
    },
    "InsectEPGRegularTrain": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 311,
        "n_instances_train": 62,
        "n_instances_test": 249,
        "n_classes": 3,
    },
    "SwedishLeaf": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 1125,
        "n_instances_train": 500,
        "n_instances_test": 625,
        "n_classes": 15,
    },
    "Yoga": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 3300,
        "n_instances_train": 300,
        "n_instances_test": 3000,
        "n_classes": 2,
    },
    "InsectWingbeatSound": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 2200,
        "n_instances_train": 220,
        "n_instances_test": 1980,
        "n_classes": 11,
    },
    "AsphaltObstacles": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 781,
        "n_instances_train": 390,
        "n_instances_test": 391,
        "n_classes": 4,
    },
    "AsphaltRegularityCoordinates": {
        "n_splits": 1,
        "is_univariate": False,
        "n_instances": 1502,
        "n_instances_train": 751,
        "n_instances_test": 751,
        "n_classes": 2,
    },
    "Epilepsy": {
        "n_splits": 1,
        "is_univariate": False,
        "n_instances": 275,
        "n_instances_train": 137,
        "n_instances_test": 138,
        "n_classes": 4,
    },
    "Phoneme": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 2110,
        "n_instances_train": 214,
        "n_instances_test": 1896,
        "n_classes": 39,
    },
    "RefrigerationDevices": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 750,
        "n_instances_train": 375,
        "n_instances_test": 375,
        "n_classes": 3,
    },
    "OliveOil": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 60,
        "n_instances_train": 30,
        "n_instances_test": 30,
        "n_classes": 4,
    },
    "Computers": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 500,
        "n_instances_train": 250,
        "n_instances_test": 250,
        "n_classes": 2,
    },
    "HandOutlines": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 1370,
        "n_instances_train": 1000,
        "n_instances_test": 370,
        "n_classes": 2,
    },
    "AllGestureWiimoteZ": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 1000,
        "n_instances_train": 300,
        "n_instances_test": 700,
        "n_classes": 10,
    },
    "Handwriting": {
        "n_splits": 1,
        "is_univariate": False,
        "n_instances": 1000,
        "n_instances_train": 150,
        "n_instances_test": 850,
        "n_classes": 26,
    },
    "GunPoint": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 200,
        "n_instances_train": 50,
        "n_instances_test": 150,
        "n_classes": 2,
    },
    "ShapesAll": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 1200,
        "n_instances_train": 600,
        "n_instances_test": 600,
        "n_classes": 60,
    },
    "DodgerLoopDay": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 158,
        "n_instances_train": 78,
        "n_instances_test": 80,
        "n_classes": 7,
    },
    "EOGHorizontalSignal": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 724,
        "n_instances_train": 362,
        "n_instances_test": 362,
        "n_classes": 12,
    },
    "SmoothSubspace": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 300,
        "n_instances_train": 150,
        "n_instances_test": 150,
        "n_classes": 3,
    },
    "UWaveGestureLibraryZ": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 4478,
        "n_instances_train": 896,
        "n_instances_test": 3582,
        "n_classes": 8,
    },
    "Wafer": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 7164,
        "n_instances_train": 1000,
        "n_instances_test": 6164,
        "n_classes": 2,
    },
    "DistalPhalanxOutlineAgeGroup": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 539,
        "n_instances_train": 400,
        "n_instances_test": 139,
        "n_classes": 3,
    },
    "NonInvasiveFetalECGThorax1": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 3765,
        "n_instances_train": 1800,
        "n_instances_test": 1965,
        "n_classes": 42,
    },
    "Fungi": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 204,
        "n_instances_train": 18,
        "n_instances_test": 186,
        "n_classes": 18,
    },
    "Herring": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 128,
        "n_instances_train": 64,
        "n_instances_test": 64,
        "n_classes": 2,
    },
    "MelbournePedestrian": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 3633,
        "n_instances_train": 1194,
        "n_instances_test": 2439,
        "n_classes": 10,
    },
    "SonyAIBORobotSurface1": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 621,
        "n_instances_train": 20,
        "n_instances_test": 601,
        "n_classes": 2,
    },
    "GesturePebbleZ1": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 304,
        "n_instances_train": 132,
        "n_instances_test": 172,
        "n_classes": 6,
    },
    "Trace": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 200,
        "n_instances_train": 100,
        "n_instances_test": 100,
        "n_classes": 4,
    },
    "ArticularyWordRecognition": {
        "n_splits": 1,
        "is_univariate": False,
        "n_instances": 575,
        "n_instances_train": 275,
        "n_instances_test": 300,
        "n_classes": 25,
    },
    "ShapeletSim": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 200,
        "n_instances_train": 20,
        "n_instances_test": 180,
        "n_classes": 2,
    },
    "ChlorineConcentration": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 4307,
        "n_instances_train": 467,
        "n_instances_test": 3840,
        "n_classes": 3,
    },
    "ECG200": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 200,
        "n_instances_train": 100,
        "n_instances_test": 100,
        "n_classes": 2,
    },
    "FacesUCR": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 2250,
        "n_instances_train": 200,
        "n_instances_test": 2050,
        "n_classes": 14,
    },
    "Wine": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 111,
        "n_instances_train": 57,
        "n_instances_test": 54,
        "n_classes": 2,
    },
    "GesturePebbleZ2": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 304,
        "n_instances_train": 146,
        "n_instances_test": 158,
        "n_classes": 6,
    },
    "TwoPatterns": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 5000,
        "n_instances_train": 1000,
        "n_instances_test": 4000,
        "n_classes": 4,
    },
    "PenDigits": {
        "n_splits": 1,
        "is_univariate": False,
        "n_instances": 10992,
        "n_instances_train": 7494,
        "n_instances_test": 3498,
        "n_classes": 10,
    },
    "StarLightCurves": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 9236,
        "n_instances_train": 1000,
        "n_instances_test": 8236,
        "n_classes": 3,
    },
    "PLAID": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 1074,
        "n_instances_train": 537,
        "n_instances_test": 537,
        "n_classes": 11,
    },
    "MixedShapesRegularTrain": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 2925,
        "n_instances_train": 500,
        "n_instances_test": 2425,
        "n_classes": 5,
    },
    "InlineSkate": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 650,
        "n_instances_train": 100,
        "n_instances_test": 550,
        "n_classes": 7,
    },
    "UMD": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 180,
        "n_instances_train": 36,
        "n_instances_test": 144,
        "n_classes": 3,
    },
    "SpokenArabicDigits": {
        "n_splits": 1,
        "is_univariate": False,
        "n_instances": 8798,
        "n_instances_train": 6599,
        "n_instances_test": 2199,
        "n_classes": 10,
    },
    "DistalPhalanxTW": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 539,
        "n_instances_train": 400,
        "n_instances_test": 139,
        "n_classes": 6,
    },
    "GunPointAgeSpan": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 451,
        "n_instances_train": 135,
        "n_instances_test": 316,
        "n_classes": 2,
    },
    "FordB": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 4446,
        "n_instances_train": 3636,
        "n_instances_test": 810,
        "n_classes": 2,
    },
    "ScreenType": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 750,
        "n_instances_train": 375,
        "n_instances_test": 375,
        "n_classes": 3,
    },
    "ECGFiveDays": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 884,
        "n_instances_train": 23,
        "n_instances_test": 861,
        "n_classes": 2,
    },
    "SemgHandGenderCh2": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 900,
        "n_instances_train": 300,
        "n_instances_test": 600,
        "n_classes": 2,
    },
    "UWaveGestureLibraryY": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 4478,
        "n_instances_train": 896,
        "n_instances_test": 3582,
        "n_classes": 8,
    },
    "DiatomSizeReduction": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 322,
        "n_instances_train": 16,
        "n_instances_test": 306,
        "n_classes": 4,
    },
    "Symbols": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 1020,
        "n_instances_train": 25,
        "n_instances_test": 995,
        "n_classes": 6,
    },
    "InsectEPGSmallTrain": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 266,
        "n_instances_train": 17,
        "n_instances_test": 249,
        "n_classes": 3,
    },
    "ShakeGestureWiimoteZ": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 100,
        "n_instances_train": 50,
        "n_instances_test": 50,
        "n_classes": 10,
    },
    "SmallKitchenAppliances": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 750,
        "n_instances_train": 375,
        "n_instances_test": 375,
        "n_classes": 3,
    },
    "FaceAll": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 2250,
        "n_instances_train": 560,
        "n_instances_test": 1690,
        "n_classes": 14,
    },
    "LSST": {
        "n_splits": 1,
        "is_univariate": False,
        "n_instances": 4925,
        "n_instances_train": 2459,
        "n_instances_test": 2466,
        "n_classes": 14,
    },
    "CricketX": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 780,
        "n_instances_train": 390,
        "n_instances_test": 390,
        "n_classes": 12,
    },
    "ProximalPhalanxTW": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 605,
        "n_instances_train": 400,
        "n_instances_test": 205,
        "n_classes": 6,
    },
    "EOGVerticalSignal": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 724,
        "n_instances_train": 362,
        "n_instances_test": 362,
        "n_classes": 12,
    },
    "Strawberry": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 983,
        "n_instances_train": 613,
        "n_instances_test": 370,
        "n_classes": 2,
    },
    "EigenWorms": {
        "n_splits": 1,
        "is_univariate": False,
        "n_instances": 259,
        "n_instances_train": 128,
        "n_instances_test": 131,
        "n_classes": 5,
    },
    "Car": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 120,
        "n_instances_train": 60,
        "n_instances_test": 60,
        "n_classes": 4,
    },
    "MiddlePhalanxTW": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 553,
        "n_instances_train": 399,
        "n_instances_test": 154,
        "n_classes": 6,
    },
    "ERing": {
        "n_splits": 1,
        "is_univariate": False,
        "n_instances": 300,
        "n_instances_train": 30,
        "n_instances_test": 270,
        "n_classes": 6,
    },
    "MedicalImages": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 1141,
        "n_instances_train": 381,
        "n_instances_test": 760,
        "n_classes": 10,
    },
    "SelfRegulationSCP1": {
        "n_splits": 1,
        "is_univariate": False,
        "n_instances": 561,
        "n_instances_train": 268,
        "n_instances_test": 293,
        "n_classes": 2,
    },
    "PEMS-SF": {
        "n_splits": 1,
        "is_univariate": False,
        "n_instances": 440,
        "n_instances_train": 267,
        "n_instances_test": 173,
        "n_classes": 7,
    },
    "Rock": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 70,
        "n_instances_train": 20,
        "n_instances_test": 50,
        "n_classes": 4,
    },
    "SyntheticControl": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 600,
        "n_instances_train": 300,
        "n_instances_test": 300,
        "n_classes": 6,
    },
    "BeetleFly": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 40,
        "n_instances_train": 20,
        "n_instances_test": 20,
        "n_classes": 2,
    },
    "PickupGestureWiimoteZ": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 100,
        "n_instances_train": 50,
        "n_instances_test": 50,
        "n_classes": 10,
    },
    "SonyAIBORobotSurface2": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 980,
        "n_instances_train": 27,
        "n_instances_test": 953,
        "n_classes": 2,
    },
    "ArrowHead": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 211,
        "n_instances_train": 36,
        "n_instances_test": 175,
        "n_classes": 3,
    },
    "MiddlePhalanxOutlineCorrect": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 891,
        "n_instances_train": 600,
        "n_instances_test": 291,
        "n_classes": 2,
    },
    "TwoLeadECG": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 1162,
        "n_instances_train": 23,
        "n_instances_test": 1139,
        "n_classes": 2,
    },
    "GunPointMaleVersusFemale": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 451,
        "n_instances_train": 135,
        "n_instances_test": 316,
        "n_classes": 2,
    },
    "ToeSegmentation1": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 268,
        "n_instances_train": 40,
        "n_instances_test": 228,
        "n_classes": 2,
    },
    "FordA": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 4921,
        "n_instances_train": 3601,
        "n_instances_test": 1320,
        "n_classes": 2,
    },
    "PowerCons": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 360,
        "n_instances_train": 180,
        "n_instances_test": 180,
        "n_classes": 2,
    },
    "ToeSegmentation2": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 166,
        "n_instances_train": 36,
        "n_instances_test": 130,
        "n_classes": 2,
    },
    "UWaveGestureLibraryAll": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 4478,
        "n_instances_train": 896,
        "n_instances_test": 3582,
        "n_classes": 8,
    },
    "DistalPhalanxOutlineCorrect": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 876,
        "n_instances_train": 600,
        "n_instances_test": 276,
        "n_classes": 2,
    },
    "Coffee": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 56,
        "n_instances_train": 28,
        "n_instances_test": 28,
        "n_classes": 2,
    },
    "HandMovementDirection": {
        "n_splits": 1,
        "is_univariate": False,
        "n_instances": 234,
        "n_instances_train": 160,
        "n_instances_test": 74,
        "n_classes": 4,
    },
    "EthanolLevel": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 1004,
        "n_instances_train": 504,
        "n_instances_test": 500,
        "n_classes": 4,
    },
    "Fish": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 350,
        "n_instances_train": 175,
        "n_instances_test": 175,
        "n_classes": 7,
    },
    "RacketSports": {
        "n_splits": 1,
        "is_univariate": False,
        "n_instances": 303,
        "n_instances_train": 151,
        "n_instances_test": 152,
        "n_classes": 4,
    },
    "DodgerLoopGame": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 158,
        "n_instances_train": 20,
        "n_instances_test": 138,
        "n_classes": 2,
    },
    "FingerMovements": {
        "n_splits": 1,
        "is_univariate": False,
        "n_instances": 416,
        "n_instances_train": 316,
        "n_instances_test": 100,
        "n_classes": 2,
    },
    "DodgerLoopWeekend": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 158,
        "n_instances_train": 20,
        "n_instances_test": 138,
        "n_classes": 2,
    },
    "PhonemeSpectra": {
        "n_splits": 1,
        "is_univariate": False,
        "n_instances": 6668,
        "n_instances_train": 3315,
        "n_instances_test": 3353,
        "n_classes": 39,
    },
    "Worms": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 258,
        "n_instances_train": 181,
        "n_instances_test": 77,
        "n_classes": 5,
    },
    "JapaneseVowels": {
        "n_splits": 1,
        "is_univariate": False,
        "n_instances": 640,
        "n_instances_train": 270,
        "n_instances_test": 370,
        "n_classes": 9,
    },
    "ECG5000": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 5000,
        "n_instances_train": 500,
        "n_instances_test": 4500,
        "n_classes": 5,
    },
    "SemgHandSubjectCh2": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 900,
        "n_instances_train": 450,
        "n_instances_test": 450,
        "n_classes": 5,
    },
    "LargeKitchenAppliances": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 750,
        "n_instances_train": 375,
        "n_instances_test": 375,
        "n_classes": 3,
    },
    "WormsTwoClass": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 258,
        "n_instances_train": 181,
        "n_instances_test": 77,
        "n_classes": 2,
    },
    "GestureMidAirD2": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 338,
        "n_instances_train": 208,
        "n_instances_test": 130,
        "n_classes": 26,
    },
    "NonInvasiveFetalECGThorax2": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 3765,
        "n_instances_train": 1800,
        "n_instances_test": 1965,
        "n_classes": 42,
    },
    "Ham": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 214,
        "n_instances_train": 109,
        "n_instances_test": 105,
        "n_classes": 2,
    },
    "DuckDuckGeese": {
        "n_splits": 1,
        "is_univariate": False,
        "n_instances": 100,
        "n_instances_train": 50,
        "n_instances_test": 50,
        "n_classes": 5,
    },
    "Libras": {
        "n_splits": 1,
        "is_univariate": False,
        "n_instances": 360,
        "n_instances_train": 180,
        "n_instances_test": 180,
        "n_classes": 15,
    },
    "ProximalPhalanxOutlineAgeGroup": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 605,
        "n_instances_train": 400,
        "n_instances_test": 205,
        "n_classes": 3,
    },
    "Lightning2": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 121,
        "n_instances_train": 60,
        "n_instances_test": 61,
        "n_classes": 2,
    },
    "UWaveGestureLibraryX": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 4478,
        "n_instances_train": 896,
        "n_instances_test": 3582,
        "n_classes": 8,
    },
    "FreezerSmallTrain": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 2878,
        "n_instances_train": 28,
        "n_instances_test": 2850,
        "n_classes": 2,
    },
    "Meat": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 120,
        "n_instances_train": 60,
        "n_instances_test": 60,
        "n_classes": 3,
    },
    "MoteStrain": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 1272,
        "n_instances_train": 20,
        "n_instances_test": 1252,
        "n_classes": 2,
    },
    "PigArtPressure": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 312,
        "n_instances_train": 104,
        "n_instances_test": 208,
        "n_classes": 52,
    },
    "Heartbeat": {
        "n_splits": 1,
        "is_univariate": False,
        "n_instances": 409,
        "n_instances_train": 204,
        "n_instances_test": 205,
        "n_classes": 2,
    },
    "InsectWingbeat": {
        "n_splits": 1,
        "is_univariate": False,
        "n_instances": 50000,
        "n_instances_train": 25000,
        "n_instances_test": 25000,
        "n_classes": 10,
    },
    "SemgHandMovementCh2": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 900,
        "n_instances_train": 450,
        "n_instances_test": 450,
        "n_classes": 6,
    },
    "Crop": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 24000,
        "n_instances_train": 7200,
        "n_instances_test": 16800,
        "n_classes": 24,
    },
    "AsphaltObstaclesCoordinates": {
        "n_splits": 1,
        "is_univariate": False,
        "n_instances": 781,
        "n_instances_train": 390,
        "n_instances_test": 391,
        "n_classes": 4,
    },
    "Mallat": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 2400,
        "n_instances_train": 55,
        "n_instances_test": 2345,
        "n_classes": 8,
    },
    "AllGestureWiimoteX": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 1000,
        "n_instances_train": 300,
        "n_instances_test": 700,
        "n_classes": 10,
    },
    "Beef": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 60,
        "n_instances_train": 30,
        "n_instances_test": 30,
        "n_classes": 5,
    },
    "CharacterTrajectories": {
        "n_splits": 1,
        "is_univariate": False,
        "n_instances": 2858,
        "n_instances_train": 1422,
        "n_instances_test": 1436,
        "n_classes": 20,
    },
    "MotorImagery": {
        "n_splits": 1,
        "is_univariate": False,
        "n_instances": 378,
        "n_instances_train": 278,
        "n_instances_test": 100,
        "n_classes": 2,
    },
    "StandWalkJump": {
        "n_splits": 1,
        "is_univariate": False,
        "n_instances": 27,
        "n_instances_train": 12,
        "n_instances_test": 15,
        "n_classes": 3,
    },
    "GestureMidAirD1": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 338,
        "n_instances_train": 208,
        "n_instances_test": 130,
        "n_classes": 26,
    },
    "UWaveGestureLibrary": {
        "n_splits": 1,
        "is_univariate": False,
        "n_instances": 440,
        "n_instances_train": 120,
        "n_instances_test": 320,
        "n_classes": 8,
    },
    "AtrialFibrillation": {
        "n_splits": 1,
        "is_univariate": False,
        "n_instances": 30,
        "n_instances_train": 15,
        "n_instances_test": 15,
        "n_classes": 3,
    },
    "Earthquakes": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 461,
        "n_instances_train": 322,
        "n_instances_test": 139,
        "n_classes": 2,
    },
    "NATOPS": {
        "n_splits": 1,
        "is_univariate": False,
        "n_instances": 360,
        "n_instances_train": 180,
        "n_instances_test": 180,
        "n_classes": 6,
    },
    "FiftyWords": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 905,
        "n_instances_train": 450,
        "n_instances_test": 455,
        "n_classes": 50,
    },
    "SelfRegulationSCP2": {
        "n_splits": 1,
        "is_univariate": False,
        "n_instances": 380,
        "n_instances_train": 200,
        "n_instances_test": 180,
        "n_classes": 2,
    },
    "BME": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 180,
        "n_instances_train": 30,
        "n_instances_test": 150,
        "n_classes": 3,
    },
    "Chinatown": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 363,
        "n_instances_train": 20,
        "n_instances_test": 343,
        "n_classes": 2,
    },
    "FaceFour": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 112,
        "n_instances_train": 24,
        "n_instances_test": 88,
        "n_classes": 4,
    },
    "PhalangesOutlinesCorrect": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 2658,
        "n_instances_train": 1800,
        "n_instances_test": 858,
        "n_classes": 2,
    },
    "MiddlePhalanxOutlineAgeGroup": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 554,
        "n_instances_train": 400,
        "n_instances_test": 154,
        "n_classes": 3,
    },
    "PigAirwayPressure": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 312,
        "n_instances_train": 104,
        "n_instances_test": 208,
        "n_classes": 52,
    },
    "EthanolConcentration": {
        "n_splits": 1,
        "is_univariate": False,
        "n_instances": 524,
        "n_instances_train": 261,
        "n_instances_test": 263,
        "n_classes": 4,
    },
    "GunPointOldVersusYoung": {
        "n_splits": 1,
        "is_univariate": True,
        "n_instances": 451,
        "n_instances_train": 136,
        "n_instances_test": 315,
        "n_classes": 2,
    },
}
