// Copyright 2014-2017 Indian Type Foundry (info@indiantypefoundry.com). Copyright 2019 Google LLC.

// This Font Software is licensed under the SIL Open Font License, Version 1.1.
// This license is copied below, and is also available with a FAQ at:
// http://scripts.sil.org/OFL


// -----------------------------------------------------------
// SIL OPEN FONT LICENSE Version 1.1 - 26 February 2007
// -----------------------------------------------------------

// PREAMBLE
// The goals of the Open Font License (OFL) are to stimulate worldwide
// development of collaborative font projects, to support the font creation
// efforts of academic and linguistic communities, and to provide a free and
// open framework in which fonts may be shared and improved in partnership
// with others.

// The OFL allows the licensed fonts to be used, studied, modified and
// redistributed freely as long as they are not sold by themselves. The
// fonts, including any derivative works, can be bundled, embedded, 
// redistributed and/or sold with any software provided that any reserved
// names are not used by derivative works. The fonts and derivatives,
// however, cannot be released under any other type of license. The
// requirement for fonts to remain under this license does not apply
// to any document created using the fonts or their derivatives.

// DEFINITIONS
// "Font Software" refers to the set of files released by the Copyright
// Holder(s) under this license and clearly marked as such. This may
// include source files, build scripts and documentation.

// "Reserved Font Name" refers to any names specified as such after the
// copyright statement(s).

// "Original Version" refers to the collection of Font Software components as
// distributed by the Copyright Holder(s).

// "Modified Version" refers to any derivative made by adding to, deleting,
// or substituting -- in part or in whole -- any of the components of the
// Original Version, by changing formats or by porting the Font Software to a
// new environment.

// "Author" refers to any designer, engineer, programmer, technical
// writer or other person who contributed to the Font Software.

// PERMISSION & CONDITIONS
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of the Font Software, to use, study, copy, merge, embed, modify,
// redistribute, and sell modified and unmodified copies of the Font
// Software, subject to the following conditions:

// 1) Neither the Font Software nor any of its individual components,
// in Original or Modified Versions, may be sold by itself.

// 2) Original or Modified Versions of the Font Software may be bundled,
// redistributed and/or sold with any software, provided that each copy
// contains the above copyright notice and this license. These can be
// included either as stand-alone text files, human-readable headers or
// in the appropriate machine-readable metadata fields within text or
// binary files as long as those fields can be easily viewed by the user.

// 3) No Modified Version of the Font Software may use the Reserved Font
// Name(s) unless explicit written permission is granted by the corresponding
// Copyright Holder. This restriction only applies to the primary font name as
// presented to the users.

// 4) The name(s) of the Copyright Holder(s) or the Author(s) of the Font
// Software shall not be used to promote, endorse or advertise any
// Modified Version, except to acknowledge the contribution(s) of the
// Copyright Holder(s) and the Author(s) or with their explicit written
// permission.

// 5) The Font Software, modified or unmodified, in part or in whole,
// must be distributed entirely under this license, and must not be
// distributed under any other license. The requirement for fonts to
// remain under this license does not apply to any document created
// using the Font Software.

// TERMINATION
// This license becomes null and void if any of the above conditions are
// not met.

// DISCLAIMER
// THE FONT SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO ANY WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
// OF COPYRIGHT, PATENT, TRADEMARK, OR OTHER RIGHT. IN NO EVENT SHALL THE
// COPYRIGHT HOLDER BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// INCLUDING ANY GENERAL, SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL
// DAMAGES, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF THE USE OR INABILITY TO USE THE FONT SOFTWARE OR FROM
// OTHER DEALINGS IN THE FONT SOFTWARE.

#ifndef _TVG_WASM_DEFAULT_FONT_H_
#define _TVG_WASM_DEFAULT_FONT_H_

#ifdef THORVG_TTF_LOADER_SUPPORT

#include <cstddef>
#include <atomic>

constexpr size_t COMPRESSED_FONT_SIZE = 9721;
constexpr size_t DEFAULT_FONT_SIZE = 14852;

constexpr const unsigned char COMPRESSED_FONT[] = {
    0xBF, 0x00, 0x01, 0x00, 0x00, 0x00, 0x11, 0x00, 0x50, 0x04, 0xFF, 0x00, 0x10, 0x47, 0x44, 0x45, 0x46, 0x02, 0xDE, 0xBF, 0x04, 0xA8, 0x00, 0x00, 0x31, 0x04, 0x01, 0x60, 0x9C, 0xFF, 0x47, 0x50, 0x4F, 0x53, 0x42, 0xFF, 0x3E, 0x7A, 0xFE, 0x01, 0x00, 0xA0, 0x00, 0x00, 0x07, 0x80, 0x47, 0x53, 0xFF, 0x55, 0x42, 0x82, 0x14, 0x74, 0x96, 0x00, 0x00, 0xFB, 0x39, 0x20, 0x03, 0x60, 0xE4, 0x4F, 0x53, 0x2F, 0x32, 0xFF, 0x60, 0x77, 0x54, 0xC8, 0x00, 0x00, 0x1F, 0x24, 0xFE, 0x04, 0x60, 0x60, 0x63, 0x6D, 0x61, 0x70, 0x01, 0x68, 0xEB, 0x00, 0xF6, 0x01, 0x00, 0x84, 0x05, 0x60, 0x4C, 0x63, 0x76, 0xFF, 0x74, 0x20, 0x15, 0x9A, 0x05, 0xF1, 0x00, 0x00, 0xFB, 0x2E, 0x9C, 0x02, 0x01, 0x66, 0x70, 0x67, 0x6D, 0x62, 0xF7, 0x2E, 0xFF, 0x7D, 0x03, 0x00, 0xD0, 0x00, 0x00, 0x0E, 0xDF, 0x0C, 0x67, 0x61, 0x73, 0x70, 0x07, 0xE0, 0x10, 0x00, 0xF7, 0x00, 0x30, 0xFC, 0x08, 0x60, 0x08, 0x67, 0x6C, 0x79, 0xFF, 0x66, 0xC0, 0x77, 0x4F, 0x4F, 0x00, 0x00, 0x01, 0xFF, 0x1C, 0x00, 0x00, 0x1C, 0x26, 0x68, 0x65, 0x61, 0xFF, 0x64, 0x26, 0x53, 0x2E, 0x53, 0x00, 0x00, 0x1D, 0xED, 0xDC, 0x0A, 0x60, 0x36, 0x68, 0x01, 0x10, 0x07, 0xEC, 0x06, 0xF9, 0x02, 0x07, 0x00, 0x0B, 0x50, 0x00, 0x24, 0x68, 0x6D, 0x74, 0xFF, 0x78, 0x7E, 0xB0, 0x0B, 0x5B, 0x00, 0x00, 0x1E, 0xFD, 0x14, 0x0C, 0x60, 0xEC, 0x6C, 0x6F, 0x63, 0x61, 0xCD, 0xD7, 0xC9, 0xD3, 0xB3, 0x03, 0x00, 0x64, 0x0D, 0x60, 0x78, 0x6D, 0x7F, 0x61, 0x78, 0x70, 0x01, 0x8A, 0x0F, 0x11, 0x04, 0x00, 0xFD, 0x44, 0x0E, 0x60, 0x20, 0x6E, 0x61, 0x6D, 0x65, 0x26, 0xE7, 0xF7, 0x3E, 0x74, 0x09, 0x00, 0x07, 0x00, 0x01, 0xDE, 0x70, 0x7F, 0x6F, 0x73, 0x74, 0xFF, 0x9F, 0x00, 0x32, 0x08, 0x00, 0xFE, 0x06, 0x01, 0x20, 0x70, 0x72, 0x65, 0x70, 0xCC, 0xA4, 0xDF, 0x56, 0x21, 0x00, 0x00, 0x2D, 0x07, 0x01, 0xBD, 0x00, 0xFF, 0x02, 0x00, 0x1E, 0x00, 0x00, 0x02, 0x7A, 0x02, 0xFF, 0xBC, 0x00, 0x07, 0x00, 0x0A, 0x00, 0x26, 0x40, 0x7D, 0x23, 0x12, 0x60, 0x02, 0x01, 0x04, 0x02, 0x68, 0x13, 0x40, 0xFF, 0x1C, 0x4D, 0x05, 0x03, 0x02, 0x01, 0x01, 0x1D, 0xBF, 0x01, 0x4E, 0x00, 0x00, 0x0A, 0x09, 0x02, 0x10, 0x07, 0xFF, 0x11, 0x11, 0x11, 0x06, 0x08, 0x19, 0x2B, 0x33, 0xFF, 0x01, 0x33, 0x01, 0x23, 0x27, 0x21, 0x07, 0x13, 0xFF, 0x03, 0x33, 0x1E, 0x01, 0x02, 0x59, 0x01, 0x01, 0xFF, 0x59, 0x40, 0xFE, 0xD6, 0x41, 0xD6, 0x7D, 0xF9, 0xFF, 0x02, 0xBC, 0xFD, 0x44, 0xB4, 0xB4, 0x02, 0x53, 0x7F, 0xFE, 0xA5, 0x00, 0x00, 0x03, 0x00, 0x4B, 0x05, 0xA0, 0xFD, 0x2C, 0x05, 0xA0, 0x11, 0x00, 0x1A, 0x00, 0x23, 0x00, 0xFF, 0x39, 0x40, 0x36, 0x09, 0x01, 0x05, 0x02, 0x01, 0xFD, 0x4C, 0x07, 0x40, 0x05, 0x04, 0x02, 0x05, 0x67, 0x00, 0xEF, 0x03, 0x03, 0x00, 0x5F, 0x06, 0x72, 0x00, 0x04, 0x04, 0xEF, 0x01, 0x5F, 0x06, 0x01, 0x06, 0xB4, 0x23, 0x21, 0x1D, 0xDF, 0x1B, 0x1A, 0x18, 0x14, 0x12, 0x03, 0x80, 0x10, 0x21, 0xFF, 0x07, 0x08, 0x17, 0x2B, 0x33, 0x11, 0x33, 0x32, 0xFF, 0x16, 0x16, 0x15, 0x14, 0x06, 0x07, 0x1E, 0x02, 0xFE, 0x00, 0x60, 0x06, 0x23, 0x03, 0x33, 0x32, 0x36, 0x35, 0xCF, 0x34, 0x26, 0x23, 0x23, 0x01, 0x90, 0x00, 0x93, 0x4B, 0xF6, 0xFF, 0x49, 0x62, 0x30, 0x49, 0x33, 0x27, 0x3F, 0x26, 0xFF, 0x35, 0x65, 0x49, 0xAA, 0x9C, 0x43, 0x48, 0x47, 0xFF, 0x47, 0x99, 0xA1, 0x47, 0x4F, 0x52, 0x46, 0x9F, 0xFF, 0x02, 0xBC, 0x2F, 0x51, 0x32, 0x44, 0x4F, 0x0E, 0xFF, 0x07, 0x30, 0x48, 0x2B, 0x35, 0x57, 0x33, 0x01, 0xFF, 0x8A, 0x40, 0x37, 0x35, 0x40, 0xFD, 0xD0, 0x43, 0xF7, 0x3C, 0x3B, 0x47, 0x18, 0x50, 0x00, 0x30, 0xFF, 0xF4, 0xFF, 0x02, 0x9E, 0x02, 0xC8, 0x00, 0x1D, 0x00, 0x3B, 0xDF, 0x40, 0x38, 0x00, 0x02, 0x03, 0x0F, 0x20, 0x05, 0x80, 0xDE, 0x0A, 0x00, 0x03, 0x05, 0x04, 0x7E, 0x0A, 0x10, 0x01, 0x61, 0xEF, 0x00, 0x01, 0x01, 0x22, 0x0A, 0x11, 0x00, 0x61, 0x06, 0xBE, 0x24, 0x80, 0x23, 0x00, 0x4E, 0x01, 0x00, 0x09, 0xE0, 0x16, 0xFF, 0x10, 0x0E, 0x0C, 0x0B, 0x09, 0x07, 0x00, 0x1D, 0xFF, 0x01, 0x1D, 0x07, 0x08, 0x16, 0x2B, 0x05, 0x22, 0xBF, 0x26, 0x26, 0x35, 0x34, 0x36, 0x36, 0x0A, 0x80, 0x17, 0xFF, 0x23, 0x26, 0x26, 0x23, 0x22, 0x06, 0x06, 0x15, 0xF7, 0x14, 0x16, 0x16, 0x0A, 0x70, 0x37, 0x33, 0x06, 0x06, 0xFF, 0x01, 0x7B, 0x66, 0x95, 0x50, 0x50, 0x95, 0x66, 0xFF, 0x78, 0x96, 0x15, 0x5D, 0x10, 0x62, 0x54, 0x4B, 0xFF, 0x6E, 0x3C, 0x3C, 0x6E, 0x4B, 0x54, 0x62, 0x10, 0xFF, 0x5D, 0x15, 0x96, 0x0C, 0x5B, 0xA3, 0x6C, 0x6C, 0xFF, 0xA3, 0x5B, 0x72, 0x68, 0x41, 0x4F, 0x45, 0x81, 0xFF, 0x5A, 0x5A, 0x81, 0x45, 0x4D, 0x40, 0x65, 0x72, 0xF4, 0x19, 0x10, 0x13, 0xC2, 0x81, 0x19, 0x60, 0x08, 0x00, 0x13, 0x00, 0xF7, 0x27, 0x40, 0x24, 0x12, 0xC8, 0x02, 0x02, 0x01, 0x5F, 0xBD, 0x04, 0x12, 0xC5, 0x13, 0x11, 0x0B, 0x09, 0x02, 0x40, 0x07, 0x33, 0x21, 0x05, 0x12, 0x85, 0x12, 0x70, 0x23, 0x27, 0x12, 0x00, 0x12, 0x11, 0xFE, 0x11, 0x91, 0xCE, 0xB8, 0xB0, 0xB0, 0xB8, 0x7A, 0x78, 0xEF, 0x66, 0x78, 0x35, 0x35, 0x00, 0x50, 0x02, 0xBC, 0xBC, 0xFF, 0xA4, 0xA1, 0xBB, 0x46, 0x43, 0x7D, 0x56, 0x58, 0xB5, 0x7E, 0x23, 0x10, 0x01, 0x1A, 0x41, 0x01, 0xFC, 0x1F, 0xE0, 0x0B, 0xEF, 0x00, 0x2F, 0x40, 0x2C, 0x20, 0xE0, 0x03, 0x04, 0x02, 0xD3, 0x03, 0x67, 0x0F, 0x40, 0x19, 0xA7, 0x05, 0x19, 0xA0, 0x05, 0x05, 0xD3, 0x1D, 0x05, 0x20, 0x50, 0x02, 0x60, 0x0B, 0x20, 0x30, 0x11, 0x11, 0xB7, 0x07, 0x08, 0x1B, 0x19, 0x60, 0x21, 0x15, 0x00, 0x25, 0x4B, 0xFF, 0x01, 0xB1, 0xFE, 0xA3, 0x01, 0x3F, 0xFE, 0xC1, 0xFF, 0x01, 0x5D, 0x02, 0xBC, 0x45, 0xF4, 0x44, 0xFA, 0xF5, 0x45, 0x05, 0xC5, 0xF5, 0x25, 0xA0, 0x09, 0x00, 0x29, 0x40, 0xFD, 0x26, 0x05, 0xCF, 0x05, 0x01, 0x04, 0x04, 0x1D, 0x04, 0xEE, 0x05, 0x71, 0x09, 0x00, 0x09, 0x05, 0x71, 0x06, 0x08, 0x1A, 0xFE, 0x05, 0x67, 0x11, 0x4B, 0x01, 0xAA, 0xFE, 0xAA, 0x01, 0xF7, 0x23, 0xFE, 0xDD, 0x05, 0x20, 0xF6, 0x44, 0xFE, 0xC3, 0xFA, 0x1A, 0xE5, 0xBB, 0x1A, 0xE0, 0x22, 0x00, 0x7E, 0xB5, 0x20, 0xFF, 0x01, 0x04, 0x05, 0x01, 0x4C, 0x4B, 0xB0, 0x15, 0xEF, 0x50, 0x58, 0x40, 0x27, 0x1B, 0xA0, 0x06, 0x03, 0x02, 0x2F, 0x06, 0x80, 0x00, 0x06, 0x25, 0xC0, 0x06, 0x25, 0xC2, 0x1B, 0xB9, 0x73, 0x07, 0x08, 0x35, 0x20, 0x1B, 0xC0, 0x1B, 0x40, 0x2B, 0x02, 0xAF, 0xAE, 0x1E, 0x56, 0x07, 0x07, 0x1D, 0x1E, 0xA3, 0x08, 0x1E, 0xA3, 0x59, 0xFF, 0x40, 0x17, 0x01, 0x00, 0x1F, 0x1E, 0x1D, 0x1C, 0x9E, 0x1F, 0x18, 0x22, 0x01, 0x22, 0x09, 0x1F, 0x1F, 0x1F, 0x19, 0x23, 0xDF, 0x35, 0x21, 0x11, 0x23, 0x27, 0x1F, 0x60, 0x78, 0x63, 0xFF, 0x94, 0x51, 0x53, 0x99, 0x68, 0x75, 0x9E, 0x17, 0xFF, 0x61, 0x0F, 0x68, 0x52, 0x4E, 0x72, 0x3E, 0x3E, 0xFF, 0x6E, 0x49, 0x6F, 0x72, 0x09, 0xCA, 0x01, 0x20, 0xFF, 0x4D, 0x07, 0x26, 0x6F, 0x0C, 0x5B, 0xA2, 0x6C, 0xFF, 0x6B, 0xA4, 0x5C, 0x71, 0x65, 0x3F, 0x4A, 0x45, 0xFF, 0x80, 0x59, 0x59, 0x81, 0x44, 0x84, 0x71, 0x42, 0xDF, 0xFE, 0x8A, 0x73, 0x3D, 0x42, 0x19, 0x64, 0x02, 0x5E, 0xFC, 0x19, 0x62, 0x1F, 0xC1, 0x01, 0x00, 0x04, 0x03, 0x01, 0x04, 0xFB, 0x67, 0x02, 0x4C, 0x80, 0x1C, 0x4D, 0x06, 0x05, 0x02, 0x8F, 0x03, 0x03, 0x1D, 0x03, 0x18, 0xEF, 0x19, 0x00, 0x00, 0x40, 0x23, 0xFE, 0x00, 0x60, 0x4B, 0x54, 0x01, 0x6B, 0x54, 0x54, 0xFE, 0xFF, 0x95, 0x02, 0xBC, 0xFE, 0xCB, 0x01, 0x35, 0xFD, 0x5F, 0x44, 0x01, 0x42, 0xFE, 0xBE, 0x1E, 0xC4, 0x00, 0x31, 0x00, 0x0E, 0x39, 0xA0, 0x19, 0x40, 0x16, 0x3E, 0x02, 0x3D, 0xE0, 0x3D, 0xF3, 0x3A, 0xE0, 0x87, 0x03, 0x11, 0x03, 0x36, 0xC3, 0x04, 0x00, 0x3C, 0x81, 0x31, 0xE1, 0x1C, 0xEF, 0xFF, 0xF4, 0x01, 0xAA, 0x41, 0xC0, 0x0F, 0x00, 0x2B, 0xFF, 0x40, 0x28, 0x00, 0x01, 0x03, 0x02, 0x03, 0x01, 0x73, 0x02, 0x80, 0x3B, 0x80, 0x28, 0x72, 0x00, 0x61, 0x04, 0x31, 0x25, 0xFF, 0x0C, 0x0B, 0x08, 0x06, 0x04, 0x03, 0x00, 0x0F, 0xF7, 0x01, 0x0F, 0x05, 0x30, 0xE0, 0x17, 0x22, 0x26, 0x35, 0xEB, 0x33, 0x14, 0x2F, 0xE1, 0x35, 0x09, 0x60, 0x14, 0x06, 0xE7, 0xFF, 0x5E, 0x6D, 0x55, 0x35, 0x40, 0x3F, 0x31, 0x54, 0xFF, 0x67, 0x0C, 0x6A, 0x5E, 0x35, 0x48, 0x46, 0x34, 0x9F, 0x02, 0x03, 0xFD, 0xFD, 0x5E, 0x26, 0x60, 0x42, 0x22, 0x31, 0xDC, 0x27, 0xE2, 0x47, 0xA0, 0x0A, 0x09, 0x06, 0x27, 0xE0, 0x00, 0x01, 0xF9, 0x4C, 0x27, 0xE0, 0x47, 0xC0, 0x04, 0x03, 0x02, 0x02, 0x02, 0x7B, 0x1D, 0x02, 0x27, 0x74, 0x12, 0x12, 0x11, 0x05, 0x47, 0xA1, 0xBC, 0x0E, 0x70, 0x47, 0xD0, 0x01, 0x23, 0x03, 0x07, 0x0E, 0x71, 0x24, 0xFF, 0x6A, 0xFE, 0xFC, 0x01, 0x08, 0x66, 0xDE, 0x4E, 0xFE, 0x0E, 0xB0, 0xC3, 0x01, 0x3D, 0xFE, 0xE9, 0xFE, 0x5B, 0x5F, 0x01, 0x64, 0x53, 0xFE, 0xEF, 0x2D, 0xA5, 0xE5, 0x4D, 0x80, 0xCF, 0x05, 0x00, 0x1F, 0x40, 0x56, 0xC0, 0x46, 0x71, 0x01, 0x01, 0xF3, 0x02, 0x60, 0x0C, 0x20, 0x05, 0x64, 0x05, 0x00, 0x05, 0x11, 0xAF, 0x11, 0x04, 0x08, 0x18, 0x13, 0xC3, 0x15, 0x13, 0x60, 0x46, 0xD6, 0x4C, 0x00, 0x87, 0x43, 0x18, 0x04, 0xFF, 0x51, 0x40, 0x0C, 0x00, 0x3F, 0x2E, 0x40, 0x2B, 0x0B, 0x08, 0x03, 0x4A, 0xA0, 0x4B, 0x80, 0x8D, 0x03, 0x32, 0x01, 0x02, 0x80, 0x09, 0xF3, 0x4C, 0x30, 0x09, 0xF5, 0x0C, 0xDF, 0x00, 0x0C, 0x12, 0x11, 0x12, 0x2B, 0xF4, 0x33, 0x13, 0xFD, 0x13, 0x18, 0x61, 0x03, 0x23, 0x03, 0x11, 0x4B, 0x62, 0x7F, 0xF8, 0xF7, 0x63, 0x54, 0xE7, 0x3F, 0xE6, 0x18, 0x90, 0xFF, 0x17, 0x01, 0xE9, 0xFD, 0x44, 0x02, 0x26, 0xFE, 0x5F, 0x3C, 0x01, 0xC2, 0xFD, 0xDC, 0x1E, 0x24, 0x68, 0x31, 0xC2, 0x0F, 0x24, 0x40, 0x21, 0x08, 0x0E, 0xB0, 0x0F, 0x8F, 0x31, 0x83, 0x0F, 0x86, 0x55, 0x01, 0x1D, 0xE1, 0x01, 0x1D, 0xD1, 0x75, 0x1D, 0xD0, 0x8B, 0x56, 0xB0, 0x77, 0xCF, 0x02, 0x31, 0x05, 0x40, 0x31, 0xFD, 0xCF, 0x5C, 0x60, 0xEA, 0x4C, 0x81, 0xD7, 0x4C, 0x80, 0x0F, 0x63, 0x90, 0x2D, 0x40, 0x2A, 0xF2, 0x4B, 0xB7, 0x05, 0x0F, 0x00, 0x1A, 0xA6, 0x11, 0x10, 0x01, 0x00, 0x3F, 0x19, 0x17, 0x10, 0x1F, 0x11, 0x1F, 0x4B, 0xC0, 0x1A, 0xE0, 0x99, 0x06, 0x4B, 0xCB, 0x56, 0x41, 0x06, 0x27, 0x43, 0xC5, 0x4C, 0x54, 0x01, 0xFF, 0x83, 0x65, 0x99, 0x55, 0x55, 0x99, 0x65, 0x67, 0xFF, 0x99, 0x54, 0x54, 0x99, 0x67, 0x4C, 0x72, 0x40, 0xFF, 0x40, 0x72, 0x4C, 0x4B, 0x73, 0x3F, 0x3F, 0x73, 0x7E, 0x4B, 0xC1, 0x6B, 0xA3, 0x5C, 0x5C, 0xA3, 0x6B, 0x4C, 0x20, 0x4D, 0x4A, 0x4B, 0xF2, 0x44, 0x44, 0x4C, 0x52, 0x4C, 0x04, 0x20, 0x14, 0x22, 0x11, 0x15, 0x23, 0xC2, 0x14, 0x10, 0x23, 0xD0, 0x67, 0x54, 0x91, 0x3F, 0xE5, 0x1D, 0xE4, 0xEF, 0x15, 0x13, 0x0F, 0x0D, 0x14, 0x31, 0x26, 0x21, 0x06, 0xF0, 0x18, 0xC3, 0x08, 0x84, 0x5D, 0xE0, 0x5D, 0xF7, 0xE5, 0x52, 0x6A, 0x34, 0xFF, 0x33, 0x6A, 0x53, 0x91, 0x8F, 0x54, 0x48, 0x48, 0xFF, 0x54, 0x8F, 0x02, 0xBC, 0x36, 0x5D, 0x3B, 0x39, 0xFF, 0x5E, 0x36, 0xFE, 0xDF, 0x01, 0x68, 0x48, 0x3E, 0xCB, 0x41, 0x47, 0x10, 0x02, 0xA1, 0x10, 0x02, 0x52, 0xE0, 0x00, 0x4A, 0xFF, 0x40, 0x47, 0x19, 0x16, 0x02, 0x03, 0x04, 0x12, 0xBD, 0x0F, 0x1B, 0x01, 0x4C, 0x00, 0x04, 0x05, 0x5C, 0xE0, 0x03, 0x7D, 0x80, 0x6E, 0xC0, 0x02, 0x86, 0x00, 0x05, 0x05, 0x5D, 0x44, 0xEB, 0x07, 0x01, 0x68, 0x00, 0x62, 0x5D, 0x54, 0x15, 0x14, 0x01, 0xFF, 0x00, 0x21, 0x1F, 0x18, 0x17, 0x14, 0x27, 0x15, 0xF7, 0x27, 0x11, 0x10, 0x5D, 0x90, 0x13, 0x01, 0x13, 0x08, 0xF6, 0x11, 0xDF, 0x07, 0x17, 0x3D, 0xA0, 0x27, 0x32, 0x37, 0x27, 0xF3, 0x33, 0x17, 0x12, 0x5F, 0x12, 0x54, 0x4D, 0x44, 0x58, 0x61, 0xFF, 0x41, 0x38, 0x41, 0x2A, 0x25, 0x80, 0x61, 0x68, 0xFB, 0x30, 0x36, 0x12, 0xDF, 0x66, 0x9E, 0x2E, 0x8B, 0x66, 0xFF, 0x13, 0x4A, 0x0B, 0xC8, 0xA3, 0x24, 0x7A, 0x52, 0xFC, 0x13, 0x37, 0x13, 0x48, 0x0F, 0x00, 0x18, 0x00, 0x33, 0x40, 0x9F, 0x30, 0x09, 0x01, 0x02, 0x04, 0x72, 0xE0, 0x79, 0x03, 0x67, 0xF0, 0x0B, 0x90, 0x72, 0xE4, 0x4E, 0x90, 0x79, 0x54, 0x18, 0x16, 0x12, 0x10, 0x8E, 0x39, 0xC0, 0x0F, 0x21, 0x17, 0x72, 0x80, 0x31, 0xD2, 0x72, 0x84, 0x13, 0xFB, 0x23, 0x03, 0x13, 0xFA, 0xE2, 0x51, 0x69, 0x32, 0x47, 0xFF, 0x4B, 0x99, 0x63, 0x8E, 0x06, 0x8A, 0x88, 0x50, 0xFF, 0x4B, 0x49, 0x53, 0x87, 0x02, 0xBC, 0x37, 0x5C, 0xFF, 0x3A, 0x42, 0x6A, 0x16, 0xFE, 0xD3, 0x01, 0x21, 0xBE, 0x14, 0x60, 0x63, 0x4E, 0x3D, 0x3E, 0x49, 0x92, 0x80, 0x2D, 0xCA, 0x70, 0xE0, 0x16, 0x70, 0xE0, 0x2F, 0x70, 0xE2, 0x56, 0x00, 0x05, 0x04, 0xD3, 0x01, 0x80, 0x1B, 0xA0, 0x24, 0x50, 0x7E, 0x13, 0xA0, 0x03, 0x61, 0xF0, 0x7B, 0x40, 0x70, 0xE0, 0x3F, 0xC1, 0x70, 0xE6, 0x22, 0x20, 0x1D, 0x1C, 0xFF, 0x19, 0x17, 0x0A, 0x08, 0x05, 0x04, 0x00, 0x2F, 0xE3, 0x01, 0x2F, 0x70, 0xE6, 0x40, 0x10, 0x40, 0x22, 0x34, 0x2E, 0x02, 0x55, 0x27, 0x26, 0x18, 0x23, 0x69, 0x61, 0x26, 0x71, 0xE2, 0x17, 0x7C, 0xE3, 0xFF, 0x01, 0x2A, 0x4D, 0x72, 0x3E, 0x58, 0x26, 0x49, 0xFF, 0x36, 0x47, 0x4E, 0x23, 0x3D, 0x4E, 0x2B, 0x53, 0xFF, 0x4E, 0x35, 0x63, 0x44, 0x43, 0x63, 0x38, 0x58, 0xFF, 0x1E, 0x3D, 0x2E, 0x39, 0x49, 0x34, 0x5B, 0x3C, 0xFF, 0x33, 0x4F, 0x2D, 0x35, 0x68, 0x0C, 0x38, 0x64, 0xFF, 0x42, 0x29, 0x45, 0x29, 0x44, 0x33, 0x29, 0x33, 0xFF, 0x20, 0x19, 0x0F, 0x1B, 0x54, 0x43, 0x39, 0x56, 0xFF, 0x31, 0x32, 0x57, 0x39, 0x1D, 0x38, 0x25, 0x01, 0xFF, 0x3C, 0x35, 0x2D, 0x30, 0x1F, 0x14, 0x11, 0x31, 0x9F, 0x4C, 0x3B, 0x32, 0x59, 0x38, 0x9E, 0xC0, 0x8D, 0x01, 0x14, 0x6E, 0x8D, 0x02, 0x21, 0x40, 0x1E, 0x53, 0x41, 0x01, 0x5F, 0x7C, 0x40, 0xC0, 0x45, 0x00, 0x1F, 0x00, 0x53, 0x83, 0x8C, 0x93, 0x44, 0xF3, 0x5A, 0xE0, 0x15, 0x23, 0xFF, 0x11, 0xEF, 0xD1, 0x01, 0xF6, 0xD1, 0x02, 0x77, 0xAF, 0x45, 0x45, 0xFD, 0x89, 0xA2, 0xE0, 0x44, 0x81, 0x40, 0x4C, 0xCA, 0x91, 0x20, 0x13, 0x39, 0xC1, 0x03, 0x89, 0x70, 0x4E, 0xFD, 0x0F, 0x0E, 0x0F, 0x0B, 0x09, 0x06, 0x05, 0x22, 0x41, 0x4E, 0xF1, 0x7F, 0xD2, 0x4E, 0x91, 0xFE, 0x4F, 0x27, 0x06, 0x01, 0x47, 0x48, 0x76, 0x45, 0x54, 0xFF, 0x62, 0x4F, 0x4F, 0x60, 0x54, 0x46, 0x77, 0x0C, 0xFF, 0x3A, 0x77, 0x5D, 0x01, 0xBA, 0xFE, 0x45, 0x66, 0xFF, 0x5C, 0x5C, 0x66, 0x01, 0xBB, 0xFE, 0x46, 0x5D, 0xB3, 0x77, 0x3A, 0xA9, 0x40, 0x58, 0x20, 0x02, 0x86, 0x97, 0x80, 0x06, 0xF0, 0x0A, 0x81, 0x55, 0x80, 0x4F, 0x96, 0x4A, 0x27, 0x06, 0x00, 0x06, 0x12, 0xE6, 0x4A, 0x22, 0x21, 0x01, 0x45, 0x71, 0x98, 0xB0, 0xFE, 0xF9, 0x5B, 0xEF, 0xDD, 0xDF, 0x59, 0xFE, 0x96, 0x91, 0x9D, 0x02, 0x63, 0xC8, 0x5A, 0x50, 0x88, 0xE0, 0x96, 0xB0, 0xAF, 0x4A, 0xC2, 0x82, 0x80, 0x0B, 0x06, 0x42, 0x4A, 0xC3, 0x02, 0x05, 0x00, 0x4A, 0x53, 0x62, 0xD5, 0x4A, 0x50, 0x11, 0x54, 0x50, 0xE2, 0x76, 0x42, 0x03, 0x4A, 0x51, 0x4A, 0x80, 0x4A, 0x50, 0x03, 0xDB, 0xC0, 0xFF, 0x5A, 0x97, 0xAB, 0x5E, 0xA7, 0x99, 0x5A, 0xC4, 0xF7, 0x60, 0xA7, 0xAB, 0x9C, 0x00, 0xA8, 0x02, 0x58, 0xFD, 0x77, 0xA6, 0x02, 0x5A, 0x4A, 0xD0, 0x43, 0xFD, 0xBD, 0x92, 0x21, 0x35, 0x26, 0xA2, 0x00, 0x34, 0x5A, 0x46, 0x07, 0x04, 0xA1, 0xD0, 0x5A, 0x4F, 0xC2, 0x5A, 0x44, 0x12, 0x5A, 0x42, 0xA1, 0x70, 0x05, 0xD1, 0x28, 0x50, 0x03, 0x26, 0xFF, 0xD6, 0xD6, 0x5F, 0xAC, 0xA4, 0x5E, 0xD6, 0xD7, 0xFF, 0x5F, 0xAD, 0xA3, 0x01, 0x61, 0x01, 0x5B, 0xFE, 0xFF, 0xE9, 0x01, 0x17, 0xFE, 0xA2, 0xFE, 0xA2, 0x01, 0x67, 0x1A, 0xFE, 0xE6, 0xB9, 0x80, 0xAD, 0x40, 0x02, 0x2F, 0x8E, 0x62, 0x97, 0x23, 0x40, 0x20, 0x05, 0xB0, 0x03, 0x10, 0x6F, 0xB3, 0x50, 0x00, 0xE7, 0x08, 0x12, 0x12, 0x5A, 0x83, 0x05, 0x93, 0x11, 0xF8, 0xE4, 0xFF, 0x5F, 0xB0, 0xAE, 0x5E, 0xE3, 0x01, 0x0A, 0x01, 0xFF, 0xB2, 0xFE, 0x9E, 0x01, 0x62, 0xFE, 0x4E, 0xFE, 0x08, 0xB9, 0x10, 0x2B, 0xE0, 0xB5, 0x60, 0xF0, 0x87, 0x02, 0x8C, 0xC0, 0x9A, 0xE0, 0xA5, 0x10, 0x22, 0x64, 0x40, 0x4C, 0xBF, 0xE0, 0x20, 0x34, 0x93, 0xC0, 0x03, 0x93, 0xC0, 0x74, 0x05, 0xB8, 0x87, 0x70, 0x5B, 0x80, 0x65, 0x72, 0x35, 0x01, 0x21, 0x20, 0x90, 0x01, 0x7F, 0x21, 0x15, 0x2D, 0x01, 0x5D, 0xFE, 0xA8, 0x1A, 0xD0, 0xFF, 0xA2, 0x01, 0x62, 0x42, 0x02, 0x31, 0x49, 0x42, 0xD7, 0xFD, 0xCF, 0x49, 0xB2, 0x40, 0x33, 0x70, 0x80, 0xE4, 0x02, 0xFD, 0x04, 0xAC, 0x80, 0x26, 0x00, 0x84, 0xB5, 0x18, 0x01, 0xA3, 0x06, 0x07, 0x87, 0xA5, 0x4D, 0xA0, 0x16, 0xC0, 0x03, 0x32, 0x61, 0x00, 0xDF, 0x07, 0x06, 0x01, 0x07, 0x67, 0x9A, 0x00, 0x04, 0x61, 0xFE, 0xAD, 0x10, 0x25, 0x4D, 0x09, 0x01, 0x06, 0x06, 0x00, 0x8B, 0x61, 0x05, 0x87, 0xB6, 0x2C, 0x02, 0xBF, 0x02, 0xB5, 0x49, 0x60, 0x1D, 0xDC, 0x03, 0x04, 0x87, 0xC6, 0x1B, 0x1C, 0x1B, 0x35, 0xD0, 0x1F, 0x1B, 0xFF, 0x26, 0x1C, 0x26, 0x17, 0x16, 0x13, 0x11, 0x0E, 0xFF, 0x0D, 0x0B, 0x09, 0x08, 0x06, 0x00, 0x1A, 0x01, 0x73, 0x1A, 0x0A, 0x76, 0x33, 0xA7, 0x11, 0x33, 0x33, 0x34, 0xA6, 0xC0, 0x8F, 0x07, 0x23, 0x3E, 0x02, 0x9F, 0xA1, 0x87, 0x72, 0x5B, 0xF2, 0x35, 0xFC, 0xA8, 0x20, 0xA8, 0x10, 0xEA, 0x3E, 0x51, 0x28, 0x75, 0x63, 0xFF, 0x85, 0x7D, 0x30, 0x46, 0x08, 0x56, 0x06, 0x3E, 0xFF, 0x5C, 0x34, 0x69, 0x68, 0x4B, 0x05, 0x15, 0x51, 0xFF, 0x37, 0x30, 0x44, 0x25, 0x7E, 0x4A, 0x3D, 0x38, 0xFF, 0x0C, 0x2B, 0x47, 0x2A, 0x4C, 0x53, 0x8E, 0x30, 0xFF, 0x2F, 0x35, 0x4A, 0x27, 0x70, 0x5C, 0xFE, 0xC8, 0xFF, 0x59, 0x2A, 0x3B, 0x47, 0x33, 0x50, 0x2D, 0x03, 0xAF, 0x34, 0x26, 0x29, 0x30, 0xC1, 0x80, 0x46, 0xB1, 0xA0, 0x42, 0xFF, 0x02, 0xD0, 0x00, 0x12, 0x00, 0x20, 0x00, 0x6B, 0x29, 0xB6, 0x6A, 0x30, 0x96, 0xF7, 0x1D, 0xA8, 0x50, 0x1E, 0x0B, 0x51, 0x41, 0x12, 0x49, 0x25, 0x54, 0xB0, 0xB2, 0x01, 0x01, 0xCB, 0x71, 0x96, 0x52, 0x21, 0x02, 0x0C, 0x62, 0xB4, 0x40, 0x1D, 0x02, 0x54, 0xB4, 0x54, 0x95, 0xB0, 0x14, 0x13, 0x86, 0x00, 0xFF, 0x1A, 0x13, 0x20, 0x14, 0x20, 0x0C, 0x0A, 0x07, 0xDD, 0x06, 0x43, 0xE0, 0x12, 0x01, 0x12, 0x57, 0x34, 0x27, 0x07, 0xF2, 0xBD, 0xA0, 0x11, 0x69, 0x3F, 0x0D, 0x63, 0x01, 0x4E, 0x40, 0x5C, 0xFF, 0x19, 0x07, 0x4C, 0x54, 0x18, 0x5A, 0x42, 0x49, 0xFF, 0x6E, 0x3D, 0x3D, 0x6E, 0x53, 0x31, 0x4C, 0x2C, 0xFF, 0x2C, 0x4C, 0x31, 0x4B, 0x5D, 0x5D, 0x0C, 0x35, 0xFF, 0x2A, 0x53, 0x02, 0xD0, 0xFE, 0xD5, 0x27, 0x38, 0xFF, 0x45, 0x77, 0x4C, 0x4D, 0x77, 0x44, 0x49, 0x2F, 0xFF, 0x56, 0x3A, 0x39, 0x56, 0x30, 0x69, 0x56, 0x56, 0x15, 0x69, 0xBE, 0xC1, 0x31, 0xBE, 0xC0, 0x0B, 0x1C, 0x60, 0xBE, 0xCF, 0xBE, 0xC7, 0xE0, 0x18, 0xC0, 0xBE, 0xCF, 0xBE, 0xCF, 0xBE, 0xCF, 0xBE, 0xC5, 0x29, 0x47, 0x70, 0xFF, 0x41, 0x41, 0x70, 0x47, 0x59, 0x78, 0x11, 0x56, 0xFF, 0x0B, 0x4E, 0x34, 0x2B, 0x4A, 0x2C, 0x2C, 0x4A, 0xFF, 0x2B, 0x34, 0x4E, 0x0B, 0x56, 0x10, 0x79, 0x0C, 0xFD, 0x42, 0xDF, 0x90, 0x77, 0x42, 0x5D, 0x4E, 0x2E, 0x35, 0xFF, 0x2C, 0x55, 0x3F, 0x3F, 0x56, 0x2C, 0x35, 0x2F, 0x55, 0x4C, 0xD0, 0x00, 0x02, 0x09, 0x82, 0x2E, 0x16, 0xA6, 0x10, 0x0A, 0x30, 0x08, 0x16, 0xAF, 0x09, 0xD4, 0x16, 0xA3, 0x03, 0x16, 0xAF, 0x0B, 0xD5, 0xA1, 0xC0, 0x16, 0xAF, 0xF6, 0x16, 0xA0, 0x1A, 0x18, 0x16, 0xA1, 0x0F, 0x0E, 0x0D, 0x0C, 0x80, 0xCB, 0x60, 0x16, 0xA7, 0xCB, 0x66, 0xA3, 0xB1, 0x23, 0xE3, 0xD5, 0x91, 0x7F, 0xB5, 0x25, 0xFB, 0x4A, 0x6D, 0x16, 0x10, 0x4A, 0x3C, 0x5E, 0x1A, 0x54, 0xFF, 0x4C, 0x08, 0x18, 0x59, 0x3B, 0x4B, 0x5E, 0x5E, 0xFF, 0x4B, 0x31, 0x4B, 0x2B, 0x2B, 0x4B, 0x0C, 0x45, 0xFF, 0x78, 0x4C, 0x4C, 0x77, 0x44, 0x32, 0x2D, 0x01, 0x7F, 0x2B, 0xFD, 0x30, 0x53, 0x25, 0x3A, 0x49, 0x16, 0x41, 0xBF, 0x30, 0x56, 0x39, 0x3A, 0x56, 0x2F, 0x0D, 0x25, 0x0E, 0x7E, 0x33, 0x02, 0x21, 0x00, 0x43, 0x40, 0x40, 0x00, 0xC5, 0x50, 0xFD, 0x02, 0x78, 0x21, 0x06, 0x00, 0x02, 0x04, 0x06, 0x02, 0x83, 0x67, 0x08, 0xC5, 0x10, 0x0B, 0x17, 0xB9, 0xF0, 0xD5, 0xA3, 0x2F, 0x11, 0x1F, 0xFF, 0x1E, 0x1B, 0x21, 0x1C, 0x21, 0x18, 0x17, 0x15, 0x87, 0x13, 0x10, 0x0F, 0xD6, 0x00, 0x2E, 0xF0, 0xB6, 0xFC, 0xE0, 0x81, 0x15, 0xD3, 0x21, 0x1E, 0x2F, 0x10, 0xD5, 0xC2, 0x03, 0x2F, 0xF0, 0x21, 0x26, 0xFF, 0x26, 0x01, 0x23, 0x46, 0x6E, 0x3E, 0x3D, 0x6F, 0xFF, 0x48, 0x4A, 0x68, 0x37, 0x01, 0xFE, 0x76, 0x03, 0xFF, 0x2E, 0x47, 0x28, 0x35, 0x45, 0x10, 0x53, 0x14, 0xFF, 0x71, 0x58, 0x3C, 0x5C, 0x07, 0x01, 0x37, 0x03, 0xDF, 0x55, 0x0C, 0x42, 0x76, 0x50, 0x17, 0xC0, 0x42, 0x6C, 0xFF, 0x3F, 0x0A, 0x16, 0x0E, 0x3A, 0x4E, 0x26, 0x2E, 0xFF, 0x2A, 0x45, 0x5A, 0x01, 0xC9, 0x4B, 0x48, 0x45, 0x55, 0x4E, 0xE0, 0x40, 0x15, 0xF8, 0xE0, 0x35, 0x2E, 0xA0, 0x13, 0xD0, 0x42, 0x2F, 0x03, 0x03, 0x02, 0x61, 0x2E, 0x02, 0x05, 0x63, 0xC2, 0xD6, 0xB1, 0xBD, 0x1F, 0x82, 0xD0, 0x06, 0x06, 0x1D, 0x06, 0xD0, 0x31, 0x13, 0x76, 0xD7, 0x40, 0x13, 0x21, 0x89, 0xC0, 0x08, 0x08, 0x1C, 0x64, 0x02, 0xD5, 0x33, 0x38, 0x82, 0x15, 0x37, 0x21, 0x15, 0x00, 0x70, 0x11, 0x62, 0xFF, 0x4D, 0x4D, 0x48, 0x45, 0x39, 0x2C, 0x25, 0x21, 0xFF, 0x7F, 0x7F, 0x01, 0xB1, 0x47, 0x4E, 0x48, 0x42, 0xBF, 0x48, 0x1F, 0x25, 0x4C, 0x47, 0xFE, 0xFF, 0x30, 0x03, 0xBF, 0x00, 0x26, 0xFF, 0x18, 0x02, 0x13, 0x44, 0x80, 0x29, 0xFF, 0x00, 0x35, 0x00, 0x43, 0x01, 0x3F, 0x40, 0x0F, 0xED, 0x19, 0xB4, 0x70, 0x05, 0x41, 0x87, 0x80, 0x03, 0x05, 0x08, 0xFB, 0x00, 0x02, 0xCC, 0xE4, 0x26, 0x0A, 0x01, 0x05, 0x09, 0x7F, 0x01, 0x00, 0x08, 0x05, 0x00, 0x69, 0x06, 0xD2, 0x40, 0xB3, 0x02, 0x61, 0xAB, 0x41, 0x42, 0x50, 0x08, 0x08, 0xCA, 0x00, 0x07, 0xFD, 0x07, 0xE9, 0x42, 0x21, 0x01, 0x4E, 0x1B, 0x4B, 0xB0, 0x65, 0x18, 0xCF, 0xC0, 0x30, 0x02, 0xED, 0xE2, 0x20, 0x25, 0x4D, 0x03, 0x91, 0xEB, 0x03, 0x5F, 0xF6, 0x30, 0x1F, 0x03, 0x8F, 0x4B, 0xB0, 0x1E, 0x7A, 0xD3, 0x40, 0x33, 0xE3, 0x81, 0x00, 0x08, 0x07, 0x80, 0x04, 0x0F, 0xD4, 0x04, 0x0C, 0x07, 0x3A, 0x2A, 0xD6, 0xF0, 0x31, 0x03, 0xBF, 0x00, 0x06, 0x71, 0x06, 0x07, 0xA4, 0xFC, 0xD0, 0x03, 0x9F, 0x1B, 0x40, 0x2E, 0x06, 0xFF, 0xDE, 0x7A, 0x30, 0x01, 0x07, 0x01, 0x65, 0x03, 0xBF, 0x1F, 0x04, 0xFB, 0x4E, 0x59, 0x00, 0x10, 0x40, 0x1D, 0x2B, 0x2A, 0x01, 0xFF, 0x00, 0x40, 0x3E, 0x3A, 0x38, 0x31, 0x2F, 0x2A, 0xFF, 0x35, 0x2B, 0x35, 0x24, 0x23, 0x22, 0x21, 0x20, 0xBD, 0x1E, 0xA2, 0xE0, 0x29, 0x01, 0x29, 0x0B, 0xF7, 0x60, 0x25, 0x3F, 0x22, 0x27, 0x07, 0x1E, 0x02, 0x17, 0xA2, 0xF4, 0xC7, 0x50, 0xFF, 0x34, 0x36, 0x37, 0x26, 0x26, 0x27, 0x35, 0x37, 0x1E, 0xF8, 0xC4, 0x17, 0x33, 0x15, 0x07, 0xAD, 0x35, 0x2D, 0x63, 0xF9, 0x50, 0xBD, 0x03, 0xC9, 0x93, 0x34, 0x26, 0x27, 0x26, 0xDA, 0x51, 0x0C, 0xFF, 0x29, 0x23, 0x34, 0x0B, 0x21, 0x3E, 0x38, 0x67, 0xFF, 0x56, 0x2F, 0x62, 0x4D, 0x67, 0x80, 0x1E, 0x29, 0xFF, 0x17, 0x1E, 0x0D, 0x56, 0x3B, 0x2E, 0x59, 0x3F, 0xFF, 0x2A, 0x24, 0xB9, 0x5F, 0x1D, 0x2E, 0x58, 0x3F, 0xFF, 0x36, 0x3E, 0x3E, 0x36, 0x35, 0x41, 0x40, 0x5E, 0xFF, 0x54, 0x41, 0x3F, 0x4C, 0x34, 0x49, 0x37, 0x28, 0xFF, 0x2A, 0x1A, 0x9E, 0x0B, 0x2F, 0x08, 0x0B, 0x0A, 0xFF, 0x04, 0x08, 0x4E, 0x41, 0x2B, 0x4E, 0x31, 0x50, 0xFF, 0x50, 0x1C, 0x43, 0x1C, 0x09, 0x16, 0x0D, 0x17, 0xFF, 0x55, 0x32, 0x54, 0x31, 0x51, 0x31, 0x0C, 0x3F, 0xFF, 0x05, 0x2B, 0x38, 0x32, 0x51, 0x30, 0x45, 0x38, 0xFF, 0x36, 0x35, 0x38, 0x38, 0x35, 0x36, 0x38, 0xFE, 0xFF, 0xDD, 0x32, 0x31, 0x35, 0x2D, 0x23, 0x2E, 0x05, 0xAF, 0x03, 0x07, 0x16, 0x33, 0xF7, 0x00, 0x46, 0xFD, 0xD0, 0x02, 0x68, 0x55, 0x62, 0xBA, 0x60, 0xD4, 0xE0, 0x03, 0xC5, 0x80, 0x00, 0x00, 0x54, 0xD0, 0xFC, 0x48, 0x06, 0xC5, 0x98, 0x12, 0x00, 0x12, 0x22, 0x13, 0x23, 0xE8, 0xC5, 0x95, 0x51, 0x13, 0x5E, 0x60, 0x11, 0x5F, 0x51, 0x15, 0x11, 0x46, 0xFF, 0x54, 0x18, 0x5C, 0x36, 0x57, 0x67, 0x53, 0x7D, 0xFB, 0x41, 0x57, 0x4F, 0x50, 0xD3, 0x2D, 0x34, 0x6A, 0x6E, 0xFF, 0xFE, 0xD4, 0x01, 0x23, 0x99, 0x5C, 0x55, 0xFE, 0x75, 0xF5, 0xFC, 0xA0, 0x3E, 0xFC, 0x10, 0xB2, 0x02, 0xD5, 0xFD, 0xA0, 0x51, 0x0F, 0xC1, 0x21, 0xDA, 0xC1, 0xF1, 0x32, 0x24, 0xDB, 0xC1, 0x1F, 0xF7, 0xE0, 0xB6, 0xE4, 0x72, 0x0C, 0x0C, 0xDB, 0xE0, 0x0F, 0x0C, 0x41, 0x90, 0x07, 0x5F, 0x05, 0x00, 0x0B, 0x01, 0x0B, 0xC1, 0x21, 0x13, 0x14, 0xB2, 0xEE, 0x65, 0x21, 0x14, 0x06, 0x03, 0xE5, 0x80, 0x78, 0x18, 0x22, 0xFB, 0x22, 0x18, 0x00, 0x40, 0x42, 0x54, 0x02, 0x63, 0x21, 0xFF, 0x19, 0x19, 0x1F, 0x1F, 0x19, 0x19, 0x21, 0xFD, 0x9F, 0x9D, 0x01, 0xF8, 0xFE, 0x08, 0xFE, 0x61, 0x0D, 0x20, 0x00, 0x97, 0x9A, 0x01, 0xF8, 0xE5, 0x66, 0x1F, 0xE5, 0x6F, 0xE9, 0xE2, 0x46, 0xED, 0x54, 0x03, 0x22, 0xFF, 0xFF, 0x09, 0xA2, 0xA2, 0x02, 0x9F, 0xAF, 0x02, 0x26, 0x00, 0x24, 0x8E, 0x52, 0x3A, 0x0A, 0xB0, 0x02, 0xBF, 0xFF, 0xE5, 0xFF, 0x24, 0x00, 0xB6, 0x0B, 0x02, 0x17, 0x0F, 0x00, 0x34, 0x40, 0x31, 0x37, 0xE2, 0x0B, 0x04, 0x2C, 0x62, 0x75, 0x80, 0xDE, 0xBA, 0xE0, 0x04, 0x04, 0x21, 0x04, 0x0B, 0x53, 0x17, 0x0C, 0x8F, 0x16, 0x13, 0x12, 0x0F, 0x0B, 0x74, 0xA7, 0x71, 0x0B, 0x7A, 0x35, 0xFE, 0xE7, 0xE6, 0x23, 0x7D, 0x19, 0x21, 0x21, 0x19, 0x18, 0xFF, 0x21, 0x21, 0xB0, 0x27, 0x25, 0x21, 0x54, 0x48, 0xED, 0x45, 0x0C, 0x47, 0xFC, 0xC1, 0x39, 0xB0, 0x02, 0x48, 0xFD, 0xB7, 0xB6, 0x48, 0x42, 0x19, 0xA3, 0x01, 0xE7, 0x6F, 0x00, 0x0A, 0x0F, 0x00, 0x29, 0x40, 0x26, 0xE8, 0xB0, 0xB6, 0x61, 0x19, 0xC4, 0x40, 0x21, 0x6E, 0xE8, 0xF8, 0x0A, 0x00, 0x0A, 0xE8, 0xF8, 0x37, 0x33, 0xB6, 0xF1, 0x7E, 0x18, 0xE0, 0xCD, 0x67, 0xDF, 0xF8, 0x6B, 0xE2, 0x68, 0x00, 0xFF, 0x52, 0xD6, 0xE5, 0xFE, 0xED, 0x01, 0x04, 0xFE, 0x91, 0xFC, 0x11, 0xE5, 0x74, 0x60, 0xF7, 0x45, 0x1E, 0xF7, 0x4F, 0x11, 0xE4, 0x02, 0xB7, 0xD0, 0xFD, 0x30, 0x15, 0x04, 0x03, 0x3F, 0x86, 0xC0, 0x22, 0x8F, 0x00, 0x56, 0xB6, 0x09, 0xF7, 0x20, 0xC0, 0x40, 0x86, 0xB3, 0x16, 0xF6, 0x40, 0xD1, 0x00, 0x61, 0x9D, 0xB2, 0x1F, 0x4D, 0x08, 0x07, 0x39, 0x05, 0xE9, 0x70, 0xAD, 0x10, 0x1B, 0x40, 0x1A, 0x17, 0x62, 0x42, 0xB1, 0x71, 0x01, 0x01, 0xE0, 0x6C, 0x41, 0x01, 0xD6, 0x59, 0x40, 0x10, 0xFF, 0x50, 0xFF, 0x22, 0x00, 0x22, 0x23, 0x13, 0x23, 0x13, 0x24, 0x1F, 0x23, 0x11, 0x09, 0x08, 0x1D, 0xFE, 0x31, 0xCB, 0xE0, 0x6B, 0xF1, 0xF8, 0x25, 0x17, 0x75, 0xB2, 0x00, 0x97, 0x46, 0x4C, 0x05, 0x18, 0x50, 0xFF, 0x31, 0x3A, 0x55, 0x16, 0x1A, 0x5B, 0x34, 0x58, 0xFF, 0x69, 0x53, 0x3F, 0x38, 0x3B, 0x4E, 0x54, 0x3E, 0xFF, 0x38, 0x3A, 0x4E, 0x01, 0xF8, 0x48, 0x27, 0x2D, 0xBF, 0x31, 0x30, 0x2E, 0x33, 0x6A, 0x6D, 0xC3, 0xA0, 0x24, 0x3F, 0x4C, 0x4C, 0x5B, 0x55, 0xFE, 0xF4, 0x00, 0x85, 0x2D, 0xE4, 0x4C, 0xCB, 0x60, 0xD8, 0x60, 0x4C, 0xB5, 0x2D, 0xD3, 0x92, 0x63, 0x13, 0x5E, 0x72, 0x38, 0xFD, 0x81, 0x27, 0x90, 0xF3, 0x94, 0x1B, 0x40, 0x17, 0x22, 0xE2, 0x2F, 0xAF, 0x87, 0x59, 0x40, 0x0D, 0x56, 0x93, 0x0B, 0x50, 0xF5, 0x65, 0x0A, 0xCE, 0x46, 0xFF, 0x4C, 0x04, 0x18, 0x59, 0x39, 0x58, 0x69, 0x54, 0x77, 0x43, 0x3D, 0x3F, 0x25, 0xA0, 0x58, 0x2F, 0x35, 0x09, 0x46, 0x17, 0x54, 0xFE, 0xF3, 0x75, 0x64, 0x21, 0x9B, 0x40, 0xF1, 0x2C, 0x36, 0x10, 0xF0, 0xF1, 0x2F, 0xF1, 0x2F, 0xF1, 0x2F, 0xF1, 0x28, 0x28, 0x47, 0x70, 0x40, 0xFF, 0x41, 0x71, 0x47, 0x47, 0x6F, 0x41, 0x42, 0x70, 0xFF, 0x47, 0x2B, 0x4A, 0x2E, 0x2D, 0x49, 0x2B, 0x2C, 0xFF, 0x4A, 0x2D, 0x2C, 0x4A, 0x0C, 0x41, 0x77, 0x50, 0xF7, 0x50, 0x76, 0x42, 0x66, 0xC0, 0x50, 0x77, 0x41, 0x48, 0x3F, 0x2B, 0x55, 0x40, 0x40, 0x55, 0x2B, 0x00, 0x63, 0x95, 0x02, 0x71, 0x24, 0x95, 0x00, 0x8E, 0x70, 0x95, 0x00, 0x68, 0xB6, 0x11, 0x95, 0x0B, 0xD0, 0xDD, 0xD0, 0x11, 0xF4, 0x94, 0xC1, 0x68, 0x12, 0x23, 0x5C, 0x40, 0x03, 0x03, 0xC5, 0x21, 0x1E, 0x11, 0x21, 0x12, 0x93, 0x80, 0x6A, 0x02, 0x4B, 0x59, 0x40, 0xC7, 0x14, 0x14, 0x13, 0xF5, 0x70, 0x95, 0x02, 0x43, 0x81, 0x26, 0x23, 0xC6, 0x6A, 0x10, 0x19, 0x2B, 0x7D, 0x80, 0x1E, 0xC3, 0x52, 0x45, 0x27, 0x11, 0xFD, 0x13, 0x94, 0xDA, 0x46, 0x4C, 0x07, 0x18, 0x59, 0x45, 0x7D, 0x48, 0x94, 0x81, 0x49, 0x3E, 0x5D, 0x19, 0xAA, 0x94, 0xC6, 0xBF, 0xDC, 0x02, 0xD4, 0x52, 0x24, 0x3A, 0x7E, 0x75, 0xFE, 0x27, 0xD1, 0x01, 0x19, 0x94, 0xD8, 0x8B, 0x41, 0x24, 0x8B, 0x40, 0x0C, 0xE5, 0x01, 0x0F, 0xEA, 0xB0, 0x0C, 0xEA, 0x28, 0x95, 0xA1, 0xA3, 0xFF, 0x10, 0x0C, 0xEA, 0x48, 0x01, 0xE0, 0x8D, 0x4D, 0x02, 0x49, 0x0C, 0xE4, 0x8B, 0x43, 0x50, 0x61, 0x13, 0x26, 0x23, 0xE6, 0x0C, 0xE1, 0x05, 0x11, 0x5E, 0x82, 0x97, 0xF6, 0x37, 0x33, 0x11, 0xBD, 0x01, 0x8B, 0x1B, 0xDA, 0x19, 0x5B, 0x41, 0xA1, 0x52, 0x49, 0x7F, 0x3F, 0x5D, 0x19, 0x08, 0x4C, 0xFF, 0x00, 0x8B, 0x26, 0xDF, 0xDC, 0x01, 0x2E, 0x27, 0x37, 0xA1, 0x70, 0x4C, 0x77, 0x3D, 0x45, 0xA2, 0x60, 0xFD, 0x2C, 0x01, 0x19, 0x8B, 0x38, 0x3F, 0xE3, 0x1D, 0x59, 0xBE, 0x20, 0x0D, 0x00, 0x49, 0x2B, 0xA0, 0xF6, 0x20, 0xBE, 0x04, 0x11, 0x12, 0xEE, 0xD2, 0x2B, 0xA3, 0xE4, 0x24, 0x1B, 0x4E, 0x74, 0xF0, 0x70, 0xA3, 0x34, 0xEE, 0xE5, 0xB4, 0x59, 0x40, 0x0C, 0xFA, 0x10, 0x0D, 0x00, 0x0D, 0xC3, 0x21, 0x13, 0x41, 0xE5, 0x36, 0x91, 0x81, 0xB1, 0x35, 0x42, 0x06, 0x18, 0xFF, 0x61, 0x48, 0x1F, 0x2B, 0x49, 0x2C, 0x01, 0xF8, 0x7F, 0x60, 0x33, 0x39, 0x58, 0x1F, 0x49, 0x40, 0x42, 0x22, 0x15, 0x2B, 0xC5, 0xC0, 0xC3, 0xC5, 0xC0, 0x27, 0xF7, 0x4F, 0xF7, 0x46, 0xC2, 0x20, 0xF6, 0xF7, 0x4A, 0x1C, 0x1A, 0x92, 0x21, 0x08, 0x06, 0x04, 0x03, 0x6F, 0x00, 0x27, 0x01, 0x27, 0xF7, 0x44, 0x27, 0x33, 0xF7, 0x24, 0x0F, 0x26, 0x27, 0x2E, 0x02, 0x5C, 0x13, 0xAA, 0x14, 0xF6, 0xE0, 0xF6, 0xD0, 0xFB, 0x17, 0x14, 0x84, 0xE0, 0x5E, 0x72, 0x09, 0x56, 0x07, 0xFF, 0x42, 0x3B, 0x34, 0x34, 0x42, 0x3B, 0x2D, 0x50, 0xFF, 0x33, 0x62, 0x54, 0x51, 0x64, 0x09, 0x53, 0x05, 0xFF, 0x38, 0x2F, 0x2F, 0x31, 0x3D, 0x3A, 0x32, 0x52, 0xFF, 0x32, 0x01, 0x68, 0x0C, 0x5B, 0x4D, 0x27, 0x3A, 0xFF, 0x2E, 0x20, 0x2D, 0x21, 0x0B, 0x08, 0x1F, 0x39, 0xFF, 0x2E, 0x41, 0x53, 0x4F, 0x49, 0x25, 0x2C, 0x27, 0xFF, 0x1E, 0x1F, 0x27, 0x0A, 0x09, 0x1E, 0x3B, 0x36, 0xEB, 0x46, 0x56, 0xF6, 0x00, 0x22, 0xF5, 0x20, 0x60, 0x02, 0x72, 0xEE, 0xF1, 0xE0, 0x35, 0x40, 0x32, 0xCF, 0xE0, 0x03, 0x85, 0x05, 0xA2, 0xF2, 0x30, 0x02, 0xD5, 0x80, 0x1D, 0x72, 0xCF, 0x40, 0x60, 0x9D, 0x01, 0x1D, 0xFE, 0xF2, 0x91, 0x12, 0x10, 0x0D, 0x0C, 0x0B, 0x0A, 0x09, 0x91, 0x08, 0xBE, 0x02, 0xF2, 0xF0, 0xBE, 0x01, 0x21, 0x7A, 0x90, 0x93, 0x71, 0x37, 0xF9, 0x33, 0x92, 0xF2, 0xF3, 0x60, 0x33, 0x15, 0x01, 0x0C, 0x45, 0xFF, 0x4D, 0x58, 0x58, 0x0B, 0x49, 0x92, 0x92, 0x26, 0xFF, 0x30, 0x36, 0x43, 0x55, 0x01, 0x19, 0x47, 0x7A, 0x7F, 0x7A, 0x47, 0xFE, 0xE7, 0x2F, 0x21, 0x48, 0xE8, 0x21, 0xF5, 0x3D, 0xD7, 0xE0, 0xF8, 0x66, 0x20, 0x13, 0x00, 0x50, 0xB5, 0x83, 0x11, 0x01, 0x59, 0x71, 0x45, 0x64, 0xF9, 0xC1, 0x61, 0xA2, 0xF9, 0xC0, 0x05, 0x1A, 0xD6, 0x75, 0x17, 0x01, 0x64, 0x04, 0x04, 0x92, 0xE0, 0xFB, 0x71, 0x9C, 0x81, 0xDE, 0xD5, 0x22, 0x11, 0x01, 0x00, 0x10, 0xB0, 0x20, 0x0A, 0x08, 0xE0, 0x08, 0xD3, 0x6E, 0xB1, 0xD4, 0x80, 0xFB, 0xBA, 0xD4, 0x21, 0xFD, 0x58, 0x68, 0xFF, 0x54, 0x41, 0x3E, 0x3F, 0x55, 0x54, 0x4C, 0x05, 0xFF, 0x17, 0x5A, 0x0C, 0x69, 0x6D, 0x01, 0x2E, 0xFE, 0xFF, 0xDB, 0x4B, 0x4C, 0x5A, 0x55, 0x01, 0x0D, 0xFE, 0x29, 0x08, 0x46, 0x70, 0xF1, 0x41, 0x18, 0xF1, 0x90, 0xF7, 0x6F, 0x40, 0xFB, 0xCC, 0xF1, 0x1F, 0xFB, 0xCF, 0xEB, 0x60, 0xF0, 0xE3, 0xD7, 0xBF, 0x58, 0x98, 0x77, 0x99, 0x56, 0xBF, 0x73, 0x60, 0x59, 0x01, 0xA7, 0x73, 0xA3, 0x06, 0x04, 0x60, 0x02, 0xE2, 0x73, 0xA0, 0xFB, 0xAF, 0x52, 0x62, 0xFB, 0xAF, 0xFB, 0xAB, 0xFF, 0xAC, 0x94, 0x54, 0x6C, 0x75, 0x5F, 0x76, 0x6B, 0xDF, 0x55, 0x93, 0x56, 0x7C, 0x7B, 0x78, 0xE0, 0x73, 0x01, 0xFF, 0x8D, 0xFE, 0x74, 0x01, 0x8C, 0xFE, 0x08, 0x01, 0x67, 0xA0, 0xFE, 0x60, 0xFB, 0xA1, 0xF5, 0xE0, 0x01, 0xDC, 0x79, 0xA0, 0xB8, 0xFB, 0xAF, 0x6C, 0xFA, 0xFB, 0xA8, 0x37, 0x27, 0x33, 0x35, 0x50, 0x07, 0xFF, 0x17, 0x23, 0x27, 0x07, 0x14, 0xAB, 0xAB, 0x5C, 0xFF, 0x88, 0x8A, 0x5A, 0xAB, 0xAB, 0x5A, 0x8A, 0x88, 0xFF, 0xFC, 0xFC, 0xCE, 0xCE, 0xFC, 0xFC, 0xCF, 0xCF, 0xF4, 0xB2, 0xC1, 0x4C, 0x60, 0x18, 0x7E, 0xE0, 0x08, 0x00, 0x2A, 0x40, 0xF9, 0x27, 0xB2, 0x20, 0x72, 0x42, 0x01, 0x03, 0x01, 0x00, 0x03, 0xA1, 0x80, 0x7F, 0x71, 0x32, 0x53, 0x4B, 0x50, 0xFB, 0x84, 0x11, 0x72, 0x72, 0x17, 0xFC, 0x72, 0x10, 0xFB, 0xA1, 0x01, 0x7D, 0x7B, 0x1D, 0xC6, 0x5B, 0xFF, 0xA4, 0xAD, 0x57, 0xFE, 0xBD, 0xDC, 0x01, 0x14, 0xFF, 0x01, 0xC0, 0xFE, 0x7F, 0x01, 0x81, 0xFD, 0x2C, 0x0C, 0xFB, 0xA0, 0x80, 0x80, 0x01, 0xA0, 0x84, 0x40, 0xFB, 0xAF, 0xFB, 0xA2, 0x7F, 0xE2, 0xFC, 0xFB, 0xAF, 0xFB, 0xAB, 0x24, 0x01, 0x17, 0xFE, 0xEE, 0x01, 0xFF, 0x72, 0xFE, 0xE8, 0x01, 0x1D, 0x45, 0x01, 0x6D, 0x9F, 0x46, 0x45, 0xFE, 0x93, 0x46, 0xFB, 0xA0, 0xBD, 0xC1, 0xF6, 0x7A, 0xEC, 0x60, 0x15, 0xC8, 0xA0, 0x7A, 0x4B, 0xB0, 0x26, 0xFB, 0x30, 0xF5, 0x2B, 0xBE, 0x32, 0x09, 0xB5, 0x40, 0x1E, 0x4D, 0x0B, 0x01, 0xE3, 0x08, 0x08, 0x00, 0xC5, 0xE9, 0xB1, 0xBF, 0x05, 0x0A, 0x07, 0x02, 0xCA, 0xF9, 0x30, 0x05, 0xFB, 0x60, 0x29, 0xC1, 0x17, 0x02, 0xD1, 0x09, 0x61, 0xCF, 0x00, 0x09, 0x09, 0x22, 0x02, 0xCF, 0x02, 0xC0, 0x59, 0x40, 0xFB, 0x18, 0x17, 0x90, 0x10, 0x1D, 0x1B, 0x16, 0x21, 0x17, 0x2D, 0x21, 0xC5, 0x50, 0x15, 0x11, 0xC2, 0x93, 0x0C, 0x77, 0x42, 0xC2, 0x9B, 0x9D, 0x21, 0x9C, 0x60, 0x23, 0x11, 0x01, 0x96, 0x98, 0xC3, 0x72, 0x32, 0xFF, 0x25, 0x26, 0x20, 0x01, 0x2F, 0x54, 0xDB, 0x01, 0xB9, 0x06, 0x97, 0x34, 0xC4, 0x24, 0x1E, 0x26, 0x4C, 0x1D, 0x70, 0xB1, 0x8F, 0xFE, 0x4F, 0x02, 0x58, 0x98, 0x15, 0x94, 0x80, 0xCB, 0x81, 0xEE, 0xEA, 0xFA, 0x20, 0x26, 0xFA, 0x20, 0x00, 0xBC, 0xC0, 0x28, 0x01, 0x54, 0x7C, 0x13, 0x21, 0xE5, 0x30, 0x3B, 0x00, 0x64, 0x02, 0x9F, 0x9F, 0xA0, 0x7F, 0x27, 0xB1, 0x06, 0x64, 0x44, 0x40, 0x1C, 0x01, 0x41, 0xE3, 0x01, 0x59, 0xF8, 0x60, 0x83, 0xE1, 0xF0, 0x90, 0x51, 0x01, 0x00, 0x7A, 0x9E, 0xE3, 0x03, 0xF7, 0x00, 0xB1, 0x06, 0x00, 0x44, 0x9F, 0x29, 0xDF, 0x32, 0x14, 0x1E, 0x1E, 0x14, 0x00, 0x40, 0x02, 0x3B, 0x9B, 0x1D, 0x15, 0x00, 0xB1, 0x15, 0x1D, 0xCF, 0x60, 0x05, 0x61, 0x00, 0x77, 0x3B, 0x00, 0x57, 0xC3, 0x20, 0x54, 0x00, 0x04, 0xEB, 0x40, 0x75, 0x2A, 0x00, 0xC0, 0x8D, 0xD0, 0xF0, 0x89, 0x0E, 0x0C, 0xCD, 0x80, 0xFE, 0x01, 0xE1, 0x00, 0x00, 0x2D, 0x00, 0x7F, 0x00, 0xCB, 0xFF, 0x00, 0xFF, 0x01, 0x2D, 0x01, 0x56, 0x01, 0xCA, 0xFB, 0x01, 0xF5, 0xE0, 0x20, 0x3E, 0x02, 0x6C, 0x02, 0x8A, 0xFF, 0x02, 0xBB, 0x02, 0xE3, 0x03, 0x2B, 0x03, 0x63, 0xFF, 0x03, 0xC5, 0x04, 0x06, 0x04, 0x68, 0x04, 0x89, 0xFF, 0x04, 0xBC, 0x04, 0xE0, 0x05, 0x10, 0x05, 0x3E, 0xFF, 0x05, 0x65, 0x05, 0x92, 0x06, 0x0C, 0x06, 0x75, 0xFF, 0x06, 0xC1, 0x07, 0x2A, 0x07, 0x81, 0x07, 0xB6, 0xFF, 0x08, 0xB7, 0x08, 0xEC, 0x09, 0x20, 0x09, 0x39, 0xFF, 0x09, 0x44, 0x09, 0x84, 0x09, 0xAF, 0x09, 0xC8, 0xFF, 0x0A, 0x26, 0x0A, 0x6C, 0x0A, 0xB4, 0x0B, 0x1B, 0xFF, 0x0B, 0x83, 0x0B, 0xC0, 0x0C, 0x18, 0x0C, 0x51, 0xFF, 0x0C, 0x9A, 0x0C, 0xBD, 0x0C, 0xED, 0x0D, 0x17, 0xFF, 0x0D, 0x42, 0x0D, 0x6F, 0x0D, 0xDD, 0x0D, 0xE9, 0xEF, 0x0D, 0xE9, 0x0E, 0x13, 0x09, 0x82, 0x04, 0x01, 0x06, 0xFF, 0x8A, 0xCD, 0x24, 0x5C, 0x5F, 0x0F, 0x3C, 0xF5, 0xEF, 0x00, 0x0F, 0x03, 0xE8, 0x0A, 0xF1, 0xE0, 0x79, 0x20, 0xFD, 0x70, 0x0B, 0x71, 0xE2, 0xAA, 0xC9, 0x37, 0xFF, 0xC2, 0x3F, 0xFE, 0xFC, 0x04, 0x47, 0x03, 0xC7, 0xA6, 0xC2, 0xF3, 0x90, 0xFE, 0x0C, 0xF1, 0x02, 0x27, 0x00, 0x4B, 0x02, 0x98, 0x00, 0xF7, 0x1E, 0x02, 0x5B, 0x00, 0x80, 0xCD, 0x00, 0x30, 0x02, 0x55, 0xB0, 0x01, 0x00, 0x35, 0x01, 0x40, 0x17, 0x01, 0x80, 0xF6, 0x01, 0x00, 0xFF, 0xA9, 0x00, 0x4B, 0x00, 0xEA, 0x00, 0x4B, 0x01, 0xDF, 0xF5, 0x00, 0x1C, 0x02, 0x48, 0x02, 0xC0, 0x0F, 0x00, 0x57, 0x4B, 0x03, 0x4A, 0x03, 0x40, 0xB3, 0x00, 0x80, 0x07, 0x03, 0x00, 0xF5, 0x44, 0x00, 0x84, 0x52, 0x04, 0x80, 0x44, 0x00, 0x2D, 0x02, 0xFD, 0x31, 0x04, 0xC0, 0x90, 0x00, 0x44, 0x02, 0x9D, 0x00, 0x5F, 0x16, 0x03, 0xC8, 0x00, 0x1B, 0x05, 0x80, 0x26, 0x02, 0x40, 0xF7, 0x14, 0x02, 0x1D, 0x01, 0xC0, 0x20, 0x00, 0x33, 0x02, 0x7F, 0x73, 0x00, 0x46, 0x02, 0x3C, 0x00, 0x31, 0x00, 0x80, 0xDF, 0x31, 0x02, 0x38, 0x00, 0x31, 0x1A, 0xA0, 0x15, 0x02, 0x55, 0x2E, 0x02, 0x40, 0x3F, 0xC1, 0x20, 0xF0, 0xBA, 0xC0, 0xDF, 0xC1, 0xA0, 0x9D, 0xDF, 0xBB, 0x40, 0xF3, 0xFF, 0xE5, 0xB4, 0xC0, 0x00, 0xC1, 0x46, 0xAB, 0x03, 0x7B, 0x03, 0x40, 0x3E, 0x03, 0x80, 0x51, 0x03, 0x82, 0x46, 0xFE, 0x03, 0xC1, 0x01, 0x72, 0x00, 0x46, 0x01, 0xF6, 0x00, 0xFF, 0x2B, 0x01, 0x88, 0x00, 0x22, 0x02, 0x3D, 0x00, 0xFD, 0x3D, 0x09, 0x80, 0x18, 0x02, 0xFB, 0x00, 0x18, 0x01, 0xFD, 0xF0, 0x06, 0xC0, 0x2C, 0x00, 0x15, 0x01, 0xCA, 0x00, 0x67, 0x24, 0x02, 0x33, 0x05, 0xC0, 0x00, 0x40, 0x01, 0x0A, 0x0E, 0xC3, 0x5E, 0x21, 0x21, 0x03, 0xE0, 0xFE, 0xCA, 0x12, 0x90, 0x70, 0x10, 0xC0, 0xD1, 0xA5, 0x10, 0xC0, 0x12, 0x42, 0x00, 0x48, 0x3B, 0xFA, 0x20, 0x26, 0x01, 0x77, 0x90, 0x00, 0x05, 0xFB, 0xD0, 0x8A, 0x02, 0x58, 0xEE, 0x70, 0xFD, 0x4B, 0x00, 0x83, 0x01, 0x5E, 0x00, 0x32, 0x01, 0x2E, 0xF8, 0x02, 0xEC, 0x1E, 0xE3, 0x05, 0xD4, 0x47, 0x4F, 0x4F, 0x47, 0x00, 0xF5, 0xC0, 0x8D, 0x40, 0x7A, 0x06, 0x43, 0x03, 0xF4, 0x01, 0x36, 0x5E, 0x02, 0x45, 0x01, 0xF8, 0x02, 0xBC, 0xF3, 0x30, 0x20, 0x53, 0x01, 0xAA, 0x17, 0xA2, 0x03, 0xF4, 0x10, 0x14, 0x23, 0x04, 0x14, 0x24, 0x80, 0x38, 0xB8, 0xB4, 0xE2, 0xEF, 0xA0, 0xCB, 0x00, 0x20, 0x00, 0x5A, 0xE4, 0x70, 0x7A, 0xD4, 0xC2, 0x00, 0x03, 0x21, 0x41, 0x83, 0x60, 0x6A, 0xC2, 0xC0, 0x19, 0xFF, 0xDF, 0xC0, 0xFF, 0xBA, 0xFF, 0xBC, 0x07, 0x49, 0xB0, 0x00, 0xFF, 0x2C, 0x20, 0xB0, 0x00, 0x55, 0x58, 0x45, 0x59, 0xFF, 0x20, 0x20, 0x4B, 0xB8, 0x00, 0x0E, 0x51, 0x4B, 0xFF, 0xB0, 0x06, 0x53, 0x5A, 0x58, 0xB0, 0x34, 0x1B, 0xFF, 0xB0, 0x28, 0x59, 0x60, 0x66, 0x20, 0x8A, 0x55, 0xBF, 0x58, 0xB0, 0x02, 0x25, 0x61, 0xB9, 0x48, 0x00, 0x00, 0xDF, 0x63, 0x63, 0x23, 0x62, 0x1B, 0xBF, 0xB0, 0x00, 0x59, 0xBF, 0xB0, 0x00, 0x43, 0x23, 0x44, 0xB2, 0xFE, 0xE0, 0x43, 0xFF, 0x60, 0x42, 0x2D, 0xB0, 0x01, 0x2C, 0xB0, 0x20, 0xFF, 0x60, 0x66, 0x2D, 0xB0, 0x02, 0x2C, 0x23, 0x21, 0xFF, 0x23, 0x21, 0x2D, 0xB0, 0x03, 0x2C, 0x20, 0x64, 0xFF, 0xB3, 0x03, 0x14, 0x15, 0x00, 0x42, 0x43, 0xB0, 0xFF, 0x13, 0x43, 0x20, 0x60, 0x60, 0x42, 0xB1, 0x02, 0xFF, 0x14, 0x43, 0x42, 0xB1, 0x25, 0x03, 0x43, 0xB0, 0xFF, 0x02, 0x43, 0x54, 0x78, 0x20, 0xB0, 0x0C, 0x23, 0xFE, 0x00, 0x90, 0x43, 0x61, 0x64, 0xB0, 0x04, 0x50, 0x78, 0xF9, 0xB2, 0xDC, 0x30, 0x04, 0x70, 0xB0, 0x21, 0x65, 0x1C, 0x21, 0xFE, 0x01, 0x61, 0xB2, 0x0E, 0x15, 0x01, 0x42, 0x1C, 0x20, 0xCE, 0x02, 0xA0, 0x23, 0x42, 0xB2, 0x6E, 0x70, 0x06, 0x30, 0x23, 0xB0, 0xFF, 0x00, 0x50, 0x58, 0x65, 0x59, 0xB2, 0x16, 0x01, 0xFE, 0x02, 0xA1, 0x2D, 0xB0, 0x04, 0x2C, 0xB0, 0x03, 0x2B, 0xEF, 0xB0, 0x15, 0x43, 0x58, 0x07, 0x01, 0xB0, 0x16, 0x43, 0xFD, 0x43, 0x02, 0x14, 0x1B, 0x20, 0x64, 0x20, 0xB0, 0xC0, 0xFF, 0x50, 0xB0, 0x04, 0x26, 0x5A, 0xB2, 0x28, 0x01, 0xFF, 0x0D, 0x43, 0x45, 0x63, 0x45, 0xB0, 0x06, 0x45, 0xFF, 0x58, 0x21, 0xB0, 0x03, 0x25, 0x59, 0x52, 0x5B, 0xFD, 0x58, 0x09, 0xD0, 0x1B, 0x8A, 0x58, 0x20, 0xB0, 0x50, 0xB5, 0x50, 0x01, 0x30, 0x40, 0x02, 0xE0, 0xB0, 0x38, 0x00, 0xA1, 0x38, 0x4F, 0x59, 0x59, 0x20, 0xB1, 0x02, 0xE3, 0x09, 0x20, 0x28, 0x01, 0xD0, 0xAE, 0x00, 0xE4, 0x20, 0xB0, 0x30, 0x02, 0xA1, 0x30, 0x02, 0xA1, 0xC0, 0xF7, 0x50, 0x58, 0x20, 0x10, 0xE0, 0x8A, 0x61, 0x20, 0xB0, 0xAF, 0x0A, 0x50, 0x58, 0x60, 0x03, 0xC0, 0x20, 0x04, 0x61, 0x0A, 0x7A, 0x00, 0xA1, 0x36, 0x05, 0x01, 0x36, 0x60, 0x1B, 0x60, 0xF6, 0x80, 0xFD, 0x1B, 0x12, 0xE0, 0xB0, 0x0C, 0x43, 0x63, 0xB0, 0x00, 0x93, 0x52, 0x58, 0x30, 0x70, 0x02, 0xD1, 0x21, 0x01, 0x00, 0xFE, 0xC0, 0x1E, 0xFE, 0x07, 0x61, 0x1E, 0x4B, 0x61, 0xB8, 0x10, 0x00, 0x63, 0xFE, 0x02, 0x21, 0xB8, 0x05, 0x00, 0x62, 0x59, 0x59, 0x64, 0x7F, 0x61, 0x59, 0xB0, 0x01, 0x2B, 0x59, 0x59, 0x0E, 0x34, 0xF7, 0x59, 0x20, 0x64, 0x0D, 0x00, 0x23, 0x42, 0x59, 0x2D, 0xEF, 0xB0, 0x05, 0x2C, 0x20, 0x08, 0x20, 0x04, 0x25, 0x61, 0xFE, 0x0D, 0x40, 0x07, 0x43, 0x50, 0x58, 0xB0, 0x07, 0x23, 0x9F, 0x42, 0xB0, 0x08, 0x23, 0x42, 0x18, 0x20, 0x03, 0x30, 0x60, 0xE7, 0x2D, 0xB0, 0x06, 0x16, 0xF2, 0x10, 0xA0, 0x20, 0x64, 0xB1, 0x4F, 0x07, 0x62, 0x42, 0x20, 0x01, 0xD1, 0x0E, 0xF1, 0x1B, 0x0C, 0xD3, 0xFE, 0x0D, 0x31, 0xB0, 0x03, 0x60, 0x45, 0x63, 0xB0, 0x05, 0xFB, 0x2A, 0x21, 0x01, 0xD0, 0x43, 0x20, 0x8A, 0x20, 0x8A, 0xDE, 0x06, 0xC0, 0xB1, 0x30, 0x05, 0x25, 0x12, 0x20, 0x51, 0x58, 0xFF, 0x60, 0x50, 0x1B, 0x61, 0x52, 0x59, 0x58, 0x23, 0xFF, 0x59, 0x21, 0x59, 0x20, 0xB0, 0x40, 0x53, 0x58, 0xF2, 0x08, 0x80, 0x1B, 0x11, 0x81, 0x16, 0xE4, 0x2D, 0xB0, 0x07, 0x2C, 0x9F, 0xB0, 0x09, 0x43, 0x2B, 0xB2, 0xEF, 0xF0, 0x1E, 0x72, 0x08, 0xEE, 0x00, 0xF0, 0x23, 0x42, 0x23, 0x22, 0xF0, 0x23, 0x42, 0x61, 0x7F, 0xB0, 0x02, 0x62, 0x66, 0xB0, 0x01, 0x63, 0x08, 0x90, 0xFF, 0xB0, 0x07, 0x2A, 0x2D, 0xB0, 0x09, 0x2C, 0x20, 0x3A, 0x0A, 0xE1, 0x0E, 0x0D, 0x70, 0x04, 0x00, 0x62, 0x25, 0x20, 0x0B, 0x00, 0xB7, 0x40, 0x60, 0x59, 0x02, 0x31, 0x60, 0x44, 0x0A, 0xE2, 0x0A, 0xFF, 0x2C, 0xB2, 0x09, 0x0E, 0x00, 0x43, 0x45, 0x42, 0x5B, 0x2A, 0x21, 0x23, 0x96, 0x0B, 0x2C, 0x24, 0x9B, 0x0C, 0x04, 0x63, 0xEB, 0x01, 0x2B, 0x1F, 0x10, 0x43, 0x0F, 0xB0, 0x60, 0x20, 0x45, 0x67, 0x8A, 0x23, 0x61, 0x1D, 0x51, 0x16, 0xD2, 0x00, 0x1B, 0x19, 0x11, 0xC7, 0xB0, 0x20, 0x1B, 0x1B, 0xD0, 0x13, 0x15, 0x1D, 0xB0, 0x23, 0x61, 0x65, 0x44, 0x06, 0x33, 0x0D, 0x03, 0xFF, 0x03, 0xF2, 0xB0, 0x24, 0x13, 0xE0, 0xE8, 0x03, 0xD0, 0x0D, 0xB6, 0x03, 0x59, 0x0E, 0x30, 0x01, 0x23, 0x42, 0xB3, 0xF5, 0x0D, 0x57, 0xB0, 0x45, 0x21, 0x90, 0x1B, 0x23, 0x21, 0x59, 0xFD, 0x2A, 0x2C, 0x50, 0x0F, 0x2C, 0xB1, 0x02, 0x02, 0x45, 0xFF, 0xB0, 0x64, 0x61, 0x44, 0x2D, 0xB0, 0x10, 0x2C, 0x7E, 0x17, 0x10, 0x20, 0x20, 0xB0, 0x0F, 0x43, 0x4A, 0x28, 0xA1, 0xAC, 0x00, 0x90, 0x1A, 0x20, 0xB0, 0x10, 0x00, 0xE1, 0x52, 0x25, 0x00, 0x10, 0xAA, 0x1B, 0x02, 0x11, 0x34, 0x90, 0x10, 0x11, 0x52, 0x20, 0x10, 0x40, 0x63, 0xFE, 0x0B, 0x90, 0xB0, 0x11, 0x43, 0x60, 0x20, 0x8A, 0x60, 0xF7, 0x20, 0xB0, 0x11, 0x13, 0x70, 0x2D, 0xB0, 0x12, 0x2C, 0xFF, 0x4B, 0x54, 0x58, 0xB1, 0x04, 0x64, 0x44, 0x59, 0xFF, 0x24, 0xB0, 0x0D, 0x65, 0x23, 0x78, 0x2D, 0xB0, 0x7F, 0x13, 0x2C, 0x4B, 0x51, 0x58, 0x4B, 0x53, 0x01, 0x53, 0xEB, 0x1B, 0x21, 0x01, 0x80, 0x13, 0x01, 0x82, 0x14, 0x2C, 0xB1, 0xFF, 0x00, 0x12, 0x43, 0x55, 0x58, 0xB1, 0x12, 0x12, 0xFF, 0x43, 0xB0, 0x01, 0x61, 0x42, 0xB0, 0x11, 0x2B, 0x5C, 0x37, 0x31, 0x38, 0x90, 0x42, 0xB1, 0x0F, 0x00, 0x51, 0x10, 0x00, 0xA0, 0xF7, 0xB0, 0x01, 0x16, 0x18, 0xC0, 0x03, 0x25, 0x50, 0x58, 0x99, 0xB1, 0x38, 0x81, 0x22, 0xA0, 0x42, 0x8A, 0x1E, 0x20, 0x07, 0x70, 0x10, 0x07, 0x2A, 0x21, 0x23, 0x03, 0x70, 0x00, 0xC5, 0x21, 0x00, 0x02, 0x01, 0x03, 0x31, 0x54, 0x3C, 0xA0, 0x01, 0xE1, 0x59, 0x0C, 0xA0, 0x47, 0x0C, 0x00, 0x47, 0x01, 0x60, 0xA8, 0x1A, 0xDB, 0x1C, 0x3F, 0x1C, 0x32, 0xB1, 0xE4, 0x20, 0x23, 0x1C, 0x80, 0x43, 0xCF, 0xB0, 0x00, 0x3E, 0xB2, 0xF7, 0x30, 0x3F, 0x72, 0x15, 0x2C, 0xFF, 0x00, 0xB1, 0x00, 0x02, 0x45, 0x54, 0x58, 0xB0, 0x7F, 0x12, 0x23, 0x42, 0x20, 0x45, 0xB0, 0x0E, 0x2A, 0x00, 0xFB, 0x0D, 0x23, 0x27, 0x30, 0x42, 0x20, 0x60, 0xB7, 0x18, 0xEF, 0x18, 0x01, 0x00, 0x11, 0xEB, 0xB0, 0x42, 0x42, 0x42, 0xFA, 0x10, 0x21, 0x14, 0x2B, 0xC0, 0x01, 0x61, 0xB1, 0x14, 0x08, 0xBF, 0x2B, 0xB0, 0x8B, 0x2B, 0x1B, 0x22, 0x2D, 0xF0, 0x16, 0xFE, 0x0E, 0x40, 0x15, 0x2B, 0x2D, 0xB0, 0x17, 0x2C, 0xB1, 0xE5, 0x01, 0x00, 0x81, 0x18, 0x17, 0x00, 0x01, 0x01, 0x19, 0x2C, 0xB1, 0xBD, 0x03, 0x01, 0x81, 0x1A, 0x2C, 0xB1, 0x04, 0x02, 0x01, 0x1B, 0xF7, 0x2C, 0xB1, 0x05, 0x02, 0x81, 0x1C, 0x2C, 0xB1, 0x06, 0xDE, 0x03, 0x01, 0x1D, 0x2C, 0xB1, 0x07, 0x03, 0x81, 0x1E, 0x2C, 0x7B, 0xB1, 0x08, 0x04, 0x01, 0x1F, 0x2C, 0xB1, 0x09, 0x04, 0x81, 0x73, 0x2B, 0x2C, 0x29, 0xA0, 0x18, 0x03, 0xB0, 0x06, 0x60, 0x16, 0xA0, 0xBF, 0x23, 0x20, 0x2E, 0xB0, 0x01, 0x5D, 0x32, 0xE1, 0x2D, 0xAB, 0xB0, 0x2C, 0x01, 0xD8, 0x16, 0x01, 0xD6, 0x71, 0x01, 0xD3, 0x2D, 0xEA, 0x03, 0xA8, 0x26, 0x03, 0xA6, 0x72, 0x03, 0xA3, 0x20, 0x2C, 0x00, 0x47, 0xB0, 0x0F, 0x2B, 0x0E, 0x8F, 0x0E, 0x84, 0x19, 0xE0, 0xB5, 0x0E, 0xB3, 0x54, 0x0E, 0x81, 0x0E, 0x09, 0x21, 0x1C, 0x40, 0x20, 0x0E, 0x00, 0x22, 0x0E, 0x00, 0x92, 0x00, 0x81, 0x23, 0x25, 0x00, 0x01, 0x01, 0x24, 0x0E, 0x00, 0x01, 0x81, 0x25, 0x24, 0x0E, 0x00, 0x02, 0x01, 0x26, 0x0E, 0x00, 0x02, 0x81, 0x27, 0x0E, 0x00, 0x03, 0x01, 0x49, 0x28, 0x0E, 0x00, 0x03, 0x81, 0x29, 0x0E, 0x00, 0x04, 0x01, 0x2A, 0x0E, 0x00, 0xDE, 0x04, 0x81, 0x2E, 0x2C, 0x20, 0x3C, 0x3F, 0x72, 0x2F, 0x2C, 0x6E, 0x07, 0x70, 0x18, 0x60, 0x20, 0x4F, 0x50, 0x01, 0x60, 0x21, 0x41, 0xF5, 0x61, 0x38, 0x51, 0x2E, 0x2B, 0x41, 0x30, 0x2C, 0xB0, 0x2F, 0x57, 0x2B, 0xB0, 0x2F, 0x39, 0x00, 0x31, 0x39, 0x00, 0x47, 0x2B, 0x20, 0x3C, 0x39, 0x1F, 0x39, 0x10, 0x23, 0x61, 0x38, 0x23, 0x5D, 0x91, 0x02, 0x2F, 0xDC, 0x02, 0x28, 0x28, 0xF0, 0x2D, 0xB0, 0x32, 0x1E, 0x35, 0xB1, 0x0E, 0xFB, 0x06, 0x45, 0x27, 0x21, 0xB0, 0x31, 0x2A, 0xB1, 0x05, 0x4F, 0x01, 0x15, 0x45, 0x58, 0x51, 0x50, 0x1C, 0x61, 0x33, 0x11, 0xF8, 0xBC, 0x02, 0x4F, 0x02, 0x43, 0x34, 0x2C, 0x20, 0x35, 0x4B, 0x12, 0x35, 0x84, 0x23, 0x10, 0x04, 0x83, 0x45, 0x42, 0x7F, 0x50, 0x60, 0x43, 0xFF, 0x01, 0x84, 0x00, 0xFB, 0x16, 0xB4, 0x91, 0x42, 0x44, 0x3E, 0x23, 0x38, 0xB1, 0x17, 0x34, 0x01, 0x15, 0x3A, 0x01, 0x36, 0x11, 0x00, 0x0E, 0x30, 0x47, 0x3F, 0xFC, 0x47, 0x31, 0x6A, 0x00, 0x61, 0x38, 0x2D, 0xB0, 0x37, 0x2C, 0x3F, 0x2E, 0x17, 0x3C, 0x2D, 0xB0, 0x38, 0x02, 0xBF, 0x02, 0xBB, 0xEA, 0x2D, 0x90, 0x63, 0x02, 0xF0, 0x39, 0x3F, 0x30, 0x00, 0x16, 0x25, 0xCF, 0x20, 0x2E, 0x20, 0x47, 0x4E, 0x41, 0x6F, 0x80, 0x49, 0x8A, 0x2F, 0x8A, 0x47, 0x23, 0x47, 0x48, 0x30, 0x58, 0x6F, 0x90, 0x5A, 0x90, 0xBE, 0x69, 0x20, 0x38, 0x01, 0x01, 0x15, 0x14, 0x4F, 0x20, 0x3A, 0xAE, 0x4B, 0xC0, 0x16, 0xB0, 0x17, 0x59, 0x40, 0x04, 0x54, 0xF0, 0x25, 0xFE, 0x02, 0x72, 0xB1, 0x0C, 0x00, 0x42, 0xB0, 0x0B, 0x43, 0xFF, 0x2B, 0x65, 0x8A, 0x2E, 0x23, 0x20, 0x20, 0x3C, 0xB5, 0x8A, 0x08, 0x30, 0x3B, 0x02, 0x7B, 0x20, 0x2E, 0x05, 0x03, 0xB0, 0x77, 0x06, 0x23, 0x42, 0x02, 0xE5, 0x20, 0xB0, 0x60, 0x45, 0x41, 0xFF, 0x40, 0x51, 0x58, 0xB3, 0x04, 0x20, 0x05, 0x20, 0xFF, 0x1B, 0xB3, 0x04, 0x26, 0x05, 0x1A, 0x59, 0x42, 0xE2, 0x56, 0xA1, 0x0A, 0x5B, 0x50, 0x08, 0x00, 0x08, 0x20, 0x23, 0x46, 0x60, 0xC3, 0xB0, 0x06, 0x73, 0xF0, 0x55, 0xCC, 0x52, 0xD1, 0x69, 0x63, 0x04, 0x43, 0x9F, 0x60, 0x64, 0x23, 0xB0, 0x05, 0x75, 0x50, 0x62, 0xB0, 0x04, 0x97, 0x43, 0x61, 0x1B, 0x00, 0xC0, 0x60, 0x51, 0xF1, 0x3E, 0x3D, 0x61, 0xAC, 0x09, 0xB0, 0x72, 0x20, 0x23, 0x46, 0x1E, 0x40, 0x23, 0x06, 0x20, 0x46, 0x46, 0x6B, 0x21, 0x0A, 0x43, 0x0E, 0x82, 0x4A, 0xC0, 0x06, 0x5F, 0x60, 0x5F, 0x30, 0x12, 0x59, 0x31, 0x06, 0x46, 0x50, 0x1A, 0x50, 0x05, 0x44, 0x40, 0x64, 0x20, 0x43, 0x9C, 0x14, 0x77, 0x40, 0x08, 0x51, 0x25, 0x08, 0x51, 0x03, 0x00, 0x60, 0x54, 0xA4, 0x06, 0xC7, 0x6A, 0x6D, 0x20, 0x3C, 0x13, 0x35, 0x20, 0x54, 0xC0, 0x05, 0x26, 0x10, 0xC4, 0x6B, 0x23, 0x3C, 0x1A, 0xA0, 0x3D, 0x01, 0xB6, 0xB0, 0x0A, 0x02, 0x02, 0x27, 0x46, 0x23, 0x47, 0x60, 0x81, 0x1C, 0x61, 0x3E, 0x16, 0xA6, 0x0C, 0xD1, 0xFE, 0x16, 0xA3, 0xB0, 0x00, 0x54, 0x58, 0x2E, 0x20, 0x3C, 0xE0, 0x7D, 0x10, 0x77, 0x01, 0x01, 0x54, 0x05, 0x50, 0x18, 0xB6, 0xB0, 0x06, 0x25, 0x62, 0x0A, 0xA0, 0x49, 0x8B, 0xC9, 0x1C, 0x53, 0x6A, 0x1F, 0x60, 0x23, 0x1A, 0xE4, 0xAE, 0x5F, 0xA0, 0x2D, 0xB0, 0x3F, 0x08, 0xA8, 0x43, 0x1A, 0xF5, 0x60, 0xA8, 0x8E, 0x11, 0x52, 0xCD, 0x1E, 0x35, 0x40, 0x47, 0xA0, 0x2E, 0x14, 0x61, 0x46, 0xBF, 0xB0, 0x17, 0x43, 0x58, 0x50, 0x1B, 0x75, 0x40, 0x20, 0x7F, 0x3C, 0x59, 0x2E, 0xB1, 0x30, 0x01, 0x14, 0x4E, 0x00, 0x5D, 0x41, 0x01, 0xEA, 0x52, 0x1B, 0x50, 0x01, 0xEA, 0x42, 0x03, 0xCF, 0xF8, 0x03, 0xC0, 0x03, 0x2F, 0x05, 0x07, 0x43, 0x2C, 0xB0, 0x3A, 0x2B, 0xFC, 0x07, 0x1F, 0x07, 0x17, 0x44, 0x2C, 0xB0, 0x3B, 0x2B, 0x8A, 0xC0, 0x27, 0xF0, 0x26, 0x41, 0x0D, 0x50, 0x09, 0xCF, 0x09, 0xC4, 0x25, 0x00, 0x2E, 0xB0, 0xA5, 0x30, 0x58, 0x30, 0x45, 0x2C, 0xB2, 0x2C, 0x71, 0x26, 0x17, 0xA3, 0x61, 0x52, 0x9A, 0x10, 0x42, 0x2A, 0xA3, 0x2C, 0xF1, 0x23, 0x36, 0xA0, 0x2E, 0x37, 0xA0, 0x1E, 0x0D, 0x13, 0x46, 0x2C, 0xB1, 0x0A, 0x66, 0xC0, 0x03, 0x35, 0x2D, 0x3F, 0x04, 0x2D, 0x3F, 0x2D, 0x38, 0x47, 0x2C, 0x6F, 0x2C, 0x6F, 0x2C, 0x6F, 0x2C, 0x6F, 0x17, 0x01, 0x66, 0x4C, 0x81, 0x3C, 0x23, 0x4A, 0xB0, 0x23, 0x08, 0x21, 0x59, 0x17, 0x94, 0xAD, 0x47, 0x74, 0x50, 0x3A, 0x2B, 0x18, 0x75, 0x48, 0x75, 0x30, 0x3B, 0x43, 0x2B, 0x21, 0x39, 0x71, 0x37, 0xC1, 0x0C, 0xE4, 0x10, 0x36, 0x49, 0x88, 0xA0, 0xF1, 0x15, 0x3F, 0x73, 0xAD, 0x70, 0x3E, 0x20, 0x13, 0x2E, 0xB0, 0x36, 0xD2, 0x8D, 0x80, 0x4A, 0x01, 0x8F, 0x01, 0x82, 0x4B, 0x7A, 0x20, 0x01, 0x14, 0xF7, 0x13, 0xB0, 0x37, 0x8F, 0xC0, 0x4C, 0x2C, 0xB0, 0x39, 0x6A, 0x90, 0x30, 0x4D, 0x41, 0x11, 0x45, 0x67, 0x60, 0x20, 0x46, 0x8B, 0x50, 0xB6, 0x12, 0xE5, 0x4E, 0x2C, 0x2D, 0x11, 0xB0, 0x4D, 0x6E, 0xA0, 0x4F, 0x5F, 0x2C, 0xB2, 0x00, 0x00, 0x46, 0x6F, 0x30, 0x50, 0x00, 0x90, 0xBD, 0x01, 0x00, 0x91, 0x51, 0x2C, 0xB2, 0x01, 0x01, 0x22, 0x52, 0x54, 0x00, 0x90, 0x01, 0x22, 0x53, 0x02, 0x41, 0x47, 0x71, 0x70, 0x54, 0x02, 0x41, 0x92, 0x00, 0x91, 0x55, 0x02, 0x41, 0x01, 0x21, 0x56, 0x02, 0x41, 0x01, 0xB1, 0x57, 0x2B, 0x2C, 0xB3, 0xFC, 0xC0, 0x43, 0x73, 0xC0, 0x58, 0x00, 0xA0, 0xB8, 0x40, 0x4E, 0x74, 0x60, 0x59, 0x2C, 0xB3, 0xF7, 0x10, 0x01, 0x41, 0x5A, 0x00, 0xA0, 0x2A, 0x01, 0x43, 0x5B, 0x02, 0x81, 0x01, 0x02, 0x81, 0x5C, 0x02, 0x81, 0x00, 0xA2, 0x49, 0x5D, 0x02, 0x81, 0x01, 0x42, 0x5E, 0x02, 0x81, 0x01, 0xE2, 0x5F, 0x09, 0x81, 0x25, 0x45, 0x78, 0xB0, 0x60, 0x09, 0x81, 0x00, 0x91, 0x61, 0x09, 0x81, 0x01, 0x21, 0xA9, 0x62, 0x09, 0x81, 0x01, 0xB1, 0x63, 0x0B, 0xC1, 0x48, 0x7A, 0xF0, 0x64, 0x24, 0x0B, 0xC1, 0x00, 0x91, 0x65, 0x0B, 0xC1, 0x01, 0x21, 0x66, 0x0B, 0xC1, 0x01, 0xB1, 0x95, 0x67, 0x09, 0x82, 0x44, 0x7D, 0x40, 0x68, 0x09, 0x82, 0x00, 0xA1, 0x69, 0x24, 0x09, 0x82, 0x01, 0x41, 0x6A, 0x09, 0x82, 0x01, 0xE1, 0x6B, 0x09, 0x82, 0x02, 0x81, 0x49, 0x6C, 0x09, 0x82, 0x03, 0x21, 0x6D, 0x09, 0x82, 0x03, 0xC1, 0x6E, 0x09, 0x82, 0xAA, 0x04, 0x61, 0x6F, 0x90, 0x60, 0x3C, 0x1C, 0x16, 0x70, 0x00, 0xE2, 0xB0, 0x55, 0x40, 0x83, 0x30, 0x71, 0x00, 0xB3, 0x41, 0x83, 0xE0, 0x72, 0x58, 0x61, 0x4A, 0x01, 0x92, 0x42, 0x84, 0xC0, 0x73, 0x84, 0xC0, 0x02, 0x44, 0x74, 0x00, 0xB3, 0xA2, 0x02, 0x41, 0x75, 0x02, 0x42, 0x01, 0x91, 0x02, 0x41, 0x76, 0x95, 0xC0, 0x3D, 0x92, 0x21, 0x76, 0x77, 0x00, 0xE2, 0x05, 0x62, 0x78, 0x00, 0xB3, 0x05, 0x61, 0x79, 0x24, 0x01, 0x63, 0x05, 0x31, 0x7A, 0x89, 0xF0, 0x02, 0x14, 0x7B, 0x00, 0xB3, 0x07, 0x71, 0xA9, 0x7C, 0x01, 0x63, 0x07, 0x41, 0x7D, 0x9A, 0xC0, 0x3E, 0x26, 0x76, 0x7E, 0x24, 0x00, 0xE2, 0x0A, 0x62, 0x7F, 0x00, 0xB3, 0x0A, 0x61, 0x80, 0x01, 0x63, 0x0A, 0x31, 0x49, 0x81, 0x8E, 0xF0, 0x02, 0x14, 0x82, 0x00, 0xB3, 0x0C, 0x71, 0x83, 0x01, 0x63, 0x2A, 0x0C, 0x41, 0x84, 0x9F, 0xC0, 0x3F, 0x2B, 0x76, 0x85, 0x00, 0xE2, 0x0F, 0x62, 0x49, 0x86, 0x00, 0xB3, 0x0F, 0x61, 0x87, 0x01, 0x63, 0x0F, 0x31, 0x88, 0x93, 0xF0, 0x92, 0x02, 0x14, 0x89, 0x00, 0xB3, 0x11, 0x71, 0x8A, 0x01, 0x63, 0x11, 0x41, 0x8B, 0xF7, 0x2C, 0xB2, 0x0B, 0xAD, 0xA2, 0xB0, 0x06, 0x1B, 0xB2, 0xCF, 0x04, 0x02, 0x03, 0x45, 0xD3, 0x50, 0xA6, 0xB0, 0x59, 0x42, 0xFF, 0x2B, 0xB0, 0x08, 0x65, 0xB0, 0x03, 0x24, 0x50, 0x6D, 0x78, 0x7D, 0x15, 0x2D, 0x00, 0xE0, 0x10, 0xC8, 0x52, 0xA4, 0xF0, 0xF3, 0x01, 0x8E, 0xC9, 0x50, 0xDF, 0x33, 0x70, 0xB1, 0x00, 0x07, 0xFF, 0x42, 0xB4, 0x00, 0x25, 0x16, 0x03, 0x00, 0x2A, 0xFE, 0x00, 0xB1, 0xB7, 0x2A, 0x04, 0x1A, 0x08, 0x12, 0x04, 0xFB, 0x03, 0x0A, 0x00, 0xE3, 0x2E, 0x02, 0x22, 0x06, 0x16, 0xFD, 0x02, 0x00, 0xE2, 0x0A, 0x42, 0xBC, 0x0A, 0xC0, 0x06, 0xD7, 0xC0, 0x04, 0xC0, 0xE9, 0x90, 0x0B, 0x02, 0xC0, 0x0D, 0x42, 0xA7, 0xBC, 0x00, 0x40, 0x00, 0x22, 0x01, 0x01, 0xB9, 0xEA, 0xF1, 0x44, 0xDF, 0xB1, 0x24, 0x01, 0x88, 0x51, 0xC1, 0xA0, 0x88, 0x58, 0xDE, 0x01, 0x01, 0x64, 0x44, 0xB1, 0x28, 0x01, 0x01, 0xB8, 0x08, 0xB5, 0x00, 0x01, 0x13, 0x00, 0xB0, 0x60, 0xB1, 0x27, 0x02, 0x31, 0xBA, 0xFF, 0x08, 0x80, 0x00, 0x01, 0x04, 0x40, 0x88, 0x63, 0xF9, 0x54, 0x01, 0x95, 0x00, 0x11, 0xB7, 0x2C, 0x02, 0x1C, 0x06, 0xFF, 0x14, 0x02, 0x03, 0x0E, 0x2A, 0xB8, 0x01, 0xFF, 0xEF, 0x85, 0xB0, 0x04, 0x8D, 0x7B, 0x00, 0x44, 0xB3, 0x05, 0x1F, 0x64, 0x06, 0x00, 0x44, 0x44, 0xF8, 0x5C, 0x00, 0xFF, 0xFC, 0x00, 0x4D, 0x18, 0x00, 0x23, 0x01, 0xF8, 0xF4, 0xE1, 0xFD, 0x00, 0x56, 0x00, 0x20, 0xB7, 0x48, 0x00, 0x48, 0xF5, 0x81, 0x02, 0xD0, 0x01, 0x61, 0xFF, 0xFF, 0x24, 0x02, 0xC8, 0xFF, 0xF4, 0x02, 0xD5, 0x02, 0xDF, 0x04, 0xFF, 0xF4, 0xFF, 0x24, 0x03, 0x05, 0x02, 0xC6, 0x2B, 0x01, 0x60, 0x00, 0x40, 0x5B, 0x00, 0x00, 0x07, 0xF5, 0x80, 0xF7, 0x20, 0xCB, 0x04, 0x09, 0xFF, 0x40, 0xA8, 0xF8, 0x42, 0x00, 0xC1, 0x01, 0x00, 0xA9, 0x0E, 0x00, 0xE0, 0x01, 0x83, 0x02, 0x00, 0xC0, 0xB6, 0x02, 0x44, 0x03, 0xEF, 0x00, 0x32, 0x00, 0xC4, 0x03, 0x04, 0x04, 0x00, 0x1E, 0x7B, 0x00, 0xF6, 0x03, 0xC4, 0x05, 0x00, 0x54, 0x01, 0xFB, 0xA2, 0xFE, 0x04, 0x80, 0x06, 0x00, 0x1C, 0x01, 0x68, 0x00, 0x43, 0xFF, 0x00, 0x6F, 0x00, 0x70, 0x00, 0x79, 0x00, 0x72, 0xBE, 0xFB, 0x60, 0x67, 0x00, 0x68, 0x00, 0x74, 0xFE, 0x80, 0x32, 0xBF, 0x00, 0x30, 0x00, 0x31, 0x00, 0x34, 0xFF, 0x20, 0x54, 0xBA, 0x01, 0x20, 0x65, 0xFF, 0xA0, 0x44, 0x00, 0x4D, 0x00, 0x00, 0x53, 0xAE, 0xFC, 0xE0, 0x6E, 0x00, 0x73, 0xFE, 0x40, 0x50, 0x03, 0x00, 0x6F, 0xEB, 0x00, 0x6A, 0x01, 0xC0, 0x63, 0x03, 0x22, 0x41, 0x00, 0x75, 0xAA, 0x03, 0xA0, 0x68, 0x04, 0xC0, 0x72, 0x02, 0x02, 0x28, 0x04, 0xA2, 0x74, 0xBE, 0x05, 0xA0, 0x73, 0x00, 0x3A, 0x00, 0x2F, 0x00, 0x20, 0x67, 0x7C, 0x06, 0x00, 0x02, 0x21, 0x75, 0x00, 0x62, 0x00, 0x2E, 0x03, 0x60, 0xD7, 0x6F, 0x00, 0x6D, 0x01, 0x62, 0x6F, 0x08, 0x00, 0x67, 0x00, 0x55, 0x6C, 0x06, 0x60, 0x66, 0x08, 0xA0, 0x6E, 0x08, 0x00, 0x73, 0x03, 0x00, 0x55, 0x64, 0x01, 0xE0, 0x2D, 0x01, 0x28, 0x29, 0x08, 0x2C, 0x52, 0x09, 0x60, 0x55, 0x67, 0x07, 0x40, 0x6C, 0x09, 0x20, 0x72, 0x0A, 0xA0, 0x2E, 0x0B, 0x20, 0x7D, 0x30, 0x0B, 0x20, 0x3B, 0x00, 0x47, 0x00, 0x4F, 0x00, 0x20, 0x11, 0x47, 0x00, 0xA0, 0x0B, 0x41, 0x0B, 0x25, 0x2D, 0x03, 0x2C, 0x0D, 0x0D, 0x05, 0x0B, 0xA9, 0x56, 0x0F, 0x40, 0x0C, 0x81, 0x69, 0x09, 0x22, 0x20, 0x06, 0x0A, 0x20, 0x52, 0x0D, 0x82, 0x66, 0x10, 0xA0, 0x0F, 0x21, 0x6F, 0x13, 0x20, 0x69, 0x0B, 0x62, 0x3A, 0x0F, 0x41, 0x76, 0x13, 0x60, 0x2E, 0x00, 0x38, 0x0E, 0x00, 0x09, 0x21, 0x15, 0x37, 0x0C, 0x20, 0x35, 0x0C, 0xA0, 0x35, 0x0F, 0x20, 0x0C, 0x03, 0x08, 0xEF, 0x18, 0x0C, 0x03, 0x1C, 0xE1, 0xA6, 0x72, 0xFF, 0x9C, 0x1B, 0x80, 0x25, 0x0F, 0x54, 0xD0, 0xBF, 0x00, 0x01, 0xFF, 0xFF, 0x00, 0x0F, 0xEB, 0xF0, 0x00, 0xEB, 0x00, 0x0C, 0xA9, 0x20, 0x7C, 0xA9, 0x60, 0x02, 0x00, 0x12, 0x54, 0x01, 0x81, 0xED, 0x30, 0x03, 0x1D, 0x80, 0x01, 0x22, 0x20, 0x07, 0xED, 0xF0, 0x1D, 0x09, 0x00, 0x20, 0x01, 0x00, 0x0B, 0x02, 0x60, 0x21, 0xC1, 0x03, 0x21, 0xD7, 0x11, 0x00, 0x15, 0xEF, 0x70, 0x17, 0x00, 0x20, 0x01, 0x00, 0x77, 0x19, 0x00, 0x1B, 0xF0, 0x30, 0x1D, 0x00, 0x1F, 0xF0, 0x90, 0xD7, 0x21, 0x00, 0x23, 0xF0, 0xF0, 0x25, 0x00, 0x20, 0x01, 0x00, 0x7D, 0x27, 0x1B, 0x20, 0x01, 0x00, 0x2A, 0x00, 0x2B, 0xF2, 0x10, 0x5D, 0x2E, 0x1F, 0xC0, 0x01, 0x00, 0x33, 0x00, 0x20, 0x01, 0x0C, 0x00, 0xD5, 0x36, 0xF3, 0x30, 0x37, 0x0D, 0x40, 0x02, 0x8C, 0xB0, 0x02, 0x00, 0xA5, 0x10, 0x2C, 0xA0, 0x01, 0xF9, 0x70, 0x01, 0x21, 0x01, 0x25, 0xA0, 0x01, 0xEB, 0x01, 0x19, 0x00, 0x84, 0x1A, 0x09, 0xC2, 0x0A, 0x00, 0x24, 0xFE, 0x27, 0xA0, 0x02, 0x44, 0x46, 0x4C, 0x54, 0x00, 0x0E, 0xAF, 0x6C, 0x61, 0x74, 0x6E, 0x2A, 0x00, 0x04, 0x0D, 0xA2, 0xFF, 0x3E, 0x0B, 0xC2, 0x01, 0x6B, 0x65, 0x72, 0x6E, 0x91, 0x50, 0x0D, 0x21, 0xBA, 0x0D, 0x61, 0x04, 0x05, 0x84, 0x0A, 0x02, 0x3A, 0xF9, 0xB0, 0x46, 0xFE, 0x02, 0xC2, 0x1E, 0x00, 0x86, 0x00, 0x90, 0x00, 0xAA, 0xFF, 0x00, 0xE8, 0x00, 0xB0, 0x00, 0xD6, 0x00, 0xDC, 0xFB, 0x00, 0xE2, 0x00, 0xA0, 0xEE, 0x01, 0x20, 0x01, 0x32, 0xFF, 0x01, 0x3C, 0x01, 0x46, 0x01, 0x84, 0x01, 0x8E, 0xFF, 0x01, 0xD6, 0x01, 0x94, 0x01, 0x9A, 0x01, 0xA4, 0xAF, 0x01, 0xC6, 0x01, 0xD0, 0x00, 0x22, 0xD6, 0x01, 0x20, 0xE0, 0xBF, 0x01, 0xE6, 0x01, 0xEC, 0x02, 0x16, 0xFE, 0x10, 0x1E, 0x4A, 0x0A, 0x22, 0x03, 0x2F, 0x80, 0x06, 0x09, 0x00, 0x10, 0xA1, 0x0F, 0x0B, 0x80, 0x57, 0x14, 0x00, 0x16, 0x10, 0x40, 0x18, 0x10, 0x22, 0x1C, 0x10, 0x22, 0xA5, 0x20, 0x10, 0x20, 0x22, 0x25, 0xA0, 0x0F, 0x61, 0x2C, 0x26, 0xE0, 0x2F, 0xFA, 0x33, 0x40, 0x34, 0x34, 0x60, 0x20, 0xFF, 0xEF, 0x00, 0x32, 0xFB, 0xFF, 0xCD, 0x32, 0x00, 0x01, 0xFF, 0xF4, 0x00, 0x14, 0xBE, 0x00, 0xE0, 0x16, 0xFF, 0xEC, 0x00, 0x17, 0x00, 0x40, 0x18, 0xBF, 0xFF, 0xE9, 0x00, 0x19, 0xFF, 0xE2, 0x6F, 0xA0, 0x18, 0xFC, 0x01, 0x20, 0x37, 0xE0, 0xFF, 0xB9, 0x00, 0x0A, 0xFF, 0xC7, 0xFF, 0x00, 0x1B, 0xFF, 0xDE, 0x00, 0x1D, 0xFF, 0xEB, 0xAB, 0x00, 0x1E, 0x00, 0x40, 0x1F, 0x00, 0x80, 0x2B, 0x00, 0xC0, 0x2D, 0xA2, 0x01, 0x00, 0x2F, 0x03, 0x80, 0x1B, 0xA1, 0x03, 0x21, 0x32, 0x00, 0x64, 0xBD, 0x5A, 0x03, 0xE2, 0xD1, 0x1A, 0x01, 0xFF, 0xA8, 0x03, 0xE0, 0xB3, 0x05, 0x60, 0x5D, 0xE2, 0x05, 0x60, 0xF4, 0x00, 0x1A, 0x06, 0x60, 0x1B, 0x06, 0x20, 0xD7, 0x1D, 0xFF, 0xE3, 0x04, 0xA0, 0xE3, 0x04, 0xA0, 0xE3, 0x00, 0x57, 0x21, 0xFF, 0xDB, 0x04, 0xE0, 0xE3, 0x04, 0xE0, 0xE3, 0x3C, 0x80, 0x7F, 0x0A, 0xFF, 0xAD, 0x00, 0x2C, 0xFF, 0xCE, 0x09, 0xE0, 0x47, 0xC4, 0x00, 0x34, 0x04, 0x40, 0x13, 0x80, 0x00, 0xA0, 0x32, 0x0B, 0x00, 0xBA, 0x00, 0xA1, 0xD8, 0x00, 0xA2, 0x0F, 0x00, 0x03, 0x05, 0xE0, 0x07, 0xAA, 0x06, 0x20, 0x0F, 0x06, 0x60, 0x11, 0x06, 0xA0, 0x1B, 0x09, 0xA0, 0x1D, 0xAB, 0xFF, 0xE1, 0x09, 0xE0, 0xE1, 0x09, 0xE0, 0xE1, 0x09, 0xE0, 0xE1, 0x3A, 0x09, 0xE0, 0xE1, 0x09, 0xE0, 0xEF, 0x00, 0x31, 0x0D, 0x20, 0x09, 0xA1, 0xA5, 0x33, 0x0D, 0x60, 0x35, 0x0C, 0x20, 0x05, 0x21, 0xAF, 0x0F, 0xE0, 0xD6, 0xAA, 0x0B, 0x22, 0xED, 0x0B, 0x82, 0xF0, 0x45, 0xA0, 0x32, 0x10, 0x20, 0x34, 0xAA, 0x0F, 0xE0, 0x08, 0x0E, 0xC0, 0xEC, 0x0E, 0xC0, 0xEC, 0x0E, 0xC0, 0xEC, 0xAA, 0x0E, 0xC0, 0xEC, 0x0A, 0x20, 0xD8, 0x0F, 0x00, 0xEC, 0x0F, 0x00, 0xEC, 0x2A, 0x0F, 0x00, 0xED, 0x48, 0x60, 0x26, 0x16, 0xC0, 0x32, 0x4A, 0xC1, 0x14, 0x60, 0xD5, 0xF6, 0x03, 0xC2, 0xE7, 0x0A, 0xE0, 0xEB, 0x83, 0x00, 0x26, 0x00, 0xAE, 0x22, 0x61, 0x32, 0xFF, 0xE5, 0x22, 0x80, 0x1B, 0x01, 0x60, 0x1D, 0xAA, 0x01, 0xA0, 0x1E, 0x01, 0xE0, 0x1F, 0x02, 0x20, 0x20, 0x1A, 0x20, 0x21, 0xAA, 0x13, 0xC2, 0xE7, 0x13, 0xC0, 0xE7, 0x13, 0xC0, 0xE6, 0x48, 0x60, 0x03, 0xCE, 0x4A, 0x60, 0x1B, 0xFF, 0xFD, 0x15, 0xEF, 0x0A, 0xC1, 0x03, 0xEC, 0x5E, 0x25, 0xC1, 0x04, 0x2E, 0x04, 0x9E, 0x05, 0x80, 0x13, 0x58, 0x7F, 0xE4, 0x1B, 0x60, 0x00, 0x67, 0xFD, 0x1D, 0x60, 0x02, 0x2F, 0xCE, 0xFF, 0xCF, 0x2A, 0x57, 0xC0, 0xE7, 0x37, 0xE4, 0xDC, 0x38, 0x64, 0xE5, 0x5D, 0x3F, 0x15, 0xE0, 0x4A, 0x3A, 0x01, 0xED, 0x3A, 0x62, 0xEB, 0x05, 0xA3, 0x06, 0xEC, 0xE2, 0x60, 0x9F, 0xDE, 0x05, 0x05, 0xFF, 0xD8, 0xFF, 0xEC, 0x02, 0x01, 0xFF, 0xF5, 0xBE, 0x5E, 0xA0, 0xB7, 0xFF, 0xC4, 0xFF, 0xBA, 0x5F, 0x20, 0xD9, 0xAA, 0x5F, 0x60, 0xB1, 0x5F, 0xA0, 0xD6, 0x5F, 0xE0, 0x9F, 0x64, 0x5F, 0xFF, 0x15, 0xF1, 0x41, 0x22, 0xF6, 0x41, 0xA4, 0xF2, 0x66, 0x7F, 0x02, 0x67, 0x0F, 0xAE, 0xF7, 0xEB, 0xFF, 0xBF, 0x09, 0x27, 0xFF, 0x9C, 0xFF, 0xC3, 0x4A, 0x07, 0x22, 0xE2, 0x00, 0x20, 0x91, 0x0F, 0x61, 0x67, 0x00, 0x88, 0x67, 0x40, 0x1F, 0xA9, 0xFF, 0xCF, 0xFF, 0xB7, 0x08, 0xA1, 0x0A, 0x20, 0x00, 0x81, 0xDE, 0x13, 0x00, 0xFF, 0xBA, 0xFF, 0xEF, 0x0E, 0xC1, 0xFF, 0xAF, 0x54, 0x02, 0xE0, 0x14, 0x03, 0xD1, 0x69, 0xE0, 0xE1, 0x15, 0xAC, 0xE3, 0x4B, 0x04, 0x84, 0x01, 0x8C, 0x4C, 0x64, 0xEF, 0x03, 0x01, 0x1B, 0x60, 0x00, 0xE4, 0x19, 0x28, 0xCD, 0x3B, 0xFF, 0xE7, 0x17, 0x22, 0xEF, 0xFF, 0xF2, 0x10, 0x41, 0x4F, 0x42, 0x0C, 0x10, 0x81, 0x19, 0xC0, 0xFF, 0xD7, 0x74, 0x9F, 0x75, 0xBF, 0x10, 0xAF, 0x0F, 0x47, 0x64, 0x1A, 0x27, 0x75, 0x00, 0xEA, 0x55, 0x24, 0x1B, 0x20, 0xFF, 0xEE, 0x7A, 0x3F, 0xC0, 0x22, 0x07, 0x7B, 0xFF, 0x1A, 0xA2, 0x22, 0xE4, 0x00, 0x86, 0x11, 0xC1, 0xA6, 0xFF, 0x17, 0xDC, 0xFF, 0xB6, 0x7A, 0xC0, 0xC7, 0x23, 0x80, 0x1B, 0xA1, 0x14, 0x81, 0x77, 0xBB, 0xFF, 0xCB, 0x0B, 0xE2, 0xA6, 0xFF, 0xDE, 0x1D, 0x21, 0x80, 0x05, 0x8F, 0x81, 0xFF, 0x07, 0xCF, 0x84, 0x3F, 0x0B, 0xE7, 0x85, 0xFF, 0x62, 0xC4, 0xF4, 0x00, 0x11, 0x2F, 0x88, 0xBF, 0x89, 0xDF, 0x2D, 0x09, 0x8B, 0xBF, 0x2A, 0x62, 0x26, 0xC6, 0x1E, 0x81, 0x38, 0x21, 0x00, 0x33, 0xAA, 0x01, 0x42, 0xDF, 0xFF, 0xD7, 0x16, 0x23, 0x35, 0x63, 0x62, 0x25, 0x22, 0xF6, 0x27, 0x06, 0x18, 0xA2, 0x35, 0x03, 0xFF, 0xFC, 0x23, 0xAF, 0x0A, 0x3A, 0x6C, 0xBF, 0x32, 0x00, 0xC8, 0x25, 0x41, 0x8F, 0xA0, 0x30, 0x84, 0x55, 0x40, 0x4A, 0x18, 0x63, 0xC3, 0x36, 0xA4, 0x01, 0x6B, 0x22, 0x5D, 0x41, 0x07, 0x5D, 0x24, 0x25, 0x12, 0x3F, 0x20, 0x14, 0x6D, 0xA0, 0x5D, 0x61, 0x19, 0x45, 0x80, 0x5D, 0x65, 0xAA, 0x5D, 0x41, 0x27, 0x5D, 0x66, 0x2E, 0x87, 0xC0, 0x30, 0x6C, 0xC0, 0x35, 0x2A, 0x72, 0xA2, 0x35, 0x68, 0xC2, 0x0A, 0x74, 0x62, 0x00, 0x71, 0x60, 0x9B, 0xA3, 0x51, 0x17, 0x95, 0xC0, 0x76, 0x43, 0x9C, 0xA1, 0x16, 0x62, 0xE2, 0x03, 0x72, 0xA0, 0x15, 0x0B, 0xCE, 0xC0, 0x08, 0x73, 0xE0, 0x05, 0x95, 0xA0, 0x77, 0x41, 0x9E, 0x81, 0xA9, 0x12, 0x93, 0x60, 0x9D, 0x47, 0x00, 0x94, 0x40, 0x06, 0x97, 0x80, 0x02, 0x4E, 0xD1, 0x60, 0x13, 0x00, 0x0D, 0x66, 0x40, 0xA0, 0xC1, 0x0E, 0xD2, 0x40, 0x02, 0x99, 0xA1, 0x01, 0x73, 0xC0, 0x05, 0xA1, 0x01, 0xE1, 0xA2, 0x41, 0x00, 0x85, 0xA3, 0x05, 0x14, 0x03, 0x61, 0x03, 0xA1, 0x0D, 0x72, 0x42, 0x12, 0x73, 0xC0, 0x07, 0x01, 0x80, 0xC3, 0x92, 0x7D, 0x83, 0x00, 0x7F, 0x20, 0xA5, 0xEB, 0x05, 0x7E, 0xA2, 0x81, 0x01, 0x05, 0x92, 0x7E, 0x40, 0x10, 0x08, 0xE2, 0x81, 0x01, 0x09, 0x7E, 0x60, 0x78, 0x03, 0x54, 0xAB, 0x00, 0x7A, 0x78, 0x0A, 0x12, 0x59, 0x00, 0x00, 0x6E, 0x80, 0x05, 0xFF, 0x41, 0x5A, 0x45, 0x20, 0x00, 0x2C, 0x43, 0x52, 0xDD, 0x54, 0x00, 0x60, 0x4B, 0x41, 0x5A, 0x00, 0xC0, 0x54, 0x41, 0x0E, 0x00, 0xC1, 0x54, 0x52, 0x4B, 0x01, 0x80, 0x7A, 0x22, 0x0C, 0x81, 0xDC, 0xD0, 0xF8, 0x86, 0xA0, 0x08, 0x43, 0x74, 0x60, 0x63, 0x63, 0x6D, 0x70, 0x00, 0xFF, 0x14, 0x6C, 0x69, 0x67, 0x61, 0x00, 0x1A, 0x6C, 0x87, 0x6F, 0x63, 0x6C, 0xA1, 0xE0, 0x12, 0xA5, 0x80, 0x81, 0x0A, 0xA3, 0x03, 0xAE, 0xBB, 0x00, 0x2E, 0x00, 0x42, 0x04, 0x04, 0x08, 0xE1, 0xA0, 0x0A, 0x00, 0x89, 0xE2, 0x82, 0xC7, 0x75, 0x60, 0x86, 0xE0, 0x00, 0x61, 0x86, 0x81, 0x02, 0x65, 0x13, 0xC1, 0x82, 0x8C, 0x21, 0x23, 0xAA, 0x40, 0x03, 0x61, 0x03, 0xA1, 0x84, 0x81, 0x86, 0xA1, 0x06, 0xCA, 0x8E, 0x80, 0x37, 0xAD, 0x40, 0x23, 0x87, 0xC2, 0x89, 0xE1, 0x01, 0x00, 0x01, 0x20
};
unsigned char* _fontData = nullptr;
std::atomic<int> _instanceCnt{0};

inline const void retrieveFont() {
    if (--_instanceCnt == 0) std::free(_fontData);
}

inline const char* requestFont() {
    if (_instanceCnt++ > 0) return reinterpret_cast<const char*>(_fontData);

    const unsigned char* input = COMPRESSED_FONT;
    _fontData = new unsigned char[DEFAULT_FONT_SIZE];
    size_t inputPos = 0;
    size_t outputPos = 0;

    /*
    LZSS: Lempel-Ziv-Storer-Szymanski compression algorithm
    by James A. Storer and Thomas Szymanski
    */
    // Obtain font _fontData using LZSS decompression
    while (inputPos < COMPRESSED_FONT_SIZE && outputPos < DEFAULT_FONT_SIZE) {
        unsigned char flags = input[inputPos++];
        
        for (int bit = 0; bit < 8 && outputPos < DEFAULT_FONT_SIZE; bit++) {
            if (flags & (1 << bit)) _fontData[outputPos++] = input[inputPos++];
            else {
                unsigned short offset = input[inputPos++] << 4;
                unsigned char lengthOffset = input[inputPos++];
                offset |= lengthOffset >> 4;
                unsigned char length = (lengthOffset & 0x0F) + 3;
                
                size_t copy_pos = outputPos - offset;
                for (int i = 0; i < length; i++) _fontData[outputPos++] = _fontData[copy_pos + i];
            }
        }
    }

    return reinterpret_cast<const char*>(_fontData);
}

#else

constexpr size_t DEFAULT_FONT_SIZE = 0;

inline void retrieveFont() {}
inline const char* requestFont() { return nullptr; }

#endif

#endif //_TVG_WASM_DEFAULT_FONT_H_