<!--
    SPDX-FileCopyrightText: 2022-2026 TII (SSRC) and the Ghaf contributors
    SPDX-License-Identifier: CC-BY-SA-4.0
-->

## Description of Changes

<!--
Summary of the proposed changes in the PR description in your own words. For dependency updates, please link to the changelog.
-->

### Type of Change
- [ ] New Feature
- [ ] Bug Fix
- [ ] Improvement / Refactor

## Related Issues / Tickets

<!--
Link to GitHub issues or JIRA tickets (if any) that this PR addresses or is related to
-->

## Checklist

<!--
Please check [X] for all items that apply. Leave [ ] if an item does not apply, but you have considered it.
Note that none of these are strict requirements — they are intended to inform reviewers.
Completing this checklist shows that you value and respect their time and effort.
-->

- [ ] Clear summary in PR description
- [ ] Detailed and meaningful commit message(s)
- [ ] Commits are logically organized and squashed if appropriate
- [ ] [Contribution guidelines](https://github.com/tiiuae/ghaf/blob/main/CONTRIBUTING.md) followed
- [ ] Ghaf documentation updated with the commit - https://tiiuae.github.io/ghaf/
- [ ] Author has run `make-checks` and it passes
- [ ] All automatic GitHub Action checks pass - see [actions](https://github.com/tiiuae/ghaf/actions)
- [ ] Author has added reviewers and removed PR draft status

<!-- Additional description of omitted [ ] items if not obvious. -->

## Testing Instructions

### Applicable Targets
- [ ] Orin AGX `aarch64`
- [ ] Orin NX `aarch64`
- [ ] Lenovo X1 `x86_64`
- [ ] Dell Latitude `x86_64`
- [ ] System 76 `x86_64`

### Installation Method
- [ ] Requires full re-installation
- [ ] Can be updated with `nixos-rebuild ... switch`
- [ ] Other: 

### Test Steps To Verify:
<!--
Provide clear, simple step-by-step instructions to verify the functionality.
Please do not assume that readers know everything you currently know.
-->
1. ...
