export default [
	{
		"details": {
			"affected_kernel": "3.10.0-123.el7",
			"error_key": "KERNEL_CVE-2016-0728"
		},
		"id": 709784465,
		"rule_id": "CVE_2016_0728_kernel|KERNEL_CVE-2016-0728",
		"system_id": "f31b6265939d4a8492d3ce9655dc94be",
		"account_number": "540155",
		"uuid": "d195e3c5e5e6469781c4e59fa3f5ba87",
		"date": "2017-05-25T14:01:19.000Z",
		"rule": {
			"summary_html": "<p>A vulnerability in the Linux kernel allowing local privilege escalation was discovered. The issue was reported as <a href=\"https://access.redhat.com/security/cve/cve-2016-0728\">CVE-2016-0728</a>.</p>\n",
			"generic_html": "<p>A vulnerability in the Linux kernel rated <strong>Important</strong> was discovered. The use-after-free flaw relates to the way the Linux kernel&#39;s key management subsystem handles keyring object reference counting in certain error paths of the join_session_keyring() function. A local, unprivileged user could use this flaw to escalate their privileges on the system. The issue was reported as <a href=\"https://access.redhat.com/security/cve/cve-2016-0728\">CVE-2016-0728</a>.</p>\n<p>Red Hat recommends that you update the kernel and reboot the system. If you cannot reboot now, consider applying the <a href=\"https://bugzilla.redhat.com/attachment.cgi?id=1116284&amp;action=edit\">systemtap patch</a> to update your running kernel.</p>\n",
			"more_info_html": "<ul>\n<li>For more information about the flaws and versions of the package that are vulnerable see <a href=\"https://access.redhat.com/security/cve/cve-2016-0728\">CVE-2016-0728</a>.</li>\n<li>To learn how to upgrade packages, see &quot;<a href=\"https://access.redhat.com/solutions/9934\">What is yum and how do I use it?</a>&quot;</li>\n<li>The Customer Portal page for the <a href=\"https://access.redhat.com/security/\">Red Hat Security Team</a> contains more information about policies, procedures, and alerts for Red Hat Products.</li>\n<li>The Security Team also maintains a frequently updated blog at <a href=\"https://securityblog.redhat.com\">securityblog.redhat.com</a>.</li>\n</ul>\n",
			"severity": "WARN",
			"ansible": true,
			"ansible_fix": false,
			"ansible_mitigation": false,
			"rule_id": "CVE_2016_0728_kernel|KERNEL_CVE-2016-0728",
			"error_key": "KERNEL_CVE-2016-0728",
			"plugin": "CVE_2016_0728_kernel",
			"description": "Kernel key management subsystem vulnerable to local privilege escalation (CVE-2016-0728)",
			"summary": "A vulnerability in the Linux kernel allowing local privilege escalation was discovered. The issue was reported as [CVE-2016-0728](https://access.redhat.com/security/cve/cve-2016-0728).",
			"generic": "A vulnerability in the Linux kernel rated **Important** was discovered. The use-after-free flaw relates to the way the Linux kernel's key management subsystem handles keyring object reference counting in certain error paths of the join_session_keyring() function. A local, unprivileged user could use this flaw to escalate their privileges on the system. The issue was reported as [CVE-2016-0728](https://access.redhat.com/security/cve/cve-2016-0728).\n\nRed Hat recommends that you update the kernel and reboot the system. If you cannot reboot now, consider applying the [systemtap patch](https://bugzilla.redhat.com/attachment.cgi?id=1116284&action=edit) to update your running kernel.",
			"reason": "<p>A vulnerability in the Linux kernel rated <strong>Important</strong> was discovered. The use-after-free flaw relates to the way the Linux kernel&#39;s key management subsystem handles keyring object reference counting in certain error paths of the join_session_keyring() function. A local, unprivileged user could use this flaw to escalate their privileges on the system. The issue was reported as <a href=\"https://access.redhat.com/security/cve/cve-2016-0728\">CVE-2016-0728</a>.</p>\n<p>The host is vulnerable as it is running <strong>kernel-3.10.0-123.el7</strong>.</p>\n",
			"type": null,
			"more_info": "* For more information about the flaws and versions of the package that are vulnerable see [CVE-2016-0728](https://access.redhat.com/security/cve/cve-2016-0728).\n* To learn how to upgrade packages, see \"[What is yum and how do I use it?](https://access.redhat.com/solutions/9934)\"\n* The Customer Portal page for the [Red Hat Security Team](https://access.redhat.com/security/) contains more information about policies, procedures, and alerts for Red Hat Products.\n* The Security Team also maintains a frequently updated blog at [securityblog.redhat.com](https://securityblog.redhat.com).",
			"active": true,
			"node_id": "2130791",
			"category": "Security",
			"retired": false,
			"reboot_required": false,
			"publish_date": "2016-10-31T04:08:37.000Z",
			"rec_impact": 2,
			"rec_likelihood": 2,
			"resolution": "<p>Red Hat recommends that you update <code>kernel</code> and reboot. If you cannot reboot now, consider applying the <a href=\"https://bugzilla.redhat.com/attachment.cgi?id=1116284&amp;action=edit\">systemtap patch</a> to update your running kernel.</p>\n<pre><code># yum update kernel\n# reboot\n-or-\n# debuginfo-install kernel     (or equivalent)\n# stap -vgt -Gfix_p=1 -Gtrace_p=0 cve20160728e.stp\n</code></pre>"
		},
		"maintenance_actions": []
	}, {
		"details": {
			"processes_listening_int": [],
			"processes_listening_ext": [],
			"error_key": "OPENSSL_CVE_2016_0800_SPECIAL_DROWN",
			"processes_listening": [],
			"processes_names": [],
			"vulnerable_package": "openssl-libs-1.0.1e-34.el7"
		},
		"id": 709784475,
		"rule_id": "CVE_2016_0800_openssl_drown|OPENSSL_CVE_2016_0800_SPECIAL_DROWN",
		"system_id": "f31b6265939d4a8492d3ce9655dc94be",
		"account_number": "540155",
		"uuid": "d195e3c5e5e6469781c4e59fa3f5ba87",
		"date": "2017-05-25T14:01:19.000Z",
		"rule": {
			"summary_html": "<p>A new cross-protocol attack against SSLv2 protocol has been found. It has been assigned <a href=\"https://access.redhat.com/security/cve/CVE-2016-0800\">CVE-2016-0800</a> and is referred to as DROWN - Decrypting RSA using Obsolete and Weakened eNcryption. An attacker can decrypt passively collected TLS sessions between up-to-date client and server which supports SSLv2.</p>\n",
			"generic_html": "<p>A new cross-protocol attack against a vulnerability in the SSLv2 protocol has been found. It can be used to passively decrypt collected TLS/SSL sessions from any connection that used an RSA key exchange cypher suite on a server that supports SSLv2. Even if a given service does not support SSLv2 the connection is still vulnerable if another service does and shares the same RSA private key.</p>\n<p>A more efficient variant of the attack exists against unpatched OpenSSL servers using versions that predate security advisories released on March 19, 2015 (see <a href=\"https://access.redhat.com/security/cve/CVE-2015-0293\">CVE-2015-0293</a>).</p>\n",
			"more_info_html": "<ul>\n<li>For more information about the flaw see <a href=\"https://access.redhat.com/security/cve/CVE-2016-0800\">CVE-2016-0800</a></li>\n<li>To learn how to upgrade packages, see &quot;<a href=\"https://access.redhat.com/solutions/9934\">What is yum and how do I use it?</a>&quot;</li>\n<li>The Customer Portal page for the <a href=\"https://access.redhat.com/security/\">Red Hat Security Team</a> contains more information about policies, procedures, and alerts for Red Hat Products.</li>\n<li>The Security Team also maintains a frequently updated blog at <a href=\"https://securityblog.redhat.com\">securityblog.redhat.com</a>.</li>\n</ul>\n",
			"severity": "WARN",
			"ansible": true,
			"ansible_fix": false,
			"ansible_mitigation": false,
			"rule_id": "CVE_2016_0800_openssl_drown|OPENSSL_CVE_2016_0800_SPECIAL_DROWN",
			"error_key": "OPENSSL_CVE_2016_0800_SPECIAL_DROWN",
			"plugin": "CVE_2016_0800_openssl_drown",
			"description": "OpenSSL vulnerable to very efficient session decryption (CVE-2016-0800/Special DROWN)",
			"summary": "A new cross-protocol attack against SSLv2 protocol has been found. It has been assigned [CVE-2016-0800](https://access.redhat.com/security/cve/CVE-2016-0800) and is referred to as DROWN - Decrypting RSA using Obsolete and Weakened eNcryption. An attacker can decrypt passively collected TLS sessions between up-to-date client and server which supports SSLv2.",
			"generic": "A new cross-protocol attack against a vulnerability in the SSLv2 protocol has been found. It can be used to passively decrypt collected TLS/SSL sessions from any connection that used an RSA key exchange cypher suite on a server that supports SSLv2. Even if a given service does not support SSLv2 the connection is still vulnerable if another service does and shares the same RSA private key.\n\nA more efficient variant of the attack exists against unpatched OpenSSL servers using versions that predate security advisories released on March 19, 2015 (see [CVE-2015-0293](https://access.redhat.com/security/cve/CVE-2015-0293)).",
			"reason": "<p>This host is vulnerable because it has vulnerable package <strong>openssl-libs-1.0.1e-34.el7</strong> installed.</p>\n<p>This package does not have a patch for <a href=\"https://access.redhat.com/security/cve/CVE-2015-0293\">CVE-2015-0293</a> applied, which makes the system especially vulnerable. This is known as <strong>Special DROWN</strong>. An attacker can use this flaw to perform active man-in-the-middle (MITM) attacks and impersonate a TLS server to connecting TLS client in a matter of minutes. </p>\n<p>Fortunately, it does not seem to run any processes that use OpenSSL libraries.</p>\n<p>A new cross-protocol attack against a vulnerability in the SSLv2 protocol has been found. It can be used to passively decrypt collected TLS/SSL sessions from any connection that used an RSA key exchange cypher suite on a server that supports SSLv2. Even if a given service does not support SSLv2 the connection is still vulnerable if another service does and shares the same RSA private key.</p>\n<p>A more efficient variant of the attack exists against unpatched OpenSSL servers using versions that predate security advisories released on March 19, 2015 (see <a href=\"https://access.redhat.com/security/cve/CVE-2015-0293\">CVE-2015-0293</a>).</p>\n",
			"type": null,
			"more_info": "* For more information about the flaw see [CVE-2016-0800](https://access.redhat.com/security/cve/CVE-2016-0800)\n* To learn how to upgrade packages, see \"[What is yum and how do I use it?](https://access.redhat.com/solutions/9934)\"\n* The Customer Portal page for the [Red Hat Security Team](https://access.redhat.com/security/) contains more information about policies, procedures, and alerts for Red Hat Products.\n* The Security Team also maintains a frequently updated blog at [securityblog.redhat.com](https://securityblog.redhat.com).",
			"active": true,
			"node_id": "2174451",
			"category": "Security",
			"retired": false,
			"reboot_required": false,
			"publish_date": "2016-10-31T04:08:32.000Z",
			"rec_impact": 3,
			"rec_likelihood": 2,
			"resolution": "<p>Red Hat recommends that you update <code>openssl</code> and restart the affected system:</p>\n<pre><code># yum update openssl\n# reboot\n</code></pre><p>Alternatively, you can restart all affected services (that is, the ones linked to the openssl library), especially those listening on public IP addresses.</p>\n"
		},
		"maintenance_actions": []
	}, {
		"details": {
			"vulnerable_kernel": "3.10.0-123.el7",
			"package_name": "kernel",
			"error_key": "KERNEL_CVE_2016_5195"
		},
		"id": 709784485,
		"rule_id": "CVE_2016_5195_kernel|KERNEL_CVE_2016_5195",
		"system_id": "f31b6265939d4a8492d3ce9655dc94be",
		"account_number": "540155",
		"uuid": "d195e3c5e5e6469781c4e59fa3f5ba87",
		"date": "2017-05-25T14:01:19.000Z",
		"rule": {
			"summary_html": "<p>A flaw was found in the Linux kernel&#39;s memory subsystem. An unprivileged local user could use this flaw to write to files they would normally only have read-only access to and thus increase their privileges on the system.</p>\n",
			"generic_html": "<p>A race condition was found in the way Linux kernel&#39;s memory subsystem handled breakage of the the read only shared mappings COW situation on write access. An unprivileged local user could use this flaw to write to files they should normally have read-only access to, and thus increase their privileges on the system.</p>\n<p>A process that is able to mmap a file is able to race Copy on Write (COW) page creation (within get_user_pages) with madvise(MADV_DONTNEED) kernel system calls. This would allow modified pages to bypass the page protection mechanism and modify the mapped file.  The vulnerability could be abused by allowing an attacker to modify existing setuid files with instructions to elevate permissions.  This attack has been found in the wild. </p>\n<p>Red Hat recommends that you update the kernel package or apply mitigations.</p>\n",
			"more_info_html": "<ul>\n<li>For more information about the flaw see <a href=\"https://access.redhat.com/security/cve/CVE-2016-5195\">CVE-2016-5195</a></li>\n<li>To learn how to upgrade packages, see &quot;<a href=\"https://access.redhat.com/solutions/9934\">What is yum and how do I use it?</a>&quot;</li>\n<li>The Customer Portal page for the <a href=\"https://access.redhat.com/security/\">Red Hat Security Team</a> contains more information about policies, procedures, and alerts for Red Hat Products.</li>\n<li>The Security Team also maintains a frequently updated blog at <a href=\"https://securityblog.redhat.com\">securityblog.redhat.com</a>.</li>\n</ul>\n",
			"severity": "WARN",
			"ansible": true,
			"ansible_fix": false,
			"ansible_mitigation": false,
			"rule_id": "CVE_2016_5195_kernel|KERNEL_CVE_2016_5195",
			"error_key": "KERNEL_CVE_2016_5195",
			"plugin": "CVE_2016_5195_kernel",
			"description": "Kernel vulnerable to privilege escalation via permission bypass (CVE-2016-5195)",
			"summary": "A flaw was found in the Linux kernel's memory subsystem. An unprivileged local user could use this flaw to write to files they would normally only have read-only access to and thus increase their privileges on the system.",
			"generic": "A race condition was found in the way Linux kernel's memory subsystem handled breakage of the the read only shared mappings COW situation on write access. An unprivileged local user could use this flaw to write to files they should normally have read-only access to, and thus increase their privileges on the system.\n\nA process that is able to mmap a file is able to race Copy on Write (COW) page creation (within get_user_pages) with madvise(MADV_DONTNEED) kernel system calls. This would allow modified pages to bypass the page protection mechanism and modify the mapped file.  The vulnerability could be abused by allowing an attacker to modify existing setuid files with instructions to elevate permissions.  This attack has been found in the wild. \n\nRed Hat recommends that you update the kernel package or apply mitigations.",
			"reason": "<p>A flaw was found in the Linux kernel&#39;s memory subsystem. An unprivileged local user could use this flaw to write to files they would normally have read-only access to and thus increase their privileges on the system.</p>\n<p>This host is affected because it is running kernel <strong>3.10.0-123.el7</strong>. </p>\n<p>There is currently no mitigation applied and your system is vulnerable.</p>\n",
			"type": null,
			"more_info": "* For more information about the flaw see [CVE-2016-5195](https://access.redhat.com/security/cve/CVE-2016-5195)\n* To learn how to upgrade packages, see \"[What is yum and how do I use it?](https://access.redhat.com/solutions/9934)\"\n* The Customer Portal page for the [Red Hat Security Team](https://access.redhat.com/security/) contains more information about policies, procedures, and alerts for Red Hat Products.\n* The Security Team also maintains a frequently updated blog at [securityblog.redhat.com](https://securityblog.redhat.com).",
			"active": true,
			"node_id": "2706661",
			"category": "Security",
			"retired": false,
			"reboot_required": false,
			"publish_date": "2016-10-31T04:08:33.000Z",
			"rec_impact": 2,
			"rec_likelihood": 2,
			"resolution": "<p>Red Hat recommends that you update the <code>kernel</code> package and restart the system:</p>\n<pre><code># yum update kernel\n# reboot\n</code></pre><p><strong>or</strong></p>\n<p>Alternatively, this issue can be addressed by applying mitigations until the machine is restarted with the updated kernel package.</p>\n<p>Please refer to the Resolve Tab in <a href=\"https://access.redhat.com/security/vulnerabilities/2706661\">the vulnerability article</a> for information about the mitigation and the latest information.</p>\n"
		},
		"maintenance_actions": [{
			"done": false,
			"id": 29885,
			"maintenance_plan": {
				"maintenance_id": 12195,
				"name": null,
				"description": null,
				"start": null,
				"end": null,
				"created_by": "rhn-support-jnewton",
				"silenced": false,
				"hidden": true,
				"suggestion": "proposed",
				"remote_branch": null
			}
		}]
	}, {
		"details": {
			"package": "bash-4.2.45-5.el7",
			"error_key": "VULNERABLE_BASH_DETECTED"
		},
		"id": 709784505,
		"rule_id": "bash_injection|VULNERABLE_BASH_DETECTED",
		"system_id": "f31b6265939d4a8492d3ce9655dc94be",
		"account_number": "540155",
		"uuid": "d195e3c5e5e6469781c4e59fa3f5ba87",
		"date": "2017-05-25T14:01:19.000Z",
		"rule": {
			"summary_html": "<p>In September 2014, an exploitable bug known as Shellshock was discovered in commonly shipped versions of the bash shell.</p>\n",
			"generic_html": "<p>Hosts running earlier versions of <code>bash</code> are affected by the code injection vulnerability known as <strong>Shellshock</strong>.</p>\n",
			"more_info_html": "<p>For further information about this <strong>critical</strong> vulnerability, see:</p>\n<ul>\n<li><a href=\"https://access.redhat.com/articles/1200223\">Bash Code Injection Vulnerability via Specially Crafted Environment Variables (CVE-2014-6271, CVE-2014-7169)</a></li>\n<li><a href=\"https://access.redhat.com/security/cve/CVE-2014-6271\">CVE-2014-6271</a></li>\n<li><a href=\"https://access.redhat.com/security/cve/CVE-2014-7169\">CVE-2014-7169</a></li>\n</ul>\n",
			"severity": "WARN",
			"ansible": true,
			"ansible_fix": true,
			"ansible_mitigation": false,
			"rule_id": "bash_injection|VULNERABLE_BASH_DETECTED",
			"error_key": "VULNERABLE_BASH_DETECTED",
			"plugin": "bash_injection",
			"description": "Bash locally vulnerable via environment variables (CVE-2014-6271, CVE-2014-7169/Shellshock)",
			"summary": "In September 2014, an exploitable bug known as Shellshock was discovered in commonly shipped versions of the bash shell.",
			"generic": "Hosts running earlier versions of `bash` are affected by the code injection vulnerability known as **Shellshock**.",
			"reason": "<p>This host is running a version of <code>bash</code> that is affected by the code injection vulnerability known as <strong>Shellshock</strong>.</p>\n<p>The package affected is <strong>bash-4.2.45-5.el7</strong>.</p>\n",
			"type": null,
			"more_info": "For further information about this **critical** vulnerability, see:\n* [Bash Code Injection Vulnerability via Specially Crafted Environment Variables (CVE-2014-6271, CVE-2014-7169)](https://access.redhat.com/articles/1200223)\n* [CVE-2014-6271](https://access.redhat.com/security/cve/CVE-2014-6271)\n* [CVE-2014-7169](https://access.redhat.com/security/cve/CVE-2014-7169)",
			"active": true,
			"node_id": "1200223",
			"category": "Security",
			"retired": false,
			"reboot_required": false,
			"publish_date": "2016-10-31T04:08:36.000Z",
			"rec_impact": 2,
			"rec_likelihood": 2,
			"resolution": "<p>Red Hat recommends that you upgrade <code>bash</code> immediately:</p>\n<pre><code># yum update bash\n</code></pre>"
		},
		"maintenance_actions": []
	}, {
		"details": {
			"filesystems": [{
				"usage": "99",
				"mountpoint": "/"
			}, {
				"usage": "99",
				"mountpoint": "/"
			}],
			"error_key": "FILESYSTEM_CAPACITY"
		},
		"id": 709784535,
		"rule_id": "filesystem_capacity|FILESYSTEM_CAPACITY",
		"system_id": "f31b6265939d4a8492d3ce9655dc94be",
		"account_number": "540155",
		"uuid": "d195e3c5e5e6469781c4e59fa3f5ba87",
		"date": "2017-05-25T14:01:19.000Z",
		"rule": {
			"summary_html": "<p>File systems nearing full capacity can cause performance issues because blocks must be used from different block groups. \nBesides, file systems at or exceeding capacity will have stability issues because applications will no longer be able to write to the file system.</p>\n",
			"generic_html": "<p>File systems nearing full capacity can cause performance issues because blocks must be used from different block groups. \nBesides, file systems at or exceeding capacity will have stability issues because applications will no longer be able to write to the file system.</p>\n",
			"more_info_html": "<p><a href=\"https://access.redhat.com/solutions/21820\">How to increase the filesystem size?</a>\n<a href=\"https://access.redhat.com/solutions/1154683\">How do I find out what is using disk space?</a></p>\n",
			"severity": "WARN",
			"ansible": false,
			"ansible_fix": false,
			"ansible_mitigation": false,
			"rule_id": "filesystem_capacity|FILESYSTEM_CAPACITY",
			"error_key": "FILESYSTEM_CAPACITY",
			"plugin": "filesystem_capacity",
			"description": "Decreased stability and/or performance due to filesystem over 95% capacity",
			"summary": "File systems nearing full capacity can cause performance issues because blocks must be used from different block groups. \nBesides, file systems at or exceeding capacity will have stability issues because applications will no longer be able to write to the file system.\n",
			"generic": "File systems nearing full capacity can cause performance issues because blocks must be used from different block groups. \nBesides, file systems at or exceeding capacity will have stability issues because applications will no longer be able to write to the file system.\n",
			"reason": "<p>This host has the following file systems nearing or at capacity:</p>\n<ul>\n\n<li><strong>Filesystem:</strong> / <strong>Usage:</strong> 99%</li>\n\n<li><strong>Filesystem:</strong> / <strong>Usage:</strong> 99%</li>\n\n</ul>",
			"type": null,
			"more_info": "[How to increase the filesystem size?](https://access.redhat.com/solutions/21820)\n[How do I find out what is using disk space?](https://access.redhat.com/solutions/1154683)\n",
			"active": true,
			"node_id": "1154683",
			"category": "Stability",
			"retired": false,
			"reboot_required": false,
			"publish_date": "2016-10-31T04:08:36.000Z",
			"rec_impact": 2,
			"rec_likelihood": 3,
			"resolution": "<p>To solve the issue, Red Hat recommends that you either add more storage capacity to the identified file systems, or remove unnecessary files to reduce the current usage.\nPlease refer to more_information part for more detailed steps.</p>\n"
		},
		"maintenance_actions": []
	}, {
		"details": {
			"msg": "[    0.000000] crashkernel=auto resulted in zero bytes of reserved memory.",
			"auto_with_low_ram": true,
			"rhel_ver": 7,
			"error_key": "CRASHKERNEL_RESERVATION_FAILED"
		},
		"id": 709784555,
		"rule_id": "crashkernel_reservation_failed|CRASHKERNEL_RESERVATION_FAILED",
		"system_id": "f31b6265939d4a8492d3ce9655dc94be",
		"account_number": "540155",
		"uuid": "d195e3c5e5e6469781c4e59fa3f5ba87",
		"date": "2017-05-25T14:01:19.000Z",
		"rule": {
			"summary_html": "<p>The crashkernel configuration has failed to produce a working kdump environment. Configuration changes must be made to enable vmcore capture.</p>\n",
			"generic_html": "<p>Kdump is unable to reserve memory for the kdump kernel. The kdump service has not started and a vmcore will not be captured if the host crashes, which will make it difficult for our support technicians to determine why the machine crashed.</p>\n",
			"more_info_html": "",
			"severity": "WARN",
			"ansible": false,
			"ansible_fix": false,
			"ansible_mitigation": false,
			"rule_id": "crashkernel_reservation_failed|CRASHKERNEL_RESERVATION_FAILED",
			"error_key": "CRASHKERNEL_RESERVATION_FAILED",
			"plugin": "crashkernel_reservation_failed",
			"description": "Kdump crashkernel reservation failed due to improper configuration of crashkernel parameter",
			"summary": "The crashkernel configuration has failed to produce a working kdump environment. Configuration changes must be made to enable vmcore capture.\n",
			"generic": "Kdump is unable to reserve memory for the kdump kernel. The kdump service has not started and a vmcore will not be captured if the host crashes, which will make it difficult for our support technicians to determine why the machine crashed.",
			"reason": "<p>This host is unable to reserve memory for the kdump kernel:</p>\n<pre><code>[    0.000000] crashkernel=auto resulted in zero bytes of reserved memory.\n</code></pre><p>This means the kdump service has not started and a vmcore will not be captured if the host crashes, which will make it difficult for our support technicians to determine why the machine crashed.</p>\n",
			"type": null,
			"more_info": null,
			"active": true,
			"node_id": "59432",
			"category": "Stability",
			"retired": false,
			"reboot_required": false,
			"publish_date": "2016-10-31T04:08:33.000Z",
			"rec_impact": 1,
			"rec_likelihood": 3,
			"resolution": "<p>To fix this issue, Red Hat recommends that you change the <strong>crashkernel</strong> setting in the <em>grub.conf</em> file.</p>\n<p>This host failed to reserved memory with <strong>auto</strong> crashkernel parameter due to low physical memory. The memory must be reserved by explicitly requesting the reservation size, for example: crashkernel=128M.</p>\n<p>For details of <code>crashkernel</code> setting, please refer to the Knowledge article <a href=\"https://access.redhat.com/solutions/916043\">How should the crashkernel parameter be configured for using kdump on RHEL7? </a> to pickup the setting specifically for your host.</p>\n"
		},
		"maintenance_actions": []
	}, {
		"details": {
			"selinux_info": true,
			"package_name": "kernel",
			"selinux_enforcing": true,
			"selinux_can_help": true,
			"minimal_selinux_policy": "selinux-policy-3.13.1-81.el7",
			"selinux_enabled": true,
			"vulnerable_kernel": "3.10.0-123.el7",
			"active_policy": "selinux-policy-3.12.1-153.el7",
			"dccp_loading_disabled": null,
			"error_key": "KERNEL_CVE_2017_6074",
			"enough_policy": false,
			"dccp_loaded": null,
			"mitigation_info": false
		},
		"id": 709784575,
		"rule_id": "CVE_2017_6074_kernel|KERNEL_CVE_2017_6074",
		"system_id": "f31b6265939d4a8492d3ce9655dc94be",
		"account_number": "540155",
		"uuid": "d195e3c5e5e6469781c4e59fa3f5ba87",
		"date": "2017-05-25T14:01:19.000Z",
		"rule": {
			"summary_html": "<p>A use-after-free flaw was found in the Linux kernel IPv6 DCCP network protocol code. It has been assigned <a href=\"https://access.redhat.com/security/cve/CVE-2017-6074\">CVE-2017-6074</a>. An unprivileged local user could use this flaw to execute arbitrary code in kernel memory and increase their privileges on the system.</p>\n",
			"generic_html": "<p>A use-after-free flaw was found in the Linux kernel IPv6 DCCP network protocol code. It has been assigned CVE-2017-6074. </p>\n<p>An unprivileged local user could use this flaw to execute arbitrary code in kernel memory and increase their privileges on the system. A local user could initiate a DCCP network connection on any local system network interface and then create specially-crafted memory allocations containing malicious instructions that can then either cause a crash or potentially escalate the user&#39;s privileges.</p>\n<p>An attacker must have access to a local account on the system; this is not a remote attack and it requires IPv6 support to be enabled on the system.</p>\n<p>Red Hat recommends that you update the kernel when possible. Otherwise, you can use proposed mitigation to disable DCCP. SELinux in enforcing mode can also mitigate the issue under specific circumstances.</p>\n",
			"more_info_html": "<ul>\n<li>For more information about the flaw, see <a href=\"https://access.redhat.com/security/cve/CVE-2017-6074\">CVE-2017-6074</a>.</li>\n<li>To learn how to upgrade packages, see <a href=\"https://access.redhat.com/solutions/9934\">What is yum and how do I use it?</a>.</li>\n<li>For more information about SELinux, see <a href=\"https://access.redhat.com/documentation/en-US/Red_Hat_Enterprise_Linux/7/html/SELinux_Users_and_Administrators_Guide/chap-Security-Enhanced_Linux-Introduction.html#sect-Security-Enhanced_Linux-Introduction-Benefits_of_running_SELinux\">Benefits of running SELinux</a>.</li>\n<li>The Customer Portal page for the <a href=\"https://access.redhat.com/security/\">Red Hat Security Team</a> contains more information about policies, procedures, and alerts for Red Hat products.</li>\n<li>The Security Team also maintains a frequently updated blog at <a href=\"https://securityblog.redhat.com\">securityblog.redhat.com</a>.</li>\n</ul>\n",
			"severity": "WARN",
			"ansible": true,
			"ansible_fix": false,
			"ansible_mitigation": false,
			"rule_id": "CVE_2017_6074_kernel|KERNEL_CVE_2017_6074",
			"error_key": "KERNEL_CVE_2017_6074",
			"plugin": "CVE_2017_6074_kernel",
			"description": "Kernel vulnerable to local privilege escalation via DCCP module (CVE-2017-6074)",
			"summary": "A use-after-free flaw was found in the Linux kernel IPv6 DCCP network protocol code. It has been assigned [CVE-2017-6074](https://access.redhat.com/security/cve/CVE-2017-6074). An unprivileged local user could use this flaw to execute arbitrary code in kernel memory and increase their privileges on the system.\n",
			"generic": "A use-after-free flaw was found in the Linux kernel IPv6 DCCP network protocol code. It has been assigned CVE-2017-6074. \n\nAn unprivileged local user could use this flaw to execute arbitrary code in kernel memory and increase their privileges on the system. A local user could initiate a DCCP network connection on any local system network interface and then create specially-crafted memory allocations containing malicious instructions that can then either cause a crash or potentially escalate the user's privileges.\n\nAn attacker must have access to a local account on the system; this is not a remote attack and it requires IPv6 support to be enabled on the system.\n\nRed Hat recommends that you update the kernel when possible. Otherwise, you can use proposed mitigation to disable DCCP. SELinux in enforcing mode can also mitigate the issue under specific circumstances.\n",
			"reason": "<p>A use-after-free flaw was found within the Linux kernel IPv6 DCCP network protocol code.</p>\n<p>This host is affected because:</p>\n<ul><li> It is running kernel <strong>3.10.0-123.el7</strong>.</li><li> SELinux policy is outdated.</li></ul>\n\n\n\n\n\n\n<p>Your installed SELinux policy is <strong>selinux-policy-3.12.1-153.el7</strong>; however, to mitigate the issue, the earliest required version is <strong>selinux-policy-3.13.1-81.el7</strong>.</p>\n",
			"type": null,
			"more_info": "* For more information about the flaw, see [CVE-2017-6074](https://access.redhat.com/security/cve/CVE-2017-6074).\n* To learn how to upgrade packages, see [What is yum and how do I use it?](https://access.redhat.com/solutions/9934).\n* For more information about SELinux, see [Benefits of running SELinux](https://access.redhat.com/documentation/en-US/Red_Hat_Enterprise_Linux/7/html/SELinux_Users_and_Administrators_Guide/chap-Security-Enhanced_Linux-Introduction.html#sect-Security-Enhanced_Linux-Introduction-Benefits_of_running_SELinux).\n* The Customer Portal page for the [Red Hat Security Team](https://access.redhat.com/security/) contains more information about policies, procedures, and alerts for Red Hat products.\n* The Security Team also maintains a frequently updated blog at [securityblog.redhat.com](https://securityblog.redhat.com).\n",
			"active": true,
			"node_id": null,
			"category": "Security",
			"retired": false,
			"reboot_required": false,
			"publish_date": null,
			"rec_impact": 2,
			"rec_likelihood": 2,
			"resolution": "<p>Red Hat recommends updating the <code>kernel</code> package and rebooting the system.</p>\n<pre><code># yum update kernel\n# reboot\n</code></pre><p><strong>Alternatively</strong>, apply one of the following mitigations:</p>\n<h5 id=\"update-selinux-policy\">Update SELinux policy</h5>\n<p>Update your SELinux policy:</p>\n<pre><code># yum update selinux-policy\n</code></pre><p>The system does not provide enough information for Insights about loaded kernel modules. It is not possible to recommend a mitigation based on kernel modules.</p>\n"
		},
		"maintenance_actions": []
	}, {
		"details": {
			"mod_loading_disabled": null,
			"package_name": "kernel",
			"error_key": "KERNEL_CVE_2017_2636",
			"vulnerable_kernel": "3.10.0-123.el7",
			"mod_loaded": null,
			"mitigation_info": false
		},
		"id": 766342165,
		"rule_id": "CVE_2017_2636_kernel|KERNEL_CVE_2017_2636",
		"system_id": "f31b6265939d4a8492d3ce9655dc94be",
		"account_number": "540155",
		"uuid": "d195e3c5e5e6469781c4e59fa3f5ba87",
		"date": "2017-05-25T14:01:19.000Z",
		"rule": {
			"summary_html": "<p>A vulnerability in the Linux kernel allowing local privilege escalation was discovered.\nThe issue was reported as <a href=\"https://access.redhat.com/security/cve/CVE-2017-2636\">CVE-2017-2636</a>.</p>\n",
			"generic_html": "<p>A use-after-free flaw was found in the Linux kernel implementation of the HDLC (High-Level Data Link Control) TTY line discipline implementation. It has been assigned CVE-2017-2636.</p>\n<p>An unprivileged local user could use this flaw to execute arbitrary code in kernel memory and increase their privileges on the system. The kernel uses a TTY subsystem to take and show terminal output to connected systems. An attacker crafting specific-sized memory allocations could abuse this mechanism to place a kernel function pointer with malicious instructions to be executed on behalf of the attacker.</p>\n<p>An attacker must have access to a local account on the system; this is not a remote attack. Exploiting this flaw does not require Microgate or SyncLink hardware to be in use.</p>\n<p>Red Hat recommends that you use the proposed mitigation to disable the N_HDLC module.</p>\n",
			"more_info_html": "<ul>\n<li>For more information about the flaw, see <a href=\"https://access.redhat.com/security/cve/CVE-2017-2636\">CVE-2017-2636</a> and <a href=\"https://access.redhat.com/security/vulnerabilities/CVE-2017-2636\">CVE-2017-2636 article</a>.</li>\n<li>The Customer Portal page for the <a href=\"https://access.redhat.com/security/\">Red Hat Security Team</a> contains more information about policies, procedures, and alerts for Red Hat products.</li>\n<li>The Security Team also maintains a frequently updated blog at <a href=\"https://securityblog.redhat.com\">securityblog.redhat.com</a>.</li>\n</ul>\n",
			"severity": "WARN",
			"ansible": true,
			"ansible_fix": false,
			"ansible_mitigation": false,
			"rule_id": "CVE_2017_2636_kernel|KERNEL_CVE_2017_2636",
			"error_key": "KERNEL_CVE_2017_2636",
			"plugin": "CVE_2017_2636_kernel",
			"description": "Kernel vulnerable to local privilege escalation via n_hdlc module (CVE-2017-2636)",
			"summary": "A vulnerability in the Linux kernel allowing local privilege escalation was discovered.\nThe issue was reported as [CVE-2017-2636](https://access.redhat.com/security/cve/CVE-2017-2636).\n",
			"generic": "A use-after-free flaw was found in the Linux kernel implementation of the HDLC (High-Level Data Link Control) TTY line discipline implementation. It has been assigned CVE-2017-2636.\n\nAn unprivileged local user could use this flaw to execute arbitrary code in kernel memory and increase their privileges on the system. The kernel uses a TTY subsystem to take and show terminal output to connected systems. An attacker crafting specific-sized memory allocations could abuse this mechanism to place a kernel function pointer with malicious instructions to be executed on behalf of the attacker.\n\nAn attacker must have access to a local account on the system; this is not a remote attack. Exploiting this flaw does not require Microgate or SyncLink hardware to be in use.\n\nRed Hat recommends that you use the proposed mitigation to disable the N_HDLC module.\n",
			"reason": "<p>A use-after-free flaw was found in the Linux kernel implementation of the HDLC (High-Level Data Link Control) TTY line discipline implementation.</p>\n<p>This host is affected because it is running kernel <strong>3.10.0-123.el7</strong>.</p>\n",
			"type": null,
			"more_info": "* For more information about the flaw, see [CVE-2017-2636](https://access.redhat.com/security/cve/CVE-2017-2636) and [CVE-2017-2636 article](https://access.redhat.com/security/vulnerabilities/CVE-2017-2636).\n* The Customer Portal page for the [Red Hat Security Team](https://access.redhat.com/security/) contains more information about policies, procedures, and alerts for Red Hat products.\n* The Security Team also maintains a frequently updated blog at [securityblog.redhat.com](https://securityblog.redhat.com).\n",
			"active": true,
			"node_id": null,
			"category": "Security",
			"retired": false,
			"reboot_required": false,
			"publish_date": null,
			"rec_impact": 2,
			"rec_likelihood": 2,
			"resolution": "<p>Red Hat recommends updating the <code>kernel</code> package and rebooting the system.</p>\n<pre><code># yum update kernel\n# reboot\n</code></pre>"
		},
		"maintenance_actions": [{
			"done": false,
			"id": 58335,
			"maintenance_plan": {
				"maintenance_id": 16545,
				"name": "Insights Summit 2017 - n_HDLC",
				"description": "",
				"start": "2017-05-06T02:00:00.000Z",
				"end": "2017-05-06T03:00:00.000Z",
				"created_by": "rhn-support-wnix",
				"silenced": false,
				"hidden": false,
				"suggestion": null,
				"remote_branch": null
			}
		}, {
			"done": false,
			"id": 61895,
			"maintenance_plan": {
				"maintenance_id": 16835,
				"name": "Summit 2017 N_HDLC",
				"description": "",
				"start": null,
				"end": null,
				"created_by": "rhn-support-wnix",
				"silenced": false,
				"hidden": false,
				"suggestion": null,
				"remote_branch": null
			}
		}, {
			"done": false,
			"id": 66225,
			"maintenance_plan": {
				"maintenance_id": 19445,
				"name": "Seattle's Best Plan",
				"description": null,
				"start": null,
				"end": null,
				"created_by": "rhn-support-wnix",
				"silenced": false,
				"hidden": false,
				"suggestion": null,
				"remote_branch": null
			}
		}, {
			"done": false,
			"id": 71075,
			"maintenance_plan": {
				"maintenance_id": 19845,
				"name": "Optum N_HDLC FIX",
				"description": null,
				"start": null,
				"end": null,
				"created_by": "rhn-support-wnix",
				"silenced": false,
				"hidden": false,
				"suggestion": null,
				"remote_branch": null
			}
		}]
	}
]
