export default [
	{
		"details": {
			"vulnerable_setting": "hosts:      files dns",
			"affected_package": "glibc-2.17-55.el7",
			"error_key": "GLIBC_CVE_2015_7547"
		},
		"id": 709784455,
		"rule_id": "CVE_2015_7547_glibc|GLIBC_CVE_2015_7547",
		"system_id": "f31b6265939d4a8492d3ce9655dc94be",
		"account_number": "540155",
		"uuid": "d195e3c5e5e6469781c4e59fa3f5ba87",
		"date": "2017-05-25T14:01:19.000Z",
		"rule": {
			"summary_html": "<p>A critical security flaw in the <code>glibc</code> library was found. It allows an attacker to crash an application built against that library or, potentially, execute arbitrary code with privileges of the user running the application.</p>\n",
			"generic_html": "<p>The <code>glibc</code> library is vulnerable to a stack-based buffer overflow security flaw. A remote attacker could create specially crafted DNS responses that could cause the <code>libresolv</code> part of the library, which performs dual A/AAAA DNS queries, to crash or potentially execute code with the permissions of the user running the library. The issue is only exposed when <code>libresolv</code> is called from the nss_dns NSS service module. This flaw is known as <a href=\"https://access.redhat.com/security/cve/CVE-2015-7547\">CVE-2015-7547</a>.</p>\n",
			"more_info_html": "<ul>\n<li>For more information about the flaw see <a href=\"https://access.redhat.com/security/cve/CVE-2015-7547\">CVE-2015-7547</a>.</li>\n<li>To learn how to upgrade packages, see &quot;<a href=\"https://access.redhat.com/solutions/9934\">What is yum and how do I use it?</a>&quot;</li>\n<li>The Customer Portal page for the <a href=\"https://access.redhat.com/security/\">Red Hat Security Team</a> contains more information about policies, procedures, and alerts for Red Hat Products.</li>\n<li>The Security Team also maintains a frequently updated blog at <a href=\"https://securityblog.redhat.com\">securityblog.redhat.com</a>.</li>\n</ul>\n",
			"severity": "ERROR",
			"ansible": true,
			"ansible_fix": false,
			"ansible_mitigation": false,
			"rule_id": "CVE_2015_7547_glibc|GLIBC_CVE_2015_7547",
			"error_key": "GLIBC_CVE_2015_7547",
			"plugin": "CVE_2015_7547_glibc",
			"description": "Remote code execution vulnerability in libresolv via crafted DNS response (CVE-2015-7547)",
			"summary": "A critical security flaw in the `glibc` library was found. It allows an attacker to crash an application built against that library or, potentially, execute arbitrary code with privileges of the user running the application.",
			"generic": "The `glibc` library is vulnerable to a stack-based buffer overflow security flaw. A remote attacker could create specially crafted DNS responses that could cause the `libresolv` part of the library, which performs dual A/AAAA DNS queries, to crash or potentially execute code with the permissions of the user running the library. The issue is only exposed when `libresolv` is called from the nss_dns NSS service module. This flaw is known as [CVE-2015-7547](https://access.redhat.com/security/cve/CVE-2015-7547).",
			"reason": "<p>This host is vulnerable because it has vulnerable package <strong>glibc-2.17-55.el7</strong> installed and DNS is enabled in <code>/etc/nsswitch.conf</code>:</p>\n<pre><code>hosts:      files dns\n</code></pre><p>The <code>glibc</code> library is vulnerable to a stack-based buffer overflow security flaw. A remote attacker could create specially crafted DNS responses that could cause the <code>libresolv</code> part of the library, which performs dual A/AAAA DNS queries, to crash or potentially execute code with the permissions of the user running the library. The issue is only exposed when <code>libresolv</code> is called from the nss_dns NSS service module. This flaw is known as <a href=\"https://access.redhat.com/security/cve/CVE-2015-7547\">CVE-2015-7547</a>.</p>\n",
			"type": null,
			"more_info": "* For more information about the flaw see [CVE-2015-7547](https://access.redhat.com/security/cve/CVE-2015-7547).\n* To learn how to upgrade packages, see \"[What is yum and how do I use it?](https://access.redhat.com/solutions/9934)\"\n* The Customer Portal page for the [Red Hat Security Team](https://access.redhat.com/security/) contains more information about policies, procedures, and alerts for Red Hat Products.\n* The Security Team also maintains a frequently updated blog at [securityblog.redhat.com](https://securityblog.redhat.com).",
			"active": true,
			"node_id": "2168451",
			"category": "Security",
			"retired": false,
			"reboot_required": false,
			"publish_date": "2016-10-31T04:08:35.000Z",
			"rec_impact": 4,
			"rec_likelihood": 2,
			"resolution": "<p>Red Hat recommends updating <code>glibc</code> and restarting the affected system:</p>\n<pre><code># yum update glibc\n# reboot\n</code></pre><p>Alternatively, you can restart all affected services, but because this vulnerability affects a large amount of applications on the system, the best solution is to restart the system.</p>\n"
		},
		"maintenance_actions": []
	}, {
		"details": {
			"affected_kernel": "3.10.0-123.el7",
			"error_key": "KERNEL_CVE-2016-0728"
		},
		"id": 709784465,
		"rule_id": "CVE_2016_0728_kernel|KERNEL_CVE-2016-0728",
		"system_id": "f31b6265939d4a8492d3ce9655dc94be",
		"account_number": "540155",
		"uuid": "d195e3c5e5e6469781c4e59fa3f5ba87",
		"date": "2017-05-25T14:01:19.000Z",
		"rule": {
			"summary_html": "<p>A vulnerability in the Linux kernel allowing local privilege escalation was discovered. The issue was reported as <a href=\"https://access.redhat.com/security/cve/cve-2016-0728\">CVE-2016-0728</a>.</p>\n",
			"generic_html": "<p>A vulnerability in the Linux kernel rated <strong>Important</strong> was discovered. The use-after-free flaw relates to the way the Linux kernel&#39;s key management subsystem handles keyring object reference counting in certain error paths of the join_session_keyring() function. A local, unprivileged user could use this flaw to escalate their privileges on the system. The issue was reported as <a href=\"https://access.redhat.com/security/cve/cve-2016-0728\">CVE-2016-0728</a>.</p>\n<p>Red Hat recommends that you update the kernel and reboot the system. If you cannot reboot now, consider applying the <a href=\"https://bugzilla.redhat.com/attachment.cgi?id=1116284&amp;action=edit\">systemtap patch</a> to update your running kernel.</p>\n",
			"more_info_html": "<ul>\n<li>For more information about the flaws and versions of the package that are vulnerable see <a href=\"https://access.redhat.com/security/cve/cve-2016-0728\">CVE-2016-0728</a>.</li>\n<li>To learn how to upgrade packages, see &quot;<a href=\"https://access.redhat.com/solutions/9934\">What is yum and how do I use it?</a>&quot;</li>\n<li>The Customer Portal page for the <a href=\"https://access.redhat.com/security/\">Red Hat Security Team</a> contains more information about policies, procedures, and alerts for Red Hat Products.</li>\n<li>The Security Team also maintains a frequently updated blog at <a href=\"https://securityblog.redhat.com\">securityblog.redhat.com</a>.</li>\n</ul>\n",
			"severity": "WARN",
			"ansible": true,
			"ansible_fix": false,
			"ansible_mitigation": false,
			"rule_id": "CVE_2016_0728_kernel|KERNEL_CVE-2016-0728",
			"error_key": "KERNEL_CVE-2016-0728",
			"plugin": "CVE_2016_0728_kernel",
			"description": "Kernel key management subsystem vulnerable to local privilege escalation (CVE-2016-0728)",
			"summary": "A vulnerability in the Linux kernel allowing local privilege escalation was discovered. The issue was reported as [CVE-2016-0728](https://access.redhat.com/security/cve/cve-2016-0728).",
			"generic": "A vulnerability in the Linux kernel rated **Important** was discovered. The use-after-free flaw relates to the way the Linux kernel's key management subsystem handles keyring object reference counting in certain error paths of the join_session_keyring() function. A local, unprivileged user could use this flaw to escalate their privileges on the system. The issue was reported as [CVE-2016-0728](https://access.redhat.com/security/cve/cve-2016-0728).\n\nRed Hat recommends that you update the kernel and reboot the system. If you cannot reboot now, consider applying the [systemtap patch](https://bugzilla.redhat.com/attachment.cgi?id=1116284&action=edit) to update your running kernel.",
			"reason": "<p>A vulnerability in the Linux kernel rated <strong>Important</strong> was discovered. The use-after-free flaw relates to the way the Linux kernel&#39;s key management subsystem handles keyring object reference counting in certain error paths of the join_session_keyring() function. A local, unprivileged user could use this flaw to escalate their privileges on the system. The issue was reported as <a href=\"https://access.redhat.com/security/cve/cve-2016-0728\">CVE-2016-0728</a>.</p>\n<p>The host is vulnerable as it is running <strong>kernel-3.10.0-123.el7</strong>.</p>\n",
			"type": null,
			"more_info": "* For more information about the flaws and versions of the package that are vulnerable see [CVE-2016-0728](https://access.redhat.com/security/cve/cve-2016-0728).\n* To learn how to upgrade packages, see \"[What is yum and how do I use it?](https://access.redhat.com/solutions/9934)\"\n* The Customer Portal page for the [Red Hat Security Team](https://access.redhat.com/security/) contains more information about policies, procedures, and alerts for Red Hat Products.\n* The Security Team also maintains a frequently updated blog at [securityblog.redhat.com](https://securityblog.redhat.com).",
			"active": true,
			"node_id": "2130791",
			"category": "Security",
			"retired": false,
			"reboot_required": false,
			"publish_date": "2016-10-31T04:08:37.000Z",
			"rec_impact": 2,
			"rec_likelihood": 2,
			"resolution": "<p>Red Hat recommends that you update <code>kernel</code> and reboot. If you cannot reboot now, consider applying the <a href=\"https://bugzilla.redhat.com/attachment.cgi?id=1116284&amp;action=edit\">systemtap patch</a> to update your running kernel.</p>\n<pre><code># yum update kernel\n# reboot\n-or-\n# debuginfo-install kernel     (or equivalent)\n# stap -vgt -Gfix_p=1 -Gtrace_p=0 cve20160728e.stp\n</code></pre>"
		},
		"maintenance_actions": []
	}, {
		"details": {
			"processes_listening_int": [],
			"processes_listening_ext": [],
			"error_key": "OPENSSL_CVE_2016_0800_SPECIAL_DROWN",
			"processes_listening": [],
			"processes_names": [],
			"vulnerable_package": "openssl-libs-1.0.1e-34.el7"
		},
		"id": 709784475,
		"rule_id": "CVE_2016_0800_openssl_drown|OPENSSL_CVE_2016_0800_SPECIAL_DROWN",
		"system_id": "f31b6265939d4a8492d3ce9655dc94be",
		"account_number": "540155",
		"uuid": "d195e3c5e5e6469781c4e59fa3f5ba87",
		"date": "2017-05-25T14:01:19.000Z",
		"rule": {
			"summary_html": "<p>A new cross-protocol attack against SSLv2 protocol has been found. It has been assigned <a href=\"https://access.redhat.com/security/cve/CVE-2016-0800\">CVE-2016-0800</a> and is referred to as DROWN - Decrypting RSA using Obsolete and Weakened eNcryption. An attacker can decrypt passively collected TLS sessions between up-to-date client and server which supports SSLv2.</p>\n",
			"generic_html": "<p>A new cross-protocol attack against a vulnerability in the SSLv2 protocol has been found. It can be used to passively decrypt collected TLS/SSL sessions from any connection that used an RSA key exchange cypher suite on a server that supports SSLv2. Even if a given service does not support SSLv2 the connection is still vulnerable if another service does and shares the same RSA private key.</p>\n<p>A more efficient variant of the attack exists against unpatched OpenSSL servers using versions that predate security advisories released on March 19, 2015 (see <a href=\"https://access.redhat.com/security/cve/CVE-2015-0293\">CVE-2015-0293</a>).</p>\n",
			"more_info_html": "<ul>\n<li>For more information about the flaw see <a href=\"https://access.redhat.com/security/cve/CVE-2016-0800\">CVE-2016-0800</a></li>\n<li>To learn how to upgrade packages, see &quot;<a href=\"https://access.redhat.com/solutions/9934\">What is yum and how do I use it?</a>&quot;</li>\n<li>The Customer Portal page for the <a href=\"https://access.redhat.com/security/\">Red Hat Security Team</a> contains more information about policies, procedures, and alerts for Red Hat Products.</li>\n<li>The Security Team also maintains a frequently updated blog at <a href=\"https://securityblog.redhat.com\">securityblog.redhat.com</a>.</li>\n</ul>\n",
			"severity": "WARN",
			"ansible": true,
			"ansible_fix": false,
			"ansible_mitigation": false,
			"rule_id": "CVE_2016_0800_openssl_drown|OPENSSL_CVE_2016_0800_SPECIAL_DROWN",
			"error_key": "OPENSSL_CVE_2016_0800_SPECIAL_DROWN",
			"plugin": "CVE_2016_0800_openssl_drown",
			"description": "OpenSSL vulnerable to very efficient session decryption (CVE-2016-0800/Special DROWN)",
			"summary": "A new cross-protocol attack against SSLv2 protocol has been found. It has been assigned [CVE-2016-0800](https://access.redhat.com/security/cve/CVE-2016-0800) and is referred to as DROWN - Decrypting RSA using Obsolete and Weakened eNcryption. An attacker can decrypt passively collected TLS sessions between up-to-date client and server which supports SSLv2.",
			"generic": "A new cross-protocol attack against a vulnerability in the SSLv2 protocol has been found. It can be used to passively decrypt collected TLS/SSL sessions from any connection that used an RSA key exchange cypher suite on a server that supports SSLv2. Even if a given service does not support SSLv2 the connection is still vulnerable if another service does and shares the same RSA private key.\n\nA more efficient variant of the attack exists against unpatched OpenSSL servers using versions that predate security advisories released on March 19, 2015 (see [CVE-2015-0293](https://access.redhat.com/security/cve/CVE-2015-0293)).",
			"reason": "<p>This host is vulnerable because it has vulnerable package <strong>openssl-libs-1.0.1e-34.el7</strong> installed.</p>\n<p>This package does not have a patch for <a href=\"https://access.redhat.com/security/cve/CVE-2015-0293\">CVE-2015-0293</a> applied, which makes the system especially vulnerable. This is known as <strong>Special DROWN</strong>. An attacker can use this flaw to perform active man-in-the-middle (MITM) attacks and impersonate a TLS server to connecting TLS client in a matter of minutes. </p>\n<p>Fortunately, it does not seem to run any processes that use OpenSSL libraries.</p>\n<p>A new cross-protocol attack against a vulnerability in the SSLv2 protocol has been found. It can be used to passively decrypt collected TLS/SSL sessions from any connection that used an RSA key exchange cypher suite on a server that supports SSLv2. Even if a given service does not support SSLv2 the connection is still vulnerable if another service does and shares the same RSA private key.</p>\n<p>A more efficient variant of the attack exists against unpatched OpenSSL servers using versions that predate security advisories released on March 19, 2015 (see <a href=\"https://access.redhat.com/security/cve/CVE-2015-0293\">CVE-2015-0293</a>).</p>\n",
			"type": null,
			"more_info": "* For more information about the flaw see [CVE-2016-0800](https://access.redhat.com/security/cve/CVE-2016-0800)\n* To learn how to upgrade packages, see \"[What is yum and how do I use it?](https://access.redhat.com/solutions/9934)\"\n* The Customer Portal page for the [Red Hat Security Team](https://access.redhat.com/security/) contains more information about policies, procedures, and alerts for Red Hat Products.\n* The Security Team also maintains a frequently updated blog at [securityblog.redhat.com](https://securityblog.redhat.com).",
			"active": true,
			"node_id": "2174451",
			"category": "Security",
			"retired": false,
			"reboot_required": false,
			"publish_date": "2016-10-31T04:08:32.000Z",
			"rec_impact": 3,
			"rec_likelihood": 2,
			"resolution": "<p>Red Hat recommends that you update <code>openssl</code> and restart the affected system:</p>\n<pre><code># yum update openssl\n# reboot\n</code></pre><p>Alternatively, you can restart all affected services (that is, the ones linked to the openssl library), especially those listening on public IP addresses.</p>\n"
		},
		"maintenance_actions": []
	}, {
		"details": {
			"package": "bash-4.2.45-5.el7",
			"error_key": "VULNERABLE_BASH_DETECTED"
		},
		"id": 709784505,
		"rule_id": "bash_injection|VULNERABLE_BASH_DETECTED",
		"system_id": "f31b6265939d4a8492d3ce9655dc94be",
		"account_number": "540155",
		"uuid": "d195e3c5e5e6469781c4e59fa3f5ba87",
		"date": "2017-05-25T14:01:19.000Z",
		"rule": {
			"summary_html": "<p>In September 2014, an exploitable bug known as Shellshock was discovered in commonly shipped versions of the bash shell.</p>\n",
			"generic_html": "<p>Hosts running earlier versions of <code>bash</code> are affected by the code injection vulnerability known as <strong>Shellshock</strong>.</p>\n",
			"more_info_html": "<p>For further information about this <strong>critical</strong> vulnerability, see:</p>\n<ul>\n<li><a href=\"https://access.redhat.com/articles/1200223\">Bash Code Injection Vulnerability via Specially Crafted Environment Variables (CVE-2014-6271, CVE-2014-7169)</a></li>\n<li><a href=\"https://access.redhat.com/security/cve/CVE-2014-6271\">CVE-2014-6271</a></li>\n<li><a href=\"https://access.redhat.com/security/cve/CVE-2014-7169\">CVE-2014-7169</a></li>\n</ul>\n",
			"severity": "WARN",
			"ansible": true,
			"ansible_fix": true,
			"ansible_mitigation": false,
			"rule_id": "bash_injection|VULNERABLE_BASH_DETECTED",
			"error_key": "VULNERABLE_BASH_DETECTED",
			"plugin": "bash_injection",
			"description": "Bash locally vulnerable via environment variables (CVE-2014-6271, CVE-2014-7169/Shellshock)",
			"summary": "In September 2014, an exploitable bug known as Shellshock was discovered in commonly shipped versions of the bash shell.",
			"generic": "Hosts running earlier versions of `bash` are affected by the code injection vulnerability known as **Shellshock**.",
			"reason": "<p>This host is running a version of <code>bash</code> that is affected by the code injection vulnerability known as <strong>Shellshock</strong>.</p>\n<p>The package affected is <strong>bash-4.2.45-5.el7</strong>.</p>\n",
			"type": null,
			"more_info": "For further information about this **critical** vulnerability, see:\n* [Bash Code Injection Vulnerability via Specially Crafted Environment Variables (CVE-2014-6271, CVE-2014-7169)](https://access.redhat.com/articles/1200223)\n* [CVE-2014-6271](https://access.redhat.com/security/cve/CVE-2014-6271)\n* [CVE-2014-7169](https://access.redhat.com/security/cve/CVE-2014-7169)",
			"active": true,
			"node_id": "1200223",
			"category": "Security",
			"retired": false,
			"reboot_required": false,
			"publish_date": "2016-10-31T04:08:36.000Z",
			"rec_impact": 2,
			"rec_likelihood": 2,
			"resolution": "<p>Red Hat recommends that you upgrade <code>bash</code> immediately:</p>\n<pre><code># yum update bash\n</code></pre>"
		},
		"maintenance_actions": []
	}, {
		"details": {
			"detected_problem_log_perms": [{
				"log_perms_dirfilename": "/var/log/cron",
				"log_perms_sensitive": true,
				"log_perms_ls_line": "-rw-r--r--.  1 root root   15438 May 25 10:01 cron"
			}],
			"error_key": "HARDENING_LOGGING_3_LOG_PERMS"
		},
		"id": 709784525,
		"rule_id": "hardening_logging_log_perms|HARDENING_LOGGING_3_LOG_PERMS",
		"system_id": "f31b6265939d4a8492d3ce9655dc94be",
		"account_number": "540155",
		"uuid": "d195e3c5e5e6469781c4e59fa3f5ba87",
		"date": "2017-05-25T14:01:19.000Z",
		"rule": {
			"summary_html": "<p>Issues related to system logging and auditing were detected on your system. Important services are disabled or log file permissions are not secure.</p>\n",
			"generic_html": "<p>Issues related to system logging and auditing were detected on your system.</p>\n<p>Red Hat recommends that the logging service <code>rsyslog</code> and the auditing service <code>auditd</code> are enabled and that log files in <code>/var/log</code> have secure permissions.</p>\n",
			"more_info_html": "<ul>\n<li><a href=\"https://access.redhat.com/solutions/1491573\">Why is <code>/var/log/cron</code> world readable in RHEL7?</a></li>\n<li><a href=\"https://access.redhat.com/documentation/en-US/Red_Hat_Enterprise_Linux/6/html/Deployment_Guide/s2-services-chkconfig.html\">Using the chkconfig Utility</a> to configure services on RHEL 6</li>\n<li><a href=\"https://access.redhat.com/documentation/en-US/Red_Hat_Enterprise_Linux/7/html/System_Administrators_Guide/sect-Managing_Services_with_systemd-Services.html\">Managing System Services</a> to configure services on RHEL 7</li>\n<li>The Customer Portal page for the <a href=\"https://access.redhat.com/security/\">Red Hat Security Team</a> contains more information about policies, procedures, and alerts for Red Hat products.</li>\n<li>The Security Team also maintains a frequently updated blog at <a href=\"https://securityblog.redhat.com\">securityblog.redhat.com</a>.</li>\n</ul>\n",
			"severity": "INFO",
			"ansible": false,
			"ansible_fix": false,
			"ansible_mitigation": false,
			"rule_id": "hardening_logging_log_perms|HARDENING_LOGGING_3_LOG_PERMS",
			"error_key": "HARDENING_LOGGING_3_LOG_PERMS",
			"plugin": "hardening_logging_log_perms",
			"description": "Decreased security in system logging permissions",
			"summary": "Issues related to system logging and auditing were detected on your system. Important services are disabled or log file permissions are not secure.\n",
			"generic": "Issues related to system logging and auditing were detected on your system.\n\nRed Hat recommends that the logging service `rsyslog` and the auditing service `auditd` are enabled and that log files in `/var/log` have secure permissions.\n",
			"reason": "<p>Log files have permission issues.</p>\n<p>The following files or directories in <code>/var/log</code> have file permissions that differ from the default RHEL configuration and are possibly non-secure. Red Hat recommends that the file permissions be adjusted to more secure settings.</p>\n<table border=\"1\" align=\"left\">\n  <tr>\n    <th style=\"text-align:center;\">File or directory name</th>\n    <th style=\"text-align:center;\">Detected problem</th>\n    <th style=\"text-align:center;\">Output from <code>ls -l</code></th>\n  </tr>\n\n<tr>\n\n<td><code>/var/log/cron</code></td><td>Users other than <code>root</code> can read or write.</td><td><code>-rw-r--r--.  1 root root   15438 May 25 10:01 cron</code></td>\n\n</td>\n\n</table>\n\n\n\n",
			"type": null,
			"more_info": "* [Why is `/var/log/cron` world readable in RHEL7?](https://access.redhat.com/solutions/1491573)\n* [Using the chkconfig Utility](https://access.redhat.com/documentation/en-US/Red_Hat_Enterprise_Linux/6/html/Deployment_Guide/s2-services-chkconfig.html) to configure services on RHEL 6\n* [Managing System Services](https://access.redhat.com/documentation/en-US/Red_Hat_Enterprise_Linux/7/html/System_Administrators_Guide/sect-Managing_Services_with_systemd-Services.html) to configure services on RHEL 7\n* The Customer Portal page for the [Red Hat Security Team](https://access.redhat.com/security/) contains more information about policies, procedures, and alerts for Red Hat products.\n* The Security Team also maintains a frequently updated blog at [securityblog.redhat.com](https://securityblog.redhat.com).\n",
			"active": true,
			"node_id": null,
			"category": "Security",
			"retired": false,
			"reboot_required": false,
			"publish_date": "2017-05-16T04:08:34.000Z",
			"rec_impact": 1,
			"rec_likelihood": 1,
			"resolution": "<p>Red Hat recommends that you perform the following adjustments:</p>\n<p>Fixing permission issues depends on whether there is a designated safe group on your system that has Read access to the log files. This situation might exist if you want to allow certain administrators to see the log files without becoming <code>root</code>. To prevent log tampering, no other user than <code>root</code> should have permissions to Write to the log files. (The <code>btmp</code> and <code>wtmp</code> files are owned by the <code>utmp</code> group but other users should still be unable to write to them.)</p>\n<p><strong>Fix for a default RHEL configuration</strong></p>\n<p>(No designated group for reading log files)</p>\n<pre><code>chown root:root /var/log/cron\nchmod u=rw,g-x,o-rwx /var/log/cron\n</code></pre><p><strong>Fix for a configuration with a designated safe group for reading log files</strong></p>\n<p>In the following lines, substitute the name of your designated safe group for the string <code>safegroup</code>:</p>\n<pre><code>chown root:safegroup /var/log/cron\nchmod u=rw,g-x,o-rwx /var/log/cron\n</code></pre>"
		},
		"maintenance_actions": []
	}, {
		"details": {
			"filesystems": [{
				"usage": "99",
				"mountpoint": "/"
			}, {
				"usage": "99",
				"mountpoint": "/"
			}],
			"error_key": "FILESYSTEM_CAPACITY"
		},
		"id": 709784535,
		"rule_id": "filesystem_capacity|FILESYSTEM_CAPACITY",
		"system_id": "f31b6265939d4a8492d3ce9655dc94be",
		"account_number": "540155",
		"uuid": "d195e3c5e5e6469781c4e59fa3f5ba87",
		"date": "2017-05-25T14:01:19.000Z",
		"rule": {
			"summary_html": "<p>File systems nearing full capacity can cause performance issues because blocks must be used from different block groups. \nBesides, file systems at or exceeding capacity will have stability issues because applications will no longer be able to write to the file system.</p>\n",
			"generic_html": "<p>File systems nearing full capacity can cause performance issues because blocks must be used from different block groups. \nBesides, file systems at or exceeding capacity will have stability issues because applications will no longer be able to write to the file system.</p>\n",
			"more_info_html": "<p><a href=\"https://access.redhat.com/solutions/21820\">How to increase the filesystem size?</a>\n<a href=\"https://access.redhat.com/solutions/1154683\">How do I find out what is using disk space?</a></p>\n",
			"severity": "WARN",
			"ansible": false,
			"ansible_fix": false,
			"ansible_mitigation": false,
			"rule_id": "filesystem_capacity|FILESYSTEM_CAPACITY",
			"error_key": "FILESYSTEM_CAPACITY",
			"plugin": "filesystem_capacity",
			"description": "Decreased stability and/or performance due to filesystem over 95% capacity",
			"summary": "File systems nearing full capacity can cause performance issues because blocks must be used from different block groups. \nBesides, file systems at or exceeding capacity will have stability issues because applications will no longer be able to write to the file system.\n",
			"generic": "File systems nearing full capacity can cause performance issues because blocks must be used from different block groups. \nBesides, file systems at or exceeding capacity will have stability issues because applications will no longer be able to write to the file system.\n",
			"reason": "<p>This host has the following file systems nearing or at capacity:</p>\n<ul>\n\n<li><strong>Filesystem:</strong> / <strong>Usage:</strong> 99%</li>\n\n<li><strong>Filesystem:</strong> / <strong>Usage:</strong> 99%</li>\n\n</ul>",
			"type": null,
			"more_info": "[How to increase the filesystem size?](https://access.redhat.com/solutions/21820)\n[How do I find out what is using disk space?](https://access.redhat.com/solutions/1154683)\n",
			"active": true,
			"node_id": "1154683",
			"category": "Stability",
			"retired": false,
			"reboot_required": false,
			"publish_date": "2016-10-31T04:08:36.000Z",
			"rec_impact": 2,
			"rec_likelihood": 3,
			"resolution": "<p>To solve the issue, Red Hat recommends that you either add more storage capacity to the identified file systems, or remove unnecessary files to reduce the current usage.\nPlease refer to more_information part for more detailed steps.</p>\n"
		},
		"maintenance_actions": []
	}, {
		"details": {
			"msg": "[    0.000000] crashkernel=auto resulted in zero bytes of reserved memory.",
			"auto_with_low_ram": true,
			"rhel_ver": 7,
			"error_key": "CRASHKERNEL_RESERVATION_FAILED"
		},
		"id": 709784555,
		"rule_id": "crashkernel_reservation_failed|CRASHKERNEL_RESERVATION_FAILED",
		"system_id": "f31b6265939d4a8492d3ce9655dc94be",
		"account_number": "540155",
		"uuid": "d195e3c5e5e6469781c4e59fa3f5ba87",
		"date": "2017-05-25T14:01:19.000Z",
		"rule": {
			"summary_html": "<p>The crashkernel configuration has failed to produce a working kdump environment. Configuration changes must be made to enable vmcore capture.</p>\n",
			"generic_html": "<p>Kdump is unable to reserve memory for the kdump kernel. The kdump service has not started and a vmcore will not be captured if the host crashes, which will make it difficult for our support technicians to determine why the machine crashed.</p>\n",
			"more_info_html": "",
			"severity": "WARN",
			"ansible": false,
			"ansible_fix": false,
			"ansible_mitigation": false,
			"rule_id": "crashkernel_reservation_failed|CRASHKERNEL_RESERVATION_FAILED",
			"error_key": "CRASHKERNEL_RESERVATION_FAILED",
			"plugin": "crashkernel_reservation_failed",
			"description": "Kdump crashkernel reservation failed due to improper configuration of crashkernel parameter",
			"summary": "The crashkernel configuration has failed to produce a working kdump environment. Configuration changes must be made to enable vmcore capture.\n",
			"generic": "Kdump is unable to reserve memory for the kdump kernel. The kdump service has not started and a vmcore will not be captured if the host crashes, which will make it difficult for our support technicians to determine why the machine crashed.",
			"reason": "<p>This host is unable to reserve memory for the kdump kernel:</p>\n<pre><code>[    0.000000] crashkernel=auto resulted in zero bytes of reserved memory.\n</code></pre><p>This means the kdump service has not started and a vmcore will not be captured if the host crashes, which will make it difficult for our support technicians to determine why the machine crashed.</p>\n",
			"type": null,
			"more_info": null,
			"active": true,
			"node_id": "59432",
			"category": "Stability",
			"retired": false,
			"reboot_required": false,
			"publish_date": "2016-10-31T04:08:33.000Z",
			"rec_impact": 1,
			"rec_likelihood": 3,
			"resolution": "<p>To fix this issue, Red Hat recommends that you change the <strong>crashkernel</strong> setting in the <em>grub.conf</em> file.</p>\n<p>This host failed to reserved memory with <strong>auto</strong> crashkernel parameter due to low physical memory. The memory must be reserved by explicitly requesting the reservation size, for example: crashkernel=128M.</p>\n<p>For details of <code>crashkernel</code> setting, please refer to the Knowledge article <a href=\"https://access.redhat.com/solutions/916043\">How should the crashkernel parameter be configured for using kdump on RHEL7? </a> to pickup the setting specifically for your host.</p>\n"
		},
		"maintenance_actions": []
	}, {
		"details": {
			"error_key": "TZDATA_NEED_UPGRADE_INFO_NEED_MANUAL_ACTION"
		},
		"id": 709784565,
		"rule_id": "tzdata_need_upgrade|TZDATA_NEED_UPGRADE_INFO_NEED_MANUAL_ACTION",
		"system_id": "f31b6265939d4a8492d3ce9655dc94be",
		"account_number": "540155",
		"uuid": "d195e3c5e5e6469781c4e59fa3f5ba87",
		"date": "2017-05-25T14:01:19.000Z",
		"rule": {
			"summary_html": "<p>System clock inaccurate when a leap second event happens in a non-NTP system without following the TAI timescale.</p>\n",
			"generic_html": "<p>System clock inaccurate when a leap second event happens in a non-NTP system without following the TAI timescale.</p>\n",
			"more_info_html": "",
			"severity": "INFO",
			"ansible": false,
			"ansible_fix": false,
			"ansible_mitigation": false,
			"rule_id": "tzdata_need_upgrade|TZDATA_NEED_UPGRADE_INFO_NEED_MANUAL_ACTION",
			"error_key": "TZDATA_NEED_UPGRADE_INFO_NEED_MANUAL_ACTION",
			"plugin": "tzdata_need_upgrade",
			"description": "System clock inaccurate when a leap second event happens in a non-NTP system without following the TAI timescale",
			"summary": "System clock inaccurate when a leap second event happens in a non-NTP system without following the TAI timescale.\n",
			"generic": "System clock inaccurate when a leap second event happens in a non-NTP system without following the TAI timescale.\n",
			"reason": "<p>This system running as a non-NTP system is following the <strong>UTC timescale</strong>. In this situation, manual correction is required to avoid system clock inaccuracy when a leap second event happens.</p>\n",
			"type": null,
			"more_info": null,
			"active": true,
			"node_id": "1465713",
			"category": "Stability",
			"retired": false,
			"reboot_required": false,
			"publish_date": null,
			"rec_impact": 2,
			"rec_likelihood": 1,
			"resolution": "<p>The system clock of this system needs manual correction when a leap second event happens. For example:</p>\n<pre>\n<code>\n# date -s \"20170101 HH:MM:SS\"\n</code>\n</pre>\n\n<p>You need to replace &quot;HH:MM:SS&quot; with the accurate time after the leap second occurs.</p>\n"
		},
		"maintenance_actions": []
	}, {
		"details": {
			"selinux_info": true,
			"package_name": "kernel",
			"selinux_enforcing": true,
			"selinux_can_help": true,
			"minimal_selinux_policy": "selinux-policy-3.13.1-81.el7",
			"selinux_enabled": true,
			"vulnerable_kernel": "3.10.0-123.el7",
			"active_policy": "selinux-policy-3.12.1-153.el7",
			"dccp_loading_disabled": null,
			"error_key": "KERNEL_CVE_2017_6074",
			"enough_policy": false,
			"dccp_loaded": null,
			"mitigation_info": false
		},
		"id": 709784575,
		"rule_id": "CVE_2017_6074_kernel|KERNEL_CVE_2017_6074",
		"system_id": "f31b6265939d4a8492d3ce9655dc94be",
		"account_number": "540155",
		"uuid": "d195e3c5e5e6469781c4e59fa3f5ba87",
		"date": "2017-05-25T14:01:19.000Z",
		"rule": {
			"summary_html": "<p>A use-after-free flaw was found in the Linux kernel IPv6 DCCP network protocol code. It has been assigned <a href=\"https://access.redhat.com/security/cve/CVE-2017-6074\">CVE-2017-6074</a>. An unprivileged local user could use this flaw to execute arbitrary code in kernel memory and increase their privileges on the system.</p>\n",
			"generic_html": "<p>A use-after-free flaw was found in the Linux kernel IPv6 DCCP network protocol code. It has been assigned CVE-2017-6074. </p>\n<p>An unprivileged local user could use this flaw to execute arbitrary code in kernel memory and increase their privileges on the system. A local user could initiate a DCCP network connection on any local system network interface and then create specially-crafted memory allocations containing malicious instructions that can then either cause a crash or potentially escalate the user&#39;s privileges.</p>\n<p>An attacker must have access to a local account on the system; this is not a remote attack and it requires IPv6 support to be enabled on the system.</p>\n<p>Red Hat recommends that you update the kernel when possible. Otherwise, you can use proposed mitigation to disable DCCP. SELinux in enforcing mode can also mitigate the issue under specific circumstances.</p>\n",
			"more_info_html": "<ul>\n<li>For more information about the flaw, see <a href=\"https://access.redhat.com/security/cve/CVE-2017-6074\">CVE-2017-6074</a>.</li>\n<li>To learn how to upgrade packages, see <a href=\"https://access.redhat.com/solutions/9934\">What is yum and how do I use it?</a>.</li>\n<li>For more information about SELinux, see <a href=\"https://access.redhat.com/documentation/en-US/Red_Hat_Enterprise_Linux/7/html/SELinux_Users_and_Administrators_Guide/chap-Security-Enhanced_Linux-Introduction.html#sect-Security-Enhanced_Linux-Introduction-Benefits_of_running_SELinux\">Benefits of running SELinux</a>.</li>\n<li>The Customer Portal page for the <a href=\"https://access.redhat.com/security/\">Red Hat Security Team</a> contains more information about policies, procedures, and alerts for Red Hat products.</li>\n<li>The Security Team also maintains a frequently updated blog at <a href=\"https://securityblog.redhat.com\">securityblog.redhat.com</a>.</li>\n</ul>\n",
			"severity": "WARN",
			"ansible": true,
			"ansible_fix": false,
			"ansible_mitigation": false,
			"rule_id": "CVE_2017_6074_kernel|KERNEL_CVE_2017_6074",
			"error_key": "KERNEL_CVE_2017_6074",
			"plugin": "CVE_2017_6074_kernel",
			"description": "Kernel vulnerable to local privilege escalation via DCCP module (CVE-2017-6074)",
			"summary": "A use-after-free flaw was found in the Linux kernel IPv6 DCCP network protocol code. It has been assigned [CVE-2017-6074](https://access.redhat.com/security/cve/CVE-2017-6074). An unprivileged local user could use this flaw to execute arbitrary code in kernel memory and increase their privileges on the system.\n",
			"generic": "A use-after-free flaw was found in the Linux kernel IPv6 DCCP network protocol code. It has been assigned CVE-2017-6074. \n\nAn unprivileged local user could use this flaw to execute arbitrary code in kernel memory and increase their privileges on the system. A local user could initiate a DCCP network connection on any local system network interface and then create specially-crafted memory allocations containing malicious instructions that can then either cause a crash or potentially escalate the user's privileges.\n\nAn attacker must have access to a local account on the system; this is not a remote attack and it requires IPv6 support to be enabled on the system.\n\nRed Hat recommends that you update the kernel when possible. Otherwise, you can use proposed mitigation to disable DCCP. SELinux in enforcing mode can also mitigate the issue under specific circumstances.\n",
			"reason": "<p>A use-after-free flaw was found within the Linux kernel IPv6 DCCP network protocol code.</p>\n<p>This host is affected because:</p>\n<ul><li> It is running kernel <strong>3.10.0-123.el7</strong>.</li><li> SELinux policy is outdated.</li></ul>\n\n\n\n\n\n\n<p>Your installed SELinux policy is <strong>selinux-policy-3.12.1-153.el7</strong>; however, to mitigate the issue, the earliest required version is <strong>selinux-policy-3.13.1-81.el7</strong>.</p>\n",
			"type": null,
			"more_info": "* For more information about the flaw, see [CVE-2017-6074](https://access.redhat.com/security/cve/CVE-2017-6074).\n* To learn how to upgrade packages, see [What is yum and how do I use it?](https://access.redhat.com/solutions/9934).\n* For more information about SELinux, see [Benefits of running SELinux](https://access.redhat.com/documentation/en-US/Red_Hat_Enterprise_Linux/7/html/SELinux_Users_and_Administrators_Guide/chap-Security-Enhanced_Linux-Introduction.html#sect-Security-Enhanced_Linux-Introduction-Benefits_of_running_SELinux).\n* The Customer Portal page for the [Red Hat Security Team](https://access.redhat.com/security/) contains more information about policies, procedures, and alerts for Red Hat products.\n* The Security Team also maintains a frequently updated blog at [securityblog.redhat.com](https://securityblog.redhat.com).\n",
			"active": true,
			"node_id": null,
			"category": "Security",
			"retired": false,
			"reboot_required": false,
			"publish_date": null,
			"rec_impact": 2,
			"rec_likelihood": 2,
			"resolution": "<p>Red Hat recommends updating the <code>kernel</code> package and rebooting the system.</p>\n<pre><code># yum update kernel\n# reboot\n</code></pre><p><strong>Alternatively</strong>, apply one of the following mitigations:</p>\n<h5 id=\"update-selinux-policy\">Update SELinux policy</h5>\n<p>Update your SELinux policy:</p>\n<pre><code># yum update selinux-policy\n</code></pre><p>The system does not provide enough information for Insights about loaded kernel modules. It is not possible to recommend a mitigation based on kernel modules.</p>\n"
		},
		"maintenance_actions": []
	}
]
